/*
 * Decompiled with CFR 0.152.
 */
package com.r2pmml;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.sun.istack.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.logging.LogManager;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitable;
import org.jpmml.converter.Application;
import org.jpmml.converter.VersionConverter;
import org.jpmml.model.MarkupException;
import org.jpmml.model.PMMLOutputStream;
import org.jpmml.model.metro.MetroJAXBSerializer;
import org.jpmml.model.visitors.VersionChecker;
import org.jpmml.model.visitors.VersionDowngrader;
import org.jpmml.model.visitors.VersionStandardizer;
import org.jpmml.rexp.Converter;
import org.jpmml.rexp.ConverterFactory;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpParser;

public class Main
extends Application {
    @Parameter(names={"--model-rds-input", "--rds-input"}, required=true, order=1)
    private File inputFile = null;
    @Parameter(names={"--pmml-output"}, required=true, order=2)
    private File outputFile = null;
    @Parameter(names={"--converter"}, description="Converter class", order=3)
    private String converter = null;
    @Parameter(names={"--pmml-schema", "--schema"}, converter=VersionConverter.class, order=4)
    private Version version = null;
    private static final Logger logger;

    public static void main(String ... args) throws Exception {
        Main application = new Main();
        JCommander commander = JCommander.newBuilder().addObject((Object)application).build();
        commander.parse(args);
        try {
            Application.setInstance((Application)application);
            application.run();
        }
        finally {
            Application.setInstance(null);
        }
    }

    public void run() throws Exception {
        File absoluteOutputFile;
        File outputDir;
        Converter converter;
        RExp rexp;
        try (FileInputStream is = new FileInputStream(this.inputFile);){
            RExpParser parser = new RExpParser((InputStream)is);
            rexp = parser.parse();
        }
        ConverterFactory converterFactory = ConverterFactory.newInstance();
        if (this.converter != null) {
            Class<?> clazz = Class.forName(this.converter);
            converter = converterFactory.newConverter(clazz, rexp);
        } else {
            converter = converterFactory.newConverter(rexp);
        }
        PMML pmml = converter.encodePMML();
        if (!this.outputFile.exists() && !(outputDir = (absoluteOutputFile = this.outputFile.getAbsoluteFile()).getParentFile()).exists()) {
            outputDir.mkdirs();
        }
        if (this.version != null && this.version.compareTo((Enum)Version.XPMML) < 0) {
            VersionStandardizer versionStandardizer = new VersionStandardizer();
            versionStandardizer.applyTo((Visitable)pmml);
            VersionDowngrader versionDowngrader = new VersionDowngrader(this.version);
            versionDowngrader.applyTo((Visitable)pmml);
            VersionChecker versionChecker = new VersionChecker(this.version);
            versionChecker.applyTo((Visitable)pmml);
            List exceptions = versionChecker.getExceptions();
            if (!exceptions.isEmpty()) {
                logger.severe("The PMML object has " + exceptions.size() + " incompatibilities with the requested PMML schema version:");
                LinkedHashMultiset groupedMessages = LinkedHashMultiset.create();
                for (MarkupException exception : exceptions) {
                    groupedMessages.add((Object)exception.getMessage());
                }
                Set entries = groupedMessages.entrySet();
                for (Multiset.Entry entry : entries) {
                    logger.warning((String)entry.getElement() + (String)(entry.getCount() > 1 ? " (" + entry.getCount() + " cases)" : ""));
                }
            }
            MetroJAXBSerializer jaxbSerializer = new MetroJAXBSerializer();
            try (PMMLOutputStream os = new PMMLOutputStream((OutputStream)new FileOutputStream(this.outputFile), this.version);){
                jaxbSerializer.serializePretty((PMMLObject)pmml, (OutputStream)os);
            }
        }
        MetroJAXBSerializer jaxbSerializer = new MetroJAXBSerializer();
        try (FileOutputStream os = new FileOutputStream(this.outputFile);){
            jaxbSerializer.serializePretty((PMMLObject)pmml, (OutputStream)os);
        }
    }

    static {
        LogManager logManager = LogManager.getLogManager();
        try {
            logManager.readConfiguration(Main.class.getResourceAsStream("/logging.properties"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
        logger = Logger.getLogger(Main.class);
    }
}

