/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.likelihood;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.stats.likelihood.Likelihood;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;

public final class DiffuseLikelihood
implements Likelihood {
    private final double ll;
    private final double ssqerr;
    private final double ldet;
    private final double dcorr;
    private final int nobs;
    private final int nd;
    private final double[] res;
    private final boolean legacy;
    private final boolean scalingFactor;

    public static Builder builder(int n, int nd) {
        return new Builder(n, nd);
    }

    private DiffuseLikelihood(boolean concentrated, int n, int nd, double ssqerr, double ldet, double lddet, double[] res, boolean legacy) {
        int m;
        this.scalingFactor = concentrated;
        this.nobs = n;
        this.nd = nd;
        this.ssqerr = ssqerr;
        this.ldet = ldet;
        this.dcorr = lddet;
        this.res = res;
        this.legacy = legacy;
        int n2 = m = legacy ? this.nobs : this.nobs - nd;
        this.ll = m > 0 ? (this.scalingFactor ? -0.5 * ((double)m * Constants.LOGTWOPI + (double)m * (1.0 + Math.log(ssqerr / (double)m)) + ldet + lddet) : -0.5 * ((double)m * Constants.LOGTWOPI + ssqerr + ldet + lddet)) : Double.NaN;
    }

    private int m() {
        return this.legacy ? this.nobs : this.nobs - this.nd;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public DiffuseLikelihood setLegacy(boolean legacy) {
        if (this.legacy == legacy) {
            return this;
        }
        return new DiffuseLikelihood(this.scalingFactor, this.nobs, this.nd, this.ssqerr, this.ldet, this.dcorr, this.res, legacy);
    }

    public int getD() {
        return this.nd;
    }

    @Override
    public double factor() {
        return Math.exp((this.ldet + this.dcorr) / (double)this.m());
    }

    @Override
    public double logLikelihood() {
        return this.ll;
    }

    @Override
    public int dim() {
        return this.nobs;
    }

    @Override
    public DoubleSeq e() {
        return this.res == null ? null : DoubleSeq.of((double[])this.res);
    }

    @Override
    public DoubleSeq deviances() {
        double f = this.factor();
        DoubleSeq e = this.e().select(x -> Double.isFinite(x));
        if (f == 1.0) {
            return e;
        }
        double sf = Math.sqrt(f);
        return e.map(x -> x * sf);
    }

    @Override
    public double logDeterminant() {
        return this.ldet;
    }

    @Override
    public double ser() {
        return Math.sqrt(this.ssqerr / (double)this.m());
    }

    @Override
    public double sigma2() {
        return this.ssqerr / (double)this.m();
    }

    @Override
    public double ssq() {
        return this.ssqerr;
    }

    public DiffuseLikelihood rescale(double factor) {
        if (factor == 1.0) {
            return this;
        }
        double[] nres = null;
        if (this.res != null) {
            nres = new double[this.res.length];
            for (int i = 0; i < this.res.length; ++i) {
                nres[i] = Double.isFinite(this.res[i]) ? this.res[i] / factor : Double.NaN;
            }
        }
        return new DiffuseLikelihood(this.scalingFactor, this.nobs, this.nd, this.ssqerr / (factor * factor), this.ldet, this.dcorr, nres, this.legacy);
    }

    public double getDiffuseCorrection() {
        return this.dcorr;
    }

    public DiffuseLikelihood add(Likelihood ll) {
        return DiffuseLikelihood.builder(this.nobs + ll.dim(), this.nd).ssqErr(this.ssqerr + ll.ssq()).logDeterminant(this.ldet + ll.logDeterminant()).diffuseCorrection(this.dcorr).legacy(this.legacy).concentratedScalingFactor(this.scalingFactor).residuals(ll.e()).build();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ll=").append(this.logLikelihood()).append(System.lineSeparator());
        builder.append("n=").append(this.dim()).append(System.lineSeparator());
        builder.append("ssq=").append(this.ssq()).append(System.lineSeparator());
        builder.append("ldet=").append(this.logDeterminant()).append(System.lineSeparator());
        builder.append("dcorr=").append(this.getDiffuseCorrection()).append(System.lineSeparator());
        return builder.toString();
    }

    public LikelihoodStatistics stats(double llcorrection, int nparams) {
        return LikelihoodStatistics.statistics(this.logLikelihood(), this.dim()).llAdjustment(llcorrection).parametersCount(this.scalingFactor ? nparams + 1 : nparams).diffuseOrder(this.nd).ssq(this.ssq()).build();
    }

    public static class Builder {
        private final int n;
        private final int nd;
        private double ssqerr;
        private double ldet;
        private double dcorr;
        private double[] res;
        private boolean legacy;
        private boolean concentratedScalingFactor = true;

        Builder(int n, int nd) {
            this.n = n;
            this.nd = nd;
        }

        public Builder logDeterminant(double ldet) {
            this.ldet = ldet;
            return this;
        }

        public Builder diffuseCorrection(double dcorr) {
            this.dcorr = dcorr;
            return this;
        }

        public Builder ssqErr(double ssq) {
            this.ssqerr = ssq;
            return this;
        }

        public Builder legacy(boolean legacy) {
            this.legacy = legacy;
            return this;
        }

        public Builder concentratedScalingFactor(boolean concentrated) {
            this.concentratedScalingFactor = concentrated;
            return this;
        }

        public Builder residuals(DoubleSeq residuals) {
            if (residuals == null) {
                return this;
            }
            if (this.ssqerr == 0.0) {
                this.ssqerr = residuals.ssqWithMissing();
            }
            this.res = residuals.toArray();
            return this;
        }

        public DiffuseLikelihood build() {
            if (this.nd == 0 && this.dcorr != 0.0) {
                throw new IllegalArgumentException("Incorrect diffuse initialisation");
            }
            return new DiffuseLikelihood(this.concentratedScalingFactor, this.n, this.nd, this.ssqerr, this.ldet, this.dcorr, this.res, this.legacy);
        }
    }
}

