/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.core.math.linearfilters.Filtering;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.ISymmetricFiltering;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;

public class SymmetricFiltering
implements ISymmetricFiltering {
    private final SymmetricFilter cf;
    private final IFiniteFilter[] ff;

    public SymmetricFiltering(SymmetricFilter cf, IFiniteFilter[] endPoints) {
        this.cf = cf;
        this.ff = (IFiniteFilter[])endPoints.clone();
    }

    @Override
    public SymmetricFilter centralFilter() {
        return this.cf;
    }

    @Override
    public IFiniteFilter[] endPointsFilters() {
        return this.ff;
    }

    public static SymmetricFiltering of(DoubleSeq cf, Matrix rf) {
        int l = rf.getColumnsCount();
        if (cf.length() != 2 * l + 1) {
            throw new IllegalArgumentException();
        }
        SymmetricFilter fcf = SymmetricFilter.of(cf);
        IFiniteFilter[] frf = Filtering.rightFilters(rf);
        return new SymmetricFiltering(fcf, frf);
    }
}

