/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.arima;

import jdplus.toolkit.base.core.arima.ArimaException;
import jdplus.toolkit.base.core.arima.AutoCovarianceFunction;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearsystem.LinearSystemSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.polynomials.RationalFunction;

public class AutoCovarianceComputers {
    public static AutoCovarianceFunction.Computer defaultComputer(LinearSystemSolver solver) {
        return (ma, ar, rank) -> {
            int j;
            int i;
            int q;
            int p = ar.degree();
            int r0 = Math.max(p, q = ma.degree()) + 1;
            if (rank < r0) {
                rank = r0;
            }
            double[] c = new double[rank + 1];
            RationalFunction rfe = RationalFunction.of(ma, ar);
            double[] cr = rfe.coefficients(q + 1);
            FastMatrix M = FastMatrix.square(r0);
            DataBlock x = DataBlock.of(c, 0, r0);
            for (i = 0; i <= q; ++i) {
                double s = 0.0;
                for (j = i; j <= q; ++j) {
                    s += ma.get(j) * cr[j - i];
                }
                x.set(i, s);
            }
            for (i = 0; i < r0; ++i) {
                for (int j2 = 0; j2 <= p; ++j2) {
                    double w = ar.get(j2);
                    if (w == 0.0) continue;
                    M.add(i, i < j2 ? j2 - i : i - j2, w);
                }
            }
            try {
                if (solver == null) {
                    LinearSystemSolver.robustSolver().solve(M, x);
                } else {
                    solver.solve(M, x);
                }
            }
            catch (MatrixException err) {
                throw new ArimaException("acgf of non stationary model");
            }
            for (int r = r0; r <= rank; ++r) {
                double s = 0.0;
                for (j = 1; j <= p; ++j) {
                    s += ar.get(j) * c[r - j];
                }
                c[r] = -s;
            }
            return c;
        };
    }

    public static AutoCovarianceFunction.SymmetricComputer defaultSymmetricComputer(LinearSystemSolver solver) {
        return (sma, ar, rank) -> {
            double[] tmp;
            double[] c;
            int q;
            int p = ar.degree();
            int r0 = Math.max(p, q = sma.getUpperBound()) + 1;
            if (rank < r0) {
                rank = r0;
            }
            if (p == 0) {
                c = sma.coefficientsAsPolynomial().toArray();
            } else {
                c = new double[rank + 1];
                BackFilter g = sma.decompose(new BackFilter(ar));
                tmp = RationalFunction.of(g.asPolynomial(), ar).coefficients(rank + 1);
                System.arraycopy(tmp, 0, c, 0, tmp.length);
                c[0] = c[0] * 2.0;
            }
            if (rank < c.length) {
                return c;
            }
            int k0 = c.length;
            tmp = new double[rank];
            System.arraycopy(c, 0, tmp, 0, k0);
            c = tmp;
            if (p > 0) {
                for (int r = k0; r < rank; ++r) {
                    double s = 0.0;
                    for (int x = 1; x <= p; ++x) {
                        s += ar.get(x) * c[r - x];
                    }
                    c[r] = -s;
                }
            }
            return c;
        };
    }
}

