/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.gmwcs.solver;

import ilog.concert.IloException;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.cplex.IloCplex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ru.itmo.ctlab.virgo.gmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.gmwcs.graph.Elem;
import ru.itmo.ctlab.virgo.gmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.gmwcs.graph.Node;
import ru.itmo.ctlab.virgo.gmwcs.solver.CutGenerator;

public class Separator
extends IloCplex.UserCutCallback {
    public static final double ADDITION_CAPACITY = 1.0E-6;
    public static final double STEP = 0.1;
    public static final double EPS = 1.0E-5;
    private final IloCplex cplex;
    private Map<Node, CutGenerator> generators;
    private int maxToAdd;
    private int minToConsider;
    private List<Node> nodes;
    private List<CutGenerator> generatorList;
    private Map<Node, IloNumVar> y;
    private Map<Edge, IloNumVar> w;
    private int waited;
    private double period;
    private Graph graph;
    private boolean inited;
    private Map<Elem, Integer> indices;
    private IloNumVar[] vars;

    public Separator(Map<Node, IloNumVar> y, Map<Edge, IloNumVar> w, IloCplex cplex, Graph graph) {
        this.y = y;
        this.w = w;
        this.generators = new HashMap<Node, CutGenerator>();
        this.generatorList = new ArrayList<CutGenerator>();
        this.nodes = new ArrayList<Node>();
        this.maxToAdd = Integer.MAX_VALUE;
        this.minToConsider = Integer.MAX_VALUE;
        this.cplex = cplex;
        this.graph = graph;
    }

    public void setMaxToAdd(int n) {
        this.maxToAdd = n;
    }

    public void setMinToConsider(int n) {
        this.minToConsider = n;
    }

    private synchronized boolean isCutsAllowed() {
        ++this.waited;
        if ((double)this.waited > this.period) {
            this.waited = 0;
            this.period += 0.1;
            return true;
        }
        return false;
    }

    public Separator clone() {
        Separator result = new Separator(this.y, this.w, this.cplex, this.graph);
        for (CutGenerator generator : this.generatorList) {
            result.addComponent(this.graph.subgraph(generator.getNodes()), generator.getRoot());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void main() throws IloException {
        if (!this.isCutsAllowed()) {
            return;
        }
        this.initWeights();
        Collections.shuffle(this.nodes);
        List<Node> now = this.nodes.subList(0, Math.min(this.nodes.size(), this.minToConsider));
        int added = 0;
        for (Node node : now) {
            CutGenerator generator = this.generators.get(node);
            List<Edge> cut = generator.findCut(node);
            if (cut != null) {
                HashSet<Edge> minCut = new HashSet<Edge>();
                minCut.addAll(cut);
                IloCplex iloCplex = this.cplex;
                synchronized (iloCplex) {
                    IloNumVar[] evars = (IloNumVar[])minCut.stream().map(x -> this.w.get(x)).toArray(IloNumVar[]::new);
                    this.add(this.cplex.le(this.cplex.diff((IloNumExpr)this.y.get(node), this.cplex.sum((IloNumExpr[])evars)), 0.0), 1);
                }
                ++added;
            }
            if (added != this.maxToAdd) continue;
            break;
        }
    }

    private void initWeights() throws IloException {
        if (!this.inited) {
            this.init();
        }
        double[] values2 = this.getValues(this.vars);
        for (CutGenerator generator : this.generatorList) {
            HashSet<Edge> visited = new HashSet<Edge>();
            for (Edge edge : generator.getEdges()) {
                if (visited.contains(edge)) continue;
                double weight2 = 0.0;
                for (Edge e : this.graph.getAllEdges(this.graph.getEdgeSource(edge), this.graph.getEdgeTarget(edge))) {
                    weight2 += values2[this.indices.get(e)];
                    visited.add(e);
                }
                generator.setCapacity(edge, weight2 + 1.0E-6);
            }
            for (Node node : generator.getNodes()) {
                generator.setVertexCapacity(node, values2[this.indices.get(node)] - 1.0E-5);
            }
        }
    }

    private void init() {
        this.inited = true;
        this.indices = new HashMap<Elem, Integer>();
        int i = 0;
        this.vars = new IloNumVar[this.w.size() + this.y.size()];
        for (Edge e : this.graph.edgeSet()) {
            this.vars[i] = this.w.get(e);
            this.indices.put(e, i++);
        }
        for (Node v : this.graph.vertexSet()) {
            this.vars[i] = this.y.get(v);
            this.indices.put(v, i++);
        }
    }

    public void addComponent(Graph graph, Node root) {
        CutGenerator generator = new CutGenerator(graph, root);
        this.generatorList.add(generator);
        for (Node node : generator.getNodes()) {
            if (node == generator.getRoot()) continue;
            this.generators.put(node, generator);
            this.nodes.add(node);
        }
        this.inited = false;
    }
}

