/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.global.matching;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.text.MessageFormat;
import java.util.logging.Level;

public abstract class AbstractBipartiteGraph
extends AbstractLargeIntSConstraint {
    protected int nbLeftVertices;
    protected int nbRightVertices;
    protected int nbVertices;
    protected int minValue = Integer.MIN_VALUE;
    protected int maxValue = Integer.MAX_VALUE;
    protected int source;
    protected IStateIntVector refMatch;
    protected IStateInt matchingSize;
    protected int[] left2rightArc;
    protected int[] right2leftArc;
    protected IntQueue queue;
    protected int time = 0;
    protected int[] finishDate;
    protected boolean[] seen;
    protected int currentNode = -1;
    protected int currentComponent = -1;
    protected int[] component;
    protected boolean[][] componentOrder;

    public AbstractBipartiteGraph(IEnvironment environment, IntDomainVar[] vars, int nbLeft, int nbRight) {
        super(ConstraintEvent.CUBIC, vars);
        this.nbLeftVertices = nbLeft;
        this.nbRightVertices = nbRight;
        this.refMatch = environment.makeIntVector(this.nbLeftVertices, -1);
        this.matchingSize = environment.makeInt(0);
    }

    protected void init() {
        int i;
        this.nbVertices = this.nbLeftVertices + this.nbRightVertices + 1;
        for (i = 0; i < this.nbLeftVertices; ++i) {
            this.refMatch.set(i, -1);
        }
        this.matchingSize.set(0);
        this.queue = new IntQueue(this.nbVertices - 1);
        this.left2rightArc = new int[this.nbLeftVertices];
        this.right2leftArc = new int[this.nbRightVertices];
        this.source = this.nbVertices - 1;
        this.finishDate = new int[this.nbVertices];
        this.seen = new boolean[this.nbVertices];
        this.component = new int[this.nbVertices];
        for (i = 0; i < this.component.length; ++i) {
            this.component[i] = -1;
        }
        this.componentOrder = new boolean[this.nbVertices][this.nbVertices];
        for (i = 0; i < this.nbVertices; ++i) {
            this.componentOrder[i][i] = true;
        }
    }

    public final int[] mayMatch(int i) {
        int[] ret = new int[((IntDomainVar)this.getVar(i)).getDomain().getSize()];
        int offset = 0;
        DisposableIntIterator iterator = ((IntDomainVar)this.getVar(i)).getDomain().getIterator();
        while (iterator.hasNext()) {
            int j = iterator.next();
            ret[offset++] = j - this.minValue;
        }
        iterator.dispose();
        return ret;
    }

    public final int[] mayInverseMatch(int j) {
        int[] ret = new int[this.nbLeftVertices];
        int nb = 0;
        for (int i = 0; i < this.nbLeftVertices; ++i) {
            if (!((IntDomainVar)this.getVar(i)).canBeInstantiatedTo(j + this.minValue)) continue;
            ret[nb++] = i;
        }
        int[] ret2 = new int[nb];
        System.arraycopy(ret, 0, ret2, 0, nb);
        return ret2;
    }

    public final int match(int i) {
        return this.refMatch.get(i);
    }

    public final boolean mayGrowFlowToSink(int i) {
        return this.match(i) == -1;
    }

    public final boolean mayGrowFlowBetween(int j, int i) {
        return this.match(i) != j;
    }

    public final boolean mayDiminishFlowBetween(int j, int i) {
        return this.match(i) == j;
    }

    public abstract void increaseMatchingSize(int var1);

    public abstract void decreaseMatchingSize(int var1);

    public abstract void deleteMatch(int var1, int var2);

    public abstract void putRefMatch(int var1, int var2);

    public abstract void setMatch(int var1, int var2);

    public abstract boolean mayDiminishFlowFromSource(int var1);

    public abstract boolean mayGrowFlowFromSource(int var1);

    public abstract boolean mustGrowFlowFromSource(int var1);

    public abstract void deleteEdgeAndPublish(int var1, int var2) throws ContradictionException;

    public int findAlternatingPath() {
        int j;
        int eopath = -1;
        int n = this.nbLeftVertices;
        this.queue.init();
        for (j = 0; j < this.nbRightVertices; ++j) {
            if (!this.mustGrowFlowFromSource(j)) continue;
            this.queue.push(j + n);
        }
        if (this.queue.getSize() == 0) {
            for (j = 0; j < this.nbRightVertices; ++j) {
                if (!this.mayGrowFlowFromSource(j)) continue;
                this.queue.push(j + n);
            }
        }
        while (this.queue.getSize() > 0) {
            int x = this.queue.pop();
            if (x >= n) {
                boolean shouldBreak = false;
                int[] yy = this.mayInverseMatch(x -= n);
                for (int i = 0; i < yy.length; ++i) {
                    int y = yy[i];
                    if (!this.mayGrowFlowBetween(x, y) || this.queue.onceInQueue(y)) continue;
                    this.left2rightArc[y] = x;
                    if (this.mayGrowFlowToSink(y)) {
                        eopath = y;
                        shouldBreak = true;
                        break;
                    }
                    this.queue.push(y);
                }
                if (!shouldBreak) continue;
                break;
            }
            int y = this.match(x);
            if (this.queue.onceInQueue(y + n)) continue;
            this.right2leftArc[y] = x;
            this.queue.push(y + n);
        }
        return eopath;
    }

    public void augment(int x) {
        int xx = x;
        int y = this.left2rightArc[xx];
        while (!this.mayGrowFlowFromSource(y)) {
            this.putRefMatch(xx, y);
            xx = this.right2leftArc[y];
            assert (this.match(xx) == y);
            y = this.left2rightArc[xx];
            assert (y >= 0);
        }
        this.putRefMatch(xx, y);
        this.increaseMatchingSize(y);
    }

    public final void augmentFlow() throws ContradictionException {
        int eopath = this.findAlternatingPath();
        int n1 = this.nbLeftVertices;
        if (this.matchingSize.get() < n1) {
            while (eopath >= 0) {
                this.augment(eopath);
                eopath = this.findAlternatingPath();
            }
            if (this.matchingSize.get() < n1) {
                this.fail();
            }
        }
    }

    public final void initSCCGraph() {
        int i;
        int nbc = this.getNbComponents();
        for (i = 0; i < nbc; ++i) {
            for (int j = 0; j < nbc; ++j) {
                if (i == j) continue;
                this.componentOrder[i][j] = false;
            }
        }
        for (i = 0; i < this.nbVertices; ++i) {
            this.component[i] = -1;
        }
        this.currentComponent = -1;
    }

    public final void addComponentVertex() {
        ++this.currentComponent;
    }

    public final int getNbComponents() {
        return this.currentComponent + 1;
    }

    public final void addComponentEdge(int compi, int compj) {
        if (!this.componentOrder[compi][compj]) {
            this.componentOrder[compi][compj] = true;
            for (int compj2 = 0; compj2 < compj; ++compj2) {
                if (!this.componentOrder[compj][compj2]) continue;
                this.componentOrder[compi][compj2] = true;
            }
        }
    }

    public final void firstPassDFS() {
        int i;
        for (i = 0; i < this.nbVertices; ++i) {
            this.finishDate[i] = 0;
            this.seen[i] = false;
        }
        this.time = 0;
        for (i = 0; i < this.nbVertices; ++i) {
            this.firstDFSearch(i);
        }
    }

    public final void firstDFSearch(int i) {
        if (!this.seen[i]) {
            ++this.time;
            this.seen[i] = true;
            if (i < this.nbLeftVertices) {
                this.firstDFSearch(this.match(i) + this.nbLeftVertices);
            } else if (i < this.source) {
                int[] jj = this.mayInverseMatch(i - this.nbLeftVertices);
                for (int k = 0; k < jj.length; ++k) {
                    int j = jj[k];
                    if (this.match(j) == i - this.nbLeftVertices) continue;
                    this.firstDFSearch(j);
                }
                if (this.mayDiminishFlowFromSource(i - this.nbLeftVertices)) {
                    this.firstDFSearch(this.source);
                }
            } else {
                for (int j = 0; j < this.nbRightVertices; ++j) {
                    if (!this.mayGrowFlowFromSource(j)) continue;
                    this.firstDFSearch(j + this.nbLeftVertices);
                }
            }
            this.finishDate[i] = ++this.time;
        }
    }

    public final void secondPassDFS() {
        this.initSCCGraph();
        while (true) {
            int maxf = 0;
            int rootOfComp = -1;
            for (int i = 0; i < this.nbVertices; ++i) {
                if (this.component[i] != -1 || this.finishDate[i] <= maxf) continue;
                maxf = this.finishDate[i];
                rootOfComp = i;
            }
            if (maxf <= 0) break;
            this.addComponentVertex();
            this.secondDFSearch(rootOfComp);
        }
    }

    public final void secondDFSearch(int i) {
        int compi = this.component[i];
        int curComp = this.currentComponent;
        if (compi == -1) {
            this.component[i] = curComp;
            this.currentNode = i;
            if (i < this.nbLeftVertices) {
                int[] jj = this.mayMatch(i);
                for (int k = 0; k < jj.length; ++k) {
                    int j = jj[k];
                    if (this.match(i) == j) continue;
                    this.secondDFSearch(j + this.nbLeftVertices);
                }
            } else if (i < this.source) {
                int[] jj = this.mayInverseMatch(i - this.nbLeftVertices);
                for (int k = 0; k < jj.length; ++k) {
                    int j = jj[k];
                    if (this.match(j) != i - this.nbLeftVertices) continue;
                    this.secondDFSearch(j);
                }
                if (this.mayGrowFlowFromSource(i - this.nbLeftVertices)) {
                    this.secondDFSearch(this.source);
                }
            } else {
                for (int j = 0; j < this.nbRightVertices; ++j) {
                    if (!this.mayDiminishFlowFromSource(j)) continue;
                    this.secondDFSearch(j + this.nbLeftVertices);
                }
            }
        } else if (compi < curComp) {
            this.addComponentEdge(curComp, compi);
        } else if (compi > curComp) {
            LOGGER.log(Level.SEVERE, "Unexpected strong connection component of higher index: {0}, {1}", new Object[]{compi, curComp});
        }
    }

    protected void removeUselessEdges() throws ContradictionException {
        if (this.matchingSize.get() < this.nbLeftVertices) {
            this.augmentFlow();
        }
        this.refreshSCC();
        for (int i = 0; i < this.nbLeftVertices; ++i) {
            int[] jj = this.mayMatch(i);
            for (int k = 0; k < jj.length; ++k) {
                int j = jj[k];
                if (this.match(i) == j || this.component[i] == this.component[j + this.nbLeftVertices]) continue;
                this.deleteEdgeAndPublish(i, j);
            }
        }
    }

    public final void refreshSCC() {
        this.firstPassDFS();
        this.secondPassDFS();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.removeUselessEdges();
    }

    public final void prettyPrintForDebug() {
        if (LOGGER.isLoggable(Level.INFO)) {
            int i;
            for (i = 0; i < this.nbLeftVertices; ++i) {
                LOGGER.info(MessageFormat.format("{0}: {1}[{2}]", ((IntDomainVar[])this.vars)[i].pretty(), this.refMatch.get(i), this.component[i]));
            }
            for (i = 0; i < this.nbRightVertices; ++i) {
                LOGGER.info(MessageFormat.format("val({0}): [{1}]", i, this.component[i + this.nbLeftVertices]));
            }
            LOGGER.info(MessageFormat.format("Matching size = {0}/{1}", this.matchingSize.get(), this.nbLeftVertices));
        }
    }

    protected static class IntQueue {
        private int maxSize;
        private int nbElts;
        private int last;
        private int[] contents;
        private boolean[] onceInQueue;

        public IntQueue(int n) {
            this.maxSize = n;
            this.contents = new int[n];
            this.onceInQueue = new boolean[n];
            this.init();
        }

        public int getSize() {
            return this.nbElts;
        }

        public void init() {
            this.nbElts = 0;
            for (int i = 0; i < this.maxSize; ++i) {
                this.contents[i] = -1;
                this.onceInQueue[i] = false;
            }
        }

        public void push(int val) {
            this.onceInQueue[val] = true;
            if (this.contents[val] == -1) {
                if (this.nbElts == 0) {
                    this.contents[val] = val;
                } else {
                    this.contents[val] = this.contents[this.last];
                    this.contents[this.last] = val;
                }
                this.last = val;
                ++this.nbElts;
            }
        }

        public int pop() {
            int val = this.contents[this.last];
            --this.nbElts;
            this.contents[this.last] = this.contents[val];
            this.contents[val] = -1;
            return val;
        }

        public boolean onceInQueue(int i) {
            return this.onceInQueue[i];
        }
    }
}

