## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(corella)
library(tibble)

df <- tibble::tibble(
  name = c("Eolophus roseicapilla", "Eolophus roseicapilla"),
  latitude = c(-35.310, -35.273),
  longitude = c(149.125, 149.133),
  place = c("a big tree", "an open field")
)

df

## -----------------------------------------------------------------------------
df |>
  set_coordinates(decimalLatitude = place, # wrong column
                  decimalLongitude = longitude)

## ----term-table-output, out.extra='max-height:200px;', class.output='output-scroll'----
library(gt)
library(dplyr)

object <- darwin_core_terms |>
  select(set_function, term) |>
  filter(!is.na(set_function)) |>
  arrange(match(term, c("basisOfRecord", "occurrenceID", "scientificName",
                  "occurrenceID", "scientificName", "decimalLatitude",
                  "decimalLongitude", "geodeticDatum",
                  "coordinateUncertaintyInMeters", "eventDate")
                ), 
          desc(set_function)
          )

object |>
  mutate(
    check_function = glue::glue("check_{term}()")
  ) |>
  dplyr::select(2, 3, 1) |>
  dplyr::rename(
    "Term" = term,
    "check function" = check_function,
    "set function" = set_function
  ) |> 
  gt() |>
  cols_align(
    align = "left"
  ) |>
  tab_header(
    title = md("Supported Darwin Core terms"),
    subtitle = "and their associated functions"
  ) |>
  tab_style(
    style = list(
      cell_fill(color = "#92b4ea", alpha = 0.3),
      cell_text(font = c(google_font(name = "Roboto")))
    ),
    locations = cells_body(columns = c("Term"))
  ) |>
  tab_style(
    style = list(
      cell_borders(sides = c("l"), color = "gray50", weight = px(3)),
      cell_text(font = c(google_font(name = "Fira Mono")))
    ),
    locations = cells_body(columns = c("check function", "set function"))
  ) |>
  tab_options(
    container.height = "450px"
  )

## -----------------------------------------------------------------------------
df <- tibble::tibble(
  decimalLatitude = c(-35.310, "-35.273"), # deliberate error for demonstration purposes
  decimalLongitude = c(149.125, 149.133),
  date = c("14-01-2023", "15-01-2023"),
  individualCount = c(0, 2),
  scientificName = c("Callocephalon fimbriatum", "Eolophus roseicapilla"),
  country = c("AU", "AU"),
  occurrenceStatus = c("present", "present")
  )

df |>
  check_dataset()

