/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.highprecision;

import jdplus.toolkit.base.core.math.highprecision.DoubleDouble;
import jdplus.toolkit.base.core.math.highprecision.DoubleDoubleType;

public class DoubleDoubleComputer
implements DoubleDoubleType {
    private static final double SPLIT = 1.34217729E8;
    private double high;
    private double low;

    public DoubleDoubleComputer() {
        this.high = 0.0;
        this.low = 0.0;
    }

    public DoubleDoubleComputer(double x) {
        this.high = x;
        this.low = 0.0;
    }

    public DoubleDoubleComputer(DoubleDoubleType x) {
        this.high = x.getHigh();
        this.low = x.getLow();
    }

    public DoubleDoubleComputer(double high, double low) {
        this.high = high;
        this.low = low;
    }

    @Override
    public double getHigh() {
        return this.high;
    }

    @Override
    public double getLow() {
        return this.low;
    }

    public DoubleDoubleComputer set(DoubleDoubleType dd) {
        this.high = dd.getHigh();
        this.low = dd.getLow();
        return this;
    }

    public DoubleDoubleComputer set(double high, double low) {
        this.high = high;
        this.low = low;
        return this;
    }

    public DoubleDoubleComputer set(double d) {
        this.high = d;
        this.low = 0.0;
        return this;
    }

    @Override
    public double asDouble() {
        return this.high + this.low;
    }

    public DoubleDouble result() {
        return new DoubleDouble(this.high, this.low);
    }

    DoubleDoubleComputer add(double yhi, double ylo) {
        double S = this.high + yhi;
        double T2 = this.low + ylo;
        double e = S - this.high;
        double f = T2 - this.low;
        double s = S - e;
        double t = T2 - f;
        s = yhi - e + (this.high - s);
        t = ylo - f + (this.low - t);
        e = s + T2;
        double H = S + e;
        double h = e + (S - H);
        e = t + h;
        double zhi = H + e;
        double zlo = e + (H - zhi);
        this.high = zhi;
        this.low = zlo;
        return this;
    }

    DoubleDoubleComputer addXY(double xhi, double xlo, double yhi, double ylo) {
        double tmpHi = this.high;
        double tmpLo = this.low;
        this.high = xhi;
        this.low = xlo;
        return this.mul(yhi, ylo).add(tmpHi, tmpLo);
    }

    DoubleDoubleComputer addXY(DoubleDoubleType x, DoubleDoubleType y) {
        double tmpHi = this.high;
        double tmpLo = this.low;
        this.high = x.getHigh();
        this.low = x.getLow();
        return this.mul(y).add(tmpHi, tmpLo);
    }

    DoubleDoubleComputer subXY(double xhi, double xlo, double yhi, double ylo) {
        double tmpHi = this.high;
        double tmpLo = this.low;
        this.high = xhi;
        this.low = xlo;
        return this.mul(yhi, ylo).chs().add(tmpHi, tmpLo);
    }

    DoubleDoubleComputer subXY(DoubleDoubleType x, DoubleDoubleType y) {
        double tmpHi = this.high;
        double tmpLo = this.low;
        this.high = x.getHigh();
        this.low = x.getLow();
        return this.mul(y).chs().add(tmpHi, tmpLo);
    }

    DoubleDoubleComputer addaXY(double a, double xhi, double xlo, double yhi, double ylo) {
        double tmpHi = this.high;
        double tmpLo = this.low;
        this.high = xhi;
        this.low = xlo;
        return this.mul(yhi, ylo).mul(a).add(tmpHi, tmpLo);
    }

    public DoubleDoubleComputer add(double y) {
        return this.add(y, 0.0);
    }

    public DoubleDoubleComputer add(DoubleDoubleType y) {
        return this.add(y.getHigh(), y.getLow());
    }

    DoubleDoubleComputer sub(double yhi, double ylo) {
        return this.add(-yhi, -ylo);
    }

    DoubleDoubleComputer sub(double yhi) {
        return this.add(-yhi, 0.0);
    }

    public DoubleDoubleComputer sub(DoubleDoubleType y) {
        return this.add(-y.getHigh(), -y.getLow());
    }

    DoubleDoubleComputer mul(double yhi, double ylo) {
        double C = 1.34217729E8 * this.high;
        double hx = C - this.high;
        double c = 1.34217729E8 * yhi;
        hx = C - hx;
        double tx = this.high - hx;
        double hy = c - yhi;
        C = this.high * yhi;
        hy = c - hy;
        double ty = yhi - hy;
        c = hx * hy - C + hx * ty + tx * hy + tx * ty + (this.high * ylo + this.low * yhi);
        this.high = C + c;
        hx = C - this.high;
        this.low = c + hx;
        return this;
    }

    public DoubleDoubleComputer mul(double y) {
        return this.mul(y, 0.0);
    }

    public DoubleDoubleComputer mul(DoubleDoubleType y) {
        return this.mul(y.getHigh(), y.getLow());
    }

    DoubleDoubleComputer div(double yhi, double ylo) {
        double C = this.high / yhi;
        double c = 1.34217729E8 * C;
        double hc = c - C;
        double u = 1.34217729E8 * yhi;
        hc = c - hc;
        double tc = C - hc;
        double hy = u - yhi;
        double U = C * yhi;
        hy = u - hy;
        double ty = yhi - hy;
        u = hc * hy - U + hc * ty + tc * hy + tc * ty;
        c = (this.high - U - u + this.low - C * ylo) / yhi;
        this.high = u = C + c;
        this.low = C - u + c;
        return this;
    }

    public DoubleDoubleComputer div(double y) {
        return this.div(y, 0.0);
    }

    public DoubleDoubleComputer div(DoubleDoubleType y) {
        return this.div(y.getHigh(), y.getLow());
    }

    public DoubleDoubleComputer inv() {
        double C = 1.0 / this.high;
        double c = 1.34217729E8 * C;
        double hc = c - C;
        double u = 1.34217729E8 * this.high;
        hc = c - hc;
        double tc = C - hc;
        double hy = u - this.high;
        double U = C * this.high;
        hy = u - hy;
        double ty = this.high - hy;
        u = hc * hy - U + hc * ty + tc * hy + tc * ty;
        c = (1.0 - U - u - C * this.low) / this.high;
        this.high = C + c;
        this.low = C - this.high + c;
        return this;
    }

    public DoubleDoubleComputer chs() {
        this.high = -this.high;
        this.low = -this.low;
        return this;
    }

    public DoubleDoubleComputer abs() {
        if (this.isNegative()) {
            return this.chs();
        }
        return this;
    }

    public DoubleDoubleComputer square() {
        return this.mul(this.high, this.low);
    }

    public DoubleDoubleComputer sqrt() {
        if (this.isZero()) {
            this.set(0.0);
            return this;
        }
        if (this.isNegative()) {
            this.set(Double.NaN);
            return this;
        }
        double x = 1.0 / Math.sqrt(this.high);
        double ax = this.high * x;
        DoubleDoubleComputer sq = new DoubleDoubleComputer(ax);
        sq.square();
        this.sub(sq.high, sq.low);
        double d2 = this.high * (x * 0.5);
        this.set(ax);
        this.add(d2, 0.0);
        return this;
    }
}

