/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.miachm.sods;

import java.text.NumberFormat;
import java.text.ParseException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Currency;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import standalone_spreadsheet.com.github.miachm.sods.OfficeCurrency;
import standalone_spreadsheet.com.github.miachm.sods.OfficePercentage;
import standalone_spreadsheet.com.github.miachm.sods.XmlReaderInstance;

enum OfficeValueType {
    BOOLEAN("boolean", new Class[]{Boolean.class}){

        @Override
        public Object read(XmlReaderInstance reader) {
            String raw = reader.getAttribValue("office:boolean-value");
            if (raw == null) {
                return null;
            }
            switch (raw) {
                case "true": {
                    return true;
                }
                case "false": {
                    return false;
                }
            }
            return null;
        }

        @Override
        public void write(Object value, XMLStreamWriter writer) throws XMLStreamException {
            if (value instanceof Boolean) {
                writer.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type", this.getId());
                writer.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "boolean-value", value.toString());
            }
        }
    }
    ,
    CURRENCY("currency", new Class[]{OfficeCurrency.class}){

        @Override
        public Object read(XmlReaderInstance reader) {
            String tag = reader.getAttribValue("office:currency");
            Currency currency = null;
            if (tag != null) {
                currency = Currency.getInstance(tag);
            }
            NumberFormat nf = NumberFormat.getInstance(Locale.US);
            Double value = null;
            try {
                value = nf.parse(reader.getAttribValue("office:value")).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return new OfficeCurrency(currency, value);
        }

        @Override
        public void write(Object value, XMLStreamWriter writer) throws XMLStreamException {
            if (value instanceof OfficeCurrency) {
                writer.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type", this.getId());
                OfficeCurrency currency = (OfficeCurrency)value;
                if (currency.getValue() != null) {
                    NumberFormat formatter = NumberFormat.getInstance(Locale.US);
                    formatter.setGroupingUsed(false);
                    writer.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value", formatter.format(currency.getValue()));
                }
                if (currency.getCurrency() != null) {
                    writer.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "currency", currency.getCurrency().getCurrencyCode());
                }
            }
        }
    }
    ,
    DATE("date", new Class[]{LocalDateTime.class, LocalDate.class}){

        @Override
        public Object read(XmlReaderInstance reader) {
            String raw = reader.getAttribValue("office:date-value");
            if (raw == null) {
                return null;
            }
            try {
                return LocalDateTime.parse(raw, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
            catch (DateTimeParseException dateTimeEx) {
                try {
                    return LocalDate.parse(raw, DateTimeFormatter.ISO_LOCAL_DATE);
                }
                catch (DateTimeParseException dateEx) {
                    return null;
                }
            }
        }

        @Override
        public void write(Object value, XMLStreamWriter writer) throws XMLStreamException {
            if (value instanceof LocalDateTime) {
                writer.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type", this.getId());
                writer.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "date-value", ((LocalDateTime)value).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
            } else if (value instanceof LocalDate) {
                writer.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type", this.getId());
                writer.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "date-value", ((LocalDate)value).format(DateTimeFormatter.ISO_LOCAL_DATE));
            }
        }
    }
    ,
    FLOAT("float", new Class[]{Number.class}){

        @Override
        public Object read(XmlReaderInstance reader) {
            String raw = reader.getAttribValue("office:value");
            if (raw == null) {
                return null;
            }
            NumberFormat nf = NumberFormat.getInstance(Locale.US);
            Double value = null;
            try {
                value = nf.parse(reader.getAttribValue("office:value")).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return value;
        }

        @Override
        public void write(Object value, XMLStreamWriter writer) throws XMLStreamException {
            if (value instanceof Number) {
                writer.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type", this.getId());
                writer.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value", value.toString());
            }
        }
    }
    ,
    PERCENTAGE("percentage", new Class[]{OfficePercentage.class}){

        @Override
        public Object read(XmlReaderInstance reader) {
            String raw = reader.getAttribValue("office:value");
            NumberFormat nf = NumberFormat.getInstance(Locale.US);
            Double value = null;
            try {
                value = nf.parse(raw).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return new OfficePercentage(value);
        }

        @Override
        public void write(Object value, XMLStreamWriter writer) throws XMLStreamException {
            if (value instanceof OfficePercentage) {
                writer.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type", this.getId());
                OfficePercentage percentage = (OfficePercentage)value;
                if (percentage.getValue() != null) {
                    NumberFormat formatter = NumberFormat.getInstance(Locale.US);
                    writer.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value", formatter.format(percentage.getValue()));
                }
            }
        }
    }
    ,
    STRING("string", new Class[]{String.class}){

        @Override
        public Object read(XmlReaderInstance reader) {
            return reader.getAttribValue("office:string-value");
        }

        @Override
        public void write(Object value, XMLStreamWriter writer) throws XMLStreamException {
            if (value instanceof String) {
                writer.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type", this.getId());
                writer.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "string-value", value.toString().replace("\n", "&#x0a;"));
            }
        }
    }
    ,
    TIME("time", new Class[]{Duration.class}){

        @Override
        public Object read(XmlReaderInstance reader) {
            String raw = reader.getAttribValue("office:time-value");
            if (raw == null) {
                return null;
            }
            try {
                return Duration.parse(raw);
            }
            catch (DateTimeParseException dateEx) {
                return null;
            }
        }

        @Override
        public void write(Object value, XMLStreamWriter writer) throws XMLStreamException {
            if (value instanceof Duration) {
                writer.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type", this.getId());
                writer.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "time-value", value.toString());
            }
        }
    }
    ,
    VOID("void", new Class[0]){

        @Override
        public Object read(XmlReaderInstance reader) {
            return null;
        }

        @Override
        public void write(Object value, XMLStreamWriter writer) throws XMLStreamException {
        }
    };

    private final String id;
    private final Class<?>[] javaTypes;
    private static final OfficeValueType DEFAULT_VALUE;

    private OfficeValueType(String id, Class<?> ... javaTypes) {
        this.id = id;
        this.javaTypes = javaTypes;
    }

    public String getId() {
        return this.id;
    }

    public boolean canHandle(Class<?> type) {
        for (Class<?> javaType : this.javaTypes) {
            if (!javaType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public abstract Object read(XmlReaderInstance var1);

    public abstract void write(Object var1, XMLStreamWriter var2) throws XMLStreamException;

    public static OfficeValueType ofReader(XmlReaderInstance reader) {
        String raw = reader.getAttribValue("office:value-type");
        return raw != null ? OfficeValueType.ofId(raw) : DEFAULT_VALUE;
    }

    public static OfficeValueType ofId(String id) {
        for (OfficeValueType valueType : OfficeValueType.values()) {
            if (!valueType.getId().equals(id)) continue;
            return valueType;
        }
        return DEFAULT_VALUE;
    }

    public static OfficeValueType ofJavaType(Class<?> type) {
        for (OfficeValueType valueType : OfficeValueType.values()) {
            if (!valueType.canHandle(type)) continue;
            return valueType;
        }
        return DEFAULT_VALUE;
    }

    static {
        DEFAULT_VALUE = STRING;
    }
}

