/* Mapbox GL JS is Copyright © 2020 Mapbox and subject to the Mapbox Terms of Service ((https://www.mapbox.com/legal/tos/). */
(function (global, factory) {
typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
typeof define === 'function' && define.amd ? define(factory) :
(global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.mapboxgl = factory());
})(this, (function () { 'use strict';

/* eslint-disable */

var shared, worker, mapboxgl;
// define gets called three times: one for each chunk. we rely on the order
// they're imported to know which is which
function define(_, chunk) {
if (!shared) {
    shared = chunk;
} else if (!worker) {
    worker = chunk;
} else {
    var workerBundleString = "self.onerror = function() { console.error('An error occurred while parsing the WebWorker bundle. This is most likely due to improper transpilation by Babel; please see https://docs.mapbox.com/mapbox-gl-js/guides/install/#transpiling'); }; var sharedChunk = {}; (" + shared + ")(sharedChunk); (" + worker + ")(sharedChunk); self.onerror = null;"

    var sharedChunk = {};
    shared(sharedChunk);
    mapboxgl = chunk(sharedChunk);
    if (typeof window !== 'undefined' && window && window.URL && window.URL.createObjectURL) {
        mapboxgl.workerUrl = window.URL.createObjectURL(new Blob([workerBundleString], { type: 'text/javascript' }));
    }
}
}


define(["exports"],(function(t){var e=1e-6,r="undefined"!=typeof Float32Array?Float32Array:Array;function n(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],o=r*s-i*n;return o?(t[0]=s*(o=1/o),t[1]=-n*o,t[2]=-i*o,t[3]=r*o,t):null}function i(){var t=new r(9);return r!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t}function s(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],o=e[4],a=e[5],l=e[6],u=e[7],c=e[8];return t[0]=o*c-a*u,t[1]=i*u-n*c,t[2]=n*a-i*o,t[3]=a*l-s*c,t[4]=r*c-i*l,t[5]=i*s-r*a,t[6]=s*u-o*l,t[7]=n*l-r*u,t[8]=r*o-n*s,t}function o(t,e,r){var n=e[0],i=e[1],s=e[2],o=e[3],a=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=r[0],d=r[1],f=r[2],m=r[3],y=r[4],g=r[5],x=r[6],v=r[7],b=r[8];return t[0]=p*n+d*o+f*u,t[1]=p*i+d*a+f*c,t[2]=p*s+d*l+f*h,t[3]=m*n+y*o+g*u,t[4]=m*i+y*a+g*c,t[5]=m*s+y*l+g*h,t[6]=x*n+v*o+b*u,t[7]=x*i+v*a+b*c,t[8]=x*s+v*l+b*h,t}function a(){var t=new r(16);return r!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t}function l(t){var e=new r(16);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e}function u(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function c(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],o=e[4],a=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],d=e[11],f=e[12],m=e[13],y=e[14],g=e[15],x=r*a-n*o,v=r*l-i*o,b=r*u-s*o,w=n*l-i*a,_=n*u-s*a,A=i*u-s*l,I=c*m-h*f,M=c*y-p*f,S=c*g-d*f,P=h*y-p*m,k=h*g-d*m,B=p*g-d*y,z=x*B-v*k+b*P+w*S-_*M+A*I;return z?(t[0]=(a*B-l*k+u*P)*(z=1/z),t[1]=(i*k-n*B-s*P)*z,t[2]=(m*A-y*_+g*w)*z,t[3]=(p*_-h*A-d*w)*z,t[4]=(l*S-o*B-u*M)*z,t[5]=(r*B-i*S+s*M)*z,t[6]=(y*b-f*A-g*v)*z,t[7]=(c*A-p*b+d*v)*z,t[8]=(o*k-a*S+u*I)*z,t[9]=(n*S-r*k-s*I)*z,t[10]=(f*_-m*b+g*x)*z,t[11]=(h*b-c*_-d*x)*z,t[12]=(a*M-o*P-l*I)*z,t[13]=(r*P-n*M+i*I)*z,t[14]=(m*v-f*w-y*x)*z,t[15]=(c*w-h*v+p*x)*z,t):null}function h(t,e,r){var n=e[0],i=e[1],s=e[2],o=e[3],a=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],d=e[10],f=e[11],m=e[12],y=e[13],g=e[14],x=e[15],v=r[0],b=r[1],w=r[2],_=r[3];return t[0]=v*n+b*a+w*h+_*m,t[1]=v*i+b*l+w*p+_*y,t[2]=v*s+b*u+w*d+_*g,t[3]=v*o+b*c+w*f+_*x,t[4]=(v=r[4])*n+(b=r[5])*a+(w=r[6])*h+(_=r[7])*m,t[5]=v*i+b*l+w*p+_*y,t[6]=v*s+b*u+w*d+_*g,t[7]=v*o+b*c+w*f+_*x,t[8]=(v=r[8])*n+(b=r[9])*a+(w=r[10])*h+(_=r[11])*m,t[9]=v*i+b*l+w*p+_*y,t[10]=v*s+b*u+w*d+_*g,t[11]=v*o+b*c+w*f+_*x,t[12]=(v=r[12])*n+(b=r[13])*a+(w=r[14])*h+(_=r[15])*m,t[13]=v*i+b*l+w*p+_*y,t[14]=v*s+b*u+w*d+_*g,t[15]=v*o+b*c+w*f+_*x,t}function p(t,e,r){var n,i,s,o,a,l,u,c,h,p,d,f,m=r[0],y=r[1],g=r[2];return e===t?(t[12]=e[0]*m+e[4]*y+e[8]*g+e[12],t[13]=e[1]*m+e[5]*y+e[9]*g+e[13],t[14]=e[2]*m+e[6]*y+e[10]*g+e[14],t[15]=e[3]*m+e[7]*y+e[11]*g+e[15]):(i=e[1],s=e[2],o=e[3],a=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],d=e[10],f=e[11],t[0]=n=e[0],t[1]=i,t[2]=s,t[3]=o,t[4]=a,t[5]=l,t[6]=u,t[7]=c,t[8]=h,t[9]=p,t[10]=d,t[11]=f,t[12]=n*m+a*y+h*g+e[12],t[13]=i*m+l*y+p*g+e[13],t[14]=s*m+u*y+d*g+e[14],t[15]=o*m+c*y+f*g+e[15]),t}function d(t,e,r){var n=r[0],i=r[1],s=r[2];return t[0]=e[0]*n,t[1]=e[1]*n,t[2]=e[2]*n,t[3]=e[3]*n,t[4]=e[4]*i,t[5]=e[5]*i,t[6]=e[6]*i,t[7]=e[7]*i,t[8]=e[8]*s,t[9]=e[9]*s,t[10]=e[10]*s,t[11]=e[11]*s,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t}function f(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[4],o=e[5],a=e[6],l=e[7],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=s*i+u*n,t[5]=o*i+c*n,t[6]=a*i+h*n,t[7]=l*i+p*n,t[8]=u*i-s*n,t[9]=c*i-o*n,t[10]=h*i-a*n,t[11]=p*i-l*n,t}function m(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],o=e[1],a=e[2],l=e[3],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i-u*n,t[1]=o*i-c*n,t[2]=a*i-h*n,t[3]=l*i-p*n,t[8]=s*n+u*i,t[9]=o*n+c*i,t[10]=a*n+h*i,t[11]=l*n+p*i,t}function y(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],o=e[1],a=e[2],l=e[3],u=e[4],c=e[5],h=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i+u*n,t[1]=o*i+c*n,t[2]=a*i+h*n,t[3]=l*i+p*n,t[4]=u*i-s*n,t[5]=c*i-o*n,t[6]=h*i-a*n,t[7]=p*i-l*n,t}function g(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e[1],t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e[2],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function x(t,r,n){var i,s,o,a=n[0],l=n[1],u=n[2],c=Math.sqrt(a*a+l*l+u*u);return c<e?null:(a*=c=1/c,l*=c,u*=c,i=Math.sin(r),s=Math.cos(r),t[0]=a*a*(o=1-s)+s,t[1]=l*a*o+u*i,t[2]=u*a*o-l*i,t[3]=0,t[4]=a*l*o-u*i,t[5]=l*l*o+s,t[6]=u*l*o+a*i,t[7]=0,t[8]=a*u*o+l*i,t[9]=l*u*o-a*i,t[10]=u*u*o+s,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t)}function v(t,e){var r=e[0],n=e[1],i=e[2],s=e[4],o=e[5],a=e[6],l=e[8],u=e[9],c=e[10];return t[0]=Math.sqrt(r*r+n*n+i*i),t[1]=Math.sqrt(s*s+o*o+a*a),t[2]=Math.sqrt(l*l+u*u+c*c),t}function b(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],o=r+r,a=n+n,l=i+i,u=r*o,c=n*o,h=n*a,p=i*o,d=i*a,f=i*l,m=s*o,y=s*a,g=s*l;return t[0]=1-h-f,t[1]=c+g,t[2]=p-y,t[3]=0,t[4]=c-g,t[5]=1-u-f,t[6]=d+m,t[7]=0,t[8]=p+y,t[9]=d-m,t[10]=1-u-h,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}var w=h;function _(){var t=new r(3);return r!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function A(t){var e=new r(3);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e}function I(t){var e=t[0],r=t[1],n=t[2];return Math.sqrt(e*e+r*r+n*n)}function M(t,e,n){var i=new r(3);return i[0]=t,i[1]=e,i[2]=n,i}function S(t,e,r,n){return t[0]=e,t[1]=r,t[2]=n,t}function P(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t}function k(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t}function B(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t}function z(t,e,r){return t[0]=Math.min(e[0],r[0]),t[1]=Math.min(e[1],r[1]),t[2]=Math.min(e[2],r[2]),t}function T(t,e,r){return t[0]=Math.max(e[0],r[0]),t[1]=Math.max(e[1],r[1]),t[2]=Math.max(e[2],r[2]),t}function E(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t}function V(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t}function F(t,e){var r=e[0]-t[0],n=e[1]-t[1],i=e[2]-t[2];return Math.sqrt(r*r+n*n+i*i)}function C(t,e){var r=e[0]-t[0],n=e[1]-t[1],i=e[2]-t[2];return r*r+n*n+i*i}function D(t){var e=t[0],r=t[1],n=t[2];return e*e+r*r+n*n}function R(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t}function L(t,e){var r=e[0],n=e[1],i=e[2],s=r*r+n*n+i*i;return s>0&&(s=1/Math.sqrt(s)),t[0]=e[0]*s,t[1]=e[1]*s,t[2]=e[2]*s,t}function O(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]}function U(t,e,r){var n=e[0],i=e[1],s=e[2],o=r[0],a=r[1],l=r[2];return t[0]=i*l-s*a,t[1]=s*o-n*l,t[2]=n*a-i*o,t}function N(t,e,r,n){var i=e[0],s=e[1],o=e[2];return t[0]=i+n*(r[0]-i),t[1]=s+n*(r[1]-s),t[2]=o+n*(r[2]-o),t}function j(t,e,r){var n=e[0],i=e[1],s=e[2],o=r[3]*n+r[7]*i+r[11]*s+r[15];return t[0]=(r[0]*n+r[4]*i+r[8]*s+r[12])/(o=o||1),t[1]=(r[1]*n+r[5]*i+r[9]*s+r[13])/o,t[2]=(r[2]*n+r[6]*i+r[10]*s+r[14])/o,t}function $(t,e,r){var n=e[0],i=e[1],s=e[2];return t[0]=n*r[0]+i*r[3]+s*r[6],t[1]=n*r[1]+i*r[4]+s*r[7],t[2]=n*r[2]+i*r[5]+s*r[8],t}function G(t,e,r){var n=r[0],i=r[1],s=r[2],o=r[3],a=e[0],l=e[1],u=e[2],c=i*u-s*l,h=s*a-n*u,p=n*l-i*a;return t[0]=a+o*(c+=c)+i*(p+=p)-s*(h+=h),t[1]=l+o*h+s*c-n*p,t[2]=u+o*p+n*h-i*c,t}function q(t){return t[0]=0,t[1]=0,t[2]=0,t}function H(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]}var X=k,Z=B,W=I;function Y(){var t=new r(4);return r!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0,t[3]=0),t}function K(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t}function J(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],o=r*r+n*n+i*i+s*s;return o>0&&(o=1/Math.sqrt(o)),t[0]=r*o,t[1]=n*o,t[2]=i*o,t[3]=s*o,t}function Q(t,e,r){var n=e[0],i=e[1],s=e[2],o=e[3];return t[0]=r[0]*n+r[4]*i+r[8]*s+r[12]*o,t[1]=r[1]*n+r[5]*i+r[9]*s+r[13]*o,t[2]=r[2]*n+r[6]*i+r[10]*s+r[14]*o,t[3]=r[3]*n+r[7]*i+r[11]*s+r[15]*o,t}function tt(){var t=new r(4);return r!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function et(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t}function rt(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],o=e[3],a=Math.sin(r),l=Math.cos(r);return t[0]=n*l+o*a,t[1]=i*l+s*a,t[2]=s*l-i*a,t[3]=o*l-n*a,t}function nt(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],o=e[3],a=Math.sin(r),l=Math.cos(r);return t[0]=n*l-s*a,t[1]=i*l+o*a,t[2]=s*l+n*a,t[3]=o*l-i*a,t}_(),Y();var it,st,ot,at=J,lt=(it=_(),st=M(1,0,0),ot=M(0,1,0),function(t,e,r){var n=O(e,r);return n<-.999999?(U(it,st,e),W(it)<1e-6&&U(it,ot,e),L(it,it),function(t,e,r){r*=.5;var n=Math.sin(r);t[0]=n*e[0],t[1]=n*e[1],t[2]=n*e[2],t[3]=Math.cos(r);}(t,it,Math.PI),t):n>.999999?(t[0]=0,t[1]=0,t[2]=0,t[3]=1,t):(U(it,e,r),t[0]=it[0],t[1]=it[1],t[2]=it[2],t[3]=1+n,at(t,t))});function ut(){var t=new r(2);return r!=Float32Array&&(t[0]=0,t[1]=0),t}function ct(t,e){var n=new r(2);return n[0]=t,n[1]=e,n}function ht(t,e,r){return t[0]=e,t[1]=r,t}function pt(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t}function dt(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t}function ft(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t}function mt(t){var e=t[0],r=t[1];return Math.sqrt(e*e+r*r)}function yt(t,e){var r=e[0],n=e[1],i=r*r+n*n;return i>0&&(i=1/Math.sqrt(i)),t[0]=e[0]*i,t[1]=e[1]*i,t}function gt(t,e){return t[0]*e[0]+t[1]*e[1]}tt(),tt(),i();var xt,vt,bt=dt;function wt(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}ut();var _t=function(){if(vt)return xt;function t(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n;}return vt=1,xt=t,t.prototype={sampleCurveX:function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return ((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s;}var o=0,a=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?o=r:a=r,r=.5*(a-o)+o;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},xt}(),At=wt(_t);function It(t,e){this.x=t,this.y=e;}function Mt(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return !1;for(let r=0;r<t.length;r++)if(!Mt(t[r],e[r]))return !1;return !0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return !1;if(Object.keys(t).length!==Object.keys(e).length)return !1;for(const r in t)if(!Mt(t[r],e[r]))return !1;return !0}return t===e}It.prototype={clone(){return new It(this.x,this.y)},add(t){return this.clone()._add(t)},sub(t){return this.clone()._sub(t)},multByPoint(t){return this.clone()._multByPoint(t)},divByPoint(t){return this.clone()._divByPoint(t)},mult(t){return this.clone()._mult(t)},div(t){return this.clone()._div(t)},rotate(t){return this.clone()._rotate(t)},rotateAround(t,e){return this.clone()._rotateAround(t,e)},matMult(t){return this.clone()._matMult(t)},unit(){return this.clone()._unit()},perp(){return this.clone()._perp()},round(){return this.clone()._round()},mag(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals(t){return this.x===t.x&&this.y===t.y},dist(t){return Math.sqrt(this.distSqr(t))},distSqr(t){const e=t.x-this.x,r=t.y-this.y;return e*e+r*r},angle(){return Math.atan2(this.y,this.x)},angleTo(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith(t){return this.angleWithSep(t.x,t.y)},angleWithSep(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult(t){const e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add(t){return this.x+=t.x,this.y+=t.y,this},_sub(t){return this.x-=t.x,this.y-=t.y,this},_mult(t){return this.x*=t,this.y*=t,this},_div(t){return this.x/=t,this.y/=t,this},_multByPoint(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint(t){return this.x/=t.x,this.y/=t.y,this},_unit(){return this._div(this.mag()),this},_perp(){const t=this.y;return this.y=this.x,this.x=-t,this},_rotate(t){const e=Math.cos(t),r=Math.sin(t),n=r*this.x+e*this.y;return this.x=e*this.x-r*this.y,this.y=n,this},_rotateAround(t,e){const r=Math.cos(t),n=Math.sin(t),i=e.y+n*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-n*(this.y-e.y),this.y=i,this},_round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},constructor:It},It.convert=function(t){if(t instanceof It)return t;if(Array.isArray(t))return new It(+t[0],+t[1]);if(void 0!==t.x&&void 0!==t.y)return new It(+t.x,+t.y);throw new Error("Expected [x, y] or {x, y} point format")};const St=Math.PI/180,Pt=180/Math.PI;function kt(t){return t*St}function Bt(t){return t*Pt}const zt=[[0,0],[1,0],[1,1],[0,1]];function Tt(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75)}function Et(t,e,r,n){const i=new At(t,e,r,n);return function(t){return i.solve(t)}}const Vt=Et(.25,.1,.25,1);function Ft(t,e,r){return Math.min(r,Math.max(e,t))}function Ct(t,e,r){return (r=Ft((r-t)/(e-t),0,1))*r*(3-2*r)}function Dt(t,e,r){const n=r-e,i=((t-e)%n+n)%n+e;return i===e?r:i}function Rt(t,e,r){if(!t.length)return r(null,[]);let n=t.length;const i=new Array(t.length);let s=null;t.forEach(((t,o)=>{e(t,((t,e)=>{t&&(s=t),i[o]=e,0==--n&&r(s,i);}));}));}let Lt=1;function Ot(){return Lt++}function Ut(t){return t<=1?1:Math.pow(2,Math.ceil(Math.log2(t)))}function Nt(t,e){t.forEach((t=>{e[t]&&(e[t]=e[t].bind(e));}));}function jt(t,e,r){const n={};for(const r in t)n[r]=e.call(this,t[r],r,t);return n}function $t(t,e,r){const n={};for(const r in t)e.call(this,t[r],r,t)&&(n[r]=t[r]);return n}function Gt(t){return Array.isArray(t)?t.map(Gt):"object"==typeof t&&t?jt(t,Gt):t}function qt(t,e){for(let r=0;r<t.length;r++)if(e.indexOf(t[r])>=0)return !0;return !1}const Ht={};function Xt(t){Ht[t]||("undefined"!=typeof console&&console.warn(t),Ht[t]=!0);}function Zt(t,e,r){return (r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x)}function Wt(t){let e=0;for(let r,n,i=0,s=t.length,o=s-1;i<s;o=i++)r=t[i],n=t[o],e+=(n.x-r.x)*(r.y+n.y);return e}function Yt([t,e,r]){const n=kt(e+90),i=kt(r);return {x:t*Math.cos(n)*Math.sin(i),y:t*Math.sin(n)*Math.sin(i),z:t*Math.cos(i),azimuthal:e,polar:r}}function Kt(t){return ("undefined"!=typeof self||void 0!==t)&&"undefined"!=typeof WorkerGlobalScope&&(void 0!==t?t:self)instanceof WorkerGlobalScope}function Jt(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((t,r,n,i)=>{const s=n||i;return e[r]=!s||s.toLowerCase(),""})),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t;}return e}let Qt=null;function te(t,e){return [t[4*e],t[4*e+1],t[4*e+2],t[4*e+3]]}function ee(t,e,r,n){for(;e<r;){const i=e+r>>1;t[i]<n?e=i+1:r=i;}return e}function re(t,e,r,n){for(;e<r;){const i=e+r>>1;t[i]<=n?e=i+1:r=i;}return e}function ne(t){return t>0?1/(1.001-t):1+t}function ie(t){return t>0?1-1/(1.001-t):-t}function se(t,e,r){return (t-e.min)*(r.max-r.min)/(e.max-e.min)+r.min}const oe={API_URL:"https://api.mapbox.com",get API_URL_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/|\?|$)/i},get API_TILEJSON_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/v[0-9]*\/.*\.json.*$)/i},get API_SPRITE_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/styles\/v[0-9]*\/)(.*\/sprite.*\..*$)/i},get API_FONTS_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/fonts\/v[0-9]*\/)(.*\.pbf.*$)/i},get API_STYLE_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/styles\/v[0-9]*\/)(.*$)/i},get API_CDN_URL_REGEX(){return /^((https?:)?\/\/)?api\.mapbox\.c(n|om)(\/mapbox-gl-js\/)(.*$)/i},get EVENTS_URL(){if(!oe.API_URL)return null;try{const t=new URL(oe.API_URL);return "api.mapbox.cn"===t.hostname?"https://events.mapbox.cn/events/v2":"api.mapbox.com"===t.hostname?"https://events.mapbox.com/events/v2":null}catch(t){return null}},SESSION_PATH:"/map-sessions/v1",FEEDBACK_URL:"https://apps.mapbox.com/feedback",TILE_URL_VERSION:"v4",RASTER_URL_PREFIX:"raster/v1",RASTERARRAYS_URL_PREFIX:"rasterarrays/v1",REQUIRE_ACCESS_TOKEN:!0,ACCESS_TOKEN:null,DEFAULT_STYLE:"mapbox://styles/mapbox/standard",MAX_PARALLEL_IMAGE_REQUESTS:16,DRACO_URL:"https://api.mapbox.com/mapbox-gl-js/draco_decoder_gltf_v1.5.6.wasm",MESHOPT_URL:"https://api.mapbox.com/mapbox-gl-js/meshopt_base_v0.20.wasm",MESHOPT_SIMD_URL:"https://api.mapbox.com/mapbox-gl-js/meshopt_simd_v0.20.wasm",BUILDING_GEN_URL:"https://api.mapbox.com/mapbox-gl-js/building-gen/building_gen_v1.2.4.wasm",GLYPHS_URL:"mapbox://fonts/mapbox/{fontstack}/{range}.pbf",TILES3D_URL_PREFIX:"3dtiles/v1"};function ae(t){return oe.API_URL_REGEX.test(t)}function le(t){return oe.API_SPRITE_REGEX.test(t)}let ue,ce,he,pe,de,fe;function me(){return null==ue&&(ue=self.OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof self.createImageBitmap),ue}const ye={now:()=>void 0!==pe?pe:performance.now(),setNow(t){pe=t;},restoreNow(){pe=void 0;},frame(t){const e=requestAnimationFrame(t);return {cancel:()=>cancelAnimationFrame(e)}},getImageData(t,e=0){const{width:r,height:n}=t;de||(de=document.createElement("canvas"));const i=de.getContext("2d",{willReadFrequently:!0});if(!i)throw new Error("failed to create canvas 2d context");return (r>de.width||n>de.height)&&(de.width=r,de.height=n),i.clearRect(-e,-e,r+2*e,n+2*e),i.drawImage(t,0,0,r,n),i.getImageData(-e,-e,r+2*e,n+2*e)},resolveURL:t=>(ce||(ce=document.createElement("a")),ce.href=t,ce.href),get devicePixelRatio(){return window.devicePixelRatio},get prefersReducedMotion(){return !!window.matchMedia&&(null==he&&(he=window.matchMedia("(prefers-reduced-motion: reduce)")),he.matches)},hasCanvasFingerprintNoise(){if(void 0!==fe)return fe;if(!me())return fe=!1,!1;const t=new OffscreenCanvas(85,1),e=t.getContext("2d",{willReadFrequently:!0});let r=0;for(let n=0;n<t.width;++n)e.fillStyle=`rgba(${r++},${r++},${r++}, 255)`,e.fillRect(n,0,1,1);const n=e.getImageData(0,0,t.width,t.height);r=0;for(let t=0;t<n.data.length;++t)if(t%4!=3&&r++!==n.data[t])return fe=!0,!0;return fe=!1,!1}};function ge(t,e){const r=t.indexOf("?");if(r<0)return `${t}?${new URLSearchParams(e).toString()}`;const n=new URLSearchParams(t.slice(r));for(const t in e)n.set(t,e[t]);return `${t.slice(0,r)}?${n.toString()}`}function xe(t,e={persistentParams:[]}){const r=t.indexOf("?");if(r<0)return t;const n=new URLSearchParams,i=new URLSearchParams(t.slice(r));for(const t of e.persistentParams){const e=i.get(t);e&&n.set(t,e);}const s=n.toString();return `${t.slice(0,r)}${s.length>0?`?${s}`:""}`}const ve="mapbox-tiles";let be=500,we=50;const _e=["language","worldview","jobid"];let Ae,Ie;function Me(){try{return caches}catch(t){}}function Se(){const t=Me();t&&null==Ae&&(Ae=t.open(ve));}let Pe=1/0;const ke={supported:!1,testSupport:function(t){!Te&&ze&&(Ee?Fe(t):Be=t);}};let Be,ze,Te=!1,Ee=!1;const Ve="undefined"!=typeof self?self:{};function Fe(t){const e=t.createTexture();t.bindTexture(t.TEXTURE_2D,e);try{if(t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,ze),t.isContextLost())return;ke.supported=!0;}catch(t){}t.deleteTexture(e),Te=!0;}Ve.document&&(ze=Ve.document.createElement("img"),ze.onload=function(){Be&&Fe(Be),Be=null,Ee=!0;},ze.onerror=function(){Te=!0,Be=null;},ze.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA=");const Ce={Unknown:"Unknown",Style:"Style",Source:"Source",Tile:"Tile",Glyphs:"Glyphs",SpriteImage:"SpriteImage",SpriteJSON:"SpriteJSON",Iconset:"Iconset",Image:"Image",Model:"Model"};"function"==typeof Object.freeze&&Object.freeze(Ce);class De extends Error{constructor(t,e,r){401===e&&ae(r)&&(t+=": you may have provided an invalid Mapbox access token. See https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes"),super(t),this.status=e,this.url=r;}toString(){return `${this.name}: ${this.message} (${this.status}): ${this.url}`}}const Re=Kt()?()=>self.worker.referrer:()=>("blob:"===location.protocol?parent:self).location.href;const Le=function(t,e){if(!(/^file:/.test(r=t.url)||/^file:/.test(Re())&&!/^\w+:/.test(r))){if(self.fetch&&self.Request&&self.AbortController&&Request.prototype.hasOwnProperty("signal"))return function(t,e){const r=new AbortController,n=new Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,referrer:Re(),referrerPolicy:t.referrerPolicy,signal:r.signal});let i=!1,s=!1;const o=(a=n.url).indexOf("sku=")>0&&ae(a);var a;"json"===t.type&&n.headers.set("Accept","application/json");const l=(r,i,a)=>{if(s)return;if(r&&"SecurityError"!==r.message&&Xt(r.toString()),i&&a)return u(i);const l=Date.now();fetch(n).then((r=>{if(r.ok){const t=o?r.clone():null;return u(r,t,l)}return e(new De(r.statusText,r.status,t.url))})).catch((r=>{"AbortError"!==r.name&&e(new Error(`${r.message} ${t.url}`));}));},u=(r,o,a)=>{("arrayBuffer"===t.type?r.arrayBuffer():"json"===t.type?r.json():r.text()).then((t=>{s||(o&&a&&function(t,e,r){if(Se(),null==Ae)return;const n=Jt(e.headers.get("Cache-Control")||"");if(n["no-store"])return;const i={status:e.status,statusText:e.statusText,headers:new Headers};e.headers.forEach(((t,e)=>i.headers.set(e,t))),n["max-age"]&&i.headers.set("Expires",new Date(r+1e3*n["max-age"]).toUTCString());const s=i.headers.get("Expires");if(!s)return;if(new Date(s).getTime()-r<42e4)return;let o=xe(t.url,{persistentParams:_e});if(206===e.status){const e=t.headers.get("Range");if(!e)return;i.status=200,o=ge(o,{range:e});}!function(t,e){if(void 0===Ie)try{new Response(new ReadableStream),Ie=!0;}catch(t){Ie=!1;}Ie?e(t.body):t.blob().then(e).catch((t=>Xt(t.message)));}(e,(t=>{const r=new Response(200!==(n=e.status)&&404!==n&&[101,103,204,205,304].includes(n)?null:t,i);var n;Se(),null!=Ae&&Ae.then((t=>t.put(o,r))).catch((t=>Xt(t.message)));}));}(n,o,a),i=!0,e(null,t,r.headers));})).catch((t=>{s||e(new Error(t.message));}));};return o?function(t,e){if(Se(),null==Ae)return e(null);Ae.then((r=>{let n=xe(t.url,{persistentParams:_e});const i=t.headers.get("Range");i&&(n=ge(n,{range:i})),r.match(n).then((t=>{const i=function(t){if(!t)return !1;const e=new Date(t.headers.get("Expires")||0),r=Jt(t.headers.get("Cache-Control")||"");return Number(e)>Date.now()&&!r["no-cache"]}(t);r.delete(n).catch(e),i&&r.put(n,t.clone()).catch(e),e(null,t,i);})).catch(e);})).catch(e);}(n,l):l(null,null),{cancel:()=>{s=!0,i||r.abort();}}}(t,e);if(Kt(self)&&self.worker.actor)return self.worker.actor.send("getResource",t,e,void 0,!0)}var r;return function(t,e){const r=new XMLHttpRequest;r.open(t.method||"GET",t.url,!0),"arrayBuffer"===t.type&&(r.responseType="arraybuffer");for(const e in t.headers)r.setRequestHeader(e,t.headers[e]);return "json"===t.type&&(r.responseType="text",r.setRequestHeader("Accept","application/json")),r.withCredentials="include"===t.credentials,r.onerror=()=>{e(new Error(r.statusText));},r.onload=()=>{if((r.status>=200&&r.status<300||0===r.status)&&null!==r.response){let n=r.response;if("json"===t.type)try{n=JSON.parse(r.response);}catch(t){return e(t)}const i=new Headers;r.getAllResponseHeaders().trim().split(/[\r\n]+/).forEach((t=>{const e=t.split(": "),r=e.shift(),n=e.join(": ");i.append(r,n);})),e(null,n,i);}else e(new De(r.statusText,r.status,t.url));},r.send(t.body),{cancel:()=>r.abort()}}(t,e)},Oe=function(t,e){return Le(Object.assign(t,{type:"arrayBuffer"}),e)};function Ue(t){const e=document.createElement("a");return e.href=t,e.protocol===location.protocol&&e.host===location.host}const Ne="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";let je,$e;je=[],$e=0;const Ge=function(t,e){if(ke.supported&&(t.headers||(t.headers={}),t.headers.accept="image/webp,*/*"),$e>=oe.MAX_PARALLEL_IMAGE_REQUESTS){const r={requestParameters:t,callback:e,cancelled:!1,cancel(){this.cancelled=!0;}};return je.push(r),r}$e++;let r=!1;const n=()=>{if(!r)for(r=!0,$e--;je.length&&$e<oe.MAX_PARALLEL_IMAGE_REQUESTS;){const t=je.shift(),{requestParameters:e,callback:r,cancelled:n}=t;n||(t.cancel=Ge(e,r).cancel);}},i=Oe(t,((t,r,i)=>{n(),t?e(t):r&&(self.createImageBitmap?function(t,e){const r=new Blob([new Uint8Array(t)],{type:"image/png"});createImageBitmap(r).then((t=>{e(null,t);})).catch((t=>{e(new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`));}));}(r,((t,r)=>e(t,r,i))):function(t,e){const r=new Image;r.onload=()=>{e(null,r),URL.revokeObjectURL(r.src),r.onload=null,requestAnimationFrame((()=>{r.src=Ne;}));},r.onerror=()=>e(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const n=new Blob([new Uint8Array(t)],{type:"image/png"});r.src=t.byteLength?URL.createObjectURL(n):Ne;}(r,((t,r)=>e(t,r,i))));}));return {cancel:()=>{i.cancel(),n();}}};var qe,He,Xe,Ze={exports:{}},We={exports:{}},Ye={exports:{}},Ke=function(){if(Xe)return Ze.exports;Xe=1;var t=(qe||(qe=1,We.exports=function(t,e){var r,n,i,s,o,a,l,u;for(n=t.length-(r=3&t.length),i=e,o=3432918353,a=461845907,u=0;u<n;)l=255&t.charCodeAt(u)|(255&t.charCodeAt(++u))<<8|(255&t.charCodeAt(++u))<<16|(255&t.charCodeAt(++u))<<24,++u,i=27492+(65535&(s=5*(65535&(i=(i^=l=(65535&(l=(l=(65535&l)*o+(((l>>>16)*o&65535)<<16)&4294967295)<<15|l>>>17))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<13|i>>>19))+((5*(i>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&t.charCodeAt(u+2))<<16;case 2:l^=(255&t.charCodeAt(u+1))<<8;case 1:i^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(u)))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<15|l>>>17))*a+(((l>>>16)*a&65535)<<16)&4294967295;}return i^=t.length,i=2246822507*(65535&(i^=i>>>16))+((2246822507*(i>>>16)&65535)<<16)&4294967295,i=3266489909*(65535&(i^=i>>>13))+((3266489909*(i>>>16)&65535)<<16)&4294967295,(i^=i>>>16)>>>0}),We.exports),e=(He||(He=1,Ye.exports=function(t,e){for(var r,n=t.length,i=e^n,s=0;n>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(s)|(255&t.charCodeAt(++s))<<8|(255&t.charCodeAt(++s))<<16|(255&t.charCodeAt(++s))<<24))+((1540483477*(r>>>16)&65535)<<16),i=1540483477*(65535&i)+((1540483477*(i>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),n-=4,++s;switch(n){case 3:i^=(255&t.charCodeAt(s+2))<<16;case 2:i^=(255&t.charCodeAt(s+1))<<8;case 1:i=1540483477*(65535&(i^=255&t.charCodeAt(s)))+((1540483477*(i>>>16)&65535)<<16);}return i=1540483477*(65535&(i^=i>>>13))+((1540483477*(i>>>16)&65535)<<16),(i^=i>>>15)>>>0}),Ye.exports);return Ze.exports=t,Ze.exports.murmur3=t,Ze.exports.murmur2=e,Ze.exports}(),Je=wt(Ke);class Qe{constructor(t,...e){Object.assign(this,e[0]||{}),this.type=t;}}class tr extends Qe{constructor(t,e={}){super("error",Object.assign({error:t},e));}}function er(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[],r[t].push(e));}function rr(t,e,r){if(r&&r[t]){const n=r[t].indexOf(e);-1!==n&&r[t].splice(n,1);}}class nr{on(t,e){return this._listeners=this._listeners||{},er(t,e,this._listeners),this}off(t,e){return rr(t,e,this._listeners),rr(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},er(t,e,this._oneTimeListeners),this):new Promise((e=>{this.once(t,e);}))}fire(t,e){const r="string"==typeof t?new Qe(t,e):t,n=r.type;if(this.listens(n)){r.target=this;const t=this._listeners&&this._listeners[n]?this._listeners[n].slice():[];for(const e of t)e.call(this,r);const e=this._oneTimeListeners&&this._oneTimeListeners[n]?this._oneTimeListeners[n].slice():[];for(const t of e)rr(n,t,this._oneTimeListeners),t.call(this,r);const i=this._eventedParent;if(i){const t="function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData;Object.assign(r,t),i.fire(r);}}else r instanceof tr&&console.error(r.error);return this}listens(t){return !!(this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t))}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}class ir{constructor(t){"string"==typeof t?this.name=t:(this.name=t.name,this.iconsetId=t.iconsetId);}static from(t){return new ir(t)}static toString(t){return t.iconsetId?`${t.name}${t.iconsetId}`:t.name}static parse(t){const[e,r]=t.split("");return new ir({name:e,iconsetId:r})}static isEqual(t,e){return t.name===e.name&&t.iconsetId===e.iconsetId}toString(){return ir.toString(this)}serialize(){return {name:this.name,iconsetId:this.iconsetId}}}var sr,or={},ar=function(){if(sr)return or;sr=1;var t={transparent:[0,0,0,0],aliceblue:[240,248,255,1],antiquewhite:[250,235,215,1],aqua:[0,255,255,1],aquamarine:[127,255,212,1],azure:[240,255,255,1],beige:[245,245,220,1],bisque:[255,228,196,1],black:[0,0,0,1],blanchedalmond:[255,235,205,1],blue:[0,0,255,1],blueviolet:[138,43,226,1],brown:[165,42,42,1],burlywood:[222,184,135,1],cadetblue:[95,158,160,1],chartreuse:[127,255,0,1],chocolate:[210,105,30,1],coral:[255,127,80,1],cornflowerblue:[100,149,237,1],cornsilk:[255,248,220,1],crimson:[220,20,60,1],cyan:[0,255,255,1],darkblue:[0,0,139,1],darkcyan:[0,139,139,1],darkgoldenrod:[184,134,11,1],darkgray:[169,169,169,1],darkgreen:[0,100,0,1],darkgrey:[169,169,169,1],darkkhaki:[189,183,107,1],darkmagenta:[139,0,139,1],darkolivegreen:[85,107,47,1],darkorange:[255,140,0,1],darkorchid:[153,50,204,1],darkred:[139,0,0,1],darksalmon:[233,150,122,1],darkseagreen:[143,188,143,1],darkslateblue:[72,61,139,1],darkslategray:[47,79,79,1],darkslategrey:[47,79,79,1],darkturquoise:[0,206,209,1],darkviolet:[148,0,211,1],deeppink:[255,20,147,1],deepskyblue:[0,191,255,1],dimgray:[105,105,105,1],dimgrey:[105,105,105,1],dodgerblue:[30,144,255,1],firebrick:[178,34,34,1],floralwhite:[255,250,240,1],forestgreen:[34,139,34,1],fuchsia:[255,0,255,1],gainsboro:[220,220,220,1],ghostwhite:[248,248,255,1],gold:[255,215,0,1],goldenrod:[218,165,32,1],gray:[128,128,128,1],green:[0,128,0,1],greenyellow:[173,255,47,1],grey:[128,128,128,1],honeydew:[240,255,240,1],hotpink:[255,105,180,1],indianred:[205,92,92,1],indigo:[75,0,130,1],ivory:[255,255,240,1],khaki:[240,230,140,1],lavender:[230,230,250,1],lavenderblush:[255,240,245,1],lawngreen:[124,252,0,1],lemonchiffon:[255,250,205,1],lightblue:[173,216,230,1],lightcoral:[240,128,128,1],lightcyan:[224,255,255,1],lightgoldenrodyellow:[250,250,210,1],lightgray:[211,211,211,1],lightgreen:[144,238,144,1],lightgrey:[211,211,211,1],lightpink:[255,182,193,1],lightsalmon:[255,160,122,1],lightseagreen:[32,178,170,1],lightskyblue:[135,206,250,1],lightslategray:[119,136,153,1],lightslategrey:[119,136,153,1],lightsteelblue:[176,196,222,1],lightyellow:[255,255,224,1],lime:[0,255,0,1],limegreen:[50,205,50,1],linen:[250,240,230,1],magenta:[255,0,255,1],maroon:[128,0,0,1],mediumaquamarine:[102,205,170,1],mediumblue:[0,0,205,1],mediumorchid:[186,85,211,1],mediumpurple:[147,112,219,1],mediumseagreen:[60,179,113,1],mediumslateblue:[123,104,238,1],mediumspringgreen:[0,250,154,1],mediumturquoise:[72,209,204,1],mediumvioletred:[199,21,133,1],midnightblue:[25,25,112,1],mintcream:[245,255,250,1],mistyrose:[255,228,225,1],moccasin:[255,228,181,1],navajowhite:[255,222,173,1],navy:[0,0,128,1],oldlace:[253,245,230,1],olive:[128,128,0,1],olivedrab:[107,142,35,1],orange:[255,165,0,1],orangered:[255,69,0,1],orchid:[218,112,214,1],palegoldenrod:[238,232,170,1],palegreen:[152,251,152,1],paleturquoise:[175,238,238,1],palevioletred:[219,112,147,1],papayawhip:[255,239,213,1],peachpuff:[255,218,185,1],peru:[205,133,63,1],pink:[255,192,203,1],plum:[221,160,221,1],powderblue:[176,224,230,1],purple:[128,0,128,1],rebeccapurple:[102,51,153,1],red:[255,0,0,1],rosybrown:[188,143,143,1],royalblue:[65,105,225,1],saddlebrown:[139,69,19,1],salmon:[250,128,114,1],sandybrown:[244,164,96,1],seagreen:[46,139,87,1],seashell:[255,245,238,1],sienna:[160,82,45,1],silver:[192,192,192,1],skyblue:[135,206,235,1],slateblue:[106,90,205,1],slategray:[112,128,144,1],slategrey:[112,128,144,1],snow:[255,250,250,1],springgreen:[0,255,127,1],steelblue:[70,130,180,1],tan:[210,180,140,1],teal:[0,128,128,1],thistle:[216,191,216,1],tomato:[255,99,71,1],turquoise:[64,224,208,1],violet:[238,130,238,1],wheat:[245,222,179,1],white:[255,255,255,1],whitesmoke:[245,245,245,1],yellow:[255,255,0,1],yellowgreen:[154,205,50,1]};function e(t){return (t=Math.round(t))<0?0:t>255?255:t}function r(t){return e("%"===t[t.length-1]?parseFloat(t)/100*255:parseInt(t))}function n(t){return (e="%"===t[t.length-1]?parseFloat(t)/100:parseFloat(t))<0?0:e>1?1:e;var e;}function i(t,e,r){return r<0?r+=1:r>1&&(r-=1),6*r<1?t+(e-t)*r*6:2*r<1?e:3*r<2?t+(e-t)*(2/3-r)*6:t}try{or.parseCSSColor=function(s){var o,a=s.replace(/ /g,"").toLowerCase();if(a in t)return t[a].slice();if("#"===a[0])return 4===a.length?(o=parseInt(a.substr(1),16))>=0&&o<=4095?[(3840&o)>>4|(3840&o)>>8,240&o|(240&o)>>4,15&o|(15&o)<<4,1]:null:7===a.length&&(o=parseInt(a.substr(1),16))>=0&&o<=16777215?[(16711680&o)>>16,(65280&o)>>8,255&o,1]:null;var l=a.indexOf("("),u=a.indexOf(")");if(-1!==l&&u+1===a.length){var c=a.substr(0,l),h=a.substr(l+1,u-(l+1)).split(","),p=1;switch(c){case "rgba":if(4!==h.length)return null;p=n(h.pop());case "rgb":return 3!==h.length?null:[r(h[0]),r(h[1]),r(h[2]),p];case "hsla":if(4!==h.length)return null;p=n(h.pop());case "hsl":if(3!==h.length)return null;var d=(parseFloat(h[0])%360+360)%360/360,f=n(h[1]),m=n(h[2]),y=m<=.5?m*(f+1):m+f-m*f,g=2*m-y;return [e(255*i(g,y,d+1/3)),e(255*i(g,y,d)),e(255*i(g,y,d-1/3)),p];default:return null}}return null};}catch(t){}return or}();class lr{constructor(t,e,r,n=1){this.r=t,this.g=e,this.b=r,this.a=n;}static parse(t){if(!t)return;if(t instanceof lr)return t;if("string"!=typeof t)return;const e=ar.parseCSSColor(t);return e?new lr(e[0]/255,e[1]/255,e[2]/255,e[3]):void 0}toString(){const[t,e,r,n]=[this.r,this.g,this.b,this.a];return `rgba(${Math.round(255*t)},${Math.round(255*e)},${Math.round(255*r)},${n})`}toNonPremultipliedRenderColor(t){const{r:e,g:r,b:n,a:i}=this;return new cr(t,e,r,n,i)}toPremultipliedRenderColor(t){const{r:e,g:r,b:n,a:i}=this;return new hr(t,e*i,r*i,n*i,i)}clone(){return new lr(this.r,this.g,this.b,this.a)}}class ur{constructor(t,e,r,n,i,s=!1){if(this.premultiplied=!1,this.premultiplied=s,t){const s=t.image.height,o=s*s;this.premultiplied?(e=0===i?0:e/i*(s-1),r=0===i?0:r/i*(s-1),n=0===i?0:n/i*(s-1)):(e*=s-1,r*=s-1,n*=s-1);const a=Math.floor(e),l=Math.floor(r),u=Math.floor(n),c=Math.ceil(e),h=Math.ceil(r),p=Math.ceil(n),d=e-a,f=r-l,m=n-u,y=t.image.data,g=4*(a+l*o+u*s),x=4*(a+l*o+p*s),v=4*(a+h*o+u*s),b=4*(a+h*o+p*s),w=4*(c+l*o+u*s),_=4*(c+l*o+p*s),A=4*(c+h*o+u*s),I=4*(c+h*o+p*s);if(g<0||I>=y.length)throw new Error("out of range");this.r=pr(pr(pr(y[g],y[x],m),pr(y[v],y[b],m),f),pr(pr(y[w],y[_],m),pr(y[A],y[I],m),f),d)/255*(this.premultiplied?i:1),this.g=pr(pr(pr(y[g+1],y[x+1],m),pr(y[v+1],y[b+1],m),f),pr(pr(y[w+1],y[_+1],m),pr(y[A+1],y[I+1],m),f),d)/255*(this.premultiplied?i:1),this.b=pr(pr(pr(y[g+2],y[x+2],m),pr(y[v+2],y[b+2],m),f),pr(pr(y[w+2],y[_+2],m),pr(y[A+2],y[I+2],m),f),d)/255*(this.premultiplied?i:1),this.a=i;}else this.r=e,this.g=r,this.b=n,this.a=i;}toArray(){const{r:t,g:e,b:r,a:n}=this;return [255*t,255*e,255*r,n]}toHslaArray(){let{r:t,g:e,b:r,a:n}=this;if(this.premultiplied){if(0===n)return [0,0,0,0];const i=1/n;t*=i,e*=i,r*=i;}const i=Math.min(Math.max(t,0),1),s=Math.min(Math.max(e,0),1),o=Math.min(Math.max(r,0),1),a=Math.min(i,s,o),l=Math.max(i,s,o),u=l-a,c=.5*(a+l);if(0===u)return [0,0,100*c,n];const h=c>.5?u/(2-l-a):u/(l+a);let p;switch(l){case i:p=60*((s-o)/u+(s<o?6:0));break;case s:p=60*((o-i)/u+2);break;default:p=60*((i-s)/u+4);}return [p,100*h,100*c,n]}toArray01(){const{r:t,g:e,b:r,a:n}=this;return [t,e,r,n]}toArray01Scaled(t){const{r:e,g:r,b:n}=this;return [e*t,r*t,n*t]}toArray01Linear(){const{r:t,g:e,b:r,a:n}=this;return [Math.pow(t,2.2),Math.pow(e,2.2),Math.pow(r,2.2),n]}}class cr extends ur{constructor(t,e,r,n,i){super(t,e,r,n,i,!1);}}class hr extends ur{constructor(t,e,r,n,i){super(t,e,r,n,i,!0);}}function pr(t,e,r){return t*(1-r)+e*r}function dr(t,e,r){return t.map(((t,n)=>pr(t,e[n],r)))}lr.black=new lr(0,0,0,1),lr.white=new lr(1,1,1,1),lr.transparent=new lr(0,0,0,0),lr.red=new lr(1,0,0,1),lr.blue=new lr(0,0,1,1);var fr=Object.freeze({__proto__:null,array:dr,color:function(t,e,r){return new lr(pr(t.r,e.r,r),pr(t.g,e.g,r),pr(t.b,e.b,r),pr(t.a,e.a,r))},number:pr});class mr extends Error{constructor(t,e){super(e),this.message=e,this.key=t;}}class yr{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,r]of e)this.bindings[t]=r;}concat(t){return new yr(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return !!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const gr={kind:"null"},xr={kind:"number"},vr={kind:"string"},br={kind:"boolean"},wr={kind:"color"},_r={kind:"object"},Ar={kind:"value"},Ir={kind:"collator"},Mr={kind:"formatted"},Sr={kind:"resolvedImage"};function Pr(t,e){return {kind:"array",itemType:t,N:e}}function kr(t){if("array"===t.kind){const e=kr(t.itemType);return "number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const Br=[gr,xr,vr,br,wr,Mr,_r,Pr(Ar),Sr];function zr(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!zr(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else {if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of Br)if(!zr(t,e))return null}return `Expected ${kr(t)} but found ${kr(e)} instead.`}function Tr(t,e){return e.some((e=>e.kind===t.kind))}function Er(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}function Vr(t,e){return "array"===t.kind&&"array"===e.kind?t.N===e.N&&Vr(t.itemType,e.itemType):t.kind===e.kind}class Fr{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"});}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}class Cr{constructor(t,e,r,n,i){this.text=t.normalize?t.normalize():t,this.image=e,this.scale=r,this.fontStack=n,this.textColor=i;}}class Dr{constructor(t){this.sections=t;}static fromString(t){return new Dr([new Cr(t,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||!!t.image&&t.image.hasPrimary()))}static factory(t){return t instanceof Dr?t:Dr.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}serialize(){const t=["format"];for(const e of this.sections){if(e.image){const r=e.image.getPrimary().id.toString();t.push(["image",r]);continue}t.push(e.text);const r={};e.fontStack&&(r["text-font"]=["literal",e.fontStack.split(",")]),e.scale&&(r["font-scale"]=e.scale),e.textColor&&(r["text-color"]=["rgba"].concat(e.textColor.toNonPremultipliedRenderColor(null).toArray())),t.push(r);}return t}}class Rr{constructor(t,e={}){this.id=ir.from(t),this.params=e.params,this.sx=e.sx||1,this.sy=e.sy||1;}toString(){return JSON.stringify(this)}static parse(t){let e,r,n,i;try{({id:e,params:r,sx:n,sy:i}=JSON.parse(t)||{});}catch(t){return null}return e?new Rr(e,{params:r,sx:n,sy:i}):null}scaleSelf(t,e=t){return this.sx*=t,this.sy*=e,this}}class Lr{constructor(t,e,r,n,i=!1){this.primaryId=ir.from(t),this.primaryOptions=e,r&&(this.secondaryId=ir.from(r)),this.secondaryOptions=n,this.available=i;}toString(){return this.primaryId&&this.secondaryId?`[${this.primaryId.name},${this.secondaryId.name}]`:this.primaryId.name}hasPrimary(){return !!this.primaryId}getPrimary(){return new Rr(this.primaryId,this.primaryOptions)}hasSecondary(){return !!this.secondaryId}getSecondary(){return this.secondaryId?new Rr(this.secondaryId,this.secondaryOptions):null}static from(t){return "string"==typeof t?Lr.build({name:t}):t}static build(t,e,r,n){return !t||"object"==typeof t&&!("name"in t)?null:new Lr(t,r,e,n)}}function Or(t,e,r,n){return "number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function Ur(t){if(null===t)return !0;if("string"==typeof t)return !0;if("boolean"==typeof t)return !0;if("number"==typeof t)return !0;if(t instanceof lr)return !0;if(t instanceof Fr)return !0;if(t instanceof Dr)return !0;if(t instanceof Lr)return !0;if(Array.isArray(t)){for(const e of t)if(!Ur(e))return !1;return !0}if("object"==typeof t){for(const e in t)if(!Ur(t[e]))return !1;return !0}return !1}function Nr(t){if(null===t)return gr;if("string"==typeof t)return vr;if("boolean"==typeof t)return br;if("number"==typeof t)return xr;if(t instanceof lr)return wr;if(t instanceof Fr)return Ir;if(t instanceof Dr)return Mr;if(t instanceof Lr)return Sr;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=Nr(e);if(r){if(r===t)continue;r=Ar;break}r=t;}return Pr(r||Ar,e)}return _r}function jr(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof Dr||t instanceof Lr||t instanceof lr?t.toString():JSON.stringify(t)}class $r{constructor(t,e){this.type=t,this.value=e;}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!Ur(t[1]))return e.error("invalid value");const r=t[1];let n=Nr(r);const i=e.expectedType;return "array"!==n.kind||0!==n.N||!i||"array"!==i.kind||"number"==typeof i.N&&0!==i.N||(n=i),new $r(n,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return !0}serialize(){return "array"===this.type.kind||"object"===this.type.kind?["literal",this.value]:this.value instanceof lr?["rgba"].concat(this.value.toNonPremultipliedRenderColor(null).toArray()):this.value instanceof Dr?this.value.serialize():this.value}}class Gr{constructor(t){this.name="ExpressionEvaluationError",this.message=t;}toJSON(){return this.message}}const qr={string:vr,number:xr,boolean:br,object:_r};class Hr{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,n=1;const i=t[0];if("array"===i){let i,s;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in qr)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);i=qr[r],n++;}else i=Ar;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);s=t[2],n++;}r=Pr(i,s);}else r=qr[i];const s=[];for(;n<t.length;n++){const r=e.parse(t[n],n,Ar);if(!r)return null;s.push(r);}return new Hr(r,s)}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!zr(this.type,Nr(r)))return r;if(e===this.args.length-1)throw new Gr(`The expression ${JSON.stringify(this.args[e].serialize())} evaluated to ${kr(Nr(r))} but was expected to be of type ${kr(this.type)}.`)}return null}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){const t=this.type,e=[t.kind];if("array"===t.kind){const r=t.itemType;if("string"===r.kind||"number"===r.kind||"boolean"===r.kind){e.push(r.kind);const n=t.N;("number"==typeof n||this.args.length>1)&&e.push(n);}}return e.concat(this.args.map((t=>t.serialize())))}}class Xr{constructor(t){this.type=Mr,this.sections=t;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const n=[];let i=!1;for(let r=1;r<=t.length-1;++r){const s=t[r];if(i&&"object"==typeof s&&!Array.isArray(s)){i=!1;let t=null;if(s["font-scale"]&&(t=e.parseObjectValue(s["font-scale"],r,"font-scale",xr),!t))return null;let o=null;if(s["text-font"]&&(o=e.parseObjectValue(s["text-font"],r,"text-font",Pr(vr)),!o))return null;let a=null;if(s["text-color"]&&(a=e.parseObjectValue(s["text-color"],r,"text-color",wr),!a))return null;const l=n[n.length-1];l.scale=t,l.font=o,l.textColor=a;}else {const s=e.parse(t[r],r,Ar);if(!s)return null;const o=s.type.kind;if("string"!==o&&"value"!==o&&"null"!==o&&"resolvedImage"!==o)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");i=!0,n.push({content:s,scale:null,font:null,textColor:null});}}return new Xr(n)}evaluate(t){return new Dr(this.sections.map((e=>{const r=e.content.evaluate(t);return Vr(Nr(r),Sr)?new Cr("",r,null,null,null):new Cr(jr(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor);}outputDefined(){return !1}serialize(){const t=["format"];for(const e of this.sections){t.push(e.content.serialize());const r={};e.scale&&(r["font-scale"]=e.scale.serialize()),e.font&&(r["text-font"]=e.font.serialize()),e.textColor&&(r["text-color"]=e.textColor.serialize()),t.push(r);}return t}}class Zr{constructor(t,e,r,n){this._imageWarnHistory={},this.type=Sr,this.namePrimary=t,this.nameSecondary=e,r&&(this.paramsPrimary=r.params,this.iconsetIdPrimary=r.iconset?r.iconset.id:void 0),n&&(this.paramsSecondary=n.params,this.iconsetIdSecondary=n.iconset?n.iconset.id:void 0);}static parse(t,e){if(t.length<2)return e.error("Expected two or more arguments.");let r=1;const n=[];function i(){if(r<t.length){const i=e.parse(t[r],r++,vr);return i?(n.push({image:i,options:{}}),!0):(e.error(n.length?"Secondary image variant is not a string.":"No image name provided."),!1)}return !0}function s(){if(r<t.length){const s=t[r];if(null===(i=s)||"object"!=typeof i||Array.isArray(i))return !0;const o=s.params,a=s.iconset,l=e.concat(r);if(!o&&!a)return r++,!0;if(o){if("object"!=typeof o||o.constructor!==Object)return l.error('Image options "params" should be an object'),!1;const t={},e=l.concat(void 0,"params");for(const r in o){if(!r)return e.error("Image parameter name should be non-empty"),!1;const n=e.concat(void 0,r).parse(o[r],void 0,wr,void 0,{typeAnnotation:"coerce"});if(!n)return !1;t[r]=n;}n[n.length-1].options.params=t;}if(a){if("object"!=typeof a||a.constructor!==Object)return l.error('Image options "iconset" should be an object'),!1;if(!a.id)return l.error('Image options "iconset" should have an "id" property'),!1;n[n.length-1].options.iconset=a;}return r++,!0}var i;return !0}for(let t=0;t<2;t++)if(!i()||!s())return;return new Zr(n[0].image,n[1]?n[1].image:void 0,n[0].options,n[1]?n[1].options:void 0)}evaluateParams(t,e){const r={};if(e){for(const n in e)if(e[n])try{r[n]=e[n].evaluate(t);}catch(t){continue}if(0!==Object.keys(r).length)return {params:r}}}evaluate(t){const e={name:this.namePrimary.evaluate(t),iconsetId:this.iconsetIdPrimary},r=this.nameSecondary?{name:this.nameSecondary.evaluate(t),iconsetId:this.iconsetIdSecondary}:void 0,n=Lr.build(e,r,this.paramsPrimary?this.evaluateParams(t,this.paramsPrimary):void 0,this.paramsSecondary?this.evaluateParams(t,this.paramsSecondary):void 0);if(n&&t.availableImages){const e=n.getPrimary().id;if(n.available=t.availableImages.some((t=>ir.isEqual(t,e))),n.available){const e=n.getSecondary()?n.getSecondary().id:null;e&&(n.available=t.availableImages.some((t=>ir.isEqual(t,e))));}}return n}eachChild(t){if(t(this.namePrimary),this.paramsPrimary)for(const e in this.paramsPrimary)this.paramsPrimary[e]&&t(this.paramsPrimary[e]);if(this.nameSecondary&&(t(this.nameSecondary),this.paramsSecondary))for(const e in this.paramsSecondary)this.paramsSecondary[e]&&t(this.paramsSecondary[e]);}outputDefined(){return !1}serializeOptions(t,e){const r={};if(e&&(r.iconset={id:e}),t){r.params={};for(const e in t)t[e]&&(r.params[e]=t[e].serialize());}return Object.keys(r).length>0?r:void 0}serialize(){const t=["image",this.namePrimary.serialize()];if(this.paramsPrimary||this.iconsetIdPrimary){const e=this.serializeOptions(this.paramsPrimary,this.iconsetIdPrimary);e&&t.push(e);}if(this.nameSecondary&&(t.push(this.nameSecondary.serialize()),this.paramsSecondary||this.iconsetIdSecondary)){const e=this.serializeOptions(this.paramsSecondary,this.iconsetIdSecondary);e&&t.push(e);}return t}}function Wr(t){return Kr(t)?"string":Jr(t)?"number":Qr(t)?"boolean":Array.isArray(t)?"array":null===t?"null":Yr(t)?"object":typeof t}function Yr(t){return null!=t&&!Array.isArray(t)&&"function"!=typeof t&&!(t instanceof String||t instanceof Number||t instanceof Boolean)&&"object"==typeof t}function Kr(t){return "string"==typeof t||t instanceof String}function Jr(t){return "number"==typeof t||t instanceof Number}function Qr(t){return "boolean"==typeof t||t instanceof Boolean}const tn={"to-boolean":br,"to-color":wr,"to-number":xr,"to-string":vr};class en{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0],n=[];let i=gr;if("to-array"===r){if(!Array.isArray(t[1]))return null;const r=t[1].length;if(e.expectedType){if("array"!==e.expectedType.kind)return e.error(`Expected ${e.expectedType.kind} but found array.`);i=Pr(e.expectedType.itemType,r);}else {if(!(r>0&&Ur(t[1][0])))return null;i=Pr(Nr(t[1][0]),r);}for(let s=0;s<r;s++){const r=t[1][s];let o;if(Array.isArray(r))o=e.parse(r,void 0,i.itemType);else {const t=Wr(r);if(t!==i.itemType.kind)return e.error(`Expected ${i.itemType.kind} but found ${t}.`);o=e.registry.literal.parse(["literal",void 0===r?null:r],e);}if(!o)return null;n.push(o);}}else {if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");i=tn[r];for(let r=1;r<t.length;r++){const i=e.parse(t[r],r,Ar);if(!i)return null;n.push(i);}}return new en(i,n)}evaluate(t){if("boolean"===this.type.kind)return Boolean(this.args[0].evaluate(t));if("color"===this.type.kind){let e,r;for(const n of this.args){if(e=n.evaluate(t),r=null,e instanceof lr)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rbga value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:Or(e[0],e[1],e[2],e[3]),!r))return new lr(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new Gr(r||`Could not parse color from value '${"string"==typeof e?e:String(JSON.stringify(e))}'`)}if("number"===this.type.kind){let e=null;for(const r of this.args){if(e=r.evaluate(t),null===e)return 0;const n=Number(e);if(!isNaN(n))return n}throw new Gr(`Could not convert ${JSON.stringify(e)} to number.`)}return "formatted"===this.type.kind?Dr.fromString(jr(this.args[0].evaluate(t))):"resolvedImage"===this.type.kind?Lr.build(jr(this.args[0].evaluate(t))):"array"===this.type.kind?this.args.map((e=>e.evaluate(t))):jr(this.args[0].evaluate(t))}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){if("formatted"===this.type.kind)return new Xr([{content:this.args[0],scale:null,font:null,textColor:null}]).serialize();if("resolvedImage"===this.type.kind)return new Zr(this.args[0]).serialize();const t="array"===this.type.kind?[]:[`to-${this.type.kind}`];return this.eachChild((e=>{t.push(e.serialize());})),t}}const rn=["Unknown","Point","LineString","Polygon"];class nn{constructor(t,e,r){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache={},this.availableImages=null,this.canonical=null,this.featureTileCoord=null,this.featureDistanceData=null,this.scope=t,this.options=e,this.iconImageUseTheme=r;}id(){return this.feature&&void 0!==this.feature.id?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?rn[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}measureLight(t){return this.globals.brightness||0}distanceFromCenter(){if(this.featureTileCoord&&this.featureDistanceData){const t=this.featureDistanceData.center,e=this.featureDistanceData.scale,{x:r,y:n}=this.featureTileCoord;return this.featureDistanceData.bearing[0]*(r*e-t[0])+this.featureDistanceData.bearing[1]*(n*e-t[1])}return 0}parseColor(t){let e=this._parseColorCache[t];return e||(e=this._parseColorCache[t]=lr.parse(t)),e}getConfig(t){return this.options?this.options.get(t):null}}class sn{constructor(t,e,r,n,i){this.name=t,this.type=e,this._evaluate=r,this.args=n,this._overloadIndex=i;}evaluate(t){if(!this._evaluate){const t=sn.definitions[this.name];this._evaluate=Array.isArray(t)?t[2]:t.overloads[this._overloadIndex][1];}return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t);}outputDefined(){return !1}serialize(){return [this.name].concat(this.args.map((t=>t.serialize())))}static parse(t,e){const r=t[0],n=sn.definitions[r];if(!n)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const i=Array.isArray(n)?n[0]:n.type,s=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,o=[];let a=null,l=-1;for(const[n,u]of s){if(Array.isArray(n)&&n.length!==t.length-1)continue;o.push(n),l++,a=new Mi(e.registry,e.path,null,e.scope,void 0,e._scope,e.options,e.iconImageUseTheme);const s=[];let c=!1;for(let e=1;e<t.length;e++){const r=t[e],i=Array.isArray(n)?n[e-1]:n.type,o=a.parse(r,1+s.length,i);if(!o){c=!0;break}s.push(o);}if(!c)if(Array.isArray(n)&&n.length!==s.length)a.error(`Expected ${n.length} arguments, but found ${s.length} instead.`);else {for(let t=0;t<s.length;t++){const e=Array.isArray(n)?n[t]:n.type,r=s[t];a.concat(t+1).checkSubtype(e,r.type);}if(0===a.errors.length)return new sn(r,i,u,s,l)}}if(1===o.length)e.errors.push(...a.errors);else {const r=(o.length?o:s.map((([t])=>t))).map(on).join(" | "),n=[];for(let r=1;r<t.length;r++){const i=e.parse(t[r],1+n.length);if(!i)return null;n.push(kr(i.type));}e.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`);}return null}static register(t,e){sn.definitions=e;for(const r in e)t[r]=sn;}}function on(t){return Array.isArray(t)?`(${t.map(kr).join(", ")})`:`(${kr(t.type)}...)`}class an{constructor(t,e,r){this.type=Ir,this.locale=r,this.caseSensitive=t,this.diacriticSensitive=e;}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const n=void 0===r["case-sensitive"]?e.parse(!1,1,br):e.parseObjectValue(r["case-sensitive"],1,"case-sensitive",br);if(!n)return null;const i=void 0===r["diacritic-sensitive"]?e.parse(!1,1,br):e.parseObjectValue(r["diacritic-sensitive"],1,"diacritic-sensitive",br);if(!i)return null;let s=null;return r.locale&&(s=e.parseObjectValue(r.locale,1,"locale",vr),!s)?null:new an(n,i,s)}evaluate(t){return new Fr(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale);}outputDefined(){return !1}serialize(){const t={};return t["case-sensitive"]=this.caseSensitive.serialize(),t["diacritic-sensitive"]=this.diacriticSensitive.serialize(),this.locale&&(t.locale=this.locale.serialize()),["collator",t]}}function ln(t,e,r=0,n=t.length-1,i=cn){for(;n>r;){if(n-r>600){const s=n-r+1,o=e-r+1,a=Math.log(s),l=.5*Math.exp(2*a/3),u=.5*Math.sqrt(a*l*(s-l)/s)*(o-s/2<0?-1:1);ln(t,e,Math.max(r,Math.floor(e-o*l/s+u)),Math.min(n,Math.floor(e+(s-o)*l/s+u)),i);}const s=t[e];let o=r,a=n;for(un(t,r,e),i(t[n],s)>0&&un(t,r,n);o<a;){for(un(t,o,a),o++,a--;i(t[o],s)<0;)o++;for(;i(t[a],s)>0;)a--;}0===i(t[r],s)?un(t,r,a):(a++,un(t,a,n)),a<=e&&(r=a+1),e<=a&&(n=a-1);}}function un(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function cn(t,e){return t<e?-1:t>e?1:0}function hn(t){let e=0;for(let r,n,i=0,s=t.length,o=s-1;i<s;o=i++)r=t[i],n=t[o],e+=(n.x-r.x)*(r.y+n.y);return e}function pn(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1]);}function dn(t,e){return !(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function fn(t,e,r){const n=t[0]-e[0],i=t[1]-e[1],s=t[0]-r[0],o=t[1]-r[1];return n*o-s*i==0&&n*s<=0&&i*o<=0}function mn(t,e,r=!1){let n=!1;for(let a=0,l=e.length;a<l;a++){const l=e[a];for(let e=0,a=l.length,u=a-1;e<a;u=e++){const a=l[u],c=l[e];if(fn(t,a,c))return r;(s=a)[1]>(i=t)[1]!=(o=c)[1]>i[1]&&i[0]<(o[0]-s[0])*(i[1]-s[1])/(o[1]-s[1])+s[0]&&(n=!n);}}var i,s,o;return n}function yn(t,e,r,n){const i=n[0]-r[0],s=n[1]-r[1],o=(t[0]-r[0])*s-i*(t[1]-r[1]),a=(e[0]-r[0])*s-i*(e[1]-r[1]);return o>0&&a<0||o<0&&a>0}function gn(t,e,r,n){return 0!=(i=[n[0]-r[0],n[1]-r[1]])[0]*(s=[e[0]-t[0],e[1]-t[1]])[1]-i[1]*s[0]&&!(!yn(t,e,r,n)||!yn(r,n,t,e));var i,s;}function xn(t){const e=new It(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY),r=new It(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY);for(const n of t[0])e.x>n.x&&(e.x=n.x),e.y>n.y&&(e.y=n.y),r.x<n.x&&(r.x=n.x),r.y<n.y&&(r.y=n.y);return {min:e,max:r}}const vn=8192;function bn(t,e){const r=(180+t[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,i=Math.pow(2,e.z);return [Math.round(r*i*vn),Math.round(n*i*vn)]}function wn(t,e){for(let r=0;r<e.length;r++)if(mn(t,e[r]))return !0;return !1}function _n(t,e,r){for(const n of r)for(let r=0,i=n.length,s=i-1;r<i;s=r++)if(gn(t,e,n[s],n[r]))return !0;return !1}function An(t,e){for(let r=0;r<t.length;++r)if(!mn(t[r],e))return !1;for(let r=0;r<t.length-1;++r)if(_n(t[r],t[r+1],e))return !1;return !0}function In(t,e){for(let r=0;r<e.length;r++)if(An(t,e[r]))return !0;return !1}function Mn(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=[];for(let n=0;n<t[i].length;n++){const o=bn(t[i][n],r);pn(e,o),s.push(o);}n.push(s);}return n}function Sn(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=Mn(t[i],e,r);n.push(s);}return n}function Pn(t,e,r,n){if(t[0]<r[0]||t[0]>r[2]){const e=.5*n;let i=t[0]-r[0]>e?-n:r[0]-t[0]>e?n:0;0===i&&(i=t[0]-r[2]>e?-n:r[2]-t[0]>e?n:0),t[0]+=i;}pn(e,t);}function kn(t,e,r,n){const i=Math.pow(2,n.z)*vn,s=[n.x*vn,n.y*vn],o=[];if(!t)return o;for(const n of t)for(const t of n){const n=[t.x+s[0],t.y+s[1]];Pn(n,e,r,i),o.push(n);}return o}function Bn(t,e,r,n){const i=Math.pow(2,n.z)*vn,s=[n.x*vn,n.y*vn],o=[];if(!t)return o;for(const r of t){const t=[];for(const n of r){const r=[n.x+s[0],n.y+s[1]];pn(e,r),t.push(r);}o.push(t);}if(e[2]-e[0]<=i/2){(a=e)[0]=a[1]=1/0,a[2]=a[3]=-1/0;for(const t of o)for(const n of t)Pn(n,e,r,i);}var a;return o}class zn{constructor(t,e){this.type=br,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Ur(t[1])){const e=t[1];if("FeatureCollection"===e.type)for(let t=0;t<e.features.length;++t){const r=e.features[t].geometry.type;if("Polygon"===r||"MultiPolygon"===r)return new zn(e,e.features[t].geometry)}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new zn(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new zn(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if(!i)return !1;if("Polygon"===e.type){const s=Mn(e.coordinates,n,i),o=kn(t.geometry(),r,n,i);if(!dn(r,n))return !1;for(const t of o)if(!mn(t,s))return !1}if("MultiPolygon"===e.type){const s=Sn(e.coordinates,n,i),o=kn(t.geometry(),r,n,i);if(!dn(r,n))return !1;for(const t of o)if(!wn(t,s))return !1}return !0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if(!i)return !1;if("Polygon"===e.type){const s=Mn(e.coordinates,n,i),o=Bn(t.geometry(),r,n,i);if(!dn(r,n))return !1;for(const t of o)if(!An(t,s))return !1}if("MultiPolygon"===e.type){const s=Sn(e.coordinates,n,i),o=Bn(t.geometry(),r,n,i);if(!dn(r,n))return !1;for(const t of o)if(!In(t,s))return !1}return !0}(t,this.geometries)}return !1}eachChild(){}outputDefined(){return !0}serialize(){return ["within",this.geojson]}}const Tn={kilometers:1,miles:1e3/1609.344,nauticalmiles:1e3/1852,meters:1e3,metres:1e3,yards:1e3/.9144,feet:1e3/.3048,inches:1e3/.0254},En=1/298.257223563,Vn=En*(2-En),Fn=Math.PI/180;class Cn{static fromTile(t,e,r){const n=Math.PI*(1-2*(t+.5)/Math.pow(2,e)),i=Math.atan(.5*(Math.exp(n)-Math.exp(-n)))/Fn;return new Cn(i,r)}static get units(){return Tn}constructor(t,e){if(void 0===t)throw new Error("No latitude given.");if(e&&!Tn[e])throw new Error(`Unknown unit ${e}. Use one of: ${Object.keys(Tn).join(", ")}`);const r=6378.137*Fn*(e?Tn[e]:1),n=Math.cos(t*Fn),i=1/(1-Vn*(1-n*n)),s=Math.sqrt(i);this.kx=r*s*n,this.ky=r*s*i*(1-Vn);}distance(t,e){const r=Ln(t[0]-e[0])*this.kx,n=(t[1]-e[1])*this.ky;return Math.sqrt(r*r+n*n)}bearing(t,e){const r=Ln(e[0]-t[0])*this.kx;return Math.atan2(r,(e[1]-t[1])*this.ky)/Fn}destination(t,e,r){const n=r*Fn;return this.offset(t,Math.sin(n)*e,Math.cos(n)*e)}offset(t,e,r){return [t[0]+e/this.kx,t[1]+r/this.ky]}lineDistance(t){let e=0;for(let r=0;r<t.length-1;r++)e+=this.distance(t[r],t[r+1]);return e}area(t){let e=0;for(let r=0;r<t.length;r++){const n=t[r];for(let t=0,i=n.length,s=i-1;t<i;s=t++)e+=Ln(n[t][0]-n[s][0])*(n[t][1]+n[s][1])*(r?-1:1);}return Math.abs(e)/2*this.kx*this.ky}along(t,e){let r=0;if(e<=0)return t[0];for(let n=0;n<t.length-1;n++){const i=t[n],s=t[n+1],o=this.distance(i,s);if(r+=o,r>e)return Rn(i,s,(e-(r-o))/o)}return t[t.length-1]}pointToSegmentDistance(t,e,r){let[n,i]=e,s=Ln(r[0]-n)*this.kx,o=(r[1]-i)*this.ky;if(0!==s||0!==o){const e=(Ln(t[0]-n)*this.kx*s+(t[1]-i)*this.ky*o)/(s*s+o*o);e>1?(n=r[0],i=r[1]):e>0&&(n+=s/this.kx*e,i+=o/this.ky*e);}return s=Ln(t[0]-n)*this.kx,o=(t[1]-i)*this.ky,Math.sqrt(s*s+o*o)}pointOnLine(t,e){let r=1/0,n=t[0][0],i=t[0][1],s=0,o=0;for(let a=0;a<t.length-1;a++){let l=t[a][0],u=t[a][1],c=Ln(t[a+1][0]-l)*this.kx,h=(t[a+1][1]-u)*this.ky,p=0;0===c&&0===h||(p=(Ln(e[0]-l)*this.kx*c+(e[1]-u)*this.ky*h)/(c*c+h*h),p>1?(l=t[a+1][0],u=t[a+1][1]):p>0&&(l+=c/this.kx*p,u+=h/this.ky*p)),c=Ln(e[0]-l)*this.kx,h=(e[1]-u)*this.ky;const d=c*c+h*h;d<r&&(r=d,n=l,i=u,s=a,o=p);}return {point:[n,i],index:s,t:Math.max(0,Math.min(1,o))}}lineSlice(t,e,r){let n=this.pointOnLine(r,t),i=this.pointOnLine(r,e);if(n.index>i.index||n.index===i.index&&n.t>i.t){const t=n;n=i,i=t;}const s=[n.point],o=n.index+1,a=i.index;!Dn(r[o],s[0])&&o<=a&&s.push(r[o]);for(let t=o+1;t<=a;t++)s.push(r[t]);return Dn(r[a],i.point)||s.push(i.point),s}lineSliceAlong(t,e,r){let n=0;const i=[];for(let s=0;s<r.length-1;s++){const o=r[s],a=r[s+1],l=this.distance(o,a);if(n+=l,n>t&&0===i.length&&i.push(Rn(o,a,(t-(n-l))/l)),n>=e)return i.push(Rn(o,a,(e-(n-l))/l)),i;n>t&&i.push(a);}return i}bufferPoint(t,e){const r=e/this.ky,n=e/this.kx;return [t[0]-n,t[1]-r,t[0]+n,t[1]+r]}bufferBBox(t,e){const r=e/this.ky,n=e/this.kx;return [t[0]-n,t[1]-r,t[2]+n,t[3]+r]}insideBBox(t,e){return Ln(t[0]-e[0])>=0&&Ln(t[0]-e[2])<=0&&t[1]>=e[1]&&t[1]<=e[3]}}function Dn(t,e){return t[0]===e[0]&&t[1]===e[1]}function Rn(t,e,r){const n=Ln(e[0]-t[0]);return [t[0]+n*r,t[1]+(e[1]-t[1])*r]}function Ln(t){for(;t<-180;)t+=360;for(;t>180;)t-=360;return t}class On{constructor(t=[],e=((t,e)=>t<e?-1:t>e?1:0)){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this._up(this.length++);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return --this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i;}e[t]=n;}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1);const s=n+1;if(s<this.length&&r(e[s],e[n])<0&&(n=s),r(e[n],i)>=0)break;e[t]=e[n],t=n;}e[t]=i;}}var Un=8192;function Nn(t,e){return e.dist-t.dist}const jn=100,$n=50;function Gn(t){const e=[1/0,1/0,-1/0,-1/0];if(e.length!==t.length)return !1;for(let r=0;r<e.length;r++)if(e[r]!==t[r])return !1;return !0}function qn(t){return t[1]-t[0]+1}function Hn(t,e){const r=t[1]>=t[0]&&t[1]<e;return r||console.warn("Distance Expression: Index is out of range"),r}function Xn(t,e){if(t[0]>t[1])return [null,null];const r=qn(t);if(e){if(2===r)return [t,null];const e=Math.floor(r/2);return [[t[0],t[0]+e],[t[0]+e,t[1]]]}{if(1===r)return [t,null];const e=Math.floor(r/2)-1;return [[t[0],t[0]+e],[t[0]+e+1,t[1]]]}}function Zn(t,e){const r=[1/0,1/0,-1/0,-1/0];if(!Hn(e,t.length))return r;for(let n=e[0];n<=e[1];++n)pn(r,t[n]);return r}function Wn(t){const e=[1/0,1/0,-1/0,-1/0];for(let r=0;r<t.length;++r)for(let n=0;n<t[r].length;++n)pn(e,t[r][n]);return e}function Yn(t,e,r){if(Gn(t)||Gn(e))return NaN;let n=0,i=0;return t[2]<e[0]&&(n=e[0]-t[2]),t[0]>e[2]&&(n=t[0]-e[2]),t[1]>e[3]&&(i=t[1]-e[3]),t[3]<e[1]&&(i=e[1]-t[3]),r.distance([0,0],[n,i])}function Kn(t){return 360*t-180}function Jn(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function Qn(t,e){const r=Math.pow(2,e.z),n=(t.y/Un+e.y)/r;return [Kn((t.x/Un+e.x)/r),Jn(n)]}function ti(t,e){const r=[];for(let n=0;n<t.length;++n)r.push(Qn(t[n],e));return r}function ei(t,e,r){const n=r.pointOnLine(e,t).point;return r.distance(t,n)}function ri(t,e,r,n,i){const s=r.slice(n[0],n[1]+1);let o=1/0;for(let r=e[0];r<=e[1];++r)if(0===(o=Math.min(o,ei(t[r],s,i))))return 0;return o}function ni(t,e,r,n,i){const s=Math.min(i.pointToSegmentDistance(t,r,n),i.pointToSegmentDistance(e,r,n)),o=Math.min(i.pointToSegmentDistance(r,t,e),i.pointToSegmentDistance(n,t,e));return Math.min(s,o)}function ii(t,e,r,n,i){if(!Hn(e,t.length)||!Hn(n,r.length))return NaN;let s=1/0;for(let o=e[0];o<e[1];++o)for(let e=n[0];e<n[1];++e){if(gn(t[o],t[o+1],r[e],r[e+1]))return 0;s=Math.min(s,ni(t[o],t[o+1],r[e],r[e+1],i));}return s}function si(t,e,r,n,i){if(!Hn(e,t.length)||!Hn(n,r.length))return NaN;let s=1/0;for(let o=e[0];o<=e[1];++o)for(let e=n[0];e<=n[1];++e)if(0===(s=Math.min(s,i.distance(t[o],r[e]))))return s;return s}function oi(t,e,r){if(mn(t,e,!0))return 0;let n=1/0;for(const i of e){const e=i.length;if(e<2)return console.warn("Distance Expression: Invalid polygon!"),NaN;if(i[0]!==i[e-1]&&0===(n=Math.min(n,r.pointToSegmentDistance(t,i[e-1],i[0]))))return n;if(0===(n=Math.min(n,ei(t,i,r))))return n}return n}function ai(t,e,r,n){if(!Hn(e,t.length))return NaN;for(let n=e[0];n<=e[1];++n)if(mn(t[n],r,!0))return 0;let i=1/0;for(let s=e[0];s<e[1];++s)for(const e of r)for(let r=0,o=e.length,a=o-1;r<o;a=r++){if(gn(t[s],t[s+1],e[a],e[r]))return 0;i=Math.min(i,ni(t[s],t[s+1],e[a],e[r],n));}return i}function li(t,e){for(const r of t)for(let t=0;t<=r.length-1;++t)if(mn(r[t],e,!0))return !0;return !1}function ui(t,e,r,n=1/0){const i=Wn(t),s=Wn(e);if(n!==1/0&&Yn(i,s,r)>=n)return n;if(dn(i,s)){if(li(t,e))return 0}else if(li(e,t))return 0;let o=n;for(const n of t)for(let t=0,i=n.length,s=i-1;t<i;s=t++)for(const i of e)for(let e=0,a=i.length,l=a-1;e<a;l=e++){if(gn(n[s],n[t],i[l],i[e]))return 0;o=Math.min(o,ni(n[s],n[t],i[l],i[e],r));}return o}function ci(t,e,r,n,i,s,o){if(null===s||null===o)return;const a=Yn(Zn(n,s),Zn(i,o),r);a<e&&t.push({dist:a,range1:s,range2:o});}function hi(t,e,r,n,i=1/0){let s=Math.min(n.distance(t[0],r[0][0]),i);if(0===s)return s;const o=new On([{dist:0,range1:[0,t.length-1],range2:[0,0]}],Nn),a=e?$n:jn,l=Wn(r);for(;o.length;){const i=o.pop();if(i.dist>=s)continue;const u=i.range1;if(qn(u)<=a){if(!Hn(u,t.length))return NaN;if(e){const e=ai(t,u,r,n);if(0===(s=Math.min(s,e)))return s}else for(let e=u[0];e<=u[1];++e){const i=oi(t[e],r,n);if(0===(s=Math.min(s,i)))return s}}else {const r=Xn(u,e);if(null!==r[0]){const e=Yn(Zn(t,r[0]),l,n);e<s&&o.push({dist:e,range1:r[0],range2:[0,0]});}if(null!==r[1]){const e=Yn(Zn(t,r[1]),l,n);e<s&&o.push({dist:e,range1:r[1],range2:[0,0]});}}}return s}function pi(t,e,r,n,i,s=1/0){let o=Math.min(s,i.distance(t[0],r[0]));if(0===o)return o;const a=new On([{dist:0,range1:[0,t.length-1],range2:[0,r.length-1]}],Nn),l=e?$n:jn,u=n?$n:jn;for(;a.length;){const s=a.pop();if(s.dist>=o)continue;const c=s.range1,h=s.range2;if(qn(c)<=l&&qn(h)<=u){if(!Hn(c,t.length)||!Hn(h,r.length))return NaN;if(e&&n?o=Math.min(o,ii(t,c,r,h,i)):e||n?e&&!n?o=Math.min(o,ri(r,h,t,c,i)):!e&&n&&(o=Math.min(o,ri(t,c,r,h,i))):o=Math.min(o,si(t,c,r,h,i)),0===o)return o}else {const s=Xn(c,e),l=Xn(h,n);ci(a,o,i,t,r,s[0],l[0]),ci(a,o,i,t,r,s[0],l[1]),ci(a,o,i,t,r,s[1],l[0]),ci(a,o,i,t,r,s[1],l[1]);}}return o}function di(t,e,r,n,i=1/0){let s=i;const o=Zn(t,[0,t.length-1]);for(const i of r)if(!(s!==1/0&&Yn(o,Zn(i,[0,i.length-1]),n)>=s)&&(s=Math.min(s,pi(t,e,i,!0,n,s)),0===s))return s;return s}function fi(t,e,r,n,i=1/0){let s=i;const o=Zn(t,[0,t.length-1]);for(const i of r){if(s!==1/0&&Yn(o,Wn(i),n)>=s)continue;const r=hi(t,e,i,n,s);if(isNaN(r))return r;if(0===(s=Math.min(s,r)))return s}return s}function mi(t){return "Point"===t||"MultiPoint"===t||"LineString"===t||"MultiLineString"===t||"Polygon"===t||"MultiPolygon"===t}class yi{constructor(t,e){this.type=xr,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'distance' expression requires either one argument, but found ' ${t.length-1} instead.`);if(Ur(t[1])){const e=t[1];if("FeatureCollection"===e.type){for(let t=0;t<e.features.length;++t)if(mi(e.features[t].geometry.type))return new yi(e,e.features[t].geometry)}else if("Feature"===e.type){if(mi(e.geometry.type))return new yi(e,e.geometry)}else if(mi(e.type))return new yi(e,e)}return e.error("'distance' expression needs to be an array with format ['Distance', GeoJSONObj].")}evaluate(t){const e=t.geometry(),r=t.canonicalID();if(null!=e&&null!=r){if("Point"===t.geometryType())return function(t,e,r){const n=[];for(const r of t)for(const t of r)n.push(Qn(t,e));const i=new Cn(n[0][1],"meters");return "Point"===r.type||"MultiPoint"===r.type||"LineString"===r.type?pi(n,!1,"Point"===r.type?[r.coordinates]:r.coordinates,"LineString"===r.type,i):"MultiLineString"===r.type?di(n,!1,r.coordinates,i):"Polygon"===r.type||"MultiPolygon"===r.type?fi(n,!1,"Polygon"===r.type?[r.coordinates]:r.coordinates,i):null}(e,r,this.geometries);if("LineString"===t.geometryType())return function(t,e,r){const n=[];for(const r of t){const t=[];for(const n of r)t.push(Qn(n,e));n.push(t);}const i=new Cn(n[0][0][1],"meters");if("Point"===r.type||"MultiPoint"===r.type||"LineString"===r.type)return di("Point"===r.type?[r.coordinates]:r.coordinates,"LineString"===r.type,n,i);if("MultiLineString"===r.type){let t=1/0;for(let e=0;e<r.coordinates.length;e++){const s=di(r.coordinates[e],!0,n,i,t);if(isNaN(s))return s;if(0===(t=Math.min(t,s)))return t}return t}if("Polygon"===r.type||"MultiPolygon"===r.type){let t=1/0;for(let e=0;e<n.length;e++){const s=fi(n[e],!0,"Polygon"===r.type?[r.coordinates]:r.coordinates,i,t);if(isNaN(s))return s;if(0===(t=Math.min(t,s)))return t}return t}return null}(e,r,this.geometries);if("Polygon"===t.geometryType())return function(t,e,r){const n=[];for(const r of function(t,e){const r=t.length;if(r<=1)return [t];const n=[];let i,s;for(let e=0;e<r;e++){const r=hn(t[e]);0!==r&&(t[e].area=Math.abs(r),void 0===s&&(s=r<0),s===r<0?(i&&n.push(i),i=[t[e]]):i.push(t[e]));}return i&&n.push(i),n}(t)){const t=[];for(let n=0;n<r.length;++n)t.push(ti(r[n],e));n.push(t);}const i=new Cn(n[0][0][0][1],"meters");if("Point"===r.type||"MultiPoint"===r.type||"LineString"===r.type)return fi("Point"===r.type?[r.coordinates]:r.coordinates,"LineString"===r.type,n,i);if("MultiLineString"===r.type){let t=1/0;for(let e=0;e<r.coordinates.length;e++){const s=fi(r.coordinates[e],!0,n,i,t);if(isNaN(s))return s;if(0===(t=Math.min(t,s)))return t}return t}return "Polygon"===r.type||"MultiPolygon"===r.type?function(t,e,r){let n=1/0;for(const i of t)for(const t of e){const e=ui(i,t,r,n);if(isNaN(e))return e;if(0===(n=Math.min(n,e)))return n}return n}("Polygon"===r.type?[r.coordinates]:r.coordinates,n,i):null}(e,r,this.geometries);console.warn("Distance Expression: currently only evaluates valid Point/LineString/Polygon geometries.");}else console.warn("Distance Expression: requirs valid feature and canonical information.");return null}eachChild(){}outputDefined(){return !0}serialize(){return ["distance",this.geojson]}}function gi(t){if(t instanceof sn){if("get"===t.name&&1===t.args.length)return !1;if("feature-state"===t.name)return !1;if("has"===t.name&&1===t.args.length)return !1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return !1;if(/^filter-/.test(t.name))return !1}if(t instanceof zn)return !1;if(t instanceof yi)return !1;if(t instanceof Ai)return t.featureConstant;let e=!0;return t.eachChild((t=>{e&&!gi(t)&&(e=!1);})),e}function xi(t){if(t instanceof sn&&"feature-state"===t.name)return !1;let e=!0;return t.eachChild((t=>{e&&!xi(t)&&(e=!1);})),e}function vi(t,e){if(t instanceof sn&&e.indexOf(t.name)>=0)return !1;let r=!0;return t.eachChild((t=>{r&&!vi(t,e)&&(r=!1);})),r}function bi(t,e,r){return [t,e,r].filter(Boolean).join("")}function wi(t,e){switch(t){case "string":return jr(e);case "number":return +e;case "boolean":return !!e;case "color":return lr.parse(e);case "formatted":return Dr.fromString(jr(e));case "resolvedImage":return Lr.build(jr(e))}return e}function _i(t,e,r,n){return void 0!==n&&(t=n*Math.round(t/n)),void 0!==e&&t<e&&(t=e),void 0!==r&&t>r&&(t=r),t}class Ai{constructor(t,e,r,n=!1){this.type=t,this.key=e,this.scope=r,this.featureConstant=n;}static parse(t,e){let r=e.expectedType;if(null==r&&(r=Ar),t.length<2||t.length>3)return e.error("Invalid number of arguments for 'config' expression.");const n=e.parse(t[1],1);if(!(n instanceof $r))return e.error("Key name of 'config' expression must be a string literal.");let i,s=!0;const o=jr(n.value);if(t.length>=3){const r=e.parse(t[2],2);if(!(r instanceof $r))return e.error("Scope of 'config' expression must be a string literal.");i=jr(r.value);}if(e.options){const t=bi(o,i,e._scope),r=e.options.get(t);r&&(s=gi(r.value||r.default));}return new Ai(r,o,i,s)}evaluate(t){const e=bi(this.key,this.scope,t.scope),r=t.getConfig(e);if(!r)return null;const{type:n,value:i,values:s,minValue:o,maxValue:a,stepValue:l}=r,u=r.default.evaluate(t);let c=u;if(i){const e=t.scope;t.scope=(e||"").split("").slice(1).join(""),c=i.evaluate(t),t.scope=e;}return n&&(c=wi(n,c)),void 0===c||void 0===o&&void 0===a&&void 0===l||("number"==typeof c?c=_i(c,o,a,l):Array.isArray(c)&&(c=c.map((t=>"number"==typeof t?_i(t,o,a,l):t)))),void 0!==i&&void 0!==c&&s&&!s.includes(c)&&(c=u,n&&(c=wi(n,c))),(n&&n!==this.type||void 0!==c&&!Vr(Nr(c),this.type))&&(c=wi(this.type.kind,c)),c}eachChild(){}outputDefined(){return !1}serialize(){const t=["config",this.key];return this.scope&&t.concat(this.scope),t}}class Ii{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e;}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new Ii(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return !1}serialize(){return ["var",this.name]}}class Mi{constructor(t,e=[],r,n=new yr,i=[],s,o,a){this.registry=t,this.path=e,this.key=e.map((t=>"string"==typeof t?`['${t}']`:`[${t}]`)).join(""),this.scope=n,this.errors=i,this.expectedType=r,this._scope=s,this.options=o,this.iconImageUseTheme=a;}parse(t,e,r,n,i={}){return e||r?this.concat(e,null,r,n)._parse(t,i):this._parse(t,i)}parseObjectValue(t,e,r,n,i,s={}){return this.concat(e,r,n,i)._parse(t,s)}_parse(t,e){function r(t,e,r){return "assert"===r?new Hr(e,[t]):"coerce"===r?new en(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n="string"==typeof t[0]?this.registry[t[0]]:void 0;if(n){let i=n.parse(t,this);if(!i)return null;if(this.expectedType){const t=this.expectedType,n=i.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==n.kind)if("color"!==t.kind&&"formatted"!==t.kind&&"resolvedImage"!==t.kind||"value"!==n.kind&&"string"!==n.kind){if(this.checkSubtype(t,n))return null}else i=r(i,t,e.typeAnnotation||"coerce");else i=r(i,t,e.typeAnnotation||"assert");}if(!(i instanceof $r)&&"resolvedImage"!==i.type.kind&&Si(i)){const t=new nn(this._scope,this.options,this.iconImageUseTheme);try{i=new $r(i.type,i.evaluate(t));}catch(t){return this.error(t.message),null}}return i}return en.parse(["to-array",t],this)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,r,n){let i="number"==typeof t?this.path.concat(t):this.path;i="string"==typeof e?i.concat(e):i;const s=n?this.scope.concat(n):this.scope;return new Mi(this.registry,i,r||null,s,this.errors,this._scope,this.options,this.iconImageUseTheme)}error(t,...e){const r=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new mr(r,t));}checkSubtype(t,e){const r=zr(t,e);return r&&this.error(r),r}}function Si(t){if(t instanceof Ii)return Si(t.boundExpression);if(t instanceof sn&&"error"===t.name)return !1;if(t instanceof an)return !1;if(t instanceof zn)return !1;if(t instanceof yi)return !1;if(t instanceof Ai)return !1;const e=t instanceof en||t instanceof Hr;let r=!0;return t.eachChild((t=>{r=e?r&&Si(t):r&&t instanceof $r;})),!!r&&gi(t)&&vi(t,["zoom","heatmap-density","worldview","line-progress","raster-value","sky-radial-progress","accumulated","is-supported-script","pitch","distance-from-center","measure-light","raster-particle-speed"])}function Pi(t,e){const r=t.length-1;let n,i,s=0,o=r,a=0;for(;s<=o;)if(a=Math.floor((s+o)/2),n=t[a],i=t[a+1],n<=e){if(a===r||e<i)return a;s=a+1;}else {if(!(n>e))throw new Gr("Input is not a number.");o=a-1;}return 0}class ki{constructor(t,e,r){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of r)this.labels.push(t),this.outputs.push(e);}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,xr);if(!r)return null;const n=[];let i=null;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);for(let r=1;r<t.length;r+=2){const s=1===r?-1/0:t[r],o=t[r+1],a=r,l=r+1;if("number"!=typeof s)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',a);if(n.length&&n[n.length-1][0]>=s)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',a);const u=e.parse(o,l,i);if(!u)return null;i=i||u.type,n.push([s,u]);}return new ki(i,r,n)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;return n>=e[i-1]?r[i-1].evaluate(t):r[Pi(e,n)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}serialize(){const t=["step",this.input.serialize()];for(let e=0;e<this.labels.length;e++)e>0&&t.push(this.labels[e]),t.push(this.outputs[e].serialize());return t}}const Bi=.95047,zi=1.08883,Ti=4/29,Ei=6/29,Vi=3*Ei*Ei,Fi=Ei*Ei*Ei,Ci=Math.PI/180,Di=180/Math.PI;function Ri(t){return t>Fi?Math.pow(t,1/3):t/Vi+Ti}function Li(t){return t>Ei?t*t*t:Vi*(t-Ti)}function Oi(t){return 255*(t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055)}function Ui(t){return (t/=255)<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function Ni(t){const e=Ui(t.r),r=Ui(t.g),n=Ui(t.b),i=Ri((.4124564*e+.3575761*r+.1804375*n)/Bi),s=Ri((.2126729*e+.7151522*r+.072175*n)/1);return {l:116*s-16,a:500*(i-s),b:200*(s-Ri((.0193339*e+.119192*r+.9503041*n)/zi)),alpha:t.a}}function ji(t){let e=(t.l+16)/116,r=isNaN(t.a)?e:e+t.a/500,n=isNaN(t.b)?e:e-t.b/200;return e=1*Li(e),r=Bi*Li(r),n=zi*Li(n),new lr(Oi(3.2404542*r-1.5371385*e-.4985314*n),Oi(-.969266*r+1.8760108*e+.041556*n),Oi(.0556434*r-.2040259*e+1.0572252*n),t.alpha)}function $i(t,e,r){const n=e-t;return t+r*(n>180||n<-180?n-360*Math.round(n/360):n)}const Gi={forward:Ni,reverse:ji,interpolate:function(t,e,r){return {l:pr(t.l,e.l,r),a:pr(t.a,e.a,r),b:pr(t.b,e.b,r),alpha:pr(t.alpha,e.alpha,r)}}},qi={forward:function(t){const{l:e,a:r,b:n}=Ni(t),i=Math.atan2(n,r)*Di;return {h:i<0?i+360:i,c:Math.sqrt(r*r+n*n),l:e,alpha:t.a}},reverse:function(t){const e=t.h*Ci,r=t.c;return ji({l:t.l,a:Math.cos(e)*r,b:Math.sin(e)*r,alpha:t.alpha})},interpolate:function(t,e,r){return {h:$i(t.h,e.h,r),c:pr(t.c,e.c,r),l:pr(t.l,e.l,r),alpha:pr(t.alpha,e.alpha,r)}}};var Hi=Object.freeze({__proto__:null,hcl:qi,lab:Gi});class Xi{constructor(t,e,r,n,i){this.type=t,this.operator=e,this.interpolation=r,this.input=n,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e);}static interpolationFactor(t,e,r,n){let i=0;if("exponential"===t.name)i=Zi(e,t.base,r,n);else if("linear"===t.name)i=Zi(e,1,r,n);else if("cubic-bezier"===t.name){const s=t.controlPoints;i=new At(s[0],s[1],s[2],s[3]).solve(Zi(e,1,r,n));}return i}static parse(t,e){let[r,n,i,...s]=t;if(!Array.isArray(n)||0===n.length)return e.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const t=n[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:t};}else {if("cubic-bezier"!==n[0])return e.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const t=n.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:t};}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length-1>3&&(t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(i=e.parse(i,2,xr),!i)return null;const o=[];let a=null;"interpolate-hcl"===r||"interpolate-lab"===r?a=wr:e.expectedType&&"value"!==e.expectedType.kind&&(a=e.expectedType);for(let t=0;t<s.length;t+=2){const r=s[t],n=s[t+1],i=t+3,l=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',i);if(o.length&&o[o.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',i);const u=e.parse(n,l,a);if(!u)return null;a=a||u.type,o.push([r,u]);}return "number"===a.kind||"color"===a.kind||"array"===a.kind&&"number"===a.itemType.kind&&"number"==typeof a.N?new Xi(a,r,n,i,o):e.error(`Type ${kr(a)} is not interpolatable.`)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;if(n>=e[i-1])return r[i-1].evaluate(t);const s=Pi(e,n),o=Xi.interpolationFactor(this.interpolation,n,e[s],e[s+1]),a=r[s].evaluate(t),l=r[s+1].evaluate(t);return "interpolate"===this.operator?fr[this.type.kind.toLowerCase()](a,l,o):"interpolate-hcl"===this.operator?qi.reverse(qi.interpolate(qi.forward(a),qi.forward(l),o)):Gi.reverse(Gi.interpolate(Gi.forward(a),Gi.forward(l),o))}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}serialize(){let t;t="linear"===this.interpolation.name?["linear"]:"exponential"===this.interpolation.name?1===this.interpolation.base?["linear"]:["exponential",this.interpolation.base]:["cubic-bezier",...this.interpolation.controlPoints];const e=[this.operator,t,this.input.serialize()];for(let t=0;t<this.labels.length;t++)e.push(this.labels[t],this.outputs[t].serialize());return e}}function Zi(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}class Wi{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expectected at least one argument.");let r=null;const n=e.expectedType;n&&"value"!==n.kind&&(r=n);const i=[];for(const n of t.slice(1)){const t=e.parse(n,1+i.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type,i.push(t);}const s=n&&i.some((t=>zr(n,t.type)));return new Wi(s?Ar:r,i)}evaluate(t){let e,r=null,n=0;for(const i of this.args){if(n++,r=i.evaluate(t),r&&r instanceof Lr&&!r.available&&(e||(e=r),r=null,n===this.args.length))return e;if(null!==r)break}return r}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){const t=["coalesce"];return this.eachChild((e=>{t.push(e.serialize());})),t}}class Yi{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e;}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result);}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let n=1;n<t.length-1;n+=2){const i=t[n];if("string"!=typeof i)return e.error(`Expected string, but found ${typeof i} instead.`,n);if(/[^a-zA-Z0-9_]/.test(i))return e.error("Variable names must contain only alphanumeric characters or '_'.",n);const s=e.parse(t[n+1],n+1);if(!s)return null;r.push([i,s]);}const n=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return n?new Yi(r,n):null}outputDefined(){return this.result.outputDefined()}serialize(){const t=["let"];for(const[e,r]of this.bindings)t.push(e,r.serialize());return t.push(this.result.serialize()),t}}class Ki{constructor(t,e,r){this.type=t,this.index=e,this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,xr),n=e.parse(t[2],2,Pr(e.expectedType||Ar));return r&&n?new Ki(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new Gr("Array index out of bounds: negative index");if(e>=r.length)throw new Gr("Array index out of bounds: index exceeds array size");if(e!==Math.floor(e))throw new Gr("Array index must be an integer. Use at-interpolated for fractional indices");return r[e]}eachChild(t){t(this.index),t(this.input);}outputDefined(){return !1}serialize(){return ["at",this.index.serialize(),this.input.serialize()]}}class Ji{constructor(t,e,r){this.type=t,this.index=e,this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,xr),n=e.parse(t[2],2,Pr(e.expectedType||Ar));return r&&n?new Ji(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new Gr(`Array index out of bounds: ${e} < 0.`);if(e>r.length-1)throw new Gr(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e===Math.floor(e))return r[e];const n=Math.floor(e),i=Math.ceil(e),s=r[n],o=r[i];if("number"!=typeof s||"number"!=typeof o)throw new Gr(`Cannot interpolate between non-number values at index ${e}.`);const a=e-n;return s*(1-a)+o*a}eachChild(t){t(this.index),t(this.input);}outputDefined(){return !1}serialize(){return ["at-interpolated",this.index.serialize(),this.input.serialize()]}}class Qi{constructor(t,e){this.type=br,this.needle=t,this.haystack=e;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ar),n=e.parse(t[2],2,Ar);return r&&n?Tr(r.type,[br,vr,xr,gr,Ar])?new Qi(r,n):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${kr(r.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(null==r)return !1;if(!Er(e,["boolean","string","number","null"]))throw new Gr(`Expected first argument to be of type boolean, string, number or null, but found ${kr(Nr(e))} instead.`);if(!Er(r,["string","array"]))throw new Gr(`Expected second argument to be of type array or string, but found ${kr(Nr(r))} instead.`);return r.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack);}outputDefined(){return !0}serialize(){return ["in",this.needle.serialize(),this.haystack.serialize()]}}class ts{constructor(t,e,r){this.type=xr,this.needle=t,this.haystack=e,this.fromIndex=r;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ar),n=e.parse(t[2],2,Ar);if(!r||!n)return null;if(!Tr(r.type,[br,vr,xr,gr,Ar]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${kr(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,xr);return i?new ts(r,n,i):null}return new ts(r,n)}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!Er(e,["boolean","string","number","null"]))throw new Gr(`Expected first argument to be of type boolean, string, number or null, but found ${kr(Nr(e))} instead.`);if(!Er(r,["string","array"]))throw new Gr(`Expected second argument to be of type array or string, but found ${kr(Nr(r))} instead.`);if(this.fromIndex){const n=this.fromIndex.evaluate(t);return r.indexOf(e,n)}return r.indexOf(e)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex);}outputDefined(){return !1}serialize(){if(null!=this.fromIndex&&void 0!==this.fromIndex){const t=this.fromIndex.serialize();return ["index-of",this.needle.serialize(),this.haystack.serialize(),t]}return ["index-of",this.needle.serialize(),this.haystack.serialize()]}}class es{constructor(t,e,r,n,i,s){this.inputType=t,this.type=e,this.input=r,this.cases=n,this.outputs=i,this.otherwise=s;}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,n;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);const i={},s=[];for(let o=2;o<t.length-1;o+=2){let a=t[o];const l=t[o+1];Array.isArray(a)||(a=[a]);const u=e.concat(o);if(0===a.length)return u.error("Expected at least one branch label.");for(const t of a){if("number"!=typeof t&&"string"!=typeof t)return u.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,Nr(t)))return null}else r=Nr(t);if(void 0!==i[String(t)])return u.error("Branch labels must be unique.");i[String(t)]=s.length;}const c=e.parse(l,o,n);if(!c)return null;n=n||c.type,s.push(c);}const o=e.parse(t[1],1,Ar);if(!o)return null;const a=e.parse(t[t.length-1],t.length-1,n);return a?"value"!==o.type.kind&&e.concat(1).checkSubtype(r,o.type)?null:new es(r,n,o,i,s,a):null}evaluate(t){const e=this.input.evaluate(t);return (Vr(Nr(e),this.inputType)&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const t=["match",this.input.serialize()],e=Object.keys(this.cases).sort(),r=[],n={};for(const t of e){const e=n[this.cases[t]];void 0===e?(n[this.cases[t]]=r.length,r.push([this.cases[t],[t]])):r[e][1].push(t);}const i=t=>"number"===this.inputType.kind?Number(t):t;for(const[e,n]of r)t.push(1===n.length?i(n[0]):n.map(i)),t.push(this.outputs[e].serialize());return t.push(this.otherwise.serialize()),t}}class rs{constructor(t,e,r){this.type=t,this.branches=e,this.otherwise=r;}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n=[];for(let i=1;i<t.length-1;i+=2){const s=e.parse(t[i],i,br);if(!s)return null;const o=e.parse(t[i+1],i+1,r);if(!o)return null;n.push([s,o]),r=r||o.type;}const i=e.parse(t[t.length-1],t.length-1,r);return i?new rs(r,n,i):null}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,r]of this.branches)t(e),t(r);t(this.otherwise);}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const t=["case"];return this.eachChild((e=>{t.push(e.serialize());})),t}}class ns{constructor(t,e,r,n){this.type=t,this.input=e,this.beginIndex=r,this.endIndex=n;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ar),n=e.parse(t[2],2,xr);if(!r||!n)return null;if(!Tr(r.type,[Pr(Ar),vr,Ar]))return e.error(`Expected first argument to be of type array or string, but found ${kr(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,xr);return i?new ns(r.type,r,n,i):null}return new ns(r.type,r,n)}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);if(!Er(e,["string","array"]))throw new Gr(`Expected first argument to be of type array or string, but found ${kr(Nr(e))} instead.`);if(this.endIndex){const n=this.endIndex.evaluate(t);return e.slice(r,n)}return e.slice(r)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex);}outputDefined(){return !1}serialize(){if(null!=this.endIndex&&void 0!==this.endIndex){const t=this.endIndex.serialize();return ["slice",this.input.serialize(),this.beginIndex.serialize(),t]}return ["slice",this.input.serialize(),this.beginIndex.serialize()]}}class is{constructor(t,e){this.type=Pr(vr),this.str=t,this.delimiter=e;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,vr),n=e.parse(t[2],2,vr);return r&&n?new is(r,n):void 0}evaluate(t){const e=this.str.evaluate(t),r=this.delimiter.evaluate(t);return e.split(r)}eachChild(t){t(this.str),t(this.delimiter);}outputDefined(){return !1}serialize(){return ["split",this.str.serialize(),this.delimiter.serialize()]}}function ss(t,e){return "=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function os(t,e,r,n){return 0===n.compare(e,r)}function as(t,e,r){const n="=="!==t&&"!="!==t;return class i{constructor(t,e,r){this.type=br,this.lhs=t,this.rhs=e,this.collator=r,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind;}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let s=e.parse(t[1],1,Ar);if(!s)return null;if(!ss(r,s.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${kr(s.type)}'.`);let o=e.parse(t[2],2,Ar);if(!o)return null;if(!ss(r,o.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${kr(o.type)}'.`);if(s.type.kind!==o.type.kind&&"value"!==s.type.kind&&"value"!==o.type.kind)return e.error(`Cannot compare types '${kr(s.type)}' and '${kr(o.type)}'.`);n&&("value"===s.type.kind&&"value"!==o.type.kind?s=new Hr(o.type,[s]):"value"!==s.type.kind&&"value"===o.type.kind&&(o=new Hr(s.type,[o])));let a=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==o.type.kind&&"value"!==s.type.kind&&"value"!==o.type.kind)return e.error("Cannot use collator to compare non-string types.");if(a=e.parse(t[3],3,Ir),!a)return null}return new i(s,o,a)}evaluate(i){const s=this.lhs.evaluate(i),o=this.rhs.evaluate(i);if(n&&this.hasUntypedArgument){const e=Nr(s),r=Nr(o);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new Gr(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`)}if(this.collator&&!n&&this.hasUntypedArgument){const t=Nr(s),r=Nr(o);if("string"!==t.kind||"string"!==r.kind)return e(i,s,o)}return this.collator?r(i,s,o,this.collator.evaluate(i)):e(i,s,o)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator);}outputDefined(){return !0}serialize(){const e=[t];return this.eachChild((t=>{e.push(t.serialize());})),e}}}const ls=as("==",(function(t,e,r){return e===r}),os),us=as("!=",(function(t,e,r){return e!==r}),(function(t,e,r,n){return !os(0,e,r,n)})),cs=as("<",(function(t,e,r){return e<r}),(function(t,e,r,n){return n.compare(e,r)<0})),hs=as(">",(function(t,e,r){return e>r}),(function(t,e,r,n){return n.compare(e,r)>0})),ps=as("<=",(function(t,e,r){return e<=r}),(function(t,e,r,n){return n.compare(e,r)<=0})),ds=as(">=",(function(t,e,r){return e>=r}),(function(t,e,r,n){return n.compare(e,r)>=0}));class fs{constructor(t,e,r,n,i,s){this.type=vr,this.number=t,this.locale=e,this.currency=r,this.unit=n,this.minFractionDigits=i,this.maxFractionDigits=s;}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,xr);if(!r)return null;const n=t[2];if("object"!=typeof n||Array.isArray(n))return e.error("NumberFormat options argument must be an object.");let i=null;if(n.locale&&(i=e.parseObjectValue(n.locale,2,"locale",vr),!i))return null;let s=null;if(n.currency&&(s=e.parseObjectValue(n.currency,2,"currency",vr),!s))return null;let o=null;if(n.unit&&(o=e.parseObjectValue(n.unit,2,"unit",vr),!o))return null;let a=null;if(n["min-fraction-digits"]&&(a=e.parseObjectValue(n["min-fraction-digits"],2,"min-fraction-digits",xr),!a))return null;let l=null;return n["max-fraction-digits"]&&(l=e.parseObjectValue(n["max-fraction-digits"],2,"max-fraction-digits",xr),!l)?null:new fs(r,i,s,o,a,l)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:(this.currency?"currency":this.unit&&"unit")||"decimal",currency:this.currency?this.currency.evaluate(t):void 0,unit:this.unit?this.unit.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.unit&&t(this.unit),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits);}outputDefined(){return !1}serialize(){const t={};return this.locale&&(t.locale=this.locale.serialize()),this.currency&&(t.currency=this.currency.serialize()),this.unit&&(t.unit=this.unit.serialize()),this.minFractionDigits&&(t["min-fraction-digits"]=this.minFractionDigits.serialize()),this.maxFractionDigits&&(t["max-fraction-digits"]=this.maxFractionDigits.serialize()),["number-format",this.number.serialize(),t]}}class ms{constructor(t){this.type=xr,this.input=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${kr(r.type)} instead.`):new ms(r):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return e.length;if(Array.isArray(e))return e.length;throw new Gr(`Expected value to be of type string or array, but found ${kr(Nr(e))} instead.`)}eachChild(t){t(this.input);}outputDefined(){return !1}serialize(){const t=["length"];return this.eachChild((e=>{t.push(e.serialize());})),t}}function ys(t){return function(){t=1831565813+(t|=0)|0;let e=Math.imul(t^t>>>15,1|t);return e=e+Math.imul(e^e>>>7,61|e)^e,((e^e>>>14)>>>0)/4294967296}}const gs={"==":ls,"!=":us,">":hs,"<":cs,">=":ds,"<=":ps,array:Hr,at:Ki,"at-interpolated":Ji,boolean:Hr,case:rs,coalesce:Wi,collator:an,format:Xr,image:Zr,in:Qi,"index-of":ts,interpolate:Xi,"interpolate-hcl":Xi,"interpolate-lab":Xi,length:ms,let:Yi,literal:$r,match:es,number:Hr,"number-format":fs,object:Hr,slice:ns,step:ki,string:Hr,"to-boolean":en,"to-color":en,"to-number":en,"to-string":en,var:Ii,within:zn,distance:yi,config:Ai,split:is};function xs(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const s=i?i.evaluate(t):1,o=Or(e,r,n,s);if(o)throw new Gr(o);return new lr(e/255,r/255,n/255,s)}function vs(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const s=i?i.evaluate(t):1,o=function(t,e,r,n){return "number"==typeof t&&t>=0&&t<=360?"number"==typeof e&&e>=0&&e<=100&&"number"==typeof r&&r>=0&&r<=100?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid hsla value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid hsla value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 's', and 'l' must be between 0 and 100.`:`Invalid hsla value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'h' must be between 0 and 360.`}(e,r,n,s);if(o)throw new Gr(o);const a=`hsla(${e}, ${r}%, ${n}%, ${s})`,l=lr.parse(a);if(!l)throw new Gr(`Failed to parse HSLA color: ${a}`);return l}function bs(t,e){return t in e}function ws(t,e){const r=e[t];return void 0===r?null:r}function _s(t){return {type:t}}function As(t){if(t instanceof Ai)return new Set([t.key]);let e=new Set;return t.eachChild((t=>{e=new Set([...e,...As(t)]);})),e}function Is(t){if(t instanceof sn&&"is-active-floor"===t.name)return !0;let e=!1;return t.eachChild((t=>{!e&&Is(t)&&(e=!0);})),e}function Ms(t){return {result:"success",value:t}}function Ss(t){return {result:"error",value:t}}function Ps(t,e){return !!t&&!!t.parameters&&t.parameters.indexOf(e)>-1}function ks(t){return "data-driven"===t["property-type"]}function Bs(t){return Ps(t.expression,"measure-light")}function zs(t){return Ps(t.expression,"zoom")}function Ts(t){return !!t.expression&&t.expression.interpolated}function Es(t){return "object"==typeof t&&null!==t&&!Array.isArray(t)}function Vs(t){return t}function Fs(t,e){const r="color"===e.type,n=t.stops&&"object"==typeof t.stops[0][0],i=n||!(n||void 0!==t.property),s=t.type||(Ts(e)?"exponential":"interval");if(r&&((t=Object.assign({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],lr.parse(t[1])]))),t.default=lr.parse(t.default?t.default:e.default)),t.colorSpace&&"rgb"!==t.colorSpace&&!Hi[t.colorSpace])throw new Error(`Unknown color space: ${t.colorSpace}`);let o,a,l;if("exponential"===s)o=Ls;else if("interval"===s)o=Rs;else if("categorical"===s){o=Ds,a=Object.create(null);for(const e of t.stops)a[e[0]]=e[1];l=typeof t.stops[0][0];}else {if("identity"!==s)throw new Error(`Unknown function type "${s}"`);o=Os;}if(n){const r={},n=[];for(let e=0;e<t.stops.length;e++){const i=t.stops[e],s=i[0].zoom;void 0===r[s]&&(r[s]={zoom:s,type:t.type,property:t.property,default:t.default,stops:[]},n.push(s)),r[s].stops.push([i[0].value,i[1]]);}const i=[];for(const t of n)i.push([r[t].zoom,Fs(r[t],e)]);const s={name:"linear"};return {kind:"composite",interpolationType:s,interpolationFactor:Xi.interpolationFactor.bind(void 0,s),zoomStops:i.map((t=>t[0])),evaluate:({zoom:r},n)=>Ls({stops:i,base:t.base},e,r).evaluate(r,n)}}if(i){const r="exponential"===s?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return {kind:"camera",interpolationType:r,interpolationFactor:Xi.interpolationFactor.bind(void 0,r),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:r})=>o(t,e,r,a,l)}}return {kind:"source",evaluate(r,n){const i=n&&n.properties?n.properties[t.property]:void 0;return void 0===i?Cs(t.default,e.default):o(t,e,i,a,l)}}}function Cs(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0}function Ds(t,e,r,n,i){return Cs(typeof r===i?n[r]:void 0,t.default,e.default)}function Rs(t,e,r){if(!Jr(r))return Cs(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const i=Pi(t.stops.map((t=>t[0])),r);return t.stops[i][1]}function Ls(t,e,r){const n=void 0!==t.base?t.base:1;if(!Jr(r))return Cs(t.default,e.default);const i=t.stops.length;if(1===i)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[i-1][0])return t.stops[i-1][1];const s=Pi(t.stops.map((t=>t[0])),r),o=function(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}(r,n,t.stops[s][0],t.stops[s+1][0]),a=t.stops[s][1],l=t.stops[s+1][1];let u=fr[e.type]||Vs;if(t.colorSpace&&"rgb"!==t.colorSpace){const e=Hi[t.colorSpace];u=(t,r)=>e.reverse(e.interpolate(e.forward(t),e.forward(r),o));}return "function"==typeof a.evaluate?{evaluate(...t){const e=a.evaluate.apply(void 0,t),r=l.evaluate.apply(void 0,t);if(void 0!==e&&void 0!==r)return u(e,r,o)}}:u(a,l,o)}function Os(t,e,r){return "color"===e.type?r=lr.parse(r):"formatted"===e.type?r=Dr.fromString(r.toString()):"resolvedImage"===e.type?r=Lr.build(r.toString()):Wr(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0),Cs(r,t.default,e.default)}sn.register(gs,{error:[{kind:"error"},[vr],(t,[e])=>{throw new Gr(e.evaluate(t))}],typeof:[vr,[Ar],(t,[e])=>kr(Nr(e.evaluate(t)))],"to-rgba":[Pr(xr,4),[wr],(t,[e])=>e.evaluate(t).toNonPremultipliedRenderColor(null).toArray()],"to-hsla":[Pr(xr,4),[wr],(t,[e])=>e.evaluate(t).toNonPremultipliedRenderColor(null).toHslaArray()],rgb:[wr,[xr,xr,xr],xs],rgba:[wr,[xr,xr,xr,xr],xs],hsl:[wr,[xr,xr,xr],vs],hsla:[wr,[xr,xr,xr,xr],vs],has:{type:br,overloads:[[[vr],(t,[e])=>bs(e.evaluate(t),t.properties())],[[vr,_r],(t,[e,r])=>bs(e.evaluate(t),r.evaluate(t))]]},get:{type:Ar,overloads:[[[vr],(t,[e])=>ws(e.evaluate(t),t.properties())],[[vr,_r],(t,[e,r])=>ws(e.evaluate(t),r.evaluate(t))]]},"feature-state":[Ar,[vr],(t,[e])=>ws(e.evaluate(t),t.featureState||{})],properties:[_r,[],t=>t.properties()],"geometry-type":[vr,[],t=>t.geometryType()],worldview:[vr,[],t=>t.globals.worldview||""],"is-active-floor":[br,_s(vr),(t,e)=>{if(!(t.globals.activeFloors&&t.globals.activeFloors.size>0))return !1;const r=t.globals.activeFloors;return e.some((e=>{const n=e.evaluate(t);return r.has(n)}))}],id:[Ar,[],t=>t.id()],zoom:[xr,[],t=>t.globals.zoom],pitch:[xr,[],t=>t.globals.pitch||0],"distance-from-center":[xr,[],t=>t.distanceFromCenter()],"measure-light":[xr,[vr],(t,[e])=>t.measureLight(e.evaluate(t))],"heatmap-density":[xr,[],t=>t.globals.heatmapDensity||0],"line-progress":[xr,[],t=>t.globals.lineProgress||0],"raster-value":[xr,[],t=>t.globals.rasterValue||0],"raster-particle-speed":[xr,[],t=>t.globals.rasterParticleSpeed||0],"sky-radial-progress":[xr,[],t=>t.globals.skyRadialProgress||0],accumulated:[Ar,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[xr,_s(xr),(t,e)=>{let r=0;for(const n of e)r+=n.evaluate(t);return r}],"*":[xr,_s(xr),(t,e)=>{let r=1;for(const n of e)r*=n.evaluate(t);return r}],"-":{type:xr,overloads:[[[xr,xr],(t,[e,r])=>e.evaluate(t)-r.evaluate(t)],[[xr],(t,[e])=>-e.evaluate(t)]]},"/":[xr,[xr,xr],(t,[e,r])=>e.evaluate(t)/r.evaluate(t)],"%":[xr,[xr,xr],(t,[e,r])=>e.evaluate(t)%r.evaluate(t)],ln2:[xr,[],()=>Math.LN2],pi:[xr,[],()=>Math.PI],e:[xr,[],()=>Math.E],"^":[xr,[xr,xr],(t,[e,r])=>Math.pow(e.evaluate(t),r.evaluate(t))],sqrt:[xr,[xr],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[xr,[xr],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[xr,[xr],(t,[e])=>Math.log(e.evaluate(t))],log2:[xr,[xr],(t,[e])=>Math.log2(e.evaluate(t))],sin:[xr,[xr],(t,[e])=>Math.sin(e.evaluate(t))],cos:[xr,[xr],(t,[e])=>Math.cos(e.evaluate(t))],tan:[xr,[xr],(t,[e])=>Math.tan(e.evaluate(t))],asin:[xr,[xr],(t,[e])=>Math.asin(e.evaluate(t))],acos:[xr,[xr],(t,[e])=>Math.acos(e.evaluate(t))],atan:[xr,[xr],(t,[e])=>Math.atan(e.evaluate(t))],min:[xr,_s(xr),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[xr,_s(xr),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[xr,[xr],(t,[e])=>Math.abs(e.evaluate(t))],round:[xr,[xr],(t,[e])=>{const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r)}],floor:[xr,[xr],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[xr,[xr],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[br,[vr,Ar],(t,[e,r])=>t.properties()[e.value]===r.value],"filter-id-==":[br,[Ar],(t,[e])=>t.id()===e.value],"filter-type-==":[br,[vr],(t,[e])=>t.geometryType()===e.value],"filter-<":[br,[vr,Ar],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<i}],"filter-id-<":[br,[Ar],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<n}],"filter->":[br,[vr,Ar],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>i}],"filter-id->":[br,[Ar],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>n}],"filter-<=":[br,[vr,Ar],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<=i}],"filter-id-<=":[br,[Ar],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<=n}],"filter->=":[br,[vr,Ar],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>=i}],"filter-id->=":[br,[Ar],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>=n}],"filter-has":[br,[Ar],(t,[e])=>e.value in t.properties()],"filter-has-id":[br,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[br,[Pr(vr)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[br,[Pr(Ar)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[br,[vr,Pr(Ar)],(t,[e,r])=>r.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[br,[vr,Pr(Ar)],(t,[e,r])=>function(t,e,r,n){for(;r<=n;){const i=r+n>>1;if(e[i]===t)return !0;e[i]>t?n=i-1:r=i+1;}return !1}(t.properties()[e.value],r.value,0,r.value.length-1)],all:{type:br,overloads:[[[br,br],(t,[e,r])=>e.evaluate(t)&&r.evaluate(t)],[_s(br),(t,e)=>{for(const r of e)if(!r.evaluate(t))return !1;return !0}]]},any:{type:br,overloads:[[[br,br],(t,[e,r])=>e.evaluate(t)||r.evaluate(t)],[_s(br),(t,e)=>{for(const r of e)if(r.evaluate(t))return !0;return !1}]]},"!":[br,[br],(t,[e])=>!e.evaluate(t)],"is-supported-script":[br,[vr],(t,[e])=>{const r=t.globals&&t.globals.isSupportedScript;return !r||r(e.evaluate(t))}],upcase:[vr,[vr],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[vr,[vr],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[vr,_s(Ar),(t,e)=>e.map((e=>jr(e.evaluate(t)))).join("")],"resolved-locale":[vr,[Ir],(t,[e])=>e.evaluate(t).resolvedLocale()],random:[xr,[xr,xr,Ar],(t,e)=>{const[r,n,i]=e.map((e=>e.evaluate(t)));if(r>n)return r;if(r===n)return r;let s;if("string"==typeof i)s=function(t){let e=0;if(0===t.length)return e;for(let r=0;r<t.length;r++)e=(e<<5)-e+t.charCodeAt(r),e|=0;return e}(i);else {if("number"!=typeof i)throw new Gr(`Invalid seed input: ${i}`);s=i;}return r+ys(s)()*(n-r)}]});class Us{constructor(t,e,r,n,i){this.expression=t,this._warningHistory={},this._scope=r,this._options=n,this._iconImageUseTheme=i,this._evaluator=new nn(r,n,i),this._defaultValue=e?function(t){return "color"===t.type&&(Es(t.default)||Array.isArray(t.default))?new lr(0,0,0,0):"color"===t.type?lr.parse(t.default)||null:void 0===t.default?null:t.default}(e):null,this._enumValues=e&&"enum"===e.type?e.values:null,this.configDependencies=As(t),this.isIndoorDependent=Is(t);}evaluateWithoutErrorHandling(t,e,r,n,i,s,o,a){return this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=r,this._evaluator.canonical=n||null,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s,this._evaluator.featureTileCoord=o||null,this._evaluator.featureDistanceData=a||null,this.expression.evaluate(this._evaluator)}evaluate(t,e,r,n,i,s,o,a,l){this._evaluator||(this._evaluator=new nn(this._scope,this._options,this._iconImageUseTheme)),this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=r||null,this._evaluator.canonical=n||null,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s||null,this._evaluator.featureTileCoord=o||null,this._evaluator.featureDistanceData=a||null,this._evaluator.iconImageUseTheme=l||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new Gr(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){const e=t;return this._warningHistory[e.message]||(this._warningHistory[e.message]=!0,"undefined"!=typeof console&&console.warn(`Failed to evaluate expression "${JSON.stringify(this.expression.serialize())}". ${e.message}`)),this._defaultValue}}}function Ns(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in gs}function js(t,e,r,n,i){const s=new Mi(gs,[],e?function(t){const e={color:wr,string:vr,number:xr,enum:vr,boolean:br,formatted:Mr,resolvedImage:Sr};return "array"===t.type?Pr(e[t.value]||Ar,t.length):e[t.type]}(e):void 0,void 0,void 0,r,n,i),o=s.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return o?Ms(new Us(o,e,r,n,i)):Ss(s.errors)}class $s{constructor(t,e,r,n){this.kind=t,this._styleExpression=e,this.isLightConstant=r,this.isLineProgressConstant=n,this.isStateDependent="constant"!==t&&!xi(e.expression),this.configDependencies=As(e.expression),this.isIndoorDependent=Is(e.expression);}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s,o){return this._styleExpression.evaluate(t,e,r,n,i,s,void 0,void 0,o)}}class Gs{constructor(t,e,r,n,i,s){this.kind=t,this.zoomStops=r,this._styleExpression=e,this.isStateDependent="camera"!==t&&!xi(e.expression),this.isIndoorDependent=Is(e.expression),this.isLightConstant=i,this.isLineProgressConstant=s,this.configDependencies=As(e.expression),this.interpolationType=n;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}interpolationFactor(t,e,r){return this.interpolationType?Xi.interpolationFactor(this.interpolationType,t,e,r):0}}function qs(t,e,r,n,i){if("error"===(t=js(t,e,r,n,i)).result)return t;const s=t.value.expression,o=gi(s);if(!o&&!ks(e))return Ss([new mr("","data expressions not supported")]);const a=vi(s,["zoom","pitch","distance-from-center"]);if(!a&&!zs(e))return Ss([new mr("","zoom expressions not supported")]);const l=vi(s,["measure-light"]);if(!l&&!Bs(e))return Ss([new mr("","measure-light expression not supported")]);const u=vi(s,["line-progress"]);if(!u&&!function(t){return Ps(t.expression,"line-progress")}(e))return Ss([new mr("","line-progress expression not supported")]);const c=e.expression&&e.expression.relaxZoomRestriction,h=Xs(s);return h||a||c?h instanceof mr?Ss([h]):h instanceof Xi&&!Ts(e)?Ss([new mr("",'"interpolate" expressions cannot be used with this property')]):Ms(h?new Gs(o&&u?"camera":"composite",t.value,h.labels,h instanceof Xi?h.interpolation:void 0,l,u):new $s(o&&u?"constant":"source",t.value,l,u)):Ss([new mr("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression, or in the properties of atmosphere.')])}class Hs{constructor(t,e){this._parameters=t,this._specification=e,Object.assign(this,Fs(this._parameters,this._specification));}static deserialize(t){return new Hs(t._parameters,t._specification)}static serialize(t){return {_parameters:t._parameters,_specification:t._specification}}}function Xs(t){let e=null;if(t instanceof Yi)e=Xs(t.result);else if(t instanceof Wi){for(const r of t.args)if(e=Xs(r),e)break}else (t instanceof ki||t instanceof Xi)&&t.input instanceof sn&&"zoom"===t.input.name&&(e=t);return e instanceof mr||t.eachChild((t=>{const r=Xs(t);r instanceof mr?e=r:e&&r&&e!==r&&(e=new mr("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'));})),e}var Zs,Ws,Ys=function(){if(Ws)return Zs;Ws=1,Zs=e;var t=3;function e(e,r,n){var i=this.cells=[];if(e instanceof ArrayBuffer){this.arrayBuffer=e;var s=new Int32Array(this.arrayBuffer);e=s[0],this.d=(r=s[1])+2*(n=s[2]);for(var o=0;o<this.d*this.d;o++){var a=s[t+o],l=s[t+o+1];i.push(a===l?null:s.subarray(a,l));}var u=s[t+i.length+1];this.keys=s.subarray(s[t+i.length],u),this.bboxes=s.subarray(u),this.insert=this._insertReadonly;}else {this.d=r+2*n;for(var c=0;c<this.d*this.d;c++)i.push([]);this.keys=[],this.bboxes=[];}this.n=r,this.extent=e,this.padding=n,this.scale=r/e,this.uid=0;var h=n/r*e;this.min=-h,this.max=e+h;}return e.prototype.insert=function(t,e,r,n,i){this._forEachCell(e,r,n,i,this._insertCell,this.uid++),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(r),this.bboxes.push(n),this.bboxes.push(i);},e.prototype._insertReadonly=function(){throw "Cannot insert into a GridIndex created from an ArrayBuffer."},e.prototype._insertCell=function(t,e,r,n,i,s){this.cells[i].push(s);},e.prototype.query=function(t,e,r,n,i){var s=this.min,o=this.max;if(t<=s&&e<=s&&o<=r&&o<=n&&!i)return Array.prototype.slice.call(this.keys);var a=[];return this._forEachCell(t,e,r,n,this._queryCell,a,{},i),a},e.prototype._queryCell=function(t,e,r,n,i,s,o,a){var l=this.cells[i];if(null!==l)for(var u=this.keys,c=this.bboxes,h=0;h<l.length;h++){var p=l[h];if(void 0===o[p]){var d=4*p;(a?a(c[d+0],c[d+1],c[d+2],c[d+3]):t<=c[d+2]&&e<=c[d+3]&&r>=c[d+0]&&n>=c[d+1])?(o[p]=!0,s.push(u[p])):o[p]=!1;}}},e.prototype._forEachCell=function(t,e,r,n,i,s,o,a){for(var l=this._convertToCellCoord(t),u=this._convertToCellCoord(e),c=this._convertToCellCoord(r),h=this._convertToCellCoord(n),p=l;p<=c;p++)for(var d=u;d<=h;d++){var f=this.d*d+p;if((!a||a(this._convertFromCellCoord(p),this._convertFromCellCoord(d),this._convertFromCellCoord(p+1),this._convertFromCellCoord(d+1)))&&i.call(this,t,e,r,n,f,s,o,a))return}},e.prototype._convertFromCellCoord=function(t){return (t-this.padding)/this.scale},e.prototype._convertToCellCoord=function(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))},e.prototype.toArrayBuffer=function(){if(this.arrayBuffer)return this.arrayBuffer;for(var e=this.cells,r=t+this.cells.length+1+1,n=0,i=0;i<this.cells.length;i++)n+=this.cells[i].length;var s=new Int32Array(r+n+this.keys.length+this.bboxes.length);s[0]=this.extent,s[1]=this.n,s[2]=this.padding;for(var o=r,a=0;a<e.length;a++){var l=e[a];s[t+a]=o,s.set(l,o),o+=l.length;}return s[t+e.length]=o,s.set(this.keys,o),s[t+e.length+1]=o+=this.keys.length,s.set(this.bboxes,o),o+=this.bboxes.length,s.buffer},Zs}(),Ks=wt(Ys);const Js={};function Qs(t,e,r={}){Object.defineProperty(t,"_classRegistryKey",{value:e,writable:!1}),Js[e]={klass:t,omit:r.omit||[]};}Qs(Object,"Object"),Ks.serialize=function(t,e){const r=t.toArrayBuffer();return e&&e.add(r),{buffer:r}},Ks.deserialize=function(t){return new Ks(t.buffer)},Object.defineProperty(Ks,"name",{value:"Grid"}),Qs(Ks,"Grid"),delete It.prototype.constructor,Qs(lr,"Color"),Qs(Error,"Error"),Qs(Dr,"Formatted"),Qs(Cr,"FormattedSection"),Qs(De,"AJAXError"),Qs(Lr,"ResolvedImage"),Qs(Hs,"StylePropertyFunction"),Qs(Us,"StyleExpression",{omit:["_evaluator"]}),Qs(ir,"ImageId"),Qs(Rr,"ImageVariant"),Qs(Gs,"ZoomDependentExpression"),Qs($s,"ZoomConstantExpression"),Qs(sn,"CompoundExpression",{omit:["_evaluate"]});for(const t in gs)Js[gs[t]._classRegistryKey]||Qs(gs[t],`Expression${t}`);function to(t){return t&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function eo(t,e){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp)return t;if(to(t)||t instanceof ImageBitmap)return e&&e.add(t),t;if(ArrayBuffer.isView(t))return e&&e.add(t.buffer),t;if(t instanceof ImageData)return e&&e.add(t.data.buffer),t;if(Array.isArray(t)){const r=[];for(const n of t)r.push(eo(n,e));return r}if(t instanceof Map){const r={$name:"Map",entries:[]};for(const[n,i]of t.entries())r.entries.push(eo(n),eo(i,e));return r}if(t instanceof Set){const e={$name:"Set"};let r=0;for(const n of t.values())e[++r]=eo(n);return e}if("bigint"==typeof t)return {$name:"BigInt",value:t.toString()};if("object"==typeof t){const r=t.constructor,n=r._classRegistryKey;if(!n)throw new Error(`Can't serialize object of unregistered class "${r.name}".`);const i=r.serialize?r.serialize(t,e):{};if(!r.serialize){for(const r in t)t.hasOwnProperty(r)&&(Js[n].omit.indexOf(r)>=0||(i[r]=eo(t[r],e)));t instanceof Error&&(i.message=t.message);}if(i.$name)throw new Error("$name property is reserved for worker serialization logic.");return "Object"!==n&&(i.$name=n),i}throw new Error("can't serialize object of type "+typeof t)}function ro(t){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||to(t)||t instanceof ImageBitmap||ArrayBuffer.isView(t)||t instanceof ImageData)return t;if(Array.isArray(t))return t.map(ro);if("object"==typeof t){const e=t.$name||"Object";if("Map"===e){const e=t.entries||[],r=new Map;for(let t=0;t<e.length;t+=2)r.set(ro(e[t]),ro(e[t+1]));return r}if("Set"===e){const e=new Set;for(const r of Object.keys(t))"$name"!==r&&e.add(ro(t[r]));return e}if("BigInt"===e)return BigInt(t.value);const{klass:r}=Js[e];if(!r)throw new Error(`Can't deserialize unregistered class "${e}".`);if(r.deserialize)return r.deserialize(t);const n=Object.create(r.prototype);for(const e of Object.keys(t))"$name"!==e&&(n[e]=ro(t[e]));return n}throw new Error("can't deserialize object of type "+typeof t)}const no={"Latin-1 Supplement":t=>t>=128&&t<=255,Arabic:t=>t>=1536&&t<=1791,"Arabic Supplement":t=>t>=1872&&t<=1919,"Arabic Extended-A":t=>t>=2208&&t<=2303,"Hangul Jamo":t=>t>=4352&&t<=4607,"Unified Canadian Aboriginal Syllabics":t=>t>=5120&&t<=5759,Khmer:t=>t>=6016&&t<=6143,"Unified Canadian Aboriginal Syllabics Extended":t=>t>=6320&&t<=6399,"General Punctuation":t=>t>=8192&&t<=8303,"Letterlike Symbols":t=>t>=8448&&t<=8527,"Number Forms":t=>t>=8528&&t<=8591,"Miscellaneous Technical":t=>t>=8960&&t<=9215,"Control Pictures":t=>t>=9216&&t<=9279,"Optical Character Recognition":t=>t>=9280&&t<=9311,"Enclosed Alphanumerics":t=>t>=9312&&t<=9471,"Geometric Shapes":t=>t>=9632&&t<=9727,"Miscellaneous Symbols":t=>t>=9728&&t<=9983,"Miscellaneous Symbols and Arrows":t=>t>=11008&&t<=11263,"CJK Radicals Supplement":t=>t>=11904&&t<=12031,"Kangxi Radicals":t=>t>=12032&&t<=12255,"Ideographic Description Characters":t=>t>=12272&&t<=12287,"CJK Symbols and Punctuation":t=>t>=12288&&t<=12351,Hiragana:t=>t>=12352&&t<=12447,Katakana:t=>t>=12448&&t<=12543,Bopomofo:t=>t>=12544&&t<=12591,"Hangul Compatibility Jamo":t=>t>=12592&&t<=12687,Kanbun:t=>t>=12688&&t<=12703,"Bopomofo Extended":t=>t>=12704&&t<=12735,"CJK Strokes":t=>t>=12736&&t<=12783,"Katakana Phonetic Extensions":t=>t>=12784&&t<=12799,"Enclosed CJK Letters and Months":t=>t>=12800&&t<=13055,"CJK Compatibility":t=>t>=13056&&t<=13311,"CJK Unified Ideographs Extension A":t=>t>=13312&&t<=19903,"Yijing Hexagram Symbols":t=>t>=19904&&t<=19967,"CJK Unified Ideographs":t=>t>=19968&&t<=40959,"Yi Syllables":t=>t>=40960&&t<=42127,"Yi Radicals":t=>t>=42128&&t<=42191,"Hangul Jamo Extended-A":t=>t>=43360&&t<=43391,"Hangul Syllables":t=>t>=44032&&t<=55215,"Hangul Jamo Extended-B":t=>t>=55216&&t<=55295,"Private Use Area":t=>t>=57344&&t<=63743,"CJK Compatibility Ideographs":t=>t>=63744&&t<=64255,"Arabic Presentation Forms-A":t=>t>=64336&&t<=65023,"Vertical Forms":t=>t>=65040&&t<=65055,"CJK Compatibility Forms":t=>t>=65072&&t<=65103,"Small Form Variants":t=>t>=65104&&t<=65135,"Arabic Presentation Forms-B":t=>t>=65136&&t<=65279,"Halfwidth and Fullwidth Forms":t=>t>=65280&&t<=65519,Osage:t=>t>=66736&&t<=66815,"CJK Unified Ideographs Extension B":t=>t>=131072&&t<=173791};function io(t){for(const e of t)if(ao(e.charCodeAt(0)))return !0;return !1}function so(t){for(const e of t)if(!oo(e.charCodeAt(0)))return !1;return !0}function oo(t){return !(no.Arabic(t)||no["Arabic Supplement"](t)||no["Arabic Extended-A"](t)||no["Arabic Presentation Forms-A"](t)||no["Arabic Presentation Forms-B"](t))}function ao(t){return !(746!==t&&747!==t&&(t<4352||!(no["Bopomofo Extended"](t)||no.Bopomofo(t)||no["CJK Compatibility Forms"](t)&&!(t>=65097&&t<=65103)||no["CJK Compatibility Ideographs"](t)||no["CJK Compatibility"](t)||no["CJK Radicals Supplement"](t)||no["CJK Strokes"](t)||!(!no["CJK Symbols and Punctuation"](t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||no["CJK Unified Ideographs Extension A"](t)||no["CJK Unified Ideographs"](t)||no["Enclosed CJK Letters and Months"](t)||no["Hangul Compatibility Jamo"](t)||no["Hangul Jamo Extended-A"](t)||no["Hangul Jamo Extended-B"](t)||no["Hangul Jamo"](t)||no["Hangul Syllables"](t)||no.Hiragana(t)||no["Ideographic Description Characters"](t)||no.Kanbun(t)||no["Kangxi Radicals"](t)||no["Katakana Phonetic Extensions"](t)||no.Katakana(t)&&12540!==t||!(!no["Halfwidth and Fullwidth Forms"](t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!no["Small Form Variants"](t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||no["Unified Canadian Aboriginal Syllabics"](t)||no["Unified Canadian Aboriginal Syllabics Extended"](t)||no["Vertical Forms"](t)||no["Yijing Hexagram Symbols"](t)||no["Yi Syllables"](t)||no["Yi Radicals"](t))))}function lo(t){return !(ao(t)||function(t){return !!(no["Latin-1 Supplement"](t)&&(167===t||169===t||174===t||177===t||188===t||189===t||190===t||215===t||247===t)||no["General Punctuation"](t)&&(8214===t||8224===t||8225===t||8240===t||8241===t||8251===t||8252===t||8258===t||8263===t||8264===t||8265===t||8273===t)||no["Letterlike Symbols"](t)||no["Number Forms"](t)||no["Miscellaneous Technical"](t)&&(t>=8960&&t<=8967||t>=8972&&t<=8991||t>=8996&&t<=9e3||9003===t||t>=9085&&t<=9114||t>=9150&&t<=9165||9167===t||t>=9169&&t<=9179||t>=9186&&t<=9215)||no["Control Pictures"](t)&&9251!==t||no["Optical Character Recognition"](t)||no["Enclosed Alphanumerics"](t)||no["Geometric Shapes"](t)||no["Miscellaneous Symbols"](t)&&!(t>=9754&&t<=9759)||no["Miscellaneous Symbols and Arrows"](t)&&(t>=11026&&t<=11055||t>=11088&&t<=11097||t>=11192&&t<=11243)||no["CJK Symbols and Punctuation"](t)||no.Katakana(t)||no["Private Use Area"](t)||no["CJK Compatibility Forms"](t)||no["Small Form Variants"](t)||no["Halfwidth and Fullwidth Forms"](t)||8734===t||8756===t||8757===t||t>=9984&&t<=10087||t>=10102&&t<=10131||65532===t||65533===t)}(t))}function uo(t){return no.Arabic(t)||no["Arabic Supplement"](t)||no["Arabic Extended-A"](t)||no["Arabic Presentation Forms-A"](t)||no["Arabic Presentation Forms-B"](t)}function co(t){return t>=1424&&t<=2303||no["Arabic Presentation Forms-A"](t)||no["Arabic Presentation Forms-B"](t)}function ho(t,e){return !(!e&&co(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||no.Khmer(t))}function po(t){for(const e of t)if(co(e.charCodeAt(0)))return !0;return !1}const fo={unavailable:"unavailable",deferred:"deferred",loading:"loading",parsing:"parsing",parsed:"parsed",loaded:"loaded",error:"error"};let mo=null,yo=fo.unavailable,go=null;const xo=function(t){t&&"string"==typeof t&&t.indexOf("NetworkError")>-1&&(yo=fo.error),mo&&mo(t);};function vo(){bo.fire(new Qe("pluginStateChange",{pluginStatus:yo,pluginURL:go}));}const bo=new nr,wo=function(){return yo},_o=function(){if(yo!==fo.deferred||!go)throw new Error("rtl-text-plugin cannot be downloaded unless a pluginURL is specified");yo=fo.loading,vo(),go&&Oe({url:go},(t=>{t?xo(t):(yo=fo.loaded,vo());}));},Ao={applyArabicShaping:null,processBidirectionalText:null,processStyledBidirectionalText:null,isLoaded:()=>yo===fo.loaded||null!=Ao.applyArabicShaping,isLoading:()=>yo===fo.loading,setState(t){yo=t.pluginStatus,go=t.pluginURL;},isParsing:()=>yo===fo.parsing,isParsed:()=>yo===fo.parsed,getPluginURL:()=>go};class Io{constructor(t,e){this.zoom=t,e?(this.now=e.now,this.fadeDuration=e.fadeDuration,this.transition=e.transition,this.pitch=e.pitch,this.brightness=e.brightness,this.worldview=e.worldview,this.activeFloors=e.activeFloors):(this.now=0,this.fadeDuration=0,this.transition={},this.pitch=0,this.brightness=0);}isSupportedScript(t){return function(t,e){for(const r of t)if(!ho(r.charCodeAt(0),e))return !1;return !0}(t,Ao.isLoaded())}}class Mo{constructor(t,e,r,n,i){this.property=t,this.value=e,this.expression=function(t,e,r,n,i){if(Es(t))return new Hs(t,e);if(Ns(t)||Array.isArray(t)&&t.length>0){const s=qs(t,e,r,n,i);if("error"===s.result)throw new Error(s.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return s.value}{let r=t;return "string"==typeof t&&"color"===e.type&&(r=lr.parse(t)),{kind:"constant",configDependencies:new Set,isIndoorDependent:!1,evaluate:()=>r}}}(void 0===e?t.specification.default:e,t.specification,r,n,i);}isIndoorDependent(){return this.expression.isIndoorDependent}isDataDriven(){return "source"===this.expression.kind||"composite"===this.expression.kind}possiblyEvaluate(t,e,r,n){return this.property.possiblyEvaluate(this,t,e,r,n)}}class So{constructor(t,e,r,n){this.property=t,this.value=new Mo(t,void 0,e,r,n);}transitioned(t,e){return new ko(this.property,this.value,e,Object.assign({},t.transition,this.transition),t.now)}untransitioned(){return new ko(this.property,this.value,null,{},0)}}class Po{constructor(t,e,r,n){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues),this._scope=e,this._options=r,this._iconImageUseTheme=n,this._isIndoorDependent=!1,this.configDependencies=new Set;}getValue(t){return Gt(this._values[t].value.value)}setValue(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new So(this._values[t].property,this._scope,this._options,this._iconImageUseTheme)),this._values[t].value=new Mo(this._values[t].property,null===e?void 0:Gt(e),this._scope,this._options,this._iconImageUseTheme),this._values[t].value.expression.configDependencies&&(this.configDependencies=new Set([...this.configDependencies,...this._values[t].value.expression.configDependencies]),this._isIndoorDependent=this._isIndoorDependent||this._values[t].value.isIndoorDependent());}setTransitionOrValue(t,e){e&&(this._options=e);const r=this._properties.properties;if(t)for(const e in t){const n=t[e];if(e.endsWith("-transition")){const t=e.slice(0,-11);r[t]&&this.setTransition(t,n);}else r.hasOwnProperty(e)&&this.setValue(e,n);}}getTransition(t){return Gt(this._values[t].transition)}setTransition(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new So(this._values[t].property)),this._values[t].transition=Gt(e)||void 0;}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const n=this.getTransition(e);void 0!==n&&(t[`${e}-transition`]=n);}return t}transitioned(t,e){const r=new Bo(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(t,e._values[n]);return r}untransitioned(){const t=new Bo(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}isIndoorDependent(){return this._isIndoorDependent}}class ko{constructor(t,e,r,n,i){const s=n.delay||0,o=n.duration||0;i=i||0,this.property=t,this.value=e,this.begin=i+s,this.end=this.begin+o,t.specification.transition&&(n.delay||n.duration)&&(this.prior=r);}possiblyEvaluate(t,e,r){const n=t.now||0,i=this.value.possiblyEvaluate(t,e,r),s=this.prior;if(s){if(n>this.end)return this.prior=null,i;if(this.value.isDataDriven())return this.prior=null,i;if(n<this.begin)return s.possiblyEvaluate(t,e,r);{const o=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(t,e,r),i,Tt(o))}}return i}}class Bo{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues);}possiblyEvaluate(t,e,r){const n=new Eo(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return !0;return !1}}class zo{constructor(t,e,r,n){this._properties=t,this._values=Object.create(t.defaultPropertyValues),this._scope=e,this._options=r,this._iconImageUseTheme=n,this._isIndoorDependent=!1,this.configDependencies=new Set;}getValue(t){return Gt(this._values[t].value)}setValue(t,e){this._values[t]=new Mo(this._values[t].property,null===e?void 0:Gt(e),this._scope,this._options,this._iconImageUseTheme),this._values[t].expression.configDependencies&&(this.configDependencies=new Set([...this.configDependencies,...this._values[t].expression.configDependencies]),this._isIndoorDependent=this._isIndoorDependent||this._values[t].isIndoorDependent());}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);}return t}possiblyEvaluate(t,e,r,n){const i=new Eo(this._properties);for(const s of Object.keys(this._values))i._values[s]=this._values[s].possiblyEvaluate(t,e,r,n);return i}isIndoorDependent(){return this._isIndoorDependent}}class To{constructor(t,e,r,n){this.property=t,this.value=e,this.parameters=r,this.iconImageUseTheme=n;}isConstant(){return "constant"===this.value.kind}constantOr(t){return "constant"===this.value.kind?this.value.value:t}evaluate(t,e,r,n){return this.property.evaluate(this.value,this.parameters,t,e,r,n,this.iconImageUseTheme)}}class Eo{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues);}get(t){return this._values[t]}}class Vo{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return t.expression.evaluate(e)}interpolate(t,e,r){const n=fr[this.specification.type];return n?n(t,e,r):t}}class Fo{constructor(t,e){this.specification=t,this.overrides=e;}possiblyEvaluate(t,e,r,n,i){return "constant"===t.expression.kind||"camera"===t.expression.kind?new To(this,{kind:"constant",value:t.expression.evaluate(e,null,{},r,n,void 0,i)},e):new To(this,t.expression,e,i)}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new To(this,{kind:"constant",value:void 0},t.parameters);const n=fr[this.specification.type];return n?new To(this,{kind:"constant",value:n(t.value.value,e.value.value,r)},t.parameters):t}evaluate(t,e,r,n,i,s,o){return "constant"===t.kind?t.value:t.evaluate(e,r,n,i,s,void 0,o)}}class Co{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){return !!t.expression.evaluate(e,null,{},r,n)}interpolate(){return !1}}class Do{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];const e=new Io(0,{});for(const r in t){const n=t[r];n.specification.overridable&&this.overridableProperties.push(r);const i=this.defaultPropertyValues[r]=new Mo(n,void 0),s=this.defaultTransitionablePropertyValues[r]=new So(n);this.defaultTransitioningPropertyValues[r]=s.untransitioned(),this.defaultPossiblyEvaluatedValues[r]=i.possiblyEvaluate(e);}}}Qs(Fo,"DataDrivenProperty"),Qs(Vo,"DataConstantProperty"),Qs(Co,"ColorRampProperty");var Ro=JSON.parse('{"$version":8,"$root":{"version":{"type":"enum","values":[8]},"fragment":{"type":"boolean"},"name":{"type":"string"},"metadata":{"type":"*"},"center":{"type":"array","value":"number"},"zoom":{"type":"number"},"bearing":{"type":"number","default":0,"period":360},"pitch":{"type":"number","default":0},"light":{"type":"light"},"lights":{"type":"array","value":"light-3d"},"terrain":{"type":"terrain","optional":true},"fog":{"type":"fog"},"snow":{"type":"snow"},"rain":{"type":"rain"},"camera":{"type":"camera"},"color-theme":{"type":"colorTheme"},"indoor":{"type":"indoor"},"imports":{"type":"array","value":"import"},"iconsets":{"type":"iconsets"},"schema":{"type":"schema"},"sources":{"type":"sources"},"sprite":{"type":"string"},"glyphs":{"type":"string","default":"mapbox://fonts/mapbox/{fontstack}/{range}.pbf"},"transition":{"type":"transition"},"projection":{"type":"projection"},"layers":{"type":"array","value":"layer"},"models":{"type":"models"},"featuresets":{"type":"featuresets"}},"featuresets":{"*":{"type":"featureset"}},"featureset":{"metadata":{"type":"*"},"selectors":{"type":"array","value":"selector"}},"selector":{"layer":{"type":"string"},"properties":{"type":"selectorProperty"},"featureNamespace":{"type":"string"},"_uniqueFeatureID":{"type":"boolean"}},"selectorProperty":{"*":{"type":"*"}},"model":{"type":"string"},"import":{"id":{"type":"string"},"url":{"type":"string"},"config":{"type":"config"},"data":{"type":"$root"},"color-theme":{"type":"colorTheme","optional":true}},"config":{"*":{"type":"*"}},"schema":{"*":{"type":"option"}},"option":{"default":{"type":"*","expression":{}},"type":{"type":"enum","values":{"string":1,"number":1,"boolean":1,"color":1}},"array":{"type":"boolean"},"minValue":{"type":"number"},"maxValue":{"type":"number"},"stepValue":{"type":"number"},"values":{"type":"array","value":"*"},"metadata":{"type":"*"}},"models":{"*":{"type":"model"}},"light-3d":{"id":{"type":"string"},"properties":{"type":"properties"},"type":{"type":"enum","values":{"ambient":{},"directional":{},"flat":{}}}},"properties":["properties_light_directional","properties_light_ambient","properties_light_flat"],"properties_light_directional":{"direction":{"type":"array","default":[210,30],"minimum":[0,0],"maximum":[360,90],"length":2,"value":"number","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"use-theme":true,"transition":true},"intensity":{"type":"number","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"cast-shadows":{"type":"boolean","default":false},"shadow-quality":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{"parameters":["zoom"]}},"shadow-intensity":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"properties_light_ambient":{"color":{"type":"color","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"use-theme":true,"transition":true},"intensity":{"type":"number","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"properties_light_flat":{"anchor":{"type":"enum","default":"viewport","values":{"map":1,"viewport":1},"expression":{"parameters":["zoom"]}},"position":{"type":"array","default":[1.15,210,30],"length":3,"value":"number","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"use-theme":true,"transition":true},"intensity":{"type":"number","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"iconsets":{"*":{"type":"iconset"}},"iconset":["iconset_sprite","iconset_source"],"iconset_sprite":{"type":{"type":"enum","values":{"sprite":1}},"url":{"type":"string"}},"iconset_source":{"type":{"type":"enum","values":{"source":1}},"source":{"type":"string"}},"sources":{"*":{"type":"source"}},"source":["source_vector","source_raster","source_raster_dem","source_raster_array","source_geojson","source_video","source_image","source_model"],"source_vector":{"type":{"type":"enum","values":{"vector":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"extra_bounds":{"type":"array","value":{"type":"array","value":"number","length":4}},"scheme":{"type":"enum","values":{"xyz":1,"tms":1},"default":"xyz"},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"attribution":{"type":"string"},"promoteId":{"type":"promoteId"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster":{"type":{"type":"enum","values":{"raster":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"extra_bounds":{"type":"array","value":{"type":"array","value":"number","length":4}},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"scheme":{"type":"enum","values":{"xyz":1,"tms":1},"default":"xyz"},"attribution":{"type":"string"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster_dem":{"type":{"type":"enum","values":{"raster-dem":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"extra_bounds":{"type":"array","value":{"type":"array","value":"number","length":4}},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"attribution":{"type":"string"},"encoding":{"type":"enum","values":{"terrarium":1,"mapbox":1},"default":"mapbox"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster_array":{"type":{"type":"enum","values":{"raster-array":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"extra_bounds":{"type":"array","value":{"type":"array","value":"number","length":4}},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"attribution":{"type":"string"},"rasterLayers":{"type":"*"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_geojson":{"type":{"type":"enum","values":{"geojson":1}},"data":{"type":"*"},"maxzoom":{"type":"number","default":18},"minzoom":{"type":"number","default":0},"attribution":{"type":"string"},"buffer":{"type":"number","default":128,"maximum":512,"minimum":0},"filter":{"type":"*"},"tolerance":{"type":"number","default":0.375},"cluster":{"type":"boolean","default":false},"clusterRadius":{"type":"number","default":50,"minimum":0},"clusterMaxZoom":{"type":"number"},"clusterMinPoints":{"type":"number"},"clusterProperties":{"type":"*"},"lineMetrics":{"type":"boolean","default":false},"generateId":{"type":"boolean","default":false},"promoteId":{"type":"promoteId"},"dynamic":{"type":"boolean","default":false}},"source_video":{"type":{"type":"enum","values":{"video":1}},"urls":{"type":"array","value":"string"},"coordinates":{"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"source_image":{"type":{"type":"enum","values":{"image":1}},"url":{"type":"string"},"coordinates":{"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"modelNodeOverride":{"orientation":{"type":"array","value":"number","length":3,"default":[0,0,0],"period":360}},"modelNodeOverrides":{"*":{"type":"modelNodeOverride"}},"modelMaterialOverride":{"model-color":{"type":"color"},"model-color-mix-intensity":{"type":"number"},"model-opacity":{"type":"number"},"model-emissive-strength":{"type":"number"}},"modelMaterialOverrides":{"*":{"type":"modelMaterialOverride"}},"modelSourceModel":{"uri":{"type":"string"},"position":{"type":"array","value":"number","length":2,"default":[0,0],"minimum":[-180,-90],"maximum":[180,90]},"orientation":{"type":"array","value":"number","length":3,"default":[0,0,0],"period":360},"nodeOverrides":{"type":"modelNodeOverrides"},"materialOverrides":{"type":"modelMaterialOverrides"},"nodeOverrideNames":{"type":"array","value":"string"},"materialOverrideNames":{"type":"array","value":"string"},"featureProperties":{"type":"*"}},"modelSourceModels":{"*":{"type":"modelSourceModel"}},"source_model":{"type":{"type":"enum","values":{"model":1,"batched-model":1}},"maxzoom":{"type":"number","default":18},"minzoom":{"type":"number","default":0},"tiles":{"type":"array","value":"string"},"models":{"type":"modelSourceModels"}},"layer":{"id":{"type":"string"},"type":{"type":"enum","values":{"fill":{},"line":{},"symbol":{},"circle":{},"heatmap":{},"fill-extrusion":{},"building":{},"raster":{},"raster-particle":{},"hillshade":{},"model":{},"background":{},"sky":{},"slot":{},"clip":{}}},"metadata":{"type":"*"},"source":{"type":"string"},"source-layer":{"type":"string"},"slot":{"type":"string"},"minzoom":{"type":"number","minimum":0,"maximum":24},"maxzoom":{"type":"number","minimum":0,"maximum":24},"filter":{"type":"filter"},"layout":{"type":"layout"},"paint":{"type":"paint"},"appearances":{"type":"array","value":"appearance","supported-layer-types":["symbol"]}},"appearance":{"condition":{"type":"boolean","expression":{"interpolated":true,"parameters":["zoom","pitch","feature","feature-state","measure-light","distance-from-center"]},"property-type":"data-driven"},"name":{"type":"string"},"properties":{"type":"*"}},"layout":["layout_clip","layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_building","layout_symbol","layout_raster","layout_raster-particle","layout_hillshade","layout_background","layout_sky","layout_model"],"layout_background":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}}},"layout_sky":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}}},"layout_model":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}},"model-id":{"type":"string","default":"","property-type":"data-driven","expression":{"parameters":["zoom","feature"]}}},"layout_clip":{"clip-layer-types":{"type":"array","value":"enum","values":{"model":1,"symbol":1},"default":[],"expression":{}},"clip-layer-scope":{"type":"array","value":"string","default":[],"expression":{}}},"layout_fill":{"fill-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}},"fill-elevation-reference":{"type":"enum","values":{"none":1,"hd-road-base":1,"hd-road-markup":1},"default":"none","expression":{}},"fill-construct-bridge-guard-rail":{"type":"boolean","default":"true","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"}},"layout_circle":{"circle-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"circle-elevation-reference":{"type":"enum","values":{"none":1,"hd-road-markup":1},"default":"none","expression":{}},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}}},"layout_heatmap":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}}},"layout_fill-extrusion":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}},"fill-extrusion-edge-radius":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{}}},"layout_building":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}},"building-facade":{"type":"boolean","default":false,"expression":{"parameters":["feature"]},"property-type":"data-driven"},"building-facade-floors":{"type":"number","minimum":1,"maximum":200,"default":3,"property-type":"data-driven","expression":{"parameters":["feature"]}},"building-facade-unit-width":{"type":"number","minimum":1,"maximum":20,"default":3.1,"property-type":"data-driven","expression":{"parameters":["feature"]}},"building-facade-window":{"type":"array","length":2,"value":"number","minimum":0.1,"maximum":1,"default":[0.9,0.9],"property-type":"data-driven","expression":{"parameters":["feature"]}},"building-roof-shape":{"type":"enum","values":{"flat":1,"hipped":1,"gabled":1,"parapet":1,"mansard":1,"skillion":1,"pyramidal":1},"default":"flat","expression":{"parameters":["feature"]},"property-type":"data-driven"},"building-height":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{},"property-type":"data-driven"},"building-base":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{},"property-type":"data-driven"},"building-flood-light-wall-radius":{"property-type":"data-driven","type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state"]}},"building-flood-light-ground-radius":{"property-type":"data-driven","type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state"]}},"building-flip-roof-orientation":{"property-type":"data-driven","type":"boolean","default":false,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state"]}}},"layout_line":{"line-cap":{"type":"enum","values":{"butt":1,"round":1,"square":1},"default":"butt","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-join":{"type":"enum","values":{"bevel":1,"round":1,"miter":1,"none":1},"default":"miter","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{"type":"number","default":2,"expression":{"interpolated":true,"parameters":["zoom"]}},"line-round-limit":{"type":"number","default":1.05,"expression":{"interpolated":true,"parameters":["zoom"]}},"line-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-z-offset":{"type":"number","default":0,"expression":{"parameters":["zoom","feature","line-progress"]},"property-type":"data-driven"},"line-elevation-reference":{"type":"enum","values":{"none":1,"sea":1,"ground":1,"hd-road-markup":1},"default":"none","expression":{}},"line-cross-slope":{"type":"number","expression":{}},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}},"line-width-unit":{"type":"enum","values":{"pixels":1,"meters":1},"default":"pixels","expression":{"parameters":["zoom"]}}},"layout_symbol":{"symbol-placement":{"type":"enum","values":{"point":1,"line":1,"line-center":1},"default":"point","expression":{"parameters":["zoom"]}},"symbol-spacing":{"type":"number","default":250,"minimum":1,"expression":{"interpolated":true,"parameters":["zoom"]}},"symbol-avoid-edges":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]}},"symbol-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{"type":"enum","values":{"auto":1,"viewport-y":1,"source":1},"default":"auto","expression":{"parameters":["zoom"]}},"symbol-z-elevate":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]}},"symbol-elevation-reference":{"type":"enum","values":{"sea":1,"ground":1,"hd-road-markup":1},"default":"ground","expression":{"parameters":["zoom"]}},"icon-allow-overlap":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]}},"icon-ignore-placement":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]}},"icon-optional":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]}},"icon-rotation-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]}},"icon-size":{"type":"number","default":1,"minimum":0,"appearance":true,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-size-scale-range":{"type":"array","value":"number","length":2,"default":[0.8,2],"minimum":[0.1,0.1],"maximum":[10,10],"expression":{}},"icon-text-fit":{"type":"enum","values":{"none":1,"width":1,"height":1,"both":1},"default":"none","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit-padding":{"type":"array","value":"number","length":4,"default":[0,0,0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-image":{"type":"resolvedImage","tokens":true,"appearance":true,"use-theme":true,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{"type":"number","default":0,"period":360,"appearance":true,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{"type":"number","default":2,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]}},"icon-keep-upright":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]}},"icon-offset":{"type":"array","value":"number","length":2,"default":[0,0],"appearance":true,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{"type":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]}},"text-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]}},"text-rotation-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]}},"text-field":{"type":"formatted","default":"","tokens":true,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-font":{"type":"array","value":"string","default":["Open Sans Regular","Arial Unicode MS Regular"],"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-size":{"type":"number","default":16,"minimum":0,"appearance":true,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-size-scale-range":{"type":"array","value":"number","length":2,"default":[0.8,2],"minimum":[0.1,0.1],"maximum":[10,10],"expression":{}},"text-max-width":{"type":"number","default":10,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{"type":"number","default":1.2,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-letter-spacing":{"type":"number","default":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-justify":{"type":"enum","values":{"auto":1,"left":1,"center":1,"right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{"type":"number","default":0,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["zoom","feature"]}},"text-variable-anchor":{"type":"array","value":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"expression":{"parameters":["zoom"]}},"text-anchor":{"type":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{"type":"number","default":45,"expression":{"interpolated":true,"parameters":["zoom"]}},"text-writing-mode":{"type":"array","value":"enum","values":{"horizontal":1,"vertical":1},"expression":{"parameters":["zoom"]}},"text-rotate":{"type":"number","default":0,"period":360,"appearance":true,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-padding":{"type":"number","default":2,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]}},"text-keep-upright":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]}},"text-transform":{"type":"enum","values":{"none":1,"uppercase":1,"lowercase":1},"default":"none","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-offset":{"type":"array","value":"number","length":2,"default":[0,0],"appearance":true,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]}},"text-ignore-placement":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]}},"text-optional":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]}},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}}},"layout_raster":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}}},"layout_raster-particle":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}}},"layout_hillshade":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{}}},"filter":{"type":"array","value":"*"},"filter_symbol":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature","pitch","distance-from-center"]}},"filter_fill":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_hillshade":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_raster":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_raster-particle":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_clip":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_model":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_line":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_circle":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_fill-extrusion":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_building":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_heatmap":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_operator":{"type":"enum","values":{"==":1,"!=":1,">":1,">=":1,"<":1,"<=":1,"in":1,"!in":1,"all":1,"any":1,"none":1,"has":1,"!has":1}},"geometry_type":{"type":"enum","values":{"Point":1,"LineString":1,"Polygon":1}},"function":{"expression":{"type":"expression"},"stops":{"type":"array","value":"function_stop"},"base":{"type":"number","default":1,"minimum":0},"property":{"type":"string","default":"$zoom"},"type":{"type":"enum","values":{"identity":1,"exponential":1,"interval":1,"categorical":1},"default":"exponential"},"colorSpace":{"type":"enum","values":{"rgb":1,"lab":1,"hcl":1},"default":"rgb"},"default":{"type":"*"}},"function_stop":{"type":"array","minimum":0,"maximum":24,"value":["number","color"],"length":2},"expression":{"type":"array","value":"*","minimum":1},"fog":{"range":{"type":"array","default":[0.5,10],"minimum":-20,"maximum":20,"length":2,"value":"number","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}},"color":{"type":"color","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"use-theme":true,"transition":true},"high-color":{"type":"color","default":"#245cdf","expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"use-theme":true,"transition":true},"space-color":{"type":"color","default":["interpolate",["linear"],["zoom"],4,"#010b19",7,"#367ab9"],"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"use-theme":true,"transition":true},"horizon-blend":{"type":"number","default":["interpolate",["linear"],["zoom"],4,0.2,7,0.1],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"star-intensity":{"type":"number","default":["interpolate",["linear"],["zoom"],5,0.35,6,0],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vertical-range":{"type":"array","default":[0,0],"minimum":0,"length":2,"value":"number","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}}},"snow":{"density":{"type":"number","default":["interpolate",["linear"],["zoom"],11,0,13,0.85],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"intensity":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"color":{"type":"color","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"use-theme":true,"transition":true},"opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vignette":{"type":"number","default":["interpolate",["linear"],["zoom"],11,0,13,0.3],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vignette-color":{"type":"color","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"use-theme":true,"transition":true},"center-thinning":{"type":"number","default":0.4,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"direction":{"type":"array","default":[0,50],"minimum":0,"maximum":360,"length":2,"value":"number","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}},"flake-size":{"type":"number","default":0.71,"minimum":0,"maximum":5,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true}},"rain":{"density":{"type":"number","default":["interpolate",["linear"],["zoom"],11,0,13,0.5],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"intensity":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"color":{"type":"color","default":["interpolate",["linear"],["measure-light","brightness"],0,"#03113d",0.3,"#a8adbc"],"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"use-theme":true,"transition":true},"opacity":{"type":"number","default":["interpolate",["linear"],["measure-light","brightness"],0,0.88,1,0.7],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vignette":{"type":"number","default":["interpolate",["linear"],["zoom"],11,0,13,1],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vignette-color":{"type":"color","default":["interpolate",["linear"],["measure-light","brightness"],0,"#001736",0.3,"#464646"],"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"use-theme":true,"transition":true},"center-thinning":{"type":"number","default":0.57,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"direction":{"type":"array","default":[0,80],"minimum":0,"maximum":360,"length":2,"value":"number","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}},"droplet-size":{"type":"array","default":[2.6,18.2],"minimum":0,"maximum":50,"length":2,"value":"number","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}},"distortion-strength":{"type":"number","default":0.7,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true}},"camera":{"camera-projection":{"type":"enum","values":{"perspective":1,"orthographic":1},"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"default":"perspective"}},"colorTheme":{"data":{"type":"string","expression":{}}},"indoor_source":{"sourceId":{"type":"string"},"sourceLayers":{"type":"array","value":"string"}},"indoor":{"*":{"type":"indoor_source"}},"light":{"anchor":{"type":"enum","default":"viewport","values":{"map":1,"viewport":1},"expression":{"parameters":["zoom"]}},"position":{"type":"array","default":[1.15,210,30],"length":3,"value":"number","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"use-theme":true,"transition":true},"intensity":{"type":"number","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"projection":{"name":{"type":"enum","values":{"albers":1,"equalEarth":1,"equirectangular":1,"lambertConformalConic":1,"mercator":1,"naturalEarth":1,"winkelTripel":1,"globe":1},"default":"mercator"},"center":{"type":"array","length":2,"value":"number","minimum":[-180,-90],"maximum":[180,90]},"parallels":{"type":"array","length":2,"value":"number","minimum":[-90,-90],"maximum":[90,90]}},"terrain":{"source":{"type":"string"},"exaggeration":{"type":"number","default":1,"minimum":0,"maximum":1000,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"paint":["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_building","paint_symbol","paint_raster","paint_raster-particle","paint_hillshade","paint_background","paint_sky","paint_model"],"paint_fill":{"fill-antialias":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]}},"fill-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-color":{"type":"color","default":"#000000","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-outline-color":{"type":"color","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]}},"fill-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-pattern-cross-fade":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-z-offset":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-bridge-guard-rail-color":{"type":"color","default":"rgba(241, 236, 225, 255)","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light","feature"]},"property-type":"data-driven"},"fill-tunnel-structure-color":{"type":"color","default":"rgba(241, 236, 225, 255)","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light","feature"]},"property-type":"data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-color":{"type":"color","default":"#000000","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-extrusion-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]}},"fill-extrusion-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-extrusion-pattern-cross-fade":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-extrusion-height":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-height-alignment":{"type":"enum","values":{"terrain":1,"flat":1},"default":"flat"},"fill-extrusion-base-alignment":{"type":"enum","values":{"terrain":1,"flat":1},"default":"terrain"},"fill-extrusion-vertical-gradient":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]}},"fill-extrusion-ambient-occlusion-intensity":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-radius":{"type":"number","default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-wall-radius":{"type":"number","default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-ground-radius":{"type":"number","default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-ground-attenuation":{"type":"number","default":0.69,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-flood-light-color":{"type":"color","default":"#ffffff","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-extrusion-flood-light-intensity":{"type":"number","default":0,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-extrusion-flood-light-wall-radius":{"property-type":"data-driven","type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state"]}},"fill-extrusion-flood-light-ground-radius":{"property-type":"data-driven","type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state"]}},"fill-extrusion-flood-light-ground-attenuation":{"type":"number","default":0.69,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-vertical-scale":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-rounded-roof":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]}},"fill-extrusion-cutoff-fade-range":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{}},"fill-extrusion-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light","feature-state"]},"property-type":"data-driven"},"fill-extrusion-line-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-extrusion-cast-shadows":{"type":"boolean","default":true}},"paint_building":{"building-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"building-ambient-occlusion-intensity":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{"parameters":[]},"transition":true},"building-ambient-occlusion-ground-intensity":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"building-ambient-occlusion-ground-radius":{"type":"number","default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"building-ambient-occlusion-ground-attenuation":{"type":"number","default":0.69,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"building-vertical-scale":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"building-cast-shadows":{"type":"boolean","default":true},"building-color":{"type":"color","default":"rgba(193, 154, 127, 1)","use-theme":true,"expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"property-type":"data-driven"},"building-emissive-strength":{"type":"number","default":0,"minimum":0,"maximum":5,"expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"property-type":"data-driven"},"building-facade-emissive-chance":{"type":"number","default":0.35,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["measure-light","zoom"]}},"building-cutoff-fade-range":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{}},"building-flood-light-color":{"type":"color","default":"#ffffff","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"building-flood-light-intensity":{"type":"number","default":0,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"building-flood-light-ground-attenuation":{"type":"number","default":0.69,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}}},"paint_line":{"line-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-color":{"type":"color","default":"#000000","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"line-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]}},"line-width":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light","line-progress"]},"property-type":"data-driven"},"line-gap-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-offset":{"type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-dasharray":{"type":"array","value":"number","minimum":0,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-pattern-cross-fade":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"line-gradient":{"type":"color","use-theme":true,"expression":{"interpolated":true,"parameters":["line-progress"]}},"line-trim-offset":{"type":"array","value":"number","length":2,"default":[0,0],"minimum":[0,0],"maximum":[1,1]},"line-trim-fade-range":{"type":"array","value":"number","length":2,"default":[0,0],"minimum":[0,0],"maximum":[1,1],"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"line-trim-color":{"type":"color","default":"transparent","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"line-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-driven"},"line-border-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-border-color":{"type":"color","default":"rgba(0, 0, 0, 0)","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-occlusion-opacity":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"paint_circle":{"circle-radius":{"type":"number","default":5,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-color":{"type":"color","default":"#000000","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-blur":{"type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"circle-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]}},"circle-pitch-scale":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]}},"circle-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1},"default":"viewport","expression":{"parameters":["zoom"]}},"circle-stroke-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-stroke-color":{"type":"color","default":"#000000","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-stroke-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}}},"paint_heatmap":{"heatmap-radius":{"type":"number","default":30,"minimum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"heatmap-weight":{"type":"number","default":1,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"heatmap-intensity":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"heatmap-color":{"type":"color","default":["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",0.1,"royalblue",0.3,"cyan",0.5,"lime",0.7,"yellow",1,"red"],"use-theme":true,"expression":{"interpolated":true,"parameters":["heatmap-density"]}},"heatmap-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}}},"paint_symbol":{"icon-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-occlusion-opacity":{"type":"number","minimum":0,"maximum":1,"default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-emissive-strength":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light","feature-state"]},"property-type":"data-driven"},"text-emissive-strength":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light","feature-state"]},"property-type":"data-driven"},"icon-color":{"type":"color","default":"#000000","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"icon-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]}},"icon-image-cross-fade":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"text-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-occlusion-opacity":{"type":"number","minimum":0,"maximum":1,"default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-color":{"type":"color","default":"#000000","use-theme":true,"transition":true,"overridable":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"text-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]}},"icon-color-saturation":{"type":"number","default":0,"minimum":-1,"maximum":1,"expression":{}},"icon-color-contrast":{"type":"number","default":0,"minimum":-1,"maximum":1,"expression":{}},"icon-color-brightness-min":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{}},"icon-color-brightness-max":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{}},"symbol-z-offset":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"}},"paint_raster":{"raster-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-color":{"type":"color","use-theme":true,"expression":{"interpolated":true,"parameters":["raster-value"]}},"raster-color-mix":{"type":"array","default":[0.2126,0.7152,0.0722,0],"length":4,"value":"number","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-color-range":{"type":"array","length":2,"value":"number","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-hue-rotate":{"type":"number","default":0,"period":360,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-brightness-min":{"type":"number","default":0,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-brightness-max":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-saturation":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-contrast":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-resampling":{"type":"enum","values":{"linear":1,"nearest":1},"default":"linear","expression":{"parameters":["zoom"]}},"raster-fade-duration":{"type":"number","default":300,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"raster-array-band":{"type":"string"},"raster-elevation":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}}},"paint_raster-particle":{"raster-particle-array-band":{"type":"string"},"raster-particle-count":{"type":"number","default":512,"minimum":1},"raster-particle-color":{"type":"color","use-theme":true,"expression":{"interpolated":true,"parameters":["raster-particle-speed"]}},"raster-particle-max-speed":{"type":"number","default":1,"minimum":1},"raster-particle-speed-factor":{"type":"number","default":0.2,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-particle-fade-opacity-factor":{"type":"number","default":0.98,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-particle-reset-rate-factor":{"type":"number","default":0.8,"minimum":0,"maximum":1},"raster-particle-elevation":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}}},"paint_hillshade":{"hillshade-illumination-direction":{"type":"number","default":335,"minimum":0,"maximum":359,"expression":{"interpolated":true,"parameters":["zoom"]}},"hillshade-illumination-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"viewport","expression":{"parameters":["zoom"]}},"hillshade-exaggeration":{"type":"number","default":0.5,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"hillshade-shadow-color":{"type":"color","default":"#000000","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"hillshade-highlight-color":{"type":"color","default":"#FFFFFF","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"hillshade-accent-color":{"type":"color","default":"#000000","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"hillshade-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}}},"paint_background":{"background-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":[]}},"background-color":{"type":"color","default":"#000000","use-theme":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"background-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom"]}},"background-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"background-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}}},"paint_sky":{"sky-type":{"type":"enum","values":{"gradient":1,"atmosphere":1},"default":"atmosphere","expression":{"parameters":["zoom"]}},"sky-atmosphere-sun":{"type":"array","value":"number","length":2,"minimum":[0,0],"maximum":[360,180],"expression":{"parameters":["zoom"]}},"sky-atmosphere-sun-intensity":{"type":"number","default":10,"minimum":0,"maximum":100},"sky-gradient-center":{"type":"array","value":"number","default":[0,0],"length":2,"minimum":[0,0],"maximum":[360,180],"expression":{"parameters":["zoom"]}},"sky-gradient-radius":{"type":"number","default":90,"minimum":0,"maximum":180,"expression":{"parameters":["zoom"]}},"sky-gradient":{"type":"color","default":["interpolate",["linear"],["sky-radial-progress"],0.8,"#87ceeb",1,"white"],"use-theme":true,"expression":{"interpolated":true,"parameters":["sky-radial-progress"]}},"sky-atmosphere-halo-color":{"type":"color","default":"white","use-theme":true},"sky-atmosphere-color":{"type":"color","default":"white","use-theme":true},"sky-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}}},"paint_model":{"model-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"property-type":"data-driven"},"model-rotation":{"type":"array","value":"number","length":3,"default":[0,0,0],"period":360,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-scale":{"type":"array","value":"number","length":3,"default":[1,1,1],"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-translation":{"type":"array","value":"number","length":3,"default":[0,0,0],"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-color":{"type":"color","default":"#ffffff","property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light","zoom"]},"use-theme":true,"transition":true},"model-color-mix-intensity":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-type":{"type":"enum","values":{"common-3d":1,"location-indicator":1},"default":"common-3d"},"model-cast-shadows":{"type":"boolean","default":true},"model-receive-shadows":{"type":"boolean","default":true},"model-ambient-occlusion-intensity":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"model-emissive-strength":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":5,"expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-roughness":{"type":"number","default":1,"minimum":0,"maximum":1,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state"]},"transition":true},"model-height-based-emissive-strength-multiplier":{"type":"array","default":[1,1,1,1,0],"length":5,"value":"number","property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-cutoff-fade-range":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{}},"model-front-cutoff":{"type":"array","value":"number","expression":{"interpolated":true,"parameters":["zoom"]},"length":3,"default":[0,0,1],"minimum":[0,0,0],"maximum":[1,1,1]},"model-elevation-reference":{"type":"enum","values":{"sea":1,"ground":1,"hd-road-markup":1},"default":"ground","expression":{}}},"transition":{"duration":{"type":"number","default":300,"minimum":0},"delay":{"type":"number","default":0,"minimum":0}},"promoteId":{"*":{"type":"*"}}}');function Lo(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function Oo(t){if(Array.isArray(t))return t.map(Oo);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=Oo(t[r]);return e}return Lo(t)}function Uo(t){if(!0===t||!1===t)return !0;if(!Array.isArray(t)||0===t.length)return !1;switch(t[0]){case "has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case "in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case "!in":case "!has":case "none":return !1;case "==":case "!=":case ">":case ">=":case "<":case "<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case "any":case "all":for(const e of t.slice(1))if(!Uo(e)&&"boolean"!=typeof e)return !1;return !0;default:return !0}}function No(t,e="",r=null,n="fill"){if(null==t)return {filter:()=>!0,needGeometry:!1,needFeature:!1};Uo(t)||(t=Zo(t));const i=t;let s=!0;try{s=function(t){if(!Go(t))return t;let e=Oo(t);return $o(e),e=jo(e),e}(i);}catch(t){console.warn(`Failed to extract static filter. Filter will continue working, but at higher memory usage and slower framerate.\nThis is most likely a bug, please report this via https://github.com/mapbox/mapbox-gl-js/issues/new?assignees=&labels=&template=Bug_report.md\nand paste the contents of this message in the report.\nThank you!\nFilter Expression:\n${JSON.stringify(i,null,2)}\n        `);}let o=null,a=null;if("background"!==n&&"sky"!==n&&"slot"!==n){a=Ro[`filter_${n}`];const t=js(s,a,e,r);if("error"===t.result)throw new Error(t.value.map((t=>`${t.key}: ${t.message}`)).join(", "));o=(e,r,n)=>t.value.evaluate(e,r,{},n);}let l=null,u=null;if(s!==i){const t=js(i,a,e,r);if("error"===t.result)throw new Error(t.value.map((t=>`${t.key}: ${t.message}`)).join(", "));l=(e,r,n,i,s)=>t.value.evaluate(e,r,{},n,void 0,void 0,i,s),u=!gi(t.value.expression);}return {filter:o,dynamicFilter:l||void 0,needGeometry:Xo(s),needFeature:!!u}}function jo(t){if(!Array.isArray(t))return t;const e=function(t){if(qo.has(t[0]))for(let e=1;e<t.length;e++)if(Go(t[e]))return !0;return t}(t);return !0===e?e:e.map((t=>jo(t)))}function $o(t){let e=!1;const r=[];if("case"===t[0]){for(let n=1;n<t.length-1;n+=2)e=e||Go(t[n]),r.push(t[n+1]);r.push(t[t.length-1]);}else if("match"===t[0]){e=e||Go(t[1]);for(let e=2;e<t.length-1;e+=2)r.push(t[e+1]);r.push(t[t.length-1]);}else if("step"===t[0]){e=e||Go(t[1]);for(let e=1;e<t.length-1;e+=2)r.push(t[e+1]);}e&&(t.length=0,t.push("any",...r));for(let e=1;e<t.length;e++)$o(t[e]);}function Go(t){if(!Array.isArray(t))return !1;if("pitch"===(e=t[0])||"distance-from-center"===e)return !0;var e;for(let e=1;e<t.length;e++)if(Go(t[e]))return !0;return !1}const qo=new Set(["in","==","!=",">",">=","<","<=","to-boolean"]);function Ho(t,e){return t<e?-1:t>e?1:0}function Xo(t){if(!Array.isArray(t))return !1;if("within"===t[0]||"distance"===t[0])return !0;for(let e=1;e<t.length;e++)if(Xo(t[e]))return !0;return !1}function Zo(t){if(!t)return !0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?Wo(t[1],t[2],"=="):"!="===e?Jo(Wo(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?Wo(t[1],t[2],e):"any"===e?(r=t.slice(1),["any"].concat(r.map(Zo))):"all"===e?["all"].concat(t.slice(1).map(Zo)):"none"===e?["all"].concat(t.slice(1).map(Zo).map(Jo)):"in"===e?Yo(t[1],t.slice(2)):"!in"===e?Jo(Yo(t[1],t.slice(2))):"has"===e?Ko(t[1]):"!has"!==e||Jo(Ko(t[1]));var r;}function Wo(t,e,r){switch(t){case "$type":return [`filter-type-${r}`,e];case "$id":return [`filter-id-${r}`,e];default:return [`filter-${r}`,t,e]}}function Yo(t,e){if(0===e.length)return !1;switch(t){case "$type":return ["filter-type-in",["literal",e]];case "$id":return ["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(Ho)]]:["filter-in-small",t,["literal",e]]}}function Ko(t){switch(t){case "$type":return !0;case "$id":return ["filter-has-id"];default:return ["filter-has",t]}}function Jo(t){return ["!",t]}const Qo="";function ta(t,e){return e?`${t}${Qo}${e}`:t}let ea;const ra=()=>ea||(ea=new Do({"icon-size":new Fo(Ro.layout_symbol["icon-size"]),"icon-image":new Fo(Ro.layout_symbol["icon-image"]),"icon-rotate":new Fo(Ro.layout_symbol["icon-rotate"]),"icon-offset":new Fo(Ro.layout_symbol["icon-offset"]),"text-size":new Fo(Ro.layout_symbol["text-size"]),"text-rotate":new Fo(Ro.layout_symbol["text-rotate"]),"text-offset":new Fo(Ro.layout_symbol["text-offset"])}));class na{constructor(t,e,r,n,i,s){const o=js(t,Ro.appearance.condition);if("success"===o.result&&(this.condition=o.value),this.name=e,r){this.properties=new Eo(ra()),this.unevaluatedLayout=new zo(ra(),n,i,s);for(const t in r)this.unevaluatedLayout.setValue(t,r[t]);}}isActive(t){return !(this.condition||!t.isHidden||"hidden"!==this.name)||this.condition.evaluate(t.globals,t.feature,t.featureState,t.canonical)}getCondition(){return this.condition}getName(){return this.name}getProperty(t){return this.properties.get(t)}getUnevaluatedProperties(){return this.unevaluatedLayout}getUnevaluatedProperty(t){return this.unevaluatedLayout._values[t]}recalculate(t,e,r){this.unevaluatedLayout&&(this.properties=this.unevaluatedLayout.possiblyEvaluate(t,void 0,e,r));}serialize(){const t={};return t.condition=this.condition.expression.serialize(),this.name&&(t.name=this.name),this.unevaluatedLayout&&(t.properties=this.unevaluatedLayout.serialize()),t}hasIconProperties(){const t=this.hasProperty("icon-image"),e=this.hasProperty("icon-size"),r=this.hasProperty("icon-offset"),n=this.hasProperty("icon-rotate");return t||e||r||n}hasTextProperties(){const t=this.hasProperty("text-size"),e=this.hasProperty("text-offset"),r=this.hasProperty("text-rotate");return t||e||r}hasProperty(t){return void 0!==this.getUnevaluatedProperty(t).value}}const ia="-transition",sa=new Set(["fill","line","background","hillshade","raster"]);class oa extends nr{constructor(t,e,r,n,i,s){if(super(),this.id=t.id,this.fqid=ta(this.id,r),this.type=t.type,this.scope=r,this.lut=n,this.options=i,this.iconImageUseTheme=s,this.appearances=new Array,this._featureFilter={filter:()=>!0,needGeometry:!1,needFeature:!1},this._filterCompiled=!1,this.expressionDependencies={isIndoorDependent:!1,configDependencies:new Set},"custom"!==t.type){if(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,t.type&&"background"!==t.type&&"sky"!==t.type&&"slot"!==t.type){this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter;const e=js(this.filter,Ro[`filter_${t.type}`]);"error"!==e.result&&(this.expressionDependencies.configDependencies=new Set([...this.expressionDependencies.configDependencies,...e.value.configDependencies]),this.expressionDependencies.isIndoorDependent=this.expressionDependencies.isIndoorDependent||e.value.isIndoorDependent);}if(t.slot&&(this.slot=t.slot),t.appearances&&this.setAppearances(t.appearances),e.layout&&(this._unevaluatedLayout=new zo(e.layout,this.scope,i,this.iconImageUseTheme),this.expressionDependencies.configDependencies=new Set([...this.expressionDependencies.configDependencies,...this._unevaluatedLayout.configDependencies]),this.expressionDependencies.isIndoorDependent=this.expressionDependencies.isIndoorDependent||this._unevaluatedLayout.isIndoorDependent()),e.paint){this._transitionablePaint=new Po(e.paint,this.scope,i);for(const e in t.paint)this.setPaintProperty(e,t.paint[e]);for(const e in t.layout)this.setLayoutProperty(e,t.layout[e]);this.expressionDependencies.configDependencies=new Set([...this.expressionDependencies.configDependencies,...this._transitionablePaint.configDependencies]),this.expressionDependencies.isIndoorDependent=this.expressionDependencies.isIndoorDependent||this._transitionablePaint.isIndoorDependent(),this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new Eo(e.paint);}}}onAdd(t){}onRemove(t){}isDraped(t){return !this.is3D(!0)&&sa.has(this.type)}getLayoutProperty(t){return "visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}setLayoutProperty(t,e){if("custom"===this.type&&"visibility"===t)return void(this.visibility=e);const r=this._unevaluatedLayout;r._properties.properties[t]&&(r.setValue(t,e),this.expressionDependencies.configDependencies=new Set([...this.expressionDependencies.configDependencies,...r.configDependencies]),this.expressionDependencies.isIndoorDependent=this.expressionDependencies.isIndoorDependent||r.isIndoorDependent(),"visibility"===t&&this.possiblyEvaluateVisibility());}setAppearances(t){this.appearances=[],t.forEach((t=>{this.appearances.push(new na(t.condition,t.name,t.properties,this.scope,this.options,this.iconImageUseTheme));}));}possiblyEvaluateVisibility(){this._unevaluatedLayout._values.visibility&&(this.visibility=this._unevaluatedLayout._values.visibility.possiblyEvaluate({zoom:0}));}getPaintProperty(t){return t.endsWith(ia)?this._transitionablePaint.getTransition(t.slice(0,-11)):this._transitionablePaint.getValue(t)}isPaintProperty(t){return !!this._transitionablePaint._properties.properties[t]}setPaintProperty(t,e){const r=this._transitionablePaint,n=r._properties.properties;if(t.endsWith(ia)){const i=t.slice(0,-11);return n[i]&&r.setTransition(i,e||void 0),!1}if(!n[t])return !1;const i=r._values[t],s=i.value.isDataDriven(),o=i.value;r.setValue(t,e),this.expressionDependencies.configDependencies=new Set([...this.expressionDependencies.configDependencies,...r.configDependencies]),this.expressionDependencies.isIndoorDependent=this.expressionDependencies.isIndoorDependent||r.isIndoorDependent(),this._handleSpecialPaintPropertyUpdate(t);const a=r._values[t].value,l=a.isDataDriven(),u=t.endsWith("pattern")||"line-dasharray"===t;return l||s||u||this._handleOverridablePaintPropertyUpdate(t,o,a)}_handleSpecialPaintPropertyUpdate(t){}getProgramIds(){return null}getDefaultProgramParams(t,e,r){return null}_handleOverridablePaintPropertyUpdate(t,e,r){return !1}isHidden(t){return !!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint);}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e,this.iconImageUseTheme)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e);}serialize(){const t={id:this.id,type:this.type,slot:this.slot,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return 0!==this.appearances.length&&(t.appearances=this.appearances.map((t=>t.serialize()))),$t(t,((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}is3D(t){return !1}hasElevation(){return !1}isSky(){return !1}isTileClipped(){return !1}hasOffscreenPass(){return !1}hasShadowPass(){return !1}canCastShadows(){return !1}hasLightBeamPass(){return !1}cutoffRange(){return 0}tileCoverLift(){return 0}resize(){}_clear(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof To&&ks(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return !0}for(const t of this.appearances)if(!xi(t.condition.expression))return !0;return !1}compileFilter(t){this._filterCompiled||(this._featureFilter=No(this.filter,this.scope,t),this._filterCompiled=!0);}invalidateCompiledFilter(){this._filterCompiled=!1;}dynamicFilter(){return this._featureFilter.dynamicFilter}dynamicFilterNeedsFeature(){return this._featureFilter.needFeature}getLayerRenderingStats(){return this._stats}resetLayerRenderingStats(t){this._stats&&("shadow"===t.renderPass?this._stats.numRenderedVerticesInShadowPass=0:this._stats.numRenderedVerticesInTransparentPass=0);}getAppearances(){return this.appearances}queryRenderedFeatures(t,e,r){return {}}queryRadius(t){}queryIntersectsFeature(t,e,r,n,i,s,o,a,l){}}const aa={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class la{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8;}}const ua=new ArrayBuffer(0);class ca{constructor(){this._reallocCount=0,this.capacity=0,this.length=0;}static serialize(t,e){return t._trim(),e&&t.arrayBuffer&&e.add(t.arrayBuffer),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,t.arrayBuffer?e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement:(e.capacity=0,e.arrayBuffer=ua),e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews());}clear(){this.length=0;}resize(t){this.reserve(t),this.length=t;}reserve(t){if(t>this.capacity){this._reallocCount++,this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e);}}reserveForAdditional(t){this.reserve(this.length+t);}_refreshViews(){throw new Error("StructArray#_refreshViews() must be implemented by each concrete StructArray layout")}emplace(...t){throw new Error("StructArray#emplace() must be implemented by each concrete StructArray layout")}emplaceBack(...t){throw new Error("StructArray#emplaceBack() must be implemented by each concrete StructArray layout")}destroy(){this.int8=this.uint8=this.int16=this.uint16=this.int32=this.uint32=this.float32=null,this.arrayBuffer=null;}}function ha(t,e=1){let r=0,n=0;return {members:t.map((t=>{const i=aa[t.type].BYTES_PER_ELEMENT,s=r=pa(r,Math.max(e,i)),o=t.components||1;return n=Math.max(n,i),r+=i*o,{name:t.name,type:t.type,components:o,offset:s}})),size:pa(r,Math.max(n,e)),alignment:e}}function pa(t,e){return Math.ceil(t/e)*e}class da extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.int16[n+0]=e,this.int16[n+1]=r,t}}da.prototype.bytesPerElement=4,Qs(da,"StructArrayLayout2i4");class fa extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.int16[i+2]=n,t}}fa.prototype.bytesPerElement=6,Qs(fa,"StructArrayLayout3i6");class ma extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.int16[s+0]=e,this.int16[s+1]=r,this.int16[s+2]=n,this.int16[s+3]=i,t}}ma.prototype.bytesPerElement=8,Qs(ma,"StructArrayLayout4i8");class ya extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}ya.prototype.bytesPerElement=4,Qs(ya,"StructArrayLayout1f4");class ga extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=4*t,s=2*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.float32[s+1]=n,t}}ga.prototype.bytesPerElement=8,Qs(ga,"StructArrayLayout2i1f8");class xa extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=4*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.int16[i+2]=n,t}}xa.prototype.bytesPerElement=8,Qs(xa,"StructArrayLayout3i8");class va extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const o=5*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=i,this.int16[o+4]=s,t}}va.prototype.bytesPerElement=10,Qs(va,"StructArrayLayout5i10");class ba extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s,o)}emplace(t,e,r,n,i,s,o,a){const l=6*t,u=12*t,c=3*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.uint8[u+4]=n,this.uint8[u+5]=i,this.uint8[u+6]=s,this.uint8[u+7]=o,this.float32[c+2]=a,t}}ba.prototype.bytesPerElement=12,Qs(ba,"StructArrayLayout2i4ub1f12");class wa extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.float32[i+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}wa.prototype.bytesPerElement=12,Qs(wa,"StructArrayLayout3f12");class _a extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const o=6*t,a=3*t;return this.uint16[o+0]=e,this.uint16[o+1]=r,this.uint16[o+2]=n,this.uint16[o+3]=i,this.float32[a+2]=s,t}}_a.prototype.bytesPerElement=12,Qs(_a,"StructArrayLayout4ui1f12");class Aa extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.uint16[s+0]=e,this.uint16[s+1]=r,this.uint16[s+2]=n,this.uint16[s+3]=i,t}}Aa.prototype.bytesPerElement=8,Qs(Aa,"StructArrayLayout4ui8");class Ia extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,o){const a=6*t;return this.int16[a+0]=e,this.int16[a+1]=r,this.int16[a+2]=n,this.int16[a+3]=i,this.int16[a+4]=s,this.int16[a+5]=o,t}}Ia.prototype.bytesPerElement=12,Qs(Ia,"StructArrayLayout6i12");class Ma extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o,a,l,u,c,h){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,r,n,i,s,o,a,l,u,c,h)}emplace(t,e,r,n,i,s,o,a,l,u,c,h,p){const d=12*t;return this.int16[d+0]=e,this.int16[d+1]=r,this.int16[d+2]=n,this.int16[d+3]=i,this.uint16[d+4]=s,this.uint16[d+5]=o,this.uint16[d+6]=a,this.uint16[d+7]=l,this.int16[d+8]=u,this.int16[d+9]=c,this.int16[d+10]=h,this.int16[d+11]=p,t}}Ma.prototype.bytesPerElement=24,Qs(Ma,"StructArrayLayout4i4ui4i24");class Sa extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,o){const a=10*t,l=5*t;return this.int16[a+0]=e,this.int16[a+1]=r,this.int16[a+2]=n,this.float32[l+2]=i,this.float32[l+3]=s,this.float32[l+4]=o,t}}Sa.prototype.bytesPerElement=20,Qs(Sa,"StructArrayLayout3i3f20");class Pa extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,this.float32[s+3]=i,t}}Pa.prototype.bytesPerElement=16,Qs(Pa,"StructArrayLayout4f16");class ka extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}ka.prototype.bytesPerElement=4,Qs(ka,"StructArrayLayout1ul4");class Ba extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.uint16[n+0]=e,this.uint16[n+1]=r,t}}Ba.prototype.bytesPerElement=4,Qs(Ba,"StructArrayLayout2ui4");class za extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o,a,l,u,c,h,p){const d=this.length;return this.resize(d+1),this.emplace(d,t,e,r,n,i,s,o,a,l,u,c,h,p)}emplace(t,e,r,n,i,s,o,a,l,u,c,h,p,d){const f=20*t,m=10*t;return this.int16[f+0]=e,this.int16[f+1]=r,this.int16[f+2]=n,this.int16[f+3]=i,this.int16[f+4]=s,this.float32[m+3]=o,this.float32[m+4]=a,this.float32[m+5]=l,this.float32[m+6]=u,this.int16[f+14]=c,this.uint32[m+8]=h,this.uint16[f+18]=p,this.uint16[f+19]=d,t}}za.prototype.bytesPerElement=40,Qs(za,"StructArrayLayout5i4f1i1ul2ui40");class Ta extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s,o)}emplace(t,e,r,n,i,s,o,a){const l=8*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.int16[l+2]=n,this.int16[l+4]=i,this.int16[l+5]=s,this.int16[l+6]=o,this.int16[l+7]=a,t}}Ta.prototype.bytesPerElement=16,Qs(Ta,"StructArrayLayout3i2i2i16");class Ea extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const o=4*t,a=8*t;return this.float32[o+0]=e,this.float32[o+1]=r,this.float32[o+2]=n,this.int16[a+6]=i,this.int16[a+7]=s,t}}Ea.prototype.bytesPerElement=16,Qs(Ea,"StructArrayLayout2f1f2i16");class Va extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,o){const a=20*t,l=5*t;return this.uint8[a+0]=e,this.uint8[a+1]=r,this.float32[l+1]=n,this.float32[l+2]=i,this.float32[l+3]=s,this.float32[l+4]=o,t}}Va.prototype.bytesPerElement=20,Qs(Va,"StructArrayLayout2ub4f20");class Fa extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[i+0]=e,this.uint16[i+1]=r,this.uint16[i+2]=n,t}}Fa.prototype.bytesPerElement=6,Qs(Fa,"StructArrayLayout3ui6");class Ca extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o,a,l,u,c,h,p,d,f,m,y,g,x,v,b){const w=this.length;return this.resize(w+1),this.emplace(w,t,e,r,n,i,s,o,a,l,u,c,h,p,d,f,m,y,g,x,v,b)}emplace(t,e,r,n,i,s,o,a,l,u,c,h,p,d,f,m,y,g,x,v,b,w){const _=30*t,A=15*t,I=60*t;return this.int16[_+0]=e,this.int16[_+1]=r,this.int16[_+2]=n,this.float32[A+2]=i,this.float32[A+3]=s,this.uint16[_+8]=o,this.uint16[_+9]=a,this.uint32[A+5]=l,this.uint32[A+6]=u,this.uint32[A+7]=c,this.uint16[_+16]=h,this.uint16[_+17]=p,this.uint16[_+18]=d,this.float32[A+10]=f,this.float32[A+11]=m,this.uint8[I+48]=y,this.uint8[I+49]=g,this.uint8[I+50]=x,this.uint32[A+13]=v,this.int16[_+28]=b,this.uint8[I+58]=w,t}}Ca.prototype.bytesPerElement=60,Qs(Ca,"StructArrayLayout3i2f2ui3ul3ui2f3ub1ul1i1ub60");class Da extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o,a,l,u,c,h,p,d,f,m,y,g,x,v,b,w,_,A,I,M,S,P,k,B,z,T,E){const V=this.length;return this.resize(V+1),this.emplace(V,t,e,r,n,i,s,o,a,l,u,c,h,p,d,f,m,y,g,x,v,b,w,_,A,I,M,S,P,k,B,z,T,E)}emplace(t,e,r,n,i,s,o,a,l,u,c,h,p,d,f,m,y,g,x,v,b,w,_,A,I,M,S,P,k,B,z,T,E,V){const F=20*t,C=40*t,D=80*t;return this.float32[F+0]=e,this.float32[F+1]=r,this.int16[C+4]=n,this.int16[C+5]=i,this.int16[C+6]=s,this.int16[C+7]=o,this.int16[C+8]=a,this.int16[C+9]=l,this.int16[C+10]=u,this.int16[C+11]=c,this.int16[C+12]=h,this.uint16[C+13]=p,this.uint16[C+14]=d,this.uint16[C+15]=f,this.uint16[C+16]=m,this.uint16[C+17]=y,this.uint16[C+18]=g,this.uint16[C+19]=x,this.uint16[C+20]=v,this.uint16[C+21]=b,this.uint16[C+22]=w,this.uint16[C+23]=_,this.uint16[C+24]=A,this.uint16[C+25]=I,this.uint16[C+26]=M,this.uint16[C+27]=S,this.uint32[F+14]=P,this.float32[F+15]=k,this.float32[F+16]=B,this.float32[F+17]=z,this.float32[F+18]=T,this.uint8[D+76]=E,this.uint16[C+39]=V,t}}Da.prototype.bytesPerElement=80,Qs(Da,"StructArrayLayout2f9i15ui1ul4f1ub1ui80");class Ra extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,o){const a=6*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=n,this.float32[a+3]=i,this.float32[a+4]=s,this.float32[a+5]=o,t}}Ra.prototype.bytesPerElement=24,Qs(Ra,"StructArrayLayout6f24");class La extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const o=5*t;return this.float32[o+0]=e,this.float32[o+1]=r,this.float32[o+2]=n,this.float32[o+3]=i,this.float32[o+4]=s,t}}La.prototype.bytesPerElement=20,Qs(La,"StructArrayLayout5f20");class Oa extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s,o)}emplace(t,e,r,n,i,s,o,a){const l=7*t;return this.float32[l+0]=e,this.float32[l+1]=r,this.float32[l+2]=n,this.float32[l+3]=i,this.float32[l+4]=s,this.float32[l+5]=o,this.float32[l+6]=a,t}}Oa.prototype.bytesPerElement=28,Qs(Oa,"StructArrayLayout7f28");class Ua extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o,a,l,u,c){const h=this.length;return this.resize(h+1),this.emplace(h,t,e,r,n,i,s,o,a,l,u,c)}emplace(t,e,r,n,i,s,o,a,l,u,c,h){const p=11*t;return this.float32[p+0]=e,this.float32[p+1]=r,this.float32[p+2]=n,this.float32[p+3]=i,this.float32[p+4]=s,this.float32[p+5]=o,this.float32[p+6]=a,this.float32[p+7]=l,this.float32[p+8]=u,this.float32[p+9]=c,this.float32[p+10]=h,t}}Ua.prototype.bytesPerElement=44,Qs(Ua,"StructArrayLayout11f44");class Na extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o,a,l){const u=this.length;return this.resize(u+1),this.emplace(u,t,e,r,n,i,s,o,a,l)}emplace(t,e,r,n,i,s,o,a,l,u){const c=9*t;return this.float32[c+0]=e,this.float32[c+1]=r,this.float32[c+2]=n,this.float32[c+3]=i,this.float32[c+4]=s,this.float32[c+5]=o,this.float32[c+6]=a,this.float32[c+7]=l,this.float32[c+8]=u,t}}Na.prototype.bytesPerElement=36,Qs(Na,"StructArrayLayout9f36");class ja extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.float32[n+0]=e,this.float32[n+1]=r,t}}ja.prototype.bytesPerElement=8,Qs(ja,"StructArrayLayout2f8");class $a extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=6*t;return this.uint32[3*t+0]=e,this.uint16[s+2]=r,this.uint16[s+3]=n,this.uint16[s+4]=i,t}}$a.prototype.bytesPerElement=12,Qs($a,"StructArrayLayout1ul3ui12");class Ga extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}Ga.prototype.bytesPerElement=2,Qs(Ga,"StructArrayLayout1ui2");class qa extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o,a,l,u,c,h,p,d,f,m){const y=this.length;return this.resize(y+1),this.emplace(y,t,e,r,n,i,s,o,a,l,u,c,h,p,d,f,m)}emplace(t,e,r,n,i,s,o,a,l,u,c,h,p,d,f,m,y){const g=16*t;return this.float32[g+0]=e,this.float32[g+1]=r,this.float32[g+2]=n,this.float32[g+3]=i,this.float32[g+4]=s,this.float32[g+5]=o,this.float32[g+6]=a,this.float32[g+7]=l,this.float32[g+8]=u,this.float32[g+9]=c,this.float32[g+10]=h,this.float32[g+11]=p,this.float32[g+12]=d,this.float32[g+13]=f,this.float32[g+14]=m,this.float32[g+15]=y,t}}qa.prototype.bytesPerElement=64,Qs(qa,"StructArrayLayout16f64");class Ha extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,o){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s,o)}emplace(t,e,r,n,i,s,o,a){const l=10*t,u=5*t;return this.uint16[l+0]=e,this.uint16[l+1]=r,this.uint16[l+2]=n,this.uint16[l+3]=i,this.float32[u+2]=s,this.float32[u+3]=o,this.float32[u+4]=a,t}}Ha.prototype.bytesPerElement=20,Qs(Ha,"StructArrayLayout4ui3f20");class Xa extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.int16[1*t+0]=e,t}}Xa.prototype.bytesPerElement=2,Qs(Xa,"StructArrayLayout1i2");class Za extends ca{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint8[1*t+0]=e,t}}Za.prototype.bytesPerElement=1,Qs(Za,"StructArrayLayout1ub1");class Wa extends la{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.int16[this._pos2+3]}get tileAnchorY(){return this._structArray.int16[this._pos2+4]}get x1(){return this._structArray.float32[this._pos4+3]}get y1(){return this._structArray.float32[this._pos4+4]}get x2(){return this._structArray.float32[this._pos4+5]}get y2(){return this._structArray.float32[this._pos4+6]}get padding(){return this._structArray.int16[this._pos2+14]}get featureIndex(){return this._structArray.uint32[this._pos4+8]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+18]}get bucketIndex(){return this._structArray.uint16[this._pos2+19]}}Wa.prototype.size=40;class Ya extends za{get(t){return new Wa(this,t)}}Qs(Ya,"CollisionBoxArray");class Ka extends la{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.float32[this._pos4+2]}get tileAnchorY(){return this._structArray.float32[this._pos4+3]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+8]}get numGlyphs(){return this._structArray.uint16[this._pos2+9]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+5]}get lineStartIndex(){return this._structArray.uint32[this._pos4+6]}get lineLength(){return this._structArray.uint32[this._pos4+7]}get segment(){return this._structArray.uint16[this._pos2+16]}get lowerSize(){return this._structArray.uint16[this._pos2+17]}get upperSize(){return this._structArray.uint16[this._pos2+18]}get lineOffsetX(){return this._structArray.float32[this._pos4+10]}get lineOffsetY(){return this._structArray.float32[this._pos4+11]}get writingMode(){return this._structArray.uint8[this._pos1+48]}get placedOrientation(){return this._structArray.uint8[this._pos1+49]}set placedOrientation(t){this._structArray.uint8[this._pos1+49]=t;}get hidden(){return this._structArray.uint8[this._pos1+50]}set hidden(t){this._structArray.uint8[this._pos1+50]=t;}get crossTileID(){return this._structArray.uint32[this._pos4+13]}set crossTileID(t){this._structArray.uint32[this._pos4+13]=t;}get associatedIconIndex(){return this._structArray.int16[this._pos2+28]}get flipState(){return this._structArray.uint8[this._pos1+58]}set flipState(t){this._structArray.uint8[this._pos1+58]=t;}}Ka.prototype.size=60;class Ja extends Ca{get(t){return new Ka(this,t)}}Qs(Ja,"PlacedSymbolArray");class Qa extends la{get tileAnchorX(){return this._structArray.float32[this._pos4+0]}get tileAnchorY(){return this._structArray.float32[this._pos4+1]}get projectedAnchorX(){return this._structArray.int16[this._pos2+4]}get projectedAnchorY(){return this._structArray.int16[this._pos2+5]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+6]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+7]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+8]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+9]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+10]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+11]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+12]}get key(){return this._structArray.uint16[this._pos2+13]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+14]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+15]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+16]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+17]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+18]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+19]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+20]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+21]}get featureIndex(){return this._structArray.uint16[this._pos2+22]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+23]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+24]}get numIconVertices(){return this._structArray.uint16[this._pos2+25]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+26]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+27]}get crossTileID(){return this._structArray.uint32[this._pos4+14]}set crossTileID(t){this._structArray.uint32[this._pos4+14]=t;}get textOffset0(){return this._structArray.float32[this._pos4+15]}get textOffset1(){return this._structArray.float32[this._pos4+16]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+17]}get zOffset(){return this._structArray.float32[this._pos4+18]}set zOffset(t){this._structArray.float32[this._pos4+18]=t;}get hasIconTextFit(){return this._structArray.uint8[this._pos1+76]}get elevationFeatureIndex(){return this._structArray.uint16[this._pos2+39]}}Qa.prototype.size=80;class tl extends Da{get(t){return new Qa(this,t)}}Qs(tl,"SymbolInstanceArray");class el extends ya{getoffsetX(t){return this.float32[1*t+0]}}Qs(el,"GlyphOffsetArray");class rl extends da{getx(t){return this.int16[2*t+0]}gety(t){return this.int16[2*t+1]}}Qs(rl,"SymbolLineVertexArray");class nl extends la{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}get layoutVertexArrayOffset(){return this._structArray.uint16[this._pos2+4]}}nl.prototype.size=12;class il extends $a{get(t){return new nl(this,t)}}Qs(il,"FeatureIndexArray");class sl extends Ba{geta_centroid_pos0(t){return this.uint16[2*t+0]}geta_centroid_pos1(t){return this.uint16[2*t+1]}}Qs(sl,"FillExtrusionCentroidArray");class ol extends la{get a_join_normal_inside0(){return this._structArray.int16[this._pos2+0]}get a_join_normal_inside1(){return this._structArray.int16[this._pos2+1]}get a_join_normal_inside2(){return this._structArray.int16[this._pos2+2]}}ol.prototype.size=6;class al extends fa{get(t){return new ol(this,t)}}Qs(al,"FillExtrusionWallArray");const ll=ha([{name:"a_pos",components:2,type:"Int16"}],4),ul=ha([{name:"a_circle_z_offset",components:1,type:"Float32"}],4),cl=ha([{name:"a_pos_3",components:3,type:"Int16"},{name:"a_pos_normal_3",components:3,type:"Int16"}]);class hl{constructor(t=[]){this.segments=t;}_prepareSegment(t,e,r,n){let i=this.segments[this.segments.length-1];return t>hl.MAX_VERTEX_ARRAY_LENGTH&&Xt(`Max vertices per segment is ${hl.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}`),(!i||i.vertexLength+t>hl.MAX_VERTEX_ARRAY_LENGTH||i.sortKey!==n)&&(i={vertexOffset:e,primitiveOffset:r,vertexLength:0,primitiveLength:0},void 0!==n&&(i.sortKey=n),this.segments.push(i)),i}prepareSegment(t,e,r,n){return this._prepareSegment(t,e.length,r.length,n)}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy();}static simpleSegment(t,e,r,n){return new hl([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}])}}function pl(t,e){return 256*(t=Ft(Math.floor(t),0,255))+Ft(Math.floor(e),0,255)}hl.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,Qs(hl,"SegmentVector");const dl=ha([{name:"a_pattern",components:4,type:"Uint16"},{name:"a_pixel_ratio",components:1,type:"Float32"}]),fl=ha([{name:"a_pattern_b",components:4,type:"Uint16"}]),ml=ha([{name:"a_dash",components:4,type:"Uint16"}]);class yl{constructor(){this.ids=[],this.uniqueIds=[],this.positions=[],this.indexed=!1;}add(t,e,r,n){this.ids.push(gl(t)),this.positions.push(e,r,n);}eachPosition(t,e){const r=gl(t);let n=0,i=this.ids.length-1;for(;n<i;){const t=n+i>>1;this.ids[t]>=r?i=t:n=t+1;}for(;this.ids[n]===r;)e(this.positions[3*n],this.positions[3*n+1],this.positions[3*n+2]),n++;}static serialize(t,e){const r=new Float64Array(t.ids),n=new Uint32Array(t.positions);return xl(r,n,0,r.length-1),e&&(e.add(r.buffer),e.add(n.buffer)),{ids:r,positions:n}}static deserialize(t){const e=new yl;let r;e.ids=t.ids,e.positions=t.positions;for(const t of e.ids)t!==r&&e.uniqueIds.push(t),r=t;return e.indexed=!0,e}}function gl(t){const e=+t;return Number.isSafeInteger(e)?e:Je(String(t))}function xl(t,e,r,n){for(;r<n;){const i=t[r+n>>1];let s=r-1,o=n+1;for(;;){do{s++;}while(t[s]<i);do{o--;}while(t[o]>i);if(s>=o)break;vl(t,s,o),vl(e,3*s,3*o),vl(e,3*s+1,3*o+1),vl(e,3*s+2,3*o+2);}o-r<n-o?(xl(t,e,r,o),r=o+1):(xl(t,e,o+1,n),n=o);}}function vl(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}Qs(yl,"FeaturePositionMap");class bl{constructor(t){this.gl=t.gl,this.initialized=!1;}fetchUniformLocation(t,e){return this.location||this.initialized||(this.location=this.gl.getUniformLocation(t,e),this.initialized=!0),!!this.location}set(t,e,r){throw new Error("Uniform#set() must be implemented by each concrete Uniform")}}class wl extends bl{constructor(t){super(t),this.current=0;}set(t,e,r){this.fetchUniformLocation(t,e)&&this.current!==r&&(this.current=r,this.gl.uniform1i(this.location,r));}}class _l extends bl{constructor(t){super(t),this.current=0;}set(t,e,r){this.fetchUniformLocation(t,e)&&this.current!==r&&(this.current=r,this.gl.uniform1f(this.location,r));}}class Al extends bl{constructor(t){super(t),this.current=[0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]||(this.current=r,this.gl.uniform2f(this.location,r[0],r[1])));}}class Il extends bl{constructor(t){super(t),this.current=[0,0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]&&r[2]===this.current[2]||(this.current=r,this.gl.uniform3f(this.location,r[0],r[1],r[2])));}}class Ml extends bl{constructor(t){super(t),this.current=[0,0,0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]&&r[2]===this.current[2]&&r[3]===this.current[3]||(this.current=r,this.gl.uniform4f(this.location,r[0],r[1],r[2],r[3])));}}class Sl extends bl{constructor(t){super(t),this.current=lr.transparent.toPremultipliedRenderColor(null);}set(t,e,r){this.fetchUniformLocation(t,e)&&(r.r===this.current.r&&r.g===this.current.g&&r.b===this.current.b&&r.a===this.current.a||(this.current=r,this.gl.uniform4f(this.location,r.r,r.g,r.b,r.a)));}}const Pl=new Float32Array(16);class kl extends bl{constructor(t){super(t),this.current=Pl;}set(t,e,r){if(this.fetchUniformLocation(t,e)){if(r[12]!==this.current[12]||r[0]!==this.current[0])return this.current=r,void this.gl.uniformMatrix4fv(this.location,!1,r);for(let t=1;t<16;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix4fv(this.location,!1,r);break}}}}const Bl=new Float32Array(9),zl=new Float32Array(4);class Tl extends bl{constructor(t){super(t),this.current=zl;}set(t,e,r){if(this.fetchUniformLocation(t,e))for(let t=0;t<4;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix2fv(this.location,!1,r);break}}}function El(t){return [pl(255*t.r,255*t.g),pl(255*t.b,255*t.a)]}function Vl(t,e,r,n,i,s,o,a){return !!t&&("composite"===t.kind||"source"===t.kind?"none"===t.evaluate(new Io(0,{brightness:s,worldview:a}),e,r,i,n,o):"none"===t.value)}class Fl{constructor(t,e,r,n){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=r,this.context=n;}setUniform(t,e,r,n,i){const s=n.constantOr(this.value);e.set(t,i,s instanceof lr?s.toPremultipliedRenderColor(this.lutExpression&&"constant"===this.lutExpression.kind&&"none"===this.lutExpression.value?null:this.context.lut):s);}getBinding(t,e){return "color"===this.type?new Sl(t):new _l(t)}}class Cl{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.pattern=null,this.patternTransition=null,this.pixelRatio=1;}setConstantPatternPositions(t,e){this.pixelRatio=t.pixelRatio||1,this.pattern=t.tl.concat(t.br),this.patternTransition=e?e.tl.concat(e.br):this.pattern;}setUniform(t,e,r,n,i){let s=null;"u_pattern"!==i&&"u_dash"!==i||(s=this.pattern),"u_pattern_b"===i&&(s=this.patternTransition),"u_pixel_ratio"===i&&(s=this.pixelRatio),s&&e.set(t,i,s);}getBinding(t,e){return "u_pattern"===e||"u_pattern_b"===e||"u_dash"===e?new Ml(t):new _l(t)}}class Dl{constructor(t,e,r,n){this.expression=t,this.type=r,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0}))),this.paintVertexArray=new n;}populatePaintArray(t,e,r,n,i,s,o,a){const l=this.paintVertexArray.length,u="composite"===this.expression.kind||"source"===this.expression.kind?this.expression.evaluate(new Io(0,{brightness:s,worldview:a}),e,{},i,n,o):"constant"===this.expression.kind&&this.expression.value,c=Vl(this.lutExpression,e,{},n,i,s,o,a);this.paintVertexArray.resize(t),this._setPaintValue(l,t,u,c?null:this.context.lut);}updatePaintArray(t,e,r,n,i,s,o,a){const l="composite"===this.expression.kind||"source"===this.expression.kind?this.expression.evaluate({zoom:0,brightness:o,worldview:a},r,n,void 0,i):"constant"===this.expression.kind&&this.expression.value,u=Vl(this.lutExpression,r,n,i,void 0,o,void 0,a);this._setPaintValue(t,e,l,u?null:this.context.lut);}_setPaintValue(t,e,r,n){if("color"===this.type){const i=El(r.toPremultipliedRenderColor(n));for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i[0],i[1]);}else {for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.lutExpression&&"constant"!==this.lutExpression.kind&&(this.lutExpression.isStateDependent||!this.lutExpression.isLightConstant)||"constant"!==this.expression.kind&&(this.expression.isStateDependent||!this.expression.isLightConstant)));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class Rl{constructor(t,e,r,n,i,s){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=r,this.useIntegerZoom=n,this.context=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0}))),this.paintVertexArray=new s;}populatePaintArray(t,e,r,n,i,s,o,a){const l=this.expression.evaluate(new Io(this.context.zoom,{brightness:s,worldview:a}),e,{},i,n,o),u=this.expression.evaluate(new Io(this.context.zoom+1,{brightness:s,worldview:a}),e,{},i,n,o),c=Vl(this.lutExpression,e,{},n,i,s,o,a),h=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(h,t,l,u,c?null:this.context.lut);}updatePaintArray(t,e,r,n,i,s,o,a){const l=this.expression.evaluate({zoom:this.context.zoom,brightness:o,worldview:a},r,n,void 0,i),u=this.expression.evaluate({zoom:this.context.zoom+1,brightness:o,worldview:a},r,n,void 0,i),c=Vl(this.lutExpression,r,n,i,void 0,o,void 0,a);this._setPaintValue(t,e,l,u,c?null:this.context.lut);}_setPaintValue(t,e,r,n,i){if("color"===this.type){const n=El(r.toPremultipliedRenderColor(i)),s=El(r.toPremultipliedRenderColor(i));for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1],s[0],s[1]);}else {for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent||!this.expression.isLightConstant));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}setUniform(t,e,r,n,i){const s=this.useIntegerZoom?Math.floor(r.zoom):r.zoom,o=Ft(this.expression.interpolationFactor(s,this.context.zoom,this.context.zoom+1),0,1);e.set(t,i,o);}getBinding(t,e){return new _l(t)}}class Ll{constructor(t,e,r,n,i){this.expression=t,this.layerId=i,this.paintVertexAttributes=("array"===r?ml:dl).members;for(let t=0;t<e.length;++t);this.paintVertexArray=new n,this.paintTransitionVertexArray=new Aa;}populatePaintArray(t,e,r,n){const i=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValues(i,t,e.patterns&&e.patterns[this.layerId],r);}updatePaintArray(t,e,r,n,i,s,o){this._setPaintValues(t,e,r.patterns&&r.patterns[this.layerId],s);}_setPaintValues(t,e,r,n){if(!n||!r)return;const i=n[r[0]],s=n[r[1]];if(i){if(i){const{tl:r,br:n,pixelRatio:s}=i;for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r[0],r[1],n[0],n[1],s);}if(s){this.paintTransitionVertexArray.resize(this.paintVertexArray.length);const{tl:r,br:n}=s;for(let i=t;i<e;i++)this.paintTransitionVertexArray.emplace(i,r[0],r[1],n[0],n[1]);}}}upload(t){const e=this.expression.isStateDependent||!this.expression.isLightConstant;this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,e)),this.paintTransitionVertexArray&&this.paintTransitionVertexArray.length&&(this.paintTransitionVertexBuffer=t.createVertexBuffer(this.paintTransitionVertexArray,fl.members,e));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy(),this.paintTransitionVertexBuffer&&this.paintTransitionVertexBuffer.destroy();}}class Ol{constructor(t,e,r=(()=>!0)){this.binders={},this._buffers=[],this.context=e;const n=[];for(const i in t.paint._values){const s=t.paint.get(i);if(i.endsWith("-use-theme"))continue;if(!r(i))continue;if(!(s instanceof To&&ks(s.property.specification)))continue;const o=jl(i,t.type),a=s.value,l=s.property.specification.type,u=!!s.property.useIntegerZoom,c="line-dasharray"===i||i.endsWith("pattern"),h=t.paint.get(`${i}-use-theme`),p="line-dasharray"===i&&"constant"!==t.layout.get("line-cap").value.kind||h&&"constant"!==h.value.kind;if("constant"!==a.kind||p)if("source"===a.kind||p||c){const e=ql(i,l,"source");this.binders[i]=c?new Ll(a,o,l,e,t.id):new Dl(a,o,l,e),n.push(`/a_${i}`);}else {const t=ql(i,l,"composite");this.binders[i]=new Rl(a,o,l,u,e,t),n.push(`/z_${i}`);}else this.binders[i]=c?new Cl(a.value,o):new Fl(a.value,o,l,e),n.push(`/u_${i}`);h&&(this.binders[i].lutExpression=h.value);}this.cacheKey=n.sort().join("");}getMaxValue(t){const e=this.binders[t];return e instanceof Dl||e instanceof Rl?e.maxValue:0}populatePaintArrays(t,e,r,n,i,s,o,a){for(const l in this.binders){const u=this.binders[l];u.context=this.context,(u instanceof Dl||u instanceof Rl||u instanceof Ll)&&u.populatePaintArray(t,e,r,n,i,s,o,a);}}setConstantPatternPositions(t,e){for(const r in this.binders){const n=this.binders[r];n instanceof Cl&&n.setConstantPatternPositions(t,e);}}getPatternTransitionVertexBuffer(t){const e=this.binders[t];return e instanceof Ll?e.paintTransitionVertexBuffer:null}updatePaintArrays(t,e,r,n,i,s,o,a,l,u){let c=!1;const h=Object.keys(t),p=0!==h.length&&!a,d=p?h:e.uniqueIds;this.context.lut=i.lut;for(const a in this.binders){const h=this.binders[a];if(h.context=this.context,(h instanceof Dl||h instanceof Rl||h instanceof Ll)&&h.expression&&h.expression.kind&&"constant"!==h.expression.kind&&(!0===h.expression.isStateDependent||!1===h.expression.isLightConstant)){const f=i.paint.get(a);h.expression=f.value;for(const r of d){const i=t[r.toString()];e.eachPosition(r,((t,e,r)=>{const a=n.feature(t);h.updatePaintArray(e,r,a,i,s,o,l,u);}));}if(!p)for(const e of r.uniqueIds){const i=t[e.toString()];r.eachPosition(e,((t,e,r)=>{const a=n.feature(t);h.updatePaintArray(e,r,a,i,s,o,l,u);}));}c=!0;}}return c}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof Fl||r instanceof Cl)&&t.push(...r.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)));}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t){const e=[];for(const r in this.binders){const n=this.binders[r];if(n instanceof Fl||n instanceof Cl||n instanceof Rl)for(const i of n.uniformNames)e.push({name:i,property:r,binding:n.getBinding(t,i)});}return e}setUniforms(t,e,r,n,i){for(const{name:e,property:s,binding:o}of r)this.binders[s].setUniform(t,o,i,n.get(s),e);}updatePaintBuffers(){this._buffers=[];for(const t in this.binders){const e=this.binders[t];(e instanceof Dl||e instanceof Rl||e instanceof Ll)&&e.paintVertexBuffer&&this._buffers.push(e.paintVertexBuffer),e instanceof Ll&&e.paintTransitionVertexBuffer&&this._buffers.push(e.paintTransitionVertexBuffer);}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof Dl||r instanceof Rl||r instanceof Ll)&&r.upload(t);}this.updatePaintBuffers();}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof Dl||e instanceof Rl||e instanceof Ll)&&e.destroy();}}}class Ul{constructor(t,e,r=(()=>!0)){this.programConfigurations={};for(const n of t)this.programConfigurations[n.id]=new Ol(n,e,r);this.needsUpload=!1,this._featureMap=new yl,this._featureMapWithoutIds=new yl,this._bufferOffset=0,this._idlessCounter=0;}populatePaintArrays(t,e,r,n,i,s,o,a,l){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,n,i,s,o,a,l);void 0!==e.id?this._featureMap.add(e.id,r,this._bufferOffset,t):(this._featureMapWithoutIds.add(this._idlessCounter,r,this._bufferOffset,t),this._idlessCounter+=1),this._bufferOffset=t,this.needsUpload=!0;}updatePaintArrays(t,e,r,n,i,s,o,a){for(const l of r)this.needsUpload=this.programConfigurations[l.id].updatePaintArrays(t,this._featureMap,this._featureMapWithoutIds,e,l,n,i,s,o||0,a)||this.needsUpload;}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1;}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy();}}const Nl={"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-occlusion-opacity":["occlusion_opacity"],"icon-occlusion-opacity":["occlusion_opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-emissive-strength":["emissive_strength"],"icon-emissive-strength":["emissive_strength"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"symbol-z-offset":["z_offset"],"line-gap-width":["gapwidth"],"line-pattern":["pattern","pixel_ratio","pattern_b"],"fill-pattern":["pattern","pixel_ratio","pattern_b"],"fill-extrusion-pattern":["pattern","pixel_ratio","pattern_b"],"line-dasharray":["dash"],"fill-bridge-guard-rail-color":["structure_color"],"fill-tunnel-structure-color":["structure_color"]};function jl(t,e){return Nl[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}const $l={"line-pattern":{source:_a,composite:_a},"fill-pattern":{source:_a,composite:_a},"fill-extrusion-pattern":{source:_a,composite:_a},"line-dasharray":{source:Aa,composite:Aa}},Gl={color:{source:ja,composite:Pa},number:{source:ya,composite:ja}};function ql(t,e,r){const n=$l[t];return n&&n[r]||Gl[e][r]}Qs(Fl,"ConstantBinder"),Qs(Cl,"PatternConstantBinder"),Qs(Dl,"SourceExpressionBinder"),Qs(Ll,"PatternCompositeBinder"),Qs(Rl,"CompositeExpressionBinder"),Qs(Ol,"ProgramConfiguration",{omit:["_buffers"]}),Qs(Ul,"ProgramConfigurationSet");const Hl=Un/Math.PI/2,Xl=5,Zl=6,Wl=16383,Yl=64,Kl=[Yl,32,16],Jl=-Hl,Ql=Hl;function tu(t,e,r,n=Hl){return r=kt(r),[t*Math.sin(r)*n,-e*n,t*Math.cos(r)*n]}function eu(t,e,r){return tu(Math.cos(kt(t)),Math.sin(kt(t)),e,r)}const ru=6371008.8,nu=2*Math.PI*ru;class iu{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new iu(Dt(this.lng,-180,180),this.lat)}toArray(){return [this.lng,this.lat]}toString(){return `LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,r=this.lat*e,n=t.lat*e,i=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((t.lng-this.lng)*e);return ru*Math.acos(Math.min(i,1))}toBounds(t=0){const e=360*t/40075017,r=e/Math.cos(Math.PI/180*this.lat);return new su({lng:this.lng-r,lat:this.lat-e},{lng:this.lng+r,lat:this.lat+e})}toEcef(t){return eu(this.lat,this.lng,Hl+t*Hl/ru)}static convert(t){if(t instanceof iu)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new iu(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new iu(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}class su{constructor(t,e){t&&(e?this.setSouthWest(t).setNorthEast(e):Array.isArray(t)&&4===t.length?this.setSouthWest([t[0],t[1]]).setNorthEast([t[2],t[3]]):this.setSouthWest(t[0]).setNorthEast(t[1]));}setNorthEast(t){return this._ne=t instanceof iu?new iu(t.lng,t.lat):iu.convert(t),this}setSouthWest(t){return this._sw=t instanceof iu?new iu(t.lng,t.lat):iu.convert(t),this}extend(t){const e=this._sw,r=this._ne;let n,i;if(t instanceof iu)n=t,i=t;else {if(!(t instanceof su))return Array.isArray(t)?4===t.length||t.every(Array.isArray)?this.extend(su.convert(t)):this.extend(iu.convert(t)):"object"==typeof t&&null!==t&&t.hasOwnProperty("lat")&&(t.hasOwnProperty("lon")||t.hasOwnProperty("lng"))?this.extend(iu.convert(t)):this;if(n=t._sw,i=t._ne,!n||!i)return this}return e||r?(e.lng=Math.min(n.lng,e.lng),e.lat=Math.min(n.lat,e.lat),r.lng=Math.max(i.lng,r.lng),r.lat=Math.max(i.lat,r.lat)):(this._sw=new iu(n.lng,n.lat),this._ne=new iu(i.lng,i.lat)),this}getCenter(){return new iu((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new iu(this.getWest(),this.getNorth())}getSouthEast(){return new iu(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return [this._sw.toArray(),this._ne.toArray()]}toString(){return `LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return !(this._sw&&this._ne)}contains(t){const{lng:e,lat:r}=iu.convert(t);let n=this._sw.lng<=e&&e<=this._ne.lng;return this._sw.lng>this._ne.lng&&(n=this._sw.lng>=e&&e>=this._ne.lng),this._sw.lat<=r&&r<=this._ne.lat&&n}static convert(t){if(t)return t instanceof su?t:new su(t)}}const ou=0,au=25.5;function lu(t){return nu*Math.cos(t*Math.PI/180)}function uu(t){return (180+t)/360}function cu(t){return (180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function hu(t,e){return t/lu(e)}function pu(t){return 360*t-180}function du(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function fu(t,e){return t*lu(du(e))}const mu=85.051129;function yu(t){return Math.cos(kt(Ft(t,-mu,mu)))}function gu(t,e){const r=Ft(e,ou,au),n=Math.pow(2,r);return yu(t)*nu/(512*n)}function xu(t){return 1/Math.cos(t*Math.PI/180)}function vu(t,e=0){const r=Math.exp(Math.PI*(1-(t.y+e/Un)/(1<<t.z)*2));return 80150034*r/(r*r+1)/Un/(1<<t.z)}class bu{constructor(t,e,r=0){this.x=+t,this.y=+e,this.z=+r;}static fromLngLat(t,e=0){const r=iu.convert(t);return new bu(uu(r.lng),cu(r.lat),hu(e,r.lat))}toLngLat(){return new iu(pu(this.x),du(this.y))}toAltitude(){return fu(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/nu*xu(du(this.y))}}function wu(t,e,r,n,i,s,o,a,l){const u=(e+n)/2,c=(r+i)/2,h=new It(u,c);a(h),function(t,e,r,n,i,s){const o=r-i,a=n-s;return Math.abs((n-e)*o-(r-t)*a)/Math.hypot(o,a)}(h.x,h.y,s.x,s.y,o.x,o.y)>=l?(wu(t,e,r,u,c,s,h,a,l),wu(t,u,c,n,i,h,o,a,l)):t.push(o);}function _u(t,e,r){let n=t[0],i=n.x,s=n.y;e(n);const o=[n];for(let a=1;a<t.length;a++){const l=t[a],{x:u,y:c}=l;e(l),wu(o,i,s,u,c,n,l,e,r),i=u,s=c,n=l;}return o}function Au(t,e,r,n){if(n(e,r)){const i=e.add(r)._mult(.5);Au(t,e,i,n),Au(t,i,r,n);}else t.push(r);}function Iu(t,e){let r=t[0];const n=[r];for(let i=1;i<t.length;i++){const s=t[i];Au(n,r,s,e),r=s;}return n}const Mu=Math.pow(2,14)-1,Su=-Mu-1;function Pu(t,e){const r=Math.round(t.x*e),n=Math.round(t.y*e);return t.x=Ft(r,Su,Mu),t.y=Ft(n,Su,Mu),(r<t.x||r>t.x+1||n<t.y||n>t.y+1)&&Xt("Geometry exceeds allowed extent, reduce your vector tile buffer size"),t}function ku(t,e,r){const n=t.loadGeometry(),i=t.extent,s=Un/i;if(e&&r&&r.projection.isReprojectedInTileSpace){const s=1<<e.z,{scale:o,x:a,y:l,projection:u}=r,c=t=>{const r=pu((e.x+t.x/i)/s),n=du((e.y+t.y/i)/s),c=u.project(r,n);t.x=(c.x*o-a)*i,t.y=(c.y*o-l)*i;};for(let e=0;e<n.length;e++)if(1!==t.type)n[e]=_u(n[e],c,1);else {const t=[];for(const r of n[e])r.x<0||r.x>=i||r.y<0||r.y>=i||(c(r),t.push(r));n[e]=t;}}for(const t of n)for(const e of t)Pu(e,s);return n}function Bu(t,e){return {type:t.type,id:t.id,properties:t.properties,geometry:e?ku(t):[]}}class zu{constructor(t,e,r,n,i){this.properties={},this.extent=r,this.type=0,this.id=void 0,this._pbf=t,this._geometry=-1,this._keys=n,this._values=i,t.readFields(Tu,this,e);}loadGeometry(){const t=this._pbf;t.pos=this._geometry;const e=t.readVarint()+t.pos,r=[];let n,i=1,s=0,o=0,a=0;for(;t.pos<e;){if(s<=0){const e=t.readVarint();i=7&e,s=e>>3;}if(s--,1===i||2===i)o+=t.readSVarint(),a+=t.readSVarint(),1===i&&(n&&r.push(n),n=[]),n&&n.push(new It(o,a));else {if(7!==i)throw new Error(`unknown command ${i}`);n&&n.push(n[0].clone());}}return n&&r.push(n),r}bbox(){const t=this._pbf;t.pos=this._geometry;const e=t.readVarint()+t.pos;let r=1,n=0,i=0,s=0,o=1/0,a=-1/0,l=1/0,u=-1/0;for(;t.pos<e;){if(n<=0){const e=t.readVarint();r=7&e,n=e>>3;}if(n--,1===r||2===r)i+=t.readSVarint(),s+=t.readSVarint(),i<o&&(o=i),i>a&&(a=i),s<l&&(l=s),s>u&&(u=s);else if(7!==r)throw new Error(`unknown command ${r}`)}return [o,l,a,u]}toGeoJSON(t,e,r){const n=this.extent*Math.pow(2,r),i=this.extent*t,s=this.extent*e,o=this.loadGeometry();function a(t){return [360*(t.x+i)/n-180,360/Math.PI*Math.atan(Math.exp((1-2*(t.y+s)/n)*Math.PI))-90]}function l(t){return t.map(a)}let u;if(1===this.type){const t=[];for(const e of o)t.push(e[0]);const e=l(t);u=1===t.length?{type:"Point",coordinates:e[0]}:{type:"MultiPoint",coordinates:e};}else if(2===this.type){const t=o.map(l);u=1===t.length?{type:"LineString",coordinates:t[0]}:{type:"MultiLineString",coordinates:t};}else {if(3!==this.type)throw new Error("unknown feature type");{const t=function(t){const e=t.length;if(e<=1)return [t];const r=[];let n,i;for(let s=0;s<e;s++){const e=Eu(t[s]);0!==e&&(void 0===i&&(i=e<0),i===e<0?(n&&r.push(n),n=[t[s]]):n&&n.push(t[s]));}return n&&r.push(n),r}(o),e=[];for(const r of t)e.push(r.map(l));u=1===e.length?{type:"Polygon",coordinates:e[0]}:{type:"MultiPolygon",coordinates:e};}}const c={type:"Feature",geometry:u,properties:this.properties};return null!=this.id&&(c.id=this.id),c}}function Tu(t,e,r){1===t?e.id=r.readVarint():2===t?function(t,e){const r=t.readVarint()+t.pos;for(;t.pos<r;){const r=e._keys[t.readVarint()],n=e._values[t.readVarint()];e.properties[r]=n;}}(r,e):3===t?e.type=r.readVarint():4===t&&(e._geometry=r.pos);}function Eu(t){let e=0;for(let r,n,i=0,s=t.length,o=s-1;i<s;o=i++)r=t[i],n=t[o],e+=(n.x-r.x)*(r.y+n.y);return e}zu.types=["Unknown","Point","LineString","Polygon"];class Vu{constructor(t,e){this.version=1,this.name="",this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(Fu,this,e),this.length=this._features.length;}feature(t){if(t<0||t>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[t];const e=this._pbf.readVarint()+this._pbf.pos;return new zu(this._pbf,e,this.extent,this._keys,this._values)}}function Fu(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){let e=null;const r=t.readVarint()+t.pos;for(;t.pos<r;){const r=t.readVarint()>>3;e=1===r?t.readString():2===r?t.readFloat():3===r?t.readDouble():4===r?t.readVarint64():5===r?t.readVarint():6===r?t.readSVarint():7===r?t.readBoolean():null;}if(null==e)throw new Error("unknown feature value");return e}(r));}class Cu{constructor(t,e){this.layers=t.readFields(Du,{},e);}}function Du(t,e,r){if(3===t){const t=new Vu(r,r.readVarint()+r.pos);t.length&&(e[t.name]=t);}}const Ru="3d_elevation_id",Lu="level";class Ou{constructor(){this._valid=!1;}reset(t){return this.feature=t,this._valid=!0,this._geometry=t.loadGeometry(),0!==this._geometry.length&&0!==this._geometry[0].length||(this._valid=!1),this}geometry(t,e){return this._valid&&t(e(this._geometry)),this}require(t,e,r){return this.get(t,!0,e,r)}optional(t,e,r){return this.get(t,!1,e,r)}success(){return this._valid}get(t,e,r,n){const i=this.feature.properties.hasOwnProperty(t)?+this.feature.properties[t]:void 0;return this._valid&&void 0!==i&&!Number.isNaN(i)?r(n?n(i):i):e&&(this._valid=!1),this}}class Uu{constructor(t,e){this.featureFunc=t,this.vertexFunc=e;}parseFeature(t,e,r){return this.featureFunc(t,e,r)}parseVertex(t,e,r){return this.vertexFunc(t,e,r)}}const Nu=new Uu(((t,e,r)=>t.reset(e).require(Ru,(t=>{r.id=t;})).optional("fixed_height_relative",(t=>{r.constantHeight=t;}),$u.decodeRelativeHeight).geometry((t=>{r.bounds=t;}),xn).success()),((t,e,r)=>t.reset(e).require(Ru,(t=>{r.id=t;})).require("elevation_idx",(t=>{r.idx=t;})).require("extent",(t=>{r.extent=t;})).require("height_relative",(t=>{r.height=t;}),$u.decodeRelativeHeight).geometry((t=>{r.position=t;}),$u.getPoint).success())),ju=new Uu(((t,e,r)=>t.reset(e).require(Ru,(t=>{r.id=t;})).optional("fixed_height",(t=>{r.constantHeight=t;}),$u.decodeMetricHeight).geometry((t=>{r.bounds=t;}),xn).success()),((t,e,r)=>t.reset(e).require(Ru,(t=>{r.id=t;})).require("elevation_idx",(t=>{r.idx=t;})).require("extent",(t=>{r.extent=t;})).require("height",(t=>{r.height=t;}),$u.decodeMetricHeight).geometry((t=>{r.position=t;}),$u.getPoint).success()));class $u{static getPoint(t){return ct(t[0][0].x,t[0][0].y)}static decodeRelativeHeight(t){return 1e-4*t*5}static decodeMetricHeight(t){return 1e-4*t}static getVersionSchema(t){return t?"1.0.1"===t?ju:void 0:Nu}static parse(t){const e=[],r=[],n=t.length,i=new Ou;for(let s=0;s<n;s++){const n=t.feature(s),o=n.properties.version,a=$u.getVersionSchema(o);if(void 0===a){Xt(`Unknown elevation feature version number ${o||"(unknown)"}`);continue}const l=n.properties.type;if(!l)continue;const u=zu.types[n.type];if("Point"===u&&"curve_point"===l){const t={};a.parseVertex(i,n,t)&&e.push(t);}else if("Polygon"===u&&"curve_meta"===l){const t={};a.parseFeature(i,n,t)&&r.push(t);}}return {vertices:e,features:r}}}class Gu{constructor(t,e){this.pos=t,this.dir=e;}intersectsPlane(t,e,r){const n=gt(e,this.dir);if(Math.abs(n)<1e-6)return !1;const i=((t[0]-this.pos[0])*e[0]+(t[1]-this.pos[1])*e[1])/n;return r[0]=this.pos[0]+this.dir[0]*i,r[1]=this.pos[1]+this.dir[1]*i,!0}}class qu{constructor(t,e){this.pos=t,this.dir=e;}intersectsPlane(t,e,r){const n=O(e,this.dir);if(Math.abs(n)<1e-6)return !1;const i=((t[0]-this.pos[0])*e[0]+(t[1]-this.pos[1])*e[1]+(t[2]-this.pos[2])*e[2])/n;return r[0]=this.pos[0]+this.dir[0]*i,r[1]=this.pos[1]+this.dir[1]*i,r[2]=this.pos[2]+this.dir[2]*i,!0}closestPointOnSphere(t,r,n){if(function(t,r){var n=t[0],i=t[1],s=t[2],o=r[0],a=r[1],l=r[2];return Math.abs(n-o)<=e*Math.max(1,Math.abs(n),Math.abs(o))&&Math.abs(i-a)<=e*Math.max(1,Math.abs(i),Math.abs(a))&&Math.abs(s-l)<=e*Math.max(1,Math.abs(s),Math.abs(l))}(this.pos,t)||0===r)return n[0]=n[1]=n[2]=0,!1;const[i,s,o]=this.dir,a=this.pos[0]-t[0],l=this.pos[1]-t[1],u=this.pos[2]-t[2],c=i*i+s*s+o*o,h=2*(a*i+l*s+u*o),p=h*h-4*c*(a*a+l*l+u*u-r*r);if(p<0){const t=Math.max(-h/2,0),e=a+i*t,c=l+s*t,p=u+o*t,d=Math.hypot(e,c,p);return n[0]=e*r/d,n[1]=c*r/d,n[2]=p*r/d,!1}{const t=(-h-Math.sqrt(p))/(2*c);if(t<0){const t=Math.hypot(a,l,u);return n[0]=a*r/t,n[1]=l*r/t,n[2]=u*r/t,!1}return n[0]=a+i*t,n[1]=l+s*t,n[2]=u+o*t,!0}}}class Hu{constructor(t,e,r,n,i){this.TL=t,this.TR=e,this.BR=r,this.BL=n,this.horizon=i;}static fromInvProjectionMatrix(t,e,r){const n=[-1,1,1],i=[1,1,1],s=[1,-1,1],o=[-1,-1,1],a=j(n,n,t),l=j(i,i,t),u=j(s,s,t),c=j(o,o,t);return new Hu(a,l,u,c,e/r)}}function Xu(t,e,r){let n=1/0,i=-1/0;const s=[];for(const o of t){X(s,o,e);const t=O(s,r);n=Math.min(n,t),i=Math.max(i,t);}return [n,i]}function Zu(t,e){let r=!0;for(let n=0;n<t.planes.length;n++){const i=t.planes[n];let s=0;for(let t=0;t<e.length;t++)s+=+(O(i,e[t])+i[3]>=0);if(0===s)return 0;s!==e.length&&(r=!1);}return r?2:1}function Wu(t,e){for(const r of t.projections){const n=Xu(e,t.points[0],r.axis);if(r.projection[1]<n[0]||r.projection[0]>n[1])return 0}return 1}function Yu(t,e){let r=0;const n=[0,0,0,0];for(let o=0;o<t.length;o++)n[0]=t[o][0],n[1]=t[o][1],n[2]=t[o][2],n[3]=1,(i=n)[0]*(s=e)[0]+i[1]*s[1]+i[2]*s[2]+i[3]*s[3]>=0&&r++;var i,s;return r}class Ku{constructor(t,e){this.points=t||new Array(8).fill([0,0,0]),this.planes=e||new Array(6).fill([0,0,0,0]),this.bounds=Ju.fromPoints(this.points),this.projections=[],this.frustumEdges=[X([],this.points[2],this.points[3]),X([],this.points[0],this.points[3]),X([],this.points[4],this.points[0]),X([],this.points[5],this.points[1]),X([],this.points[6],this.points[2]),X([],this.points[7],this.points[3])];for(const t of this.frustumEdges){const e=[0,-t[2],t[1]],r=[t[2],0,-t[0]];this.projections.push({axis:e,projection:Xu(this.points,this.points[0],e)}),this.projections.push({axis:r,projection:Xu(this.points,this.points[0],r)});}}static fromInvProjectionMatrix(t,e,r,n){const i=Math.pow(2,r),s=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((r=>{const s=Q([],r,t),o=1/s[3]/e*i;return (a=s)[0]=(l=s)[0]*(u=[o,o,n?1/s[3]:o,o])[0],a[1]=l[1]*u[1],a[2]=l[2]*u[2],a[3]=l[3]*u[3],a;var a,l,u;})),o=[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]].map((t=>{const e=L([],U([],X([],s[t[0]],s[t[1]]),X([],s[t[2]],s[t[1]]))),r=-O(e,s[t[1]]);return e.concat(r)})),a=[];for(let t=0;t<s.length;t++)a.push([s[t][0],s[t][1],s[t][2]]);return new Ku(a,o)}intersectsPrecise(t,e,r){for(let r=0;r<e.length;r++)if(!Yu(t,e[r]))return 0;for(let e=0;e<this.planes.length;e++)if(!Yu(t,this.planes[e]))return 0;for(const e of r)for(const r of this.frustumEdges){const n=U([],e,r),i=I(n);if(0===i)continue;E(n,n,1/i);const s=Xu(this.points,this.points[0],n),o=Xu(t,this.points[0],n);if(s[0]>o[1]||o[0]>s[1])return 0}return 1}containsPoint(t){for(const e of this.planes){const r=e[3];if(O([e[0],e[1],e[2]],t)+r<0)return !1}return !0}}class Ju{static fromPoints(t){const e=[1/0,1/0,1/0],r=[-1/0,-1/0,-1/0];for(const n of t)z(e,e,n),T(r,r,n);return new Ju(e,r)}static fromTileIdAndHeight(t,e,r){const n=1<<t.canonical.z,i=t.canonical.x,s=t.canonical.y;return new Ju([i/n,s/n,e],[(i+1)/n,(s+1)/n,r])}static applyTransform(t,e){const r=t.getCorners();for(let t=0;t<r.length;++t)j(r[t],r[t],e);return Ju.fromPoints(r)}static applyTransformFast(t,e){const r=[e[12],e[13],e[14]],n=[...r];for(let i=0;i<3;i++)for(let s=0;s<3;s++){const o=e[4*s+i],a=o*t.min[s],l=o*t.max[s];r[i]+=Math.min(a,l),n[i]+=Math.max(a,l);}return new Ju(r,n)}static projectAabbCorners(t,e){const r=t.getCorners();for(let t=0;t<r.length;++t)j(r[t],r[t],e);return r}constructor(t,e){this.min=t,this.max=e,this.center=E([],P([],this.min,this.max),.5);}quadrant(t){const e=[t%2==0,t<2],r=A(this.min),n=A(this.max);for(let t=0;t<e.length;t++)r[t]=e[t]?this.min[t]:this.center[t],n[t]=e[t]?this.center[t]:this.max[t];return n[2]=this.max[2],new Ju(r,n)}distanceX(t){return Math.max(Math.min(this.max[0],t[0]),this.min[0])-t[0]}distanceY(t){return Math.max(Math.min(this.max[1],t[1]),this.min[1])-t[1]}distanceZ(t){return Math.max(Math.min(this.max[2],t[2]),this.min[2])-t[2]}getCorners(){const t=this.min,e=this.max;return [[t[0],t[1],t[2]],[e[0],t[1],t[2]],[e[0],e[1],t[2]],[t[0],e[1],t[2]],[t[0],t[1],e[2]],[e[0],t[1],e[2]],[e[0],e[1],e[2]],[t[0],e[1],e[2]]]}intersects(t){return this.intersectsAabb(t.bounds)?Zu(t,this.getCorners()):0}intersectsFlat(t){return this.intersectsAabb(t.bounds)?Zu(t,[[this.min[0],this.min[1],0],[this.max[0],this.min[1],0],[this.max[0],this.max[1],0],[this.min[0],this.max[1],0]]):0}intersectsPrecise(t,e){return e||this.intersects(t)?Wu(t,this.getCorners()):0}intersectsPreciseFlat(t,e){return e||this.intersectsFlat(t)?Wu(t,[[this.min[0],this.min[1],0],[this.max[0],this.min[1],0],[this.max[0],this.max[1],0],[this.min[0],this.max[1],0]]):0}intersectsAabb(t){for(let e=0;e<3;++e)if(this.min[e]>t.max[e]||t.min[e]>this.max[e])return !1;return !0}intersectsAabbXY(t){return !(this.min[0]>t.max[0]||t.min[0]>this.max[0]||this.min[1]>t.max[1]||t.min[1]>this.max[1])}encapsulate(t){for(let e=0;e<3;e++)this.min[e]=Math.min(this.min[e],t.min[e]),this.max[e]=Math.max(this.max[e],t.max[e]);}encapsulatePoint(t){for(let e=0;e<3;e++)this.min[e]=Math.min(this.min[e],t[e]),this.max[e]=Math.max(this.max[e],t[e]);}closestPoint(t){return [Math.max(Math.min(this.max[0],t[0]),this.min[0]),Math.max(Math.min(this.max[1],t[1]),this.min[1]),Math.max(Math.min(this.max[2],t[2]),this.min[2])]}}Qs(Ju,"Aabb");class Qu{constructor(t,e){this.feature=t,this.metersToTile=e,this.index=0;}get(){const t=this.feature.vertices[this.index],e=this.feature.vertexProps[this.index].dir,r=e[1],n=-e[0],i=(t.extent+1)*this.metersToTile;return [new It(Math.trunc(t.position[0]+r*i),Math.trunc(t.position[1]+n*i)),new It(Math.trunc(t.position[0]-r*i),Math.trunc(t.position[1]-n*i))]}next(){this.index++;}valid(){return this.index<this.feature.vertices.length}}class tc{constructor(t,e,r,n,i,s){if(this.vertices=new Array,this.vertexProps=new Array,this.edges=new Array,this.edgeProps=new Array,this._tmpVec2=[ut(),ut(),ut(),ut(),ut(),ut(),ut()],this.id=t,this.heightRange={min:r,max:r},this.safeArea=e,this.constantHeight=r,null==this.constantHeight&&(null!=this.constantHeight||0!==n.length)){this.vertices=n,this.edges=i,this.edges=this.edges.filter((t=>{return t.a<this.vertices.length&&t.b<this.vertices.length&&!((e=this.vertices[t.a].position)[0]===(r=this.vertices[t.b].position)[0]&&e[1]===r[1]);var e,r;})),this.heightRange={min:Number.POSITIVE_INFINITY,max:Number.NEGATIVE_INFINITY};for(const t of this.vertices)this.vertexProps.push({dir:ct(0,0)}),this.heightRange.min=Math.min(this.heightRange.min,t.height),this.heightRange.max=Math.max(this.heightRange.max,t.height);for(const t of this.edges){const e=this.vertices[t.a].position,r=this.vertices[t.b].position,n=dt(ut(),r,e),i=mt(n),s=ft(ut(),n,1/i);this.edgeProps.push({vec:n,dir:s,len:i});const o=this.vertexProps[t.a].dir,a=this.vertexProps[t.b].dir;pt(o,o,s),pt(a,a,s);}for(const t of this.vertexProps)0===t.dir[0]&&0===t.dir[1]||yt(t.dir,t.dir);this.tessellate(s);}}pointElevation(t){if(null!=this.constantHeight)return this.constantHeight;const e=this.getClosestEdge(t);if(null==e)return 0;const[r,n]=e;return pr(this.vertices[this.edges[r].a].height,this.vertices[this.edges[r].b].height,n)}computeSlopeNormal(t,e){const r=this.getClosestEdge(t);if(!r)return M(0,0,1);const n=r[0],i=this.edges[n],s=this.edgeProps[n].vec,o=M(s[0],s[1],(this.vertices[i.b].height-this.vertices[i.a].height)*e),a=M(o[1],-o[0],0);U(a,a,o);const l=I(a);return l>0?E(a,a,1/l):S(a,0,0,1)}getSafeArea(){return this.safeArea}isTunnel(){return this.heightRange.max<=-5}getClosestEdge(t){if(0===this.edges.length)return;let e=0,r=Number.POSITIVE_INFINITY,n=0;const[i,s,o,a,l,u,c]=this._tmpVec2;ht(c,t.x,t.y);const h=new Gu(c,null);for(let t=0;t<this.edges.length;t++){const p=this.edges[t],d=this.edgeProps[t].dir;h.dir=d;const f=this.vertices[p.a].position,m=this.vertices[p.b].position,y=h.intersectsPlane(f,this.vertexProps[p.a].dir,i),g=h.intersectsPlane(m,this.vertexProps[p.b].dir,s);if(!y||!g)continue;dt(o,s,i),dt(a,c,i);const x=gt(o,o),v=x>0?gt(a,o)/x:0,b=Ft(v,0,1),w=Math.abs((v-b)*this.edgeProps[t].len);dt(l,c,f),ht(u,d[1],-d[0]);const _=w+Math.abs(gt(l,u));_<r&&(e=t,r=_,n=b);}return [e,n]}tessellate(t){const e=_(),r=_(),n=_(),i=_();for(let s=this.edges.length-1;s>=0;--s){const o=this.edges[s].a,a=this.edges[s].b,{position:l,height:u,extent:c}=this.vertices[o],{position:h,height:p,extent:d}=this.vertices[a],f=this.vertexProps[o].dir,m=this.vertexProps[a].dir;if(S(e,l[0]/t,l[1]/t,u),S(r,h[0]/t,h[1]/t,p),S(n,f[1],-f[0],0),E(n,n,c),S(i,m[1],-m[0],0),E(i,i,d),this.distSqLines(M(e[0]+.5*n[0],e[1]+.5*n[1],e[2]+.5*n[2]),M(r[0]-.5*i[0],r[1]-.5*i[1],r[2]-.5*i[2]),M(e[0]-.5*n[0],e[1]-.5*n[1],e[2]-.5*n[2]),M(r[0]+.5*i[0],r[1]+.5*i[1],r[2]+.5*i[2]))<=.0025000000000000005)continue;const y=this.vertices.length,g=pt(ut(),l,h);this.vertices.push({position:ft(g,g,.5),height:.5*(u+p),extent:.5*(c+d)});const x=pt(ut(),f,m);this.vertexProps.push({dir:yt(x,x)}),this.edges.splice(s,1),this.edgeProps.splice(s,1),this.edges.push({a:o,b:y}),this.edges.push({a:y,b:a});const v=dt(ut(),this.vertices[y].position,l),b=mt(v),w={vec:v,dir:ft(ut(),v,1/b),len:b};this.edgeProps.push(w),this.edgeProps.push(w);}}distSqLines(t,e,r,n){const i=k(_(),e,t),s=k(_(),n,r),o=k(_(),t,r),a=O(i,i),l=O(i,s),u=O(i,o),c=O(s,s),h=O(s,o),p=a*c-l*l;if(0===p)return C(N(i,r,n,O(o,s)/O(s,s)),t);const d=(a*h-l*u)/p;return C(N(i,t,e,(l*h-u*c)/p),N(s,r,n,d))}}class ec{static parseFrom(t,e){const r=$u.parse(t);if(!r)return [];let{vertices:n,features:i}=r;const s=1/vu(e);i.sort(((t,e)=>t.id-e.id)),n.sort(((t,e)=>t.id-e.id||t.idx-e.idx)),n=n.filter(((t,e,r)=>e===r.findIndex((e=>e.id===t.id&&e.idx===t.idx))));const o=new Array;let a=0;const l=n.length;for(const t of i){if(t.constantHeight){o.push(new tc(t.id,t.bounds,t.constantHeight));continue}for(;a!==l&&n[a].id<t.id;)a++;if(a===l||n[a].id!==t.id)continue;const e=new Array,r=new Array,i=a;for(;a!==l&&n[a].id===t.id;){const t=n[a];if(e.push({position:t.position,height:t.height,extent:t.extent}),a!==i&&n[a-1].idx===t.idx-1){const t=a-i;r.push({a:t-1,b:t});}a++;}o.push(new tc(t.id,t.bounds,void 0,e,r,s));}return o}static getElevationFeature(t,e){if(!e)return;const r=+t.properties[Ru];return Number.isNaN(r)?void 0:e.find((t=>t.id===r))}}class rc{constructor(t,e){this.zScale=1,this.xOffset=0,this.yOffset=0,t.equals(e)||(this.zScale=Math.pow(2,e.z-t.z),this.xOffset=(t.x*this.zScale-e.x)*Un,this.yOffset=(t.y*this.zScale-e.y)*Un);}constantElevation(t,e){if(null!=t.constantHeight)return this.computeBiasedHeight(t.constantHeight,e)}pointElevation(t,e,r){const n=this.constantElevation(e,r);return null!=n?n:(t.x=t.x*this.zScale+this.xOffset,t.y=t.y*this.zScale+this.yOffset,this.computeBiasedHeight(e.pointElevation(t),r))}computeBiasedHeight(t,e){return e<=0?t:t+e*Ct(0,e,t>=0?t:Math.abs(.5*t))}}Qs(tc,"ElevationFeature");class nc{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.projection=t.projection,this.layoutVertexArray=new da,this.indexArray=new Fa,this.segments=new hl,this.programConfigurations=new Ul(t.layers,{zoom:t.zoom,lut:t.lut}),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.elevationMode=this.layers[0].layout.get("circle-elevation-reference"),this.hasElevation=!1,"none"!==this.elevationMode&&(this.elevatedLayoutVertexArray=new ya),this.worldview=t.worldview,this.hasAppearances=null;}updateFootprints(t,e){}updateAppearances(t,e,r,n){}populate(t,e,r,n){const i=this.layers[0],s=[];let o=null;"circle"===i.type&&(o=i.layout.get("circle-sort-key"));for(const{feature:i,id:a,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=Bu(i,t);if(!this.layers[0]._featureFilter.filter(new Io(this.zoom,{worldview:this.worldview,activeFloors:e.activeFloors}),c,r))continue;const h=o?o.evaluate(c,{},r):void 0,p={id:a,properties:i.properties,type:i.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:ku(i,r,n),patterns:{},sortKey:h};s.push(p);}o&&s.sort(((t,e)=>t.sortKey-e.sortKey));let a=null;"globe"===n.projection.name&&(this.globeExtVertexArray=new Ia,a=n.projection);for(const n of s){const{geometry:i,index:s,sourceLayerIndex:o}=n,l=t[s].feature;this.addFeature(n,i,s,e.availableImages,r,a,e.brightness,e.elevationFeatures),e.featureIndex.insert(l,i,s,o,this.index);}this.hasElevation||(this.elevatedLayoutVertexArray=void 0);}update(t,e,r,n,i,s,o){this.programConfigurations.updatePaintArrays(t,e,i,r,n,s,o,this.worldview);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,ll.members),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.globeExtVertexArray&&(this.globeExtVertexBuffer=t.createVertexBuffer(this.globeExtVertexArray,cl.members)),this.elevatedLayoutVertexArray&&(this.elevatedLayoutVertexBuffer=t.createVertexBuffer(this.elevatedLayoutVertexArray,ul.members))),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.globeExtVertexBuffer&&this.globeExtVertexBuffer.destroy(),this.elevatedLayoutVertexBuffer&&this.elevatedLayoutVertexBuffer.destroy());}addFeature(t,e,r,n,i,s,o,a){let l;"none"!==this.elevationMode&&(l=ec.getElevationFeature(t,a));for(const r of e)for(const e of r){const r=e.x,n=e.y;if(r<0||r>=Un||n<0||n>=Un)continue;if(s){const t=s.projectTilePoint(r,n,i),e=s.upVector(i,r,n);this.addGlobeExtVertex(t,e),this.addGlobeExtVertex(t,e),this.addGlobeExtVertex(t,e),this.addGlobeExtVertex(t,e);}const o=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray,t.sortKey),a=o.vertexLength;if(this.addCircleVertex(r,n,-1,-1),this.addCircleVertex(r,n,1,-1),this.addCircleVertex(r,n,1,1),this.addCircleVertex(r,n,-1,1),"none"!==this.elevationMode){const t=l?l.pointElevation(new It(r,n)):0;this.hasElevation=this.hasElevation||0!==t;for(let e=0;e<4;e++)this.elevatedLayoutVertexArray.emplaceBack(t);}this.indexArray.emplaceBack(a,a+1,a+2),this.indexArray.emplaceBack(a,a+2,a+3),o.vertexLength+=4,o.primitiveLength+=2;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{},n,i,o,void 0,this.worldview);}addCircleVertex(t,e,r,n){this.layoutVertexArray.emplaceBack(2*t+(r+1)/2,2*e+(n+1)/2);}addGlobeExtVertex(t,e){const r=16384;this.globeExtVertexArray.emplaceBack(t.x,t.y,t.z,e[0]*r,e[1]*r,e[2]*r);}}function ic(t,e){for(let r=0;r<t.length;r++)if(mc(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(mc(t,e[r]))return !0;return !!lc(t,e)}function sc(t,e,r){return !!mc(t,e)||!!pc(e,t,r)}function oc(t,e){if(1===t.length)return fc(e,t[0]);for(let r=0;r<e.length;r++){const n=e[r];for(let e=0;e<n.length;e++)if(mc(t,n[e]))return !0}for(let r=0;r<t.length;r++)if(fc(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(lc(t,e[r]))return !0;return !1}function ac(t,e,r){if(t.length>1){if(lc(t,e))return !0;for(let n=0;n<e.length;n++)if(pc(e[n],t,r))return !0}for(let n=0;n<t.length;n++)if(pc(t[n],e,r))return !0;return !1}function lc(t,e){if(0===t.length||0===e.length)return !1;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)if(uc(n,i,e[t],e[t+1]))return !0}return !1}function uc(t,e,r,n){return Zt(t,r,n)!==Zt(e,r,n)&&Zt(t,e,r)!==Zt(t,e,n)}function cc(t,e,r){return (t.x-r.x)*(e.y-r.y)-(t.y-r.y)*(e.x-r.x)}function hc(t,e,r,n){const i=cc(t,e,n),s=cc(t,e,r);if(Math.sign(i)===Math.sign(s))return;const o=cc(r,n,t),a=o+s-i;return Math.sign(o)!==Math.sign(a)?[o/(o-a),s/(s-i)]:void 0}function pc(t,e,r){const n=r*r;if(1===e.length)return t.distSqr(e[0])<n;for(let r=1;r<e.length;r++)if(dc(t,e[r-1],e[r])<n)return !0;return !1}function dc(t,e,r){const n=e.distSqr(r);if(0===n)return t.distSqr(e);const i=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/n;return t.distSqr(i<0?e:i>1?r:r.sub(e)._mult(i)._add(e))}function fc(t,e){let r,n,i,s=!1;for(let o=0;o<t.length;o++){r=t[o];for(let t=0,o=r.length-1;t<r.length;o=t++)n=r[t],i=r[o],n.y>e.y!=i.y>e.y&&e.x<(i.x-n.x)*(e.y-n.y)/(i.y-n.y)+n.x&&(s=!s);}return s}function mc(t,e){let r=!1;for(let n=0,i=t.length-1;n<t.length;i=n++){const s=t[n],o=t[i];s.y>e.y!=o.y>e.y&&e.x<(o.x-s.x)*(e.y-s.y)/(o.y-s.y)+s.x&&(r=!r);}return r}function yc(t,e,r,n,i){for(const s of t)if(e<=s.x&&r<=s.y&&n>=s.x&&i>=s.y)return !0;const s=[new It(e,r),new It(e,i),new It(n,i),new It(n,r)];if(t.length>2)for(const e of s)if(mc(t,e))return !0;for(let e=0;e<t.length-1;e++)if(gc(t[e],t[e+1],s))return !0;return !1}function gc(t,e,r){const n=r[0],i=r[2];if(t.x<n.x&&e.x<n.x||t.x>i.x&&e.x>i.x||t.y<n.y&&e.y<n.y||t.y>i.y&&e.y>i.y)return !1;const s=Zt(t,e,r[0]);return s!==Zt(t,e,r[1])||s!==Zt(t,e,r[2])||s!==Zt(t,e,r[3])}function xc(t,e,r,n,i,s){let o=e.y-t.y,a=t.x-e.x;if(s=s||0){const t=o*o+a*a;if(0===t)return !0;const e=Math.sqrt(t);o/=e,a/=e;}return !((r.x-t.x)*o+(r.y-t.y)*a-s<0||(n.x-t.x)*o+(n.y-t.y)*a-s<0||(i.x-t.x)*o+(i.y-t.y)*a-s<0)}function vc(t,e,r,n,i,s,o){return !(xc(t,e,n,i,s,o)||xc(e,r,n,i,s,o)||xc(r,t,n,i,s,o)||xc(n,i,t,e,r,o)||xc(i,s,t,e,r,o)||xc(s,n,t,e,r,o))}function bc(t,e,r){const n=e.paint.get(t).value;return "constant"===n.kind?n.value:r.programConfigurations.get(e.id).getMaxValue(t)}function wc(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function _c(t,e,r,n,i){if(!e[0]&&!e[1])return t;const s=It.convert(e)._mult(i);"viewport"===r&&s._rotate(-n);const o=[];for(let e=0;e<t.length;e++)o.push(t[e].sub(s));return o}function Ac(t,e,r,n){const i=It.convert(t)._mult(n);return "viewport"===e&&i._rotate(-r),i}let Ic,Mc;function Sc(t,e,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return [t*n-2*Math.PI*6378137/2,e*n-2*Math.PI*6378137/2]}Qs(nc,"CircleBucket",{omit:["layers"]});class Pc{constructor(t,e,r){this.z=t,this.x=e,this.y=r,this.key=zc(0,t,t,e,r);}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}isChildOf(t){const e=this.z-t.z;return 0===t.z||t.z<this.z&&t.x===this.x>>e&&t.y===this.y>>e}url(t,e){const r=function(t,e,r){var n=Sc(256*t,256*(e=Math.pow(2,r)-e-1),r),i=Sc(256*(t+1),256*(e+1),r);return n[0]+","+n[1]+","+i[0]+","+i[1]}(this.x,this.y,this.z),n=function(t,e,r){let n,i="";for(let s=t;s>0;s--)n=1<<s-1,i+=(e&n?1:0)+(r&n?2:0);return i}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace("{prefix}",(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===e?Math.pow(2,this.z)-this.y-1:this.y)).replace("{quadkey}",n).replace("{bbox-epsg-3857}",r)}toString(){return `${this.z}/${this.x}/${this.y}`}}class kc{constructor(t,e){this.wrap=t,this.canonical=e,this.key=zc(t,e.z,e.z,e.x,e.y);}}class Bc{constructor(t,e,r,n,i){this.overscaledZ=t,this.wrap=e,this.canonical=new Pc(r,+n,+i),this.key=0===e&&t===r?this.canonical.key:zc(e,t,r,n,i);}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){const e=this.canonical.z-t;return t>this.canonical.z?new Bc(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new Bc(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e=!0){if(this.overscaledZ===t&&e)return this.key;if(t>this.canonical.z)return zc(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y);{const r=this.canonical.z-t;return zc(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r)}}isChildOf(t){if(t.wrap!==this.wrap)return !1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.z<this.canonical.z&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return [new Bc(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return [new Bc(e,this.wrap,e,r,n),new Bc(e,this.wrap,e,r+1,n),new Bc(e,this.wrap,e,r,n+1),new Bc(e,this.wrap,e,r+1,n+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new Bc(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new Bc(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new kc(this.wrap,this.canonical)}toString(){return `${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}}function zc(t,e,r,n,i){const s=1<<Math.min(r,22);let o=s*(i%s)+n%s;return t&&r<22&&(o+=s*s*((t<0?-2*t-1:2*t)%(1<<2*(22-r)))),16*(32*o+r)+(e-r)}const Tc=[t=>{let e=t.canonical.x-1,r=t.wrap;return e<0&&(e=(1<<t.canonical.z)-1,r--),new Bc(t.overscaledZ,r,t.canonical.z,e,t.canonical.y)},t=>{let e=t.canonical.x+1,r=t.wrap;return e===1<<t.canonical.z&&(e=0,r++),new Bc(t.overscaledZ,r,t.canonical.z,e,t.canonical.y)},t=>new Bc(t.overscaledZ,t.wrap,t.canonical.z,t.canonical.x,(0===t.canonical.y?1<<t.canonical.z:t.canonical.y)-1),t=>new Bc(t.overscaledZ,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y===(1<<t.canonical.z)-1?0:t.canonical.y+1)];Qs(Pc,"CanonicalTileID"),Qs(Bc,"OverscaledTileID",{omit:["projMatrix","expandedProjMatrix"]});const Ec=ha([{type:"Float32",name:"a_globe_pos",components:3},{type:"Float32",name:"a_uv",components:2}]),{members:Vc}=Ec,Fc=ha([{name:"a_pos_3",components:3,type:"Int16"}]);var Cc=ha([{name:"a_pos",type:"Int16",components:2}]);function Dc(t){return t*Hl/ru}const Rc=[new Ju([Jl,Jl,Jl],[Ql,Ql,Ql]),new Ju([Jl,Jl,Jl],[0,0,Ql]),new Ju([0,Jl,Jl],[Ql,0,Ql]),new Ju([Jl,0,Jl],[0,Ql,Ql]),new Ju([0,0,Jl],[Ql,Ql,Ql])];function Lc(t,e,r,n=!0){const i=E([],t._camera.position,t.worldSize),s=[e,r,1,1];Q(s,s,t.pixelMatrixInverse),K(s,s,1/s[3]);const o=L([],X([],s,i)),a=t.globeMatrix,l=[a[12],a[13],a[14]],u=X([],l,i),c=I(u),h=L([],u),p=t.worldSize/(2*Math.PI),d=O(h,o),f=Math.asin(p/c);if(f<Math.acos(d)){if(!n)return null;const t=[],e=[];E(t,o,c/d),L(e,X(e,t,u)),L(o,P(o,u,E(o,e,Math.tan(f)*c)));}const m=[];new qu(i,o).closestPointOnSphere(l,p,m);const y=L([],te(a,0)),g=L([],te(a,1)),x=L([],te(a,2)),v=O(y,m),b=O(g,m),w=O(x,m),_=Bt(Math.asin(-b/p));let A=Bt(Math.atan2(v,w));A=t.center.lng+function(t,e){const r=(e-t+180)%360-180;return r<-180?r+360:r}(t.center.lng,A);const M=uu(A),S=Ft(cu(_),0,1);return new bu(M,S)}class Oc{constructor(t,e,r){this.a=X([],t,r),this.b=X([],e,r),this.center=r;const n=L([],this.a),i=L([],this.b);this.angle=Math.acos(O(n,i));}}function Uc(t,e){if(0===t.angle)return null;let r;return r=0===t.a[e]?1/t.angle*.5*Math.PI:1/t.angle*Math.atan(t.b[e]/t.a[e]/Math.sin(t.angle)-1/Math.tan(t.angle)),r<0||r>1?null:function(t,e,r,n){const i=Math.sin(r);return t*(Math.sin((1-n)*r)/i)+e*(Math.sin(n*r)/i)}(t.a[e],t.b[e],t.angle,Ft(r,0,1))+t.center[e]}function Nc(t){if(t.z<=1)return Rc[t.z+2*t.y+t.x];const e=Hc(qc(t));return Ju.fromPoints(e)}function jc(t,e,r){return E(t,t,1-r),V(t,t,e,r)}function $c(t,e,r){for(const n of t)j(n,n,e),E(n,n,r);}function Gc(t,e,r,n){const i=e/t.worldSize,s=t.globeMatrix;if(r.z<=1){const t=Nc(r).getCorners();return $c(t,s,i),Ju.fromPoints(t)}const o=qc(r,n),a=Hc(o,Hl+Dc(t._tileCoverLift));$c(a,s,i);const l=Number.MAX_VALUE,u=[-l,-l,-l],c=[l,l,l];if(o.contains(t.center)){for(const t of a)z(c,c,t),T(u,u,t);u[2]=0;const e=t.point,r=[e.x*i,e.y*i,0];return z(c,c,r),T(u,u,r),new Ju(c,u)}if(t._tileCoverLift>0){for(const t of a)z(c,c,t),T(u,u,t);return new Ju(c,u)}const h=[s[12]*i,s[13]*i,s[14]*i],p=o.getCenter(),d=Ft(t.center.lat,-mu,mu),f=Ft(p.lat,-mu,mu),m=uu(t.center.lng),y=cu(d);let g=m-uu(p.lng);const x=y-cu(f);g>.5?g-=1:g<-.5&&(g+=1);let v=0;Math.abs(g)>Math.abs(x)?v=g>=0?1:3:(v=x>=0?0:2,V(h,h,[s[4]*i,s[5]*i,s[6]*i],-Math.sin(kt(x>=0?o.getSouth():o.getNorth()))*Hl));const b=a[v],w=a[(v+1)%4],_=new Oc(b,w,h),A=[Uc(_,0)||b[0],Uc(_,1)||b[1],Uc(_,2)||b[2]],I=eh(t.zoom);if(I>0){const n=function({x:t,y:e,z:r},n,i,s,o){const a=1/(1<<r);let l=t*a,u=l+a,c=e*a,h=c+a,p=0;const d=(l+u)/2-s;return d>.5?p=-1:d<-.5&&(p=1),l=((l+p)*n-(s*=n))*i+s,u=((u+p)*n-s)*i+s,c=(c*n-(o*=n))*i+o,h=(h*n-o)*i+o,[[l,h,0],[u,h,0],[u,c,0],[l,c,0]]}(r,e,t._pixelsPerMercatorPixel,m,y);for(let t=0;t<a.length;t++)jc(a[t],n[t],I);const i=P([],n[v],n[(v+1)%4]);E(i,i,.5),jc(A,i,I);}for(const t of a)z(c,c,t),T(u,u,t);return c[2]=Math.min(b[2],w[2]),z(c,c,A),T(u,u,A),new Ju(c,u)}function qc({x:t,y:e,z:r},n=!1){const i=1/(1<<r),s=new iu(pu(t*i),e===(1<<r)-1&&n?-90:du((e+1)*i)),o=new iu(pu((t+1)*i),0===e&&n?90:du(e*i));return new su(s,o)}function Hc(t,e=Hl){const r=kt(t.getNorth()),n=kt(t.getSouth()),i=Math.cos(r),s=Math.cos(n),o=Math.sin(r),a=Math.sin(n),l=t.getWest(),u=t.getEast();return [tu(s,a,l,e),tu(s,a,u,e),tu(i,o,u,e),tu(i,o,l,e)]}function Xc(t,e,r,n){const i=1<<r.z,s=(t/Un+r.x)/i;return eu(du((e/Un+r.y)/i),pu(s),n)}function Zc({min:t,max:e}){return Wl/Math.max(e[0]-t[0],e[1]-t[1],e[2]-t[2])}const Wc=new Float64Array(16);function Yc(t){const e=Zc(t),r=g(Wc,[e,e,e]);return p(r,r,R([],t.min))}function Kc(t){const e=(n=t.min,(r=Wc)[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=1,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=1,r[11]=0,r[12]=n[0],r[13]=n[1],r[14]=n[2],r[15]=1,r);var r,n;const i=1/Zc(t);return d(e,e,[i,i,i])}function Jc(t){const e=Un/(2*Math.PI);return t/(2*Math.PI)/e}function Qc(t,e){return Un/(512*Math.pow(2,t))*Zc(Nc(e))}function th(t,e,r,n,i){const s=Jc(r),o=[t,e,-r/(2*Math.PI)],a=u(new Float64Array(16));return p(a,a,o),d(a,a,[s,s,s]),f(a,a,kt(-i)),m(a,a,kt(-n)),a}function eh(t){return Ct(Xl,Zl,t)}function rh(t,e){const r=eu(e.lat,e.lng),n=function(t){const e=eu(t._center.lat,t._center.lng);let r=U([],M(0,1,0),e);const n=x([],-t.angle,e);r=j(r,r,n),x(n,-t._pitch,r);const i=L([],e);return E(i,i,Dc(t.cameraToCenterDistance/t.pixelsPerMeter)),j(i,i,n),P([],e,i)}(t);return o=(i=k([],n,r))[0],a=i[1],l=i[2],u=(s=r)[0],c=s[1],h=s[2],d=(p=Math.sqrt((o*o+a*a+l*l)*(u*u+c*c+h*h)))&&O(i,s)/p,Math.acos(Math.min(Math.max(d,-1),1));var i,s,o,a,l,u,c,h,p,d;}function nh(t,e){return rh(t,e)>Math.PI/2*1.01}const ih=kt(85),sh=Math.cos(ih),oh=Math.sin(ih),ah=a(),lh=t=>{const e=[];return "map"===t.paint.get("circle-pitch-alignment")&&e.push("PITCH_WITH_MAP"),"map"===t.paint.get("circle-pitch-scale")&&e.push("SCALE_WITH_MAP"),e};function uh(t,e,r,n,i,s,o,a,l){if(s&&t.queryGeometry.isAboveHorizon)return !1;s&&(l*=t.pixelToTileUnitsFactor);const u=t.tileID.canonical,c=r.projection.upVectorScale(u,r.center.lat,r.worldSize).metersToTile;for(const h of e)for(const e of h){const h=e.add(a),p=i&&r.elevation?r.elevation.exaggeration()*i.getElevationAt(h.x,h.y,!0):0,d=r.projection.projectTilePoint(h.x,h.y,u);if(p>0){const t=r.projection.upVector(u,h.x,h.y);d.x+=t[0]*c*p,d.y+=t[1]*c*p,d.z+=t[2]*c*p;}const f=s?h:ch(d.x,d.y,d.z,n),m=s?t.tilespaceRays.map((t=>dh(t,p))):t.queryGeometry.screenGeometry,y=Q([],[d.x,d.y,d.z,1],n);if(!o&&s?l*=y[3]/r.cameraToCenterDistance:o&&!s&&(l*=r.cameraToCenterDistance/y[3]),s){const t=du((e.y/Un+u.y)/(1<<u.z));l/=r.projection.pixelsPerMeter(t,1)/hu(1,t);}if(sc(m,f,l))return !0}return !1}function ch(t,e,r,n){const i=Q([],[t,e,r,1],n);return new It(i[0]/i[3],i[1]/i[3])}const hh=M(0,0,0),ph=M(0,0,1);function dh(t,e){const r=_();return hh[2]=e,t.intersectsPlane(hh,ph,r),new It(r[0],r[1])}class fh extends nc{}let mh,yh,gh,xh;function vh(t,{width:e,height:r},n,i){if(i){if(i instanceof Uint8ClampedArray)i=new Uint8Array(i.buffer);else if(i.length!==e*r*n)throw new RangeError("mismatched image size")}else i=new Uint8Array(e*r*n);return t.width=e,t.height=r,t.data=i,t}function bh(t,e,r){const{width:n,height:i}=e;n===t.width&&i===t.height||(wh(t,e,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,n),height:Math.min(t.height,i)},r,null),t.width=n,t.height=i,t.data=e.data);}function wh(t,e,r,n,i,s,o,a){if(0===i.width||0===i.height)return e;if(i.width>t.width||i.height>t.height||r.x>t.width-i.width||r.y>t.height-i.height)throw new RangeError("out of range source coordinates for image copy");if(i.width>e.width||i.height>e.height||n.x>e.width-i.width||n.y>e.height-i.height)throw new RangeError("out of range destination coordinates for image copy");const l=t.data,u=e.data,c=4===s&&a;for(let a=0;a<i.height;a++){const h=((r.y+a)*t.width+r.x)*s,p=((n.y+a)*e.width+n.x)*s;if(c)for(let t=0;t<i.width;t++){const e=h+t*s+3,r=p+t*s;u[r+0]=255,u[r+1]=255,u[r+2]=255,u[r+3]=l[e];}else if(o)for(let t=0;t<i.width;t++){const e=h+t*s,r=p+t*s,n=new lr(l[e+0]/255,l[e+1]/255,l[e+2]/255,l[e+3]).toNonPremultipliedRenderColor(o).toArray();u[r+0]=n[0],u[r+1]=n[1],u[r+2]=n[2],u[r+3]=n[3];}else for(let t=0;t<i.width*s;t++)u[p+t]=l[h+t];}return e}Qs(fh,"HeatmapBucket",{omit:["layers"]});class _h{constructor(t,e){vh(this,t,1,e);}resize(t){bh(this,new _h(t),1);}clone(){return new _h({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){wh(t,e,r,n,i,1,null);}}class Ah{constructor(t,e){vh(this,t,4,e);}resize(t){bh(this,new Ah(t),4);}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t;}clone(){return new Ah({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i,s,o){wh(t,e,r,n,i,4,s,o);}}class Ih{constructor(t,e){this.width=t.width,this.height=t.height,this.data=e instanceof Uint8Array?new Float32Array(e.buffer):e;}}function Mh(t){const e={},r=t.resolution||256,n=t.clips?t.clips.length:1,i=t.image||new Ah({width:r,height:n}),s=(r,n,s)=>{e[t.evaluationKey]=s;const o=t.expression.evaluate(e),a=o?o.toNonPremultipliedRenderColor(null):null;a&&(i.data[r+n+0]=Math.floor(255*a.r),i.data[r+n+1]=Math.floor(255*a.g),i.data[r+n+2]=Math.floor(255*a.b),i.data[r+n+3]=Math.floor(255*a.a));};if(t.clips)for(let e=0,i=0;e<n;++e,i+=4*r)for(let n=0,o=0;n<r;n++,o+=4){const a=n/(r-1),{start:l,end:u}=t.clips[e];s(i,o,l*(1-a)+u*a);}else for(let t=0,e=0;t<r;t++,e+=4)s(0,e,t/(r-1));return i}Qs(_h,"AlphaImage"),Qs(Ah,"RGBAImage");const Sh=ha([{name:"a_pos",components:2,type:"Int16"}],4),Ph=ha([{name:"a_road_z_offset",components:1,type:"Float32"}],4),kh=ha([{name:"a_pos",components:2,type:"Int16"},{name:"a_height",components:1,type:"Float32"}],4),Bh=ha([{name:"a_pos_normal_3",components:3,type:"Int16"}],4);function zh(t,e,r=2){const n=e&&e.length,i=n?e[0]*r:t.length;let s=Th(t,0,i,r,!0);const o=[];if(!s||s.next===s.prev)return o;let a,l,u;if(n&&(s=function(t,e,r,n){const i=[];for(let r=0,s=e.length;r<s;r++){const o=Th(t,e[r]*n,r<s-1?e[r+1]*n:t.length,n,!1);o===o.next&&(o.steiner=!0),i.push(jh(o));}i.sort(Lh);for(let t=0;t<i.length;t++)r=Oh(i[t],r);return r}(t,e,s,r)),t.length>80*r){a=t[0],l=t[1];let e=a,n=l;for(let s=r;s<i;s+=r){const r=t[s],i=t[s+1];r<a&&(a=r),i<l&&(l=i),r>e&&(e=r),i>n&&(n=i);}u=Math.max(e-a,n-l),u=0!==u?32767/u:0;}return Vh(s,o,r,a,l,u,0),o}function Th(t,e,r,n,i){let s;if(i===function(t,e,r,n){let i=0;for(let s=e,o=r-n;s<r;s+=n)i+=(t[o]-t[s])*(t[s+1]+t[o+1]),o=s;return i}(t,e,r,n)>0)for(let i=e;i<r;i+=n)s=Qh(i/n|0,t[i],t[i+1],s);else for(let i=r-n;i>=e;i-=n)s=Qh(i/n|0,t[i],t[i+1],s);return s&&Xh(s,s.next)&&(tp(s),s=s.next),s}function Eh(t,e){if(!t)return t;e||(e=t);let r,n=t;do{if(r=!1,n.steiner||!Xh(n,n.next)&&0!==Hh(n.prev,n,n.next))n=n.next;else {if(tp(n),n=e=n.prev,n===n.next)break;r=!0;}}while(r||n!==e);return e}function Vh(t,e,r,n,i,s,o){if(!t)return;!o&&s&&function(t,e,r,n){let i=t;do{0===i.z&&(i.z=Nh(i.x,i.y,e,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next;}while(i!==t);i.prevZ.nextZ=null,i.prevZ=null,function(t){let e,r=1;do{let n,i=t;t=null;let s=null;for(e=0;i;){e++;let o=i,a=0;for(let t=0;t<r&&(a++,o=o.nextZ,o);t++);let l=r;for(;a>0||l>0&&o;)0!==a&&(0===l||!o||i.z<=o.z)?(n=i,i=i.nextZ,a--):(n=o,o=o.nextZ,l--),s?s.nextZ=n:t=n,n.prevZ=s,s=n;i=o;}s.nextZ=null,r*=2;}while(e>1)}(i);}(t,n,i,s);let a=t;for(;t.prev!==t.next;){const l=t.prev,u=t.next;if(s?Ch(t,n,i,s):Fh(t))e.push(l.i,t.i,u.i),tp(t),t=u.next,a=u.next;else if((t=u)===a){o?1===o?Vh(t=Dh(Eh(t),e),e,r,n,i,s,2):2===o&&Rh(t,e,r,n,i,s):Vh(Eh(t),e,r,n,i,s,1);break}}}function Fh(t){const e=t.prev,r=t,n=t.next;if(Hh(e,r,n)>=0)return !1;const i=e.x,s=r.x,o=n.x,a=e.y,l=r.y,u=n.y,c=Math.min(i,s,o),h=Math.min(a,l,u),p=Math.max(i,s,o),d=Math.max(a,l,u);let f=n.next;for(;f!==e;){if(f.x>=c&&f.x<=p&&f.y>=h&&f.y<=d&&Gh(i,a,s,l,o,u,f.x,f.y)&&Hh(f.prev,f,f.next)>=0)return !1;f=f.next;}return !0}function Ch(t,e,r,n){const i=t.prev,s=t,o=t.next;if(Hh(i,s,o)>=0)return !1;const a=i.x,l=s.x,u=o.x,c=i.y,h=s.y,p=o.y,d=Math.min(a,l,u),f=Math.min(c,h,p),m=Math.max(a,l,u),y=Math.max(c,h,p),g=Nh(d,f,e,r,n),x=Nh(m,y,e,r,n);let v=t.prevZ,b=t.nextZ;for(;v&&v.z>=g&&b&&b.z<=x;){if(v.x>=d&&v.x<=m&&v.y>=f&&v.y<=y&&v!==i&&v!==o&&Gh(a,c,l,h,u,p,v.x,v.y)&&Hh(v.prev,v,v.next)>=0)return !1;if(v=v.prevZ,b.x>=d&&b.x<=m&&b.y>=f&&b.y<=y&&b!==i&&b!==o&&Gh(a,c,l,h,u,p,b.x,b.y)&&Hh(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}for(;v&&v.z>=g;){if(v.x>=d&&v.x<=m&&v.y>=f&&v.y<=y&&v!==i&&v!==o&&Gh(a,c,l,h,u,p,v.x,v.y)&&Hh(v.prev,v,v.next)>=0)return !1;v=v.prevZ;}for(;b&&b.z<=x;){if(b.x>=d&&b.x<=m&&b.y>=f&&b.y<=y&&b!==i&&b!==o&&Gh(a,c,l,h,u,p,b.x,b.y)&&Hh(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}return !0}function Dh(t,e){let r=t;do{const n=r.prev,i=r.next.next;!Xh(n,i)&&Zh(n,r,r.next,i)&&Kh(n,i)&&Kh(i,n)&&(e.push(n.i,r.i,i.i),tp(r),tp(r.next),r=t=i),r=r.next;}while(r!==t);return Eh(r)}function Rh(t,e,r,n,i,s){let o=t;do{let t=o.next.next;for(;t!==o.prev;){if(o.i!==t.i&&qh(o,t)){let a=Jh(o,t);return o=Eh(o,o.next),a=Eh(a,a.next),Vh(o,e,r,n,i,s,0),void Vh(a,e,r,n,i,s,0)}t=t.next;}o=o.next;}while(o!==t)}function Lh(t,e){let r=t.x-e.x;return 0===r&&(r=t.y-e.y,0===r)&&(r=(t.next.y-t.y)/(t.next.x-t.x)-(e.next.y-e.y)/(e.next.x-e.x)),r}function Oh(t,e){const r=function(t,e){let r=e;const n=t.x,i=t.y;let s,o=-1/0;if(Xh(t,r))return r;do{if(Xh(t,r.next))return r.next;if(i<=r.y&&i>=r.next.y&&r.next.y!==r.y){const t=r.x+(i-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(t<=n&&t>o&&(o=t,s=r.x<r.next.x?r:r.next,t===n))return s}r=r.next;}while(r!==e);if(!s)return null;const a=s,l=s.x,u=s.y;let c=1/0;r=s;do{if(n>=r.x&&r.x>=l&&n!==r.x&&$h(i<u?n:o,i,l,u,i<u?o:n,i,r.x,r.y)){const e=Math.abs(i-r.y)/(n-r.x);Kh(r,t)&&(e<c||e===c&&(r.x>s.x||r.x===s.x&&Uh(s,r)))&&(s=r,c=e);}r=r.next;}while(r!==a);return s}(t,e);if(!r)return e;const n=Jh(r,t);return Eh(n,n.next),Eh(r,r.next)}function Uh(t,e){return Hh(t.prev,t,e.prev)<0&&Hh(e.next,t,t.next)<0}function Nh(t,e,r,n,i){return (t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-r)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-n)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function jh(t){let e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e),e=e.next;}while(e!==t);return r}function $h(t,e,r,n,i,s,o,a){return (i-o)*(e-a)>=(t-o)*(s-a)&&(t-o)*(n-a)>=(r-o)*(e-a)&&(r-o)*(s-a)>=(i-o)*(n-a)}function Gh(t,e,r,n,i,s,o,a){return !(t===o&&e===a)&&$h(t,e,r,n,i,s,o,a)}function qh(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){let r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&Zh(r,r.next,t,e))return !0;r=r.next;}while(r!==t);return !1}(t,e)&&(Kh(t,e)&&Kh(e,t)&&function(t,e){let r=t,n=!1;const i=(t.x+e.x)/2,s=(t.y+e.y)/2;do{r.y>s!=r.next.y>s&&r.next.y!==r.y&&i<(r.next.x-r.x)*(s-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next;}while(r!==t);return n}(t,e)&&(Hh(t.prev,t,e.prev)||Hh(t,e.prev,e))||Xh(t,e)&&Hh(t.prev,t,t.next)>0&&Hh(e.prev,e,e.next)>0)}function Hh(t,e,r){return (e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function Xh(t,e){return t.x===e.x&&t.y===e.y}function Zh(t,e,r,n){const i=Yh(Hh(t,e,r)),s=Yh(Hh(t,e,n)),o=Yh(Hh(r,n,t)),a=Yh(Hh(r,n,e));return i!==s&&o!==a||!(0!==i||!Wh(t,r,e))||!(0!==s||!Wh(t,n,e))||!(0!==o||!Wh(r,t,n))||!(0!==a||!Wh(r,e,n))}function Wh(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y)}function Yh(t){return t>0?1:t<0?-1:0}function Kh(t,e){return Hh(t.prev,t,t.next)<0?Hh(t,e,t.next)>=0&&Hh(t,t.prev,e)>=0:Hh(t,e,t.prev)<0||Hh(t,t.next,e)<0}function Jh(t,e){const r=ep(t.i,t.x,t.y),n=ep(e.i,e.x,e.y),i=t.next,s=e.prev;return t.next=e,e.prev=t,r.next=i,i.prev=r,n.next=r,r.prev=n,s.next=n,n.prev=s,n}function Qh(t,e,r,n){const i=ep(t,e,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function tp(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ);}function ep(t,e,r){return {i:t,x:e,y:r,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}function rp(t,e){const r=t.length;if(r<=1)return [t];const n=[];let i,s;for(let e=0;e<r;e++){const r=Wt(t[e]);0!==r&&(t[e].area=Math.abs(r),void 0===s&&(s=r<0),s===r<0?(i&&n.push(i),i=[t[e]]):i.push(t[e]));}if(i&&n.push(i),e>1)for(let t=0;t<n.length;t++)n[t].length<=e||(ln(n[t],e,1,n[t].length-1,np),n[t]=n[t].slice(0,e));return n}function np(t,e){return e.area-t.area}function ip(t,e,r=1){if(!t)return null;const n="string"==typeof t?Lr.from(t).getPrimary():t.getPrimary(),i="string"==typeof t?null:t.getSecondary();for(const t of [n,i]){if(!t)continue;const n=t.id.toString();e.has(n)||e.set(n,[]),t.scaleSelf(r),e.get(n).push(t);}return {primary:n.toString(),secondary:i?i.toString():null}}function sp(t,e,r,n){const i=n.patternDependencies;let s=!1;for(const n of e){const e=n.paint.get(`${t}-pattern`);e.isConstant()||(s=!0),ip(e.constantOr(null),i,r)&&(s=!0);}return s}function op(t,e,r,n,i,s){const o=s.patternDependencies;for(const a of e){const e=a.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:n},r,{},s.availableImages);t=t&&t.name?t.name:t;const l=ip(t,o,i);if(!l)continue;const{primary:u,secondary:c}=l;u&&(r.patterns[a.id]=[u,c].filter(Boolean));}}return r}class ap{constructor(){this.polygons=new Map;}add(t,...e){const r=this.polygons.get(t);r?r.push(...e):this.polygons.set(t,e);}merge(t){for(const[e,r]of t.polygons)this.add(e,...r);}}class lp{constructor(){this.portals=[];}static isOnBorder(t,e){return t<=0&&e<=0||t>=Un&&e>=Un}static evaluate(t){if(0===t.length)return new lp;let e=[];for(const r of t)e.push(...r.portals);if(0===e.length)return new lp;for(const t of e){const e=t.va,r=t.vb;(lp.isOnBorder(e.x,r.x)||lp.isOnBorder(e.y,r.y))&&(t.type="border");}const r=e.filter((t=>"unevaluated"!==t.type)),n=e.filter((t=>"unevaluated"===t.type));if(0===n.length)return new lp;n.sort(((t,e)=>t.hash===e.hash?t.isTunnel===e.isTunnel?0:t.isTunnel?-1:1:t.hash<e.hash?1:-1)),e=r.concat(n);let i=r.length,s=i,o=i;do{if(s++,s===e.length||e[i].hash!==e[s].hash){if(s-i==2){o<i&&(e[o]=e[i],e[i]=null);const t=e[o],r=e[s-1];t.type=t.isTunnel!==r.isTunnel?"tunnel":"polygon",t.connection={a:t.connection.a,b:r.connection.a},o++;}i=s;}}while(i!==e.length);return e.splice(o),e.sort(((t,e)=>t.hash<e.hash?1:-1)),{portals:e}}}Qs(lp,"ElevationPortalGraph"),Qs(ap,"ElevationPolygons");class up{constructor(t,e,r){this.outPositions=t,this.outNormals=e,this.outIndices=r,this.vertexLookup=new Map;}addVertex(t,e,r){let n=t[2];null!=r&&(n*=r);const i=`${t[0]},${t[1]},${t[2]},${e[0]},${e[1]},${e[2]}`,s=this.vertexLookup.get(i);if(null!=s)return s;const o=this.outPositions.length;this.vertexLookup.set(i,o);const a=Math.trunc(16384*e[0]),l=Math.trunc(16384*e[1]),u=Math.trunc(16384*e[2]);return this.outPositions.emplaceBack(t[0],t[1],n),this.outNormals.emplaceBack(a,l,u),o}addTriangle(t,e,r){this.outIndices.emplaceBack(t,e,r);}addTriangles(t,e,r){if(0===t.length)return;const n=1===r.length,i=_(),s=_();for(let o=0;o<t.length;o+=3){const a=e[t[o+0]],l=e[t[o+1]],u=e[t[o+2]],c=n?r[0]:r[t[o+1]],h=n?r[0]:r[t[o+2]];S(i,a.x,a.y,n?r[0]:r[t[o+0]]);const p=this.addVertex(i,s);S(i,l.x,l.y,c);const d=this.addVertex(i,s);S(i,u.x,u.y,h);const f=this.addVertex(i,s);this.outIndices.emplaceBack(p,d,f);}}addQuad(t,e,r,n,i,s){const o=this.addVertex(t,i,s),a=this.addVertex(e,i,s),l=this.addVertex(r,i,s),u=this.addVertex(n,i,s);this.addTriangle(o,a,l),this.addTriangle(l,u,o);}getVertexCount(){return this.outPositions.length}clearVertexLookup(){this.vertexLookup.clear();}}class cp{constructor(t,e,r,n){this.unevaluatedPortals=new lp,this.portalPolygons=new ap,this.bridgeFeatureSections=[],this.tunnelFeatureSections=[],this.vertexHashLookup=new Map,this.unevalVertices=[],this.unevalHeights=[],this.unevalTriangles=[],this.unevalTunnelTriangles=[],this.unevalEdges=[],this.vertexPositions=new ga,this.vertexNormals=new xa,this.indexArray=new Fa,this.tileToMeters=vu(t),this.bridgeProgramConfigurations=new Ul(e,{zoom:r,lut:n},(t=>"fill-tunnel-structure-color"!==t)),this.tunnelProgramConfigurations=new Ul(e,{zoom:r,lut:n},(t=>"fill-bridge-guard-rail-color"!==t));}addVertices(t,e){const r=this.unevalVertices.length;for(let r=0;r<t.length;r++)this.unevalVertices.push(t[r]),this.unevalHeights.push(e[r]);return r}addTriangles(t,e,r){const n=r?this.unevalTunnelTriangles:this.unevalTriangles;for(const r of t)n.push(r+e);}addRenderableRing(t,e,r,n,i,s){const o=[new It(i.min.x,i.min.y),new It(i.max.x,i.min.y),new It(i.max.x,i.max.y),new It(i.min.x,i.max.y)];for(let a=0;a<r-1;a++){const r=e+a,l=r+1,u=this.unevalVertices[r],c=this.unevalVertices[l];if(!(u.x>=i.min.x&&u.x<=i.max.x&&u.y>=i.min.y&&u.y<=i.max.y||c.x>=i.min.x&&c.x<=i.max.x&&c.y>=i.min.y&&c.y<=i.max.y||gc(u,c,o)))continue;if(this.isOnBorder(u.x,c.x)||this.isOnBorder(u.y,c.y))continue;const h=cp.computeEdgeHash(this.unevalVertices[r],this.unevalVertices[l]);let p,d=this.vertexHashLookup.get(cp.computePosHash(u));null!=d?p=d.next:(d=this.vertexHashLookup.get(cp.computePosHash(c)),p=null!=d?d.prev:h),this.unevalEdges.push({polygonIdx:t,a:r,b:l,hash:h,portalHash:p,isTunnel:n,type:"unevaluated",featureInfo:s});}}addPortalCandidates(t,e,r,n,i){if(0===e.length)return;this.portalPolygons.add(t,{geometry:e,zLevel:i});const s=e[0];this.vertexHashLookup.clear();let o=cp.computeEdgeHash(s[s.length-2],s[s.length-1]);for(let e=0;e<s.length-1;e++){const i=s[e+0],a=s[e+1],l=ct(a.x-i.x,a.y-i.y),u=mt(l);if(0===u)continue;let c="unevaluated";const h=n.pointElevation(i),p=n.pointElevation(a);Math.abs(h)<.01&&Math.abs(p)<.01?c="entrance":(this.isOnBorder(i.x,a.x)||this.isOnBorder(i.y,a.y))&&(c="border");const d=cp.computeEdgeHash(i,a);this.unevaluatedPortals.portals.push({connection:{a:t,b:void 0},va:i,vb:a,vab:l,length:u,hash:d,isTunnel:r,type:c});const f=cp.computePosHash(i);this.vertexHashLookup.set(f,{prev:o,next:d}),o=d;}}construct(t){if(0===this.unevalVertices.length)return;const e=()=>({vertexOffset:0,primitiveOffset:this.indexArray.length}),r=t=>{t.primitiveLength=this.indexArray.length-t.primitiveOffset;},n=new up(this.vertexPositions,this.vertexNormals,this.indexArray);this.prepareEdges(t.portals,this.unevalEdges);const i=e(),s=e(),o=e(),a=(t,e)=>{t.sort(((t,r)=>t.type===e&&r.type!==e?-1:t.type!==e&&r.type===e?1:0));const r=t.findIndex((t=>t.type!==e));return r>=0?r:t.length};let l=0;this.unevalEdges.length>0&&(l=a(this.unevalEdges,"none"),this.constructBridgeStructures(n,this.unevalVertices,this.unevalHeights,this.unevalEdges,{min:0,max:l},this.tileToMeters)),r(o);const u=e(),c=e();if(this.unevalEdges.length>0){const t=this.unevalEdges.splice(l),e=a(t,"tunnel")+l;this.unevalEdges.push(...t),this.constructTunnelStructures(n,this.unevalVertices,this.unevalHeights,this.unevalEdges,{min:0,max:l},{min:l,max:e});}r(u),n.addTriangles(this.unevalTriangles,this.unevalVertices,this.unevalHeights),r(c),n.addTriangles(this.unevalTunnelTriangles,this.unevalVertices,this.unevalHeights),r(s),n.addTriangles(this.unevalTunnelTriangles,this.unevalVertices,[-.1]),r(i),this.maskSegments=hl.simpleSegment(0,c.primitiveOffset,0,c.primitiveLength),this.depthSegments=hl.simpleSegment(0,s.primitiveOffset,0,s.primitiveLength),this.renderableBridgeSegments=hl.simpleSegment(0,o.primitiveOffset,0,o.primitiveLength),this.renderableTunnelSegments=hl.simpleSegment(0,u.primitiveOffset,0,u.primitiveLength),this.shadowCasterSegments=hl.simpleSegment(0,i.primitiveOffset,0,i.primitiveLength);}update(t,e,r,n,i,s,o,a){this.bridgeProgramConfigurations.updatePaintArrays(t,e,i,r,n,s,o,a),this.tunnelProgramConfigurations.updatePaintArrays(t,e,i,r,n,s,o,a);}upload(t){this.vertexBuffer||0===this.vertexPositions.length||0===this.vertexNormals.length||0===this.indexArray.length||(this.vertexBuffer=t.createVertexBuffer(this.vertexPositions,kh.members),this.vertexBufferNormal=t.createVertexBuffer(this.vertexNormals,Bh.members),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.bridgeProgramConfigurations.upload(t),this.tunnelProgramConfigurations.upload(t));}destroy(){this.vertexBuffer&&(this.vertexBuffer.destroy(),this.vertexBufferNormal.destroy(),this.indexBuffer.destroy()),this.maskSegments&&(this.maskSegments.destroy(),this.depthSegments.destroy(),this.renderableBridgeSegments.destroy(),this.renderableTunnelSegments.destroy(),this.shadowCasterSegments.destroy()),this.bridgeProgramConfigurations.destroy(),this.tunnelProgramConfigurations.destroy();}populatePaintArrays(t,e,r,n,i){const s=(s,o)=>{for(let a=0;a<o.length-1;a++){const l=o[a].featureIndex,u=o[a+1].vertexStart,c=t.feature(l);s.populatePaintArrays(u,c,l,{},r,e,n,void 0,i);}};s(this.bridgeProgramConfigurations,this.bridgeFeatureSections),s(this.tunnelProgramConfigurations,this.tunnelFeatureSections);}computeVertexConnections(t,e,r,n,i){const s=new Map;for(let o=n;o<i;o++){const n=r[o],i=n.a,a=n.b,l=cp.computePosHash(t[i]),u=cp.computePosHash(t[a]);let c=s.get(l);c||(c={},s.set(l,c));let h=s.get(u);h||(h={},s.set(u,h)),e[i]<=0&&e[a]<=0||(c.to=a,h.from=i);}return s}isTerminalVertex(t,e){const r=cp.computePosHash(this.unevalVertices[t]),n=e.get(r);return !n||!n.from||!n.to}constructBridgeStructures(t,e,r,n,i,s){t.clearVertexLookup();const o=this.computeVertexConnections(e,r,n,i.min,i.max),a=1/s,l=.5*a,u=(t,n)=>S(t,e[n].x,e[n].y,r[n]*a),c=_(),h=_(),p=_(),d=_(),f=_(),m=(t,r)=>{const n=o.get(cp.computePosHash(e[r])),i=n.from,s=n.to;if(!i||!s)return;u(c,i),u(h,r),u(p,s),q(d),H(c,h)||(X(f,h,c),L(d,f)),H(p,h)||(X(f,p,h),P(d,d,L(f,f)));const a=W(d);return a>0?E(t,d,1/a):void 0};let y=Number.POSITIVE_INFINITY;this.sortSubarray(n,i.min,i.max,((t,e)=>t.featureInfo.featureIndex-e.featureInfo.featureIndex));const g=_(),x=_(),v=_(),b=_(),w=_(),A=_(),I=_(),M=_(),k=_(),B=[_(),_(),_(),_()],z=[_(),_(),_(),_()],T=[{coord:new It(0,0),height:0},{coord:new It(0,0),height:0}],V=(t,e)=>t>e;for(let u=i.min;u<i.max;u++){const i=n[u];if(!i.featureInfo.guardRailEnabled)continue;if(!this.prepareEdgePoints(T,e,r,i,V))continue;const[c,h]=T;if(S(g,c.coord.x,c.coord.y,a*c.height),S(x,h.coord.x,h.coord.y,a*h.height),H(g,x))continue;X(v,x,g),L(v,v);const p=m(M,i.a)||v,d=m(k,i.b)||v;S(b,p[1],-p[0],0),L(b,b),S(w,d[1],-d[0],0),L(w,w),U(M,b,p),L(A,M),U(M,w,d),L(I,M),P(B[0],g,E(M,X(M,b,A),l)),P(B[1],g,E(M,P(M,b,A),l)),P(B[2],g,E(M,A,l)),B[3]=g,P(z[0],x,E(M,X(M,w,I),l)),P(z[1],x,E(M,P(M,w,I),l)),P(z[2],x,E(M,I,l)),z[3]=x,y=this.addFeatureSection(i.featureInfo.featureIndex,y,this.bridgeFeatureSections,t);const f=t.addVertex(B[0],b,s),_=t.addVertex(B[1],b,s),F=t.addVertex(z[0],w,s),C=t.addVertex(z[1],w,s);t.addTriangle(f,_,F),t.addTriangle(_,C,F);const D=t.addVertex(B[1],A,s),O=t.addVertex(B[2],A,s),N=t.addVertex(z[1],I,s),j=t.addVertex(z[2],I,s);t.addTriangle(D,O,N),t.addTriangle(O,j,N),R(b,b),R(w,w);const $=t.addVertex(B[2],b,s),G=t.addVertex(B[3],b,s),q=t.addVertex(z[2],w,s),Z=t.addVertex(z[3],w,s);t.addTriangle($,G,q),t.addTriangle(G,Z,q);const W=this.isTerminalVertex(i.a,o),Y=this.isTerminalVertex(i.b,o);c.height<.01&&W&&t.addQuad(B[3],B[2],B[1],B[0],R(p,p),s),h.height<.01&&Y&&t.addQuad(z[0],z[1],z[2],z[3],d,s);}this.bridgeFeatureSections.push({featureIndex:Number.POSITIVE_INFINITY,vertexStart:t.getVertexCount()});}constructTunnelStructures(t,e,r,n,i,s){t.clearVertexLookup();let o=Number.POSITIVE_INFINITY;const a=(t,e)=>t.featureInfo.featureIndex-e.featureInfo.featureIndex;this.sortSubarray(n,i.min,i.max,a),this.sortSubarray(n,s.min,s.max,a);const l=t=>L(t,t),u=[{coord:new It(0,0),height:0},{coord:new It(0,0),height:0}],c=(t,e)=>t<e,h=_(),p=_(),d=_(),f=_(),m=_();for(let s=i.min;s<i.max;s++){if(!this.prepareEdgePoints(u,e,r,n[s],c))continue;const[i,a]=u,y=l(S(m,-(a.coord.y-i.coord.y),a.coord.x-i.coord.x,0));o=this.addFeatureSection(n[s].featureInfo.featureIndex,o,this.tunnelFeatureSections,t),t.addQuad(S(h,i.coord.x,i.coord.y,i.height),S(p,a.coord.x,a.coord.y,a.height),S(d,a.coord.x,a.coord.y,n[s].isTunnel?-.1:0),S(f,i.coord.x,i.coord.y,n[s].isTunnel?-.1:0),y);}for(let i=s.min;i<s.max;i++){const s=n[i];s.isTunnel&&([s.a,s.b]=[s.b,s.a]);const a=e[s.a],u=e[s.b],c=l(S(m,-(u.y-a.y),u.x-a.x,0));o=this.addFeatureSection(s.featureInfo.featureIndex,o,this.tunnelFeatureSections,t),t.addQuad(S(h,u.x,u.y,0),S(p,a.x,a.y,0),S(d,a.x,a.y,r[s.a]+4),S(f,u.x,u.y,r[s.b]+4),c),t.addQuad(S(h,a.x,a.y,0),S(p,u.x,u.y,0),S(d,u.x,u.y,r[s.b]+4),S(f,a.x,a.y,r[s.a]+4),c);}this.tunnelFeatureSections.push({featureIndex:Number.POSITIVE_INFINITY,vertexStart:t.getVertexCount()});}setElevatedPoint(t,e,r,n){t.coord.x=e,t.coord.y=r,t.height=n;}prepareEdgePoints(t,e,r,n,i){let s=e[n.a].x,o=e[n.a].y,a=e[n.b].x,l=e[n.b].y,u=r[n.a],c=r[n.b];const h=i(u,0),p=i(c,0);if(h&&p)return this.setElevatedPoint(t[0],s,o,u),this.setElevatedPoint(t[1],a,l,c),!0;if(!h&&!p)return !1;if(h){if(!p){const t=c/(c-u);a=pr(a,s,t),l=pr(l,o,t),c=pr(c,u,t);}}else {const t=u/(u-c);s=pr(s,a,t),o=pr(o,l,t),u=pr(u,c,t);}return this.setElevatedPoint(t[0],s,o,u),this.setElevatedPoint(t[1],a,l,c),!0}prepareEdges(t,e){if(0===e.length)return;e.sort(((t,e)=>t.hash===e.hash?e.polygonIdx-t.polygonIdx:e.hash>t.hash?1:-1));let r=0,n=0,i=0,s=e[r].polygonIdx;do{n++,(n===e.length||e[r].hash!==e[n].hash)&&((1==n-r||e[n-1].polygonIdx!==s)&&(i<r&&(e[i]=e[r],e[r]=null),e[i].type="none",i++),r=n,r!==e.length&&(s=e[r].polygonIdx));}while(r!==e.length);if(e.splice(i),0!==e.length&&0!==t.length){e.sort(((t,e)=>t.portalHash<e.portalHash?1:-1));let r=0,n=0;for(;r!==e.length&&n!==t.length;){const i=e[r],s=t[n];i.portalHash>s.hash?r++:s.hash>i.portalHash?n++:(i.type=s.type,r++);}}}isOnBorder(t,e){return t<=0&&e<=0||t>=Un&&e>=Un}addFeatureSection(t,e,r,n){return t!==e&&(e=t,r.push({featureIndex:t,vertexStart:n.getVertexCount()}),n.clearVertexLookup()),e}sortSubarray(t,e,r,n){const i=t.slice(e,r);i.sort(n),t.splice(e,i.length,...i);}static computeEdgeHash(t,e){return (t.y===e.y&&t.x>e.x||t.y>e.y)&&([t,e]=[e,t]),BigInt(cp.computePosHash(t))<<32n|BigInt(cp.computePosHash(e))}static computePosHash(t){return ((65535&t.x)<<16|65535&t.y)>>>0}}var hp,pp={exports:{}},dp=(hp||(hp=1,function(t){function e(t,e){return t>e?1:t<e?-1:0}var r=function(t,r){void 0===t&&(t=e),void 0===r&&(r=!1),this._compare=t,this._root=null,this._size=0,this._noDuplicates=!!r;},n={size:{configurable:!0}};function i(t,e,r,n,s){var o=s-n;if(o>0){var a=n+Math.floor(o/2),l={key:e[a],data:r[a],parent:t};return l.left=i(l,e,r,n,a),l.right=i(l,e,r,a+1,s),l}return null}function s(t,e,r,n,i){if(!(r>=n)){for(var o=t[r+n>>1],a=r-1,l=n+1;;){do{a++;}while(i(t[a],o)<0);do{l--;}while(i(t[l],o)>0);if(a>=l)break;var u=t[a];t[a]=t[l],t[l]=u,u=e[a],e[a]=e[l],e[l]=u;}s(t,e,r,l,i),s(t,e,l+1,n,i);}}r.prototype.rotateLeft=function(t){var e=t.right;e&&(t.right=e.left,e.left&&(e.left.parent=t),e.parent=t.parent),t.parent?t===t.parent.left?t.parent.left=e:t.parent.right=e:this._root=e,e&&(e.left=t),t.parent=e;},r.prototype.rotateRight=function(t){var e=t.left;e&&(t.left=e.right,e.right&&(e.right.parent=t),e.parent=t.parent),t.parent?t===t.parent.left?t.parent.left=e:t.parent.right=e:this._root=e,e&&(e.right=t),t.parent=e;},r.prototype._splay=function(t){for(;t.parent;){var e=t.parent;e.parent?e.left===t&&e.parent.left===e?(this.rotateRight(e.parent),this.rotateRight(e)):e.right===t&&e.parent.right===e?(this.rotateLeft(e.parent),this.rotateLeft(e)):e.left===t&&e.parent.right===e?(this.rotateRight(e),this.rotateLeft(e)):(this.rotateLeft(e),this.rotateRight(e)):e.left===t?this.rotateRight(e):this.rotateLeft(e);}},r.prototype.splay=function(t){for(var e,r,n,i,s;t.parent;)(r=(e=t.parent).parent)&&r.parent?((n=r.parent).left===r?n.left=t:n.right=t,t.parent=n):(t.parent=null,this._root=t),i=t.left,s=t.right,t===e.left?(r&&(r.left===e?(e.right?(r.left=e.right,r.left.parent=r):r.left=null,e.right=r,r.parent=e):(i?(r.right=i,i.parent=r):r.right=null,t.left=r,r.parent=t)),s?(e.left=s,s.parent=e):e.left=null,t.right=e,e.parent=t):(r&&(r.right===e?(e.left?(r.right=e.left,r.right.parent=r):r.right=null,e.left=r,r.parent=e):(s?(r.left=s,s.parent=r):r.left=null,t.right=r,r.parent=t)),i?(e.right=i,i.parent=e):e.right=null,t.left=e,e.parent=t);},r.prototype.replace=function(t,e){t.parent?t===t.parent.left?t.parent.left=e:t.parent.right=e:this._root=e,e&&(e.parent=t.parent);},r.prototype.minNode=function(t){if(void 0===t&&(t=this._root),t)for(;t.left;)t=t.left;return t},r.prototype.maxNode=function(t){if(void 0===t&&(t=this._root),t)for(;t.right;)t=t.right;return t},r.prototype.insert=function(t,e){var r=this._root,n=null,i=this._compare;if(this._noDuplicates)for(;r;){if(n=r,0===i(r.key,t))return;r=i(r.key,t)<0?r.right:r.left;}else for(;r;)n=r,r=i(r.key,t)<0?r.right:r.left;return r={key:t,data:e,left:null,right:null,parent:n},n?i(n.key,r.key)<0?n.right=r:n.left=r:this._root=r,this.splay(r),this._size++,r},r.prototype.find=function(t){for(var e=this._root,r=this._compare;e;){var n=r(e.key,t);if(n<0)e=e.right;else {if(!(n>0))return e;e=e.left;}}return null},r.prototype.contains=function(t){for(var e=this._root,r=this._compare;e;){var n=r(t,e.key);if(0===n)return !0;e=n<0?e.left:e.right;}return !1},r.prototype.remove=function(t){var e=this.find(t);if(!e)return !1;if(this.splay(e),e.left)if(e.right){var r=this.minNode(e.right);r.parent!==e&&(this.replace(r,r.right),r.right=e.right,r.right.parent=r),this.replace(e,r),r.left=e.left,r.left.parent=r;}else this.replace(e,e.left);else this.replace(e,e.right);return this._size--,!0},r.prototype.removeNode=function(t){if(!t)return !1;if(this.splay(t),t.left)if(t.right){var e=this.minNode(t.right);e.parent!==t&&(this.replace(e,e.right),e.right=t.right,e.right.parent=e),this.replace(t,e),e.left=t.left,e.left.parent=e;}else this.replace(t,t.left);else this.replace(t,t.right);return this._size--,!0},r.prototype.erase=function(t){var e=this.find(t);if(e){this.splay(e);var r=e.left,n=e.right,i=null;r&&(r.parent=null,i=this.maxNode(r),this.splay(i),this._root=i),n&&(r?i.right=n:this._root=n,n.parent=i),this._size--;}},r.prototype.pop=function(){var t=this._root,e=null;if(t){for(;t.left;)t=t.left;e={key:t.key,data:t.data},this.remove(t.key);}return e},r.prototype.next=function(t){var e=t;if(e)if(e.right)for(e=e.right;e&&e.left;)e=e.left;else for(e=t.parent;e&&e.right===t;)t=e,e=e.parent;return e},r.prototype.prev=function(t){var e=t;if(e)if(e.left)for(e=e.left;e&&e.right;)e=e.right;else for(e=t.parent;e&&e.left===t;)t=e,e=e.parent;return e},r.prototype.forEach=function(t){for(var e=this._root,r=[],n=!1,i=0;!n;)e?(r.push(e),e=e.left):r.length>0?(t(e=r.pop(),i++),e=e.right):n=!0;return this},r.prototype.range=function(t,e,r,n){for(var i=[],s=this._compare,o=this._root;0!==i.length||o;)if(o)i.push(o),o=o.left;else {if(s((o=i.pop()).key,e)>0)break;if(s(o.key,t)>=0&&r.call(n,o))return this;o=o.right;}return this},r.prototype.keys=function(){for(var t=this._root,e=[],r=[],n=!1;!n;)t?(e.push(t),t=t.left):e.length>0?(t=e.pop(),r.push(t.key),t=t.right):n=!0;return r},r.prototype.values=function(){for(var t=this._root,e=[],r=[],n=!1;!n;)t?(e.push(t),t=t.left):e.length>0?(t=e.pop(),r.push(t.data),t=t.right):n=!0;return r},r.prototype.at=function(t){for(var e=this._root,r=[],n=!1,i=0;!n;)if(e)r.push(e),e=e.left;else if(r.length>0){if(e=r.pop(),i===t)return e;i++,e=e.right;}else n=!0;return null},r.prototype.load=function(t,e,r){if(void 0===t&&(t=[]),void 0===e&&(e=[]),void 0===r&&(r=!1),0!==this._size)throw new Error("bulk-load: tree is not empty");var n=t.length;return r&&s(t,e,0,n-1,this._compare),this._root=i(null,t,e,0,n),this._size=n,this},r.prototype.min=function(){var t=this.minNode(this._root);return t?t.key:null},r.prototype.max=function(){var t=this.maxNode(this._root);return t?t.key:null},r.prototype.isEmpty=function(){return null===this._root},n.size.get=function(){return this._size},r.createTree=function(t,e,n,i,s){return new r(n,s).load(t,e,i)},Object.defineProperties(r.prototype,n);var o=0,a=1,l=2,u=3,c=0,h=1,p=2,d=3;function f(t,e,r){null===e?(t.inOut=!1,t.otherInOut=!0):(t.isSubject===e.isSubject?(t.inOut=!e.inOut,t.otherInOut=e.otherInOut):(t.inOut=!e.otherInOut,t.otherInOut=e.isVertical()?!e.inOut:e.inOut),e&&(t.prevInResult=!m(e,r)||e.isVertical()?e.prevInResult:e));var n=m(t,r);t.resultTransition=n?function(t,e){var r,n=!t.inOut,i=!t.otherInOut;switch(e){case c:r=n&&i;break;case h:r=n||i;break;case d:r=n^i;break;case p:r=t.isSubject?n&&!i:i&&!n;}return r?1:-1}(t,r):0;}function m(t,e){switch(t.type){case o:switch(e){case c:return !t.otherInOut;case h:return t.otherInOut;case p:return t.isSubject&&t.otherInOut||!t.isSubject&&!t.otherInOut;case d:return !0}break;case l:return e===c||e===h;case u:return e===p;case a:return !1}return !1}var y=function(t,e,r,n,i){this.left=e,this.point=t,this.otherEvent=r,this.isSubject=n,this.type=i||o,this.inOut=!1,this.otherInOut=!1,this.prevInResult=null,this.resultTransition=0,this.otherPos=-1,this.outputContourId=-1,this.isExteriorRing=!0;},g={inResult:{configurable:!0}};function x(t,e){return t[0]===e[0]&&t[1]===e[1]}y.prototype.isBelow=function(t){var e=this.point,r=this.otherEvent.point;return this.left?(e[0]-t[0])*(r[1]-t[1])-(r[0]-t[0])*(e[1]-t[1])>0:(r[0]-t[0])*(e[1]-t[1])-(e[0]-t[0])*(r[1]-t[1])>0},y.prototype.isAbove=function(t){return !this.isBelow(t)},y.prototype.isVertical=function(){return this.point[0]===this.otherEvent.point[0]},g.inResult.get=function(){return 0!==this.resultTransition},y.prototype.clone=function(){var t=new y(this.point,this.left,this.otherEvent,this.isSubject,this.type);return t.contourId=this.contourId,t.resultTransition=this.resultTransition,t.prevInResult=this.prevInResult,t.isExteriorRing=this.isExteriorRing,t.inOut=this.inOut,t.otherInOut=this.otherInOut,t},Object.defineProperties(y.prototype,g);var v=11102230246251565e-32,b=134217729,w=(3+8*v)*v;function _(t,e,r,n,i){var s,o,a,l,u=e[0],c=n[0],h=0,p=0;c>u==c>-u?(s=u,u=e[++h]):(s=c,c=n[++p]);var d=0;if(h<t&&p<r)for(c>u==c>-u?(a=s-((o=u+s)-u),u=e[++h]):(a=s-((o=c+s)-c),c=n[++p]),s=o,0!==a&&(i[d++]=a);h<t&&p<r;)c>u==c>-u?(a=s-((o=s+u)-(l=o-s))+(u-l),u=e[++h]):(a=s-((o=s+c)-(l=o-s))+(c-l),c=n[++p]),s=o,0!==a&&(i[d++]=a);for(;h<t;)a=s-((o=s+u)-(l=o-s))+(u-l),u=e[++h],s=o,0!==a&&(i[d++]=a);for(;p<r;)a=s-((o=s+c)-(l=o-s))+(c-l),c=n[++p],s=o,0!==a&&(i[d++]=a);return 0===s&&0!==d||(i[d++]=s),d}function A(t){return new Float64Array(t)}var I=33306690738754716e-32,M=22204460492503146e-32,S=11093356479670487e-47,P=A(4),k=A(8),B=A(12),z=A(16),T=A(4);function E(t,e,r){var n=function(t,e,r,n,i,s){var o=(e-s)*(r-i),a=(t-i)*(n-s),l=o-a;if(0===o||0===a||o>0!=a>0)return l;var u=Math.abs(o+a);return Math.abs(l)>=I*u?l:-function(t,e,r,n,i,s,o){var a,l,u,c,h,p,d,f,m,y,g,x,v,A,I,E,V,F,C=t-i,D=r-i,R=e-s,L=n-s;P[0]=(I=(f=C-(d=(p=b*C)-(p-C)))*(y=L-(m=(p=b*L)-(p-L)))-((A=C*L)-d*m-f*m-d*y))-((g=I-(V=(f=R-(d=(p=b*R)-(p-R)))*(y=D-(m=(p=b*D)-(p-D)))-((E=R*D)-d*m-f*m-d*y)))+(h=I-g))+(h-V),P[1]=(v=A-((x=A+g)-(h=x-A))+(g-h))-((g=v-E)+(h=v-g))+(h-E),P[2]=x-((F=x+g)-(h=F-x))+(g-h),P[3]=F;var O=function(t,e){for(var r=e[0],n=1;n<4;n++)r+=e[n];return r}(0,P),U=M*o;if(O>=U||-O>=U)return O;if(a=t-(C+(h=t-C))+(h-i),u=r-(D+(h=r-D))+(h-i),l=e-(R+(h=e-R))+(h-s),c=n-(L+(h=n-L))+(h-s),0===a&&0===l&&0===u&&0===c)return O;if(U=S*o+w*Math.abs(O),(O+=C*c+L*a-(R*u+D*l))>=U||-O>=U)return O;T[0]=(I=(f=a-(d=(p=b*a)-(p-a)))*(y=L-(m=(p=b*L)-(p-L)))-((A=a*L)-d*m-f*m-d*y))-((g=I-(V=(f=l-(d=(p=b*l)-(p-l)))*(y=D-(m=(p=b*D)-(p-D)))-((E=l*D)-d*m-f*m-d*y)))+(h=I-g))+(h-V),T[1]=(v=A-((x=A+g)-(h=x-A))+(g-h))-((g=v-E)+(h=v-g))+(h-E),T[2]=x-((F=x+g)-(h=F-x))+(g-h),T[3]=F;var N=_(4,P,4,T,k);T[0]=(I=(f=C-(d=(p=b*C)-(p-C)))*(y=c-(m=(p=b*c)-(p-c)))-((A=C*c)-d*m-f*m-d*y))-((g=I-(V=(f=R-(d=(p=b*R)-(p-R)))*(y=u-(m=(p=b*u)-(p-u)))-((E=R*u)-d*m-f*m-d*y)))+(h=I-g))+(h-V),T[1]=(v=A-((x=A+g)-(h=x-A))+(g-h))-((g=v-E)+(h=v-g))+(h-E),T[2]=x-((F=x+g)-(h=F-x))+(g-h),T[3]=F;var j=_(N,k,4,T,B);T[0]=(I=(f=a-(d=(p=b*a)-(p-a)))*(y=c-(m=(p=b*c)-(p-c)))-((A=a*c)-d*m-f*m-d*y))-((g=I-(V=(f=l-(d=(p=b*l)-(p-l)))*(y=u-(m=(p=b*u)-(p-u)))-((E=l*u)-d*m-f*m-d*y)))+(h=I-g))+(h-V),T[1]=(v=A-((x=A+g)-(h=x-A))+(g-h))-((g=v-E)+(h=v-g))+(h-E),T[2]=x-((F=x+g)-(h=F-x))+(g-h),T[3]=F;var $=_(j,B,4,T,z);return z[$-1]}(t,e,r,n,i,s,u)}(t[0],t[1],e[0],e[1],r[0],r[1]);return n>0?-1:n<0?1:0}function V(t,e){var r=t.point,n=e.point;return r[0]>n[0]?1:r[0]<n[0]?-1:r[1]!==n[1]?r[1]>n[1]?1:-1:function(t,e,r,n){return t.left!==e.left?t.left?1:-1:0!==E(r,t.otherEvent.point,e.otherEvent.point)?t.isBelow(e.otherEvent.point)?-1:1:!t.isSubject&&e.isSubject?1:-1}(t,e,r)}function F(t,e,r){var n=new y(e,!1,t,t.isSubject),i=new y(e,!0,t.otherEvent,t.isSubject);return x(t.point,t.otherEvent.point)&&console.warn("what is that, a collapsed segment?",t),n.contourId=i.contourId=t.contourId,V(i,t.otherEvent)>0&&(t.otherEvent.left=!0,i.left=!1),t.otherEvent.otherEvent=i,t.otherEvent=n,r.push(i),r.push(n),r}function C(t,e){return t[0]*e[1]-t[1]*e[0]}function D(t,e){return t[0]*e[0]+t[1]*e[1]}function R(t,e,r){var n=function(t,e,r,n,i){var s=[e[0]-t[0],e[1]-t[1]],o=[n[0]-r[0],n[1]-r[1]];function a(t,e,r){return [t[0]+e*r[0],t[1]+e*r[1]]}var l=[r[0]-t[0],r[1]-t[1]],u=C(s,o),c=u*u,h=D(s,s);if(c>0){var p=C(l,o)/u;if(p<0||p>1)return null;var d=C(l,s)/u;return d<0||d>1?null:0===p||1===p?[a(t,p,s)]:0===d||1===d?[a(r,d,o)]:[a(t,p,s)]}if((c=(u=C(l,s))*u)>0)return null;var f=D(s,l)/h,m=f+D(s,o)/h,y=Math.min(f,m),g=Math.max(f,m);return y<=1&&g>=0?1===y?[a(t,y>0?y:0,s)]:0===g?[a(t,g<1?g:1,s)]:[a(t,y>0?y:0,s),a(t,g<1?g:1,s)]:null}(t.point,t.otherEvent.point,e.point,e.otherEvent.point),i=n?n.length:0;if(0===i)return 0;if(1===i&&(x(t.point,e.point)||x(t.otherEvent.point,e.otherEvent.point)))return 0;if(2===i&&t.isSubject===e.isSubject)return 0;if(1===i)return x(t.point,n[0])||x(t.otherEvent.point,n[0])||F(t,n[0],r),x(e.point,n[0])||x(e.otherEvent.point,n[0])||F(e,n[0],r),1;var s=[],o=!1,c=!1;return x(t.point,e.point)?o=!0:1===V(t,e)?s.push(e,t):s.push(t,e),x(t.otherEvent.point,e.otherEvent.point)?c=!0:1===V(t.otherEvent,e.otherEvent)?s.push(e.otherEvent,t.otherEvent):s.push(t.otherEvent,e.otherEvent),o&&c||o?(e.type=a,t.type=e.inOut===t.inOut?l:u,o&&!c&&F(s[1].otherEvent,s[0].point,r),2):c?(F(s[0],s[1].point,r),3):s[0]!==s[3].otherEvent?(F(s[0],s[1].point,r),F(s[1],s[2].point,r),3):(F(s[0],s[1].point,r),F(s[3].otherEvent,s[2].point,r),3)}function L(t,e){if(t===e)return 0;if(0!==E(t.point,t.otherEvent.point,e.point)||0!==E(t.point,t.otherEvent.point,e.otherEvent.point))return x(t.point,e.point)?t.isBelow(e.otherEvent.point)?-1:1:t.point[0]===e.point[0]?t.point[1]<e.point[1]?-1:1:1===V(t,e)?e.isAbove(t.point)?-1:1:t.isBelow(e.point)?-1:1;if(t.isSubject!==e.isSubject)return t.isSubject?-1:1;var r=t.point,n=e.point;return r[0]===n[0]&&r[1]===n[1]?(r=t.otherEvent.point)[0]===(n=e.otherEvent.point)[0]&&r[1]===n[1]?0:t.contourId>e.contourId?1:-1:1===V(t,e)?1:-1}var O=function(){this.points=[],this.holeIds=[],this.holeOf=null,this.depth=null;};function U(t,e,r,n){var i,s=t+1,o=e[t].point,a=e.length;for(s<a&&(i=e[s].point);s<a&&i[0]===o[0]&&i[1]===o[1];){if(!r[s])return s;++s<a&&(i=e[s].point);}for(s=t-1;r[s]&&s>n;)s--;return s}O.prototype.isExterior=function(){return null==this.holeOf};var N=$,j=$;function $(t,e){if(!(this instanceof $))return new $(t,e);if(this.data=t||[],this.length=this.data.length,this.compare=e||G,this.length>0)for(var r=(this.length>>1)-1;r>=0;r--)this._down(r);}function G(t,e){return t<e?-1:t>e?1:0}$.prototype={push:function(t){this.data.push(t),this.length++,this._up(this.length-1);},pop:function(){if(0!==this.length){var t=this.data[0];return this.length--,this.length>0&&(this.data[0]=this.data[this.length],this._down(0)),this.data.pop(),t}},peek:function(){return this.data[0]},_up:function(t){for(var e=this.data,r=this.compare,n=e[t];t>0;){var i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i;}e[t]=n;},_down:function(t){for(var e=this.data,r=this.compare,n=this.length>>1,i=e[t];t<n;){var s=1+(t<<1),o=s+1,a=e[s];if(o<this.length&&r(e[o],a)<0&&(s=o,a=e[o]),r(a,i)>=0)break;e[t]=a,t=s;}e[t]=i;}},N.default=j;var q=Math.max,H=Math.min,X=0;function Z(t,e,r,n,i,s){var o,a,l,u,c,h;for(o=0,a=t.length-1;o<a;o++)if(u=t[o+1],c=new y(l=t[o],!1,void 0,e),h=new y(u,!1,c,e),c.otherEvent=h,l[0]!==u[0]||l[1]!==u[1]){c.contourId=h.contourId=r,s||(c.isExteriorRing=!1,h.isExteriorRing=!1),V(c,h)>0?h.left=!0:c.left=!0;var p=l[0],d=l[1];i[0]=H(i[0],p),i[1]=H(i[1],d),i[2]=q(i[2],p),i[3]=q(i[3],d),n.push(c),n.push(h);}}var W=[];function Y(t,e,n){"number"==typeof t[0][0][0]&&(t=[t]),"number"==typeof e[0][0][0]&&(e=[e]);var i=function(t,e,r){var n=null;return t.length*e.length==0&&(r===c?n=W:r===p?n=t:r!==h&&r!==d||(n=0===t.length?e:t)),n}(t,e,n);if(i)return i===W?null:i;var s=[1/0,1/0,-1/0,-1/0],o=[1/0,1/0,-1/0,-1/0],a=function(t,e,r,n,i){var s,o,a,l,u,c,h=new N(null,V);for(a=0,l=t.length;a<l;a++)for(u=0,c=(s=t[a]).length;u<c;u++)(o=0===u)&&X++,Z(s[u],!0,X,h,r,o);for(a=0,l=e.length;a<l;a++)for(u=0,c=(s=e[a]).length;u<c;u++)o=0===u,i===p&&(o=!1),o&&X++,Z(s[u],!1,X,h,n,o);return h}(t,e,s,o,n);if(i=function(t,e,r,n,i){var s=null;return (r[0]>n[2]||n[0]>r[2]||r[1]>n[3]||n[1]>r[3])&&(i===c?s=W:i===p?s=t:i!==h&&i!==d||(s=t.concat(e))),s}(t,e,s,o,n))return i===W?null:i;for(var l=function(t){var e,r,n=function(t){var e,r,n,i,s=[];for(r=0,n=t.length;r<n;r++)((e=t[r]).left&&e.inResult||!e.left&&e.otherEvent.inResult)&&s.push(e);for(var o=!1;!o;)for(o=!0,r=0,n=s.length;r<n;r++)r+1<n&&1===V(s[r],s[r+1])&&(i=s[r],s[r]=s[r+1],s[r+1]=i,o=!1);for(r=0,n=s.length;r<n;r++)(e=s[r]).otherPos=r;for(r=0,n=s.length;r<n;r++)(e=s[r]).left||(i=e.otherPos,e.otherPos=e.otherEvent.otherPos,e.otherEvent.otherPos=i);return s}(t),i={},s=[],o=function(){if(!i[e]){var t=s.length,r=function(t,e,r){var n=new O;if(null!=t.prevInResult){var i=t.prevInResult,s=i.outputContourId;if(i.resultTransition>0){var o=e[s];if(null!=o.holeOf){var a=o.holeOf;e[a].holeIds.push(r),n.holeOf=a,n.depth=e[s].depth;}else e[s].holeIds.push(r),n.holeOf=s,n.depth=e[s].depth+1;}else n.holeOf=null,n.depth=e[s].depth;}else n.holeOf=null,n.depth=0;return n}(n[e],s,t),o=function(e){i[e]=!0,e<n.length&&n[e]&&(n[e].outputContourId=t);},a=e,l=e;for(r.points.push(n[e].point);o(a),o(a=n[a].otherPos),r.points.push(n[a].point),!((a=U(a,n,i,l))==l||a>=n.length)&&n[a];);s.push(r);}};for(e=0,r=n.length;e<r;e++)o();return s}(function(t,e,n,i,s,o){for(var a,l,u,h=new r(L),d=[],m=Math.min(i[2],s[2]);0!==t.length;){var y=t.pop();if(d.push(y),o===c&&y.point[0]>m||o===p&&y.point[0]>i[2])break;if(y.left){l=a=h.insert(y),a=a!==(u=h.minNode())?h.prev(a):null,l=h.next(l);var g=a?a.key:null;if(f(y,g,o),l&&2===R(y,l.key,t)&&(f(y,g,o),f(l.key,y,o)),a&&2===R(a.key,y,t)){var x=a;f(g,(x=x!==u?h.prev(x):null)?x.key:null,o),f(y,g,o);}}else l=a=h.find(y=y.otherEvent),a&&l&&(a=a!==u?h.prev(a):null,l=h.next(l),h.remove(y),l&&a&&R(a.key,l.key,t));}return d}(a,0,0,s,o,n)),u=[],m=0;m<l.length;m++){var y=l[m];if(y.isExterior()){for(var g=[y.points],x=0;x<y.holeIds.length;x++)g.push(l[y.holeIds[x]].points);u.push(g);}}return u}var K={UNION:h,DIFFERENCE:p,INTERSECTION:c,XOR:d};t.diff=function(t,e){return Y(t,e,p)},t.intersection=function(t,e){return Y(t,e,c)},t.operations=K,t.union=function(t,e){return Y(t,e,h)},t.xor=function(t,e){return Y(t,e,d)},Object.defineProperty(t,"__esModule",{value:!0});}(pp.exports)),pp.exports);
/**
 * martinez v0.7.4
 * Martinez polygon clipping algorithm, does boolean operation on polygons (multipolygons, polygons with holes etc): intersection, union, difference, xor
 *
 * @author Alex Milevski <info@w8r.name>
 * @license MIT
 * @preserve
 */function fp(t,e,r,n){const i=[],s=0===n?(t,e,r,n,i,s)=>{t.push(new It(s,r+(s-e)/(n-e)*(i-r)));}:(t,e,r,n,i,s)=>{t.push(new It(e+(s-r)/(i-r)*(n-e),s));};for(const o of t){const t=[];for(const i of o){if(i.length<=2)continue;const o=[];for(let t=0;t<i.length-1;t++){const a=i[t].x,l=i[t].y,u=i[t+1].x,c=i[t+1].y,h=0===n?a:l,p=0===n?u:c;h<e?p>e&&s(o,a,l,u,c,e):h>r?p<r&&s(o,a,l,u,c,r):o.push(i[t]),p<e&&h>=e&&s(o,a,l,u,c,e),p>r&&h<=r&&s(o,a,l,u,c,r);}let a=i[i.length-1];const l=0===n?a.x:a.y;l>=e&&l<=r&&o.push(a),o.length&&(a=o[o.length-1],o[0].x===a.x&&o[0].y===a.y||o.push(o[0]),t.push(o));}t.length&&i.push(t);}return i}function mp(t,e){const r=gp(t),n=gp([e]),i=dp.intersection(r,n);return null==i?[]:xp(i)}function yp(t,e){const r=65536;let n=gp(t,r);const i=[];for(;e.valid();e.next()){const[t,n]=e.get(),s=t.x*r,o=t.y*r,a=n.x*r,l=n.y*r,u=a-s,c=l-o,h=Math.hypot(u,c);if(0===h)continue;const p=Math.trunc(c/h*3),d=-Math.trunc(u/h*3);i.push([[[s,o],[a,l],[a+p,l+d],[s+p,o+d],[s,o]]]);}return i.length>0&&(n=dp.diff(n,i)),xp(n,1/r)}function gp(t,e=1){return [t.map((t=>t.map((t=>[t.x*e,t.y*e]))))]}function xp(t,e=1){return t.map((t=>t.map(((t,r)=>{const n=t.map((t=>new It(t[0]*e,t[1]*e).round()));return r>0&&n.reverse(),n}))))}class vp{constructor(t,e){this.layoutVertexArray=new da,this.indexArray=new Fa,this.lineIndexArray=new Ba,this.triangleSegments=new hl,this.lineSegments=new hl,this.programConfigurations=new Ul(t.layers,{zoom:t.zoom,lut:t.lut}),this.uploaded=!1,e&&(this.elevatedLayoutVertexArray=new ya);}update(t,e,r,n,i,s,o,a){this.programConfigurations.updatePaintArrays(t,e,i,r,n,s,o,a);}isEmpty(){return 0===this.layoutVertexArray.length}needsUpload(){return this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Sh.members),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.lineIndexBuffer=t.createIndexBuffer(this.lineIndexArray),this.elevatedLayoutVertexArray&&this.elevatedLayoutVertexArray.length>0&&(this.elevatedLayoutVertexBuffer=t.createVertexBuffer(this.elevatedLayoutVertexArray,Ph.members))),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.elevatedLayoutVertexBuffer&&this.elevatedLayoutVertexBuffer.destroy(),this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.lineIndexBuffer.destroy(),this.programConfigurations.destroy(),this.triangleSegments.destroy(),this.lineSegments.destroy());}populatePaintArrays(t,e,r,n,i,s,o){this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,e,r,n,i,s,void 0,o);}}class bp{constructor(t){this.zoom=t.zoom,this.pixelRatio=t.pixelRatio,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.lut=t.lut,this.bufferData=new vp(t,!1),this.elevationBufferData=new vp(t,!0),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.projection=t.projection,this.elevationMode=this.layers[0].layout.get("fill-elevation-reference"),this.sourceLayerIndex=t.sourceLayerIndex,this.worldview=t.worldview,this.hasAppearances=null;}updateFootprints(t,e){}updateAppearances(t,e,r,n){}populate(t,e,r,n){this.hasPattern=sp("fill",this.layers,this.pixelRatio,e);const i=this.layers[0].layout.get("fill-sort-key"),s=[];for(const{feature:o,id:a,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=Bu(o,t);if(!this.layers[0]._featureFilter.filter(new Io(this.zoom,{worldview:this.worldview,activeFloors:e.activeFloors}),c,r))continue;const h=i?i.evaluate(c,{},r,e.availableImages):void 0,p={id:a,properties:o.properties,type:o.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:ku(o,r,n),patterns:{},sortKey:h};s.push(p);}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:o}=n;if(this.hasPattern){const t=op("fill",this.layers,n,this.zoom,this.pixelRatio,e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,{},e.availableImages,e.brightness,e.elevationFeatures);e.featureIndex.insert(t[s].feature,i,s,o,this.index);}}update(t,e,r,n,i,s,o){this.bufferData.update(t,e,r,n,i,s,o,this.worldview),this.elevationBufferData.update(t,e,r,n,i,s,o,this.worldview),this.elevatedStructures&&this.elevatedStructures.update(t,e,r,n,i,s,o,this.worldview);}addFeatures(t,e,r,n,i,s){for(const i of this.patternFeatures)this.addFeature(i,i.geometry,i.index,e,r,n,s,t.elevationFeatures);}isEmpty(){return this.bufferData.isEmpty()&&this.elevationBufferData.isEmpty()}uploadPending(){return !this.uploaded||this.bufferData.needsUpload()||this.elevationBufferData.needsUpload()}upload(t){this.bufferData.upload(t),this.elevationBufferData.upload(t),this.elevatedStructures&&this.elevatedStructures.upload(t);}destroy(){this.bufferData.destroy(),this.elevationBufferData.destroy(),this.elevatedStructures&&this.elevatedStructures.destroy();}addFeature(t,e,r,n,i,s=[],o,a){const l=rp(e,500);"none"!==this.elevationMode?this.addElevatedRoadFeature(t,l,n,r,a):this.addGeometry(l,this.bufferData),this.bufferData.populatePaintArrays(t,r,i,s,n,o,this.worldview),this.elevationBufferData.populatePaintArrays(t,r,i,s,n,o,this.worldview);}getUnevaluatedPortalGraph(){return this.elevatedStructures?this.elevatedStructures.unevaluatedPortals:void 0}getElevationPolygons(){return this.elevatedStructures?this.elevatedStructures.portalPolygons:void 0}setEvaluatedPortalGraph(t,e,r,n,i){this.elevatedStructures&&(this.elevatedStructures.construct(t),this.elevatedStructures.populatePaintArrays(e,r,n,i,this.worldview));}addElevatedRoadFeature(t,e,r,n,i){const s=new Array,o=ec.getElevationFeature(t,i);if(!o)return void this.addGeometry(e,this.bufferData);{const t=this.clipPolygonsToTile(e,1);t.length>0&&s.push({polygons:t,elevationFeature:o,elevationTileID:r});}const a={guardRailEnabled:this.layers[0].layout.get("fill-construct-bridge-guard-rail").evaluate(t,{},r),featureIndex:n};for(const e of s)if(e.elevationFeature){if("hd-road-base"===this.elevationMode){this.elevatedStructures||(this.elevatedStructures=new cp(e.elevationTileID,this.layers,this.zoom,this.lut));const r=e.elevationFeature.isTunnel();let n=0;t.properties.hasOwnProperty(Lu)&&(n=+t.properties[Lu]);for(const t of e.polygons)this.elevatedStructures.addPortalCandidates(e.elevationFeature.id,t,r,e.elevationFeature,n);}null==e.elevationFeature.constantHeight&&(e.polygons=this.prepareElevatedPolygons(e.polygons,e.elevationFeature,e.elevationTileID));const i=new rc(r,e.elevationTileID);this.addElevatedGeometry(e.polygons,i,e.elevationFeature,"hd-road-base"===this.elevationMode?0:.05,n,a);}}addElevatedGeometry(t,e,r,n,i,s){const o={elevation:r,elevationSampler:e,bias:n,index:i,featureInfo:s},[a,l]=this.addGeometry(t,this.elevationBufferData,o);null==this.elevationBufferData.heightRange?this.elevationBufferData.heightRange={min:a,max:l}:(this.elevationBufferData.heightRange.min=Math.min(this.elevationBufferData.heightRange.min,a),this.elevationBufferData.heightRange.max=Math.max(this.elevationBufferData.heightRange.max,l));}addGeometry(t,e,r){let n=Number.POSITIVE_INFINITY,i=Number.NEGATIVE_INFINITY,s=null;r&&(s=r.elevationSampler.constantElevation(r.elevation,r.bias),null!=s&&(n=s,i=s));const o=(t,o,a)=>{if(null!=r)if(o.push(t),null!=s)e.elevatedLayoutVertexArray.emplaceBack(s),a.push(s);else {const s=r.elevationSampler.pointElevation(t,r.elevation,r.bias);e.elevatedLayoutVertexArray.emplaceBack(s),a.push(s),n=Math.min(n,s),i=Math.max(i,s);}};for(const n of t){let t=0;for(const e of n)t+=e.length;const i=e.triangleSegments.prepareSegment(t,e.layoutVertexArray,e.indexArray),s=i.vertexLength,a=[],l=[],u=[],c=[],h=[],p=e.layoutVertexArray.length;for(const t of n){if(0===t.length)continue;t!==n[0]&&l.push(a.length/2);const i=e.lineSegments.prepareSegment(t.length,e.layoutVertexArray,e.lineIndexArray),s=i.vertexLength;r&&h.push(e.layoutVertexArray.length-p),o(t[0],u,c),e.layoutVertexArray.emplaceBack(t[0].x,t[0].y),e.lineIndexArray.emplaceBack(s+t.length-1,s),a.push(t[0].x),a.push(t[0].y);for(let r=1;r<t.length;r++)o(t[r],u,c),e.layoutVertexArray.emplaceBack(t[r].x,t[r].y),e.lineIndexArray.emplaceBack(s+r-1,s+r),a.push(t[r].x),a.push(t[r].y);i.vertexLength+=t.length,i.primitiveLength+=t.length;}const d=zh(a,l);for(let t=0;t<d.length;t+=3)e.indexArray.emplaceBack(s+d[t],s+d[t+1],s+d[t+2]);if(d.length>0&&r&&"hd-road-base"===this.elevationMode){const t=r.elevation.isTunnel(),e=r.elevation.safeArea,n=this.elevatedStructures.addVertices(u,c);this.elevatedStructures.addTriangles(d,n,t);const i=h.length;if(i>0){for(let s=0;s<i-1;s++)this.elevatedStructures.addRenderableRing(r.index,h[s]+n,h[s+1]-h[s],t,e,r.featureInfo);this.elevatedStructures.addRenderableRing(r.index,h[i-1]+n,u.length-h[i-1],t,e,r.featureInfo);}}i.vertexLength+=t,i.primitiveLength+=d.length/3;}return [n,i]}prepareElevatedPolygons(t,e,r){const n=1/vu(r),i=[];for(const r of t){const t=yp(r,new Qu(e,n));i.push(...t);}return i}clipPolygonsToTile(t,e){const r=-e,n=-e,i=Un+e,s=Un+e;let o=0;const a=[],l=[];for(;o<t.length;o++){const e=t[o],u=xn(e);(u.min.x>=r&&u.max.x<=i&&u.min.y>=n&&u.max.y<=s?a:l).push(e);}if(a.length===t.length)return t;const u=[new It(r,n),new It(i,n),new It(i,s),new It(r,s),new It(r,n)],c=a;for(const t of l)c.push(...mp(t,u));return c}}let wp,_p,Ap,Ip;Qs(bp,"FillBucket",{omit:["layers","patternFeatures"]}),Qs(vp,"FillBufferData"),Qs(cp,"ElevatedStructures");class Mp{constructor(t,e,r,n){if(this.triangleCount=e.length/3,this.min=new It(0,0),this.max=new It(0,0),this.xScale=0,this.yScale=0,this.cellsX=0,this.cellsY=0,this.cells=[],this.payload=[],0===this.triangleCount||0===t.length)return;const[i,s]=[t[0].clone(),t[0].clone()];for(let e=1;e<t.length;++e){const r=t[e];i.x=Math.min(i.x,r.x),i.y=Math.min(i.y,r.y),s.x=Math.max(s.x,r.x),s.y=Math.max(s.y,r.y);}if(n){const t=Math.ceil(Math.max(s.x-i.x,s.y-i.y)/n);r=Math.max(r,t);}if(0===r)return;this.min=i,this.max=s;const o=this.max.sub(this.min);o.x=Math.max(o.x,1),o.y=Math.max(o.y,1);const a=Math.max(o.x,o.y)/r;this.cellsX=Math.max(1,Math.ceil(o.x/a)),this.cellsY=Math.max(1,Math.ceil(o.y/a)),this.xScale=1/a,this.yScale=1/a;const l=[];for(let r=0;r<this.triangleCount;r++){const n=t[e[3*r+0]].sub(this.min),i=t[e[3*r+1]].sub(this.min),s=t[e[3*r+2]].sub(this.min),o=Sp(Math.floor(Math.min(n.x,i.x,s.x)),this.xScale,this.cellsX),u=Sp(Math.floor(Math.max(n.x,i.x,s.x)),this.xScale,this.cellsX),c=Sp(Math.floor(Math.min(n.y,i.y,s.y)),this.yScale,this.cellsY),h=Sp(Math.floor(Math.max(n.y,i.y,s.y)),this.yScale,this.cellsY),p=new It(0,0),d=new It(0,0),f=new It(0,0),m=new It(0,0);for(let t=c;t<=h;++t){p.y=d.y=t*a,f.y=m.y=(t+1)*a;for(let e=o;e<=u;++e)p.x=f.x=e*a,d.x=m.x=(e+1)*a,(vc(n,i,s,p,d,m)||vc(n,i,s,p,m,f))&&l.push({cellIdx:t*this.cellsX+e,triIdx:r});}}if(0===l.length)return;l.sort(((t,e)=>t.cellIdx-e.cellIdx||t.triIdx-e.triIdx));let u=0;for(;u<l.length;){const t=l[u].cellIdx,e={start:this.payload.length,len:0};for(;u<l.length&&l[u].cellIdx===t;)++e.len,this.payload.push(l[u++].triIdx);this.cells[t]=e;}}_lazyInitLookup(){this.lookup||(this.lookup=new Uint8Array(Math.ceil(this.triangleCount/8))),this.lookup.fill(0);}queryPoint(t,e){if(0===this.triangleCount||0===this.cells.length)return;if(t.x>this.max.x||this.min.x>t.x||t.y>this.max.y||this.min.y>t.y)return;const r=Sp(t.x-this.min.x,this.xScale,this.cellsX),n=Sp(t.y-this.min.y,this.yScale,this.cellsY),i=this.cells[n*this.cellsX+r];if(i){this._lazyInitLookup();for(let t=0;t<i.len;t++){const r=this.payload[i.start+t],n=Math.floor(r/8),s=1<<r%8;if(!(this.lookup[n]&s)&&(this.lookup[n]|=s,e.push(r),e.length===this.triangleCount))return}}}query(t,e,r){if(0===this.triangleCount||0===this.cells.length)return;if(t.x>this.max.x||this.min.x>e.x)return;if(t.y>this.max.y||this.min.y>e.y)return;this._lazyInitLookup();const n=Sp(t.x-this.min.x,this.xScale,this.cellsX),i=Sp(e.x-this.min.x,this.xScale,this.cellsX),s=Sp(t.y-this.min.y,this.yScale,this.cellsY),o=Sp(e.y-this.min.y,this.yScale,this.cellsY);for(let t=s;t<=o;t++)for(let e=n;e<=i;e++){const n=this.cells[t*this.cellsX+e];if(n)for(let t=0;t<n.len;t++){const e=this.payload[n.start+t],i=Math.floor(e/8),s=1<<e%8;if(!(this.lookup[i]&s)&&(this.lookup[i]|=s,r.push(e),r.length===this.triangleCount))return}}}}function Sp(t,e,r){return Math.max(0,Math.min(r-1,Math.floor(t*e)))}Qs(Mp,"TriangleGridIndex");class Pp{constructor(t){this.zoom=t.zoom,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.footprints=[],this.worldview=t.worldview,this.hasAppearances=null;}updateFootprints(t,e){for(const r of this.footprints)e.push({footprint:r,id:t});}updateAppearances(t,e,r,n){}populate(t,e,r,n){const i=[];for(const{feature:s,id:o,index:a,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Bu(s,t);if(!this.layers[0]._featureFilter.filter(new Io(this.zoom,{worldview:this.worldview,activeFloors:e.activeFloors}),u,r))continue;const c={id:o,properties:s.properties,type:s.type,sourceLayerIndex:l,index:a,geometry:t?u.geometry:ku(s,r,n),patterns:{}};i.push(c);}for(const n of i){const{geometry:i,index:s,sourceLayerIndex:o}=n;this.addFeature(n,i,s,r,{},e.availableImages,e.brightness),e.featureIndex.insert(t[s].feature,i,s,o,this.index);}}isEmpty(){return 0===this.footprints.length}uploadPending(){return !1}upload(t){}update(t,e,r,n,i,s,o){}destroy(){}addFeature(t,e,r,n,i,s=[],o){for(const t of rp(e,2)){const e=[],r=[],n=[],i=new It(1/0,1/0),s=new It(-1/0,-1/0);for(const o of t)if(0!==o.length){o!==t[0]&&n.push(r.length/2);for(let t=0;t<o.length;t++)r.push(o[t].x),r.push(o[t].y),e.push(o[t]),i.x=Math.min(i.x,o[t].x),i.y=Math.min(i.y,o[t].y),s.x=Math.max(s.x,o[t].x),s.y=Math.max(s.y,o[t].y);}const o=zh(r,n),a=new Mp(e,o,8,256);this.footprints.push({vertices:e,indices:o,grid:a,min:i,max:s});}}}Qs(Pp,"ClipBucket",{omit:["layers"]});const kp=ha([{name:"a_pos_normal_ed",components:4,type:"Int16"}]),Bp=ha([{name:"a_pos_end",components:4,type:"Int16"},{name:"a_angular_offset_factor",components:1,type:"Int16"}]),zp=ha([{name:"a_flood_light_ground_radius",components:1,type:"Float32"}]),Tp=ha([{name:"a_centroid_pos",components:2,type:"Uint16"}]),Ep=ha([{name:"a_join_normal_inside",components:3,type:"Int16"}]),Vp=ha([{name:"a_hidden_by_landmark",components:1,type:"Uint8"}]),Fp=ha([{name:"a_pos_3",components:3,type:"Int16"},{name:"a_pos_normal_3",components:3,type:"Int16"}]),{members:Cp}=kp,Dp=Number.MAX_SAFE_INTEGER,Rp=Dp-1;function Lp(t,e,r,n){return t.order<e||t.order===Dp||!(t.clipMask&r)||function(t,e){return 0!==e.length&&void 0===e.find((e=>e===t))}(n,t.clipScope)}function Op(t,e){return t.x-e.x||t.y-e.y}function Up(t,e){return 0===Op(t.min,e.min)&&0===Op(t.max,e.max)}function Np(t,e){return !(t.min.x>e.max.x||t.max.x<e.min.x||t.min.y>e.max.y||t.max.y<e.min.y)}function jp(t,e){if(t.length!==e.length)return !1;for(let r=0;r<t.length;r++)if(t[r].sourceId!==e[r].sourceId||!Up(t[r],e[r])||t[r].order!==e[r].order||t[r].clipMask!==e[r].clipMask||!Mt(t[r].clipScope,e[r].clipScope))return !1;return !0}function $p(t,e,r){const n=1/Un,i=1/(1<<r.canonical.z),s=(e.x*n+r.canonical.x)*i+r.wrap,o=(e.y*n+r.canonical.y)*i;return {min:new It((t.x*n+r.canonical.x)*i+r.wrap,(t.y*n+r.canonical.y)*i),max:new It(s,o)}}function Gp(t,e,r){const n=1<<r.canonical.z,i=((e.x-r.wrap)*n-r.canonical.x)*Un,s=(e.y*n-r.canonical.y)*Un;return {min:new It(((t.x-r.wrap)*n-r.canonical.x)*Un,(t.y*n-r.canonical.y)*Un),max:new It(i,s)}}function qp(t,e,r,n,i,s,o){const a=t.indices,l=t.vertices,u=[];for(let c=n;c<n+i;c+=3){const n=e[r[c+0]+s],i=e[r[c+1]+s],h=e[r[c+2]+s],p=Math.min(n.x,i.x,h.x),d=Math.max(n.x,i.x,h.x),f=Math.min(n.y,i.y,h.y),m=Math.max(n.y,i.y,h.y);u.length=0,t.grid.query(new It(p,f),new It(d,m),u);for(let t=0;t<u.length;t++){const e=u[t];if(vc(l[a[3*e+0]],l[a[3*e+1]],l[a[3*e+2]],n,i,h,o))return !0}}return !1}function Hp(t,e,r,n){if(!t||!r)return !1;let i=t.vertices;if(!e.canonical.equals(n.canonical)||e.wrap!==n.wrap){if(r.vertices.length<t.vertices.length)return Hp(r,n,t,e);const s=e.canonical,o=n.canonical,a=Math.pow(2,o.z-s.z);i=t.vertices.map((t=>new It((t.x+s.x*Un)*a-o.x*Un,(t.y+s.y*Un)*a-o.y*Un)));}return qp(r,i,t.indices,0,t.indices.length,0,0)}function Xp(t,e,r,n){const i=Math.pow(2,n.z-r.z);return new It((t+r.x*Un)*i-n.x*Un,(e+r.y*Un)*i-n.y*Un)}function Zp(t,e){const r=[];e.grid.queryPoint(t,r);const n=e.indices,i=e.vertices;for(let e=0;e<r.length;e++){const s=r[e];if(mc([i[n[3*s+0]],i[n[3*s+1]],i[n[3*s+2]]],t))return !0}return !1}const Wp=[new It(0,0),new It(Un,0),new It(Un,Un),new It(0,Un)];function Yp(t,e){const r=[];let n=[];if(!e||t.length<2)return [t];if(2===t.length)return gc(t[0],t[1],Wp)?[t]:[];for(let e=0;e<t.length+2;e++){const i=t[e%t.length],s=t[(e+1)%t.length],o=gc(0===e?t[t.length-1]:t[(e-1)%t.length],i,Wp),a=gc(i,s,Wp),l=o||a;l&&n.push(i),l&&a||n.length>0&&(n.length>1&&r.push(n),n=[]);}return n.length>1&&r.push(n),r}const Kp=zu.types,Jp=["fill-extrusion-base","fill-extrusion-height","fill-extrusion-color","fill-extrusion-pattern","fill-extrusion-flood-light-wall-radius","fill-extrusion-line-width","fill-extrusion-emissive-strength"],Qp=["fill-extrusion-flood-light-ground-radius"],td=Math.pow(2,13),ed=Math.pow(2,15)-1,rd=new It(0,1),nd=2147483648,id=7,sd=450;function od(t,e,r,n,i,s,o,a){t.emplaceBack((e<<1)+o,(r<<1)+s,(Math.floor(n*td)<<1)+i,Math.round(a));}function ad(t,e,r){t.emplaceBack(e.x*Un,e.y*Un,r?1:0);}function ld(t,e,r,n,i,s){t.emplaceBack(e.x,e.y,(r.x<<1)+n,(r.y<<1)+i,s);}function ud(t,e,r){const n=16384;t.emplaceBack(e.x,e.y,e.z,r[0]*n,r[1]*n,r[2]*n);}class cd{constructor(){this.vertexOffset=0,this.vertexCount=0,this.indexOffset=0,this.indexCount=0;}}class hd{constructor(){this.centroidXY=new It(0,0),this.vertexArrayOffset=0,this.vertexCount=0,this.groundVertexArrayOffset=0,this.groundVertexCount=0,this.flags=0,this.footprintSegIdx=-1,this.footprintSegLen=0,this.polygonSegIdx=-1,this.polygonSegLen=0,this.min=new It(Number.MAX_VALUE,Number.MAX_VALUE),this.max=new It(-Number.MAX_VALUE,-Number.MAX_VALUE),this.height=0,this.buildingId=0;}span(){return new It(this.max.x-this.min.x,this.max.y-this.min.y)}}class pd{constructor(){this.acc=new It(0,0),this.accCount=0,this.centroidDataIndex=0;}startRing(t,e){t.min.x===Number.MAX_VALUE&&(t.min.x=t.max.x=e.x,t.min.y=t.max.y=e.y);}appendEdge(t,e,r){this.accCount++,this.acc._add(e);let n=!!this.borders;e.x<t.min.x?(t.min.x=e.x,n=!0):e.x>t.max.x&&(t.max.x=e.x,n=!0),e.y<t.min.y?(t.min.y=e.y,n=!0):e.y>t.max.y&&(t.max.y=e.y,n=!0),((0===e.x||e.x===Un)&&e.x===r.x)!=((0===e.y||e.y===Un)&&e.y===r.y)&&this.processBorderOverlap(e,r),n&&this.checkBorderIntersection(e,r);}checkBorderIntersection(t,e){e.x<0!=t.x<0&&this.addBorderIntersection(0,pr(e.y,t.y,(0-e.x)/(t.x-e.x))),e.x>Un!=t.x>Un&&this.addBorderIntersection(1,pr(e.y,t.y,(Un-e.x)/(t.x-e.x))),e.y<0!=t.y<0&&this.addBorderIntersection(2,pr(e.x,t.x,(0-e.y)/(t.y-e.y))),e.y>Un!=t.y>Un&&this.addBorderIntersection(3,pr(e.x,t.x,(Un-e.y)/(t.y-e.y)));}addBorderIntersection(t,e){this.borders||(this.borders=[[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE]]);const r=this.borders[t];e<r[0]&&(r[0]=e),e>r[1]&&(r[1]=e);}processBorderOverlap(t,e){if(t.x===e.x){if(t.y===e.y)return;const r=0===t.x?0:1;this.addBorderIntersection(r,e.y),this.addBorderIntersection(r,t.y);}else {const r=0===t.y?2:3;this.addBorderIntersection(r,e.x),this.addBorderIntersection(r,t.x);}}centroid(){return 0===this.accCount?new It(0,0):new It(Math.floor(Math.max(0,this.acc.x)/this.accCount),Math.floor(Math.max(0,this.acc.y)/this.accCount))}intersectsCount(){return this.borders?this.borders.reduce(((t,e)=>t+ +(e[0]!==Number.MAX_VALUE)),0):0}}function dd(t,e){const r=t.add(e)._unit(),n=Ft(t.x*r.x+t.y*r.y,-1,1);var i,s,o;return i=Math.acos(n),Math.min(4,Math.max(-4,Math.tan(i)))/4*ed*((s=t).x*(o=e).y-s.y*o.x<0?-1:1)}const fd=[t=>t.x<0,t=>t.x>Un,t=>t.y<0,t=>t.y>Un];function md(t,e,r,n){const i=[4];if(0===n)return i;r._mult(n);const s=t.sub(r),o=e.sub(r),a=[t,e,s,o];for(let t=0;t<4;t++)for(const e of a)if(fd[t](e)){i.push(t);break}return i}class yd{constructor(t){this.groundRadiusArray=null,this.groundRadiusBuffer=null,this.vertexArray=new va,this.indexArray=new Fa,this.programConfigurations=new Ul(t.layers,{zoom:t.zoom,lut:t.lut},(t=>Qp.includes(t))),this._segments=new hl,this.hiddenByLandmarkVertexArray=new Za,this._segmentToGroundQuads={},this._segmentToGroundQuads[0]=[],this._segmentToRegionTriCounts={},this._segmentToRegionTriCounts[0]=[0,0,0,0,0],this.regionSegments={},this.regionSegments[4]=new hl;}getDefaultSegment(){return this.regionSegments[4]}hasData(){return 0!==this.vertexArray.length}addData(t,e,r,n=!1){const i=t.length;if(i>2){let s=Math.max(0,this._segments.get().length-1);const o=this._segments._prepareSegment(4*i,this.vertexArray.length,2*this._segmentToGroundQuads[s].length);let a;s!==this._segments.get().length-1&&(s++,this._segmentToGroundQuads[s]=[],this._segmentToRegionTriCounts[s]=[0,0,0,0,0]);{const e=t[0],r=t[1];a=dd(e.sub(t[i-1])._perp()._unit(),r.sub(e)._perp()._unit());}for(let l=0;l<i;l++){const u=l===i-1?0:l+1,c=t[l],h=t[u],p=t[u===i-1?0:u+1],d=h.sub(c)._perp()._unit(),f=dd(d,p.sub(h)._perp()._unit()),m=a,y=f;if(wd(c,h,e)||n&&_d(c,e)&&_d(h,e)){a=f;continue}const g=o.vertexLength;ld(this.vertexArray,c,h,1,1,m),ld(this.vertexArray,c,h,1,0,m),ld(this.vertexArray,c,h,0,1,y),ld(this.vertexArray,c,h,0,0,y),o.vertexLength+=4;const x=md(c,h,d,r);for(const t of x)this._segmentToGroundQuads[s].push({id:g,region:t}),this._segmentToRegionTriCounts[s][t]+=2,o.primitiveLength+=2;a=f;}}}prepareBorderSegments(){if(!this.hasData())return;const t=this._segments.get(),e=t.length;for(let t=0;t<e;t++)this._segmentToGroundQuads[t].sort(((t,e)=>t.region-e.region));for(let r=0;r<e;r++){const e=this._segmentToGroundQuads[r],n=t[r],i=this._segmentToRegionTriCounts[r];i.reduce(((t,e)=>t+e),0);let s=0;for(let t=0;t<=4;t++){const e=i[t];if(0!==e){let r=this.regionSegments[t];r||(r=this.regionSegments[t]=new hl);const i={vertexOffset:n.vertexOffset,primitiveOffset:n.primitiveOffset+s,vertexLength:n.vertexLength,primitiveLength:e};r.get().push(i);}s+=e;}for(let t=0;t<e.length;t++){const r=e[t].id;this.indexArray.emplaceBack(r,r+1,r+3),this.indexArray.emplaceBack(r,r+3,r+2);}}this._segmentToGroundQuads=null,this._segmentToRegionTriCounts=null,this._segments.destroy(),this._segments=null;}addPaintPropertiesData(t,e,r,n,i,s,o){this.hasData()&&this.programConfigurations.populatePaintArrays(this.vertexArray.length,t,e,r,n,i,s,void 0,o);}upload(t){this.hasData()&&(this.vertexBuffer=t.createVertexBuffer(this.vertexArray,Bp.members),this.indexBuffer=t.createIndexBuffer(this.indexArray),null!=this.groundRadiusArray&&(this.groundRadiusBuffer=t.createVertexBuffer(this.groundRadiusArray,zp.members)));}uploadPaintProperties(t){this.hasData()&&this.programConfigurations.upload(t);}update(t,e,r,n,i,s,o,a){this.hasData()&&this.programConfigurations.updatePaintArrays(t,e,r,n,i,s,o,a);}updateHiddenByLandmark(t){this.updateHiddenByLandmarkRange(t.groundVertexArrayOffset,t.groundVertexCount,!!(t.flags&nd));}updateHiddenByLandmarkRange(t,e,r){if(!this.hasData())return;const n=e+t;if(0!==e){for(let e=t;e<n;++e)this.hiddenByLandmarkVertexArray.emplace(e,r?1:0);this._needsHiddenByLandmarkUpdate=!0;}}uploadHiddenByLandmark(t){this.hasData()&&this._needsHiddenByLandmarkUpdate&&(!this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexArray.length>0?this.hiddenByLandmarkVertexBuffer=t.createVertexBuffer(this.hiddenByLandmarkVertexArray,Vp.members,!0):this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexBuffer.updateData(this.hiddenByLandmarkVertexArray),this._needsHiddenByLandmarkUpdate=!1);}destroy(){if(this.vertexBuffer){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexBuffer.destroy(),this.groundRadiusBuffer&&this.groundRadiusBuffer.destroy(),this._segments&&this._segments.destroy(),this.programConfigurations.destroy();for(let t=0;t<=4;t++){const e=this.regionSegments[t];e&&e.destroy();}}}}class gd{constructor(t){this.zoom=t.zoom,this.canonical=t.canonical,this.overscaling=t.overscaling,this.layers=t.layers,this.pixelRatio=t.pixelRatio,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.edgeRadius=0,this.projection=t.projection,this.activeReplacements=[],this.replacementUpdateTime=0,this.centroidData=[],this.footprintIndices=new Fa,this.footprintVertices=new da,this.footprintSegments=[],this.layoutVertexArray=new ma,this.centroidVertexArray=new sl,this.wallVertexArray=new al,this.indexArray=new Fa,this.programConfigurations=new Ul(t.layers,{zoom:t.zoom,lut:t.lut},(t=>Jp.includes(t))),this.segments=new hl,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.groundEffect=new yd(t),this.maxHeight=0,this.partLookup={},this.triangleSubSegments=[],this.polygonSegments=[],this.worldview=t.worldview,this.hasAppearances=null;}updateFootprints(t,e){}updateAppearances(t,e,r,n){}populate(t,e,r,n){this.features=[],this.hasPattern=sp("fill-extrusion",this.layers,this.pixelRatio,e),this.featuresOnBorder=[],this.borderFeatureIndices=[[],[],[],[]],this.borderDoneWithNeighborZ=[-1,-1,-1,-1],this.selfDEMTileTimestamp=Number.MAX_VALUE,this.borderDEMTileTimestamp=[Number.MAX_VALUE,Number.MAX_VALUE,Number.MAX_VALUE,Number.MAX_VALUE],this.tileToMeter=vu(r),this.edgeRadius=this.layers[0].layout.get("fill-extrusion-edge-radius")/this.tileToMeter,this.wallMode=0!==this.layers[0].paint.get("fill-extrusion-line-width").constantOr(1);for(const{feature:i,id:s,index:o,sourceLayerIndex:a}of t){const t=this.layers[0]._featureFilter.needGeometry,l=Bu(i,t);if(!this.layers[0]._featureFilter.filter(new Io(this.zoom,{worldview:this.worldview,activeFloors:e.activeFloors}),l,r))continue;const u={id:s,sourceLayerIndex:a,index:o,geometry:t?l.geometry:ku(i,r,n),properties:i.properties,type:i.type,patterns:{}},c=this.layoutVertexArray.length,h="Polygon"===Kp[u.type];if(this.hasPattern)this.features.push({featureId:i.id,feature:op("fill-extrusion",this.layers,u,this.zoom,this.pixelRatio,e)});else if(this.wallMode)for(const t of u.geometry)for(const s of Yp(t,h))this.addFeature(i.id,u,[s],o,r,{},e.availableImages,n,e.brightness);else this.addFeature(i.id,u,u.geometry,o,r,{},e.availableImages,n,e.brightness);e.featureIndex.insert(i,u.geometry,o,a,this.index,c);}this.sortBorders(),"mercator"===this.projection.name&&this.splitToSubtiles(),this.groundEffect.prepareBorderSegments(),this.polygonSegments.length=0;}addFeatures(t,e,r,n,i,s){for(const{featureId:t,feature:o}of this.features){const a="Polygon"===Kp[o.type],{geometry:l}=o;if(this.wallMode)for(const u of l)for(const l of Yp(u,a))this.addFeature(t,o,[l],o.index,e,r,n,i,s);else this.addFeature(t,o,l,o.index,e,r,n,i,s);}this.sortBorders(),"mercator"===this.projection.name&&this.splitToSubtiles();}update(t,e,r,n,i,s,o){this.programConfigurations.updatePaintArrays(t,e,i,r,n,s,o,this.worldview),this.groundEffect.update(t,e,i,r,n,s,o,this.worldview);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload||this.groundEffect.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Cp),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.wallVertexBuffer=t.createVertexBuffer(this.wallVertexArray,Ep.members),this.layoutVertexExtArray&&(this.layoutVertexExtBuffer=t.createVertexBuffer(this.layoutVertexExtArray,Fp.members,!0)),this.groundEffect.upload(t)),this.groundEffect.uploadPaintProperties(t),this.programConfigurations.upload(t),this.uploaded=!0;}uploadCentroid(t){this.groundEffect.uploadHiddenByLandmark(t),this.needsCentroidUpdate&&(!this.centroidVertexBuffer&&this.centroidVertexArray.length>0?this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,Tp.members,!0):this.centroidVertexBuffer&&this.centroidVertexBuffer.updateData(this.centroidVertexArray),this.needsCentroidUpdate=!1);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.centroidVertexBuffer&&this.centroidVertexBuffer.destroy(),this.layoutVertexExtBuffer&&this.layoutVertexExtBuffer.destroy(),this.groundEffect.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,n,i,s,o,a,l){const u=this.layers[0].paint.get("fill-extrusion-flood-light-ground-radius").evaluate(e,{})/this.tileToMeter,c=[new It(0,0),new It(Un,Un)],h=a.projection,p="globe"===h.name,d=this.wallMode||"Polygon"===Kp[e.type],f=new pd;f.centroidDataIndex=this.centroidData.length;const m=new hd;m.buildingId=t,e.properties&&e.properties.hasOwnProperty("building_id")&&(m.buildingId=e.properties.building_id);const y=this.layers[0].paint.get("fill-extrusion-base").evaluate(e,{},i)<=0,g=this.layers[0].paint.get("fill-extrusion-height").evaluate(e,{},i);let x;if(m.height=g,m.vertexArrayOffset=this.layoutVertexArray.length,m.groundVertexArrayOffset=this.groundEffect.vertexArray.length,p&&!this.layoutVertexExtArray&&(this.layoutVertexExtArray=new Ia),this.wallMode){if(p)return void Xt("Non zero fill-extrusion-line-width is not yet supported on globe.");if(1!==r.length)return;x=function(t){const e=t[0].x===t[t.length-1].x&&t[0].y===t[t.length-1].y,r=function(t){let e=0;const r=t.length;for(let n=0;n<r;n++)e+=(t[(n+1)%r].x-t[n].x)*(t[(n+1)%r].y+t[n].y);return e>=0}(t);r||(t=t.reverse());const n={geometry:[],joinNormals:[],indices:[]},i=[],s=[],o=[];let a=t.length;for(;a>=2&&t[a-1].equals(t[a-2]);)a--;if(a<(e?3:2))return n;let l,u,c,h,p,d=0;for(;d<a-1&&t[d].equals(t[d+1]);)d++;e&&(l=t[a-2],p=t[d].sub(l)._unit()._perp());for(let r=d;r<a;r++){if(c=r===a-1?e?t[d+1]:void 0:t[r+1],c&&t[r].equals(c))continue;p&&(h=p),l&&(u=l),l=t[r],p=c?c.sub(l)._unit()._perp():h,h=h||p;let n=h.add(p);0===n.x&&0===n.y||n._unit();const f=n.x*p.x+n.y*p.y,m=0!==f?1/f:1/0,y=h.x*p.y-h.y*p.x>0;let g="miter";const x=2;"miter"===g&&m>x&&(g="bevel"),"bevel"===g&&(m>100&&(g="flipbevel"),m<x&&(g="miter"));const v=(t,e,r,n)=>{const a=new It(t.x,t.y),l=new It(t.x,t.y);a.x+=e.x*n,a.y+=e.y*n,l.x-=e.x*Math.max(r,1),l.y-=e.y*Math.max(r,1),o.push(e),i.push(a),s.push(l);};if("miter"===g)n._mult(m),v(l,n,0,0);else if("flipbevel"===g)n=p.mult(-1),v(l,n,0,0),v(l,n.mult(-1),0,0);else {const t=-Math.sqrt(m*m-1),e=y?t:0,r=y?0:t;u&&v(l,h,e,r),c&&v(l,p,e,r);}}n.geometry=[...i,...s.reverse(),i[0]],n.joinNormals=[...o,...o.reverse(),o[o.length-1]];const f=n.geometry.length-1;for(let t=0;t<f/2;t++)if(t+1<f/2){let e=t,r=t+1,i=f-1-t,s=f-2-t;e=0===e?f-1:e-1,r=0===r?f-1:r-1,i=0===i?f-1:i-1,s=0===s?f-1:s-1,n.indices.push(i),n.indices.push(r),n.indices.push(e),n.indices.push(i),n.indices.push(s),n.indices.push(r);}return n}(r[0]),r=[x.geometry];}const v=(t,e)=>t<(e.length-1)/2||t===e.length-1,b=this.wallMode?[r]:rp(r,500);for(let t=b.length-1;t>=0;t--){const e=b[t];(0===e.length||(w=e[0]).every((t=>t.x<=0))||w.every((t=>t.x>=Un))||w.every((t=>t.y<=0))||w.every((t=>t.y>=Un)))&&b.splice(t,1);}var w;let _;if(p)_=Sd(b,c,i);else {_=[];for(const t of b)_.push({polygon:t,bounds:c});}const A=d?this.edgeRadius:0,I=A>0&&this.zoom<17,M=(t,e)=>{if(0===t.length)return !1;const r=t[t.length-1];return e.x===r.x&&e.y===r.y};for(const{polygon:t,bounds:e}of _){let r=0,n=0;for(const e of t)d&&!e[0].equals(e[e.length-1])&&e.push(e[0]),n+=d?e.length-1:e.length;const s=this.segments.prepareSegment((d?5:4)*n,this.layoutVertexArray,this.indexArray);m.footprintSegIdx<0&&(m.footprintSegIdx=this.footprintSegments.length),m.polygonSegIdx<0&&(m.polygonSegIdx=this.polygonSegments.length);const o={triangleArrayOffset:this.indexArray.length,triangleCount:0,triangleSegIdx:this.segments.segments.length-1},a=new cd;if(a.vertexOffset=this.footprintVertices.length,a.indexOffset=3*this.footprintIndices.length,a.ringIndices=[],d){const n=[],o=[];r=s.vertexLength;for(let r=0;r<t.length;r++){const l=t[r];l.length&&0!==r&&o.push(n.length/2);const c=[];let d,f;d=l[1].sub(l[0])._perp()._unit(),a.ringIndices.push(l.length-1);for(let t=1;t<l.length;t++){const e=l[t],r=l[t===l.length-1?1:t+1],o=e.clone();if(A){f=r.sub(e)._perp()._unit();const t=d.add(f)._unit(),n=A*Math.min(4,1/(d.x*t.x+d.y*t.y));o.x+=n*t.x,o.y+=n*t.y,o.x=Math.round(o.x),o.y=Math.round(o.y),d=f;}if(!y||0!==A&&!I||M(c,o)||c.push(o),od(this.layoutVertexArray,o.x,o.y,0,0,1,1,0),this.wallMode){const e=v(t,l);ad(this.wallVertexArray,x.joinNormals[t],!e);}s.vertexLength++,this.footprintVertices.emplaceBack(e.x,e.y),n.push(e.x,e.y),p&&ud(this.layoutVertexExtArray,h.projectTilePoint(o.x,o.y,i),h.upVector(i,o.x,o.y));}y&&(0===A||I)&&(0!==c.length&&M(c,c[0])&&c.pop(),this.groundEffect.addData(c,e,u));}const l=this.wallMode?x.indices:zh(n,o);for(let t=0;t<l.length;t+=3)this.footprintIndices.emplaceBack(a.vertexOffset+l[t+0],a.vertexOffset+l[t+1],a.vertexOffset+l[t+2]),this.indexArray.emplaceBack(r+l[t],r+l[t+2],r+l[t+1]),s.primitiveLength++;a.indexCount+=l.length,a.vertexCount+=this.footprintVertices.length-a.vertexOffset;}for(let n=0;n<t.length;n++){const o=t[n];f.startRing(m,o[0]);let a=o.length>4&&Ad(o[o.length-2],o[0],o[1]),l=A?vd(o[o.length-2],o[0],o[1],A):0;const c=[];let g,b,w;b=o[1].sub(o[0])._perp()._unit();let _=!0;for(let t=1,n=0;t<o.length;t++){let u=o[t-1],d=o[t];const I=o[t===o.length-1?1:t+1];if(f.appendEdge(m,d,u),wd(d,u,e)){A&&(b=I.sub(d)._perp()._unit(),_=!_);continue}const S=d.sub(u)._perp(),P=S.x/(Math.abs(S.x)+Math.abs(S.y)),k=S.y>0?1:0,B=u.dist(d);if(n+B>32768&&(n=0),A){w=I.sub(d)._perp()._unit();let t=bd(u,d,I,xd(b,w),A);isNaN(t)&&(t=0);const e=d.sub(u)._unit();u=u.add(e.mult(l))._round(),d=d.add(e.mult(-t))._round(),l=t,b=w,y&&this.zoom>=17&&(M(c,u)||c.push(u),M(c,d)||c.push(d));}const z=s.vertexLength,T=o.length>4&&Ad(u,d,I);let E=Id(n,a,_);if(od(this.layoutVertexArray,u.x,u.y,P,k,0,0,E),od(this.layoutVertexArray,u.x,u.y,P,k,0,1,E),this.wallMode){const e=v(t-1,o),r=x.joinNormals[t-1];ad(this.wallVertexArray,r,e),ad(this.wallVertexArray,r,e);}if(n+=B,E=Id(n,T,!_),a=T,od(this.layoutVertexArray,d.x,d.y,P,k,0,0,E),od(this.layoutVertexArray,d.x,d.y,P,k,0,1,E),this.wallMode){const e=v(t,o),r=x.joinNormals[t];ad(this.wallVertexArray,r,e),ad(this.wallVertexArray,r,e);}if(s.vertexLength+=4,this.indexArray.emplaceBack(z+0,z+1,z+2),this.indexArray.emplaceBack(z+1,z+3,z+2),s.primitiveLength+=2,A){const n=r+(1===t?o.length-2:t-2),i=1===t?r:n+1;if(this.indexArray.emplaceBack(z+1,n,z+3),this.indexArray.emplaceBack(n,i,z+3),s.primitiveLength+=2,void 0===g&&(g=z),!wd(I,o[t],e)){const e=t===o.length-1?g:s.vertexLength;this.indexArray.emplaceBack(z+2,z+3,e),this.indexArray.emplaceBack(z+3,e+1,e),this.indexArray.emplaceBack(z+3,i,e+1),s.primitiveLength+=3;}_=!_;}if(p){const t=this.layoutVertexExtArray,e=h.projectTilePoint(u.x,u.y,i),r=h.projectTilePoint(d.x,d.y,i),n=h.upVector(i,u.x,u.y),s=h.upVector(i,d.x,d.y);ud(t,e,n),ud(t,e,n),ud(t,r,s),ud(t,r,s);}}d&&(r+=o.length-1),y&&A&&this.zoom>=17&&(0!==c.length&&M(c,c[0])&&c.pop(),this.groundEffect.addData(c,e,u,A>0));}this.footprintSegments.push(a),o.triangleCount=this.indexArray.length-o.triangleArrayOffset,this.polygonSegments.push(o),++m.footprintSegLen,++m.polygonSegLen;}if(m.vertexCount=this.layoutVertexArray.length-m.vertexArrayOffset,m.groundVertexCount=this.groundEffect.vertexArray.length-m.groundVertexArrayOffset,0!==m.vertexCount){if(m.centroidXY=f.borders?rd:this.encodeCentroid(f,m),this.centroidData.push(m),f.borders){this.featuresOnBorder.push(f);const t=this.featuresOnBorder.length-1;for(let e=0;e<f.borders.length;e++)f.borders[e][0]!==Number.MAX_VALUE&&this.borderFeatureIndices[e].push(t);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,n,s,o,i,l,void 0,this.worldview),this.groundEffect.addPaintPropertiesData(e,n,s,o,i,l,this.worldview),this.maxHeight=Math.max(this.maxHeight,g);}}sortBorders(){for(let t=0;t<this.borderFeatureIndices.length;t++)this.borderFeatureIndices[t].sort(((e,r)=>this.featuresOnBorder[e].borders[t][0]-this.featuresOnBorder[r].borders[t][0]));}splitToSubtiles(){const t=[];for(let e=0;e<this.centroidData.length;e++){const r=this.centroidData[e],n=+(r.min.y+r.max.y>Un),i=2*n+(+(r.min.x+r.max.x>Un)^n);for(let n=0;n<r.polygonSegLen;n++){const s=r.polygonSegIdx+n;t.push({centroidIdx:e,subtile:i,polygonSegmentIdx:s,triangleSegmentIdx:this.polygonSegments[s].triangleSegIdx});}}const e=new Fa;t.sort(((t,e)=>t.triangleSegmentIdx===e.triangleSegmentIdx?t.subtile-e.subtile:t.triangleSegmentIdx-e.triangleSegmentIdx));let r=0,n=0,i=0;for(const e of t){if(e.triangleSegmentIdx!==r)break;i++;}const s=t.length;for(;n!==t.length;){r=t[n].triangleSegmentIdx;let o=0,a=n,l=n;for(let e=a;e<i&&t[e].subtile===o;e++)l++;for(;a!==i;){const n=t[a];o=n.subtile;const s=this.centroidData[n.centroidIdx].min.clone(),u=this.centroidData[n.centroidIdx].max.clone(),c={vertexOffset:this.segments.segments[r].vertexOffset,primitiveOffset:e.length,vertexLength:this.segments.segments[r].vertexLength,primitiveLength:0,sortKey:void 0,vaos:{}};for(let r=a;r<l;r++){const n=t[r],i=this.polygonSegments[n.polygonSegmentIdx],o=this.centroidData[n.centroidIdx].min,a=this.centroidData[n.centroidIdx].max,l=this.indexArray.uint16;for(let t=i.triangleArrayOffset;t<i.triangleArrayOffset+i.triangleCount;t++)e.emplaceBack(l[3*t],l[3*t+1],l[3*t+2]);c.primitiveLength+=i.triangleCount,s.x=Math.min(s.x,o.x),s.y=Math.min(s.y,o.y),u.x=Math.max(u.x,a.x),u.y=Math.max(u.y,a.y);}c.primitiveLength>0&&this.triangleSubSegments.push({segment:c,min:s,max:u}),a=l;for(let e=a;e<i&&t[e].subtile===t[a].subtile;e++)l++;}n=i;for(let e=n;e<s&&t[e].triangleSegmentIdx===t[n].triangleSegmentIdx;e++)i++;}e._trim(),this.indexArray=e;}getVisibleSegments(t,e,r){const n=new hl;if(this.wallMode){for(const t of this.triangleSubSegments)n.segments.push(t.segment);return n}let i=0,s=0;const o=1<<t.canonical.z;if(e){const r=e.getMinMaxForTile(t);r&&(i=r.min,s=r.max);}s+=this.maxHeight;const a=t.toUnwrapped();let l;const u=[a.canonical.x/o+a.wrap,a.canonical.y/o],c=[(a.canonical.x+1)/o+a.wrap,(a.canonical.y+1)/o],h=(t,e,r)=>[t[0]*(1-r[0])+e[0]*r[0],t[1]*(1-r[1])+e[1]*r[1]],p=[],d=[];for(const t of this.triangleSubSegments){p[0]=t.min.x/Un,p[1]=t.min.y/Un,d[0]=t.max.x/Un,d[1]=t.max.y/Un;const e=h(u,c,p),o=h(u,c,d);if(0===new Ju([e[0],e[1],i],[o[0],o[1],s]).intersectsPrecise(r)){l&&(n.segments.push(l),l=void 0);continue}const a=t.segment;l&&l.vertexOffset!==a.vertexOffset&&(n.segments.push(l),l=void 0),l?(l.vertexLength+=a.vertexLength,l.primitiveLength+=a.primitiveLength):l={vertexOffset:a.vertexOffset,primitiveLength:a.primitiveLength,vertexLength:a.vertexLength,primitiveOffset:a.primitiveOffset,sortKey:void 0,vaos:{}};}return l&&n.segments.push(l),n}encodeCentroid(t,e){const r=t.centroid(),n=e.span(),i=Math.min(7,Math.round(n.x*this.tileToMeter/10)),s=Math.min(7,Math.round(n.y*this.tileToMeter/10));return new It(Ft(r.x,1,Un-1)<<3|i,Ft(r.y,1,Un-1)<<3|s)}encodeBorderCentroid(t){if(!t.borders)return new It(0,0);const e=t.borders,r=Number.MAX_VALUE;if(e[0][0]!==r||e[1][0]!==r){const t=e[0][0]!==r?0:1;return new It(6|(e[0][0]!==r?0:65528),(e[t][0]+e[t][1])/2<<3|6)}{const t=e[2][0]!==r?2:3;return new It((e[t][0]+e[t][1])/2<<3|6,6|(e[2][0]!==r?0:65528))}}showCentroid(t){const e=this.centroidData[t.centroidDataIndex];e.flags&=2147483647,e.centroidXY.x=0,e.centroidXY.y=0,this.writeCentroidToBuffer(e);}writeCentroidToBuffer(t){this.groundEffect.updateHiddenByLandmark(t);const e=t.vertexArrayOffset,r=t.vertexCount+t.vertexArrayOffset,n=t.flags&nd?rd:t.centroidXY,i=this.centroidVertexArray.geta_centroid_pos0(e);if(this.centroidVertexArray.geta_centroid_pos1(e)!==n.y||i!==n.x){for(let t=e;t<r;++t)this.centroidVertexArray.emplace(t,n.x,n.y);this.needsCentroidUpdate=!0;}}createCentroidsBuffer(){this.centroidVertexArray.resize(this.layoutVertexArray.length),this.groundEffect.hiddenByLandmarkVertexArray.resize(this.groundEffect.vertexArray.length);for(const t of this.centroidData)this.writeCentroidToBuffer(t);}updateReplacement(t,e,r){if(e.updateTime===this.replacementUpdateTime)return;this.replacementUpdateTime=e.updateTime;const n=e.getReplacementRegionsForTile(t.toUnwrapped());if(jp(this.activeReplacements,n))return;if(this.activeReplacements=n,0===this.centroidVertexArray.length)this.createCentroidsBuffer();else for(const t of this.centroidData)t.flags&=2147483647;const i=[];for(const e of this.activeReplacements){if(e.order<r)continue;const n=Math.max(1,Math.pow(2,e.footprintTileId.canonical.z-t.canonical.z));if(e.footprint.buildingIds)for(const t of this.centroidData)t.flags&nd||e.min.x>t.max.x||t.min.x>e.max.x||e.min.y>t.max.y||t.min.y>e.max.y||e.footprint.buildingIds.has(t.buildingId)&&(t.flags|=nd);else for(const r of this.centroidData)if(!(r.flags&nd||e.min.x>r.max.x||r.min.x>e.max.x||e.min.y>r.max.y||r.min.y>e.max.y))for(let s=0;s<r.footprintSegLen;s++){const o=this.footprintSegments[r.footprintSegIdx+s];if(i.length=0,Pd(this.footprintVertices,o.vertexOffset,o.vertexCount,e.footprintTileId.canonical,t.canonical,i),qp(e.footprint,i,this.footprintIndices.uint16,o.indexOffset,o.indexCount,-o.vertexOffset,-n)){r.flags|=nd;break}}}for(const t of this.centroidData)this.writeCentroidToBuffer(t);this.borderDoneWithNeighborZ=[-1,-1,-1,-1];}footprintContainsPoint(t,e,r){let n=!1;for(let i=0;i<r.footprintSegLen;i++){const s=this.footprintSegments[r.footprintSegIdx+i];let o=0;for(const r of s.ringIndices){for(let i=o,a=r+o-1;i<r+o;a=i++){const r=this.footprintVertices.int16[2*(i+s.vertexOffset)+0],o=this.footprintVertices.int16[2*(i+s.vertexOffset)+1],l=this.footprintVertices.int16[2*(a+s.vertexOffset)+1];o>e!=l>e&&t<(this.footprintVertices.int16[2*(a+s.vertexOffset)+0]-r)*(e-o)/(l-o)+r&&(n=!n);}o=r;}}return n}getHeightAtTileCoord(t,e){let r=Number.NEGATIVE_INFINITY,n=!0;const i=4*(t+Un)*Un+(e+Un);if(this.partLookup.hasOwnProperty(i)){const t=this.partLookup[i];return t?{height:t.height,hidden:!!(t.flags&nd)}:void 0}for(const s of this.centroidData)t>s.max.x||s.min.x>t||e>s.max.y||s.min.y>e||s.height<=r||this.footprintContainsPoint(t,e,s)&&(r=s.height,this.partLookup[i]=s,n=!!(s.flags&nd));if(r!==Number.NEGATIVE_INFINITY)return {height:r,hidden:n};this.partLookup[i]=void 0;}}function xd(t,e){const r=t.add(e)._unit();return t.x*r.x+t.y*r.y}function vd(t,e,r,n){const i=e.sub(t)._perp()._unit(),s=r.sub(e)._perp()._unit();return bd(t,e,r,xd(i,s),n)}function bd(t,e,r,n,i){const s=Math.sqrt(1-n*n);return Math.min(t.dist(e)/3,e.dist(r)/3,i*s/n)}function wd(t,e,r){return t.x<r[0].x&&e.x<r[0].x||t.x>r[1].x&&e.x>r[1].x||t.y<r[0].y&&e.y<r[0].y||t.y>r[1].y&&e.y>r[1].y}function _d(t,e){return t.x<e[0].x||t.x>e[1].x||t.y<e[0].y||t.y>e[1].y}function Ad(t,e,r){if(t.x<0||t.x>=Un||e.x<0||e.x>=Un||r.x<0||r.x>=Un)return !1;const n=r.sub(e),i=n.perp(),s=t.sub(e);return (n.x*s.x+n.y*s.y)/Math.sqrt((n.x*n.x+n.y*n.y)*(s.x*s.x+s.y*s.y))>-.866&&i.x*s.x+i.y*s.y<0}function Id(t,e,r){const n=e?2|t:-3&t;return r?1|n:-2&n}function Md(){const t=Math.PI/32,e=Math.tan(t),r=ru;return r*Math.sqrt(1+2*e*e)-r}function Sd(t,e,r){const n=1<<r.z,i=pu(r.x/n),s=pu((r.x+1)/n),o=du(r.y/n),a=du((r.y+1)/n);return function(t,e,r,n,i=0,s){const o=[];if(!t.length||!r||!n)return o;const a=(t,e)=>{for(const r of t)o.push({polygon:r,bounds:e});},l=Math.ceil(Math.log2(r)),u=Math.ceil(Math.log2(n)),c=l-u,h=[];for(let t=0;t<Math.abs(c);t++)h.push(c>0?0:1);for(let t=0;t<Math.min(l,u);t++)h.push(0),h.push(1);let p=t;if(p=fp(p,e[0].y-i,e[1].y+i,1),p=fp(p,e[0].x-i,e[1].x+i,0),!p.length)return o;const d=[];for(h.length?d.push({polygons:p,bounds:e,depth:0}):a(p,e);d.length;){const t=d.pop(),e=t.depth,r=h[e],n=t.bounds[0],o=t.bounds[1],l=0===r?n.x:n.y,u=0===r?o.x:o.y,c=s?s(r,l,u):.5*(l+u),p=fp(t.polygons,l-i,c+i,r),f=fp(t.polygons,c-i,u+i,r);if(p.length){const t=[n,new It(0===r?c:o.x,1===r?c:o.y)];h.length>e+1?d.push({polygons:p,bounds:t,depth:e+1}):a(p,t);}if(f.length){const t=[new It(0===r?c:n.x,1===r?c:n.y),o];h.length>e+1?d.push({polygons:f,bounds:t,depth:e+1}):a(f,t);}}return o}(t,e,Math.ceil((s-i)/11.25),Math.ceil((o-a)/11.25),1,((t,e,i)=>{if(0===t)return .5*(e+i);{const t=du((r.y+e/Un)/n);return (cu(.5*(du((r.y+i/Un)/n)+t))*n-r.y)*Un}}))}function Pd(t,e,r,n,i,s){const o=Math.pow(2,n.z-i.z);for(let a=0;a<r;a++){let r=t.int16[2*(a+e)+0],l=t.int16[2*(a+e)+1];r=(r+i.x*Un)*o-n.x*Un,l=(l+i.y*Un)*o-n.y*Un,s.push(new It(r,l));}}let kd,Bd;Qs(gd,"FillExtrusionBucket",{omit:["layers","features"]}),Qs(hd,"PartData"),Qs(cd,"FootprintSegment"),Qs(pd,"BorderCentroidData"),Qs(yd,"GroundEffect");class zd extends It{constructor(t,e,r){super(t,e),this.z=r;}}class Td extends zd{constructor(t,e,r,n){super(t,e,r),this.w=n;}}function Ed(t,e,r,n){const i="x"===r?"y":"x",s=(n-t[r])/(e[r]-t[r]);t[i]=Math.round(t[i]+(e[i]-t[i])*s),t[r]=n,t.hasOwnProperty("z")&&(t.z=pr(t.z,e.z,s)),t.hasOwnProperty("w")&&(t.w=pr(t.w,e.w,s));}function Vd(t,e,r,n){const i=r,s=n;for(const r of ["x","y"]){let n=t,o=e;n[r]>=o[r]&&(n=e,o=t),n[r]<i&&o[r]>i&&Ed(n,o,r,i),n[r]<s&&o[r]>s&&Ed(o,n,r,s);}}function Fd(t,e,r,n,i,s){const o=[];for(let a=0;a<t.length;a++){const l=t[a];let u;const c=o.length;let h=0;for(let t=0;t<l.length-1;t++){let c=l[t],p=l[t+1],d=0;const f=h;let m,y;s&&(d=Math.hypot(p.x-c.x,p.y-c.y),h+=d,m=c,y=p),c.x<e&&p.x<e||(c.x<e?c=new It(e,c.y+(e-c.x)/(p.x-c.x)*(p.y-c.y))._round():p.x<e&&(p=new It(e,c.y+(e-c.x)/(p.x-c.x)*(p.y-c.y))._round()),c.y<r&&p.y<r||(c.y<r?c=new It(c.x+(r-c.y)/(p.y-c.y)*(p.x-c.x),r)._round():p.y<r&&(p=new It(c.x+(r-c.y)/(p.y-c.y)*(p.x-c.x),r)._round()),c.x>=n&&p.x>=n||(c.x>=n?c=new It(n,c.y+(n-c.x)/(p.x-c.x)*(p.y-c.y))._round():p.x>=n&&(p=new It(n,c.y+(n-c.x)/(p.x-c.x)*(p.y-c.y))._round()),c.y>=i&&p.y>=i||(c.y>=i?c=new It(c.x+(i-c.y)/(p.y-c.y)*(p.x-c.x),i)._round():p.y>=i&&(p=new It(c.x+(i-c.y)/(p.y-c.y)*(p.x-c.x),i)._round()),u&&c.equals(u[u.length-1])||(u=[c],o.push(u),s&&s.push({progress:{min:f+Dd(m,y,c)*d,max:1},parentIndex:a,prevPoint:m,nextPoint:y})),u.push(p),s&&(s[s.length-1].progress.max=f+Dd(m,y,p)*d,s[s.length-1].nextPoint=y)))));}if(s&&h>0)for(let t=c;t<o.length;t++)s[t].progress.min/=h,s[t].progress.max/=h;}return o}function Cd(t,e,r,n,i){if(t.length<2)return void n.push(t);const s=[];for(;e.valid();){const[r,n]=e.get();for(let e=0;e<t.length-1;e++){const i=t[e],o=t[e+1],a=hc(i,o,r,n);if(a){const[t]=a,r=new It(pr(i.x,o.x,t),pr(i.y,o.y,t));s.push({t:e+t,distance:0,point:r});}}e.next();}if(0===s.length)return void n.push(t);s.sort(((t,e)=>t.t-e.t));let o=0,a=0,l=[];for(n.push(l);o!==t.length;){if(a===s.length){for(;o!==t.length;)0!==l.length&&l[l.length-1].equals(t[o])||l.push(t[o]),o++;break}s[a].t<=o?(0!==l.length&&l[l.length-1].equals(s[a].point)||l.push(s[a].point),Math.trunc(s[a].t),a++):(0!==l.length&&l[l.length-1].equals(t[o])||l.push(t[o]),o++);}}function Dd(t,e,r){return t.x!==e.x?(r.x-t.x)/(e.x-t.x):t.y!==e.y?(r.y-t.y)/(e.y-t.y):0}function Rd(t,e){return t.x*e.x+t.y*e.y}function Ld(t,e){if(1===t.length){let r=0;const n=e[r++];let i;for(;!i||n.equals(i);)if(i=e[r++],!i)return 1/0;for(;r<e.length;r++){const s=e[r],o=t[0],a=i.sub(n),l=s.sub(n),u=o.sub(n),c=Rd(a,a),h=Rd(a,l),p=Rd(l,l),d=Rd(u,a),f=Rd(u,l),m=c*p-h*h,y=(p*d-h*f)/m,g=(c*f-h*d)/m,x=n.z*(1-y-g)+i.z*y+s.z*g;if(isFinite(x))return x}return 1/0}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t}}function Od(t,e,r){let n=1/0;oc(r,e)&&(n=Ld(r,e[0]));for(let i=0;i<e.length;i++){const s=e[i],o=t[i];for(let t=0;t<s.length-1;t++){const e=s[t],i=[e,s[t+1],o[t+1],o[t],e];ic(r,i)&&(n=Math.min(n,Ld(r,i)));}}return n!==1/0&&n}function Ud(t,e,r,n,i,s,o,a,l,u,c){return "globe"===t.projection.name?function(t,e,r,n,i,s,o,a,l,u,c){const h=[],p=[],d=t.projection.upVectorScale(c,t.center.lat,t.worldSize).metersToTile,f=[0,0,0,1],m=[0,0,0,1],y=(t,e,r,n)=>{t[0]=e,t[1]=r,t[2]=n,t[3]=1;},g=Md();r>0&&(r+=g),n+=g;for(const g of e){const e=[],x=[];for(const h of g){const p=h.x+i.x,g=h.y+i.y,v=t.projection.projectTilePoint(p,g,c),b=t.projection.upVector(c,h.x,h.y);let w=r,_=n;if(o){const t=Nd(p,g,r,n,o,a,l,u);w+=t.base,_+=t.top;}0!==r?y(f,v.x+b[0]*d*w,v.y+b[1]*d*w,v.z+b[2]*d*w):y(f,v.x,v.y,v.z),y(m,v.x+b[0]*d*_,v.y+b[1]*d*_,v.z+b[2]*d*_),j(f,f,s),j(m,m,s),e.push(new zd(f[0],f[1],f[2])),x.push(new zd(m[0],m[1],m[2]));}h.push(e),p.push(x);}return [h,p]}(t,e,r,n,i,s,o,a,l,u,c):o?function(t,e,r,n,i,s,o,a,l){const u=[],c=[],h=[0,0,0,1];for(const p of t){const t=[],d=[];for(const u of p){const c=u.x+n.x,p=u.y+n.y,f=Nd(c,p,e,r,s,o,a,l);h[0]=c,h[1]=p,h[2]=f.base,h[3]=1,Q(h,h,i),h[3]=Math.max(h[3],1e-5);const m=new zd(h[0]/h[3],h[1]/h[3],h[2]/h[3]);h[0]=c,h[1]=p,h[2]=f.top,h[3]=1,Q(h,h,i),h[3]=Math.max(h[3],1e-5);const y=new zd(h[0]/h[3],h[1]/h[3],h[2]/h[3]);t.push(m),d.push(y);}u.push(t),c.push(d);}return [u,c]}(e,r,n,i,s,o,a,l,u):function(t,e,r,n,i){const s=[],o=[],a=i[8]*e,l=i[9]*e,u=i[10]*e,c=i[11]*e,h=i[8]*r,p=i[9]*r,d=i[10]*r,f=i[11]*r;for(const e of t){const t=[],r=[];for(const s of e){const e=s.x+n.x,o=s.y+n.y,m=i[0]*e+i[4]*o+i[12],y=i[1]*e+i[5]*o+i[13],g=i[2]*e+i[6]*o+i[14],x=i[3]*e+i[7]*o+i[15],v=m+a,b=y+l,w=g+u,_=Math.max(x+c,1e-5),A=m+h,I=y+p,M=g+d,S=Math.max(x+f,1e-5);t.push(new zd(v/_,b/_,w/_)),r.push(new zd(A/S,I/S,M/S));}s.push(t),o.push(r);}return [s,o]}(e,r,n,i,s)}function Nd(t,e,r,n,i,s,o,a){const l=o*i.getElevationAt(t,e,!0,!0),u=0!==s[0],c=u?0===s[1]?o*(s[0]/id-sd):o*function(t,e,r){const n=Math.floor(e[0]/8),i=Math.floor(e[1]/8),s=10*(e[0]-8*n),o=10*(e[1]-8*i),a=t.getElevationAt(n,i,!0,!0),l=t.getMeterToDEM(r),u=Math.floor(.5*(s*l-1)),c=Math.floor(.5*(o*l-1)),h=t.tileCoordToPixel(n,i),p=2*u+1,d=2*c+1,f=function(t,e,r,n,i){return [t.getElevationAtPixel(e,r,!0),t.getElevationAtPixel(e+i,r,!0),t.getElevationAtPixel(e,r+i,!0),t.getElevationAtPixel(e+n,r+i,!0)]}(t,h.x-u,h.y-c,p,d),m=Math.abs(f[0]-f[1]),y=Math.abs(f[2]-f[3]),g=Math.abs(f[0]-f[2])+Math.abs(f[1]-f[3]),x=Math.min(.25,.5*l*(m+y)/p),v=Math.min(.25,.5*l*g/d);return a+Math.max(x*s,v*o)}(i,s,a):l;return {base:l+(0===r?-1:r),top:u?Math.max(c+n,l+r+2):l+n}}class jd{constructor(t){this._callback=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._callback();});}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._callback();}),0));}remove(){this._channel=void 0,this._callback=()=>{};}}class $d{constructor(){this.tasks={},this.taskQueue=[],Nt(["process"],this),this.invoker=new jd(this.process),this.nextId=0;}add(t,e){const r=this.nextId++,n=function({type:t,isSymbolTile:e,zoom:r}){return r=r||0,"message"===t?0:"maybePrepare"!==t||e?"parseTile"!==t||e?"parseTile"===t&&e?300-r:"maybePrepare"===t&&e?400-r:500:200-r:100-r}(e);if(0===n){try{t();}finally{}return null}return this.tasks[r]={fn:t,metadata:e,priority:n,id:r},this.taskQueue.push(r),this.invoker.trigger(),{cancel:()=>{delete this.tasks[r];}}}process(){try{if(this.taskQueue=this.taskQueue.filter((t=>!!this.tasks[t])),!this.taskQueue.length)return;const t=this.pick();if(null===t)return;const e=this.tasks[t];if(delete this.tasks[t],this.taskQueue.length&&this.invoker.trigger(),!e)return;e.fn();}finally{}}pick(){let t=null,e=1/0;for(let r=0;r<this.taskQueue.length;r++){const n=this.tasks[this.taskQueue[r]];n.priority<e&&(e=n.priority,t=r);}if(null===t)return null;const r=this.taskQueue[t];return this.taskQueue.splice(t,1),r}remove(){this.invoker.remove();}}class Gd{constructor(t,e,r){this.target=t,this.parent=e,this.mapId=r,this.callbacks={},this.cancelCallbacks={},Nt(["receive"],this),this.target.addEventListener("message",this.receive,!1),this.scheduler=new $d;}send(t,e,r,n,i=!1,s){const o=Math.round(1e18*Math.random()).toString(36).substring(0,10);r&&(r.metadata=s,this.callbacks[o]=r);const a=new Set;return this.target.postMessage({id:o,type:t,hasCallback:!!r,targetMapId:n,mustQueue:i,sourceMapId:this.mapId,data:eo(e,a)},a),{cancel:()=>{r&&delete this.callbacks[o],this.target.postMessage({id:o,type:"<cancel>",targetMapId:n,sourceMapId:this.mapId});}}}receive(t){const e=t.data;if(!e)return;const r=e.id;if(r&&(!e.targetMapId||this.mapId===e.targetMapId))if("<cancel>"===e.type){const t=this.cancelCallbacks[r];delete this.cancelCallbacks[r],t&&t.cancel();}else if(e.mustQueue||Kt(self)){const t=this.callbacks[r],n=this.scheduler.add((()=>this.processTask(r,e)),t&&t.metadata||{type:"message"});n&&(this.cancelCallbacks[r]=n);}else this.processTask(r,e);}processTask(t,e){if(delete this.cancelCallbacks[t],"<response>"===e.type){const r=this.callbacks[t];delete this.callbacks[t],r&&(e.error?r(ro(e.error)):r(null,ro(e.data)));}else {const r=new Set,n=e.hasCallback?(e,n)=>{this.target.postMessage({id:t,type:"<response>",sourceMapId:this.mapId,error:e?eo(e):null,data:eo(n,r)},r);}:()=>{},i=ro(e.data);if(this.parent[e.type])this.parent[e.type](e.sourceMapId,i,n);else if(this.parent.getWorkerSource){const t=e.type.split("."),{source:r,scope:s}=i;this.parent.getWorkerSource(e.sourceMapId,t[0],r,s)[t[1]](i,n);}else n(new Error(`Could not find function ${e.type}`));}}remove(){this.scheduler.remove(),this.target.removeEventListener("message",this.receive,!1);}}var qd={workerUrl:"",workerClass:null,workerParams:void 0};const Hd="mapboxgl_preloaded_worker_pool";class Xd{constructor(t){this.active={},this.name=t;}acquire(t,e=Xd.workerCount){if(!this.workers)for(this.workers=[];this.workers.length<e;){const e=(r=`${this.name||""}WorkerPool: ${t}-${this.workers.length}`,null!=qd.workerClass?new qd.workerClass:new self.Worker(qd.workerUrl,Object.assign({name:r},qd.workerParams)));this.workers.push(e);}var r;return this.active[t]=!0,this.workers.slice()}release(t){delete this.active[t],this.workers&&0===this.numActive()&&(this.workers.forEach((t=>{t.terminate();})),this.workers=null);}isPreloaded(){return !!this.active[Hd]}numActive(){return Object.keys(this.active).length}}Xd.workerCount=2;class Zd{constructor(t,e,r="Worker",n=Xd.workerCount){this.workerPool=t,this.actors=[],this.currentActor=0,this.id=Ot();const i=this.workerPool.acquire(this.id,n);for(let t=0;t<i.length;t++){const n=new Zd.Actor(i[t],e,this.id);n.name=`${r} ${t}`,this.actors.push(n);}this.ready=!1,this.broadcast("checkIfReady",null,(()=>{this.ready=!0;}));}broadcast(t,e,r){Rt(this.actors,((r,n)=>{r.send(t,e,n);}),r=r||function(){});}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(){this.actors.forEach((t=>{t.remove();})),this.actors=[],this.workerPool.release(this.id);}}let Wd,Yd;function Kd(){return Wd||(Wd=new Xd),Wd}Zd.Actor=Gd;const Jd=4096;class Qd{constructor(t){this.module=t,this.memoryStack=this.module.malloc(Jd),this.memoryStackNextFree=this.memoryStack;}createIntArray(t){const e=this.memoryStackNextFree;return this.memoryStackNextFree+=t.length*Int32Array.BYTES_PER_ELEMENT,this.memoryStackNextFree-this.memoryStack>Jd?-1:(new Int32Array(this.module.heap32.buffer,e,t.length).set(t),e)}createFloatArray(t){const e=this.memoryStackNextFree;return this.memoryStackNextFree+=t.length*Float32Array.BYTES_PER_ELEMENT,this.memoryStackNextFree-this.memoryStack>Jd?-1:(new Float32Array(this.module.heapF32.buffer,e,t.length).set(t),e)}readStringBuffer(t){let e="";for(;0!==this.module.heapU8[t];)e+=String.fromCharCode(this.module.heapU8[t]),++t;return e}setStyle(t){const e=t.normalScale;this.module.setStyle(e[0],e[1],e[2],t.tileToMeters);}setAOOptions(t,e){this.module.setAOOptions(t?1:0,e);}setMetricOptions(t,e){this.module.setMetricOptions(t?1:0,e);}setStructuralOptions(t){this.module.setStructuralOptions(t?1:0);}setFacadeOptions(t,e){this.module.setFacadeOptions(t,e?1:0);}setFauxFacadeOptions(t,e,r){this.module.setFauxFacadeOptions(t?1:0,e?1:0,r);}setFacadeClassifierOptions(t){this.module.setFacadeClassifierOptions(t);}generateMesh(t,e){this.memoryStackNextFree=this.memoryStack;for(const e of t){const t=this.createIntArray(e.ringIndices),r=this.createFloatArray(e.coordinates);if(-1===t||-1===r)return `building_gen: Out of stack memory: ${this.memoryStackNextFree-this.memoryStack}/4096`;this.module.addFeature(e.id,e.sourceId,e.minHeight,e.height,e.roofType,r,t,e.ringIndices.length-1);}for(const t of e){let e;e=t.entrances?JSON.parse(t.entrances):[];const r=this.createFloatArray(e),n=this.createFloatArray(t.coordinates);if(-1===r||-1===n)return `building_gen: Out of stack memory: ${this.memoryStackNextFree-this.memoryStack}/4096`;this.module.addFacade(t.sourceId,t.crossPerc,t.distanceToRoad,r,e.length,n,t.coordinates.length);}if(!this.module.generateMesh()){const t=this.module.getLastError();return this.readStringBuffer(t)}const r=this.module.getMeshCount(),n=new Array(r);for(let t=0;t<r;t++){const e=this.module.getPositionsPtr(t),r=this.module.getPositionsLength(t),i=new Float32Array(this.module.heapF32.buffer,e,r),s=this.module.getNormalsPtr(t),o=this.module.getNormalsLength(t),a=new Float32Array(this.module.heapF32.buffer,s,o),l=this.module.getAOPtr(t),u=this.module.getAOLength(t),c=new Float32Array(this.module.heapF32.buffer,l,u),h=this.module.getUVPtr(t),p=this.module.getUVLength(t),d=new Float32Array(this.module.heapF32.buffer,h,p),f=this.module.getFauxFacadePtr(t),m=this.module.getFauxFacadeLength(t),y=new Uint8Array(this.module.heapU8.buffer,f,m),g=this.module.getIndicesPtr(t),x=this.module.getIndicesLength(t),v=new Int16Array(this.module.heap16.buffer,g,x),b=this.module.getBuildingPart(t);n[t]={positions:i,normals:a,ao:c,uv:d,isFauxFacade:y,indices:v,buildingPart:b};}const i=this.module.getRingCount(),s=[];for(let t=0;t<i;t++){const e=this.module.getRingPtr(t),r=this.module.getRingLength(t),n=new Float32Array(this.module.heapF32.buffer,e,r);s.push(n);}return {meshes:n,outerRingLength:this.module.getOuterRingLength(),modifiedPolygonRings:s}}}let tf,ef,rf,nf,sf,of=null,af=null,lf=null,uf=null;function cf(){return Kt(self)&&self.worker.dracoUrl?self.worker.dracoUrl:ef||oe.DRACO_URL}function hf(){if(Kt(self)&&self.worker.meshoptUrl)return self.worker.meshoptUrl;if(nf)return nf;const t=new Uint8Array([0,97,115,109,1,0,0,0,1,4,1,96,0,0,3,3,2,0,0,5,3,1,0,1,12,1,0,10,22,2,12,0,65,0,65,0,65,0,252,10,0,0,11,7,0,65,0,253,15,26,11]);if("object"!=typeof WebAssembly)throw new Error("WebAssembly not supported, cannot instantiate meshoptimizer");return nf=WebAssembly.validate(t)?oe.MESHOPT_SIMD_URL:oe.MESHOPT_URL,nf}function pf(){return uf}const df={5120:Int8Array,5121:Uint8Array,5122:Int16Array,5123:Uint16Array,5125:Uint32Array,5126:Float32Array},ff={5120:"DT_INT8",5121:"DT_UINT8",5122:"DT_INT16",5123:"DT_UINT16",5125:"DT_UINT32",5126:"DT_FLOAT32"},mf={SCALAR:1,VEC2:2,VEC3:3,VEC4:4,MAT2:4,MAT3:9,MAT4:16};function yf(t,e,r){const n=r.json.bufferViews.length,i=r.buffers.length;e.bufferView=n,r.json.bufferViews[n]={buffer:i,byteLength:t.byteLength},r.buffers[i]=t;}const gf="KHR_draco_mesh_compression";function xf(t,e){const r=t.extensions&&t.extensions[gf];if(!r)return;const n=new rf.Decoder,i=Mf(e,r.bufferView),s=new rf.Mesh;if(!n.DecodeArrayToMesh(i,i.byteLength,s))throw new Error("Failed to decode Draco mesh");const o=e.json.accessors[t.indices],a=df[o.componentType],l=o.count*a.BYTES_PER_ELEMENT,u=rf._malloc(l);a===Uint16Array?n.GetTrianglesUInt16Array(s,l,u):n.GetTrianglesUInt32Array(s,l,u),yf(rf.memory.buffer.slice(u,u+l),o,e),rf._free(u);for(const i of Object.keys(r.attributes)){const o=n.GetAttributeByUniqueId(s,r.attributes[i]),a=e.json.accessors[t.attributes[i]],l=ff[a.componentType],u=a.count*mf[a.type]*df[a.componentType].BYTES_PER_ELEMENT,c=rf._malloc(u);n.GetAttributeDataArrayForAllPoints(s,o,rf[l],u,c),yf(rf.memory.buffer.slice(c,c+u),a,e),rf._free(c);}n.destroy(),s.destroy(),delete t.extensions[gf];}const vf="EXT_meshopt_compression";function bf(t,e){if(!t.extensions||!t.extensions[vf])return;const r=t.extensions[vf],n=new Uint8Array(e.buffers[r.buffer],r.byteOffset||0,r.byteLength||0),i=new Uint8Array(r.count*r.byteStride);sf.decodeGltfBuffer(i,r.count,r.byteStride,n,r.mode,r.filter),t.buffer=e.buffers.length,t.byteOffset=0,e.buffers[t.buffer]=i.buffer,delete t.extensions[vf];}const wf=1179937895,_f=new TextDecoder("utf8");function Af(t,e){return new URL(t,e).href}function If(t,e,r,n){return fetch(Af(t.uri,n)).then((t=>t.arrayBuffer())).then((t=>{e.buffers[r]=t;}))}function Mf(t,e){const r=t.json.bufferViews[e];return new Uint8Array(t.buffers[r.buffer],r.byteOffset||0,r.byteLength)}function Sf(t,e,r,n){if(t.uri){const i=Af(t.uri,n);return fetch(i).then((t=>t.blob())).then((t=>createImageBitmap(t))).then((t=>{e.images[r]=t;}))}if(void 0!==t.bufferView){const n=Mf(e,t.bufferView),i=new Blob([n],{type:t.mimeType});return createImageBitmap(i).then((t=>{e.images[r]=t;}))}}function Pf(t,e=0,r){const n={json:null,images:[],buffers:[]};if(new Uint32Array(t,e,1)[0]===wf){const r=new Uint32Array(t,e);let i=2;const s=(r[i++]>>2)-3,o=r[i++]>>2;if(i++,n.json=JSON.parse(_f.decode(r.subarray(i,i+o))),i+=o,i<s){const s=r[i++];i++;const o=e+(i<<2);n.buffers[0]=t.slice(o,o+s);}}else n.json=JSON.parse(_f.decode(new Uint8Array(t,e)));const{buffers:i,images:s,meshes:o,extensionsUsed:a,bufferViews:l}=n.json;let u=Promise.resolve();if(i){const t=[];for(let e=0;e<i.length;e++){const s=i[e];s.uri?t.push(If(s,n,e,r)):n.buffers[e]||(n.buffers[e]=null);}u=Promise.all(t);}return u.then((()=>{const t=[],e=a&&a.includes(gf),i=a&&a.includes(vf);if(e&&t.push(function(){if(!rf)return null!=tf?tf:(tf=function(t){let e,r=null;function n(){e=new Uint8Array(r.buffer);}function i(){throw new Error("Unexpected Draco error.")}const s={a:{a:i,d:function(t,r,n){return e.copyWithin(t,r,r+n)},c:function(t){const i=e.length,s=Math.max(t>>>0,Math.ceil(1.2*i)),o=Math.ceil((s-i)/65536);try{return r.grow(o),n(),!0}catch(t){return !1}},b:i}};return (WebAssembly.instantiateStreaming?WebAssembly.instantiateStreaming(t,s):t.then((t=>t.arrayBuffer())).then((t=>WebAssembly.instantiate(t,s)))).then((t=>{const{Rb:i,Qb:s,P:o,T:a,X:l,Ja:u,La:c,Qa:h,Va:p,Wa:d,eb:f,jb:m,f:y,e:g,yb:x,zb:v,Ab:b,Bb:w,Db:_,Gb:A}=t.instance.exports;r=g;const I=(()=>{let t=0,r=0,n=0,o=0;return a=>{n&&(i(o),i(t),r+=n,n=t=0),t||(r+=128,t=s(r));const l=a.length+7&-8;let u=t;l>=r&&(n=l,u=o=s(l));for(let t=0;t<a.length;t++)e[u+t]=a[t];return u}})();return n(),y(),{memory:g,_free:i,_malloc:s,Mesh:class{constructor(){this.ptr=o();}destroy(){a(this.ptr);}},Decoder:class{constructor(){this.ptr=u();}destroy(){m(this.ptr);}DecodeArrayToMesh(t,e,r){const n=I(t),i=c(this.ptr,n,e,r.ptr);return !!l(i)}GetAttributeByUniqueId(t,e){return {ptr:h(this.ptr,t.ptr,e)}}GetTrianglesUInt16Array(t,e,r){p(this.ptr,t.ptr,e,r);}GetTrianglesUInt32Array(t,e,r){d(this.ptr,t.ptr,e,r);}GetAttributeDataArrayForAllPoints(t,e,r,n,i){f(this.ptr,t.ptr,e.ptr,r,n,i);}},DT_INT8:x(),DT_UINT8:v(),DT_INT16:b(),DT_UINT16:w(),DT_UINT32:_(),DT_FLOAT32:A()}}))}(fetch(cf())),tf.then((t=>{rf=t,tf=void 0;})))}()),i&&t.push(function(){if(sf)return;const t=function(t){let e;const r=WebAssembly.instantiateStreaming(t,{}).then((t=>{e=t.instance,e.exports.__wasm_call_ctors();})),n={NONE:"",OCTAHEDRAL:"meshopt_decodeFilterOct",QUATERNION:"meshopt_decodeFilterQuat",EXPONENTIAL:"meshopt_decodeFilterExp"},i={ATTRIBUTES:"meshopt_decodeVertexBuffer",TRIANGLES:"meshopt_decodeIndexBuffer",INDICES:"meshopt_decodeIndexSequence"};return {ready:r,supported:!0,decodeGltfBuffer(t,r,s,o,a,l){!function(t,e,r,n,i,s,o){const a=t.exports.sbrk,l=n+3&-4,u=a(l*i),c=a(s.length),h=new Uint8Array(t.exports.memory.buffer);h.set(s,c);const p=e(u,n,i,c,s.length);if(0===p&&o&&o(u,l,i),r.set(h.subarray(u,u+n*i)),a(u-a(0)),0!==p)throw new Error(`Malformed buffer data: ${p}`)}(e,e.exports[i[a]],t,r,s,o,e.exports[n[l]]);}}}(fetch(hf()));return t.ready.then((()=>{sf=t;}))}()),s)for(let e=0;e<s.length;e++)t.push(Sf(s[e],n,e,r));return (t.length?Promise.all(t):Promise.resolve()).then((()=>{if(e&&o)for(const{primitives:t}of o)for(const e of t)xf(e,n);if(i&&o&&l)for(const t of l)bf(t,n);return n}))}))}function kf(t){return fetch(t).then((t=>t.arrayBuffer())).then((e=>Pf(e,0,t)))}function Bf(t){switch(t){case WebGL2RenderingContext.RGBA8:return WebGL2RenderingContext.RGBA;case WebGL2RenderingContext.DEPTH_COMPONENT16:return WebGL2RenderingContext.DEPTH_COMPONENT;case WebGL2RenderingContext.DEPTH24_STENCIL8:return WebGL2RenderingContext.DEPTH_STENCIL;case WebGL2RenderingContext.R8:case WebGL2RenderingContext.R32F:return WebGL2RenderingContext.RED}}function zf(t){switch(t){case WebGL2RenderingContext.RGBA8:return WebGL2RenderingContext.UNSIGNED_BYTE;case WebGL2RenderingContext.DEPTH_COMPONENT16:return WebGL2RenderingContext.UNSIGNED_SHORT;case WebGL2RenderingContext.DEPTH24_STENCIL8:return WebGL2RenderingContext.UNSIGNED_INT_24_8;case WebGL2RenderingContext.R8:return WebGL2RenderingContext.UNSIGNED_BYTE;case WebGL2RenderingContext.R32F:return WebGL2RenderingContext.FLOAT}}class Tf{constructor(t,e,r,n){this.context=t,this.format=r,this.useMipmap=n&&n.useMipmap,this.texture=t.gl.createTexture(),this.update(e,{premultiply:n&&n.premultiply});}update(t,e){const r=t&&t instanceof HTMLVideoElement&&0===t.width?t.videoWidth:t.width,n=t&&t instanceof HTMLVideoElement&&0===t.height?t.videoHeight:t.height,{context:i}=this,{gl:s}=i,{x:o,y:a}=e&&e.position?e.position:{x:0,y:0},l=o+r,u=a+n;!this.size||this.size[0]===l&&this.size[1]===u||(s.bindTexture(s.TEXTURE_2D,null),s.deleteTexture(this.texture),this.texture=s.createTexture(),this.size=null),s.bindTexture(s.TEXTURE_2D,this.texture),i.pixelStoreUnpackFlipY.set(!1),i.pixelStoreUnpack.set(1),i.pixelStoreUnpackPremultiplyAlpha.set(this.format===s.RGBA8&&(!e||!1!==e.premultiply));const c=t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||ImageBitmap&&t instanceof ImageBitmap;if(!this.size&&l>0&&u>0){const t=this.useMipmap?Math.floor(Math.log2(Math.max(l,u)))+1:1;s.texStorage2D(s.TEXTURE_2D,t,this.format,l,u),this.size=[l,u];}this.size&&(c?s.texSubImage2D(s.TEXTURE_2D,0,o,a,Bf(this.format),zf(this.format),t):"data"in t&&t.data&&s.texSubImage2D(s.TEXTURE_2D,0,o,a,r,n,Bf(this.format),zf(this.format),t.data)),this.useMipmap&&s.generateMipmap(s.TEXTURE_2D);}bind(t,e,r=!1){const{context:n}=this,{gl:i}=n;i.bindTexture(i.TEXTURE_2D,this.texture),t!==this.minFilter&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,t),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,this.useMipmap&&!r?t===i.NEAREST?i.NEAREST_MIPMAP_NEAREST:i.LINEAR_MIPMAP_LINEAR:t),this.minFilter=t),e!==this.wrapS&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,e),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,e),this.wrapS=e);}bindExtraParam(t,e,r,n,i){const{context:s}=this,{gl:o}=s;o.bindTexture(o.TEXTURE_2D,this.texture),e!==this.magFilter&&(o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MAG_FILTER,e),this.magFilter=e),t!==this.minFilter&&(o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MIN_FILTER,this.useMipmap?t===o.NEAREST?o.NEAREST_MIPMAP_NEAREST:o.LINEAR_MIPMAP_LINEAR:t),this.minFilter=t),r!==this.wrapS&&(o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_S,r),this.wrapS=r),n!==this.wrapT&&(o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_T,n),this.wrapT=n),i!==this.compareMode&&(i?(o.texParameteri(o.TEXTURE_2D,o.TEXTURE_COMPARE_MODE,o.COMPARE_REF_TO_TEXTURE),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_COMPARE_FUNC,i)):o.texParameteri(o.TEXTURE_2D,o.TEXTURE_COMPARE_MODE,o.NONE),this.compareMode=i);}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}}class Ef{constructor(t,e){this.context=t,this.texture=e;}bind(t,e){const{context:r}=this,{gl:n}=r;n.bindTexture(n.TEXTURE_2D,this.texture),t!==this.minFilter&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,t),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,t),this.minFilter=t),e!==this.wrapS&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,e),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,e),this.wrapS=e);}}const Vf=ha([{name:"a_pos_3f",components:3,type:"Float32"}]),Ff=ha([{name:"a_color_3f",components:3,type:"Float32"}]),Cf=ha([{name:"a_color_4f",components:4,type:"Float32"}]),Df=ha([{name:"a_uv_2f",components:2,type:"Float32"}]),Rf=ha([{name:"a_normal_3f",components:3,type:"Float32"}]),Lf=ha([{name:"a_normal_matrix0",components:4,type:"Float32"},{name:"a_normal_matrix1",components:4,type:"Float32"},{name:"a_normal_matrix2",components:4,type:"Float32"},{name:"a_normal_matrix3",components:4,type:"Float32"}]),Of=ha([{name:"a_pbr",components:4,type:"Uint16"},{name:"a_heightBasedEmissiveStrength",components:3,type:"Float32"}]);function Uf(t,e){const r=jf(t.projection,t.zoom,t.width,t.height),n=function(t,e,r,n,i){const s=new iu(r.lng-180*$f,r.lat),o=new iu(r.lng+180*$f,r.lat),a=t.project(s.lng,s.lat),l=t.project(o.lng,o.lat),c=-Math.atan2(l.y-a.y,l.x-a.x),p=bu.fromLngLat(r);p.y=Ft(p.y,-1+$f,1-$f);const f=p.toLngLat(),m=t.project(f.lng,f.lat),g=bu.fromLngLat(f);g.x+=$f;const x=g.toLngLat(),v=t.project(x.lng,x.lat),b=qf(v.x-m.x,v.y-m.y,c),w=bu.fromLngLat(f);w.y+=$f;const _=w.toLngLat(),A=t.project(_.lng,_.lat),I=qf(A.x-m.x,A.y-m.y,c),M=Math.abs(b.x)/Math.abs(I.y),S=u([]);y(S,S,-c*(1-(i?0:n)));const P=u([]);return d(P,P,[1,1-(1-M)*n,1]),P[4]=-I.x/I.y*n,y(P,P,c),h(P,S,P),P}(t.projection,0,t.center,r,e),i=Nf(t);return d(n,n,[i,i,1]),n}function Nf(t){const e=t.projection,r=jf(t.projection,t.zoom,t.width,t.height),n=Gf(e,t.center),i=Gf(e,iu.convert(e.center));return Math.pow(2,n*r+(1-r)*i)}function jf(t,e,r,n,i=1/0){const s=t.range;if(!s)return 0;const o=Math.min(i,Math.max(r,n)),a=Math.log2(o/1024);return Ct(s[0]+a,s[1]+a,e)}const $f=1/4e4;function Gf(t,e){const r=Ft(e.lat,-mu,mu),n=new iu(e.lng-180*$f,r),i=new iu(e.lng+180*$f,r),s=t.project(n.lng,r),o=t.project(i.lng,r),a=bu.fromLngLat(n),l=bu.fromLngLat(i),u=o.x-s.x,c=o.y-s.y,h=l.x-a.x,p=l.y-a.y,d=Math.sqrt((h*h+p*p)/(u*u+c*c));return Math.log2(d)}function qf(t,e,r){const n=Math.cos(r),i=Math.sin(r);return {x:t*n-e*i,y:t*i+e*n}}function Hf(t,e,r){u(t),y(t,t,kt(e[2])),f(t,t,kt(e[0])),m(t,t,kt(e[1])),d(t,t,r),h(t,t,[1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1]);}function Xf(t,e,r,n,i,s,o,a){const l=[r[0]-e[0],r[1]-e[1],0],u=[n[0]-e[0],n[1]-e[1],0];if(I(l)<1e-12||I(u)<1e-12)return et(t);const c=U([],l,u);L(c,c),k(u,n,e),l[2]=(s-i)*a,u[2]=(o-i)*a;const h=l;return U(h,l,u),L(h,h),lt(t,c,h)}function Zf(t,e,r=!1){const n=eh(e.zoom),i=function(t,e,r){const n=e.worldSize,i=[t[12],t[13],t[14]],s=du(i[1]/n),o=pu(i[0]/n),a=u([]),l=hu(1,s)*n,c=hu(1,0)*n*gu(s,e.zoom),f=1/Jc(n);let m=c*f;if(r){const t=jf(e.projection,e.zoom,e.width,e.height,1024);m=f*e.projection.pixelSpaceConversion(e.center.lat,n,t);}const y=eu(s,o);P(y,y,E([],L([],y),l*m*i[2]));const g=function(t){const e=[t[0],t[1],t[2]];let r=[0,1,0];const n=U([],r,e);return U(r,e,n),0===D(r)&&(r=[0,1,0],U(n,e,r)),L(n,n),L(r,r),L(e,e),[n[0],n[1],n[2],0,r[0],r[1],r[2],0,e[0],e[1],e[2],0,t[0],t[1],t[2],1]}(y);d(a,a,[m,m,m*l]),p(a,a,[-i[0],-i[1],-i[2]]);const x=h([],e.globeMatrix,g);return h(x,x,a),h(x,x,t),x}(t,e,r);if(n>0){const r=function(t,e){const r=e.worldSize,n=hu(1,0)*r*gu(e.center.lat,e.zoom)/Jc(r),i=hu(1,e.center.lat)*r,s=u([]);m(s,s,kt(e.center.lng)),f(s,s,kt(e.center.lat)),p(s,s,[0,0,Hl]),d(s,s,[n,n,n*i]);const o=e.point;return p(s,s,[-o.x,-o.y,0]),h(s,s,t),h(s,e.globeMatrix,s)}(t,e);return function(t,e,r){const n=(t,e,r)=>{const n=I(t),i=I(e),s=jc(t,e,r);return E(s,s,1/I(s)*pr(n,i,r))},i=n([t[0],t[1],t[2]],[e[0],e[1],e[2]],r),s=n([t[4],t[5],t[6]],[e[4],e[5],e[6]],r),o=n([t[8],t[9],t[10]],[e[8],e[9],e[10]],r),a=jc([t[12],t[13],t[14]],[e[12],e[13],e[14]],r);return [i[0],i[1],i[2],0,s[0],s[1],s[2],0,o[0],o[1],o[2],0,a[0],a[1],a[2],1]}(i,r,n)}return i}function Wf(t,e,r,n){const i=Ju.projectAabbCorners(n,r);let s=Number.MAX_VALUE;for(let t=0;t<i.length;++t){const r=i[t];r[0]=(.5*r[0]+.5)*e.width,r[1]=(.5-.5*r[1])*e.height,r[2]<s&&(s=r[2]);}const o=function(t){const e=[];let r=0;for(let e=1;e<t.length;e++)(t[e][0]<t[r][0]||t[e][0]===t[r][0]&&t[e][1]<t[r][1])&&(r=e);let n,i=r;const s=new Uint8Array(t.length);do{if(s[i])break;e.push(new It(t[i][0],t[i][1])),s[i]=1,n=(i+1)%t.length;for(let e=0;e<t.length;e++){if(t[e][0]===t[n][0]&&t[e][1]===t[n][1]||t[e][0]===t[i][0]&&t[e][1]===t[i][1])continue;const r=[t[e][0]-t[i][0],t[e][1]-t[i][1]],s=[t[n][0]-t[i][0],t[n][1]-t[i][1]],o=r[0]*s[1]-r[1]*s[0];(o>0||0===o&&r[0]*s[0]+r[1]*s[1]>=0&&r[0]*r[0]+r[1]*r[1]>s[0]*s[0]+s[1]*s[1])&&(n=e);}i=n;}while(i!==r);return e.length>0&&e.push(e[0]),e}(i);if(ic(t,o))return s}const Yf=64,Kf={CoordinateSpaceTile:1,HasMapboxMeshFeatures:4,HasMeshoptCompression:8};function Jf(t,e,r,n,i,s,o,a,l,c=!1){const f=r.zoom,m=r.project(n),y=gu(n.lat,f),g=1/y;u(t),p(t,t,[m.x+o[0]*g,m.y+o[1]*g,o[2]]);let x=1,v=1;const w=r.worldSize;if(c){if("mercator"===r.projection.name){let t=0;r.elevation&&(t=r.elevation.getAtPointOrZero(new bu(m.x/w,m.y/w),0));const e=Q([],[m.x,m.y,t,1],r.projMatrix)[3]/r.cameraToCenterDistance;x=e,v=e*gu(r.center.lat,f);}else if("globe"===r.projection.name){const e=Zf(t,r),i=[0,0,0,1];Q(i,i,h([],r.projMatrix,e));const s=i[3]/r.cameraToCenterDistance,o=eh(f),a=r.projection.pixelsPerMeter(n.lat,w)*gu(n.lat,f),l=r.projection.pixelsPerMeter(r.center.lat,w)*gu(r.center.lat,f);x=s/pr(a,yu(r.center.lat),o),v=s*y/a,x*=l,v*=l;}}else x=g;d(t,t,[x,x,v]);const _=[...t],A=e.orientation,I=[];if(Hf(I,[A[0]+(i?i[0]:0),A[1]+(i?i[1]:0),A[2]+(i?i[2]:0)],s),h(t,_,I),a&&r.elevation){let i=0;const s=[];if(l&&r.elevation){i=function(t,e,r,n,i){const s=e.elevation;if(!s)return 0;const o=Ju.projectAabbCorners(r,n),a=hu(1,i.lat)*e.worldSize,l=function(t,e){const r=[0,0,1],n=[{corners:[0,1,3,2],dotProductWithUp:0},{corners:[1,5,2,6],dotProductWithUp:0},{corners:[0,4,1,5],dotProductWithUp:0},{corners:[2,6,3,7],dotProductWithUp:0},{corners:[4,7,5,6],dotProductWithUp:0},{corners:[0,3,4,7],dotProductWithUp:0}];for(const i of n){const n=t[i.corners[0]],s=t[i.corners[1]],o=t[i.corners[2]],a=[s[0]-n[0],s[1]-n[1],e*(s[2]-n[2])],l=U(a,a,[o[0]-n[0],o[1]-n[1],e*(o[2]-n[2])]);L(l,l),i.dotProductWithUp=O(l,r);}return n.sort(((t,e)=>t.dotProductWithUp-e.dotProductWithUp)),n[0].corners}(o,a),u=o[l[0]],c=o[l[1]],h=o[l[2]],p=o[l[3]],d=s.getAtPointOrZero(new bu(u[0]/e.worldSize,u[1]/e.worldSize),0),f=s.getAtPointOrZero(new bu(c[0]/e.worldSize,c[1]/e.worldSize),0),m=s.getAtPointOrZero(new bu(h[0]/e.worldSize,h[1]/e.worldSize),0),y=s.getAtPointOrZero(new bu(p[0]/e.worldSize,p[1]/e.worldSize),0),g=(d+y)/2,x=(f+m)/2;return g>x?f<m?Xf(t,c,p,u,f,y,d,a):Xf(t,h,u,p,m,d,y,a):d<y?Xf(t,u,c,h,d,f,m,a):Xf(t,p,h,c,y,m,f,a),Math.max(g,x)}(s,r,e.aabb,t,n);const o=h([],b([],s),I);h(t,_,o);}else i=r.elevation.getAtPointOrZero(new bu(m.x/w,m.y/w),0);0!==i&&(t[14]+=i);}}class Qf{constructor(t,e,r,n,i){this.materialOverrides=new Map,this.nodeOverrides=new Map,this.materialOverrideNames=[],this.nodeOverrideNames=[],this.featureProperties={},this.id=t,this.uri=e,this.position=null!=r?new iu(r[0],r[1]):new iu(0,0),this.orientation=null!=n?n:[0,0,0],this.nodes=i,this.uploaded=!1,this.aabb=new Ju([1/0,1/0,1/0],[-1/0,-1/0,-1/0]),this.matrix=[];}_applyTransformations(t,e){h(t.globalMatrix,e,t.localMatrix);const r=this.nodeOverrides.get(t.name);if(void 0!==r){const e=[];i=r.orientation,u(n=e),m(n,n,kt(i[1])),y(n,n,kt(i[2])),f(n,n,kt(i[0])),h(t.globalMatrix,t.globalMatrix,e);}var n,i;if(t.meshes)for(const e of t.meshes){const r=Ju.applyTransformFast(e.aabb,t.globalMatrix);this.aabb.encapsulate(r);}if(t.children)for(const e of t.children)this._applyTransformations(e,t.globalMatrix);}computeBoundsAndApplyParent(){const t=u([]);this.aabb=new Ju([1/0,1/0,1/0],[-1/0,-1/0,-1/0]);for(const e of this.nodes)this._applyTransformations(e,t);}computeModelMatrix(t,e,r,n,i,s,o=!1){Jf(this.matrix,this,t.transform,this.position,e,r,n,i,s,o);}upload(t){if(!this.uploaded){for(const e of this.nodes)rm(e,t);for(const t of this.nodes)nm(t);this.uploaded=!0;}}destroy(){for(const t of this.nodes)im(t);}}function tm(t,e,r=!1){t.uploaded||(t.gfxTexture=new Tf(e,t.image,r?e.gl.R8:e.gl.RGBA8,{useMipmap:t.sampler.minFilter>=e.gl.NEAREST_MIPMAP_NEAREST}),t.uploaded=!0,t.image=null);}function em(t,e,r){t.indexBuffer=e.createIndexBuffer(t.indexArray,!1,!0),t.vertexBuffer=e.createVertexBuffer(t.vertexArray,Vf.members,!1,!0),t.normalArray&&(t.normalBuffer=e.createVertexBuffer(t.normalArray,Rf.members,!1,!0)),t.texcoordArray&&(t.texcoordBuffer=e.createVertexBuffer(t.texcoordArray,Df.members,!1,!0)),t.colorArray&&(t.colorBuffer=e.createVertexBuffer(t.colorArray,(12===t.colorArray.bytesPerElement?Ff:Cf).members,!1,!0)),t.featureArray&&(t.pbrBuffer=e.createVertexBuffer(t.featureArray,Of.members,!0)),t.segments=hl.simpleSegment(0,0,t.vertexArray.length,t.indexArray.length);const n=t.material;n.pbrMetallicRoughness.baseColorTexture&&tm(n.pbrMetallicRoughness.baseColorTexture,e),n.pbrMetallicRoughness.metallicRoughnessTexture&&tm(n.pbrMetallicRoughness.metallicRoughnessTexture,e),n.normalTexture&&tm(n.normalTexture,e),n.occlusionTexture&&tm(n.occlusionTexture,e,r),n.emissionTexture&&tm(n.emissionTexture,e);}function rm(t,e,r){if(t.meshes)for(const n of t.meshes)em(n,e,r);if(t.children)for(const n of t.children)rm(n,e,r);}function nm(t){if(t.meshes)for(const e of t.meshes)e.indexArray.destroy(),e.vertexArray.destroy(),e.colorArray&&e.colorArray.destroy(),e.normalArray&&e.normalArray.destroy(),e.texcoordArray&&e.texcoordArray.destroy(),e.featureArray&&e.featureArray.destroy();if(t.children)for(const e of t.children)nm(e);}function im(t){if(t.meshes)for(const r of t.meshes)r.vertexBuffer&&(r.vertexBuffer.destroy(),r.indexBuffer.destroy(),r.normalBuffer&&r.normalBuffer.destroy(),r.texcoordBuffer&&r.texcoordBuffer.destroy(),r.colorBuffer&&r.colorBuffer.destroy(),r.pbrBuffer&&r.pbrBuffer.destroy(),r.segments.destroy(),r.material&&((e=r.material).pbrMetallicRoughness.baseColorTexture&&e.pbrMetallicRoughness.baseColorTexture.gfxTexture&&e.pbrMetallicRoughness.baseColorTexture.gfxTexture.destroy(),e.pbrMetallicRoughness.metallicRoughnessTexture&&e.pbrMetallicRoughness.metallicRoughnessTexture.gfxTexture&&e.pbrMetallicRoughness.metallicRoughnessTexture.gfxTexture.destroy(),e.normalTexture&&e.normalTexture.gfxTexture&&e.normalTexture.gfxTexture.destroy(),e.emissionTexture&&e.emissionTexture.gfxTexture&&e.emissionTexture.gfxTexture.destroy(),e.occlusionTexture&&e.occlusionTexture.gfxTexture&&e.occlusionTexture.gfxTexture.destroy()));var e;if(t.children)for(const e of t.children)im(e);}function sm(t,e){const r=t.json.bufferViews[e.bufferView],n=df[e.componentType];return new n(t.buffers[r.buffer],(e.byteOffset||0)+(r.byteOffset||0),e.count*(r.byteStride&&r.byteStride!==mf[e.type]*n.BYTES_PER_ELEMENT?r.byteStride/n.BYTES_PER_ELEMENT:mf[e.type]))}function om(t,e,r,n){const i=df[e.componentType],s=function(t){switch(t){case Int8Array:return 1/127;case Uint8Array:return 1/255;case Int16Array:return 1/32767;case Uint16Array:return 1/65535;default:return 1}}(i),o=t.json.bufferViews[e.bufferView],a=o.byteStride?o.byteStride/i.BYTES_PER_ELEMENT:mf[e.type],l=r.float32,u=l.length/r.capacity;for(let t=0,r=0;t<e.count*a;t+=a,r+=u)for(let e=0;e<u;e++)l[r+e]=n[t+e]*s;r._trim();}function am(t,e,r){const n=t.indices,i=t.attributes,s={};s.indexArray=new Fa;const o=e.json.accessors[n],a=o.count/3;s.indexArray.reserve(a);const l=sm(e,o);for(let t=0;t<a;t++)s.indexArray.emplaceBack(l[3*t],l[3*t+1],l[3*t+2]);s.indexArray._trim(),s.vertexArray=new wa;const u=e.json.accessors[i.POSITION];s.vertexArray.reserve(u.count);const c=sm(e,u);for(let t=0;t<u.count;t++)s.vertexArray.emplaceBack(c[3*t],c[3*t+1],c[3*t+2]);if(s.vertexArray._trim(),s.aabb=new Ju(u.min,u.max),s.centroid=function(t,e){const r=[0,0,0],n=t.length;if(n>0){for(let i=0;i<n;i++){const n=3*t[i];r[0]+=e[n],r[1]+=e[n+1],r[2]+=e[n+2];}r[0]/=n,r[1]/=n,r[2]/=n;}return r}(l,c),void 0!==i.COLOR_0){const t=e.json.accessors[i.COLOR_0],r=mf[t.type],n=sm(e,t);s.colorArray=3===r?new wa:new Pa,s.colorArray.resize(t.count),om(e,t,s.colorArray,n);}if(void 0!==i.NORMAL){s.normalArray=new wa;const t=e.json.accessors[i.NORMAL];s.normalArray.resize(t.count);const r=sm(e,t);om(e,t,s.normalArray,r);}if(void 0!==i.TEXCOORD_0&&r.length>0){s.texcoordArray=new ja;const t=e.json.accessors[i.TEXCOORD_0];s.texcoordArray.resize(t.count);const r=sm(e,t);om(e,t,s.texcoordArray,r);}if(void 0!==i._FEATURE_ID_RGBA4444){const t=e.json.accessors[i._FEATURE_ID_RGBA4444];e.json.extensionsUsed&&e.json.extensionsUsed.includes("EXT_meshopt_compression")&&(s.featureData=sm(e,t));}void 0!==i._FEATURE_RGBA4444&&(s.featureData=new Uint32Array(sm(e,e.json.accessors[i._FEATURE_RGBA4444]).buffer));const h=t.material;return s.material=function(t,e){const{emissiveFactor:r=[0,0,0],alphaMode:n="OPAQUE",alphaCutoff:i=.5,normalTexture:s,occlusionTexture:o,emissiveTexture:a,doubleSided:l,name:u}=t,{baseColorFactor:c=[1,1,1,1],metallicFactor:h=1,roughnessFactor:p=1,baseColorTexture:d,metallicRoughnessTexture:f}=t.pbrMetallicRoughness||{},m=o?e[o.index]:void 0;if(o&&o.extensions&&o.extensions.KHR_texture_transform&&m){const t=o.extensions.KHR_texture_transform;m.offsetScale=[t.offset[0],t.offset[1],t.scale[0],t.scale[1]];}return {name:u,pbrMetallicRoughness:{baseColorFactor:new lr(...c),metallicFactor:h,roughnessFactor:p,baseColorTexture:d?e[d.index]:void 0,metallicRoughnessTexture:f?e[f.index]:void 0},doubleSided:l,emissiveFactor:new lr(...r),alphaMode:n,alphaCutoff:i,normalTexture:s?e[s.index]:void 0,occlusionTexture:m,emissionTexture:a?e[a.index]:void 0,defined:void 0===t.defined}}(void 0!==h?e.json.materials[h]:{defined:!1},r),s}function lm(t,e,r){const{matrix:n,rotation:i,translation:s,scale:o,mesh:a,extras:u,children:c,name:h}=t,p={};if(p.name=h,p.localMatrix=n||function(t,e,r,n){var i=e[0],s=e[1],o=e[2],a=e[3],l=i+i,u=s+s,c=o+o,h=i*l,p=i*u,d=i*c,f=s*u,m=s*c,y=o*c,g=a*l,x=a*u,v=a*c,b=n[0],w=n[1],_=n[2];return t[0]=(1-(f+y))*b,t[1]=(p+v)*b,t[2]=(d-x)*b,t[3]=0,t[4]=(p-v)*w,t[5]=(1-(h+y))*w,t[6]=(m+g)*w,t[7]=0,t[8]=(d+x)*_,t[9]=(m-g)*_,t[10]=(1-(h+f))*_,t[11]=0,t[12]=r[0],t[13]=r[1],t[14]=r[2],t[15]=1,t}([],i||[0,0,0,1],s||[0,0,0],o||[1,1,1]),p.globalMatrix=l(p.localMatrix),void 0!==a){p.meshes=r[a];const t=p.anchor=[0,0];for(const e of p.meshes){const{min:r,max:n}=e.aabb;t[0]+=r[0]+n[0],t[1]+=r[1]+n[1];}t[0]=Math.floor(t[0]/p.meshes.length/2),t[1]=Math.floor(t[1]/p.meshes.length/2);}if(u&&(u.id&&(p.id=u.id),u.lights&&(p.lights=function(t){if(!t.length)return [];const e=function(t){const e=atob(t),r=new Uint8Array(e.length);for(let t=0;t<e.length;t++)r[t]=e.codePointAt(t);return r}(t),r=[],n=e.length/24,i=new Uint16Array(e.buffer),s=new Float32Array(e.buffer);for(let t=0;t<n;t++){const e=i[2*t*6]/30,n=i[2*t*6+1]/30,o=i[2*t*6+10]/100,a=s[6*t+1],l=s[6*t+2],u=s[6*t+3],c=s[6*t+4],h=u-a,p=c-l,d=Math.hypot(h,p);r.push({pos:[a+.5*h,l+.5*p,n],normal:[p/d,-h/d,0],width:d,height:e,depth:o,points:[a,l,u,c]});}return r}(u.lights)),u.MAPBOX_geometry_bloom&&(p.isGeometryBloom=u.MAPBOX_geometry_bloom)),c){const t=[];for(const n of c)t.push(lm(e.json.nodes[n],e,r));p.children=t;}return p}function um(t){if(0===t.vertices.length||0===t.indices.length)return null;const e=new Mp(t.vertices,t.indices,8,256),[r,n]=[e.min.clone(),e.max.clone()];return {vertices:t.vertices,indices:t.indices,grid:e,min:r,max:n}}function cm(t){if(!t.extras||!t.extras.ground)return null;const e=t.extras.ground;if(!e||!Array.isArray(e)||0===e.length)return null;const r=e[0];if(!r||!Array.isArray(r)||0===r.length)return null;const n=[];for(const t of r){if(!Array.isArray(t)||2!==t.length)continue;const e=t[0],r=t[1];"number"==typeof e&&"number"==typeof r&&n.push(new It(e,r));}if(n.length<3)return null;n.length>1&&n[n.length-1].equals(n[0])&&n.pop();let i=0;for(let t=0;t<n.length;t++){const e=n[t],r=n[(t+1)%n.length],s=n[(t+2)%n.length];i+=(e.x-r.x)*(s.y-r.y)-(s.x-r.x)*(e.y-r.y);}i>0&&n.reverse();const s=zh(n.flatMap((t=>[t.x,t.y])),[]);return 0===s.length?null:{vertices:n,indices:s}}function hm(t,e){const r=[],n=[];let i=0;const s=[];for(const o of t){i=r.length;const t=o.vertexArray.float32,a=o.indexArray.uint16;for(let n=0;n<o.vertexArray.length;n++)s[0]=t[3*n+0],s[1]=t[3*n+1],s[2]=t[3*n+2],j(s,s,e),r.push(new It(s[0],s[1]));for(let t=0;t<3*o.indexArray.length;t++)n.push(a[t]+i);}if(n.length%3!=0)return null;for(let t=0;t<n.length;t+=3){const e=r[n[t+0]],i=r[n[t+1]],s=r[n[t+2]];(e.x-i.x)*(s.y-i.y)-(s.x-i.x)*(e.y-i.y)>0&&([n[t+1],n[t+2]]=[n[t+2],n[t+1]]);}return {vertices:r,indices:n}}function pm(t){const e=function(t,e){const r=[],n=WebGL2RenderingContext;if(t.json.textures)for(const i of t.json.textures){const s={magFilter:n.LINEAR,minFilter:n.NEAREST,wrapS:n.REPEAT,wrapT:n.REPEAT};void 0!==i.sampler&&Object.assign(s,t.json.samplers[i.sampler]),r.push({image:e[i.source],sampler:s,uploaded:!1});}return r}(t,t.images),r=function(t,e){const r=[];for(const n of t.json.meshes){const i=[];for(const r of n.primitives)i.push(am(r,t,e));r.push(i);}return r}(t,e),{scenes:n,scene:i,nodes:s}=t.json,o=n?n[i||0].nodes:[...s.keys()],a=[];for(const e of o)a.push(lm(s[e],t,r));return function(t,e,r){const n={},i=new Set;for(let s=0;s<t.length;s++){const t=r[e[s]];if(!t.extras)continue;const o=t.extras["mapbox:footprint:version"],a=t.extras["mapbox:footprint:id"];(o||a)&&i.add(s),"1.0.0"===o&&a&&(n[a]=s);}for(let s=0;s<t.length;s++){if(i.has(s))continue;const o=t[s],a=r[e[s]];if(!a.extras)continue;let l=null;o.id in n&&(l=hm(t[n[o.id]].meshes,o.localMatrix)),l||(l=cm(a)),l&&(o.footprint=um(l));}if(i.size>0){const e=Array.from(i.values()).sort(((t,e)=>t-e));for(let r=e.length-1;r>=0;r--)t.splice(e[r],1);}}(a,o,t.json.nodes),a}function dm(t){t.heightmap=new Float32Array(4096),t.heightmap.fill(-1);const e=t.vertexArray.float32,r=t.aabb.min[0]-1,n=t.aabb.min[1]-1,i=Yf/(t.aabb.max[0]-r+2),s=Yf/(t.aabb.max[1]-n+2);for(let o=0;o<e.length;o+=3){const a=e[o+2],l=(e[o+0]-r)*i|0,u=(e[o+1]-n)*s|0;a>t.heightmap[u*Yf+l]&&(t.heightmap[u*Yf+l]=a);}}function fm(t,e,r,n,i){r.reserve(r.length+4*t.length),n.reserve(n.length+10*t.length),i.reserve(i.length+10*t.length);let s=n.length;for(const o of t){const t=Math.min(10,Math.max(4,1.3*o.height))*e,a=[-o.normal[1],o.normal[0],0],l=Math.min(.29,.1*o.width/o.depth),u=o.width-2*o.depth*e*(l+.01),c=V([],o.pos,a,u/2),h=V([],o.pos,a,-u/2),p=[c[0],c[1],c[2]+o.height],d=[h[0],h[1],h[2]+o.height],f=V([],o.normal,a,l);E(f,f,t);const m=V([],o.normal,a,-l);E(m,m,t),P(f,c,f),P(m,h,m),c[2]+=.1,h[2]+=.1,n.emplaceBack(f[0],f[1],f[2]),n.emplaceBack(m[0],m[1],m[2]),n.emplaceBack(c[0],c[1],c[2]),n.emplaceBack(h[0],h[1],h[2]),n.emplaceBack(p[0],p[1],p[2]),n.emplaceBack(d[0],d[1],d[2]),n.emplaceBack(c[0],c[1],c[2]),n.emplaceBack(h[0],h[1],h[2]),n.emplaceBack(f[0],f[1],f[2]),n.emplaceBack(m[0],m[1],m[2]);const y=u/t/2;i.emplaceBack(-y-l,-1,y,.8),i.emplaceBack(y+l,-1,y,.8),i.emplaceBack(-y,0,y,1.3),i.emplaceBack(y,0,y,1.3),i.emplaceBack(y+l,-.8,y,.7),i.emplaceBack(y+l,-.8,y,.7),i.emplaceBack(0,0,y,1.3),i.emplaceBack(0,0,y,1.3),i.emplaceBack(y+l,-1.2,y,.8),i.emplaceBack(y+l,-1.2,y,.8),r.emplaceBack(6+s,4+s,8+s),r.emplaceBack(7+s,9+s,5+s),r.emplaceBack(0+s,1+s,2+s),r.emplaceBack(1+s,3+s,2+s),s+=10;}}function mm(t,e){const r={};r.indexArray=new Fa,r.vertexArray=new wa,r.colorArray=new Pa,fm(t,e,r.indexArray,r.vertexArray,r.colorArray);const n={defined:!0};n.emissiveFactor=lr.black;const i={};return i.baseColorFactor=lr.white,n.pbrMetallicRoughness=i,r.material=n,r.aabb=new Ju([1/0,1/0,1/0],[-1/0,-1/0,-1/0]),r}const ym=ha([{name:"a_pos_3f",components:3,type:"Float32"}]),gm=ha([{name:"a_normal_3",components:3,type:"Int16"}]),xm=ha([{name:"a_centroid_3",components:3,type:"Int16"}]),vm=ha([{name:"a_part_color_emissive",components:2,type:"Uint16"}]),bm=ha([{name:"a_faux_facade_color_emissive",components:2,type:"Uint16"}]),wm=ha([{name:"a_faux_facade_data",components:4,type:"Uint16"}]),_m=ha([{name:"a_faux_facade_vertical_range",components:2,type:"Uint16"}]),Am=ha([{name:"a_bloom_attenuation",components:4,type:"Float32"}]),Im=ha([{name:"a_flood_light_wall_radius_1i16",components:1,type:"Uint16"}]),Mm=zu.types,Sm=32767;function Pm(t,e){const r=Un+e;for(const n of t)for(const t of n)if(t.x<-e||t.x>r||t.y<-e||t.y>r)return !1;return !0}function km(t){switch(t){case "flat":return 3;case "hipped":return 1;case "gabled":return 2;case "parapet":return 0;case "mansard":return 4;case "skillion":return 5;case "pyramidal":return 6;default:throw new Error(`Unknown roof shape: ${t}`)}}class Bm{constructor(){this.layoutVertexArray=new wa,this.layoutAttenuationArray=new Pa,this.layoutColorArray=new Ba,this.indexArray=new Fa,this.indexArrayForConflation=new Fa,this.segmentsBucket=new hl;}}class zm{constructor(t){this.layoutFacadePaintArray=null,this.layoutFacadeDataArray=null,this.layoutFacadeVerticalRangeArray=null,this.segmentsBucket=new hl,this.entranceBloom=new Bm;const e=66560;this.layoutVertexArray=new wa,this.layoutVertexArray.reserve(e),this.layoutNormalArray=new fa,this.layoutNormalArray.reserve(e),this.layoutCentroidArray=new fa,this.layoutCentroidArray.reserve(e),this.layoutColorArray=new Ba,this.layoutColorArray.reserve(e),this.layoutFloodLightDataArray=new Ga,this.layoutFloodLightDataArray.reserve(e),this.layoutAOArray=new Za,this.layoutAOArray.reserve(e),this.indexArray=new Fa,this.indexArray.reserve(66560),this.indexArrayForConflation=new Fa,this.segmentsBucket=new hl,this.entranceBloom=new Bm,t&&(this.layoutFacadePaintArray=new Ba,this.layoutFacadeDataArray=new Aa,this.layoutFacadeVerticalRangeArray=new Ba);}reserve(t,e,r){this.layoutVertexArray.reserveForAdditional(t),this.layoutCentroidArray.reserveForAdditional(t),this.layoutFloodLightDataArray.reserveForAdditional(t),this.layoutNormalArray.reserveForAdditional(t),this.layoutAOArray.reserveForAdditional(t),this.layoutColorArray.reserveForAdditional(t),this.indexArray.reserveForAdditional(e),r&&(this.layoutFacadePaintArray.reserveForAdditional(t),this.layoutFacadeDataArray.reserveForAdditional(t),this.layoutFacadeVerticalRangeArray.reserveForAdditional(t));}}class Tm{constructor(t){this.colorBufferUploaded=!1,this.maxHeight=0,this.replacementUpdateTime=0,this.activeReplacements=[],this.footprints=[],this.footprintsVertices=new ja,this.footprintsIndices=new Ga,this.footprintsMin=new It(1/0,1/0),this.footprintsMax=new It(-1/0,-1/0),this.featuresOnBorder=[],this.buildingWithoutFacade=new zm(!1),this.buildingWithFacade=new zm(!0),this.indexArrayForConflationUploaded=!1,this.featureFootprintLookup=new Map,this.buildingIds=new Set,this.footprintLookup={},this.zoom=t.zoom,this.canonical=t.canonical,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.worldview=t.worldview,this.lut=t.lut,this.programConfigurations=new Ul(t.layers,{zoom:t.zoom,lut:t.lut}),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.projection=t.projection,this.groundEffect=new yd(t),this.groundEffect.groundRadiusArray=new ya,this.hasAppearances=null;}updateFootprints(t,e){const r=new Mp([],[],1),n={vertices:[],indices:new Uint32Array(0),grid:r,min:this.footprintsMin,max:this.footprintsMax,buildingIds:this.buildingIds};e.push({footprint:n,id:t});}updateAppearances(t,e,r,n){}prepare(){return function(){if(null!=uf||null!=lf)return null;if(null!=af)return af;const t=fetch(oe.BUILDING_GEN_URL);return af=function(t){let e,r,n,i,s;function o(){e=new Uint8Array(s.buffer),r=new Int16Array(s.buffer),n=new Int32Array(s.buffer),i=new Float32Array(s.buffer);}function a(){throw new Error("Unexpected BuildingGen error.")}const l=()=>{},u={a:{a,f:function(t){const r=e.length,n=Math.max(t>>>0,Math.ceil(1.2*r)),i=Math.ceil((n-r)/65536);try{return s.grow(i),o(),!0}catch(t){return !1}},g:a,b:l,c:l,d:l,e:l}};return (WebAssembly.instantiateStreaming?WebAssembly.instantiateStreaming(t,u):t.then((t=>t.arrayBuffer())).then((t=>WebAssembly.instantiate(t,u)))).then((t=>{const a=t.instance.exports;return (0,a.g)(),s=a.f,o(),new Qd({setStyle:a.h,setAOOptions:a.i,setMetricOptions:a.j,setStructuralOptions:a.k,setFacadeOptions:a.l,setFauxFacadeOptions:a.m,setFacadeClassifierOptions:a.n,addFeature:a.o,addFacade:a.p,generateMesh:a.q,getLastError:a.r,getOuterRingLength:a.s,getMeshCount:a.t,getPositionsPtr:a.u,getPositionsLength:a.v,getNormalsPtr:a.w,getNormalsLength:a.x,getAOPtr:a.y,getAOLength:a.z,getUVPtr:a.A,getUVLength:a.B,getFauxFacadePtr:a.C,getFauxFacadeLength:a.D,getIndicesPtr:a.E,getIndicesLength:a.F,getBuildingPart:a.G,getRingCount:a.H,getRingPtr:a.I,getRingLength:a.J,malloc:a.K,free:a.L,heapU8:e,heap16:r,heap32:n,heapF32:i})}))}(t).then((t=>(af=null,uf=t,uf))).catch((t=>{Xt("Could not load building-gen"),af=null,lf=t;})),af}()}populate(t,e,r,n){const i=pf();if(!i)return;const s=vu(r);this.tileToMeter=s,this.brightness=e.brightness,i.setStyle({normalScale:[1,-1,s],tileToMeters:s}),i.setAOOptions(!1,.3),i.setMetricOptions(!1,16),i.setStructuralOptions(!0),i.setFacadeClassifierOptions(3);const o=new Map,a=new Map;let l=0;for(const{feature:e}of t){if("LineString"!==Mm[e.type]){o.set(e.id,e.properties.source_id);continue}const t=this.layers[0]._featureFilter.needGeometry;if(t&&!this.layers[0]._featureFilter.filter(new Io(this.zoom),e,r))continue;const i=Bu(e,t);if(!t&&!this.layers[0]._featureFilter.filter(new Io(this.zoom),i,r))continue;const s=t?i.geometry:ku(e,r,n),u=[];for(const t of s)for(const e of t)u.push(e.x),u.push(e.y);const c={coordinates:u,crossPerc:e.properties.cross_perc,distanceToRoad:e.properties.distance_to_road,entrances:e.properties.entrances,sourceId:0},h=e.properties.source_id;let p=a.get(h);p||(p=[],a.set(h,p)),p.push(c),++l;}this.maxHeight=0;const u=new Array,c=new Set,h=t=>{null!=t&&c.add(t);},p=(t,e)=>{null!=t&&u.push({buildingId:t,footprintIndex:e});},d=64*(t.length-l),f=d/2;this.buildingWithFacade.reserve(d,f,!0),this.buildingWithoutFacade.reserve(2*d,2*f,!1),this.footprintsIndices.reserve(16*(t.length-l)),this.footprintsVertices.reserve(8*(t.length-l));for(const{feature:l,id:u,index:d,sourceLayerIndex:f}of t){if("LineString"===Mm[l.type])continue;const t=this.layers[0]._featureFilter.needGeometry;if(t&&!this.layers[0]._featureFilter.filter(new Io(this.zoom),l,r))continue;let m=null;if(l.properties&&l.properties.hasOwnProperty("building_id")&&(m=l.properties.building_id,c.has(m)))continue;const y=Bu(l,t);if(!t&&!this.layers[0]._featureFilter.filter(new Io(this.zoom),y,r))continue;const g=t?y.geometry:ku(l,r,n),x=rp(g,500);let v=!1;for(const t of x)if(1!==t.length){v=!0;break}if(v){h(m);continue}if(!Pm(g,163)){h(m);continue}const b=this.layers[0],w=km(b.layout.get("building-roof-shape").evaluate(l,{},r)),_=b.layout.get("building-base").evaluate(l,{},r),A=b.layout.get("building-height").evaluate(l,{},r),I=b.layout.get("building-flood-light-ground-radius").evaluate(l,{},r),M=b.paint.get("building-ambient-occlusion-intensity"),S=I/this.tileToMeter;l.properties["building-part"]="roof";const P=b.paint.get("building-color").evaluate(l,{},this.canonical).toPremultipliedRenderColor(this.lut),k=b.paint.get("building-emissive-strength").evaluate(l,{},this.canonical);l.properties["building-part"]="wall";const B=b.paint.get("building-color").evaluate(l,{},this.canonical).toPremultipliedRenderColor(this.lut),z=b.paint.get("building-emissive-strength").evaluate(l,{},this.canonical);l.properties["building-part"]="window";const T=b.paint.get("building-color").evaluate(l,{},this.canonical).toPremultipliedRenderColor(this.lut),E=b.paint.get("building-emissive-strength").evaluate(l,{},this.canonical);l.properties["building-part"]="door";const V=b.paint.get("building-color").evaluate(l,{},this.canonical).toPremultipliedRenderColor(this.lut),F=b.paint.get("building-emissive-strength").evaluate(l,{},this.canonical);let C=b.layout.get("building-flood-light-wall-radius").evaluate(l,{},r);C=Ft(C,0,2048);const D=C/2048*Sm,R=o.get(u),L=a.get(R)||[],O=0!==L.length&&b.layout.get("building-facade").evaluate(l,{},r);i.setFacadeOptions(4,!0),i.setFauxFacadeOptions(O,!1,1);let U=0,N=0,j=0,$=0,G=0,q=0,H=0,X=0,Z=0,W=0,Y=0;if(O){let t=Math.round(b.layout.get("building-facade-floors").evaluate(l,{},r));if(0===_){t=Math.max(1,t-(L.length>0?1:0));let e=4;if(A>100){const t=[10,13,15];e=t[l.id?l.id%t.length:0];}else A<=10&&(e=3);i.setFacadeOptions(e,!0),G=(A<15?1.3:1.61803)*e/s;}else G=_/s;q=A/s,G=Math.min(G,q),j=b.layout.get("building-facade-unit-width").evaluate(l,{},r)/s,$=(q-G)/t,i.setFauxFacadeOptions(!0,!0,j);const e=b.layout.get("building-facade-window").evaluate(l,{},r);U=e[0],N=e[1],H=Math.floor(65535*Math.min(1,G/Un)),X=Math.floor(65535*Math.min(1,q/Un)),Z=Math.floor(255*U)<<8|Math.floor(255*N),W=Math.floor(65535*Math.min(1,j/Un)),Y=Math.floor(65535*Math.min(1,$/Un));}const K=Array(x.length),J={x:1/0,y:1/0},Q={x:-1/0,y:-1/0},tt={x:0,y:0};let et=0;for(let t=0;t<x.length;t++){const e=x[t];if(e.length>0){const r=[],n=Array(e.length+1);n[0]=0;for(let t=0;t<e.length;t++){const i=e[t];for(let t=0;t<i.length;t++){const e=i[i.length-t-1];J.x=Math.min(J.x,e.x),J.y=Math.min(J.y,e.y),Q.x=Math.max(Q.x,e.x),Q.y=Math.max(Q.y,e.y),tt.x+=e.x,tt.y+=e.y,et++,r.push(e.x),r.push(e.y);}n[t+1]=r.length;}K[t]={id:l.id?l.id:0,height:A,minHeight:_,sourceId:0,roofType:w,coordinates:r,ringIndices:n};}}tt.x/=et||1,tt.y/=et||1;const rt=i.generateMesh(K,L);if("string"==typeof rt){Xt(`Unable to generate building ${l.id}: ${rt}`),h(m);continue}if(0===rt.meshes.length||0===rt.modifiedPolygonRings.length){h(m);continue}const nt=O?this.buildingWithFacade:this.buildingWithoutFacade;let it=0;for(const t of rt.meshes)it+=t.positions.length/3;const st=nt.segmentsBucket.prepareSegment(it,nt.layoutVertexArray,nt.indexArray),ot=[];let at=null,lt=0,ut=-1;const ct=nt.layoutVertexArray.length,ht=ct+it;nt.layoutVertexArray.resize(ht),nt.layoutCentroidArray.resize(ht),nt.layoutNormalArray.resize(ht),nt.layoutAOArray.resize(ht),nt.layoutColorArray.resize(ht),nt.layoutFloodLightDataArray.resize(ht),O&&(nt.layoutFacadePaintArray.resize(ht),nt.layoutFacadeDataArray.resize(ht),nt.layoutFacadeVerticalRangeArray.resize(ht));const pt=nt.indexArray.length;let dt=0,ft=ct;for(const t of rt.meshes){let e,r;if(1===t.buildingPart)e=P,r=k;else if(0===t.buildingPart)e=B,r=z;else if(2===t.buildingPart)e=T,r=E;else {if(3!==t.buildingPart)continue;e=V,r=F;}if(r=Ft(r,0,1),3===t.buildingPart){const e=new Array;for(let r=0;r<t.positions.length;r+=12){const n=t.positions[r+0],i=t.positions[r+1],s=t.positions[r+3],o=t.positions[r+4],a=t.positions[r+2],l=t.positions[r+8]-a,u=1,c=s-n,h=o-i,p=Math.hypot(c,h);e.push({pos:[n+.5*c,i+.5*h,a],normal:[h/p,-c/p,0],width:p,height:l,depth:u,points:[n,i,s,o]});}const r=nt.entranceBloom.segmentsBucket.prepareSegment(10*e.length,nt.entranceBloom.layoutVertexArray,nt.entranceBloom.indexArray),n=nt.entranceBloom.layoutVertexArray.length;lt=nt.entranceBloom.indexArray.length,fm(e,.5/this.tileToMeter,nt.entranceBloom.indexArray,nt.entranceBloom.layoutVertexArray,nt.entranceBloom.layoutAttenuationArray);const i=nt.entranceBloom.layoutVertexArray.length-n;ut=nt.entranceBloom.indexArray.length-lt;for(let t=0;t<i;t++)nt.entranceBloom.layoutColorArray.emplaceBack(255*V.r<<8|255*V.g,255*V.b<<8|51*F);r.vertexLength+=i,r.primitiveLength+=ut,at={part:t.buildingPart,vertexOffset:n,vertexLength:i};}nt.layoutVertexArray.float32.set(t.positions,3*ft);const n=t.positions.length/3;for(let i=0;i<n;++i){const n=3*i;dt=Math.max(dt,t.positions[n+2]);const s=t.normals[n+1]*Sm,o=t.normals[n+2]*Sm,a=3*(ft+i);nt.layoutNormalArray.int16[a]=t.normals[n]*Sm,nt.layoutNormalArray.int16[a+1]=s,nt.layoutNormalArray.int16[a+2]=o;const l=t.ao[i];nt.layoutAOArray.uint8[ft+i]=255*l;const u=1+(l-1)*M,c=255*e.b*u<<8|255*r;nt.layoutColorArray.uint16[2*(ft+i)]=255*e.r*u<<8|255*e.g*u,nt.layoutColorArray.uint16[2*(ft+i)+1]=c;}const i=Math.floor(tt.x),s=Math.floor(tt.y),o=Math.floor(A);for(let t=0;t<n;++t){const e=3*(ft+t);nt.layoutCentroidArray.int16[e]=i,nt.layoutCentroidArray.int16[e+1]=s,nt.layoutCentroidArray.int16[e+2]=o;}if(nt.layoutFloodLightDataArray.uint16.fill(0===t.buildingPart?D:0,ft,ft+n),O){const e=255*T.r<<8|255*T.g,r=255*T.b<<8|255*E;for(let t=0;t<n;++t){const n=2*(ft+t);nt.layoutFacadePaintArray.uint16[n]=e,nt.layoutFacadePaintArray.uint16[n+1]=r;}for(let e=0;e<n;++e)if(t.isFauxFacade[e]){const r=Math.min(65535,Math.floor(t.uv[2*e]*rt.outerRingLength));nt.layoutFacadeDataArray.emplace(ft+e,1|r,Z,W,Y),nt.layoutFacadeVerticalRangeArray.emplace(ft+e,H,X);}else nt.layoutFacadeDataArray.emplace(ft+e,0,0,0,0),nt.layoutFacadeVerticalRangeArray.emplace(ft+e,0,0);}const a=st.vertexLength,l=t.indices.length/3,u=nt.indexArray.length;nt.indexArray.resize(u+l);for(let e=0;e<l;++e){const r=3*e,n=3*u+r;nt.indexArray.uint16[n]=a+t.indices[r],nt.indexArray.uint16[n+1]=a+t.indices[r+1],nt.indexArray.uint16[n+2]=a+t.indices[r+2];}1!==t.buildingPart&&0!==t.buildingPart&&2!==t.buildingPart&&3!==t.buildingPart||ot.push({part:t.buildingPart,vertexOffset:ft,vertexLength:t.positions.length/3}),ft+=n,st.vertexLength+=n,st.primitiveLength+=t.indices.length/3;}this.maxHeight=Math.max(this.maxHeight,dt);const mt=nt.indexArray.length-pt,yt=this.footprintsIndices.length,gt=this.footprintsVertices.length,xt=[],vt=new It(1/0,1/0),bt=new It(-1/0,-1/0),wt=this.groundEffect.vertexArray.length;for(const t of rt.modifiedPolygonRings){const e=[],r=new It(1/0,1/0),n=new It(-1/0,-1/0);for(let i=0;i<t.length;i+=2){const s=t.length-i-2;r.x=Math.min(r.x,t[s]),r.y=Math.min(r.y,t[s+1]),n.x=Math.max(n.x,t[s]),n.y=Math.max(n.y,t[s+1]);const o=new It(t[s],t[s+1]);e.push(o),xt.push(o.x,o.y),this.footprintsVertices.emplaceBack(o.x,o.y);}vt.x=Math.min(vt.x,r.x),vt.y=Math.min(vt.y,r.y),bt.x=Math.max(bt.x,n.x),bt.y=Math.max(bt.y,n.y),this.groundEffect.addData(e,[r,n],S);}const _t=this.groundEffect.vertexArray.length-wt;this.groundEffect.groundRadiusArray.reserveForAdditional(_t);for(let t=0;t<_t;t++)this.groundEffect.groundRadiusArray.emplaceBack(I);(J.x<0||Q.x>Un||J.y<0||Q.y>Un)&&this.featuresOnBorder.push({featureId:l.id,footprintIndex:this.footprints.length});{const t=zh(xt,null,2);this.footprintsIndices.resize(this.footprintsIndices.length+t.length),this.footprintsIndices.uint16.set(t,yt),this.buildingIds.add(null!=m?m:l.id),this.footprintsMin.x=Math.min(this.footprintsMin.x,vt.x),this.footprintsMin.y=Math.min(this.footprintsMin.y,vt.y),this.footprintsMax.x=Math.max(this.footprintsMax.x,bt.x),this.footprintsMax.y=Math.max(this.footprintsMax.y,bt.y);const e={footprintVertexOffset:gt,footprintVertexLength:this.footprintsVertices.length-gt,footprintIndexOffset:yt,footprintIndexLength:this.footprintsIndices.length-yt,min:vt,max:bt,hiddenFlags:0,indicesOffset:pt,indicesLength:mt,bloomIndicesOffset:lt,bloomIndicesLength:ut,groundEffectVertexOffset:wt,groundEffectVertexLength:_t,hasFauxFacade:O,height:dt,promoteId:u,feature:y,parts:ot,buildingBloom:at},r=this.footprints.length;void 0!==l.id&&this.featureFootprintLookup.set(l.id,r),p(m,r),this.footprints.push(e);}this.programConfigurations.populatePaintArrays(nt.layoutVertexArray.length,l,d,{},e.availableImages,r,e.brightness),this.groundEffect.addPaintPropertiesData(l,d,{},e.availableImages,r,e.brightness),e.featureIndex.insert(l,g,d,f,this.index,ct);}u.forEach((({buildingId:t,footprintIndex:e})=>{c.has(t)&&(this.footprints[e].hiddenFlags|=4);}));const m=new Set;this.buildingIds.forEach(((t,e,r)=>{c.has(t)||m.add(t);})),this.buildingIds=m,this.groundEffect.prepareBorderSegments();}update(t,e,r,n,i,s,o){this.programConfigurations.updatePaintArrays(t,e,i,r,n,s,o),this.groundEffect.update(t,e,i,r,n,s,o),this.evaluate(this.layers[0],t),this.colorBufferUploaded=!1;}isEmpty(){return 0===this.buildingWithoutFacade.layoutVertexArray.length&&0===this.buildingWithFacade.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload||this.groundEffect.programConfigurations.needsUpload}upload(t){const e=e=>{e.layoutVertexBuffer=t.createVertexBuffer(e.layoutVertexArray,ym.members),e.layoutNormalBuffer=t.createVertexBuffer(e.layoutNormalArray,gm.members),e.layoutCentroidBuffer=t.createVertexBuffer(e.layoutCentroidArray,xm.members),e.layoutFloodLightDataBuffer=t.createVertexBuffer(e.layoutFloodLightDataArray,Im.members),e.layoutFacadeDataArray&&e.layoutFacadeDataArray.length&&(e.layoutFacadeDataBuffer=t.createVertexBuffer(e.layoutFacadeDataArray,wm.members)),e.layoutFacadeVerticalRangeArray&&e.layoutFacadeVerticalRangeArray.length&&(e.layoutFacadeVerticalRangeBuffer=t.createVertexBuffer(e.layoutFacadeVerticalRangeArray,_m.members)),e.entranceBloom.layoutVertexArray.length&&(e.entranceBloom.layoutVertexBuffer=t.createVertexBuffer(e.entranceBloom.layoutVertexArray,ym.members),e.entranceBloom.layoutAttenuationBuffer=t.createVertexBuffer(e.entranceBloom.layoutAttenuationArray,Am.members)),this.uploadUpdatedColorBuffer(t),this.uploadUpdatedIndexBuffer(t);};this.uploaded||(e(this.buildingWithoutFacade),e(this.buildingWithFacade),this.groundEffect.upload(t)),this.groundEffect.uploadPaintProperties(t),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){const t=t=>{t.layoutVertexBuffer&&(t.layoutVertexBuffer.destroy(),t.layoutNormalBuffer.destroy(),t.layoutColorBuffer.destroy(),t.segmentsBucket.destroy(),t.indexBuffer&&t.indexBuffer.destroy(),t.entranceBloom.layoutVertexBuffer&&(t.entranceBloom.layoutVertexBuffer.destroy(),t.entranceBloom.layoutColorBuffer.destroy(),t.entranceBloom.layoutAttenuationBuffer.destroy(),t.entranceBloom.indexBuffer.destroy(),t.entranceBloom.segmentsBucket.destroy()));};t(this.buildingWithoutFacade),t(this.buildingWithFacade),this.groundEffect.destroy(),this.programConfigurations.destroy();}updateFootprintHiddenFlags(t,e,r=!0){let n=!1;const i=r?e:0,s=0|(r?-1:~e);0===this.groundEffect.hiddenByLandmarkVertexArray.length&&this.groundEffect.hiddenByLandmarkVertexArray.resize(this.groundEffect.vertexArray.length);for(const e of t){const t=this.footprints[e],r=t.hiddenFlags&s|i;t.hiddenFlags!==r&&(t.hiddenFlags=r,n=!0,this.groundEffect.updateHiddenByLandmarkRange(t.groundEffectVertexOffset,t.groundEffectVertexLength,0!==t.hiddenFlags));}return n&&(this.indexArrayForConflationUploaded=!1),n}uploadUpdatedIndexBuffer(t){if(this.groundEffect.uploadHiddenByLandmark(t),this.indexArrayForConflationUploaded)return;const e=t=>{0!==t.indexArray.length&&(t.indexArrayForConflation.resize(t.indexArray.length),t.indexArrayForConflation.uint16.set(t.indexArray.uint16),t.entranceBloom.indexArrayForConflation.resize(t.entranceBloom.indexArray.length),t.entranceBloom.indexArrayForConflation.uint16.set(t.entranceBloom.indexArray.uint16));};e(this.buildingWithoutFacade),e(this.buildingWithFacade);for(const t of this.footprints){const e=t.hasFauxFacade?this.buildingWithFacade:this.buildingWithoutFacade,r=t.indicesOffset+t.indicesLength;if(0!==t.hiddenFlags){for(let n=t.indicesOffset;n<r;n++)e.indexArrayForConflation.uint16[3*n+0]=0,e.indexArrayForConflation.uint16[3*n+1]=0,e.indexArrayForConflation.uint16[3*n+2]=0;const n=t.bloomIndicesOffset+t.bloomIndicesLength;for(let r=t.bloomIndicesOffset;r<n;r++)e.entranceBloom.indexArrayForConflation.uint16[3*r+0]=0,e.entranceBloom.indexArrayForConflation.uint16[3*r+1]=0,e.entranceBloom.indexArrayForConflation.uint16[3*r+2]=0;}}const r=e=>{0!==e.indexArray.length&&(e.indexBuffer?e.indexBuffer.updateData(e.indexArrayForConflation):e.indexBuffer=t.createIndexBuffer(e.indexArrayForConflation,!0),e.entranceBloom.indexBuffer?e.entranceBloom.indexBuffer.updateData(e.entranceBloom.indexArrayForConflation):e.entranceBloom.indexBuffer=t.createIndexBuffer(e.entranceBloom.indexArrayForConflation,!0));};r(this.buildingWithoutFacade),r(this.buildingWithFacade),this.indexArrayForConflationUploaded=!0;}uploadUpdatedColorBuffer(t){const e=e=>{e.layoutColorBuffer?e.layoutColorBuffer.updateData(e.layoutColorArray):e.layoutColorBuffer=t.createVertexBuffer(e.layoutColorArray,vm.members,!0),e.layoutFacadePaintArray&&(e.layoutFacadePaintBuffer?e.layoutFacadePaintBuffer.updateData(e.layoutFacadePaintArray):e.layoutFacadePaintBuffer=t.createVertexBuffer(e.layoutFacadePaintArray,bm.members,!0)),e.entranceBloom.layoutColorBuffer?e.entranceBloom.layoutColorBuffer.updateData(e.entranceBloom.layoutColorArray):e.entranceBloom.layoutColorBuffer=t.createVertexBuffer(e.entranceBloom.layoutColorArray,vm.members,!0);};e(this.buildingWithoutFacade),e(this.buildingWithFacade),this.colorBufferUploaded=!0;}evaluate(t,e){const r=t.paint.get("building-ambient-occlusion-intensity");for(const n of this.footprints){if(4&n.hiddenFlags)continue;const i=e[n.promoteId],s=n.feature;s.properties["building-part"]="roof";const o=t.paint.get("building-color").evaluate(s,i,this.canonical).toPremultipliedRenderColor(this.lut),a=t.paint.get("building-emissive-strength").evaluate(s,i,this.canonical);s.properties["building-part"]="wall";const l=t.paint.get("building-color").evaluate(s,i,this.canonical).toPremultipliedRenderColor(this.lut),u=t.paint.get("building-emissive-strength").evaluate(s,i,this.canonical);s.properties["building-part"]="window";const c=t.paint.get("building-color").evaluate(s,i,this.canonical).toPremultipliedRenderColor(this.lut),h=t.paint.get("building-emissive-strength").evaluate(s,i,this.canonical);s.properties["building-part"]="door";const p=t.paint.get("building-color").evaluate(s,i,this.canonical).toPremultipliedRenderColor(this.lut),d=t.paint.get("building-emissive-strength").evaluate(s,i,this.canonical),f=n.hasFauxFacade?this.buildingWithFacade:this.buildingWithoutFacade;for(const t of n.parts){let e,i=o;1===t.part?(i=o,e=a):0===t.part?(i=l,e=u):2===t.part?(i=c,e=h):3===t.part&&(i=p,e=d),e=Ft(e,0,1);for(let s=0;s<t.vertexLength;s++){const o=t.vertexOffset+s,a=1+(f.layoutAOArray.uint8[o]/255-1)*r;f.layoutColorArray.emplace(o,i.r*a*255<<8|i.g*a*255,i.b*a*255<<8|255*e),n.hasFauxFacade&&f.layoutFacadePaintArray.emplace(o,255*c.r<<8|255*c.g,255*c.b<<8|255*h);}}const m=n.buildingBloom;if(m)for(let t=0;t<m.vertexLength;t++)f.entranceBloom.layoutColorArray.emplace(m.vertexOffset+t,255*p.r<<8|255*p.g,255*p.b<<8|51*d);}}needsEvaluation(){return !this.colorBufferUploaded}updateReplacement(t,e,r){if(e.updateTime===this.replacementUpdateTime)return;this.replacementUpdateTime=e.updateTime;const n=e.getReplacementRegionsForTile(t.toUnwrapped());if(jp(this.activeReplacements,n))return;this.activeReplacements=n;for(const t of this.footprints)t.hiddenFlags&=-2;const i=[];for(const e of this.activeReplacements){if(e.order<=Rp)continue;const r=Math.max(1,Math.pow(2,e.footprintTileId.canonical.z-t.canonical.z));for(const n of this.footprints)n.min.x>e.max.x||n.max.x<e.min.x||n.min.y>e.max.y||n.max.y<e.min.y||(i.length=0,Vm(this.footprintsVertices,n.footprintVertexOffset,n.footprintVertexLength,e.footprintTileId.canonical,t.canonical,i),qp(e.footprint,i,this.footprintsIndices.uint16,n.footprintIndexOffset,n.footprintIndexLength,0,-r)&&(n.hiddenFlags|=1));}0===this.groundEffect.hiddenByLandmarkVertexArray.length&&this.groundEffect.hiddenByLandmarkVertexArray.resize(this.groundEffect.vertexArray.length);for(const t of this.footprints)this.groundEffect.updateHiddenByLandmarkRange(t.groundEffectVertexOffset,t.groundEffectVertexLength,0!==t.hiddenFlags);this.indexArrayForConflationUploaded=!1;}getFootprint(t){if(void 0!==t.id){const e=this.featureFootprintLookup.get(t.id);return this.footprints[e]}return null}getHeightAtTileCoord(t,e){let r=Number.NEGATIVE_INFINITY,n=!0;const i=4*(t+Un)*Un+(e+Un);if(this.footprintLookup.hasOwnProperty(i)){const t=this.footprintLookup[i];return t?{height:t.height,hidden:0!==t.hiddenFlags}:void 0}const s=new It(t,e);for(const o of this.footprints)t>o.max.x||o.min.x>t||e>o.max.y||o.min.y>e||o.height<=r||Em(s,this.footprintsVertices.float32.subarray(2*o.footprintVertexOffset,2*(o.footprintVertexOffset+o.footprintVertexLength)),this.footprintsIndices.uint16.subarray(o.footprintIndexOffset,o.footprintIndexOffset+o.footprintIndexLength))&&(r=o.height,this.footprintLookup[i]=o,n=0!==o.hiddenFlags);if(r!==Number.NEGATIVE_INFINITY)return {height:r,hidden:n};this.footprintLookup[i]=void 0;}}function Em(t,e,r){for(let n=0;n<r.length;n+=3){const i=r[n],s=r[n+1],o=r[n+2],a=e[2*i+0],l=e[2*i+1],u=e[2*s+0],c=e[2*s+1],h=e[2*o+0],p=e[2*o+1],d=(a-h)*(t.y-p)-(l-p)*(t.x-h),f=(u-a)*(t.y-l)-(c-l)*(t.x-a);if(d<0!=f<0&&0!==d&&0!==f)continue;const m=(h-u)*(t.y-c)-(p-c)*(t.x-u);if(0===m||m<0==d+f<=0)return !0}return !1}function Vm(t,e,r,n,i,s){const o=Math.pow(2,n.z-i.z);for(let a=0;a<r;a++){let r=t.float32[2*(a+e)+0],l=t.float32[2*(a+e)+1];r=(r+i.x*Un)*o-n.x*Un,l=(l+i.y*Un)*o-n.y*Un,s.push(new It(r,l));}}let Fm,Cm;Qs(Tm,"BuildingBucket",{omit:["layers"]}),Qs(zm,"BuildingGeometry"),Qs(Bm,"BuildingBloomGeometry");const Dm=ha([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"},{name:"a_linesofar",components:1,type:"Float32"}],4),Rm=ha([{name:"a_z_offset_width",components:3,type:"Float32"}],4),{members:Lm}=Dm,Om=ha([{name:"a_packed",components:3,type:"Float32"}]),{members:Um}=Om,Nm=ha([{name:"a_pattern_data",components:3,type:"Float32"}]),{members:jm}=Nm;class $m{constructor(t,e){this.width=t,this.height=e,this.nextRow=0,this.image=new _h({width:t,height:e}),this.positions={},this.uploaded=!1;}getDash(t,e){const r=this.getKey(t,e);return this.positions[r]}trim(){const t=this.width,e=this.height=Ut(this.nextRow);this.image.resize({width:t,height:e});}getKey(t,e){return t.join(",")+e}getDashRanges(t,e,r){const n=[];let i=t.length%2==1?-t[t.length-1]*r:0,s=t[0]*r,o=!0;n.push({left:i,right:s,isDash:o,zeroLength:0===t[0]});let a=t[0];for(let e=1;e<t.length;e++){o=!o;const l=t[e];i=a*r,a+=l,s=a*r,n.push({left:i,right:s,isDash:o,zeroLength:0===l});}return n}addRoundDash(t,e,r){const n=e/2;for(let e=-r;e<=r;e++){const i=this.width*(this.nextRow+r+e);let s=0,o=t[s];for(let a=0;a<this.width;a++){a/o.right>1&&(o=t[++s]);const l=Math.abs(a-o.left),u=Math.abs(a-o.right),c=Math.min(l,u);let h;const p=e/r*(n+1);if(o.isDash){const t=n-Math.abs(p);h=Math.sqrt(c*c+t*t);}else h=n-Math.sqrt(c*c+p*p);this.image.data[i+a]=Math.max(0,Math.min(255,h+128));}}}addRegularDash(t,e){for(let e=t.length-1;e>=0;--e){const r=t[e],n=t[e+1];r.zeroLength?t.splice(e,1):n&&n.isDash===r.isDash&&(n.left=r.left,t.splice(e,1));}const r=t[0],n=t[t.length-1];r.isDash===n.isDash&&(r.left=n.left-this.width,n.right=r.right+this.width);const i=this.width*this.nextRow;let s=0,o=t[s];for(let r=0;r<this.width;r++){r/o.right>1&&(o=t[++s]);const n=Math.abs(r-o.left),a=Math.abs(r-o.right),l=Math.min(n,a);this.image.data[i+r]=Math.max(0,Math.min(255,(o.isDash?l:-l)+e+128));}}addDash(t,e){const r=this.getKey(t,e);if(this.positions[r])return this.positions[r];const n="round"===e,i=n?7:0,s=2*i+1;if(this.nextRow+s>this.height)return Xt("LineAtlas out of space"),null;0===t.length&&t.push(1);let o=0;for(let e=0;e<t.length;e++)t[e]<0&&(Xt("Negative value is found in line dasharray, replacing values with 0"),t[e]=0),o+=t[e];if(0!==o){const r=this.width/o,s=this.getDashRanges(t,this.width,r);n?this.addRoundDash(s,r,i):this.addRegularDash(s,"square"===e?.5*r:0);}const a=this.nextRow+i;this.nextRow+=s;const l={tl:[a,i],br:[o,0]};return this.positions[r]=l,l}}Qs($m,"LineAtlas");const Gm=zu.types,qm=Math.cos(Math.PI/180*37.5),Hm=Math.cos(Math.PI/180*5);class Xm{constructor(t){this.evaluationGlobals={zoom:0,lineProgress:void 0},this.elevationType="none",this.zoom=t.zoom,this.evaluationGlobals.zoom=this.zoom,this.overscaling=t.overscaling,this.pixelRatio=t.pixelRatio,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.projection=t.projection,this.hasPattern=!1,this.hasCrossSlope=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={};})),this.layoutVertexArray=new ba,this.layoutVertexArray2=new wa,this.patternVertexArray=new wa,this.indexArray=new Fa,this.programConfigurations=new Ul(t.layers,{zoom:t.zoom,lut:t.lut}),this.segments=new hl,this.maxLineLength=0,this.zOffsetVertexArray=new wa,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.tessellationStep=t.tessellationStep?t.tessellationStep:Un/64,this.worldview=t.worldview,this.hasAppearances=null;}updateFootprints(t,e){}updateAppearances(t,e,r,n){}populate(t,e,r,n){this.hasPattern=sp("line",this.layers,this.pixelRatio,e);const i=this.layers[0].layout.get("line-sort-key");this.tileToMeter=vu(r);const s=this.layers[0].layout.get("line-elevation-reference");if("hd-road-markup"===s)this.elevationType="road";else {const t=this.layers[0].layout.get("line-z-offset"),e=t.isConstant()&&!t.constantOr(0);this.elevationType="sea"!==s&&"ground"!==s&&e?"none":"offset","offset"===this.elevationType&&"none"===s&&Xt(`line-elevation-reference: ground is used for the layer ${this.layerIds[0]} because non-zero line-z-offset value was found.`);}const o=this.layers[0].layout.get("line-cross-slope");this.hasCrossSlope="offset"===this.elevationType&&void 0!==o;const a=[];for(const{feature:s,id:o,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=Bu(s,t);if(!this.layers[0]._featureFilter.filter(new Io(this.zoom,{worldview:this.worldview,activeFloors:e.activeFloors}),c,r))continue;const h=i?i.evaluate(c,{},r):void 0,p={id:o,properties:s.properties,type:s.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:ku(s,r,n),patterns:{},sortKey:h};a.push(p);}i&&a.sort(((t,e)=>t.sortKey-e.sortKey));const{lineAtlas:l,featureIndex:u}=e,c=this.addConstantDashes(l);for(const n of a){const{geometry:i,index:s,sourceLayerIndex:o}=n;if(c&&this.addFeatureDashes(n,l),this.hasPattern){const t=op("line",this.layers,n,this.zoom,this.pixelRatio,e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,l.positions,e.availableImages,e.brightness,e.elevationFeatures);u.insert(t[s].feature,i,s,o,this.index);}}addConstantDashes(t){let e=!1;for(const r of this.layers){const n=r.paint.get("line-dasharray").value,i=r.layout.get("line-cap").value;if("constant"!==n.kind||"constant"!==i.kind)e=!0;else {const e=i.value,r=n.value;if(!r)continue;t.addDash(r,e);}}return e}addFeatureDashes(t,e){const r=this.zoom;for(const n of this.layers){const i=n.paint.get("line-dasharray").value,s=n.layout.get("line-cap").value;if("constant"===i.kind&&"constant"===s.kind)continue;let o,a;if("constant"===i.kind){if(o=i.value,!o)continue}else o=i.evaluate({zoom:r},t);a="constant"===s.kind?s.value:s.evaluate({zoom:r},t),e.addDash(o,a),t.patterns[n.id]=[e.getKey(o,a)];}}update(t,e,r,n,i,s,o,a){this.programConfigurations.updatePaintArrays(t,e,i,r,n,s,o,a);}addFeatures(t,e,r,n,i,s){for(const i of this.patternFeatures)this.addFeature(i,i.geometry,i.index,e,r,n,s,t.elevationFeatures);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,Um)),0!==this.patternVertexArray.length&&(this.patternVertexBuffer=t.createVertexBuffer(this.patternVertexArray,jm)),!this.zOffsetVertexBuffer&&this.zOffsetVertexArray.length>0&&(this.zOffsetVertexBuffer=t.createVertexBuffer(this.zOffsetVertexArray,Rm.members,!0)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Lm),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.zOffsetVertexBuffer&&this.zOffsetVertexBuffer.destroy(),this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}lineFeatureClips(t,e){let r,n;if(e&&e>0?(r=`mapbox_clip_start_${e}`,n=`mapbox_clip_end_${e}`):(r="mapbox_clip_start",n="mapbox_clip_end"),t.properties&&t.properties.hasOwnProperty(r)&&t.properties.hasOwnProperty(n))return {start:+t.properties[r],end:+t.properties[n]}}addFeature(t,e,r,n,i,s,o,a){const l=this.layers[0].layout,u=l.get("line-join").evaluate(t,{}),c=l.get("line-cap").evaluate(t,{}),h=l.get("line-miter-limit"),p=l.get("line-round-limit");this.lineClips=this.lineFeatureClips(t),this.lineFeature=t;const d=!(!t.properties||!t.properties.hasOwnProperty("mapbox_line_metrics"))&&t.properties.mapbox_line_metrics;this.zOffsetValue=l.get("line-z-offset").value;const f=this.layers[0].paint.get("line-width").value;if("constant"!==f.kind&&!1===f.isLineProgressConstant&&(this.variableWidthValue=f),"road"===this.elevationType){const r=this.layoutVertexArray.length;if(!this.addElevatedRoadFeature(t,e,n,a,u,c,h,p)){const[i,s]=this.clipRuntimeLinesToTile(e,1);for(let e=0;e<i.length;e++){const r=i[e],o=s[e],a={progress:{min:o.progress.min,max:o.progress.max},nextDir:this.computeSegNextDir(o,r),prevDir:this.computeSegPrevDir(o,r)};this.addLine(r,t,n,u,c,h,p,a,d&&o.parentIndex>0?o.parentIndex:null);}this.fillNonElevatedRoadSegment(r);}}else for(let r=0;r<e.length;r++)this.addLine(e[r],t,n,u,c,h,p,void 0,d&&r>0?r:null);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,s,n,o,void 0,this.worldview);}computeSegNextDir(t,e){return t.nextPoint.sub(e.at(-2)).unit()}computeSegPrevDir(t,e){return e[1].sub(t.prevPoint).unit()}clipLinesToTile(t,e){return Fd(t,-e,-e,Un+e,Un+e)}clipRuntimeLinesToTile(t,e){const r=[];return [Fd(t,-e,-e,Un+e,Un+e,r),r]}addElevatedRoadFeature(t,e,r,n,i,s,o,a){const l=[],u=ec.getElevationFeature(t,n);if(u){const t=this.clipLinesToTile(e,1),n=this.prepareElevatedLines(t,u,r);for(const t of n)l.push({geometry:t,elevation:u,elevationTileID:r,segment:{progress:{min:0,max:1},nextDir:void 0,prevDir:void 0}});}if(0===l.length)return !1;for(const e of l){const n=this.layoutVertexArray.length;this.addLine(e.geometry,t,r,i,s,o,a);const l=new rc(r,e.elevationTileID);if(e.elevation)for(let t=n;t<this.layoutVertexArray.length;t++){const r=new It(this.layoutVertexArray.int16[6*t]>>1,this.layoutVertexArray.int16[6*t+1]>>1),n=l.pointElevation(r,e.elevation,.05);this.updateHeightRange(n),this.zOffsetVertexArray.emplaceBack(n,0,0);}else this.fillNonElevatedRoadSegment(n);}return !0}prepareElevatedLines(t,e,r){if(null!=e.constantHeight)return t;const n=[],i=1/vu(r);for(const r of t)Cd(r,new Qu(e,i),0,n);return n}fillNonElevatedRoadSegment(t){for(let e=t;e<this.layoutVertexArray.length;e++)this.zOffsetVertexArray.emplaceBack(0,0,0);}updateHeightRange(t){this.heightRange?(this.heightRange.min=Math.min(this.heightRange.min,t),this.heightRange.max=Math.max(this.heightRange.max,t)):this.heightRange={min:t,max:t};}addLine(t,e,r,n,i,s,o,a,l){this.distance=0,this.prevDistance=0,this.scaledDistance=0,this.totalDistance=0,this.totalFeatureLength=0,this.lineSoFar=0,this.currentVertex=void 0,this.lineClips=l?this.lineFeatureClips(e,l):this.lineClips;const u="none"===n;this.patternJoinNone=this.hasPattern&&u,this.segmentStart=0,this.segmentStartf32=0,this.segmentPoints=[];const c=a&&a.progress.min>0,h=a&&a.progress.max<1;if(this.lineClips){let r={min:this.lineClips.start,max:this.lineClips.end},n=1;if(a){const t=this.lineClips.end-this.lineClips.start;r=function(t,e,r){return {min:se(t.min,e,r),max:se(t.max,e,r)}}(a.progress,{min:0,max:1},r),t>0&&(n=(r.max-r.min)/t);}const i=+e.properties.mapbox_clip_feature_len,s=+e.properties.mapbox_clip_seg_len;if(Number.isNaN(i)||Number.isNaN(s)){for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);const e=this.totalDistance/(r.max-r.min);this.totalFeatureLength=Number.isFinite(e)?e:0,this.lineClips.start=r.min,this.lineClips.end=r.max,this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance);}else this.totalFeatureLength=i,this.distance=s*n,this.lineClips.start=r.min,this.lineClips.end=r.max,this.maxLineLength=Math.max(this.maxLineLength,this.distance);this.lineClipsArray.push(this.lineClips),this.updateScaledDistance();}const p="Polygon"===Gm[e.type];let d=t.length;for(;d>=2&&t[d-1].equals(t[d-2]);)d--;let f=0;for(;f<d-1&&t[f].equals(t[f+1]);)f++;if(d<(p?3:2))return;"bevel"===n&&(s=1.05);const m=this.segments.prepareSegment(10*d,this.layoutVertexArray,this.indexArray);let y,g,x,v,b,w,_,A;a&&a.prevDir&&(w=a.prevDir.perp()),a&&a.nextDir&&(_=a.nextDir.perp()),this.e1=this.e2=-1,p&&(y=t[d-2],b=t[f].sub(y)._unit()._perp());for(let e=f;e<d;e++){if(x=e===d-1?p?t[f+1]:void 0:t[e+1],x&&t[e].equals(x))continue;b&&(v=b),y&&(g=y),y=t[e],A=this.evaluateLineProgressFeatures(g?g.dist(y):0),b=x?x.sub(y)._unit()._perp():v,v=v||b;const r=g&&x;let a=r?n:p||u?"butt":i;const l=v.x*b.x+v.y*b.y;if(u){const t=function(t){if(t.patternJoinNone){const e=t.segmentPoints.length/2,r=t.lineSoFar-t.segmentStart;for(let n=0;n<e;++n){const e=t.segmentPoints[2*n+1],i=Math.round(t.segmentPoints[2*n])+.5+.25*e;t.patternVertexArray.emplaceBack(i,r,t.segmentStart),t.patternVertexArray.emplaceBack(i,r,t.segmentStart);}t.segmentPoints.length=0;}t.e1=t.e2=-1;};if(r&&l<Hm){this.updateDistance(g,y),this.addCurrentVertex(y,v,1,1,m,A),t(this),this.addCurrentVertex(y,b,-1,-1,m,A);continue}if(g){if(!x){this.updateDistance(g,y),this.addCurrentVertex(y,v,1,1,m,A),t(this);continue}a="miter";}}let I=v.add(b);0===I.x&&0===I.y||I._unit();const M=I.x*b.x+I.y*b.y,S=0!==M?1/M:1/0,P=2*Math.sqrt(2-2*M),k=M<qm&&g&&x,B=v.x*b.y-v.y*b.x>0,z=this.overscaling<=16?15*Un/(512*this.overscaling):0;if(r&&"round"===a)if(S<o)a="miter";else if(S<=2){const t=Zm(y,-10,Un+10);a="offset"===this.elevationType&&(t||this.hasCrossSlope)?"miter":"fakeround";}if("miter"===a&&S>s&&(a="bevel"),"bevel"===a&&(S>2&&(a="flipbevel"),S<s&&(a="miter")),g&&!("miter"===a&&k)&&this.updateDistance(g,y),"miter"===a)if(k){const t=y.dist(g);if(t>2*z){const e=y.sub(y.sub(g)._mult(z/t)._round());this.updateDistance(g,e),this.addCurrentVertex(e,v,0,0,m,A),g=e;}this.updateDistance(g,y),I._mult(S),this.addCurrentVertex(y,I,0,0,m,A);const e=y.dist(x);if(e>2*z){const t=y.add(x.sub(y)._mult(z/e)._round());this.updateDistance(y,t),this.addCurrentVertex(t,b,0,0,m,A),y=t;}}else I._mult(S),this.addCurrentVertex(y,I,0,0,m,A);else if("flipbevel"===a){if(S>100)I=b.mult(-1);else {const t=S*v.add(b).mag()/v.sub(b).mag();I._perp()._mult(t*(B?-1:1));}this.addCurrentVertex(y,I,0,0,m,A),this.addCurrentVertex(y,I.mult(-1),0,0,m,A);}else if("bevel"===a||"fakeround"===a){null!=A&&g&&this.addCurrentVertex(y,_||v,-1,-1,m,A);const t=y.dist(g)<=2*z&&"bevel"!==a,e=I.mult(B?1:-1);e._mult(S);const r=b.mult(B?-1:1),n=v.mult(B?-1:1),i=this.evaluateLineProgressFeatures(this.distance);if(null==A&&(this.addHalfVertex(y,e.x,e.y,!1,!B,0,m,i),t||this.addHalfVertex(y,e.x+2*n.x,e.y+2*n.y,!1,B,0,m,i)),"fakeround"===a){const t=Math.round(180*P/Math.PI/20);this.addHalfVertex(y,n.x,n.y,!1,B,0,m,i);for(let e=0;e<t;e++){let s=e/t;if(.5!==s){const t=s-.5;s+=s*t*(s-1)*((1.0904+l*(l*(3.55645-1.43519*l)-3.2452))*t*t+(.848013+l*(.215638*l-1.06021)));}const o=r.sub(n)._mult(s)._add(n)._unit();this.addHalfVertex(y,o.x,o.y,!1,B,0,m,i);}this.addHalfVertex(y,r.x,r.y,!1,B,0,m,i);}t||null!=A||this.addHalfVertex(y,e.x+2*r.x,e.y+2*r.y,!1,B,0,m,i),null!=A&&x&&this.addCurrentVertex(y,w||b,1,1,m,A);}else if("butt"===a)this.addCurrentVertex(y,I,0,0,m,A);else if("square"===a){if(!g){const t=c?0:-1;this.addCurrentVertex(y,I,t,t,m,A);}if(this.addCurrentVertex(y,I,0,0,m,A),g){const t=h?0:1;this.addCurrentVertex(y,I,t,t,m,A);}}else if("round"===a){if(g){const t=!r&&_?_:v;this.addCurrentVertex(y,t,0,0,m,A),!r&&h||this.addCurrentVertex(y,t,1,1,m,A,!0);}if(x){const t=!r&&w?w:b;!r&&c||this.addCurrentVertex(y,t,-1,-1,m,A,!0),this.addCurrentVertex(y,t,0,0,m,A);}}}}addVerticesTo(t,e,r,n,i,s,o,a,l,u){const c=(e.w-t.w)/this.tessellationStep|0;let h=0;const p=this.scaledDistance;if(c>1){this.lineSoFar=t.w;const p=(e.x-t.x)/c,d=(e.y-t.y)/c,f=(e.z-t.z)/c,m=(e.w-t.w)/c;for(let e=1;e<c;++e){t.x+=p,t.y+=d,t.z+=f,this.lineSoFar+=m,h+=m;const e=this.evaluateLineProgressFeatures(this.prevDistance+h);this.scaledDistance=(this.prevDistance+h)/this.totalDistance,this.addHalfVertex(t,r,n,u,!1,o,l,e),this.addHalfVertex(t,i,s,u,!0,-a,l,e);}}this.lineSoFar=e.w,this.scaledDistance=p;const d=this.evaluateLineProgressFeatures(this.distance);this.addHalfVertex(e,r,n,u,!1,o,l,d),this.addHalfVertex(e,i,s,u,!0,-a,l,d);}evaluateLineProgressFeatures(t){if(!this.variableWidthValue&&"offset"!==this.elevationType)return null;this.evaluationGlobals.lineProgress=0,this.lineClips?this.evaluationGlobals.lineProgress=Math.min(1,(this.totalFeatureLength*this.lineClips.start+t)/this.totalFeatureLength):Xt(`line-progress evaluation for ${this.layerIds[0]} requires enabling 'lineMetrics' for the source.`);let e=0;return this.variableWidthValue&&"constant"!==this.variableWidthValue.kind&&(e=this.variableWidthValue.evaluate(this.evaluationGlobals,this.lineFeature)||0),"offset"!==this.elevationType?{zOffset:0,variableWidth:e}:"constant"===this.zOffsetValue.kind?{zOffset:this.zOffsetValue.value,variableWidth:e}:{zOffset:this.zOffsetValue.evaluate(this.evaluationGlobals,this.lineFeature)||0,variableWidth:e}}addCurrentVertex(t,e,r,n,i,s,o=!1){const a=e.x+e.y*r,l=e.y-e.x*r,u=e.y*n-e.x,c=-e.y-e.x*n;if(null!=s){const e="offset"===this.elevationType,h=-10,p=Un+10,d=s.zOffset,f=new Td(t.x,t.y,d,this.lineSoFar),m=!!e&&Zm(t,h,p),y=this.lineSoFar,g=this.distance;if(this.currentVertex)if(m){const e=this.currentVertexIsOutside,s=this.currentVertex,m=new Td(t.x,t.y,d,this.lineSoFar);if(Vd(s,m,h,p),!Zm(m,h,p)){if(e){this.e1=this.e2=-1,this.distance-=s.dist(f),this.lineSoFar=s.w;const t=this.evaluateLineProgressFeatures(s.w-this.totalFeatureLength*(this.lineClips?this.lineClips.start:0));this.addHalfVertex(s,a,l,o,!1,r,i,t),this.addHalfVertex(s,u,c,o,!0,-n,i,t),this.prevDistance=this.distance;}this.distance=this.prevDistance+s.dist(m),this.scaledDistance=this.distance/this.totalDistance,this.addVerticesTo(s,m,a,l,u,c,r,n,i,o),this.distance=g,this.scaledDistance=this.distance/this.totalDistance;}}else {const t=this.currentVertex;if(this.currentVertexIsOutside){Vd(t,f,h,p),this.e1=this.e2=-1,this.distance-=t.dist(f),this.scaledDistance=this.distance/this.totalDistance,this.lineSoFar=t.w;const e=this.evaluateLineProgressFeatures(t.w-this.totalFeatureLength*(this.lineClips?this.lineClips.start:0));this.addHalfVertex(t,a,l,o,!1,r,i,e),this.addHalfVertex(t,u,c,o,!0,-n,i,e),this.prevDistance=this.distance,this.distance=g,this.scaledDistance=this.distance/this.totalDistance;}this.addVerticesTo(t,f,a,l,u,c,r,n,i,o);}else m||(this.addHalfVertex(t,a,l,o,!1,r,i,s),this.addHalfVertex(t,u,c,o,!0,-n,i,s));this.currentVertex=f,this.currentVertexIsOutside=m,this.lineSoFar=y;}else this.addHalfVertex(t,a,l,o,!1,r,i,s),this.addHalfVertex(t,u,c,o,!0,-n,i,s);}addHalfVertex({x:t,y:e},r,n,i,s,o,a,l){if(this.patternJoinNone&&(0===this.segmentPoints.length&&(this.segmentStart=this.lineSoFar,this.segmentStartf32=Math.fround(this.lineSoFar)),s||this.segmentPoints.push(this.lineSoFar-this.segmentStart,o)),this.layoutVertexArray.emplaceBack((t<<1)+(i?1:0),(e<<1)+(s?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===o?0:o<0?-1:1),0,this.lineSoFar-this.segmentStartf32),this.lineClips){const t=pr(this.lineClips.start,this.lineClips.end,this.scaledDistance);this.layoutVertexArray2.emplaceBack(this.scaledDistance,this.lineClipsArray.length,t);}const u=a.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,this.e2,u),a.primitiveLength++),s?this.e2=u:this.e1=u,null!=l&&this.zOffsetVertexArray.emplaceBack(l.zOffset,l.variableWidth,l.variableWidth);}updateScaledDistance(){this.lineClips?(this.scaledDistance=this.distance/this.totalDistance,this.lineSoFar=this.totalFeatureLength*this.lineClips.start+this.distance):this.lineSoFar=this.distance;}updateDistance(t,e){this.prevDistance=this.distance,this.distance+=t.dist(e),this.updateScaledDistance();}}function Zm(t,e,r){return t.x<e||t.x>r||t.y<e||t.y>r}let Wm,Ym;function Km(t,e,r){return e*(Un/(t.tileSize*Math.pow(2,r-t.tileID.overscaledZ)))}Qs(Xm,"LineBucket",{omit:["layers","patternFeatures","currentVertex","currentVertexIsOutside"]});const Jm=(t,e,r)=>(1-r)*t+r*e;function Qm(t,e){return 1/Km(t,1,e.tileZoom)}function ty(t,e,r,n){return t.translatePosMatrix(n||e.tileID.projMatrix,e,r.paint.get("line-translate"),r.paint.get("line-translate-anchor"))}const ey=t=>{const e=[];ry(t)&&e.push("RENDER_LINE_DASH"),t.paint.get("line-gradient")&&e.push("RENDER_LINE_GRADIENT");const r=t.paint.get("line-trim-offset");0===r[0]&&0===r[1]||e.push("RENDER_LINE_TRIM_OFFSET"),0!==t.paint.get("line-border-width").constantOr(1)&&e.push("RENDER_LINE_BORDER");const n="none"===t.layout.get("line-join").constantOr("miter"),i=!!t.paint.get("line-pattern").constantOr(1);return n&&i&&e.push("LINE_JOIN_NONE"),e};function ry(t){const e=t.paint.get("line-dasharray").value;return "constant"!==e.kind||e.value}let ny;const iy=()=>ny||(ny={layout:Wm||(Wm=new Do({"line-cap":new Fo(Ro.layout_line["line-cap"]),"line-join":new Fo(Ro.layout_line["line-join"]),"line-miter-limit":new Vo(Ro.layout_line["line-miter-limit"]),"line-round-limit":new Vo(Ro.layout_line["line-round-limit"]),"line-sort-key":new Fo(Ro.layout_line["line-sort-key"]),"line-z-offset":new Fo(Ro.layout_line["line-z-offset"]),"line-elevation-reference":new Vo(Ro.layout_line["line-elevation-reference"]),"line-cross-slope":new Vo(Ro.layout_line["line-cross-slope"]),visibility:new Vo(Ro.layout_line.visibility),"line-width-unit":new Vo(Ro.layout_line["line-width-unit"])})),paint:Ym||(Ym=new Do({"line-opacity":new Fo(Ro.paint_line["line-opacity"]),"line-color":new Fo(Ro.paint_line["line-color"]),"line-translate":new Vo(Ro.paint_line["line-translate"]),"line-translate-anchor":new Vo(Ro.paint_line["line-translate-anchor"]),"line-width":new Fo(Ro.paint_line["line-width"]),"line-gap-width":new Fo(Ro.paint_line["line-gap-width"]),"line-offset":new Fo(Ro.paint_line["line-offset"]),"line-blur":new Fo(Ro.paint_line["line-blur"]),"line-dasharray":new Fo(Ro.paint_line["line-dasharray"]),"line-pattern":new Fo(Ro.paint_line["line-pattern"]),"line-pattern-cross-fade":new Vo(Ro.paint_line["line-pattern-cross-fade"]),"line-gradient":new Co(Ro.paint_line["line-gradient"]),"line-trim-offset":new Vo(Ro.paint_line["line-trim-offset"]),"line-trim-fade-range":new Vo(Ro.paint_line["line-trim-fade-range"]),"line-trim-color":new Vo(Ro.paint_line["line-trim-color"]),"line-emissive-strength":new Fo(Ro.paint_line["line-emissive-strength"]),"line-border-width":new Fo(Ro.paint_line["line-border-width"]),"line-border-color":new Fo(Ro.paint_line["line-border-color"]),"line-occlusion-opacity":new Vo(Ro.paint_line["line-occlusion-opacity"]),"line-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"}),"line-gradient-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"}),"line-trim-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"}),"line-border-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"})}))},ny);class sy extends Fo{possiblyEvaluate(t,e){return e=new Io(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,transition:e.transition,worldview:e.worldview}),super.possiblyEvaluate(t,e)}evaluate(t,e,r,n){return e=Object.assign({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,r,n)}}let oy;function ay(t,e){return e>0?e+2*t:t}const ly=ha([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_tex_size",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),uy=ha([{name:"a_globe_anchor",components:3,type:"Int16"},{name:"a_globe_normal",components:3,type:"Float32"}],4),cy=ha([{name:"a_projected_pos",components:4,type:"Float32"}],4);ha([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const hy=ha([{name:"a_auto_z_offset",components:1,type:"Float32"}],4),py=ha([{name:"a_x_axis",components:3,type:"Float32"},{name:"a_y_axis",components:3,type:"Float32"}]),dy=ha([{name:"a_texb",components:2,type:"Uint16"}]),fy=ha([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"},{name:"a_elevation_from_sea",components:2,type:"Float32"}]),my=ha([{name:"a_size_scale",components:1,type:"Float32"},{name:"a_padding",components:2,type:"Float32"},{name:"a_auto_z_offset",components:1,type:"Float32"}]);ha([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Int16",name:"tileAnchorX"},{type:"Int16",name:"tileAnchorY"},{type:"Float32",name:"x1"},{type:"Float32",name:"y1"},{type:"Float32",name:"x2"},{type:"Float32",name:"y2"},{type:"Int16",name:"padding"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const yy=ha([{name:"a_pos",components:3,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),gy=ha([{name:"a_pos_2f",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);ha([{name:"triangle",components:3,type:"Uint16"}]),ha([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Float32",name:"tileAnchorX"},{type:"Float32",name:"tileAnchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"},{type:"Uint8",name:"flipState"}]),ha([{type:"Float32",name:"tileAnchorX"},{type:"Float32",name:"tileAnchorY"},{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",components:2,name:"textOffset"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Float32",name:"zOffset"},{type:"Uint8",name:"hasIconTextFit"},{type:"Uint16",name:"elevationFeatureIndex"}]),ha([{type:"Float32",name:"offsetX"}]),ha([{type:"Int16",name:"x"},{type:"Int16",name:"y"}]);var xy=24;function vy(t,e,r){return t.sections.forEach((t=>{t.text=function(t,e,r){const n=e.layout.get("text-transform").evaluate(r,{});return "uppercase"===n?t=t.toLocaleUpperCase():"lowercase"===n&&(t=t.toLocaleLowerCase()),Ao.applyArabicShaping&&(t=Ao.applyArabicShaping(t)),t}(t.text,e,r);})),t}const by={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂","←":"↑","→":"↓"};function wy(t){return "︶"===t||"﹈"===t||"︸"===t||"﹄"===t||"﹂"===t||"︾"===t||"︼"===t||"︺"===t||"︘"===t||"﹀"===t||"︐"===t||"︓"===t||"︔"===t||"｀"===t||"￣"===t||"︑"===t||"︒"===t}function _y(t){return "︵"===t||"﹇"===t||"︷"===t||"﹃"===t||"﹁"===t||"︽"===t||"︻"===t||"︹"===t||"︗"===t||"︿"===t}const Ay=4294967296,Iy=1/Ay,My="undefined"==typeof TextDecoder?null:new TextDecoder("utf-8");let Sy=class{constructor(t=new Uint8Array(16)){this.buf=ArrayBuffer.isView(t)?t:new Uint8Array(t),this.dataView=new DataView(this.buf.buffer),this.pos=0,this.type=0,this.length=this.buf.length;}readFields(t,e,r=this.length){for(;this.pos<r;){const r=this.readVarint(),n=r>>3,i=this.pos;this.type=7&r,t(n,e,this),this.pos===i&&this.skip(r);}return e}readMessage(t,e){return this.readFields(t,e,this.readVarint()+this.pos)}readFixed32(){const t=this.dataView.getUint32(this.pos,!0);return this.pos+=4,t}readSFixed32(){const t=this.dataView.getInt32(this.pos,!0);return this.pos+=4,t}readFixed64(){const t=this.dataView.getUint32(this.pos,!0)+this.dataView.getUint32(this.pos+4,!0)*Ay;return this.pos+=8,t}readSFixed64(){const t=this.dataView.getUint32(this.pos,!0)+this.dataView.getInt32(this.pos+4,!0)*Ay;return this.pos+=8,t}readFloat(){const t=this.dataView.getFloat32(this.pos,!0);return this.pos+=4,t}readDouble(){const t=this.dataView.getFloat64(this.pos,!0);return this.pos+=8,t}readVarint(t){const e=this.buf;let r,n;return n=e[this.pos++],r=127&n,n<128?r:(n=e[this.pos++],r|=(127&n)<<7,n<128?r:(n=e[this.pos++],r|=(127&n)<<14,n<128?r:(n=e[this.pos++],r|=(127&n)<<21,n<128?r:(n=e[this.pos],r|=(15&n)<<28,function(t,e,r){const n=r.buf;let i,s;if(s=n[r.pos++],i=(112&s)>>4,s<128)return Py(t,i,e);if(s=n[r.pos++],i|=(127&s)<<3,s<128)return Py(t,i,e);if(s=n[r.pos++],i|=(127&s)<<10,s<128)return Py(t,i,e);if(s=n[r.pos++],i|=(127&s)<<17,s<128)return Py(t,i,e);if(s=n[r.pos++],i|=(127&s)<<24,s<128)return Py(t,i,e);if(s=n[r.pos++],i|=(1&s)<<31,s<128)return Py(t,i,e);throw new Error("Expected varint not more than 10 bytes")}(r,t,this)))))}readVarint64(){return this.readVarint(!0)}readSVarint(){const t=this.readVarint();return t%2==1?(t+1)/-2:t/2}readBoolean(){return Boolean(this.readVarint())}readString(){const t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&My?My.decode(this.buf.subarray(e,t)):function(t,e,r){let n="",i=e;for(;i<r;){const e=t[i];let s,o,a,l=null,u=e>239?4:e>223?3:e>191?2:1;if(i+u>r)break;1===u?e<128&&(l=e):2===u?(s=t[i+1],128==(192&s)&&(l=(31&e)<<6|63&s,l<=127&&(l=null))):3===u?(s=t[i+1],o=t[i+2],128==(192&s)&&128==(192&o)&&(l=(15&e)<<12|(63&s)<<6|63&o,(l<=2047||l>=55296&&l<=57343)&&(l=null))):4===u&&(s=t[i+1],o=t[i+2],a=t[i+3],128==(192&s)&&128==(192&o)&&128==(192&a)&&(l=(15&e)<<18|(63&s)<<12|(63&o)<<6|63&a,(l<=65535||l>=1114112)&&(l=null))),null===l?(l=65533,u=1):l>65535&&(l-=65536,n+=String.fromCharCode(l>>>10&1023|55296),l=56320|1023&l),n+=String.fromCharCode(l),i+=u;}return n}(this.buf,e,t)}readBytes(){const t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e}readPackedVarint(t=[],e){const r=this.readPackedEnd();for(;this.pos<r;)t.push(this.readVarint(e));return t}readPackedSVarint(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSVarint());return t}readPackedBoolean(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readBoolean());return t}readPackedFloat(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFloat());return t}readPackedDouble(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readDouble());return t}readPackedFixed32(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFixed32());return t}readPackedSFixed32(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSFixed32());return t}readPackedFixed64(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFixed64());return t}readPackedSFixed64(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSFixed64());return t}readPackedEnd(){return 2===this.type?this.readVarint()+this.pos:this.pos+1}skip(t){const e=7&t;if(0===e)for(;this.buf[this.pos++]>127;);else if(2===e)this.pos=this.readVarint()+this.pos;else if(5===e)this.pos+=4;else {if(1!==e)throw new Error(`Unimplemented type: ${e}`);this.pos+=8;}}writeTag(t,e){this.writeVarint(t<<3|e);}realloc(t){let e=this.length||16;for(;e<this.pos+t;)e*=2;if(e!==this.length){const t=new Uint8Array(e);t.set(this.buf),this.buf=t,this.dataView=new DataView(t.buffer),this.length=e;}}finish(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)}writeFixed32(t){this.realloc(4),this.dataView.setInt32(this.pos,t,!0),this.pos+=4;}writeSFixed32(t){this.realloc(4),this.dataView.setInt32(this.pos,t,!0),this.pos+=4;}writeFixed64(t){this.realloc(8),this.dataView.setInt32(this.pos,-1&t,!0),this.dataView.setInt32(this.pos+4,Math.floor(t*Iy),!0),this.pos+=8;}writeSFixed64(t){this.realloc(8),this.dataView.setInt32(this.pos,-1&t,!0),this.dataView.setInt32(this.pos+4,Math.floor(t*Iy),!0),this.pos+=8;}writeVarint(t){(t=+t||0)>268435455||t<0?function(t,e){let r,n;if(t>=0?(r=t%4294967296|0,n=t/4294967296|0):(r=~(-t%4294967296),n=~(-t/4294967296),4294967295^r?r=r+1|0:(r=0,n=n+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,r){r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,r.buf[r.pos]=127&(t>>>=7);}(r,0,e),function(t,e){const r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))));}(n,e);}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))));}writeSVarint(t){this.writeVarint(t<0?2*-t-1:2*t);}writeBoolean(t){this.writeVarint(+t);}writeString(t){t=String(t),this.realloc(4*t.length),this.pos++;const e=this.pos;this.pos=function(t,e,r){for(let n,i,s=0;s<e.length;s++){if(n=e.charCodeAt(s),n>55295&&n<57344){if(!i){n>56319||s+1===e.length?(t[r++]=239,t[r++]=191,t[r++]=189):i=n;continue}if(n<56320){t[r++]=239,t[r++]=191,t[r++]=189,i=n;continue}n=i-55296<<10|n-56320|65536,i=null;}else i&&(t[r++]=239,t[r++]=191,t[r++]=189,i=null);n<128?t[r++]=n:(n<2048?t[r++]=n>>6|192:(n<65536?t[r++]=n>>12|224:(t[r++]=n>>18|240,t[r++]=n>>12&63|128),t[r++]=n>>6&63|128),t[r++]=63&n|128);}return r}(this.buf,t,this.pos);const r=this.pos-e;r>=128&&ky(e,r,this),this.pos=e-1,this.writeVarint(r),this.pos+=r;}writeFloat(t){this.realloc(4),this.dataView.setFloat32(this.pos,t,!0),this.pos+=4;}writeDouble(t){this.realloc(8),this.dataView.setFloat64(this.pos,t,!0),this.pos+=8;}writeBytes(t){const e=t.length;this.writeVarint(e),this.realloc(e);for(let r=0;r<e;r++)this.buf[this.pos++]=t[r];}writeRawMessage(t,e){this.pos++;const r=this.pos;t(e,this);const n=this.pos-r;n>=128&&ky(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n;}writeMessage(t,e,r){this.writeTag(t,2),this.writeRawMessage(e,r);}writePackedVarint(t,e){e.length&&this.writeMessage(t,By,e);}writePackedSVarint(t,e){e.length&&this.writeMessage(t,zy,e);}writePackedBoolean(t,e){e.length&&this.writeMessage(t,Vy,e);}writePackedFloat(t,e){e.length&&this.writeMessage(t,Ty,e);}writePackedDouble(t,e){e.length&&this.writeMessage(t,Ey,e);}writePackedFixed32(t,e){e.length&&this.writeMessage(t,Fy,e);}writePackedSFixed32(t,e){e.length&&this.writeMessage(t,Cy,e);}writePackedFixed64(t,e){e.length&&this.writeMessage(t,Dy,e);}writePackedSFixed64(t,e){e.length&&this.writeMessage(t,Ry,e);}writeBytesField(t,e){this.writeTag(t,2),this.writeBytes(e);}writeFixed32Field(t,e){this.writeTag(t,5),this.writeFixed32(e);}writeSFixed32Field(t,e){this.writeTag(t,5),this.writeSFixed32(e);}writeFixed64Field(t,e){this.writeTag(t,1),this.writeFixed64(e);}writeSFixed64Field(t,e){this.writeTag(t,1),this.writeSFixed64(e);}writeVarintField(t,e){this.writeTag(t,0),this.writeVarint(e);}writeSVarintField(t,e){this.writeTag(t,0),this.writeSVarint(e);}writeStringField(t,e){this.writeTag(t,2),this.writeString(e);}writeFloatField(t,e){this.writeTag(t,5),this.writeFloat(e);}writeDoubleField(t,e){this.writeTag(t,1),this.writeDouble(e);}writeBooleanField(t,e){this.writeVarintField(t,+e);}};function Py(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function ky(t,e,r){const n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(n);for(let e=r.pos-1;e>=t;e--)r.buf[e+n]=r.buf[e];}function By(t,e){for(let r=0;r<t.length;r++)e.writeVarint(t[r]);}function zy(t,e){for(let r=0;r<t.length;r++)e.writeSVarint(t[r]);}function Ty(t,e){for(let r=0;r<t.length;r++)e.writeFloat(t[r]);}function Ey(t,e){for(let r=0;r<t.length;r++)e.writeDouble(t[r]);}function Vy(t,e){for(let r=0;r<t.length;r++)e.writeBoolean(t[r]);}function Fy(t,e){for(let r=0;r<t.length;r++)e.writeFixed32(t[r]);}function Cy(t,e){for(let r=0;r<t.length;r++)e.writeSFixed32(t[r]);}function Dy(t,e){for(let r=0;r<t.length;r++)e.writeFixed64(t[r]);}function Ry(t,e){for(let r=0;r<t.length;r++)e.writeSFixed64(t[r]);}const Ly=3;function Oy(t,e,r){e.glyphs=[],1===t&&r.readMessage(Uy,e);}function Uy(t,e,r){if(3===t){const{id:t,bitmap:n,width:i,height:s,left:o,top:a,advance:l}=r.readMessage(Ny,{});e.glyphs.push({id:t,bitmap:new _h({width:i+2*Ly,height:s+2*Ly},n),metrics:{width:i,height:s,left:o,top:a,advance:l}});}else 4===t?e.ascender=r.readSVarint():5===t&&(e.descender=r.readSVarint());}function Ny(t,e,r){1===t?e.id=r.readVarint():2===t?e.bitmap=r.readBytes():3===t?e.width=r.readVarint():4===t?e.height=r.readVarint():5===t?e.left=r.readSVarint():6===t?e.top=r.readSVarint():7===t&&(e.advance=r.readVarint());}const jy=Ly,$y={horizontal:1,vertical:2,horizontalOnly:3};class Gy{constructor(){this.scale=1,this.fontStack="",this.image=null;}static forText(t,e){const r=new Gy;return r.scale=t||1,r.fontStack=e,r}static forImage(t){const e=new Gy;return e.image=t,e}}class qy{constructor(){this.text="",this.sectionIndex=[],this.sections=[],this.imageSectionID=null;}static fromFeature(t,e,r){const n=new qy;for(let i=0;i<t.sections.length;i++){const s=t.sections[i];s.image?n.addImageSection(s,r):n.addTextSection(s,e);}return n}length(){return this.text.length}getSection(t){return this.sections[this.sectionIndex[t]]}getSections(){return this.sections}getSectionIndex(t){return this.sectionIndex[t]}getCodePoint(t){return this.text.codePointAt(t)}verticalizePunctuation(t){this.text=function(t,e){let r="";for(let n=0;n<t.length;n++){const i=t.charCodeAt(n+1)||null,s=t.charCodeAt(n-1)||null;r+=!e&&(i&&lo(i)&&!by[t[n+1]]||s&&lo(s)&&!by[t[n-1]])||!by[t[n]]?t[n]:by[t[n]];}return r}(this.text,t);}trim(){let t=0;for(let e=0;e<this.text.length&&Xy[this.text.charCodeAt(e)];e++)t++;let e=this.text.length;for(let r=this.text.length-1;r>=0&&r>=t&&Xy[this.text.charCodeAt(r)];r--)e--;this.text=this.text.substring(t,e),this.sectionIndex=this.sectionIndex.slice(t,e);}substring(t,e){const r=new qy;return r.text=this.text.substring(t,e),r.sectionIndex=this.sectionIndex.slice(t,e),r.sections=this.sections,r}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce(((t,e)=>Math.max(t,this.sections[e].scale)),0)}addTextSection(t,e){this.text+=t.text,this.sections.push(Gy.forText(t.scale,t.fontStack||e));const r=this.sections.length-1;for(let e=0;e<t.text.length;++e)this.sectionIndex.push(r);}addImageSection(t,e){const r=t.image?t.image.getPrimary():null;if(!r)return void Xt("Can't add FormattedSection with an empty image.");r.scaleSelf(e);const n=this.getNextImageSectionCharCode();n?(this.text+=String.fromCodePoint(n),this.sections.push(Gy.forImage(r)),this.sectionIndex.push(this.sections.length-1)):Xt("Reached maximum number of images 6401");}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}}function Hy(t,e,r,n,i,s,o,a,l,u,c,h,p,d,f,m=1){const y=qy.fromFeature(t,i,m);h===$y.vertical&&y.verticalizePunctuation(p);let g=[];const x=function(t,e,r,n,i,s){if(!t)return [];const o=[],a=function(t,e,r,n,i,s){let o=0;for(let r=0;r<t.length();r++){const a=t.getSection(r);o+=Wy(t.getCodePoint(r),a,n,i,e,s);}return o/Math.max(1,Math.ceil(o/r))}(t,e,r,n,i,s),l=t.text.indexOf("​")>=0;let u=0;for(let r=0;r<t.length();r++){const h=t.getSection(r),p=t.getCodePoint(r);if(Xy[p]||(u+=Wy(p,h,n,i,e,s)),r<t.length()-1){const e=!((c=p)<11904||!(no["Bopomofo Extended"](c)||no.Bopomofo(c)||no["CJK Compatibility Forms"](c)||no["CJK Compatibility Ideographs"](c)||no["CJK Compatibility"](c)||no["CJK Radicals Supplement"](c)||no["CJK Strokes"](c)||no["CJK Symbols and Punctuation"](c)||no["CJK Unified Ideographs Extension A"](c)||no["CJK Unified Ideographs"](c)||no["Enclosed CJK Letters and Months"](c)||no["Halfwidth and Fullwidth Forms"](c)||no.Hiragana(c)||no["Ideographic Description Characters"](c)||no["Kangxi Radicals"](c)||no["Katakana Phonetic Extensions"](c)||no.Katakana(c)||no["Vertical Forms"](c)||no["Yi Radicals"](c)||no["Yi Syllables"](c)));(Zy[p]||e||h.image)&&o.push(Jy(r+1,u,a,o,Ky(p,t.getCodePoint(r+1),e&&l),!1));}}var c;return Qy(Jy(t.length(),u,a,o,0,!0))}(y,u,s,e,n,d),{processBidirectionalText:v,processStyledBidirectionalText:b}=Ao;if(v&&1===y.sections.length){const t=v(y.toString(),x);for(const e of t){const t=new qy;t.text=e,t.sections=y.sections;for(let r=0;r<e.length;r++)t.sectionIndex.push(0);g.push(t);}}else if(b){const t=b(y.text,y.sectionIndex,x);for(const e of t){const t=new qy;t.text=e[0],t.sectionIndex=e[1],t.sections=y.sections,g.push(t);}}else g=function(t,e){const r=[],n=t.text;let i=0;for(const n of e)r.push(t.substring(i,n)),i=n;return i<n.length&&r.push(t.substring(i,n.length)),r}(y,x);const w=[],_={positionedLines:w,text:y.toString(),top:c[1],bottom:c[1],left:c[0],right:c[0],writingMode:h,iconsInText:!1,verticalizable:!1,hasBaseline:!1};if(function(t,e,r,n,i,s,o,a,l,u,c,h){let p=0,d=0,f=0;const m="right"===a?1:"left"===a?0:.5;let y=!1;for(const t of i){const r=t.getSections();for(const t of r){if(t.image)continue;const r=e[t.fontStack];if(r&&(y=void 0!==r.ascender&&void 0!==r.descender,!y))break}if(!y)break}let g=0;for(const o of i){o.trim();const i=o.getMaxScale(),a=(i-1)*xy,v={positionedGlyphs:[],lineOffset:0};t.positionedLines[g]=v;const b=v.positionedGlyphs;let w=0;if(!o.length()){d+=s,++g;continue}let _=0,A=0;for(let s=0;s<o.length();s++){const a=o.getSection(s),f=o.getSectionIndex(s),m=o.getCodePoint(s);let g=a.scale,v=null,I=null,M=null,S=xy,P=0,k=l;k===$y.vertical&&(12312===(x=m)||12313===x||12316===x||12540===x||12448===x)&&(k=$y.horizontal);const B=!(k===$y.horizontal||!c&&!ao(m)||c&&(Xy[m]||uo(m)));if(a.image){const e=n.get(a.image.toString());if(!e)continue;M=a.image,t.iconsInText=t.iconsInText||!0,I=e.paddedRect;const r=e.displaySize;g=g*xy/h,v={width:r[0],height:r[1],left:0,top:-jy,advance:B?r[1]:r[0],localGlyph:!1},P=y?-v.height*g:i*xy-17-r[1]*g,S=v.advance;const s=(B?r[0]:r[1])*g-xy*i;s>0&&s>w&&(w=s);}else {const t=r[a.fontStack];if(!t)continue;t[m]&&(I=t[m]);const n=e[a.fontStack];if(!n)continue;const s=n.glyphs[m];if(!s)continue;if(v=s.metrics,S=8203!==m?xy:0,y){const t=void 0!==n.ascender?Math.abs(n.ascender):0,e=void 0!==n.descender?Math.abs(n.descender):0,r=(t+e)*g;_<r&&(_=r,A=(t-e)/2*g),P=-t*g;}else P=(i-g)*xy-17;}B?(t.verticalizable=!0,b.push({glyph:m,image:M,x:p,y:d+P,vertical:B,scale:g,localGlyph:v.localGlyph,fontStack:a.fontStack,sectionIndex:f,metrics:v,rect:I}),p+=S*g+u):(b.push({glyph:m,image:M,x:p,y:d+P,vertical:B,scale:g,localGlyph:v.localGlyph,fontStack:a.fontStack,sectionIndex:f,metrics:v,rect:I}),p+=v.advance*g+u);}0!==b.length&&(f=Math.max(p-u,f),y?eg(b,m,w,A,s*i/2):eg(b,m,w,0,s/2)),p=0;const I=s*i+w;v.lineOffset=Math.max(w,a),d+=I,++g;}var x;const v=d,{horizontalAlign:b,verticalAlign:w}=tg(o);((function(t,e,r,n,i,s){const o=(e-r)*i,a=-s*n;for(const e of t)for(const t of e.positionedGlyphs)t.x+=o,t.y+=a;}))(t.positionedLines,m,b,w,f,v),t.top+=-w*v,t.bottom=t.top+v,t.left+=-b*f,t.right=t.left+f,t.hasBaseline=y;}(_,e,r,n,g,o,a,l,h,u,p,f),!function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return !1;return !0}(w))return _}const Xy={9:!0,10:!0,11:!0,12:!0,13:!0,32:!0},Zy={10:!0,32:!0,38:!0,40:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0};function Wy(t,e,r,n,i,s){if(e.image){const t=n.get(e.image.toString());return t?t.displaySize[0]*e.scale*xy/s+i:0}{const n=r[e.fontStack],s=n&&n.glyphs[t];return s?s.metrics.advance*e.scale+i:0}}function Yy(t,e,r,n){const i=Math.pow(t-e,2);return n?t<e?i/2:2*i:i+Math.abs(r)*r}function Ky(t,e,r){let n=0;return 10===t&&(n-=1e4),r&&(n+=150),40!==t&&65288!==t||(n+=50),41!==e&&65289!==e||(n+=50),n}function Jy(t,e,r,n,i,s){let o=null,a=Yy(e,r,i,s);for(const t of n){const n=Yy(e-t.x,r,i,s)+t.badness;n<=a&&(o=t,a=n);}return {index:t,x:e,priorBreak:o,badness:a}}function Qy(t){return t?Qy(t.priorBreak).concat(t.index):[]}function tg(t){let e=.5,r=.5;switch(t){case "right":case "top-right":case "bottom-right":e=1;break;case "left":case "top-left":case "bottom-left":e=0;}switch(t){case "bottom":case "bottom-right":case "bottom-left":r=1;break;case "top":case "top-right":case "top-left":r=0;}return {horizontalAlign:e,verticalAlign:r}}function eg(t,e,r,n,i){if(!(e||r||n||i))return;const s=t.length-1,o=t[s],a=(o.x+o.metrics.advance*o.scale)*e;for(let e=0;e<=s;e++)t[e].x-=a,t[e].y+=r+n+i;}function rg(t){return void 0!==t.imagePrimary&&void 0!==t.top&&void 0!==t.bottom&&void 0!==t.left&&void 0!==t.right}function ng(t,e,r,n){const{horizontalAlign:i,verticalAlign:s}=tg(n),o=r[0]-t.displaySize[0]*i,a=r[1]-t.displaySize[1]*s;return {imagePrimary:t,imageSecondary:e,top:a,bottom:a+t.displaySize[1],left:o,right:o+t.displaySize[0]}}function ig(t,e,r,n,i,s){const o=t.imagePrimary;let a;if(o.content){const t=o.content,e=o.pixelRatio||1;a=[t[0]/e,t[1]/e,o.displaySize[0]-t[2]/e,o.displaySize[1]-t[3]/e];}const l=e.left*s,u=e.right*s;let c,h,p,d;"width"===r||"both"===r?(d=i[0]+l-n[3],h=i[0]+u+n[1]):(d=i[0]+(l+u-o.displaySize[0])/2,h=d+o.displaySize[0]);const f=e.top*s,m=e.bottom*s;return "height"===r||"both"===r?(c=i[1]+f-n[0],p=i[1]+m+n[2]):(c=i[1]+(f+m-o.displaySize[1])/2,p=c+o.displaySize[1]),{imagePrimary:o,imageSecondary:void 0,top:c,right:h,bottom:p,left:d,collisionPadding:a}}function sg(t){return !t.imagePrimary.stretchX}function og(t){return !t.imagePrimary.stretchY}function ag(t){return {width:t.right-t.left,height:t.bottom-t.top}}const lg=128;function ug(t,e,r){const{expression:n}=e;if("constant"===n.kind)return {kind:"constant",layoutSize:n.evaluate(new Io(t+1,{worldview:r}))};if("source"===n.kind)return {kind:"source"};{const{zoomStops:e,interpolationType:i}=n;let s=0;for(;s<e.length&&e[s]<=t;)s++;s=Math.max(0,s-1);let o=s;for(;o<e.length&&e[o]<t+1;)o++;o=Math.min(e.length-1,o);const a=e[s],l=e[o];return "composite"===n.kind?{kind:"composite",minZoom:a,maxZoom:l,interpolationType:i}:{kind:"camera",minZoom:a,maxZoom:l,minSize:n.evaluate(new Io(a,{worldview:r})),maxSize:n.evaluate(new Io(l,{worldview:r})),interpolationType:i}}}function cg(t,{uSize:e,uSizeT:r},{lowerSize:n,upperSize:i}){return "source"===t.kind?n/lg:"composite"===t.kind?pr(n/lg,i/lg,r):e}function hg(t,e,r=1){let n=0,i=0;if("constant"===t.kind)i=t.layoutSize*r;else if("source"!==t.kind){const{interpolationType:s,minZoom:o,maxZoom:a}=t,l=s?Ft(Xi.interpolationFactor(s,e,o,a),0,1):0;"camera"===t.kind?i=pr(t.minSize,t.maxSize,l)*r:n=l*r;}return {uSizeT:n,uSize:i}}class pg extends It{constructor(t,e,r,n,i){super(t,e),this.angle=n,this.z=r,void 0!==i&&(this.segment=i);}clone(){return new pg(this.x,this.y,this.z,this.angle,this.segment)}}function dg(t,e,r,n,i){if(void 0===e.segment)return !0;let s=e,o=e.segment+1,a=0;for(;a>-r/2;){if(o--,o<0)return !1;a-=t[o].dist(s),s=t[o];}a+=t[o].dist(t[o+1]),o++;const l=[];let u=0;for(;a<r/2;){const e=t[o],r=t[o+1];if(!r)return !1;let s=t[o-1].angleTo(e)-e.angleTo(r);for(s=Math.abs((s+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:a,angleDelta:s}),u+=s;a-l[0].distance>n;)u-=l.shift().angleDelta;if(u>i)return !1;o++,a+=e.dist(r);}return !0}function fg(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e}function mg(t,e,r){return t?.6*e*r:0}function yg(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0)}function gg(t,e,r,n,i,s){const o=mg(r,i,s),a=yg(r,n)*s;let l=0;const u=fg(t)/2;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1],s=n.dist(i);if(l+s>u){const c=(u-l)/s,h=pr(n.x,i.x,c),p=pr(n.y,i.y,c),d=new pg(h,p,0,i.angleTo(n),r);return !o||dg(t,d,a,o,e)?d:void 0}l+=s;}}function xg(t,e,r,n,i,s,o,a,l){const u=mg(n,s,o),c=yg(n,i),h=c*o,p=0===t[0].x||t[0].x===l||0===t[0].y||t[0].y===l;return e-h<e/4&&(e=h+e/4),vg(t,p?e/2*a%e:(c/2+2*s)*o*a%e,e,u,r,h,p,!1,l)}function vg(t,e,r,n,i,s,o,a,l){const u=s/2,c=fg(t);let h=0,p=e-r,d=[];for(let e=0;e<t.length-1;e++){const o=t[e],a=t[e+1],f=o.dist(a),m=a.angleTo(o);for(;p+r<h+f;){p+=r;const y=(p-h)/f,g=pr(o.x,a.x,y),x=pr(o.y,a.y,y);if(g>=0&&g<l&&x>=0&&x<l&&p-u>=0&&p+u<=c){const r=new pg(g,x,0,m,e);n&&!dg(t,r,s,n,i)||d.push(r);}}h+=f;}return a||d.length||o||(d=vg(t,h/2,r,n,i,s,o,!0,l)),d}function bg(t){let e=0,r=0;for(const n of t)e+=n.w*n.h,r=Math.max(r,n.w);t.sort(((t,e)=>e.h-t.h));const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let i=0,s=0;for(const e of t)for(let t=n.length-1;t>=0;t--){const r=n[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x,e.y=r.y,s=Math.max(s,e.y+e.h),i=Math.max(i,e.x+e.w),e.w===r.w&&e.h===r.h){const e=n.pop();e&&t<n.length&&(n[t]=e);}else e.h===r.h?(r.x+=e.w,r.w-=e.w):e.w===r.w?(r.y+=e.h,r.h-=e.h):(n.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}),r.y+=e.h,r.h-=e.h);break}}return {w:i,h:s,fill:e/(i*s)||0}}Qs(pg,"Anchor");const wg=1;class _g{static getImagePositionScale(t,e,r){if(e&&t){const{sx:e,sy:r}=t;return {x:e,y:r}}return {x:r,y:r}}constructor(t,e,r,n){this.paddedRect=t;const{pixelRatio:i,version:s,stretchX:o,stretchY:a,content:l,sdf:u,usvg:c}=e;this.pixelRatio=i,this.stretchX=o,this.stretchY=a,this.content=l,this.version=s,this.padding=r,this.sdf=u,this.usvg=c,this.scale=_g.getImagePositionScale(n,c,i);}get tl(){return [this.paddedRect.x+this.padding,this.paddedRect.y+this.padding]}get br(){return [this.paddedRect.x+this.paddedRect.w-this.padding,this.paddedRect.y+this.paddedRect.h-this.padding]}get displaySize(){return [(this.paddedRect.w-2*this.padding)/this.scale.x,(this.paddedRect.h-2*this.padding)/this.scale.y]}}function Ag(t,e,r){const n=Rr.parse(t),i=function(t,e,r=[1,1]){return {x:0,y:0,w:(t.data?t.data.width:t.width*r[0])+2*e,h:(t.data?t.data.height:t.height*r[1])+2*e}}(e,r,[n.sx,n.sy]);return {bin:i,imagePosition:new _g(i,e,r,n),imageVariant:n}}class Ig{constructor(t,e,r){const n=new Map,i=new Map;this.haveRenderCallbacks=[];const s=[];this.addImages(t,n,wg,s),this.addImages(e,i,2,s);const{w:o,h:a}=bg(s),l=new Ah({width:o||1,height:a||1});for(const[e,r]of t.entries()){const t=n.get(e).paddedRect;Ah.copy(r.data,l,{x:0,y:0},{x:t.x+wg,y:t.y+wg},r.data,null,r.sdf);}for(const[t,n]of e.entries()){const e=i.get(t),s=e.paddedRect;let o=e.padding;const a=s.x+o,u=s.y+o,c=n.data.width,h=n.data.height;o=o>1?o-1:o,Ah.copy(n.data,l,{x:0,y:0},{x:a,y:u},n.data,r),Ah.copy(n.data,l,{x:0,y:h-o},{x:a,y:u-o},{width:c,height:o},r),Ah.copy(n.data,l,{x:0,y:0},{x:a,y:u+h},{width:c,height:o},r),Ah.copy(n.data,l,{x:c-o,y:0},{x:a-o,y:u},{width:o,height:h},r),Ah.copy(n.data,l,{x:0,y:0},{x:a+c,y:u},{width:o,height:h},r),Ah.copy(n.data,l,{x:c-o,y:h-o},{x:a-o,y:u-o},{width:o,height:o},r),Ah.copy(n.data,l,{x:0,y:h-o},{x:a+c,y:u-o},{width:o,height:o},r),Ah.copy(n.data,l,{x:0,y:0},{x:a+c,y:u+h},{width:o,height:o},r),Ah.copy(n.data,l,{x:c-o,y:0},{x:a-o,y:u+h},{width:o,height:o},r);}this.lut=r,this.image=l,this.iconPositions=n,this.patternPositions=i;}addImages(t,e,r,n){for(const[i,s]of t.entries()){const{bin:t,imagePosition:o,imageVariant:a}=Ag(i,s,r);e.set(i,o),n.push(t),s.hasRenderCallback&&this.haveRenderCallbacks.push(a.id);}}patchUpdatedImages(t,e,r){this.haveRenderCallbacks=this.haveRenderCallbacks.filter((e=>t.hasImage(e,r))),t.dispatchRenderCallbacks(this.haveRenderCallbacks,r);for(const n of t.getUpdatedImages(r)){for(const i of this.iconPositions.keys()){const s=Rr.parse(i);if(ir.isEqual(s.id,n)){const s=t.getImage(n,r);this.patchUpdatedImage(this.iconPositions.get(i),s,e,null);}}for(const i of this.patternPositions.keys()){const s=Rr.parse(i);if(ir.isEqual(s.id,n)){const s=t.getImage(n,r);this.patchUpdatedImage(this.patternPositions.get(i),s,e,this.lut);}}}}patchUpdatedImage(t,e,r,n=null){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[i,s]=t.tl,o=t.sdf;if(this.lut||o){const t={width:e.data.width,height:e.data.height},a=new Ah(t);Ah.copy(e.data,a,{x:0,y:0},{x:0,y:0},t,n,o),r.update(a,{position:{x:i,y:s}});}else r.update(e.data,{position:{x:i,y:s}});}}Qs(_g,"ImagePosition"),Qs(Ig,"ImageAtlas");const Mg=1e20;function Sg(t,e,r,n,i,s,o,a,l){for(let u=e;u<e+n;u++)Pg(t,r*s+u,s,i,o,a,l);for(let u=r;u<r+i;u++)Pg(t,u*s+e,1,n,o,a,l);}function Pg(t,e,r,n,i,s,o){s[0]=0,o[0]=-Mg,o[1]=Mg,i[0]=t[e];for(let a=1,l=0,u=0;a<n;a++){i[a]=t[e+a*r];const n=a*a;do{const t=s[l];u=(i[a]-i[t]+n-t*t)/(a-t)/2;}while(u<=o[l]&&--l>-1);l++,s[l]=a,o[l]=u,o[l+1]=Mg;}for(let a=0,l=0;a<n;a++){for(;o[l+1]<a;)l++;const n=s[l],u=a-n;t[e+a*r]=i[n]+u*u;}}const kg=2,Bg={none:0,ideographs:1,all:2};class zg{constructor(t,e,r){this.requestManager=t,this.localGlyphMode=e,this.localFontFamily=r,this.url="",this.entries={},this.localGlyphs={200:{},400:{},500:{},900:{}};}setURL(t){this.url=t;}getGlyphs(t,e){const r=[],n=this.url||oe.GLYPHS_URL;for(const e in t)for(const n of t[e])r.push({stack:e,id:n});Rt(r,(({stack:t,id:e},r)=>{let i=this.entries[t];i||(i=this.entries[t]={glyphs:{},requests:{},ranges:{},ascender:void 0,descender:void 0});let s=i.glyphs[e];if(void 0!==s)return void r(null,{stack:t,id:e,glyph:s});if(s=this._tinySDF(i,t,e),s)return i.glyphs[e]=s,void r(null,{stack:t,id:e,glyph:s});const o=Math.floor(e/256);if(256*o>65535)return Xt("glyphs > 65535 not supported"),void r(null,{stack:t,id:e,glyph:s});if(i.ranges[o])return void r(null,{stack:t,id:e,glyph:s});let a=i.requests[o];a||(a=i.requests[o]=[],zg.loadGlyphRange(t,o,n,this.requestManager,((t,e)=>{if(e){i.ascender=e.ascender,i.descender=e.descender;for(const t in e.glyphs)this._doesCharSupportLocalGlyph(+t)||(i.glyphs[+t]=e.glyphs[+t]);i.ranges[o]=!0;}for(const r of a)r(t,e);delete i.requests[o];}))),a.push(((n,i)=>{n?r(n):i&&r(null,{stack:t,id:e,glyph:i.glyphs[e]||null});}));}),((t,r)=>{if(t)e(t);else if(r){const t={};for(const{stack:e,id:n,glyph:i}of r)void 0===t[e]&&(t[e]={}),void 0===t[e].glyphs&&(t[e].glyphs={}),t[e].glyphs[n]=i&&{id:i.id,bitmap:i.bitmap.clone(),metrics:i.metrics},t[e].ascender=this.entries[e].ascender,t[e].descender=this.entries[e].descender;e(null,t);}}));}_doesCharSupportLocalGlyph(t){return this.localGlyphMode!==Bg.none&&(this.localGlyphMode===Bg.all?!!this.localFontFamily:!!this.localFontFamily&&(no["CJK Unified Ideographs"](t)||no["Hangul Syllables"](t)||no.Hiragana(t)||no.Katakana(t)||no["CJK Symbols and Punctuation"](t)||no["CJK Unified Ideographs Extension A"](t)||no["CJK Unified Ideographs Extension B"](t)||no.Osage(t)))}_tinySDF(t,e,r){const n=this.localFontFamily;if(!n||!this._doesCharSupportLocalGlyph(r))return;let i=t.tinySDF;if(!i){let r="400";/bold/i.test(e)?r="900":/medium/i.test(e)?r="500":/light/i.test(e)&&(r="200"),i=t.tinySDF=new zg.TinySDF({fontFamily:n,fontWeight:r,fontSize:24*kg,buffer:3*kg,radius:8*kg}),i.fontWeight=r;}if(this.localGlyphs[i.fontWeight][r])return this.localGlyphs[i.fontWeight][r];const s=String.fromCodePoint(r),{data:o,width:a,height:l,glyphWidth:u,glyphHeight:c,glyphLeft:h,glyphTop:p,glyphAdvance:d}=i.draw(s);return this.localGlyphs[i.fontWeight][r]={id:r,bitmap:new _h({width:a,height:l},o),metrics:{width:u/kg,height:c/kg,left:h/kg,top:p/kg-27,advance:d/kg,localGlyph:!0}}}}zg.loadGlyphRange=function(t,e,r,n,i){const s=256*e,o=s+255,a=n.transformRequest(n.normalizeGlyphsURL(r).replace("{fontstack}",t).replace("{range}",`${s}-${o}`),Ce.Glyphs);Oe(a,((t,e)=>{if(t)i(t);else if(e){const t={},r=function(t){return new Sy(t).readFields(Oy,{})}(e);for(const e of r.glyphs)t[e.id]=e;i(null,{glyphs:t,ascender:r.ascender,descender:r.descender});}}));},zg.TinySDF=class{constructor({fontSize:t=24,buffer:e=3,radius:r=8,cutoff:n=.25,fontFamily:i="sans-serif",fontWeight:s="normal",fontStyle:o="normal",lang:a=null}={}){this.buffer=e,this.cutoff=n,this.radius=r,this.lang=a;const l=this.size=t+4*e,u=this._createCanvas(l),c=this.ctx=u.getContext("2d",{willReadFrequently:!0});c.font=`${o} ${s} ${t}px ${i}`,c.textBaseline="alphabetic",c.textAlign="left",c.fillStyle="black",this.gridOuter=new Float64Array(l*l),this.gridInner=new Float64Array(l*l),this.f=new Float64Array(l),this.z=new Float64Array(l+1),this.v=new Uint16Array(l);}_createCanvas(t){const e=document.createElement("canvas");return e.width=e.height=t,e}draw(t){const{width:e,actualBoundingBoxAscent:r,actualBoundingBoxDescent:n,actualBoundingBoxLeft:i,actualBoundingBoxRight:s}=this.ctx.measureText(t),o=Math.ceil(r),a=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(s-i))),l=Math.min(this.size-this.buffer,o+Math.ceil(n)),u=a+2*this.buffer,c=l+2*this.buffer,h=Math.max(u*c,0),p=new Uint8ClampedArray(h),d={data:p,width:u,height:c,glyphWidth:a,glyphHeight:l,glyphTop:o,glyphLeft:0,glyphAdvance:e};if(0===a||0===l)return d;const{ctx:f,buffer:m,gridInner:y,gridOuter:g}=this;this.lang&&(f.lang=this.lang),f.clearRect(m,m,a,l),f.fillText(t,m,m+o);const x=f.getImageData(m,m,a,l);g.fill(Mg,0,h),y.fill(0,0,h);for(let t=0;t<l;t++)for(let e=0;e<a;e++){const r=x.data[4*(t*a+e)+3]/255;if(0===r)continue;const n=(t+m)*u+e+m;if(1===r)g[n]=0,y[n]=Mg;else {const t=.5-r;g[n]=t>0?t*t:0,y[n]=t<0?t*t:0;}}Sg(g,0,0,u,c,u,this.f,this.v,this.z),Sg(y,m,m,a,l,u,this.f,this.v,this.z);for(let t=0;t<h;t++){const e=Math.sqrt(g[t])-Math.sqrt(y[t]);p[t]=Math.round(255-255*(e/this.radius+this.cutoff));}return d}};const Tg=wg;function Eg(t,e){return t+e[1]-e[0]}function Vg(t,e,r,n,i=1){const s=[],o=t.imagePrimary,a=o.pixelRatio,l=o.paddedRect.w-2*Tg,u=o.paddedRect.h-2*Tg,c=(t.right-t.left)*i,h=(t.bottom-t.top)*i,p=o.stretchX||[[0,l]],d=o.stretchY||[[0,u]],f=p.reduce(Eg,0),m=d.reduce(Eg,0),y=l-f,g=u-m;let x=0,v=f,b=0,w=m,_=0,A=y,I=0,M=g;if(o.content&&n){const t=o.content;x=Cg(p,0,t[0]),b=Cg(d,0,t[1]),v=Cg(p,t[0],t[2]),w=Cg(d,t[1],t[3]),_=t[0]-x,I=t[1]-b,A=t[2]-t[0]-v,M=t[3]-t[1]-w;}const S=(n,s,l,u)=>{const p=Lg(n.stretch-x,v,c,t.left*i),d=Og(n.fixed-_,A,n.stretch,f),y=Lg(s.stretch-b,w,h,t.top*i),g=Og(s.fixed-I,M,s.stretch,m),S=Lg(l.stretch-x,v,c,t.left*i),P=Og(l.fixed-_,A,l.stretch,f),k=Lg(u.stretch-b,w,h,t.top*i),B=Og(u.fixed-I,M,u.stretch,m),z=new It(p,y),T=new It(S,y),E=new It(S,k),V=new It(p,k),F=new It(d/a,g/a),C=new It(P/a,B/a),D=e*Math.PI/180;if(D){const t=Math.sin(D),e=Math.cos(D),r=[e,-t,t,e];z._matMult(r),T._matMult(r),V._matMult(r),E._matMult(r);}const R=n.stretch+n.fixed,L=l.stretch+l.fixed,O=s.stretch+s.fixed,U=u.stretch+u.fixed,N=t.imageSecondary;return {tl:z,tr:T,bl:V,br:E,texPrimary:{x:o.paddedRect.x+Tg+R,y:o.paddedRect.y+Tg+O,w:L-R,h:U-O},texSecondary:N?{x:N.paddedRect.x+Tg+R,y:N.paddedRect.y+Tg+O,w:L-R,h:U-O}:void 0,writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:F,pixelOffsetBR:C,minFontScaleX:A/a/c,minFontScaleY:M/a/h,isSDF:r}};if(n&&(o.stretchX||o.stretchY)){const t=Dg(p,y,f),e=Dg(d,g,m);for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)s.push(S(n,e[t],i,e[t+1]));}}else s.push(S({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:l+1},{fixed:0,stretch:u+1}));return s}function Fg(t,e){const r=t.stretchY||[[0,t.paddedRect.h-2*Tg]];return e&&(t.stretchX||t.stretchY)?Rg(t.stretchX||[[0,t.paddedRect.w-2*Tg]])*Rg(r):1}function Cg(t,e,r){let n=0;for(const i of t)n+=Math.max(e,Math.min(r,i[1]))-Math.max(e,Math.min(r,i[0]));return n}function Dg(t,e,r){const n=[{fixed:-Tg,stretch:0}];for(const[e,r]of t){const t=n[n.length-1];n.push({fixed:e-t.stretch,stretch:t.stretch}),n.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)});}return n.push({fixed:e+Tg,stretch:r}),n}function Rg(t){return 2*t.length+1}function Lg(t,e,r,n){return t/e*r+n}function Og(t,e,r,n){return t-e*r/n}function Ug(t,e,r,n){const i=e+t.positionedLines[n].lineOffset;return 0===n?r+i/2:r+(i+(e+t.positionedLines[n-1].lineOffset))/2}function Ng(t,e=1,r=!1){let n=1/0,i=1/0,s=-1/0,o=-1/0;const a=t[0];for(let t=0;t<a.length;t++){const e=a[t];(!t||e.x<n)&&(n=e.x),(!t||e.y<i)&&(i=e.y),(!t||e.x>s)&&(s=e.x),(!t||e.y>o)&&(o=e.y);}const l=Math.min(s-n,o-i);let u=l/2;const c=new On([],jg);if(0===l)return new It(n,i);for(let e=n;e<s;e+=l)for(let r=i;r<o;r+=l)c.push(new $g(e+u,r+u,u,t));let h=function(t){let e=0,r=0,n=0;const i=t[0];for(let t=0,s=i.length,o=s-1;t<s;o=t++){const s=i[t],a=i[o],l=s.x*a.y-a.x*s.y;r+=(s.x+a.x)*l,n+=(s.y+a.y)*l,e+=3*l;}return new $g(r/e,n/e,0,t)}(t),p=c.length;for(;c.length;){const n=c.pop();(n.d>h.d||!h.d)&&(h=n,r&&console.log("found best %d after %d probes",Math.round(1e4*n.d)/1e4,p)),n.max-h.d<=e||(u=n.h/2,c.push(new $g(n.p.x-u,n.p.y-u,u,t)),c.push(new $g(n.p.x+u,n.p.y-u,u,t)),c.push(new $g(n.p.x-u,n.p.y+u,u,t)),c.push(new $g(n.p.x+u,n.p.y+u,u,t)),p+=4);}return r&&(console.log(`num probes: ${p}`),console.log(`best distance: ${h.d}`)),h.p}function jg(t,e){return e.max-t.max}class $g{constructor(t,e,r,n){this.p=new It(t,e),this.h=r,this.d=function(t,e){let r=!1,n=1/0;for(let i=0;i<e.length;i++){const s=e[i];for(let e=0,i=s.length,o=i-1;e<i;o=e++){const i=s[e],a=s[o];i.y>t.y!=a.y>t.y&&t.x<(a.x-i.x)*(t.y-i.y)/(a.y-i.y)+i.x&&(r=!r),n=Math.min(n,dc(t,i,a));}}return (r?1:-1)*Math.sqrt(n)}(this.p,n),this.max=this.d+this.h*Math.SQRT2;}}const Gg=Object.keys,qg=Number.POSITIVE_INFINITY,Hg=Math.sqrt(2);function Xg(t,e,r,n,i){const s=rg(t)&&t.collisionPadding?t.collisionPadding:[0,0,0,0],o={top:t.top-s[1],bottom:t.bottom+s[3],left:t.left-s[0],right:t.right+s[2],scaled:!1};return void 0!==n&&function(t,e){t.top*=e,t.bottom*=e,t.left*=e,t.right*=e,t.scaled=!0;}(o,n),r&&function(t,e){if(!e)return;const r=kt(e),n=new It(t.left,t.top),i=new It(t.right,t.top),s=new It(t.left,t.bottom),o=new It(t.right,t.bottom),a=new It(0,0);n._rotateAround(r,a),i._rotateAround(r,a),s._rotateAround(r,a),o._rotateAround(r,a),t.left=Math.min(n.x,i.x,s.x,o.x),t.right=Math.max(n.x,i.x,s.x,o.x),t.top=Math.min(n.y,i.y,s.y,o.y),t.bottom=Math.max(n.y,i.y,s.y,o.y);}(o,r),i&&(o.left+=i[0],o.right+=i[0],o.top+=i[1],o.bottom+=i[1]),e?{top:Math.min(e.top,o.top),bottom:Math.max(e.bottom,o.bottom),left:Math.min(e.left,o.left),right:Math.max(e.right,o.right),scaled:e.scaled||o.scaled}:o}function Zg(t,[e,r]){let n=0,i=0;if(r===qg){e<0&&(e=0);const r=e/Hg;switch(t){case "top-right":case "top-left":i=r-7;break;case "bottom-right":case "bottom-left":i=7-r;break;case "bottom":i=7-e;break;case "top":i=e-7;}switch(t){case "top-right":case "bottom-right":n=-r;break;case "top-left":case "bottom-left":n=r;break;case "left":n=e;break;case "right":n=-e;}}else {switch(e=Math.abs(e),r=Math.abs(r),t){case "top-right":case "top-left":case "top":i=r-7;break;case "bottom-right":case "bottom-left":case "bottom":i=7-r;}switch(t){case "top-right":case "bottom-right":case "right":n=-e;break;case "top-left":case "bottom-left":case "left":n=e;}}return [n,i]}function Wg(t,e,r,n,i,s,o,a,l,u,c,h,p,d){const f=t.layers[0],m=f.appearances;if(0===m.length)return {iconBBox:null,iconVerticalBBox:null,textBBox:null,textVerticalBBox:null};const y={iconBBox:null,iconVerticalBBox:null},g={textBBox:null,textVerticalBBox:null},{baseIconRotate:x,baseTextRotate:v,iconScaleFactor:b}=function(t,e,r){const n=t.get("icon-rotate").evaluate(e,{},r),i=t.get("text-rotate").evaluate(e,{},r),[s,o]=t.get("icon-size-scale-range");return {baseIconRotate:n,baseTextRotate:i,iconScaleFactor:Ft(1,s,o)}}(n,i,s);e&&(y.iconBBox=Xg(e,y.iconBBox,x,o),r)&&(y.iconVerticalBBox=Xg(r,y.iconVerticalBBox,x+90,o));const w=hx(h.horizontal);w&&(g.textBBox=Xg(w,g.textBBox,v,1,d)),h.vertical&&(g.textVerticalBBox=Xg(h.vertical,g.textVerticalBBox,v+90,1,d));for(const r of m)r.hasIconProperties()&&Yg(y,t,f,r,i,s,a,x,o,l,e,u,b,c),r.hasTextProperties()&&Kg(g,f,r,i,s,d,v,p,w,h.vertical);return {iconBBox:y.iconBBox,iconVerticalBBox:y.iconVerticalBBox,textBBox:g.textBBox,textVerticalBBox:g.textVerticalBBox}}function Yg(t,e,r,n,i,s,o,a,l,u,c,h,p,d){const{appearanceIconOffset:f,appearanceIconRotate:m,appearanceIconSize:y}=function(t,e,r,n,i,s,o,a){const l=t.hasProperty("icon-offset")?e.getAppearanceValueAndResolveTokens(t,"icon-offset",r,n,[]):null,u=l&&Array.isArray(l)?l:i,c=t.hasProperty("icon-rotate")?e.getAppearanceValueAndResolveTokens(t,"icon-rotate",r,n,[]):null,h="number"==typeof c?c:s,p=t.hasProperty("icon-size")?e.getAppearanceValueAndResolveTokens(t,"icon-size",r,n,[]):null;return {appearanceIconOffset:u,appearanceIconRotate:h,appearanceIconSize:"number"==typeof p?p*a.iconScaleFactor:o}}(n,r,i,s,o,a,l,u);let g=null,x=null,v=null;n.hasProperty("icon-image")?v=function(t,e,r,n,i,s,o){let a=null;const l=e.getAppearanceValueAndResolveTokens(r,"icon-image",n,i,[]);if(l){const e=t.getResolvedImageFromTokens(l),u=r.getUnevaluatedProperty("icon-size"),c=tx(e,ug(t.zoom,u,t.worldview),u,i,t.zoom,n,t.pixelRatio,o,t.worldview);a=s.get(c.iconPrimary.toString());}return a}(e,r,n,i,s,h,p):c&&(v=c.imagePrimary),v&&(g=ng(v,null,f,d),e.allowVerticalPlacement&&(x=ng(v,null,f,d))),g&&(t.iconBBox=Xg(g,t.iconBBox,m,y)),x&&(t.iconVerticalBBox=Xg(x,t.iconVerticalBBox,m+90,y));}function Kg(t,e,r,n,i,s,o,a,l,u){const{appearanceTextOffset:c,appearanceTextRotate:h,appearanceTextSize:p}=function(t,e,r,n,i,s,o){const a=t.hasProperty("text-offset")?e.getAppearanceValueAndResolveTokens(t,"text-offset",r,n,[]):null,l=a&&Array.isArray(a)?[a[0]*xy,a[1]*xy]:i,u=t.hasProperty("text-rotate")?e.getAppearanceValueAndResolveTokens(t,"text-rotate",r,n,[]):null,c="number"==typeof u?u:s,h=t.hasProperty("text-size")?e.getAppearanceValueAndResolveTokens(t,"text-size",r,n,[]):null;return {appearanceTextOffset:l,appearanceTextRotate:c,appearanceTextSize:"number"==typeof h?h:o}}(r,e,n,i,s,o,a),d=p/a;l&&(t.textBBox=Xg(l,t.textBBox,h,d,c)),u&&(t.textVerticalBBox=Xg(u,t.textVerticalBBox,h+90,d,c));}function Jg(t,e,r,n,i,s,o,a,l){if(!e||!e.usvg)return;const u=ag(n),c=ag(i),h="both"!==s&&"width"!==s||!sg(n)?1:c.width/u.width,p="both"!==s&&"height"!==s||!og(n)?1:c.height/u.height;r.scaleSelf(h,p);const d=r.toString();o.set(d,r),a.set(d,e);const{imagePosition:f}=Ag(d,e,wg);l.set(d,f);}function Qg(t,e,r,n,i,s,o,a,l){if(!t)return;const u=function(t,e,r,n,i,s){if("camera"===t.kind)return t.maxSize;if("composite"===t.kind){const n=e.possiblyEvaluate(new Io(t.maxZoom,{worldview:s}),r).evaluate(i,{},r),o=e.possiblyEvaluate(new Io(t.minZoom,{worldview:s}),r).evaluate(i,{},r);return Math.max(n,o)}return e.possiblyEvaluate(new Io(n,{worldview:s})).evaluate(i,{},r)}(e,r,n,i,s,l);return t.scaleSelf(u*a*o)}function tx(t,e,r,n,i,s,o,a,l){return {iconPrimary:Qg(t.getPrimary(),e,r,n,i,s,o,a,l),iconSecondary:Qg(t.getSecondary(),e,r,n,i,s,o,a,l)}}function ex(t,e,r){if(!e)return;const n=r.get(t.toString()),i=r.get(e.toString());n&&i&&(n.paddedRect.w===i.paddedRect.w&&n.paddedRect.h===i.paddedRect.h||Xt(`Mismatch in icon variant sizes: ${t.toString()} and ${e.toString()}`),n.usvg!==i.usvg&&Xt(`Mismatch in icon variant image types: ${t.id} and ${e.id}`));}function rx(t,e,r,n){if(!t)return;const i=e.get(r.toString());if(t.imagePrimary=i,n){const r=e.get(n.toString());t.imageSecondary=r;}}function nx(t,e){for(const r in t.horizontal)ix(t.horizontal[r],e);ix(t.vertical,e);}function ix(t,e){if(t)for(const r of t.positionedLines)for(const t of r.positionedGlyphs)if(null!==t.image){const r=t.image.toString();t.rect=e.get(r).paddedRect;}}function sx(t){switch(t){case "right":case "top-right":case "bottom-right":return "right";case "left":case "top-left":case "bottom-left":return "left"}return "center"}function ox(t,e,r,n,i,s,o,a,l){const u=hx(s.horizontal)||s.vertical,c=r.get("icon-text-fit-padding").evaluate(n,{},i);let h,p=e;return e&&"none"!==l&&(t.allowVerticalPlacement&&s.vertical&&(h=ig(e,s.vertical,l,c,a,o)),u&&(p=ig(e,u,l,c,a,o))),{defaultShapedIcon:p,verticallyShapedIcon:h}}function ax(t,e,r,n,i,s,o,a,l,u,c,h,p,d,f,m,y,g,x,v,b,w,_,A){let I=o.textMaxSize.evaluate(e,{},p);void 0===I?I=a*o.textScaleFactor:I*=o.textScaleFactor;const M=t.layers[0].layout,S=xy,P=a*o.textScaleFactor/S,k=hx(r.horizontal)||r.vertical;if("none"!==y&&t.appearanceFeatureData&&e.index<t.appearanceFeatureData.length){const r=t.appearanceFeatureData[e.index];r&&(r.textShaping=k,r.iconTextFitPadding=M.get("icon-text-fit-padding").evaluate(e,{},p),r.fontScale=P);}const B="globe"===d.name,z=t.tilePixelRatio*I/S,T=(R=t.overscaling,t.zoom>18&&R>2&&(R>>=1),Math.max(Un/(512*R),1)*M.get("symbol-spacing")),E=M.get("text-padding")*t.tilePixelRatio,V=M.get("icon-padding")*t.tilePixelRatio,F=kt(M.get("text-max-angle")),C="map"===M.get("icon-rotation-alignment")&&"point"!==v,D=T/2;var R;!1===t.hasAnyIconTextFit&&"none"!==y&&(t.hasAnyIconTextFit=!0);const L=e.properties?+e.properties[Ru]:null,O=L&&t.elevationFeatureIdToIndex?t.elevationFeatureIdToIndex.get(L):65535,U=(a,l,v)=>{if(l.x<0||l.x>=Un||l.y<0||l.y>=Un)return;let A=null;if(B){const{x:t,y:e,z:r}=d.projectTilePoint(l.x,l.y,v);A={anchor:new pg(t,e,r,0,void 0),up:d.upVector(v,l.x,l.y)};}!function(t,e,r,n,i,s,o,a,l,u,c,h,p,d,f,m,y,g,x,v,b,w,_,A,I,M,S,P,k,B,z,T,E){const V=t.addToLineVertexArray(e,n);let F,C,D,R,L,O,U,N=0,j=0,$=0,G=0,q=-1,H=-1;const X={};let Z=Je("");const W=r?r.anchor:e,Y="none"!==P;let K=0,J=0;if(void 0===l._unevaluatedLayout.getValue("text-radial-offset")){const t=l.layout.get("text-offset").evaluate(b,{},I);K=t[0]*xy,J=t[1]*xy;}else K=l.layout.get("text-radial-offset").evaluate(b,{},I)*xy,J=qg;if(t.allowVerticalPlacement&&i.vertical){const t=i.vertical;if(f)O=dx(t),a&&(U=dx(a));else {const r=l.layout.get("text-rotate").evaluate(b,{},I)+90;D=px(u,W,e,c,h,p,t,d,r,m,T),a&&(R=px(u,W,e,c,h,p,a,g,r,null,z));}}if(s){const n=t.iconSizeData,i=l.layout.get("icon-rotate").evaluate(b,{},I),o=Vg(s,i,_,Y,w.iconScaleFactor),d=a?Vg(a,i,_,Y,w.iconScaleFactor):void 0;C=px(u,W,e,c,h,p,s,g,i,null,B);const f=function(t,e,r,n,i,s,o,a){const l=t.layers[0],u=l.appearances;let c=e.length;if(r&&(c=Math.max(c,r.length)),0===u.length)return c;const[h,p]=n.get("icon-size-scale-range"),d=Ft(1,h,p);for(const e of u){const r=e.getUnevaluatedProperties();if(void 0!==r._values["icon-image"].value){const n=l.getAppearanceValueAndResolveTokens(e,"icon-image",i,s,[]);if(n){const e=t.getResolvedImageFromTokens(n);if(e){const n=r._values["icon-size"],l=tx(e,ug(t.zoom,n,t.worldview),n,s,t.zoom,i,t.pixelRatio,d,t.worldview),u=o.get(l.iconPrimary.toString());c=Math.max(c,Fg(u,a));}}}}return c}(t,o,d,l.layout,b,I,t.iconAtlasPositions,Y);N=4*f;let m=null;"source"===n.kind?(m=[lg*l.layout.get("icon-size").evaluate(b,{},I)*w.iconScaleFactor],m[0]>ux&&Xt(`${t.layerIds[0]}: Value for "icon-size" is >= ${lx}. Reduce your "icon-size".`)):"composite"===n.kind&&(m=[lg*w.compositeIconSizes[0].evaluate(b,{},I)*w.iconScaleFactor,lg*w.compositeIconSizes[1].evaluate(b,{},I)*w.iconScaleFactor],(m[0]>ux||m[1]>ux)&&Xt(`${t.layerIds[0]}: Value for "icon-size" is >= ${lx}. Reduce your "icon-size".`)),t.addSymbols(t.icon,o,m,v,x,b,void 0,r,e,V.lineStartIndex,V.lineLength,-1,A,I,M,S,t.symbolInstances.length,f),q=t.icon.placedSymbolArray.length-1,d&&(j=4*f,t.addSymbols(t.icon,d,m,v,x,b,$y.vertical,r,e,V.lineStartIndex,V.lineLength,-1,A,I,M,S,t.symbolInstances.length,f),H=t.icon.placedSymbolArray.length-1);}for(const n in i.horizontal){const s=n,a=i.horizontal[s];F||(Z=Je(a.text),f?L=dx(a):F=px(u,W,e,c,h,p,a,d,l.layout.get("text-rotate").evaluate(b,{},I),m,T));const y=1===a.positionedLines.length;if($+=cx(t,r,e,a,o,l,f,b,m,V,i.vertical?$y.horizontal:$y.horizontalOnly,y?Gg(i.horizontal):[s],X,q,w,A,I,t.symbolInstances.length,M),y)break}i.vertical&&(G+=cx(t,r,e,i.vertical,o,l,f,b,m,V,$y.vertical,["vertical"],X,H,w,A,I,t.symbolInstances.length,M));let Q=-1;const tt=(t,e)=>t?Math.max(t,e):e;Q=tt(L,Q),Q=tt(O,Q),Q=tt(U,Q);const et=Q>-1?1:0;t.glyphOffsetArray.length>=65535&&Xt("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==b.sortKey&&t.addToSortKeyRanges(t.symbolInstances.length,b.sortKey),t.symbolInstances.emplaceBack(e.x,e.y,W.x,W.y,W.z,X.right>=0?X.right:-1,X.center>=0?X.center:-1,X.left>=0?X.left:-1,X.vertical>=0?X.vertical:-1,q,H,Z,void 0!==F?F:t.collisionBoxArray.length,void 0!==F?F+1:t.collisionBoxArray.length,void 0!==D?D:t.collisionBoxArray.length,void 0!==D?D+1:t.collisionBoxArray.length,void 0!==C?C:t.collisionBoxArray.length,void 0!==C?C+1:t.collisionBoxArray.length,R||t.collisionBoxArray.length,R?R+1:t.collisionBoxArray.length,c,$,G,N,j,et,0,K,J,Q,0,Y?1:0,k);}(t,l,A,a,r,n,s,i,t.layers[0],t.collisionBoxArray,e.index,e.sourceLayerIndex,t.index,E,x,u,0,V,C,g,e,o,c,h,p,f,m,y,O,b,w,_);};if("line"===v)for(const i of Fd(e.geometry,0,0,Un,Un)){const e=xg(i,T,F,r.vertical||k,n,S,z,t.overscaling,Un);for(const r of e)k&&fx(t,k.text,D,r)||U(i,r,p);}else if("line-center"===v){for(const t of e.geometry)if(t.length>1){const e=gg(t,F,r.vertical||k,n,S,z);e&&U(t,e,p);}}else if("Polygon"===e.type)for(const t of rp(e.geometry,0)){const e=Ng(t,16);U(t[0],new pg(e.x,e.y,0,0,void 0),p);}else if("LineString"===e.type)for(const t of e.geometry)U(t,new pg(t[0].x,t[0].y,0,0,void 0),p);else if("Point"===e.type)for(const t of e.geometry)for(const e of t)U([e],new pg(e.x,e.y,0,0,void 0),p);}const lx=255,ux=lx*lg;function cx(t,e,r,n,i,s,o,a,l,u,c,h,p,d,f,m,y,g,x){const v=function(t,e,r,n,i,s,o,a){const l=[];if(0===e.positionedLines.length)return l;const u=n.layout.get("text-rotate").evaluate(s,{})*Math.PI/180,c=function(t){const e=t[0],r=t[1],n=e*r;return n>0?[e,-r]:n<0?[-e,r]:0===e?[r,e]:[r,-e]}(r);let h=Math.abs(e.top-e.bottom);for(const t of e.positionedLines)h-=t.lineOffset;const p=e.positionedLines.length,d=h/p;let f=e.top-r[1];for(let t=0;t<p;++t){const n=e.positionedLines[t];f=Ug(e,d,f,t);for(const t of n.positionedGlyphs){if(!t.rect)continue;const n=t.rect||{};let s=jy+1,h=!0,p=1,d=0;if(t.image){const e=o.get(t.image.toString());if(!e)continue;if(e.sdf){Xt("SDF images are not supported in formatted text and will be ignored.");continue}h=!1,p=e.pixelRatio,s=wg/p;}const m=(i||a)&&t.vertical,y=t.metrics.advance*t.scale/2,g=t.metrics,x=t.rect;if(null===x)continue;a&&e.verticalizable&&(d=t.image?y-t.metrics.width*t.scale/2:0);const v=i?[t.x+y,t.y]:[0,0];let b=[0,0],w=[0,0],_=!1;i||(m?(w=[t.x+y+c[0],t.y+c[1]-d],_=!0):b=[t.x+y+r[0],t.y+r[1]-d]);const A=x.w*t.scale/(p*(t.localGlyph?kg:1)),I=x.h*t.scale/(p*(t.localGlyph?kg:1));let M,S,P,k;if(m){const e=t.y-f,r=new It(-y,y-e),n=-Math.PI/2,i=new It(...w);M=new It(-y+b[0],b[1]),M._rotateAround(n,r)._add(i),M.x+=-e+y,M.y-=(g.left-s)*t.scale;const o=t.image?g.advance*t.scale:xy*t.scale,a=String.fromCodePoint(t.glyph);wy(a)?M.x+=(1-s)*t.scale:_y(a)?M.x+=o-g.height*t.scale+(-s-1)*t.scale:M.x+=t.image||g.width+2*s===x.w&&g.height+2*s===x.h?(o-I)/2:(o-(g.height+2*s)*t.scale)/2,S=new It(M.x,M.y-A),P=new It(M.x+I,M.y),k=new It(M.x+I,M.y-A);}else {const e=(g.left-s)*t.scale-y+b[0],r=(-g.top-s)*t.scale+b[1],n=e+A,i=r+I;M=new It(e,r),S=new It(n,r),P=new It(e,i),k=new It(n,i);}if(u){let t;t=i?new It(0,0):_?new It(c[0],c[1]):new It(r[0],r[1]),M._rotateAround(u,t),S._rotateAround(u,t),P._rotateAround(u,t),k._rotateAround(u,t);}const B=new It(0,0),z=new It(0,0);l.push({tl:M,tr:S,bl:P,br:k,texPrimary:n,texSecondary:void 0,writingMode:e.writingMode,glyphOffset:v,sectionIndex:t.sectionIndex,isSDF:h,pixelOffsetTL:B,pixelOffsetBR:z,minFontScaleX:0,minFontScaleY:0});}}return l}(0,n,l,s,o,a,i,t.allowVerticalPlacement),b=t.textSizeData;let w=null;"source"===b.kind?(w=[lg*s.layout.get("text-size").evaluate(a,{},y)*f.textScaleFactor],w[0]>ux&&Xt(`${t.layerIds[0]}: Value for "text-size" is >= ${lx}. Reduce your "text-size".`)):"composite"===b.kind&&(w=[lg*f.compositeTextSizes[0].evaluate(a,{},y)*f.textScaleFactor,lg*f.compositeTextSizes[1].evaluate(a,{},y)*f.textScaleFactor],(w[0]>ux||w[1]>ux)&&Xt(`${t.layerIds[0]}: Value for "text-size" is >= ${lx}. Reduce your "text-size".`)),t.addSymbols(t.text,v,w,l,o,a,c,e,r,u.lineStartIndex,u.lineLength,d,m,y,x,!1,g,v.length);for(const e of h)p[e]=t.text.placedSymbolArray.length-1;return 4*v.length}function hx(t){for(const e in t)return t[e];return null}function px(t,e,r,n,i,s,o,a,l,u,c){let h,p,d,f;if(h=c?c.top:o.top,p=c?c.bottom:o.bottom,d=c?c.left:o.left,f=c?c.right:o.right,rg(o)&&o.collisionPadding){const t=o.collisionPadding;d-=t[0],h-=t[1],f+=t[2],p+=t[3];}if(l){const t=new It(d,h),e=new It(f,h),r=new It(d,p),n=new It(f,p),i=kt(l);let s=new It(0,0);u&&(s=new It(u[0],u[1])),t._rotateAround(i,s),e._rotateAround(i,s),r._rotateAround(i,s),n._rotateAround(i,s),d=Math.min(t.x,e.x,r.x,n.x),f=Math.max(t.x,e.x,r.x,n.x),h=Math.min(t.y,e.y,r.y,n.y),p=Math.max(t.y,e.y,r.y,n.y);}return t.emplaceBack(e.x,e.y,e.z,r.x,r.y,d,h,f,p,a,n,i,s),t.length-1}function dx(t){rg(t)&&t.collisionPadding&&(t.top-=t.collisionPadding[1],t.bottom+=t.collisionPadding[3]);const e=t.bottom-t.top;return e>0?Math.max(10,e):null}function fx(t,e,r,n){const i=t.compareText;if(e in i){const t=i[e];for(let e=t.length-1;e>=0;e--)if(n.dist(t[e])<r)return !0}else i[e]=[];return i[e].push(n),!1}function mx(t,e){const r=t.fovAboveCenter,n=t.elevation?t.elevation.getMinElevationBelowMSL()*e:0,i=(t._camera.position[2]*t.worldSize-n)/Math.cos(t._pitch),s=Math.sin(r)*i/Math.sin(Math.max(Math.PI/2-t._pitch-r,.01));let o=Math.sin(t._pitch)*s+i;const a=i*(1/t._horizonShift);if(!t.elevation||0===t.elevation.exaggeration()){let e=Math.max(t.zoom-17,0);t.isOrthographic&&(e/=10),o*=1+e;}return Math.min(1.01*o,a)}function yx(t,e){if(!e.isReprojectedInTileSpace)return {scale:1<<t.z,x:t.x,y:t.y,x2:t.x+1,y2:t.y+1,projection:e};const r=Math.pow(2,-t.z),n=t.x*r,i=(t.x+1)*r,s=t.y*r,o=(t.y+1)*r,a=pu(n),l=pu(i),u=du(s),c=du(o),h=e.project(a,u),p=e.project(l,u),d=e.project(l,c),f=e.project(a,c);let m=Math.min(h.x,p.x,d.x,f.x),y=Math.min(h.y,p.y,d.y,f.y),g=Math.max(h.x,p.x,d.x,f.x),x=Math.max(h.y,p.y,d.y,f.y);const v=r/16;function b(t,r,n,i,s,o){const a=(n+s)/2,l=(i+o)/2,u=e.project(pu(a),du(l)),c=Math.max(0,m-u.x,y-u.y,u.x-g,u.y-x);m=Math.min(m,u.x),g=Math.max(g,u.x),y=Math.min(y,u.y),x=Math.max(x,u.y),c>v&&(b(t,u,n,i,a,l),b(u,r,a,l,s,o));}b(h,p,n,s,i,s),b(p,d,i,s,i,o),b(d,f,i,o,n,o),b(f,h,n,o,n,s),m-=v,y-=v,g+=v,x+=v;const w=1/Math.max(g-m,x-y);return {scale:w,x:m*w,y:y*w,x2:g*w,y2:x*w,projection:e}}function gx(t,{x:e,y:r},n=0){return new It(((e-n)*t.scale-t.x)*Un,(r*t.scale-t.y)*Un)}const xx=u(new Float32Array(16));class vx{constructor(t){this.spec=t,this.name=t.name,this.wrap=!1,this.requiresDraping=!1,this.supportsWorldCopies=!1,this.supportsTerrain=!1,this.supportsFog=!1,this.supportsFreeCamera=!1,this.zAxisUnit="meters",this.isReprojectedInTileSpace=!0,this.unsupportedLayers=["custom"],this.center=[0,0],this.range=[3.5,7];}project(t,e){return {x:0,y:0,z:0}}unproject(t,e){return new iu(0,0)}projectTilePoint(t,e,r){return {x:t,y:e,z:0}}locationPoint(t,e,r,n=!0){return t._coordinatePoint(t.locationCoordinate(e,r),n)}pixelsPerMeter(t,e){return hu(1,t)*e}pixelSpaceConversion(t,e,r){return 1}farthestPixelDistance(t){return mx(t,t.pixelsPerMeter)}pointCoordinate(t,e,r,n){const i=t.horizonLineFromTop(!1),s=new It(e,Math.max(i,r));return t.rayIntersectionCoordinate(t.pointRayIntersection(s,n))}pointCoordinate3D(t,e,r){const n=new It(e,r);if(t.elevation)return t.elevation.pointCoordinate(n);{const e=this.pointCoordinate(t,n.x,n.y,0);return [e.x,e.y,e.z]}}isPointAboveHorizon(t,e){if(t.elevation&&t.elevation.visibleDemTiles.length)return !this.pointCoordinate3D(t,e.x,e.y);const r=t.horizonLineFromTop();return e.y<r}createInversionMatrix(t,e){return xx}createTileMatrix(t,e,r){let n,i,s;const o=r.canonical,a=u(new Float64Array(16));if(this.isReprojectedInTileSpace){const l=yx(o,this);n=1,i=l.x+r.wrap*l.scale,s=l.y,d(a,a,[n/l.scale,n/l.scale,t.pixelsPerMeter/e]);}else n=e/t.zoomScale(o.z),i=(o.x+Math.pow(2,o.z)*r.wrap)*n,s=o.y*n;return p(a,a,[i,s,0]),d(a,a,[n/Un,n/Un,1]),a}upVector(t,e,r){return [0,0,1]}upVectorScale(t,e,r){return {metersToTile:1}}}class bx extends vx{constructor(t){super(t),this.range=[4,7],this.center=t.center||[-96,37.5];const[e,r]=this.parallels=t.parallels||[29.5,45.5],n=Math.sin(kt(e));this.n=(n+Math.sin(kt(r)))/2,this.c=1+n*(2*this.n-n),this.r0=Math.sqrt(this.c)/this.n;}project(t,e){const{n:r,c:n,r0:i}=this,s=kt(t-this.center[0]),o=kt(e),a=Math.sqrt(n-2*r*Math.sin(o))/r;return {x:a*Math.sin(s*r),y:a*Math.cos(s*r)-i,z:0}}unproject(t,e){const{n:r,c:n,r0:i}=this,s=i+e;let o=Math.atan2(t,Math.abs(s))*Math.sign(s);s*r<0&&(o-=Math.PI*Math.sign(t)*Math.sign(s));const a=kt(this.center[0])*r;o=Dt(o,-Math.PI-a,Math.PI-a);const l=Ft(Bt(o/r)+this.center[0],-180,180),u=Math.asin(Ft((n-(t*t+s*s)*r*r)/(2*r),-1,1)),c=Ft(Bt(u),-mu,mu);return new iu(l,c)}}const wx=1.340264,_x=-.081106,Ax=893e-6,Ix=.003796,Mx=Math.sqrt(3)/2;class Sx extends vx{project(t,e){e=e/180*Math.PI,t=t/180*Math.PI;const r=Math.asin(Mx*Math.sin(e)),n=r*r,i=n*n*n;return {x:.5*(t*Math.cos(r)/(Mx*(wx+3*_x*n+i*(7*Ax+9*Ix*n)))/Math.PI+.5),y:1-.5*(r*(wx+_x*n+i*(Ax+Ix*n))/Math.PI+1),z:0}}unproject(t,e){t=(2*t-.5)*Math.PI;let r=e=(2*(1-e)-1)*Math.PI,n=r*r,i=n*n*n;for(let t,s,o,a=0;a<12&&(s=r*(wx+_x*n+i*(Ax+Ix*n))-e,o=wx+3*_x*n+i*(7*Ax+9*Ix*n),t=s/o,r=Ft(r-t,-Math.PI/3,Math.PI/3),n=r*r,i=n*n*n,!(Math.abs(t)<1e-12));++a);const s=Mx*t*(wx+3*_x*n+i*(7*Ax+9*Ix*n))/Math.cos(r),o=Math.asin(Math.sin(r)/Mx),a=Ft(180*s/Math.PI,-180,180),l=Ft(180*o/Math.PI,-mu,mu);return new iu(a,l)}}class Px extends vx{constructor(t){super(t),this.wrap=!0,this.supportsWorldCopies=!0;}project(t,e){return {x:.5+t/360,y:.5-e/360,z:0}}unproject(t,e){const r=360*(t-.5),n=Ft(360*(.5-e),-mu,mu);return new iu(r,n)}}const kx=Math.PI/2;function Bx(t){return Math.tan((kx+t)/2)}class zx extends vx{constructor(t){super(t),this.center=t.center||[0,30];const[e,r]=this.parallels=t.parallels||[30,30];let n=kt(e),i=kt(r);this.southernCenter=n+i<0,this.southernCenter&&(n=-n,i=-i);const s=Math.cos(n),o=Bx(n);this.n=n===i?Math.sin(n):Math.log(s/Math.cos(i))/Math.log(Bx(i)/o),this.f=s*Math.pow(Bx(n),this.n)/this.n;}project(t,e){e=kt(e),this.southernCenter&&(e=-e),t=kt(t-this.center[0]);const r=1e-6,{n,f:i}=this;i>0?e<-kx+r&&(e=-kx+r):e>kx-r&&(e=kx-r);const s=i/Math.pow(Bx(e),n);let o=s*Math.sin(n*t),a=i-s*Math.cos(n*t);return o=.5*(o/Math.PI+.5),a=.5*(a/Math.PI+.5),{x:o,y:this.southernCenter?a:1-a,z:0}}unproject(t,e){t=(2*t-.5)*Math.PI,this.southernCenter&&(e=1-e),e=(2*(1-e)-.5)*Math.PI;const{n:r,f:n}=this,i=n-e,s=Math.sign(i),o=Math.sign(r)*Math.sqrt(t*t+i*i);let a=Math.atan2(t,Math.abs(i))*s;i*r<0&&(a-=Math.PI*Math.sign(t)*s);const l=Ft(Bt(a/r)+this.center[0],-180,180),u=Ft(Bt(2*Math.atan(Math.pow(n/o,1/r))-kx),-mu,mu);return new iu(l,this.southernCenter?-u:u)}}class Tx extends vx{constructor(t){super(t),this.wrap=!0,this.supportsWorldCopies=!0,this.supportsTerrain=!0,this.supportsFog=!0,this.supportsFreeCamera=!0,this.isReprojectedInTileSpace=!1,this.unsupportedLayers=[],this.range=null;}project(t,e){return {x:uu(t),y:cu(e),z:0}}unproject(t,e){const r=pu(t),n=du(e);return new iu(r,n)}}const Ex=kt(mu);class Vx extends vx{project(t,e){const r=(e=kt(e))*e,n=r*r;return {x:.5*((t=kt(t))*(.8707-.131979*r+n*(n*(.003971*r-.001529*n)-.013791))/Math.PI+.5),y:1-.5*(e*(1.007226+r*(.015085+n*(.028874*r-.044475-.005916*n)))/Math.PI+1),z:0}}unproject(t,e){t=(2*t-.5)*Math.PI;let r=e=(2*(1-e)-1)*Math.PI,n=25,i=0,s=r*r;do{s=r*r;const t=s*s;i=(r*(1.007226+s*(.015085+t*(.028874*s-.044475-.005916*t)))-e)/(1.007226+s*(.045255+t*(.259866*s-.311325-.005916*11*t))),r=Ft(r-i,-Ex,Ex);}while(Math.abs(i)>1e-6&&--n>0);s=r*r;const o=Ft(Bt(t/(.8707+s*(s*(s*s*s*(.003971-.001529*s)-.013791)-.131979))),-180,180),a=Bt(r);return new iu(o,a)}}const Fx=kt(mu);class Cx extends vx{project(t,e){e=kt(e),t=kt(t);const r=Math.cos(e),n=2/Math.PI,i=Math.acos(r*Math.cos(t/2)),s=Math.sin(i)/i,o=.5*(t*n+2*r*Math.sin(t/2)/s)||0,a=.5*(e+Math.sin(e)/s)||0;return {x:.5*(o/Math.PI+.5),y:1-.5*(a/Math.PI+1),z:0}}unproject(t,e){let r=t=(2*t-.5)*Math.PI,n=e=(2*(1-e)-1)*Math.PI,i=25;const s=1e-6;let o=0,a=0;do{const i=Math.cos(n),s=Math.sin(n),l=2*s*i,u=s*s,c=i*i,h=Math.cos(r/2),p=Math.sin(r/2),d=2*h*p,f=p*p,m=1-c*h*h,y=m?1/m:0,g=m?Math.acos(i*h)*Math.sqrt(1/m):0,x=.5*(2*g*i*p+2*r/Math.PI)-t,v=.5*(g*s+n)-e,b=.5*y*(c*f+g*i*h*u)+1/Math.PI,w=y*(d*l/4-g*s*p),_=.125*y*(l*p-g*s*c*d),A=.5*y*(u*h+g*f*i)+.5,I=w*_-A*b;o=(v*w-x*A)/I,a=(x*_-v*b)/I,r=Ft(r-o,-Math.PI,Math.PI),n=Ft(n-a,-Fx,Fx);}while((Math.abs(o)>s||Math.abs(a)>s)&&--i>0);return new iu(Bt(r),Bt(n))}}class Dx extends vx{constructor(t){super(t),this.center=t.center||[0,0],this.parallels=t.parallels||[0,0],this.cosPhi=Math.max(.01,Math.cos(kt(this.parallels[0]))),this.scale=1/(2*Math.max(Math.PI*this.cosPhi,1/this.cosPhi)),this.wrap=!0,this.supportsWorldCopies=!0;}project(t,e){const{scale:r,cosPhi:n}=this;return {x:kt(t)*n*r+.5,y:-Math.sin(kt(e))/n*r+.5,z:0}}unproject(t,e){const{scale:r,cosPhi:n}=this,i=-(e-.5)/r,s=Ft(Bt((t-.5)/r)/n,-180,180),o=Math.asin(Ft(i*n,-1,1)),a=Ft(Bt(o),-mu,mu);return new iu(s,a)}}class Rx extends Tx{constructor(t){super(t),this.requiresDraping=!0,this.supportsWorldCopies=!1,this.supportsFog=!0,this.zAxisUnit="pixels",this.unsupportedLayers=["debug"],this.range=[3,5];}projectTilePoint(t,e,r){const n=Xc(t,e,r);return j(n,n,Yc(Nc(r))),{x:n[0],y:n[1],z:n[2]}}locationPoint(t,e,r){const n=eu(e.lat,e.lng),i=L([],n),s=r?t._centerAltitude+r:t.elevation?t.elevation.getAtPointOrZero(t.locationCoordinate(e),t._centerAltitude):t._centerAltitude;V(n,n,i,hu(1,0)*Un*s);const o=u(new Float64Array(16));return h(o,t.pixelMatrix,t.globeMatrix),j(n,n,o),new It(n[0],n[1])}pixelsPerMeter(t,e){return hu(1,0)*e}pixelSpaceConversion(t,e,r){const n=hu(1,t)*e,i=pr(hu(1,45)*e,n,r);return this.pixelsPerMeter(t,e)/i}createTileMatrix(t,e,r){const n=Kc(Nc(r.canonical));return h(new Float64Array(16),t.globeMatrix,n)}createInversionMatrix(t,e){const{center:r}=t,n=Yc(Nc(e));return m(n,n,kt(r.lng)),f(n,n,kt(r.lat)),d(n,n,[t._pixelsPerMercatorPixel,t._pixelsPerMercatorPixel,1]),Float32Array.from(n)}pointCoordinate(t,e,r,n){return Lc(t,e,r,!0)||new bu(0,0)}pointCoordinate3D(t,e,r){const n=this.pointCoordinate(t,e,r,0);return [n.x,n.y,n.z]}isPointAboveHorizon(t,e){return !Lc(t,e.x,e.y,!1)}farthestPixelDistance(t){const e=function(t,e){const r=t.cameraToCenterDistance,n=t._centerAltitude*e,i=t._camera,s=t._camera.forward(),o=P([],E([],s,-r),[0,0,n]),a=t.worldSize/(2*Math.PI),l=[0,0,-a],u=t.width/t.height,c=Math.tan(t.fovAboveCenter),h=E([],i.up(),c),p=E([],i.right(),c*u),d=L([],P([],P([],s,h),p)),f=[];let m;if(new qu(o,d).closestPointOnSphere(l,a,f)){const e=P([],f,l),r=X([],e,o);m=Math.cos(t.fovAboveCenter)*I(r);}else {const t=X([],o,l),e=X([],l,o);L(e,e);const r=I(t)-a;m=Math.sqrt(r*(r+2*a));const n=Math.acos(m/(a+r))-Math.acos(O(s,e));m*=Math.cos(n);}return 1.01*m}(t,this.pixelsPerMeter(t.center.lat,t.worldSize)),r=eh(t.zoom);if(r>0){const n=mx(t,hu(1,t.center.lat)*t.worldSize),i=t.worldSize/(2*Math.PI),s=Math.max(t.width,t.height)/t.worldSize*Math.PI;return pr(e,n+i*(1-Math.cos(s)),Math.pow(r,10))}return e}upVector(t,e,r){return Xc(e,r,t,1)}upVectorScale(t){return {metersToTile:Dc(Zc(Nc(t)))}}}function Lx(t){const e=t.parallels,r=!!e&&Math.abs(e[0]+e[1])<.01;switch(t.name){case "mercator":return new Tx(t);case "equirectangular":return new Px(t);case "naturalEarth":return new Vx(t);case "equalEarth":return new Sx(t);case "winkelTripel":return new Cx(t);case "albers":return r?new Dx(t):new bx(t);case "lambertConformalConic":return r?new Dx(t):new zx(t);case "globe":return new Rx(t)}throw new Error(`Invalid projection name: ${t.name}`)}const Ox=zu.types,Ux=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function Nx(t,e,r,n,i,s,o,a,l,u,c,h,p){const d=a?Math.min(ux,Math.round(a[0])):0,f=a?Math.min(ux,Math.round(a[1])):0;t.emplaceBack(e,r,Math.round(32*n),Math.round(32*i),s,o,(d<<1)+(l?1:0),0+(f<<1),16*u,16*c,256*h,256*p);}function jx(t,e,r){t.emplaceBack(e,r);}function $x(t,e,r,n,i,s,o){t.emplaceBack(e,r,n,i,s,o);}const Gx=(t,e,r,n)=>{for(let i=0;i<e;i++)t.emplaceBack(r[0],r[1],r[2],n[0],n[1],n[2]);};function qx(t,e,r,n,i){t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i);}function Hx(t){for(const e of t.sections)if(po(e.text))return !0;return !1}class Xx{constructor(t){this.layoutVertexArray=new Ma,this.indexArray=new Fa,this.programConfigurations=t,this.segments=new hl,this.dynamicLayoutVertexArray=new Pa,this.opacityVertexArray=new ka,this.placedSymbolArray=new Ja,this.iconTransitioningVertexArray=new Ba,this.globeExtVertexArray=new Sa,this.zOffsetVertexArray=new ya,this.orientationVertexArray=new Ra,this.symbolInstanceIndices=[];}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length&&0===this.iconTransitioningVertexArray.length}getIconVertexData(t,e){const r=[],n=this.layoutVertexArray.uint16;for(let i=0;i<e;++i){const e=12*(t+i);r.push(...n.slice(e,e+12));}return r}updateIconVertexData(t,e,r,n,i,s,o,a,l,u,c,h,p){const d=this.layoutVertexArray.uint16,f=12*t;d[f]=e,d[f+1]=r,d[f+2]=n,d[f+3]=i,d[f+4]=s,d[f+5]=o,d[f+6]=a,d[f+7]=l,d[f+8]=u,d[f+9]=c,d[f+10]=h,d[f+11]=p;}upload(t,e,r,n,i,s){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,ly.members,!!s),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,cy.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,Ux,!0),this.iconTransitioningVertexArray.length>0&&(this.iconTransitioningVertexBuffer=t.createVertexBuffer(this.iconTransitioningVertexArray,dy.members,!0)),this.globeExtVertexArray.length>0&&(this.globeExtVertexBuffer=t.createVertexBuffer(this.globeExtVertexArray,uy.members,!0)),!this.zOffsetVertexBuffer&&(this.zOffsetVertexArray.length>0||i)&&(this.zOffsetVertexBuffer=t.createVertexBuffer(this.zOffsetVertexArray,hy.members,!0)),!this.orientationVertexBuffer&&this.orientationVertexArray&&this.orientationVertexArray.length>0&&(this.orientationVertexBuffer=t.createVertexBuffer(this.orientationVertexArray,py.members,!0)),this.opacityVertexBuffer.itemSize=1),(r||n)&&this.programConfigurations.upload(t));}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy(),this.iconTransitioningVertexBuffer&&this.iconTransitioningVertexBuffer.destroy(),this.globeExtVertexBuffer&&this.globeExtVertexBuffer.destroy(),this.zOffsetVertexBuffer&&this.zOffsetVertexBuffer.destroy(),this.orientationVertexBuffer&&this.orientationVertexBuffer.destroy());}}Qs(Xx,"SymbolBuffers");class Zx{constructor(t,e,r){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new r,this.segments=new hl,this.collisionVertexArray=new Va,this.collisionVertexArrayExt=new Pa;}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,fy.members,!0),this.collisionVertexBufferExt=t.createVertexBuffer(this.collisionVertexArrayExt,my.members,!0);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy(),this.collisionVertexBufferExt.destroy());}}Qs(Zx,"CollisionBuffers");class Wx{constructor(t){this.collisionBoxArray=t.collisionBoxArray,this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.pixelRatio=t.pixelRatio,this.sourceLayerIndex=t.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.fullyClipped=!1,this.hasAnyIconTextFit=!1,this.sortKeyRanges=[],this.collisionCircleArray=[],this.placementInvProjMatrix=u([]),this.placementViewportMatrix=u([]);const e=this.layers[0]._unevaluatedLayout._values;this.worldview=t.worldview,this.localizable=t.localizable,this.textSizeData=ug(this.zoom,e["text-size"],this.worldview),this.iconSizeData=ug(this.zoom,e["icon-size"],this.worldview);const r=this.layers[0].layout,n=r.get("symbol-sort-key"),i=r.get("symbol-z-order");this.lut=t.lut,this.canOverlap=r.get("text-allow-overlap")||r.get("icon-allow-overlap")||r.get("text-ignore-placement")||r.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==i&&void 0!==n.constantOr(1),this.sortFeaturesByY=("viewport-y"===i||"auto"===i&&!this.sortFeaturesByKey)&&this.canOverlap,this.writingModes=r.get("text-writing-mode").map((t=>$y[t])),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=t.sourceID,this.projection=t.projection,this.hasAnyZOffset=!1,this.zOffsetSortDirty=!1,this.zOffsetBuffersNeedUpload=!1,this.elevationType="none",this.elevationStateComplete=!1,this.activeReplacements=[],this.replacementUpdateTime=0,this.hasAnySecondaryIcon=!1,this.hasAppearances=null,this.lastActiveApperance=null,this.featureToAppearanceIndex={};}hasAnyAppearanceProperty(t){const e=this.layers[0].getAppearances();return !(!e||0===e.length)&&e.some((e=>null!=e.getProperty(t)))}createArrays(){this.text=new Xx(new Ul(this.layers,{zoom:this.zoom,lut:this.lut},(t=>t.startsWith("text")||t.startsWith("symbol")))),this.icon=new Xx(new Ul(this.layers,{zoom:this.zoom,lut:this.lut},(t=>t.startsWith("icon")||t.startsWith("symbol")))),this.glyphOffsetArray=new el,this.lineVertexArray=new rl,this.symbolInstances=new tl;}calculateGlyphDependencies(t,e,r,n,i){for(const r of t){const t=r.codePointAt(0);if(void 0===t)break;if(e[t]=!0,n&&i&&t<=65535){const t=by[r];t&&(e[t.charCodeAt(0)]=!0);}}}calculateEffectiveAppearanceIconSize(t,e,r,n,i,s){let o=1;const a=t.getUnevaluatedProperties()._values["icon-size"],l=ug(this.zoom,a,this.worldview),u=hg(l,e);if("constant"!==l.kind&&"camera"!==l.kind||(o=u.uSize),"composite"===l.kind){const{minZoom:t,maxZoom:e}=l,s=a.possiblyEvaluate(new Io(t,{worldview:this.worldview}),n),c=a.possiblyEvaluate(new Io(e,{worldview:this.worldview}),n),h=s.evaluate(r,{},n,i);o=h+(c.evaluate(r,{},n,i)-h)*u.uSizeT;}return "source"===l.kind&&(o=a.possiblyEvaluate(new Io(this.zoom,{worldview:this.worldview}),n).evaluate(r,{},n,i)),o*s}updateFootprints(t,e){}updateReplacement(t,e){if(e.updateTime===this.replacementUpdateTime)return !1;this.replacementUpdateTime=e.updateTime;const r=e.getReplacementRegionsForTile(t.toUnwrapped(),!0);return !jp(this.activeReplacements,r)&&(this.activeReplacements=r,!0)}getResolvedImageFromTokens(t){return "string"==typeof t?Lr.build(t):t}populate(t,e,r,n){const i=this.layers[0],s=i.layout,o="globe"===this.projection.name,a=s.get("text-font"),l=s.get("text-field"),u=s.get("icon-image"),[c,h]=s.get("icon-size-scale-range"),p=Ft(e.scaleFactor||1,c,h),d=("constant"!==l.value.kind||l.value.value instanceof Dr&&!l.value.value.isEmpty()||l.value.value.toString().length>0)&&("constant"!==a.value.kind||a.value.value.length>0),f="constant"!==u.value.kind||!!u.value.value||Object.keys(u.parameters).length>0,m=this.hasAnyAppearanceProperty("icon-image"),y=s.get("symbol-sort-key");if(this.features=[],this.appearanceFeatureData=[],!d&&!f&&!m)return;const g=e.iconDependencies,x=e.glyphDependencies,v=e.availableImages,b=new Io(this.zoom,{worldview:this.worldview,activeFloors:e.activeFloors}),w=t=>{const e=t.id.toString();g.has(e)?g.get(e).push(t):g.set(e,[t]);};for(const e of t){const{feature:t,id:l,index:u,sourceLayerIndex:c}=e,h=i._featureFilter.needGeometry,_=Bu(t,h);if(!i._featureFilter.filter(b,_,r))continue;if(h||(_.geometry=ku(t,r,n)),o&&1!==t.type&&r.z<=5){const t=_.geometry,e=.98078528056,n=(t,n)=>O(Xc(t.x,t.y,r,1),Xc(n.x,n.y,r,1))<e;for(let e=0;e<t.length;e++)t[e]=Iu(t[e],n);}let A,I;if(d){const t=i.getValueAndResolveTokens("text-field",_,r,v),e=Dr.factory(t);Hx(e)&&(this.hasRTLText=!0),(!this.hasRTLText||"unavailable"===wo()||this.hasRTLText&&Ao.isParsed())&&(A=vy(e,i,_));}if(f){const t=i.getValueAndResolveTokens("icon-image",_,r,v);I=this.getResolvedImageFromTokens(t);}const M=this.layers[0];let S=!1;if(!I&&m){const t=M.getAppearances();for(const e of t)if(e.getProperty("icon-image")){const t=M.getAppearanceValueAndResolveTokens(e,"icon-image",_,r,v);if(t){I=this.getResolvedImageFromTokens(t),S=!0;break}}}if(!A&&!I)continue;const P=this.sortFeaturesByKey?y.evaluate(_,{},r):void 0,k={id:l,text:A,icon:I,index:u,sourceLayerIndex:c,geometry:_.geometry,properties:t.properties,type:Ox[t.type],sortKey:P};if(this.features.push(k),this.featureToAppearanceIndex[u]=this.appearanceFeatureData.length,this.appearanceFeatureData.push({id:l,properties:t.properties,usesAppearanceIconAsPlaceholder:S,isUsingAppearanceVertexData:!1,layoutBasedVertexData:[],activeAppearance:null}),I){const t=M._unevaluatedLayout._values,{iconPrimary:e,iconSecondary:n}=tx(I,this.iconSizeData,t["icon-size"],r,this.zoom,k,this.pixelRatio,p,this.worldview);w(e),n&&(this.hasAnySecondaryIcon=!0,w(n));}const B=M.getAppearances();if(0!==B.length&&B.forEach((t=>{if(!t.getProperty("icon-image"))return;const e=this.getCombinedIconPrimary(t,M,_,r,v,k,p);e&&w(e);})),A){const t=a.evaluate(_,{},r).join(","),e="map"===s.get("text-rotation-alignment")&&"point"!==s.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf($y.vertical)>=0;for(const r of A.sections)if(r.image){const t=r.image.getPrimary().scaleSelf(this.pixelRatio),e=t.id.toString(),n=g.get(e)||[];n.push(t),g.set(e,n);}else {const n=io(A.toString()),i=r.fontStack||t,s=x[i]=x[i]||{};this.calculateGlyphDependencies(r.text,s,e,this.allowVerticalPlacement,n);}}}if("line"===s.get("symbol-placement")&&(this.features=function(t){const e={},r={},n=[];let i=0;function s(e){n.push(t[e]),i++;}function o(t,e,i){const s=r[t];return delete r[t],r[e]=s,n[s].geometry[0].pop(),n[s].geometry[0]=n[s].geometry[0].concat(i[0]),s}function a(t,r,i){const s=e[r];return delete e[r],e[t]=s,n[s].geometry[0].shift(),n[s].geometry[0]=i[0].concat(n[s].geometry[0]),s}function l(t,e,r){const n=r?e[0][e[0].length-1]:e[0][0];return `${t}:${n.x}:${n.y}`}for(let u=0;u<t.length;u++){const c=t[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){s(u);continue}const d=l(p,h),f=l(p,h,!0);if(d in r&&f in e&&r[d]!==e[f]){const t=a(d,f,h),i=o(d,f,n[t].geometry);delete e[d],delete r[f],r[l(p,n[i].geometry,!0)]=i,n[t].geometry=null;}else d in r?o(d,f,h):f in e?a(d,f,h):(s(u),e[d]=i-1,r[f]=i-1);}return n.filter((t=>t.geometry))}(this.features)),"hd-road-markup"===s.get("symbol-elevation-reference")){if(this.elevationType="road",e.elevationFeatures){!this.elevationFeatures&&e.elevationFeatures.length>0&&(this.elevationFeatures=[],this.elevationFeatureIdToIndex=new Map);for(const t of e.elevationFeatures)this.elevationFeatureIdToIndex.set(t.id,this.elevationFeatures.length),this.elevationFeatures.push(t);}}else s.get("symbol-z-elevate")&&(this.elevationType="offset");"none"!==this.elevationType&&(this.zOffsetBuffersNeedUpload=!0),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey));}getCombinedIconPrimary(t,e,r,n,i,s,o){let a,l;const u=t.getUnevaluatedProperties();if(void 0!==u._values["icon-image"].value){const s=e.getAppearanceValueAndResolveTokens(t,"icon-image",r,n,i);a=this.getResolvedImageFromTokens(s);}else {const t=e.getValueAndResolveTokens("icon-image",r,n,i);a=this.getResolvedImageFromTokens(t);}if(a){const t=u._values["icon-size"]||e._unevaluatedLayout._values["icon-size"];l=tx(a,ug(this.zoom,t,this.worldview),t,n,this.zoom,s,this.pixelRatio,o,this.worldview).iconPrimary;}return l}updateAppearanceBasedIconTextures(t,e,r,n){if(!this.appearanceFeatureData)return !1;if(!this.icon.layoutVertexArray||0===this.icon.layoutVertexArray.length)return !1;const i=this.layers[0];let s=!1,o=0;const a=i.layout,[l,u]=a.get("icon-size-scale-range"),c=Ft(1,l,u);for(let a=0;a<this.symbolInstances.length;a++){const l=this.symbolInstances.get(a),u=this.featureToAppearanceIndex[l.featureIndex],h=void 0!==u?this.appearanceFeatureData[u]:void 0;if(h&&l.placedIconSymbolIndex>=0){const a=h.id,u=e&&void 0!==a?e[String(a)]:void 0,p={type:"Point",id:h.id,properties:h.properties,geometry:[]},d=this.layers[0].appearances&&this.layers[0].appearances.find((e=>e.isActive({globals:n,feature:p,canonical:t,featureState:u})));if(h.activeAppearance===d){o+=l.numIconVertices;continue}if(d){h.activeAppearance=d;const e=this.getCombinedIconPrimary(d,i,p,t,r,{sortKey:void 0,text:void 0,icon:null,index:l.featureIndex,sourceLayerIndex:l.featureIndex,geometry:[],properties:h.properties,type:"Point",id:h.id},c);if(!e)continue;const a=e.toString(),u=this.iconAtlasPositions&&this.iconAtlasPositions.get(a);if(u){const e=i.getAppearanceValueAndResolveTokens(d,"icon-offset",p,t,r),a=e&&Array.isArray(e)?e:[0,0];let f=ng(u,void 0,a,i.layout.get("icon-anchor").evaluate(p,{},t));const m=i.getAppearanceValueAndResolveTokens(d,"icon-rotate",p,t,r),y="number"==typeof m?m:0,g=u.sdf,x=i.layout.get("icon-text-fit").constantOr("none");"none"!==x&&h.textShaping&&h.iconTextFitPadding&&h.fontScale&&(f=ig(f,h.textShaping,x,h.iconTextFitPadding,a,h.fontScale));const v=this.calculateEffectiveAppearanceIconSize(d,n.zoom,p,t,r,c),b=0,w=1+(Math.min(ux,Math.round(v*lg))<<1),_=Vg(f,y,g,"none"!==x,c);h.isUsingAppearanceVertexData||(h.isUsingAppearanceVertexData=!0,h.layoutBasedVertexData=this.icon.getIconVertexData(o,l.numIconVertices));for(let t=0;t<_.length;++t){const e=_[t],r=h.layoutBasedVertexData[0]||l.tileAnchorX,n=h.layoutBasedVertexData[1]||l.tileAnchorY,i=16*e.pixelOffsetTL.x,s=16*e.pixelOffsetTL.y,a=16*e.pixelOffsetBR.x,u=16*e.pixelOffsetBR.y,c=16*e.minFontScaleX,p=16*e.minFontScaleY;this.icon.updateIconVertexData(o,r,n,Math.round(32*e.tl.x),Math.round(32*e.tl.y),e.texPrimary.x,e.texPrimary.y,b,w,i,s,c,p),this.icon.updateIconVertexData(o+1,r,n,Math.round(32*e.tr.x),Math.round(32*e.tr.y),e.texPrimary.x+e.texPrimary.w,e.texPrimary.y,b,w,a,s,c,p),this.icon.updateIconVertexData(o+2,r,n,Math.round(32*e.bl.x),Math.round(32*e.bl.y),e.texPrimary.x,e.texPrimary.y+e.texPrimary.h,b,w,i,u,c,p),this.icon.updateIconVertexData(o+3,r,n,Math.round(32*e.br.x),Math.round(32*e.br.y),e.texPrimary.x+e.texPrimary.w,e.texPrimary.y+e.texPrimary.h,b,w,a,u,c,p),o+=4;}const A=l.numIconVertices-4*_.length;for(let t=0;t<A;++t)this.icon.updateIconVertexData(o+t,0,0,0,0,0,0,0,0,0,0,0,0);s=!0;}else o+=l.numIconVertices;}else if(h.usesAppearanceIconAsPlaceholder)this.layers[0].appearances&&this.layers[0].appearances.length>0&&(this.icon.updateIconVertexData(o,0,0,0,0,0,0,0,0,0,0,0,0),this.icon.updateIconVertexData(o+1,0,0,0,0,0,0,0,0,0,0,0,0),this.icon.updateIconVertexData(o+2,0,0,0,0,0,0,0,0,0,0,0,0),this.icon.updateIconVertexData(o+3,0,0,0,0,0,0,0,0,0,0,0,0),s=!0),o+=l.numIconVertices,h.activeAppearance=null;else if(h.isUsingAppearanceVertexData){const t=12,e=h.layoutBasedVertexData.length/t;for(let r=0;r<e;++r){const e=r*t;this.icon.updateIconVertexData(o+r,h.layoutBasedVertexData[e+0],h.layoutBasedVertexData[e+1],h.layoutBasedVertexData[e+2],h.layoutBasedVertexData[e+3],h.layoutBasedVertexData[e+4],h.layoutBasedVertexData[e+5],h.layoutBasedVertexData[e+6],h.layoutBasedVertexData[e+7],h.layoutBasedVertexData[e+8],h.layoutBasedVertexData[e+9],h.layoutBasedVertexData[e+10],h.layoutBasedVertexData[e+11]);}o+=e,h.isUsingAppearanceVertexData=!1,h.activeAppearance=null,s=!0;}else o+=l.numIconVertices,h.activeAppearance=null;}}return s}update(t,e,r,n,i,s,o){this.text.programConfigurations.updatePaintArrays(t,e,i,r,n,s,o,this.worldview),this.icon.programConfigurations.updatePaintArrays(t,e,i,r,n,s,o,this.worldview);}updateRoadElevation(t){if("road"!==this.elevationType||!this.elevationFeatures)return;if(this.elevationStateComplete)return;this.elevationStateComplete=!0,this.hasAnyZOffset=!1;let e=!1;const r=vu(t),n=1/r;let i=!1,s=!1;for(let t=0;t<this.symbolInstances.length;t++){const o=this.symbolInstances.get(t),a=M(1,0,0),l=M(0,1,0),{numHorizontalGlyphVertices:u,numVerticalGlyphVertices:c,numIconVertices:h,numVerticalIconVertices:p}=o,d=u>0||c>0,f=h>0,m=this.elevationFeatures[o.elevationFeatureIndex];if(m){const t=new It(o.tileAnchorX,o.tileAnchorY),u=.075+m.pointElevation(t);o.zOffset!==u&&(e=!0,o.zOffset=u),0!==u&&(this.hasAnyZOffset=!0);const c=m.computeSlopeNormal(t,n),h=lt(tt(),M(0,0,1),c);G(a,a,h),G(l,l,h),a[2]*=r,l[2]*=r,1===a[0]&&0===a[1]&&0===a[2]&&0===l[0]&&1===l[1]&&0===l[2]||(i=i||d,s=s||f);}if(d&&(Gx(this.text.orientationVertexArray,u,a,l),Gx(this.text.orientationVertexArray,c,a,l)),f){const{placedIconSymbolIndex:t,verticalPlacedIconSymbolIndex:e}=o;t>=0&&Gx(this.icon.orientationVertexArray,h,a,l),e>=0&&Gx(this.icon.orientationVertexArray,p,a,l);}}i||(this.text.orientationVertexArray=void 0),s||(this.icon.orientationVertexArray=void 0),e&&(this.zOffsetBuffersNeedUpload=!0,this.zOffsetSortDirty=!0);}updateZOffset(){const t=(t,e,n)=>{r+=e,r>t.length&&t.resize(r);for(let i=-e;i<0;i++)t.emplace(i+r,n);},e=(t,e,r)=>{n+=e,n>t.length&&t.resize(n);for(let i=-e;i<0;i++)t.emplace(i+n,r);};if(!this.zOffsetBuffersNeedUpload)return;this.zOffsetBuffersNeedUpload=!1;let r=0,n=0;for(let r=0;r<this.symbolInstances.length;r++){const n=this.symbolInstances.get(r),{numHorizontalGlyphVertices:i,numVerticalGlyphVertices:s,numIconVertices:o}=n,a=n.zOffset,l=o>0;if((i>0||s>0)&&(t(this.text.zOffsetVertexArray,i,a),t(this.text.zOffsetVertexArray,s,a)),l){const{placedIconSymbolIndex:t,verticalPlacedIconSymbolIndex:r}=n;t>=0&&e(this.icon.zOffsetVertexArray,o,a),r>=0&&e(this.icon.zOffsetVertexArray,n.numVerticalIconVertices,a);}}this.text.zOffsetVertexBuffer&&this.text.zOffsetVertexBuffer.updateData(this.text.zOffsetVertexArray),this.icon.zOffsetVertexBuffer&&this.icon.zOffsetVertexBuffer.updateData(this.icon.zOffsetVertexArray);}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return !this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t,e,r,n,i){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload,this.zOffsetBuffersNeedUpload,!1),null===this.hasAppearances&&(this.hasAppearances=this.layers.some((t=>t.appearances&&t.appearances.length>0))),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload,this.zOffsetBuffersNeedUpload,this.hasAppearances),this.uploaded=!0;}updateAppearances(t,e,r,n){return !!(t&&e&&r)&&!(!this.icon.layoutVertexArray||0===this.icon.layoutVertexArray.length)&&!!this.icon.layoutVertexArray.arrayBuffer&&void(this.updateAppearanceBasedIconTextures(t,e,r,n)&&this.icon.layoutVertexBuffer&&null!==this.icon.layoutVertexArray.arrayBuffer&&this.icon.layoutVertexArray.length===this.icon.layoutVertexBuffer.length&&this.icon.layoutVertexBuffer.updateData(this.icon.layoutVertexArray))}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy();}getProjection(){return this.projectionInstance||(this.projectionInstance=Lx(this.projection)),this.projectionInstance}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData();}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment)for(const{x:t,y:r}of e)this.lineVertexArray.emplaceBack(t,r);return {lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(t,e,r,n,i,s,o,a,l,u,c,h,p,d,f,m,y,g){const x=t.indexArray,v=t.layoutVertexArray,b=t.globeExtVertexArray,w=t.segments.prepareSegment(4*g,v,x,this.canOverlap?s.sortKey:void 0),_=this.glyphOffsetArray.length,A=w.vertexLength,I=this.allowVerticalPlacement&&o===$y.vertical?Math.PI/2:0,M=s.text&&s.text.sections;for(let n=0;n<e.length;n++){const{tl:i,tr:o,bl:u,br:c,texPrimary:h,texSecondary:y,pixelOffsetTL:g,pixelOffsetBR:_,minFontScaleX:A,minFontScaleY:S,glyphOffset:P,isSDF:k,sectionIndex:B}=e[n],z=w.vertexLength,T=P[1];if(Nx(v,l.x,l.y,i.x,T+i.y,h.x,h.y,r,k,g.x,g.y,A,S),Nx(v,l.x,l.y,o.x,T+o.y,h.x+h.w,h.y,r,k,_.x,g.y,A,S),Nx(v,l.x,l.y,u.x,T+u.y,h.x,h.y+h.h,r,k,g.x,_.y,A,S),Nx(v,l.x,l.y,c.x,T+c.y,h.x+h.w,h.y+h.h,r,k,_.x,_.y,A,S),a){const{x:e,y:r,z:n}=a.anchor,[i,s,o]=a.up;$x(b,e,r,n,i,s,o),$x(b,e,r,n,i,s,o),$x(b,e,r,n,i,s,o),$x(b,e,r,n,i,s,o),qx(t.dynamicLayoutVertexArray,e,r,n,I);}else qx(t.dynamicLayoutVertexArray,l.x,l.y,l.z,I);if(m){const e=y||h;jx(t.iconTransitioningVertexArray,e.x,e.y),jx(t.iconTransitioningVertexArray,e.x+e.w,e.y),jx(t.iconTransitioningVertexArray,e.x,e.y+e.h),jx(t.iconTransitioningVertexArray,e.x+e.w,e.y+e.h);}x.emplaceBack(z,z+1,z+2),x.emplaceBack(z+1,z+2,z+3),w.vertexLength+=4,w.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(P[0]),n!==e.length-1&&B===e[n+1].sectionIndex||t.programConfigurations.populatePaintArrays(v.length,s,s.index,{},p,d,f,M&&M[B],this.worldview);}const S=g-e.length;0!==S&&this._addNullVertices(S,v,r,a,b,t,m,w,x);const P=a?a.anchor:l;t.placedSymbolArray.emplaceBack(P.x,P.y,P.z,l.x,l.y,_,this.glyphOffsetArray.length-_,A,u,c,l.segment,r?r[0]:0,r?r[1]:0,n[0],n[1],o,0,0,0,h,0),t.symbolInstanceIndices.push(y);}_addNullVertices(t,e,r,n,i,s,o,a,l){for(let u=0;u<t;u++){for(let t=0;t<4;t++)Nx(e,0,0,0,0,0,0,r,!1,0,0,0,0),n?($x(i,0,0,0,0,0,0),qx(s.dynamicLayoutVertexArray,0,0,0,0)):qx(s.dynamicLayoutVertexArray,0,0,0,0),o&&jx(s.iconTransitioningVertexArray,0,0);const t=a.vertexLength;l.emplaceBack(t,t+1,t+2),l.emplaceBack(t+1,t+2,t+3),a.vertexLength+=4,a.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(0);}}_commitLayoutVertex(t,e,r,n,i,s,o){t.emplaceBack(e,r,n,i,s,Math.round(o.x),Math.round(o.y));}_addCollisionDebugVertices(t,e,r,n,i,s,o){const a=r.segments.prepareSegment(4,r.layoutVertexArray,r.indexArray),l=a.vertexLength,u=o.tileAnchorX,c=o.tileAnchorY;for(let t=0;t<4;t++)r.collisionVertexArray.emplaceBack(0,0,0,0,0,0);this._commitDebugCollisionVertexUpdate(r.collisionVertexArrayExt,e,t.padding,o.zOffset),this._commitLayoutVertex(r.layoutVertexArray,n,i,s,u,c,new It(t.x1,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,i,s,u,c,new It(t.x2,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,i,s,u,c,new It(t.x2,t.y2)),this._commitLayoutVertex(r.layoutVertexArray,n,i,s,u,c,new It(t.x1,t.y2)),a.vertexLength+=4;const h=r.indexArray;h.emplaceBack(l,l+1),h.emplaceBack(l+1,l+2),h.emplaceBack(l+2,l+3),h.emplaceBack(l+3,l),a.primitiveLength+=4;}_addTextDebugCollisionBoxes(t,e,r,n,i,s){for(let o=n;o<i;o++){const n=r.get(o),i=this.getSymbolInstanceTextSize(t,s,e,o);this._addCollisionDebugVertices(n,i,this.textCollisionBox,n.projectedAnchorX,n.projectedAnchorY,n.projectedAnchorZ,s);}}_addIconDebugCollisionBoxes(t,e,r,n,i,s){for(let o=n;o<i;o++){const n=r.get(o),i=this.getSymbolInstanceIconSize(t,e,s.placedIconSymbolIndex);this._addCollisionDebugVertices(n,i,this.iconCollisionBox,n.projectedAnchorX,n.projectedAnchorY,n.projectedAnchorZ,s);}}generateCollisionDebugBuffers(t,e,r){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new Zx(Ta,yy.members,Ba),this.iconCollisionBox=new Zx(Ta,yy.members,Ba);const n=hg(this.iconSizeData,t),i=hg(this.textSizeData,t,r);for(let r=0;r<this.symbolInstances.length;r++){const s=this.symbolInstances.get(r);this._addTextDebugCollisionBoxes(i,t,e,s.textBoxStartIndex,s.textBoxEndIndex,s),this._addTextDebugCollisionBoxes(i,t,e,s.verticalTextBoxStartIndex,s.verticalTextBoxEndIndex,s),this._addIconDebugCollisionBoxes(n,t,e,s.iconBoxStartIndex,s.iconBoxEndIndex,s),this._addIconDebugCollisionBoxes(n,t,e,s.verticalIconBoxStartIndex,s.verticalIconBoxEndIndex,s);}}getSymbolInstanceTextSize(t,e,r,n){const i=this.text.placedSymbolArray.get(e.rightJustifiedTextSymbolIndex>=0?e.rightJustifiedTextSymbolIndex:e.centerJustifiedTextSymbolIndex>=0?e.centerJustifiedTextSymbolIndex:e.leftJustifiedTextSymbolIndex>=0?e.leftJustifiedTextSymbolIndex:e.verticalPlacedTextSymbolIndex>=0?e.verticalPlacedTextSymbolIndex:n),s=cg(this.textSizeData,t,i)/xy;return this.tilePixelRatio*s}getSymbolInstanceIconSize(t,e,r){const n=this.icon.placedSymbolArray.get(r),i=cg(this.iconSizeData,t,n);return this.tilePixelRatio*i}_commitDebugCollisionVertexUpdate(t,e,r,n){t.emplaceBack(e,-r,-r,n),t.emplaceBack(e,r,-r,n),t.emplaceBack(e,r,r,n),t.emplaceBack(e,-r,r,n);}_updateTextDebugCollisionBoxes(t,e,r,n,i,s,o){for(let o=n;o<i;o++){const n=r.get(o),i=this.getSymbolInstanceTextSize(t,s,e,o);this._commitDebugCollisionVertexUpdate(this.textCollisionBox.collisionVertexArrayExt,i,n.padding,s.zOffset);}}_updateIconDebugCollisionBoxes(t,e,r,n,i,s,o){for(let o=n;o<i;o++){const n=r.get(o),i=this.getSymbolInstanceIconSize(t,e,s.placedIconSymbolIndex);this._commitDebugCollisionVertexUpdate(this.iconCollisionBox.collisionVertexArrayExt,i,n.padding,s.zOffset);}}updateCollisionDebugBuffers(t,e,r,n){if(!this.hasDebugData())return;this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexArrayExt.clear(),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexArrayExt.clear();const i=hg(this.iconSizeData,t,n),s=hg(this.textSizeData,t,r);for(let o=0;o<this.symbolInstances.length;o++){const a=this.symbolInstances.get(o);this._updateTextDebugCollisionBoxes(s,t,e,a.textBoxStartIndex,a.textBoxEndIndex,a,r),this._updateTextDebugCollisionBoxes(s,t,e,a.verticalTextBoxStartIndex,a.verticalTextBoxEndIndex,a,r),this._updateIconDebugCollisionBoxes(i,t,e,a.iconBoxStartIndex,a.iconBoxEndIndex,a,n),this._updateIconDebugCollisionBoxes(i,t,e,a.verticalIconBoxStartIndex,a.verticalIconBoxEndIndex,a,n);}this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexBufferExt&&this.textCollisionBox.collisionVertexBufferExt.updateData(this.textCollisionBox.collisionVertexArrayExt),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexBufferExt&&this.iconCollisionBox.collisionVertexBufferExt.updateData(this.iconCollisionBox.collisionVertexArrayExt);}_deserializeCollisionBoxesForSymbol(t,e,r,n,i,s,o,a,l){const u={};if(e<r){const{x1:r,y1:n,x2:i,y2:s,padding:o,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:d}=t.get(e);u.textBox={x1:r,y1:n,x2:i,y2:s,padding:o,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.textFeatureIndex=d;}if(n<i){const{x1:e,y1:r,x2:i,y2:s,padding:o,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:d}=t.get(n);u.verticalTextBox={x1:e,y1:r,x2:i,y2:s,padding:o,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.verticalTextFeatureIndex=d;}if(s<o){const{x1:e,y1:r,x2:n,y2:i,padding:o,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:d}=t.get(s);u.iconBox={x1:e,y1:r,x2:n,y2:i,padding:o,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.iconFeatureIndex=d;}if(a<l){const{x1:e,y1:r,x2:n,y2:i,padding:s,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:d}=t.get(a);u.verticalIconBox={x1:e,y1:r,x2:n,y2:i,padding:s,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.verticalIconFeatureIndex=d;}return u}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex));}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}hasIconTextFit(){return this.hasAnyIconTextFit}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),n=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<n;e+=4)t.indexArray.emplaceBack(e,e+1,e+2),t.indexArray.emplaceBack(e+1,e+2,e+3);}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),n=[],i=[],s=[];for(let t=0;t<this.symbolInstances.length;++t){s.push(t);const o=this.symbolInstances.get(t);n.push(0|Math.round(e*o.tileAnchorX+r*o.tileAnchorY)),i.push(o.featureIndex);}return s.sort(((t,e)=>n[t]-n[e]||i[e]-i[t])),s}getSortedIndexesByZOffset(){if(!this.zOffsetSortDirty)return this.symbolInstanceIndexesSortedZOffset;if(!this.symbolInstanceIndexesSortedZOffset){this.symbolInstanceIndexesSortedZOffset=[];for(let t=0;t<this.symbolInstances.length;++t)this.symbolInstanceIndexesSortedZOffset.push(t);}return this.zOffsetSortDirty=!1,this.symbolInstanceIndexesSortedZOffset.sort(((t,e)=>this.symbolInstances.get(e).zOffset-this.symbolInstances.get(t).zOffset))}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1});}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex);const{rightJustifiedTextSymbolIndex:r,centerJustifiedTextSymbolIndex:n,leftJustifiedTextSymbolIndex:i,verticalPlacedTextSymbolIndex:s,placedIconSymbolIndex:o,verticalPlacedIconSymbolIndex:a}=e;r>=0&&this.addIndicesForPlacedSymbol(this.text,r),n>=0&&n!==r&&this.addIndicesForPlacedSymbol(this.text,n),i>=0&&i!==n&&i!==r&&this.addIndicesForPlacedSymbol(this.text,i),s>=0&&this.addIndicesForPlacedSymbol(this.text,s),o>=0&&this.addIndicesForPlacedSymbol(this.icon,o),a>=0&&this.addIndicesForPlacedSymbol(this.icon,a);}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray);}}getElevationFeatureForText(t){const e=this.symbolInstances.get(this.text.symbolInstanceIndices[t]).elevationFeatureIndex;let r;return this.elevationFeatures&&e<this.elevationFeatures.length&&(r=this.elevationFeatures[e]),r}}function Yx(t,e){return e.replace(/{([^{}]+)}/g,((e,r)=>r in t?String(t[r]):""))}let Kx,Jx,Qx;Qs(Wx,"SymbolBucket",{omit:["layers","collisionBoxArray","compareText","features"]}),Wx.addDynamicAttributes=qx;class tv{constructor(t){this.type=t.property.overrides?t.property.overrides.runtimeType:gr,this.defaultValue=t;}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression);}outputDefined(){return !1}serialize(){return null}}Qs(tv,"FormatSectionOverride",{omit:["defaultValue"]});const ev=()=>Qx||(Qx={layout:Kx||(Kx=new Do({"symbol-placement":new Vo(Ro.layout_symbol["symbol-placement"]),"symbol-spacing":new Vo(Ro.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new Vo(Ro.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new Fo(Ro.layout_symbol["symbol-sort-key"]),"symbol-z-order":new Vo(Ro.layout_symbol["symbol-z-order"]),"symbol-z-elevate":new Vo(Ro.layout_symbol["symbol-z-elevate"]),"symbol-elevation-reference":new Vo(Ro.layout_symbol["symbol-elevation-reference"]),"icon-allow-overlap":new Vo(Ro.layout_symbol["icon-allow-overlap"]),"icon-ignore-placement":new Vo(Ro.layout_symbol["icon-ignore-placement"]),"icon-optional":new Vo(Ro.layout_symbol["icon-optional"]),"icon-rotation-alignment":new Vo(Ro.layout_symbol["icon-rotation-alignment"]),"icon-size":new Fo(Ro.layout_symbol["icon-size"]),"icon-size-scale-range":new Vo(Ro.layout_symbol["icon-size-scale-range"]),"icon-text-fit":new Fo(Ro.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new Fo(Ro.layout_symbol["icon-text-fit-padding"]),"icon-image":new Fo(Ro.layout_symbol["icon-image"]),"icon-image-use-theme":new Vo({type:"string",default:"default","property-type":"data-constant"}),"icon-rotate":new Fo(Ro.layout_symbol["icon-rotate"]),"icon-padding":new Vo(Ro.layout_symbol["icon-padding"]),"icon-keep-upright":new Vo(Ro.layout_symbol["icon-keep-upright"]),"icon-offset":new Fo(Ro.layout_symbol["icon-offset"]),"icon-anchor":new Fo(Ro.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new Vo(Ro.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new Vo(Ro.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new Vo(Ro.layout_symbol["text-rotation-alignment"]),"text-field":new Fo(Ro.layout_symbol["text-field"]),"text-font":new Fo(Ro.layout_symbol["text-font"]),"text-size":new Fo(Ro.layout_symbol["text-size"]),"text-size-scale-range":new Vo(Ro.layout_symbol["text-size-scale-range"]),"text-max-width":new Fo(Ro.layout_symbol["text-max-width"]),"text-line-height":new Fo(Ro.layout_symbol["text-line-height"]),"text-letter-spacing":new Fo(Ro.layout_symbol["text-letter-spacing"]),"text-justify":new Fo(Ro.layout_symbol["text-justify"]),"text-radial-offset":new Fo(Ro.layout_symbol["text-radial-offset"]),"text-variable-anchor":new Vo(Ro.layout_symbol["text-variable-anchor"]),"text-anchor":new Fo(Ro.layout_symbol["text-anchor"]),"text-max-angle":new Vo(Ro.layout_symbol["text-max-angle"]),"text-writing-mode":new Vo(Ro.layout_symbol["text-writing-mode"]),"text-rotate":new Fo(Ro.layout_symbol["text-rotate"]),"text-padding":new Vo(Ro.layout_symbol["text-padding"]),"text-keep-upright":new Vo(Ro.layout_symbol["text-keep-upright"]),"text-transform":new Fo(Ro.layout_symbol["text-transform"]),"text-offset":new Fo(Ro.layout_symbol["text-offset"]),"text-allow-overlap":new Vo(Ro.layout_symbol["text-allow-overlap"]),"text-ignore-placement":new Vo(Ro.layout_symbol["text-ignore-placement"]),"text-optional":new Vo(Ro.layout_symbol["text-optional"]),visibility:new Vo(Ro.layout_symbol.visibility)})),paint:Jx||(Jx=new Do({"icon-opacity":new Fo(Ro.paint_symbol["icon-opacity"]),"icon-occlusion-opacity":new Fo(Ro.paint_symbol["icon-occlusion-opacity"]),"icon-emissive-strength":new Fo(Ro.paint_symbol["icon-emissive-strength"]),"text-emissive-strength":new Fo(Ro.paint_symbol["text-emissive-strength"]),"icon-color":new Fo(Ro.paint_symbol["icon-color"]),"icon-halo-color":new Fo(Ro.paint_symbol["icon-halo-color"]),"icon-halo-width":new Fo(Ro.paint_symbol["icon-halo-width"]),"icon-halo-blur":new Fo(Ro.paint_symbol["icon-halo-blur"]),"icon-translate":new Vo(Ro.paint_symbol["icon-translate"]),"icon-translate-anchor":new Vo(Ro.paint_symbol["icon-translate-anchor"]),"icon-image-cross-fade":new Vo(Ro.paint_symbol["icon-image-cross-fade"]),"text-opacity":new Fo(Ro.paint_symbol["text-opacity"]),"text-occlusion-opacity":new Fo(Ro.paint_symbol["text-occlusion-opacity"]),"text-color":new Fo(Ro.paint_symbol["text-color"],{runtimeType:wr,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new Fo(Ro.paint_symbol["text-halo-color"]),"text-halo-width":new Fo(Ro.paint_symbol["text-halo-width"]),"text-halo-blur":new Fo(Ro.paint_symbol["text-halo-blur"]),"text-translate":new Vo(Ro.paint_symbol["text-translate"]),"text-translate-anchor":new Vo(Ro.paint_symbol["text-translate-anchor"]),"icon-color-saturation":new Vo(Ro.paint_symbol["icon-color-saturation"]),"icon-color-contrast":new Vo(Ro.paint_symbol["icon-color-contrast"]),"icon-color-brightness-min":new Vo(Ro.paint_symbol["icon-color-brightness-min"]),"icon-color-brightness-max":new Vo(Ro.paint_symbol["icon-color-brightness-max"]),"symbol-z-offset":new Fo(Ro.paint_symbol["symbol-z-offset"]),"icon-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"}),"icon-halo-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"}),"text-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"}),"text-halo-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"})}))},Qx);class rv extends oa{constructor(t,e,r,n){super(t,ev(),e,r,n,t.layout?t.layout["icon-image-use-theme"]:null),this._colorAdjustmentMatrix=u([]),this.hasOcclusionOpacityProperties=void 0!==t.paint&&("icon-occlusion-opacity"in t.paint||"text-occlusion-opacity"in t.paint);}_handleSpecialPaintPropertyUpdate(t){"icon-occlusion-opacity"!==t&&"text-occlusion-opacity"!==t||(this.hasOcclusionOpacityProperties=!0);}recalculate(t,e){super.recalculate(t,e),this.appearances&&this.appearances.forEach((r=>{r.recalculate(t,e,this.iconImageUseTheme);})),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]=this.layout.get("text-rotation-alignment")),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment"));const r=this.layout.get("text-writing-mode");if(r){const t=[];for(const e of r)t.indexOf(e)<0&&t.push(e);this.layout._values["text-writing-mode"]=t;}else this.layout._values["text-writing-mode"]="point"===this.layout.get("symbol-placement")?["horizontal"]:["horizontal","vertical"];this._setPaintOverrides();}getColorAdjustmentMatrix(t,e,r,n){return this._saturation===t&&this._contrast===e&&this._brightnessMin===r&&this._brightnessMax===n||(this._colorAdjustmentMatrix=function(t,e,r,n){t=ie(t),e=ne(e);const i=a(),s=t/3,o=1-2*s,l=[o,s,s,0,s,o,s,0,s,s,o,0,0,0,0,1],u=.5-.5*e,c=n-r;return h(i,[c,0,0,0,0,c,0,0,0,0,c,0,r,r,r,1],[e,0,0,0,0,e,0,0,0,0,e,0,u,u,u,1]),h(i,i,l),i}(t,e,r,n),this._saturation=t,this._contrast=e,this._brightnessMin=r,this._brightnessMax=n),this._colorAdjustmentMatrix}getValueAndResolveTokens(t,e,r,n){const i=this.layout.get(t).evaluate(e,{},r,n),s=this._unevaluatedLayout._values[t];return s.isDataDriven()||Ns(s.value)||!i?i:Yx(e.properties,i)}getAppearanceValueAndResolveTokens(t,e,r,n,i){const s=t.getProperty(e);if(!s)return;const o=s.evaluate(r,{},n,i),a=t.getUnevaluatedProperties()._values[e];return a.isDataDriven()||Ns(a.value)||!o||"string"!=typeof o?o:Yx(r.properties,o)}createBucket(t){return new Wx(t)}queryRadius(){return 0}queryIntersectsFeature(){return !1}_setPaintOverrides(){for(const t of ev().paint.overridableProperties){if(!rv.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new tv(e),n=new Us(r,e.property.specification,this.scope,this.options,this.layout.get("icon-image-use-theme"));let i=null;i="constant"===e.value.kind||"source"===e.value.kind?new $s("source",n):new Gs("composite",n,e.value.zoomStops,e.value.interpolationType),this.paint._values[t]=new To(e.property,i,e.parameters);}}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven())&&rv.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const r=t.get("text-field"),n=ev().paint.properties[e];let i=!1;const s=t=>{for(const e of t)if(n.overrides&&n.overrides.hasOverride(e))return void(i=!0)};if("constant"===r.value.kind&&r.value.value instanceof Dr)s(r.value.value.sections);else if("source"===r.value.kind){const t=e=>{i||(e instanceof $r&&Nr(e.value)===Mr?s(e.value.sections):e instanceof Xr?s(e.sections):e.eachChild(t));},e=r.value;e._styleExpression&&t(e._styleExpression.expression);}return i}getProgramIds(){return ["symbol"]}getDefaultProgramParams(t,e,r){return {config:new Ol(this,{zoom:e,lut:r}),overrideFog:!1}}hasElevation(){return this.layout&&"hd-road-markup"===this.layout.get("symbol-elevation-reference")}}let nv,iv,sv,ov;var av=ha([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);function lv(t,e,r,n,i,a,l,u){const c=[t,e,1,r,n,1,i,a,1],h=[l,u,1],p=s([],c),[d,f,m]=$(h,h,p);return o(c,c,[d,0,0,0,f,0,0,0,m])}function uv(t,e,r,n,i,a,l,u){const c=function(t,e,r,n,i,a,l,u){const c=lv(0,0,1,0,1,1,0,1),h=lv(t,e,r,n,i,a,l,u);return o(h,h,s([],c))}(t,e,r,n,i,a,l,u);return [c[2]/c[8]/Un,c[5]/c[8]/Un]}function cv(t){return [t[0],Math.min(Math.max(t[1],-mu),mu)]}class hv extends nr{constructor(t,e,r,n){super(),this.id=t,this.dispatcher=r,this.coordinates=e.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.onNorthPole=!1,this.onSouthPole=!1,this.setEventedParent(n),this.options=e,this._dirty=!1;}load(t,e){if(this._loaded=e||!1,this.fire(new Qe("dataloading",{dataType:"source"})),this.url=this.options.url,!this.url)return t&&(this.coordinates=t),this._loaded=!0,void this._finishLoading();this._imageRequest=Ge(this.map._requestManager.transformRequest(this.url,Ce.Image),((e,r)=>{this._imageRequest=null,this._loaded=!0,e?this.fire(new tr(e)):r&&(this.image=r instanceof HTMLImageElement?ye.getImageData(r):r,this._dirty=!0,this.width=this.image.width,this.height=this.image.height,t&&(this.coordinates=t),this._finishLoading());}));}loaded(){return this._loaded}updateImage(t){return t.url?(this._imageRequest&&t.url!==this.options.url&&(this._imageRequest.cancel(),this._imageRequest=null),this.options.url=t.url,this.load(t.coordinates,this._loaded),this):this}setTexture(t){if(!(t.handle instanceof WebGLTexture))throw new Error("The provided handle is not a WebGLTexture instance");return this.texture=new Ef(this.map.painter.context,t.handle),this.width=t.dimensions[0],this.height=t.dimensions[1],this._dirty=!1,this._loaded=!0,this._finishLoading(),this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new Qe("data",{dataType:"source",sourceDataType:"metadata"})));}onAdd(t){this.map=t,this.load();}onRemove(t){this._imageRequest&&(this._imageRequest.cancel(),this._imageRequest=null),!this.texture||this.texture instanceof Ef||this.texture.destroy(),this.boundsBuffer&&(this.boundsBuffer.destroy(),this.elevatedGlobeVertexBuffer&&this.elevatedGlobeVertexBuffer.destroy(),this.elevatedGlobeIndexBuffer&&this.elevatedGlobeIndexBuffer.destroy());}setCoordinates(t){if(this.coordinates=t,this._boundsArray=void 0,this._unsupportedCoords=!1,!t.length)return this;this.onNorthPole=!1,this.onSouthPole=!1;let e=t[0][1],r=t[0][1];for(const n of t)n[1]>r&&(r=n[1]),n[1]<e&&(e=n[1]);const n=(r+e)/2;if(n>mu?this.onNorthPole=!0:n<-mu&&(this.onSouthPole=!0),!this.onNorthPole&&!this.onSouthPole){const e=t.map(bu.fromLngLat);this.tileID=function(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const s of t)e=Math.min(e,s.x),r=Math.min(r,s.y),n=Math.max(n,s.x),i=Math.max(i,s.y);const s=Math.max(n-e,i-r),o=Math.max(0,Math.floor(-Math.log2(s))),a=Math.pow(2,o);let l=Math.floor((e+n)/2*a);return l>1&&(l-=1),new Pc(o,l,Math.floor((r+i)/2*a))}(e),this.minzoom=this.maxzoom=this.tileID.z;}return this.fire(new Qe("data",{dataType:"source",sourceDataType:"content"})),this}_clear(){!this.texture||this.texture instanceof Ef||(this.texture.destroy(),this._dirty=!0),this.texture=null,this._boundsArray=void 0,this._unsupportedCoords=!1;}_prepareData(t){for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture);}if(this._boundsArray||this.onNorthPole||this.onSouthPole||this._unsupportedCoords)return;const e=yx(new Pc(0,0,0),this.map.transform.projection),r=[e.projection.project(this.coordinates[0][0],this.coordinates[0][1]),e.projection.project(this.coordinates[1][0],this.coordinates[1][1]),e.projection.project(this.coordinates[2][0],this.coordinates[2][1]),e.projection.project(this.coordinates[3][0],this.coordinates[3][1])];if(!function(t){const e=t[1].x-t[0].x,r=t[1].y-t[0].y,n=t[2].x-t[1].x,i=t[2].y-t[1].y,s=t[3].x-t[2].x,o=t[3].y-t[2].y,a=t[0].x-t[3].x,l=t[0].y-t[3].y,u=e*i-n*r,c=n*o-s*i,h=s*l-a*o,p=a*r-e*l;return u>0&&c>0&&h>0&&p>0||u<0&&c<0&&h<0&&p<0}(r))return console.warn("Image source coordinates are defining non-convex area in the Mercator projection"),void(this._unsupportedCoords=!0);const n=yx(this.tileID,this.map.transform.projection),[i,a,l,u]=this.coordinates.map((t=>{const e=n.projection.project(t[0],t[1]);return gx(n,e)._round()}));this.perspectiveTransform=uv(i.x,i.y,a.x,a.y,l.x,l.y,u.x,u.y);const c=this._boundsArray=new ma;c.emplaceBack(i.x,i.y,0,0),c.emplaceBack(a.x,a.y,Un,0),c.emplaceBack(u.x,u.y,0,Un),c.emplaceBack(l.x,l.y,Un,Un),this.boundsBuffer&&(this.boundsBuffer.destroy(),this.elevatedGlobeVertexBuffer&&this.elevatedGlobeVertexBuffer.destroy(),this.elevatedGlobeIndexBuffer&&this.elevatedGlobeIndexBuffer.destroy()),this.boundsBuffer=t.createVertexBuffer(c,av.members),this.boundsSegments=hl.simpleSegment(0,0,4,2);const h=[],p=[cv((d=this.coordinates)[0]),cv(d[1]),cv(d[2]),cv(d[3])];var d;const[f,m,y,g]=function(t){let e=t[0][0],r=e,n=t[0][1],i=n;for(let s=1;s<t.length;s++)t[s][0]<e?e=t[s][0]:t[s][0]>r&&(r=t[s][0]),t[s][1]<n?n=t[s][1]:t[s][1]>i&&(i=t[s][1]);return [e,n,r-e,i-n]}(p);{const n=new ma,[i,a,l,u]=function(t){let e=t[0].x,r=e,n=t[0].y,i=n;for(let s=1;s<t.length;s++)t[s].x<e?e=t[s].x:t[s].x>r&&(r=t[s].x),t[s].y<n?n=t[s].y:t[s].y>i&&(i=t[s].y);return [e,n,r-e,i-n]}(r),c=t=>[(t.x-i)/l,(t.y-a)/u],[p,d,x,v]=r.map(c),b=function(t,e,r,n,i,a,l,u){const c=lv(0,0,1,0,1,1,0,1);return o(c,c,s([],lv(t,e,r,n,i,a,l,u)))}(p[0],p[1],d[0],d[1],x[0],x[1],v[0],v[1]);this.elevatedGlobePerspectiveTransform=uv(p[0],p[1],d[0],d[1],x[0],x[1],v[0],v[1]);const w=(t,e)=>{h.push(t.lng);const r=Math.round((t.lng-f)/y*Un),i=Math.round((t.lat-m)/g*Un),s=c(e),o=$([],[s[0],s[1],1],b),a=Math.round(o[0]/o[2]*Un),l=Math.round(o[1]/o[2]*Un);n.emplaceBack(r,i,a,l);},_=r[3].x-r[0].x,A=r[3].y-r[0].y,I=r[2].x-r[1].x,M=r[2].y-r[1].y;for(let t=0;t<65;t++){const n=t/64,i=[r[0].x+n*_,r[0].y+n*A],s=[r[1].x+n*I,r[1].y+n*M],o=s[0]-i[0],a=s[1]-i[1];for(let t=0;t<65;t++){const r=t/64,n={x:i[0]+o*r,y:i[1]+a*r};w(e.projection.unproject(n.x,n.y),n);}}this.elevatedGlobeVertexBuffer=t.createVertexBuffer(n,av.members);}{this.maxLongitudeTriangleSize=0;let e=[],r=new Fa;const n=(t,n,i)=>{r.emplaceBack(t,n,i);const s=h[t],o=h[n],a=h[i],l=Math.min(Math.min(s,o),a),u=Math.max(Math.max(s,o),a)-l;u>this.maxLongitudeTriangleSize&&(this.maxLongitudeTriangleSize=u),e.push(l+u/2);};for(let t=0;t<64;t++)for(let e=0;e<64;e++){const r=65*t+e,i=r+1,s=r+65,o=s+1;n(r,s,i),n(i,s,o);}[e,r]=function(t,e){const r=Array.from({length:t.length},((t,e)=>e));r.sort(((e,r)=>t[e]-t[r]));const n=[],i=new Fa;for(let s=0;s<r.length;s++){const o=r[s];n.push(t[o]);const a=3*o,l=a+1;i.emplaceBack(e.uint16[a],e.uint16[l],e.uint16[l+1]);}return [n,i]}(e,r),this.elevatedGlobeTrianglesCenterLongitudes=e,this.elevatedGlobeIndexBuffer=t.createIndexBuffer(r);}this.elevatedGlobeSegments=hl.simpleSegment(0,0,4225,8192),this.elevatedGlobeGridMatrix=new Float32Array([0,y/Un,0,g/Un,0,0,m,f,0]);}prepare(){const t=0!==Object.keys(this.tiles).length;if(this.tileID&&!t)return;const e=this.map.painter.context,r=e.gl;!this._dirty||this.texture instanceof Ef||(this.texture?this.texture.update(this.image):(this.texture=new Tf(e,this.image,r.RGBA8),this.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE)),this._dirty=!1),t&&this._prepareData(e);}loadTile(t,e){this.tileID&&this.tileID.equals(t.tileID.canonical)?(this.tiles[String(t.tileID.wrap)]=t,t.buckets={},e(null)):(t.state="errored",e(null));}serialize(){return {type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return !1}getSegmentsForLongitude(t){const e=this.elevatedGlobeSegments;if(!this.elevatedGlobeTrianglesCenterLongitudes||!e)return null;const r=this.elevatedGlobeTrianglesCenterLongitudes;let n=(i=t+180)+360*Math.round((r[0]-i)/360);var i;const s=new hl,o=(t,r)=>{s.segments.push({vertexOffset:0,primitiveOffset:t,vertexLength:e.segments[0].vertexLength,primitiveLength:r,sortKey:void 0,vaos:{}});},a=.51*this.maxLongitudeTriangleSize;if(Math.abs(r[0]-n)<=a){const t=re(r,0,r.length,n+a);return t===r.length||o(t,ee(r,t+1,r.length,n+360-a)-t),s}n<r[0]&&(n+=360);const l=ee(r,0,r.length,n-a);if(l===r.length)return o(0,r.length),s;o(0,l-0);const u=re(r,l+1,r.length,n+a);return u!==r.length&&o(u,r.length-u),s}}const pv=(Math.pow(256,2)-1)/16907520;class dv extends oa{constructor(t,e,r,n){super(t,{layout:sv||(sv=new Do({visibility:new Vo(Ro.layout_raster.visibility)})),paint:ov||(ov=new Do({"raster-opacity":new Vo(Ro.paint_raster["raster-opacity"]),"raster-color":new Co(Ro.paint_raster["raster-color"]),"raster-color-mix":new Vo(Ro.paint_raster["raster-color-mix"]),"raster-color-range":new Vo(Ro.paint_raster["raster-color-range"]),"raster-hue-rotate":new Vo(Ro.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new Vo(Ro.paint_raster["raster-brightness-min"]),"raster-brightness-max":new Vo(Ro.paint_raster["raster-brightness-max"]),"raster-saturation":new Vo(Ro.paint_raster["raster-saturation"]),"raster-contrast":new Vo(Ro.paint_raster["raster-contrast"]),"raster-resampling":new Vo(Ro.paint_raster["raster-resampling"]),"raster-fade-duration":new Vo(Ro.paint_raster["raster-fade-duration"]),"raster-emissive-strength":new Vo(Ro.paint_raster["raster-emissive-strength"]),"raster-array-band":new Vo(Ro.paint_raster["raster-array-band"]),"raster-elevation":new Vo(Ro.paint_raster["raster-elevation"]),"raster-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this.updateColorRamp(),this._curRampRange=[NaN,NaN];}getProgramIds(){return ["raster"]}hasColorMap(){return !!this._transitionablePaint._values["raster-color"].value.value}tileCoverLift(){return this.paint.get("raster-elevation")}isDraped(t){return !(t&&t._source instanceof hv&&(t._source.onNorthPole||t._source.onSouthPole))&&0===this.paint.get("raster-elevation")}_handleSpecialPaintPropertyUpdate(t){"raster-color"!==t&&"raster-color-range"!==t||(this._curRampRange=[NaN,NaN],this.updateColorRamp());}_clear(){this.colorRampTexture&&(this.colorRampTexture.destroy(),this.colorRampTexture=null);}updateColorRamp(t){if(!this.hasColorMap())return;if(!this._curRampRange)return;const e=this._transitionablePaint._values["raster-color"].value.expression,[r,n]=t||this._transitionablePaint._values["raster-color-range"].value.expression.evaluate({zoom:0})||[NaN,NaN];isNaN(r)&&isNaN(n)||r===this._curRampRange[0]&&n===this._curRampRange[1]||(this.colorRamp=Mh({expression:e,evaluationKey:"rasterValue",image:this.colorRamp,clips:[{start:r,end:n}],resolution:256}),this.colorRampTexture=null,this._curRampRange=[r,n]);}}let fv,mv,yv,gv,xv;class vv extends oa{constructor(t,e,r,n){super(t,{layout:fv||(fv=new Do({visibility:new Vo(Ro["layout_raster-particle"].visibility)})),paint:mv||(mv=new Do({"raster-particle-array-band":new Vo(Ro["paint_raster-particle"]["raster-particle-array-band"]),"raster-particle-count":new Vo(Ro["paint_raster-particle"]["raster-particle-count"]),"raster-particle-color":new Co(Ro["paint_raster-particle"]["raster-particle-color"]),"raster-particle-max-speed":new Vo(Ro["paint_raster-particle"]["raster-particle-max-speed"]),"raster-particle-speed-factor":new Vo(Ro["paint_raster-particle"]["raster-particle-speed-factor"]),"raster-particle-fade-opacity-factor":new Vo(Ro["paint_raster-particle"]["raster-particle-fade-opacity-factor"]),"raster-particle-reset-rate-factor":new Vo(Ro["paint_raster-particle"]["raster-particle-reset-rate-factor"]),"raster-particle-elevation":new Vo(Ro["paint_raster-particle"]["raster-particle-elevation"]),"raster-particle-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._updateColorRamp(),this.lastInvalidatedAt=ye.now();}_clear(){this.colorRampTexture&&(this.colorRampTexture.destroy(),this.colorRampTexture=null),this.tileFramebuffer&&(this.tileFramebuffer.destroy(),this.tileFramebuffer=null),this.particleFramebuffer&&(this.particleFramebuffer.destroy(),this.particleFramebuffer=null);}onRemove(t){this.colorRampTexture&&this.colorRampTexture.destroy(),this.tileFramebuffer&&this.tileFramebuffer.destroy(),this.particleFramebuffer&&this.particleFramebuffer.destroy();}hasColorMap(){return !!this._transitionablePaint._values["raster-particle-color"].value.value}getProgramIds(){return ["rasterParticle"]}hasOffscreenPass(){return "none"!==this.visibility}isDraped(t){return !1}_handleSpecialPaintPropertyUpdate(t){"raster-particle-color"!==t&&"raster-particle-max-speed"!==t||(this._updateColorRamp(),this._invalidateAnimationState()),"raster-particle-count"===t&&this._invalidateAnimationState();}_updateColorRamp(){if(!this.hasColorMap())return;const t=this._transitionablePaint._values["raster-particle-color"].value.expression,e=this._transitionablePaint._values["raster-particle-max-speed"].value.expression.evaluate({zoom:0});this.colorRamp=Mh({expression:t,evaluationKey:"rasterParticleSpeed",image:this.colorRamp,clips:[{start:0,end:e}],resolution:256}),this.colorRampTexture=null;}_invalidateAnimationState(){this.lastInvalidatedAt=ye.now();}tileCoverLift(){return this.paint.get("raster-particle-elevation")}}class bv extends oa{constructor(t,e){super(t,{},e,null),this.implementation=t,t.slot&&(this.slot=t.slot);}is3D(t){return "3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}isDraped(t){return void 0!==this.implementation.renderToTile}shouldRedrape(){return !!this.implementation.shouldRerenderTiles&&this.implementation.shouldRerenderTiles()}recalculate(){}updateTransitions(){}hasTransition(){return !1}serialize(){}onAdd(t){this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl);}onRemove(t){this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl);}}function wv(t,e,r){const n=[0,0,1],i=et([]);return nt(i,i,r?-kt(t)+Math.PI:kt(t)),rt(i,i,-kt(e)),G(n,n,i),L(n,n)}const _v={None:0,Model:1,Symbol:2,FillExtrusion:4};class Av{constructor(t,e,r,n){this.message=(t?`${t}: `:"")+r,n&&(this.identifier=n),null!=e&&e.__line__&&(this.line=e.__line__);}}function Iv(t,e){const r=-1===t.indexOf("://");try{return new URL(t,r&&e?"http://example.com":void 0),!0}catch(t){return !1}}class Mv{constructor(t,e){this.feature=t,this.instancedDataOffset=e,this.instancedDataCount=0,this.rotation=[0,0,0],this.scale=[1,1,1],this.translation=[0,0,0];}}class Sv{constructor(){this.maxScale=1,this.maxXYTranslationDistance=0,this.instancedDataArray=new qa,this.instancesEvaluatedElevation=[],this.features=[],this.idToFeaturesIndex={};}colorForInstance(t){const e=16*t,r=this.instancedDataArray.float32;let n=Math.floor(r[e+2]);const i=1.05*(r[e+2]-n);return n/=100,[r[e]%1*1.05,r[e+1]%1*1.05,i,n]}tileCoordinatesForInstance(t){const e=16*t,r=this.instancedDataArray.float32;let n=r[e+0];return n=n>Un?n-Un:n,new It(Math.trunc(n),Math.trunc(r[e+1]))}translationForInstance(t){const e=16*t,r=this.instancedDataArray.float32;return [r[e+4],r[e+5],r[e+6]]}rotationScaleForInstance(t){const e=16*t,r=this.instancedDataArray.float32;return [r[e+7],r[e+8],r[e+9],r[e+10],r[e+11],r[e+12],r[e+13],r[e+14],r[e+15]]}transformForInstance(t){const e=16*t,r=this.instancedDataArray.float32;return [r[e+7],r[e+8],r[e+9],r[e+4],r[e+10],r[e+11],r[e+12],r[e+5],r[e+13],r[e+14],r[e+15],r[e+6],0,0,0,1]}}class Pv{constructor(t){this.zoom=t.zoom,this.canonical=t.canonical,this.overscaledZ=this.canonical.z+Math.log2(t.overscaling),this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.projection=t.projection,this.index=t.index,this.worldview=t.worldview,this.hasZoomDependentProperties=this.layers[0].isZoomDependent(),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.hasPattern=!1,this.instancesPerModel={},this.validForExaggeration=0,this.maxVerticalOffset=0,this.maxScale=0,this.maxHeight=0,this.lookupDim=this.zoom>this.canonical.z+1?0:this.zoom>this.canonical.z?256:this.zoom>15?75:100,this.instanceCount=0,this.terrainElevationMin=0,this.terrainElevationMax=0,this.validForDEMTile={id:null,timestamp:0},this.modelUris=[],this.modelsRequested=!1,this.activeReplacements=[],this.replacementUpdateTime=0,this.styleDefinedModelURLs=t.styleDefinedModelURLs,this.hasAppearances=null;}updateFootprints(t,e){}updateAppearances(t,e,r,n){}populate(t,e,r,n){this.tileToMeter=vu(r);const i=this.layers[0]._featureFilter.needGeometry;this.lookup=new Uint8Array(this.lookupDim*this.lookupDim);for(const{feature:s,id:o,index:a,sourceLayerIndex:l}of t){const t=null!=o?o:s.properties&&s.properties.hasOwnProperty("id")?s.properties.id:void 0,u=Bu(s,i);if(!this.layers[0]._featureFilter.filter(new Io(this.zoom,{worldview:this.worldview,activeFloors:e.activeFloors}),u,r))continue;const c={id:t,sourceLayerIndex:l,index:a,geometry:i?u.geometry:ku(s,r,n),properties:s.properties,type:s.type,patterns:{}},h=this.addFeature(c,c.geometry,u);h&&e.featureIndex.insert(s,c.geometry,a,l,this.index,this.instancesPerModel[h].instancedDataArray.length,Un/32);}this.lookup=null;}evaluateQueryRenderedFeaturePadding(){const t=this.layers[0].modelManager,e=this.layers[0].scope;let r=0;for(const n of this.modelUris){const i=t.getModel(n,e);if(!i)continue;const s=this.instancesPerModel[n];if(s){const t=.5*F(i.aabb.max,i.aabb.min)*s.maxScale+s.maxXYTranslationDistance,e=Math.min(Un,Math.max(t/this.tileToMeter,Un/32));r=Math.max(e,r);}}return r}update(t,e,r,n){for(const e in this.instancesPerModel){const r=this.instancesPerModel[e];for(const e in t)r.idToFeaturesIndex.hasOwnProperty(e)&&(this.evaluate(r.features[r.idToFeaturesIndex[e]],t[e],r,!0),this.uploaded=!1);}this.maxHeight=0;}updateZoomBasedPaintProperties(){if(!this.hasZoomDependentProperties)return !1;let t=!1;for(const e in this.instancesPerModel){const r=this.instancesPerModel[e];for(const e of r.features){const n=this.layers[0],i=e.feature,s=this.canonical,o=n.paint.get("model-rotation").evaluate(i,{},s),a=n.paint.get("model-scale").evaluate(i,{},s),l=n.paint.get("model-translation").evaluate(i,{},s);H(e.rotation,o)&&H(e.scale,a)&&H(e.translation,l)||(this.evaluate(e,e.featureStates,r,!0),t=!0);}}return t}updateReplacement(t,e,r,n){if(e.updateTime===this.replacementUpdateTime)return !1;this.replacementUpdateTime=e.updateTime;const i=e.getReplacementRegionsForTile(t.toUnwrapped(),!0);if(jp(this.activeReplacements,i))return !1;this.activeReplacements=i;let s=!1;for(const e in this.instancesPerModel){const i=this.instancesPerModel[e],o=i.instancedDataArray;for(const e of i.features){const i=e.instancedDataOffset,a=e.instancedDataCount;for(let e=0;e<a;e++){const a=16*(e+i);let l=o.float32[a+0];const u=l>Un;l=u?l-Un:l;const c=Math.floor(l),h=Math.floor(o.float32[a+1]);let p=!1;for(const e of this.activeReplacements)if(!Lp(e,r,_v.Model,n)&&!(e.min.x>c||c>e.max.x||e.min.y>h||h>e.max.y)&&(p=Zp(Xp(c,h,t.canonical,e.footprintTileId.canonical),e.footprint),p))break;o.float32[a]=p?l+Un:l,s=s||p!==u;}}}return s}isEmpty(){for(const t in this.instancesPerModel)if(0!==this.instancesPerModel[t].instancedDataArray.length)return !1;return !0}uploadPending(){return !this.uploaded}upload(t){if(!this.uploaded)for(const e in this.instancesPerModel){const r=this.instancesPerModel[e];r.instancedDataArray.length<0||0===r.instancedDataArray.length||(r.instancedDataBuffer?r.instancedDataBuffer.updateData(r.instancedDataArray):r.instancedDataBuffer=t.createVertexBuffer(r.instancedDataArray,Lf.members,!0,void 0,this.instanceCount));}this.uploaded=!0;}destroy(t){for(const t in this.instancesPerModel){const e=this.instancesPerModel[t];0!==e.instancedDataArray.length&&e.instancedDataBuffer&&e.instancedDataBuffer.destroy();}const e=this.layers[0].modelManager;if(t&&e&&this.modelUris&&this.modelsRequested)for(const t of this.modelUris)e.removeModel(t,"",!0);}addFeature(t,e,r){const n=this.layers[0],i=n.layout.get("model-id").evaluate(r,{},this.canonical);if(!i)return Xt(`modelId is not evaluated for layer ${n.id} and it is not going to get rendered.`),i;(Iv(i,!1)||void 0!==this.styleDefinedModelURLs[i])&&(this.modelUris.includes(i)||this.modelUris.push(i)),this.instancesPerModel[i]||(this.instancesPerModel[i]=new Sv);const s=this.instancesPerModel[i],o=s.instancedDataArray,a=new Mv(r,o.length);for(const t of e)for(const e of t){if(e.x<0||e.x>=Un||e.y<0||e.y>=Un)continue;if(0!==this.lookupDim){const t=(this.lookupDim-1)/Un,r=this.lookupDim*(e.y*t|0)+e.x*t|0;if(this.lookup){if(0!==this.lookup[r])continue;this.lookup[r]=1;}}this.instanceCount++;const t=o.length;o.resize(t+1),s.instancesEvaluatedElevation.push(0),o.float32[16*t]=e.x,o.float32[16*t+1]=e.y;}return a.instancedDataCount=s.instancedDataArray.length-a.instancedDataOffset,a.instancedDataCount>0&&(t.id&&(s.idToFeaturesIndex[t.id]=s.features.length),s.features.push(a),this.evaluate(a,{},s,!1)),i}getModelUris(){return this.modelUris}evaluate(t,e,r,n){const i=this.layers[0],s=t.feature,o=this.canonical,a=t.rotation=i.paint.get("model-rotation").evaluate(s,e,o),l=t.scale=i.paint.get("model-scale").evaluate(s,e,o),u=t.translation=i.paint.get("model-translation").evaluate(s,e,o),c=Object.assign({},i.paint.get("model-color").evaluate(s,e,o));c.a=i.paint.get("model-color-mix-intensity").evaluate(s,e,o);const h=[];this.maxVerticalOffset<u[2]&&(this.maxVerticalOffset=u[2]);const p=u[0]*u[0]+u[1]*u[1],d=p>0?Math.sqrt(p):0;r.maxScale=Math.max(Math.max(r.maxScale,l[0]),Math.max(l[1],l[2])),r.maxXYTranslationDistance=Math.max(r.maxXYTranslationDistance,d),this.maxScale=Math.max(Math.max(this.maxScale,l[0]),Math.max(l[1],l[2])),Hf(h,a,l);const f=Math.round(100*c.a)+c.b/1.05;for(let e=0;e<t.instancedDataCount;++e){const i=t.instancedDataOffset+e,s=16*i,a=r.instancedDataArray.float32;let l=0;n&&(l=a[s+6]-r.instancesEvaluatedElevation[i]);const p=0|a[s+1];a[s]=(0|a[s])+c.r/1.05,a[s+1]=p+c.g/1.05,a[s+2]=f,a[s+3]=1/(o.z>10?this.tileToMeter:vu(o,p)),a[s+4]=u[0],a[s+5]=u[1],a[s+6]=u[2]+l,a[s+7]=h[0],a[s+8]=h[1],a[s+9]=h[2],a[s+10]=h[4],a[s+11]=h[5],a[s+12]=h[6],a[s+13]=h[8],a[s+14]=h[9],a[s+15]=h[10],r.instancesEvaluatedElevation[i]=u[2];}}}let kv,Bv;Qs(Pv,"ModelBucket",{omit:["layers"]}),Qs(Sv,"PerModelAttributes"),Qs(Mv,"ModelFeature");class zv{constructor(t,e,r){this._demTile=t,this._dem=this._demTile.dem,this._scale=e,this._offset=r;}static create(t,e,r){const n=r||t.findDEMTileFor(e);if(!n||!n.dem)return;const i=n.dem,s=n.tileID,o=1<<e.canonical.z-s.canonical.z;return new zv(n,i.dim/Un/o,[(e.canonical.x/o-s.canonical.x)*i.dim,(e.canonical.y/o-s.canonical.y)*i.dim])}tileCoordToPixel(t,e){const r=e*this._scale+this._offset[1];return new It(Math.floor(t*this._scale+this._offset[0]),Math.floor(r))}getElevationAt(t,e,r,n){const i=t*this._scale+this._offset[0],s=e*this._scale+this._offset[1],o=Math.floor(i),a=Math.floor(s),l=this._dem;return n=!!n,r?pr(pr(l.get(o,a,n),l.get(o,a+1,n),s-a),pr(l.get(o+1,a,n),l.get(o+1,a+1,n),s-a),i-o):l.get(o,a,n)}getElevationAtPixel(t,e,r){return this._dem.get(t,e,!!r)}getMeterToDEM(t){return (1<<this._demTile.tileID.canonical.z)*hu(1,t)*this._dem.stride}}const Tv=new Float32Array(262144),Ev=new Uint8Array(262144);function Vv(t){let e=0;if(t.meshes)for(const r of t.meshes)e=Math.max(e,r.aabb.max[2]);if(t.children)for(const r of t.children)e=Math.max(e,Vv(r));return e}function Fv(t,e,r){if(t.meshes)for(const n of t.meshes){if(n.aabb.min[0]===1/0)continue;const i=Ju.applyTransform(n.aabb,t.globalMatrix);r.insert(e,i.min[0],i.min[1],i.max[0],i.max[1]);}if(t.children)for(const n of t.children)Fv(n,e,r);}const Cv=["","wall","door","roof","window","lamp","logo"];class Dv{constructor(t){this.node=t,this.evaluatedRMEA=[[1,0,0,1],[1,0,0,1],[1,0,0,1],[1,0,0,1],[.4,1,0,1],[1,0,0,1],[1,0,0,1]],this.hiddenByReplacement=!1,this.evaluatedTranslation=[0,0,0],this.evaluatedScale=[1,1,1],this.evaluatedColor=[],this.emissionHeightBasedParams=[],this.cameraCollisionOpacity=1,this.feature={type:"Point",id:t.id,geometry:[],properties:{height:Vv(t)}},this.aabb=this._getLocalBounds(),this.state=null;}_getLocalBounds(){if(!this.node.meshes)return new Ju([1/0,1/0,1/0],[-1/0,-1/0,-1/0]);if(!this.aabb){let t=0;const e=new Ju([1/0,1/0,1/0],[-1/0,-1/0,-1/0]);for(const r of this.node.meshes)this.node.lightMeshIndex!==t&&(r.transformedAabb=Ju.applyTransformFast(r.aabb,this.node.globalMatrix),e.encapsulate(r.transformedAabb)),t++;this.aabb=e;}return this.aabb}}class Rv{constructor(t,e,r,n,i,s,o,a){this.id=r,this.layers=t,this.layerIds=this.layers.map((t=>t.fqid)),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.modelTraits|=Kf.CoordinateSpaceTile,this.uploaded=!1,this.hasPattern=!1,n&&(this.modelTraits|=Kf.HasMapboxMeshFeatures),i&&(this.modelTraits|=Kf.HasMeshoptCompression),this.zoom=-1,this.terrainExaggeration=1,this.projection={name:"mercator"},this.replacementUpdateTime=0,this.elevationReadFromZ=255,this.brightness=s,this.worldview=a,this.dirty=!0,this.needsUpload=!1,this.filter=null,this.nodesInfo=[];for(const t of e)this.nodesInfo.push(new Dv(t)),Fv(t,o.featureIndexArray.length,o.grid),o.featureIndexArray.emplaceBack(this.nodesInfo.length-1,0,o.bucketLayerIDs.length-1,0);this.states={},this.hasAppearances=null;}updateFootprints(t,e){for(const r of this.getNodesInfo()){const n=r.node;n.footprint&&e.push({footprint:n.footprint,id:t});}}updateAppearances(t,e,r,n){}update(t){const e=0!==Object.keys(t).length;if(e&&!this.stateDependentLayers.length)return;const r=e?this.stateDependentLayers:this.layers;if(!Mt(t,this.states))for(const e of r)this.evaluate(e,t);this.states=structuredClone(t);}populate(){console.log("populate 3D model bucket");}uploadPending(){return !this.uploaded||this.needsUpload}upload(t){if(!this.needsUpload)return;const e=this.getNodesInfo();for(const r of e){const e=r.node;this.uploaded?this.updatePbrBuffer(e):rm(e,t,!0);}for(const t of e)nm(t.node);this.uploaded=!0,this.needsUpload=!1;}updatePbrBuffer(t){let e=!1;if(!t.meshes)return e;for(const r of t.meshes)r.pbrBuffer&&(r.pbrBuffer.updateData(r.featureArray),e=!0);return e}needsReEvaluation(t,e,r){const n=t.transform.projectionOptions,i=t.style.getBrightness(),s=this.brightness!==i;if(!this.uploaded||this.dirty||n.name!==this.projection.name||Lv(r.paint.get("model-color").value,s)||Lv(r.paint.get("model-color-mix-intensity").value,s)||Lv(r.paint.get("model-roughness").value,s)||Lv(r.paint.get("model-emissive-strength").value,s)||Lv(r.paint.get("model-height-based-emissive-strength-multiplier").value,s)){this.projection=n,this.brightness=i;const t=this.getNodesInfo();for(const e of t)e.state=null;return !0}return !1}evaluateTransform(t,e){if(t.transform.zoom===this.zoom)return;this.zoom=t.transform.zoom;const r=this.getNodesInfo(),n=this.id.canonical;for(const t of r){const r=t.feature;t.evaluatedTranslation=e.paint.get("model-translation").evaluate(r,{},n),t.evaluatedScale=e.paint.get("model-scale").evaluate(r,{},n);}}evaluate(t,e){const r=this.getNodesInfo();for(const n of r){if(!n.node.meshes)continue;const r=n.feature,i=e&&e[r.id];if(Mt(i,n.state))continue;n.state=structuredClone(i);const s=n.node.meshes&&n.node.meshes[0].featureData,o=n.evaluatedColor[2],a=n.evaluatedRMEA[2],l=this.id.canonical;if(n.hasTranslucentParts=!1,s){for(let e=0;e<Cv.length;e++){const s=Cv[e];s.length&&(r.properties.part=s);const o=t.paint.get("model-color").evaluate(r,i,l).toPremultipliedRenderColor(null),a=t.paint.get("model-color-mix-intensity").evaluate(r,i,l);n.evaluatedColor[e]=[o.r,o.g,o.b,a],n.evaluatedRMEA[e][0]=t.paint.get("model-roughness").evaluate(r,i,l),n.evaluatedRMEA[e][2]=t.paint.get("model-emissive-strength").evaluate(r,i,l),n.evaluatedRMEA[e][3]=o.a,n.emissionHeightBasedParams[e]=t.paint.get("model-height-based-emissive-strength-multiplier").evaluate(r,i,l),!n.hasTranslucentParts&&o.a<1&&(n.hasTranslucentParts=!0);}delete r.properties.part,Uv(n,o!==n.evaluatedColor[2]||a!==n.evaluatedRMEA[2],this.modelTraits);}else n.evaluatedRMEA[0][2]=t.paint.get("model-emissive-strength").evaluate(r,i,l);n.evaluatedTranslation=t.paint.get("model-translation").evaluate(r,i,l),n.evaluatedScale=t.paint.get("model-scale").evaluate(r,i,l),this.updatePbrBuffer(n.node)||(this.needsUpload=!0);}this.dirty=!1;}elevationUpdate(t,e,r,n){const i=t.findDEMTileFor(r);if(i&&(i.tileID.canonical!==this.terrainTile||e!==this.terrainExaggeration)){if(i.dem&&i.tileID.overscaledZ!==this.elevationReadFromZ){this.elevationReadFromZ=i.tileID.overscaledZ;const e=zv.create(t,r,i);if(!e)return;this.modelTraits&Kf.HasMapboxMeshFeatures&&this.updateDEM(t,e,r,n);for(const t of this.getNodesInfo()){const r=t.node;if(!r.footprint||!r.footprint.vertices||!r.footprint.vertices.length)continue;const n=r.footprint.vertices;let i=e.getElevationAt(n[0].x,n[0].y,!0,!0);for(let t=1;t<n.length;t++)i=Math.min(i,e.getElevationAt(n[t].x,n[t].y,!0,!0));r.elevation=i;}}this.terrainTile=i.tileID.canonical,this.terrainExaggeration=e;}}updateDEM(t,e,r,n){let i=e._dem._modifiedForSources[n];if(void 0===i&&(e._dem._modifiedForSources[n]=[],i=e._dem._modifiedForSources[n]),i.includes(r.canonical))return;const s=e._dem.dim;i.push(r.canonical);let o=!1;for(const t of this.getNodesInfo()){const r=t.node;if(!r.footprint||!r.footprint.grid)continue;const n=r.footprint.grid,i=e.tileCoordToPixel(n.min.x,n.min.y),a=e.tileCoordToPixel(n.max.x,n.max.y),l=Math.min(Math.min(s-a.y,i.x),Math.min(i.y,s-a.x));if(l<0)continue;const u=Ft(l,2,5);let c=Math.max(0,i.x-u),h=Math.max(0,i.y-u),p=Math.min(a.x+u,s-1),d=Math.min(a.y+u,s-1);for(let t=h;t<=d;++t)for(let e=c;e<=p;++e)Ev[t*s+e]=255;let f=0,m=0;for(let t=0;t<n.cellsY;++t)for(let r=0;r<n.cellsX;++r){if(!n.cells[t*n.cellsX+r])continue;const i=e.tileCoordToPixel(n.min.x+r/n.xScale,n.min.y+t/n.yScale),o=e.tileCoordToPixel(n.min.x+(r+1)/n.xScale,n.min.y+(t+1)/n.yScale);for(let t=i.y;t<=Math.min(o.y+1,s-1);++t)for(let r=i.x;r<=Math.min(o.x+1,s-1);++r)255===Ev[t*s+r]&&(Ev[t*s+r]=0,f+=e.getElevationAtPixel(r,t),m++);}const y=f/m;c=Math.max(1,i.x-u),h=Math.max(1,i.y-u),p=Math.min(a.x+u,s-2),d=Math.min(a.y+u,s-2),o=!0;for(let t=h;t<=d;++t)for(let r=c;r<=p;++r)0===Ev[t*s+r]&&(Tv[t*s+r]=e._dem.set(r,t,y));for(let t=1;t<u;++t){c=Math.max(1,i.x-t),h=Math.max(1,i.y-t),p=Math.min(a.x+t,s-2),d=Math.min(a.y+t,s-2);for(let r=h;r<=d;++r)for(let n=c;n<=p;++n){const i=r*s+n;if(255===Ev[i]){let o=0,a=0,l=-1,c=-1;for(let e=-1;e<=1;++e)for(let i=-1;i<=1;++i){const u=(r+e)*s+n+i;if(Ev[u]>=t)continue;const h=Tv[u],p=Math.abs(h);p>a&&(o=h,a=p,l=i,c=e);}if(a>.1){const s=1-(t+.5*Math.abs(l*c))/u;let a=e._dem.get(n,r)+o*s;const h=e._dem.get(n+l,r+c),p=e._dem.get(n-l,r-c,!0);(a-h)*(a-p)>0&&(a=(h+p)/2),Tv[i]=e._dem.set(n,r,a),Ev[i]=t;}}}}}o&&(e._demTile.needsDEMTextureUpload=!0,e._dem._timestamp=ye.now());}setFilter(t){this.filter=t?No(t):null;}getNodesInfo(){return this.filter?this.nodesInfo.filter((t=>this.filter.filter(new Io(this.id.overscaledZ,{worldview:this.worldview}),t.feature,this.id.canonical))):this.nodesInfo}destroy(){const t=this.getNodesInfo();for(const e of t)nm(e.node),im(e.node);}isEmpty(){return !this.nodesInfo.length}updateReplacement(t,e){if(e.updateTime===this.replacementUpdateTime)return;this.replacementUpdateTime=e.updateTime;const r=e.getReplacementRegionsForTile(t.toUnwrapped());for(const t of this.getNodesInfo()){const e=t.node.footprint;t.hiddenByReplacement=!!e&&!r.find((t=>t.footprint===e));}}getHeightAtTileCoord(t,e){const r=[],n=[0,0,0],i=u([]);for(const s of this.getNodesInfo()){const o=s.node.meshes[0],a=o.transformedAabb;if(t<a.min[0]||e<a.min[1]||t>a.max[0]||e>a.max[1])continue;if(!0===s.node.hidden)return {height:1/0,maxHeight:s.feature.properties.height,hidden:!1,verticalScale:s.evaluatedScale[2]};c(i,s.node.globalMatrix),n[0]=t,n[1]=e,j(n,n,i);const l=(n[0]-o.aabb.min[0])/(o.aabb.max[0]-o.aabb.min[0])*Yf|0,u=Math.min(63,(n[1]-o.aabb.min[1])/(o.aabb.max[1]-o.aabb.min[1])*Yf|0)*Yf+Math.min(63,l),h=o.heightmap[u];if(!(h<0&&s.node.footprint)){if(s.hiddenByReplacement)return;return {height:h,maxHeight:s.feature.properties.height,hidden:!1,verticalScale:s.evaluatedScale[2]}}if(s.node.footprint.grid.query(new It(t,e),new It(t,e),r),r.length>0)return {height:void 0,maxHeight:s.feature.properties.height,hidden:s.hiddenByReplacement,verticalScale:s.evaluatedScale[2]}}}}function Lv(t,e){return t instanceof $s&&!t.isLightConstant&&e}function Ov(t,e,r,n,i,s,o,a){let l=(61440&e|(61440&e)>>4)>>8,u=(3840&e|(3840&e)>>4)>>4,c=240&e|(240&e)>>4;r[3]>0&&(l=pr(l,255*r[0],r[3]),u=pr(u,255*r[1],r[3]),c=pr(c,255*r[2],r[3]));const h=l<<8|u,p=c<<8|Math.floor(255*n[3]),d=function(t){const e=Ft(t,0,2);return Math.min(Math.round(.5*e*255),255)}(n[2])<<8|15*n[0]<<4|15*n[1],f=Ft(i[0],0,1),m=Ft(i[1],0,1),y=Ft(i[2],0,1),g=Ft(i[3],0,1);let x,v,b,w;if(f!==m&&o!==s&&m!==f){const t=o-s;v=1/(t*(m-f)),b=-(s+t*f)/(t*(m-f));const e=Ft(i[4],-1,1);w=Math.pow(10,e),x=255*y<<8|255*g;}else x=65535,v=0,b=1,w=1;if(t.emplaceBack(h,p,d,x,v,b,w),a){const t=a.length;a.clear();for(let e=0;e<t;e++)a.emplaceBack(h,p,d,x,v,b,w);}}function Uv(t,e,r){const n=t.node;let i=0;const s=r&Kf.HasMeshoptCompression;for(const r of n.meshes){if(n.lights&&n.lightMeshIndex===i)continue;if(!r.featureData)continue;r.featureArray=new Ha,r.featureArray.reserve(r.featureData.length);let o=e;for(const e of r.featureData){const i=s?65535&e:e>>16&65535,a=s?e>>16&65535:65535&e,l=(15&a)<8?15&a:0,u=t.evaluatedRMEA[l],c=t.evaluatedColor[l],h=t.emissionHeightBasedParams[l];let p;if(o&&2===l&&n.lights&&(p=new Ha,p.resize(10*n.lights.length)),Ov(r.featureArray,i,c,u,h,r.aabb.min[2],r.aabb.max[2],p),p&&o){o=!1;const t=n.meshes[n.lightMeshIndex];t.featureArray=p,t.featureArray._trim();}}r.featureArray._trim(),i++;}}Qs(Rv,"Tiled3dModelBucket",{omit:["layers"]}),Qs(Dv,"Tiled3dModelFeature");const Nv=["id","tile","layer","source","sourceLayer","state"];class jv{constructor(t,e,r,n,i){this.type="Feature",this._vectorTileFeature=t,this._z=e,this._x=r,this._y=n,this.properties=t?t.properties:{},this.id=i;}clone(){const t=new jv(this._vectorTileFeature,this._z,this._x,this._y,this.id);return this.state&&(t.state=Object.assign({},this.state)),this.layer&&(t.layer=Object.assign({},this.layer)),this.source&&(t.source=this.source),this.sourceLayer&&(t.sourceLayer=this.sourceLayer),t}get geometry(){return void 0===this._geometry&&this._vectorTileFeature&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._x,this._y,this._z).geometry),this._geometry}set geometry(t){this._geometry=t;}toJSON(){const t={type:"Feature",state:void 0,geometry:this.geometry,properties:this.properties};for(const e of Nv)void 0!==this[e]&&(t[e]=this[e]);return t}}class $v extends nr{constructor(t,e,r,n){super(),this.id=t,this.type="model",this.models=[],this._loaded=!1,this._options=e,this._modelsInfo=new Map;}load(){const t=[];for(const e in this._options.models){const r=this._options.models[e],n=this._modelsInfo.get(e);if(n){const t=n.model;t.position=null!=r.position?new iu(r.position[0],r.position[1]):new iu(0,0),t.orientation=null!=r.orientation?r.orientation:[0,0,0],n.modelSpec=r,$v.applyModelSpecification(t,r),t.computeBoundsAndApplyParent(),this.models.push(t);}else {const n=kf(this.map._requestManager.transformRequest(r.uri,Ce.Model).url).then((t=>{if(!t)return;const n=pm(t),i=new Qf(e,r.uri,r.position,r.orientation,n);$v.applyModelSpecification(i,r),i.computeBoundsAndApplyParent(),this.models.push(i),this._modelsInfo.set(e,{modelSpec:r,model:i});})).catch((t=>{this.fire(new tr(new Error(`Could not load model ${e} from ${r.uri}: ${t.message}`)));}));t.push(n);}}Promise.allSettled(t).then((()=>{this._loaded=!0,this.fire(new Qe("data",{dataType:"source",sourceDataType:"metadata"}));})).catch((t=>{this._loaded=!0,this.fire(new tr(new Error(`Could not load models: ${t.message}`)));}));}static applyModelSpecification(t,e){e.nodeOverrides&&$v.convertNodeOverrides(t,e.nodeOverrides),e.materialOverrides&&$v.convertMaterialOverrides(t,e.materialOverrides),e.nodeOverrideNames&&(t.nodeOverrideNames=[...e.nodeOverrideNames]),e.materialOverrideNames&&(t.materialOverrideNames=[...e.materialOverrideNames]),e.featureProperties&&(t.featureProperties=e.featureProperties);}static convertNodeOverrides(t,e){if(Array.isArray(e)&&e.every((t=>"string"==typeof t))){t.nodeOverrideNames=[];for(const r of e)t.nodeOverrideNames.push(r);}else Object.entries(e).forEach((([e,r])=>{const n={orientation:[0,0,0]};if(r.hasOwnProperty("orientation")){const t=r.orientation;t&&(n.orientation=t);}t.nodeOverrides.set(e,n);}));}static convertMaterialOverrides(t,e){if(Array.isArray(e)&&e.every((t=>"string"==typeof t))){t.materialOverrideNames=[];for(const r of e)t.materialOverrideNames.push(r);}else Object.entries(e).forEach((([e,r])=>{const n={color:new lr(1,1,1),colorMix:0,emissionStrength:0,opacity:1},i=r["model-color"];void 0!==i&&(n.color.r=i[0],n.color.g=i[1],n.color.b=i[2]);const s=r["model-color-mix-intensity"];void 0!==s&&(n.colorMix=s);const o=r["model-emissive-strength"];void 0!==o&&(n.emissionStrength=o);const a=r["model-opacity"];void 0!==a&&(n.opacity=a),t.materialOverrides.set(e,n);}));}onAdd(t){this.map=t,this.load();}hasTransition(){return !1}loaded(){return this._loaded}getModels(){return this.models}loadTile(t,e){}serialize(){return this._options}setProperty(t,e){return !1}reload(){const t=ta(this.id,this.scope);this.map.style.clearSource(t),this.models=[],this._modelsInfo.clear(),this._loaded=!1,this.load();}setModels(t){this.models=[];const e=new Map;for(const r in t){const n=t[r];if(this._modelsInfo.has(r)){const t=this._modelsInfo.get(r);t&&t.modelSpec.uri===n.uri&&e.set(r,t);}}this._modelsInfo=e,this._options.models=t,this._loaded=!1,this.load();}}function Gv(t,e,r,n){const i=1<<t.z;e.lat=du((n/Un+t.y)/i),e.lng=pu((r/Un+t.x)/i);}function qv(t,e,r,n){const i=t.getNodesInfo()[e];if(!i||i.hiddenByReplacement||!i.node.meshes)return;let s=Number.MAX_VALUE;const o=i.node,a=r.tile,l=n.calculatePosMatrix(a.tileID.toUnwrapped(),n.worldSize),u=i.evaluatedScale;let c=0;n.elevation&&o.elevation&&(c=o.elevation*n.elevation.exaggeration()),p(l,l,[(o.anchor?o.anchor[0]:0)*(u[0]-1),(o.anchor?o.anchor[1]:0)*(u[1]-1),c]),d(l,l,u);const f=r.queryGeometry,m=f.isPointQuery()?f.screenBounds:f.screenGeometry,y=function(t){const e=h([],l,t.globalMatrix);h(e,n.expandedFarZProjMatrix,e);for(let r=0;r<t.meshes.length;++r){const i=t.meshes[r];if(r===t.lightMeshIndex)continue;const o=Wf(m,n,e,i.aabb);null!=o&&(s=Math.min(o,s));}if(t.children)for(const e of t.children)y(e);};if(y(o),s===Number.MAX_VALUE)return;const g=new iu(0,0);return Gv(a.tileID.canonical,g,i.node.anchor[0],i.node.anchor[1]),{intersectionZ:s,position:g,feature:i.feature}}const Hv={circle:class extends oa{constructor(t,e,r,n){super(t,{layout:Ic||(Ic=new Do({"circle-sort-key":new Fo(Ro.layout_circle["circle-sort-key"]),"circle-elevation-reference":new Vo(Ro.layout_circle["circle-elevation-reference"]),visibility:new Vo(Ro.layout_circle.visibility)})),paint:Mc||(Mc=new Do({"circle-radius":new Fo(Ro.paint_circle["circle-radius"]),"circle-color":new Fo(Ro.paint_circle["circle-color"]),"circle-blur":new Fo(Ro.paint_circle["circle-blur"]),"circle-opacity":new Fo(Ro.paint_circle["circle-opacity"]),"circle-translate":new Vo(Ro.paint_circle["circle-translate"]),"circle-translate-anchor":new Vo(Ro.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new Vo(Ro.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new Vo(Ro.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new Fo(Ro.paint_circle["circle-stroke-width"]),"circle-stroke-color":new Fo(Ro.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new Fo(Ro.paint_circle["circle-stroke-opacity"]),"circle-emissive-strength":new Vo(Ro.paint_circle["circle-emissive-strength"]),"circle-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"}),"circle-stroke-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n);}createBucket(t){return new nc(t)}queryRadius(t){const e=t;return bc("circle-radius",this,e)+bc("circle-stroke-width",this,e)+wc(this.paint.get("circle-translate"))}queryIntersectsFeature(t,e,r,n,i,s,o,a){const l=Ac(this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),u=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r);return uh(t,n,s,o,a,"map"===this.paint.get("circle-pitch-alignment"),"map"===this.paint.get("circle-pitch-scale"),l,u)}getProgramIds(){return ["circle"]}getDefaultProgramParams(t,e,r){const n=lh(this);return {config:new Ol(this,{zoom:e,lut:r}),defines:n,overrideFog:!1}}is3D(t){return !t&&!!this.layout&&"none"!==this.layout.get("circle-elevation-reference")}hasElevation(){return this.layout&&"none"!==this.layout.get("circle-elevation-reference")}},heatmap:class extends oa{createBucket(t){return new fh(t)}constructor(t,e,r,n){super(t,{layout:mh||(mh=new Do({visibility:new Vo(Ro.layout_heatmap.visibility)})),paint:yh||(yh=new Do({"heatmap-radius":new Fo(Ro.paint_heatmap["heatmap-radius"]),"heatmap-weight":new Fo(Ro.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new Vo(Ro.paint_heatmap["heatmap-intensity"]),"heatmap-color":new Co(Ro.paint_heatmap["heatmap-color"]),"heatmap-opacity":new Vo(Ro.paint_heatmap["heatmap-opacity"]),"heatmap-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp();}_updateColorRamp(){this.colorRamp=Mh({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null;}resize(){this.heatmapFbo&&(this.heatmapFbo.destroy(),this.heatmapFbo=null);}_clear(){this.heatmapFbo&&(this.heatmapFbo.destroy(),this.heatmapFbo=null),this.colorRampTexture&&(this.colorRampTexture.destroy(),this.colorRampTexture=null);}queryRadius(t){return bc("heatmap-radius",this,t)}queryIntersectsFeature(t,e,r,n,i,s,o,a){const l=this.paint.get("heatmap-radius").evaluate(e,r);return uh(t,n,s,o,a,!0,!0,new It(0,0),l)}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}getProgramIds(){return ["heatmap","heatmapTexture"]}getDefaultProgramParams(t,e,r){return "heatmap"===t?{config:new Ol(this,{zoom:e,lut:r}),overrideFog:!1}:{}}},hillshade:class extends oa{constructor(t,e,r,n){super(t,{layout:gh||(gh=new Do({visibility:new Vo(Ro.layout_hillshade.visibility)})),paint:xh||(xh=new Do({"hillshade-illumination-direction":new Vo(Ro.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-anchor":new Vo(Ro.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new Vo(Ro.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new Vo(Ro.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new Vo(Ro.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new Vo(Ro.paint_hillshade["hillshade-accent-color"]),"hillshade-emissive-strength":new Vo(Ro.paint_hillshade["hillshade-emissive-strength"]),"hillshade-shadow-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"}),"hillshade-highlight-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"}),"hillshade-accent-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n);}shouldRedrape(){return this.hasOffscreenPass()&&"viewport"===this.paint.get("hillshade-illumination-anchor")}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}getProgramIds(){return ["hillshade","hillshadePrepare"]}getDefaultProgramParams(t,e,r){return {overrideFog:!1}}},fill:class extends oa{constructor(t,e,r,n){super(t,{layout:wp||(wp=new Do({"fill-sort-key":new Fo(Ro.layout_fill["fill-sort-key"]),visibility:new Vo(Ro.layout_fill.visibility),"fill-elevation-reference":new Vo(Ro.layout_fill["fill-elevation-reference"]),"fill-construct-bridge-guard-rail":new Fo(Ro.layout_fill["fill-construct-bridge-guard-rail"])})),paint:_p||(_p=new Do({"fill-antialias":new Vo(Ro.paint_fill["fill-antialias"]),"fill-opacity":new Fo(Ro.paint_fill["fill-opacity"]),"fill-color":new Fo(Ro.paint_fill["fill-color"]),"fill-outline-color":new Fo(Ro.paint_fill["fill-outline-color"]),"fill-translate":new Vo(Ro.paint_fill["fill-translate"]),"fill-translate-anchor":new Vo(Ro.paint_fill["fill-translate-anchor"]),"fill-pattern":new Fo(Ro.paint_fill["fill-pattern"]),"fill-pattern-cross-fade":new Vo(Ro.paint_fill["fill-pattern-cross-fade"]),"fill-emissive-strength":new Vo(Ro.paint_fill["fill-emissive-strength"]),"fill-z-offset":new Fo(Ro.paint_fill["fill-z-offset"]),"fill-bridge-guard-rail-color":new Fo(Ro.paint_fill["fill-bridge-guard-rail-color"]),"fill-tunnel-structure-color":new Fo(Ro.paint_fill["fill-tunnel-structure-color"]),"fill-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"}),"fill-outline-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"}),"fill-bridge-guard-rail-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"}),"fill-tunnel-structure-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n);}getProgramIds(){const t=this.paint.get("fill-pattern"),e=t&&t.constantOr(1),r=[e?"fillPattern":"fill"];return this.paint.get("fill-antialias")&&r.push(e&&!this.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline"),r}getDefaultProgramParams(t,e,r){return {config:new Ol(this,{zoom:e,lut:r}),overrideFog:!1}}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"]);}createBucket(t){return new bp(t)}queryRadius(){return wc(this.paint.get("fill-translate"))}queryIntersectsFeature(t,e,r,n,i,s){return !t.queryGeometry.isAboveHorizon&&oc(_c(t.tilespaceGeometry,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),n)}isTileClipped(){return 0===this.paint.get("fill-z-offset").constantOr(1)}is3D(t){if(0!==this.paint.get("fill-z-offset").constantOr(1))return !0;const e=this.layout&&"none"!==this.layout.get("fill-elevation-reference");return null!=t?e&&!t:e}hasElevation(){return this.layout&&"none"!==this.layout.get("fill-elevation-reference")}hasShadowPass(){return this.layout&&"none"!==this.layout.get("fill-elevation-reference")}},"fill-extrusion":class extends oa{constructor(t,e,r,n){super(t,{layout:kd||(kd=new Do({visibility:new Vo(Ro["layout_fill-extrusion"].visibility),"fill-extrusion-edge-radius":new Vo(Ro["layout_fill-extrusion"]["fill-extrusion-edge-radius"])})),paint:Bd||(Bd=new Do({"fill-extrusion-opacity":new Vo(Ro["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new Fo(Ro["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new Vo(Ro["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new Vo(Ro["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new Fo(Ro["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-pattern-cross-fade":new Vo(Ro["paint_fill-extrusion"]["fill-extrusion-pattern-cross-fade"]),"fill-extrusion-height":new Fo(Ro["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new Fo(Ro["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-height-alignment":new Vo(Ro["paint_fill-extrusion"]["fill-extrusion-height-alignment"]),"fill-extrusion-base-alignment":new Vo(Ro["paint_fill-extrusion"]["fill-extrusion-base-alignment"]),"fill-extrusion-vertical-gradient":new Vo(Ro["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"]),"fill-extrusion-ambient-occlusion-intensity":new Vo(Ro["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-intensity"]),"fill-extrusion-ambient-occlusion-radius":new Vo(Ro["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-radius"]),"fill-extrusion-ambient-occlusion-wall-radius":new Vo(Ro["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-wall-radius"]),"fill-extrusion-ambient-occlusion-ground-radius":new Vo(Ro["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-ground-radius"]),"fill-extrusion-ambient-occlusion-ground-attenuation":new Vo(Ro["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-ground-attenuation"]),"fill-extrusion-flood-light-color":new Vo(Ro["paint_fill-extrusion"]["fill-extrusion-flood-light-color"]),"fill-extrusion-flood-light-intensity":new Vo(Ro["paint_fill-extrusion"]["fill-extrusion-flood-light-intensity"]),"fill-extrusion-flood-light-wall-radius":new Fo(Ro["paint_fill-extrusion"]["fill-extrusion-flood-light-wall-radius"]),"fill-extrusion-flood-light-ground-radius":new Fo(Ro["paint_fill-extrusion"]["fill-extrusion-flood-light-ground-radius"]),"fill-extrusion-flood-light-ground-attenuation":new Vo(Ro["paint_fill-extrusion"]["fill-extrusion-flood-light-ground-attenuation"]),"fill-extrusion-vertical-scale":new Vo(Ro["paint_fill-extrusion"]["fill-extrusion-vertical-scale"]),"fill-extrusion-rounded-roof":new Vo(Ro["paint_fill-extrusion"]["fill-extrusion-rounded-roof"]),"fill-extrusion-cutoff-fade-range":new Vo(Ro["paint_fill-extrusion"]["fill-extrusion-cutoff-fade-range"]),"fill-extrusion-emissive-strength":new Fo(Ro["paint_fill-extrusion"]["fill-extrusion-emissive-strength"]),"fill-extrusion-line-width":new Fo(Ro["paint_fill-extrusion"]["fill-extrusion-line-width"]),"fill-extrusion-cast-shadows":new Vo(Ro["paint_fill-extrusion"]["fill-extrusion-cast-shadows"]),"fill-extrusion-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"}),"fill-extrusion-flood-light-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._stats={numRenderedVerticesInShadowPass:0,numRenderedVerticesInTransparentPass:0};}createBucket(t){return new gd(t)}queryRadius(){return wc(this.paint.get("fill-extrusion-translate"))}is3D(t){return !0}hasShadowPass(){return this.paint.get("fill-extrusion-cast-shadows")}cutoffRange(){return this.paint.get("fill-extrusion-cutoff-fade-range")}canCastShadows(){return !0}getProgramIds(){return [this.paint.get("fill-extrusion-pattern").constantOr(1)?"fillExtrusionPattern":"fillExtrusion"]}queryIntersectsFeature(t,e,r,n,i,s,o,a,l){const u=Ac(this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),c=this.paint.get("fill-extrusion-height").evaluate(e,r),h=this.paint.get("fill-extrusion-base").evaluate(e,r),p=[0,0],d=a&&s.elevation,f=s.elevation?s.elevation.exaggeration():1,m=t.tile.getBucket(this);if(d&&m instanceof gd){const t=m.centroidVertexArray,e=l+1;e<t.length&&(p[0]=t.geta_centroid_pos0(e),p[1]=t.geta_centroid_pos1(e));}if(0===p[0]&&1===p[1])return !1;"globe"===s.projection.name&&(n=Sd([n],[new It(0,0),new It(Un,Un)],t.tileID.canonical).map((t=>t.polygon)).flat());const y=d?a:null,[g,x]=Ud(s,n,h,c,u,o,y,p,f,s.center.lat,t.tileID.canonical),v=t.queryGeometry;return Od(g,x,v.isPointQuery()?v.screenBounds:v.screenGeometry)}},building:class extends oa{constructor(t,e,r,n){super(t,{layout:Fm||(Fm=new Do({visibility:new Vo(Ro.layout_building.visibility),"building-facade":new Fo(Ro.layout_building["building-facade"]),"building-facade-floors":new Fo(Ro.layout_building["building-facade-floors"]),"building-facade-unit-width":new Fo(Ro.layout_building["building-facade-unit-width"]),"building-facade-window":new Fo(Ro.layout_building["building-facade-window"]),"building-roof-shape":new Fo(Ro.layout_building["building-roof-shape"]),"building-height":new Fo(Ro.layout_building["building-height"]),"building-base":new Fo(Ro.layout_building["building-base"]),"building-flood-light-wall-radius":new Fo(Ro.layout_building["building-flood-light-wall-radius"]),"building-flood-light-ground-radius":new Fo(Ro.layout_building["building-flood-light-ground-radius"]),"building-flip-roof-orientation":new Fo(Ro.layout_building["building-flip-roof-orientation"])})),paint:Cm||(Cm=new Do({"building-opacity":new Vo(Ro.paint_building["building-opacity"]),"building-ambient-occlusion-intensity":new Vo(Ro.paint_building["building-ambient-occlusion-intensity"]),"building-ambient-occlusion-ground-intensity":new Vo(Ro.paint_building["building-ambient-occlusion-ground-intensity"]),"building-ambient-occlusion-ground-radius":new Vo(Ro.paint_building["building-ambient-occlusion-ground-radius"]),"building-ambient-occlusion-ground-attenuation":new Vo(Ro.paint_building["building-ambient-occlusion-ground-attenuation"]),"building-vertical-scale":new Vo(Ro.paint_building["building-vertical-scale"]),"building-cast-shadows":new Vo(Ro.paint_building["building-cast-shadows"]),"building-color":new Fo(Ro.paint_building["building-color"]),"building-emissive-strength":new Fo(Ro.paint_building["building-emissive-strength"]),"building-facade-emissive-chance":new Vo(Ro.paint_building["building-facade-emissive-chance"]),"building-cutoff-fade-range":new Vo(Ro.paint_building["building-cutoff-fade-range"]),"building-flood-light-color":new Vo(Ro.paint_building["building-flood-light-color"]),"building-flood-light-intensity":new Vo(Ro.paint_building["building-flood-light-intensity"]),"building-flood-light-ground-attenuation":new Vo(Ro.paint_building["building-flood-light-ground-attenuation"]),"building-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"}),"building-flood-light-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._stats={numRenderedVerticesInShadowPass:0,numRenderedVerticesInTransparentPass:0};}createBucket(t){return new Tm(t)}cutoffRange(){return this.paint.get("building-cutoff-fade-range")}hasShadowPass(){return this.paint.get("building-cast-shadows")}hasLightBeamPass(){return !0}canCastShadows(){return !0}is3D(t){return !0}queryRadius(t){return 0}queryIntersectsFeature(t,e,r,n,i,s,o,a,l){let u=this.layout.get("building-height").evaluate(e,r);const c=this.layout.get("building-base").evaluate(e,r),h=t.tile.getBucket(this).getFootprint(e);if(h){if(0!==h.hiddenFlags)return !1;u=h.height;}const[p,d]=Ud(s,n,c,u,new It(0,0),o,null,[0,0],1,s.center.lat,t.tileID.canonical),f=t.queryGeometry;return Od(p,d,f.isPointQuery()?f.screenBounds:f.screenGeometry)}},line:class extends oa{constructor(t,e,r,n){const i=iy();super(t,i,e,r,n),i.layout&&(this.layout=new Eo(i.layout)),this.gradientVersion=0,this.hasElevatedBuckets=!1,this.hasNonElevatedBuckets=!1;}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this._transitionablePaint._values["line-gradient"].value.expression;this.stepInterpolant=t._styleExpression&&t._styleExpression.expression instanceof ki,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER;}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}widthExpression(){return this._transitionablePaint._values["line-width"].value.expression}emissiveStrengthExpression(){return this._transitionablePaint._values["line-emissive-strength"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=(()=>{if(oy)return oy;const t=iy();return oy=new sy(t.paint.properties["line-width"].specification),oy.useIntegerZoom=!0,oy})().possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t);}createBucket(t){return new Xm(t)}getProgramIds(){return [this.paint.get("line-pattern").constantOr(1)?"linePattern":"line"]}getDefaultProgramParams(t,e,r){const n=ey(this);return {config:new Ol(this,{zoom:e,lut:r}),defines:n,overrideFog:!1}}queryRadius(t){const e=t,r=ay(bc("line-width",this,e),bc("line-gap-width",this,e)),n=bc("line-offset",this,e);return r/2+Math.abs(n)+wc(this.paint.get("line-translate"))}queryIntersectsFeature(t,e,r,n,i,s){if(t.queryGeometry.isAboveHorizon)return !1;const o=_c(t.tilespaceGeometry,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),a=t.pixelToTileUnitsFactor/2*ay(this.paint.get("line-width").evaluate(e,r),this.paint.get("line-gap-width").evaluate(e,r)),l=this.paint.get("line-offset").evaluate(e,r);return l&&(n=function(t,e){const r=[],n=new It(0,0);for(let i=0;i<t.length;i++){const s=t[i],o=[];for(let t=0;t<s.length;t++){const r=s[t],i=s[t+1],a=0===t?n:r.sub(s[t-1])._unit()._perp(),l=t===s.length-1?n:i.sub(r)._unit()._perp(),u=a._add(l)._unit();u._mult(1/(u.x*l.x+u.y*l.y)),o.push(u._mult(e)._add(r));}r.push(o);}return r}(n,l*t.pixelToTileUnitsFactor)),function(t,e,r){for(let n=0;n<e.length;n++){const i=e[n];if(t.length>=3)for(let e=0;e<i.length;e++)if(mc(t,i[e]))return !0;if(ac(t,i,r))return !0}return !1}(o,n,a)}isTileClipped(){return this.hasNonElevatedBuckets}isDraped(t){return !this.hasElevatedBuckets||this.layout&&"hd-road-markup"===this.layout.get("line-elevation-reference")}hasElevation(){return this.layout&&"none"!==this.layout.get("line-elevation-reference")}},symbol:rv,background:class extends oa{constructor(t,e,r,n){super(t,{layout:nv||(nv=new Do({visibility:new Vo(Ro.layout_background.visibility)})),paint:iv||(iv=new Do({"background-pitch-alignment":new Vo(Ro.paint_background["background-pitch-alignment"]),"background-color":new Vo(Ro.paint_background["background-color"]),"background-pattern":new Vo(Ro.paint_background["background-pattern"]),"background-opacity":new Vo(Ro.paint_background["background-opacity"]),"background-emissive-strength":new Vo(Ro.paint_background["background-emissive-strength"]),"background-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n);}getProgramIds(){return [this.paint.get("background-pattern")?"backgroundPattern":"background"]}getDefaultProgramParams(t,e,r){return {overrideFog:!1}}is3D(t){return "viewport"===this.paint.get("background-pitch-alignment")}},raster:dv,"raster-particle":vv,sky:class extends oa{constructor(t,e,r,n){super(t,{layout:yv||(yv=new Do({visibility:new Vo(Ro.layout_sky.visibility)})),paint:gv||(gv=new Do({"sky-type":new Vo(Ro.paint_sky["sky-type"]),"sky-atmosphere-sun":new Vo(Ro.paint_sky["sky-atmosphere-sun"]),"sky-atmosphere-sun-intensity":new Vo(Ro.paint_sky["sky-atmosphere-sun-intensity"]),"sky-gradient-center":new Vo(Ro.paint_sky["sky-gradient-center"]),"sky-gradient-radius":new Vo(Ro.paint_sky["sky-gradient-radius"]),"sky-gradient":new Co(Ro.paint_sky["sky-gradient"]),"sky-atmosphere-halo-color":new Vo(Ro.paint_sky["sky-atmosphere-halo-color"]),"sky-atmosphere-color":new Vo(Ro.paint_sky["sky-atmosphere-color"]),"sky-opacity":new Vo(Ro.paint_sky["sky-opacity"]),"sky-gradient-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"}),"sky-atmosphere-halo-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"}),"sky-atmosphere-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._updateColorRamp();}_clear(){this.skyboxFbo&&(this.skyboxFbo.destroy(),this.skyboxFbo=null),this.colorRampTexture&&(this.colorRampTexture.destroy(),this.colorRampTexture=null),this._skyboxInvalidated=!0;}_handleSpecialPaintPropertyUpdate(t){"sky-gradient"===t?this._updateColorRamp():"sky-atmosphere-sun"!==t&&"sky-atmosphere-halo-color"!==t&&"sky-atmosphere-color"!==t&&"sky-atmosphere-sun-intensity"!==t||(this._skyboxInvalidated=!0);}_updateColorRamp(){this.colorRamp=Mh({expression:this._transitionablePaint._values["sky-gradient"].value.expression,evaluationKey:"skyRadialProgress"}),this.colorRampTexture&&(this.colorRampTexture.destroy(),this.colorRampTexture=null);}needsSkyboxCapture(t){if(this._skyboxInvalidated||!this.skyboxTexture||!this.skyboxGeometry)return !0;if(!this.paint.get("sky-atmosphere-sun")){const e=t.style.light.properties.get("position");return this._lightPosition.azimuthal!==e.azimuthal||this._lightPosition.polar!==e.polar}return !1}getCenter(t,e){if("atmosphere"===this.paint.get("sky-type")){const r=this.paint.get("sky-atmosphere-sun"),n=!r,i=t.style.light,s=i.properties.get("position");return n&&"viewport"===i.properties.get("anchor")&&Xt("The sun direction is attached to a light with viewport anchor, lighting may behave unexpectedly."),n?wv(s.azimuthal,90-s.polar,e):wv(r[0],90-r[1],e)}const r=this.paint.get("sky-gradient-center");return wv(r[0],90-r[1],e)}isSky(){return !0}markSkyboxValid(t){this._skyboxInvalidated=!1,this._lightPosition=t.style.light.properties.get("position");}hasOffscreenPass(){return !0}getProgramIds(){const t=this.paint.get("sky-type");return "atmosphere"===t?["skyboxCapture","skybox"]:"gradient"===t?["skyboxGradient"]:null}},slot:class extends oa{constructor(t,e,r,n){super(t,{paint:xv||(xv=new Do({}))},e,null);}},model:class extends oa{constructor(t,e,r,n){super(t,{layout:kv||(kv=new Do({visibility:new Vo(Ro.layout_model.visibility),"model-id":new Fo(Ro.layout_model["model-id"])})),paint:Bv||(Bv=new Do({"model-opacity":new Fo(Ro.paint_model["model-opacity"]),"model-rotation":new Fo(Ro.paint_model["model-rotation"]),"model-scale":new Fo(Ro.paint_model["model-scale"]),"model-translation":new Fo(Ro.paint_model["model-translation"]),"model-color":new Fo(Ro.paint_model["model-color"]),"model-color-mix-intensity":new Fo(Ro.paint_model["model-color-mix-intensity"]),"model-type":new Vo(Ro.paint_model["model-type"]),"model-cast-shadows":new Vo(Ro.paint_model["model-cast-shadows"]),"model-receive-shadows":new Vo(Ro.paint_model["model-receive-shadows"]),"model-ambient-occlusion-intensity":new Vo(Ro.paint_model["model-ambient-occlusion-intensity"]),"model-emissive-strength":new Fo(Ro.paint_model["model-emissive-strength"]),"model-roughness":new Fo(Ro.paint_model["model-roughness"]),"model-height-based-emissive-strength-multiplier":new Fo(Ro.paint_model["model-height-based-emissive-strength-multiplier"]),"model-cutoff-fade-range":new Vo(Ro.paint_model["model-cutoff-fade-range"]),"model-front-cutoff":new Vo(Ro.paint_model["model-front-cutoff"]),"model-elevation-reference":new Vo(Ro.paint_model["model-elevation-reference"]),"model-color-use-theme":new Fo({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this.layer=t,this._stats={numRenderedVerticesInShadowPass:0,numRenderedVerticesInTransparentPass:0};}createBucket(t){return new Pv(t)}getProgramIds(){return ["model"]}is3D(t){return !0}hasShadowPass(){return !0}canCastShadows(){return !0}hasLightBeamPass(){return !0}cutoffRange(){return this.paint.get("model-cutoff-fade-range")}queryRadius(t){return t instanceof Rv?Un-1:0}queryRenderedFeatures(t,e,r){const n=e.getSource();if(!(n&&n instanceof $v))return {};const i=n,s={};s[this.id]=[];const o=s[this.id];let a=0;for(const n of i.models){const i=e.getFeatureState(this.sourceLayer,n.id),s={type:"Unknown",id:n.id,properties:n.featureProperties},l=this.paint.get("model-rotation").evaluate(s,i),u=this.paint.get("model-scale").evaluate(s,i),c=this.paint.get("model-translation").evaluate(s,i),p=this.paint.get("model-elevation-reference");let d=[];Jf(d,n,r,n.position,l,u,c,"ground"===p,"ground"===p,!1),"globe"===r.projection.name&&(d=Zf(d,r));const f=h([],r.projMatrix,d),m=Wf(t.isPointQuery()?t.screenBounds:t.screenGeometry,r,f,n.aabb);if(null!=m){const t=new jv(void 0,0,0,0,n.id);t.layer=this.layer,t.properties=structuredClone(n.featureProperties),t.properties.layer=this.id,t.properties.uri=n.uri,t.properties.orientation=n.orientation,t.sourceLayer=this.sourceLayer,t.geometry={type:"Point",coordinates:[n.position.lng,n.position.lat]},t.state=i,t.source=this.source,o.push({featureIndex:a,feature:t,intersectionZ:m});}++a;}return s}queryIntersectsFeature(t,e,r,n,i,s){if(!this.modelManager)return !1;const o=this.modelManager,a=t.tile.getBucket(this);if(!(a&&a instanceof Pv))return !1;for(const r in a.instancesPerModel){const n=a.instancesPerModel[r],i=void 0!==e.id?e.id:e.properties&&e.properties.hasOwnProperty("id")?e.properties.id:void 0;if(n.idToFeaturesIndex.hasOwnProperty(i)){const e=n.features[n.idToFeaturesIndex[i]],l=o.getModel(r,this.scope);if(!l)return !1;let u=[];const c=new iu(0,0),p=a.canonical;let d=Number.MAX_VALUE;for(let r=0;r<e.instancedDataCount;++r){const i=16*(e.instancedDataOffset+r),o=n.instancedDataArray.float32,a=[o[i+4],o[i+5],o[i+6]];Gv(p,c,Math.floor(o[i]),Math.floor(o[i+1])),Jf(u,l,s,c,e.rotation,e.scale,a,!1,!1,!1),"globe"===s.projection.name&&(u=Zf(u,s));const f=h([],s.projMatrix,u),m=t.queryGeometry,y=Wf(m.isPointQuery()?m.screenBounds:m.screenGeometry,s,f,l.aabb);null!=y&&(d=Math.min(y,d));}return d!==Number.MAX_VALUE&&d}}return !1}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven()||"model-color"!==t&&"model-color-mix-intensity"!==t&&"model-rotation"!==t&&"model-scale"!==t&&"model-translation"!==t&&"model-emissive-strength"!==t)}_isPropertyZoomDependent(t){const e=this._transitionablePaint._values[t];return null!=e&&null!=e.value&&null!=e.value.expression&&e.value.expression instanceof Gs}isZoomDependent(){return this._isPropertyZoomDependent("model-scale")||this._isPropertyZoomDependent("model-rotation")||this._isPropertyZoomDependent("model-translation")}},clip:class extends oa{constructor(t,e,r,n){super(t,{layout:Ap||(Ap=new Do({"clip-layer-types":new Vo(Ro.layout_clip["clip-layer-types"]),"clip-layer-scope":new Vo(Ro.layout_clip["clip-layer-scope"])})),paint:Ip||(Ip=new Do({}))},e,r,n);}recalculate(t,e){super.recalculate(t,e);}createBucket(t){return new Pp(t)}is3D(t){return !0}}},Xv=new lr(0,0,0),Zv={PATH_RULE_NON_ZERO:1,PATH_RULE_EVEN_ODD:2},Wv={LINE_CAP_BUTT:1,LINE_CAP_ROUND:2,LINE_CAP_SQUARE:3},Yv={LINE_JOIN_MITER:1,LINE_JOIN_MITER_CLIP:2,LINE_JOIN_ROUND:3,LINE_JOIN_BEVEL:4},Kv={PAINT_ORDER_FILL_AND_STROKE:1},Jv={PATH_COMMAND_MOVE:1,PATH_COMMAND_LINE:2,PATH_COMMAND_QUAD:3,PATH_COMMAND_CUBIC:4,PATH_COMMAND_CLOSE:5},Qv={MASK_TYPE_LUMINANCE:1};function tb(t,e,r){1===t&&e.icons.push(function(t,e){return function(t){if(t.usvg_tree.height||(t.usvg_tree.height=t.usvg_tree.width),!t.metadata)return t;const{metadata:e}=t;if(e.content_area){const{content_area:r}=e;null==r.left&&(r.left=0),null==r.top&&(r.top=r.left),null==r.width&&(r.width=t.usvg_tree.width),null==r.height&&(r.height=r.width);}if(e.text_placeholder){const{text_placeholder:t}=e;null==t.top&&(t.top=t.left),null==t.height&&(t.height=t.width);}return e.stretch_x&&e.stretch_x.length&&eb(e,"x"),e.stretch_y&&e.stretch_y.length&&eb(e,"y"),t}(t.readFields(rb,{name:void 0},e))}(r,r.readVarint()+r.pos));}function eb(t,e){const r=[],n=t[`stretch_${e}`];let i=null;for(let t=0;t<n.length;t++)null===i?i=0===r.length?n[0]:r[r.length-1][1]+n[t]:(r.push([i,i+n[t]]),i=null);t[`stretch_${e}_areas`]=r;}function rb(t,e,r){1===t?e.name=r.readString():2===t?e.metadata=function(t,e){return t.readFields(nb,{stretch_x:null,stretch_y:null,stretch_x_areas:null,stretch_y_areas:null,variables:[]},e)}(r,r.readVarint()+r.pos):3===t&&(e.usvg_tree=function(t,e){return t.readFields(ab,{width:20,children:[],linear_gradients:[],radial_gradients:[],clip_paths:[],masks:[]},e)}(r,r.readVarint()+r.pos),e.data="usvg_tree");}function nb(t,e,r){1===t?e.stretch_x=r.readPackedVarint():2===t?e.stretch_y=r.readPackedVarint():3===t?e.content_area=ib(r,r.readVarint()+r.pos):4===t?e.variables.push(function(t,e){return t.readFields(ob,{name:void 0},e)}(r,r.readVarint()+r.pos)):5===t&&(e.text_placeholder=ib(r,r.readVarint()+r.pos));}function ib(t,e){return t.readFields(sb,{},e)}function sb(t,e,r){1===t?e.left=r.readVarint():2===t?e.width=r.readVarint():3===t?e.top=r.readVarint():4===t&&(e.height=r.readVarint());}function ob(t,e,r){1===t?e.name=r.readString():2===t&&(e.rgb_color=mb(r.readVarint()),e.value="rgb_color");}function ab(t,e,r){1===t?e.width=e.height=r.readVarint():2===t?e.height=r.readVarint():3===t?e.children.push(lb(r,r.readVarint()+r.pos)):4===t?e.linear_gradients.push(function(t,e){return t.readFields(gb,{spread_method:1,stops:[],x1:0,y1:0,x2:1,y2:0},e)}(r,r.readVarint()+r.pos)):5===t?e.radial_gradients.push(function(t,e){return t.readFields(bb,{spread_method:1,stops:[],cx:.5,cy:.5,r:.5,fx:.5,fy:.5,fr:0},e)}(r,r.readVarint()+r.pos)):7===t?e.clip_paths.push(function(t,e){return t.readFields(wb,{children:[]},e)}(r,r.readVarint()+r.pos)):8===t&&e.masks.push(function(t,e){const r=t.readFields(_b,{left:0,width:20,mask_type:Qv.MASK_TYPE_LUMINANCE,children:[]},e);return null==r.height&&(r.height=r.width),null==r.top&&(r.top=r.left),r}(r,r.readVarint()+r.pos));}function lb(t,e){return t.readFields(ub,{},e)}function ub(t,e,r){1===t?(e.group=function(t,e){return t.readFields(cb,{opacity:255,children:[]},e)}(r,r.readVarint()+r.pos),e.node="group"):2===t&&(e.path=function(t,e){return t.readFields(db,{paint_order:1,commands:[],step:1,diffs:[],rule:Zv.PATH_RULE_NON_ZERO},e)}(r,r.readVarint()+r.pos),e.node="path");}function cb(t,e,r){1===t?e.transform=hb(r,r.readVarint()+r.pos):2===t?e.opacity=r.readVarint():5===t?e.clip_path_idx=r.readVarint():6===t?e.mask_idx=r.readVarint():7===t&&e.children.push(lb(r,r.readVarint()+r.pos));}function hb(t,e){return t.readFields(pb,{sx:1,ky:0,kx:0,sy:1,tx:0,ty:0},e)}function pb(t,e,r){1===t?e.sx=r.readFloat():2===t?e.ky=r.readFloat():3===t?e.kx=r.readFloat():4===t?e.sy=r.readFloat():5===t?e.tx=r.readFloat():6===t&&(e.ty=r.readFloat());}function db(t,e,r){1===t?e.fill=function(t,e){return t.readFields(fb,{rgb_color:Xv,paint:"rgb_color",opacity:255},e)}(r,r.readVarint()+r.pos):2===t?e.stroke=function(t,e){return t.readFields(yb,{rgb_color:Xv,paint:"rgb_color",dasharray:[],dashoffset:0,miterlimit:4,opacity:255,width:1,linecap:1,linejoin:1},e)}(r,r.readVarint()+r.pos):3===t?e.paint_order=r.readVarint():5===t?r.readPackedVarint(e.commands):6===t?e.step=r.readFloat():7===t?r.readPackedSVarint(e.diffs):8===t&&(e.rule=r.readVarint());}function fb(t,e,r){1===t?(e.rgb_color=mb(r.readVarint()),e.paint="rgb_color"):2===t?(e.linear_gradient_idx=r.readVarint(),e.paint="linear_gradient_idx"):3===t?(e.radial_gradient_idx=r.readVarint(),e.paint="radial_gradient_idx"):5===t&&(e.opacity=r.readVarint());}function mb(t){return new lr((t>>16&255)/255,(t>>8&255)/255,(255&t)/255,1)}function yb(t,e,r){1===t?(e.rgb_color=mb(r.readVarint()),e.paint="rgb_color"):2===t?(e.linear_gradient_idx=r.readVarint(),e.paint="linear_gradient_idx"):3===t?(e.radial_gradient_idx=r.readVarint(),e.paint="radial_gradient_idx"):5===t?r.readPackedFloat(e.dasharray):6===t?e.dashoffset=r.readFloat():7===t?e.miterlimit=r.readFloat():8===t?e.opacity=r.readVarint():9===t?e.width=r.readFloat():10===t?e.linecap=r.readVarint():11===t&&(e.linejoin=r.readVarint());}function gb(t,e,r){1===t?e.transform=hb(r,r.readVarint()+r.pos):2===t?e.spread_method=r.readVarint():3===t?e.stops.push(xb(r,r.readVarint()+r.pos)):4===t?e.x1=r.readFloat():5===t?e.y1=r.readFloat():6===t?e.x2=r.readFloat():7===t&&(e.y2=r.readFloat());}function xb(t,e){return t.readFields(vb,{offset:0,opacity:255,rgb_color:Xv},e)}function vb(t,e,r){1===t?e.offset=r.readFloat():2===t?e.opacity=r.readVarint():3===t&&(e.rgb_color=mb(r.readVarint()));}function bb(t,e,r){1===t?e.transform=hb(r,r.readVarint()+r.pos):2===t?e.spread_method=r.readVarint():3===t?e.stops.push(xb(r,r.readVarint()+r.pos)):4===t?e.cx=r.readFloat():5===t?e.cy=r.readFloat():6===t?e.r=r.readFloat():7===t?e.fx=r.readFloat():8===t?e.fy=r.readFloat():9===t&&(e.fr=r.readFloat());}function wb(t,e,r){1===t?e.transform=hb(r,r.readVarint()+r.pos):2===t?e.clip_path_idx=r.readVarint():3===t&&e.children.push(lb(r,r.readVarint()+r.pos));}function _b(t,e,r){1===t?e.left=e.top=r.readFloat():2===t?e.width=e.height=r.readFloat():3===t?e.top=r.readFloat():4===t?e.height=r.readFloat():5===t?e.mask_type=r.readVarint():6===t?e.mask_idx=r.readVarint():7===t&&e.children.push(lb(r,r.readVarint()+r.pos));}class Ab{static calculate(t={},e=[]){const r=new Map,n=new Map;if(0===Object.keys(t).length)return r;e.forEach((t=>{n.set(t.name,t.rgb_color||new lr(0,0,0));}));for(const[e,i]of Object.entries(t))n.has(e)?r.set(n.get(e).toString(),i):console.warn(`Ignoring unknown image variable "${e}"`);return r}}function Ib(t,e=255,r){const n=e/255,i=t.toString(),s=r.has(i)?r.get(i).clone():t.clone();return s.a*=n,s.toString()}function Mb(t,e){if(!me()){const r=document.createElement("canvas");return r.width=t,r.height=e,r}return new OffscreenCanvas(t,e)}let Sb,Pb=null;function kb(t,e,r,n,i){for(const s of n.children)Bb(t,e,r,s,i);}function Bb(t,e,r,n,i){n.group?(t.save(),function(t,e,r,n,i){const s=null!=n.mask_idx?r.masks[n.mask_idx]:null,o=null!=n.clip_path_idx?r.clip_paths[n.clip_path_idx]:null;if(n.transform&&(e=Lb(n.transform).preMultiplySelf(e)),!function(t,e,r){return 255!==t.opacity||e||r}(n,null!=o,null!=s))return void kb(t,e,r,n,i);const a=Mb(t.canvas.width,t.canvas.height),l=a.getContext("2d");kb(l,e,r,n,i),o&&Db(l,e,r,o),s&&Rb(l,e,r,s,i),t.globalAlpha=n.opacity/255,t.drawImage(a,0,0);}(t,e,r,n.group,i),t.restore()):n.path&&(t.save(),function(t,e,r,n,i){t.setTransform(e),n.paint_order===Kv.PAINT_ORDER_FILL_AND_STROKE?(zb(t,r,n,i),Eb(t,r,n,i)):(Eb(t,r,n,i),zb(t,r,n,i));}(t,e,r,n.path,i),t.restore());}function zb(t,e,r,n){const i=r.fill;if(!i)return;const s=i.opacity/255;switch(t.save(),t.beginPath(),Ob(r,t),i.paint){case "rgb_color":t.fillStyle=Ib(i.rgb_color,i.opacity,n);break;case "linear_gradient_idx":{const r=e.linear_gradients[i.linear_gradient_idx];r.transform&&t.setTransform(Lb(r.transform).preMultiplySelf(t.getTransform())),t.fillStyle=Vb(t,r,s,n);break}case "radial_gradient_idx":{const r=e.radial_gradients[i.radial_gradient_idx];r.transform&&t.setTransform(Lb(r.transform).preMultiplySelf(t.getTransform())),t.fillStyle=Fb(t,r,s,n);}}t.fill(Tb(r)),t.restore();}function Tb(t){return t.rule===Zv.PATH_RULE_NON_ZERO?"nonzero":t.rule===Zv.PATH_RULE_EVEN_ODD?"evenodd":void 0}function Eb(t,e,r,n){const i=r.stroke;if(!i)return;const s=Ub(r);t.lineWidth=i.width,t.miterLimit=i.miterlimit,t.setLineDash(i.dasharray),t.lineDashOffset=i.dashoffset;const o=i.opacity/255;switch(i.paint){case "rgb_color":t.strokeStyle=Ib(i.rgb_color,i.opacity,n);break;case "linear_gradient_idx":t.strokeStyle=Vb(t,e.linear_gradients[i.linear_gradient_idx],o,n,!0);break;case "radial_gradient_idx":t.strokeStyle=Fb(t,e.radial_gradients[i.radial_gradient_idx],o,n,!0);}switch(i.linejoin){case Yv.LINE_JOIN_MITER_CLIP:case Yv.LINE_JOIN_MITER:t.lineJoin="miter";break;case Yv.LINE_JOIN_ROUND:t.lineJoin="round";break;case Yv.LINE_JOIN_BEVEL:t.lineJoin="bevel";}switch(i.linecap){case Wv.LINE_CAP_BUTT:t.lineCap="butt";break;case Wv.LINE_CAP_ROUND:t.lineCap="round";break;case Wv.LINE_CAP_SQUARE:t.lineCap="square";}t.stroke(s);}function Vb(t,e,r,n,i=!1){if(1===e.stops.length){const t=e.stops[0];return Ib(t.rgb_color,t.opacity*r,n)}const{x1:s,y1:o,x2:a,y2:l}=e;let u=new DOMPoint(s,o),c=new DOMPoint(a,l);if(i){const t=Lb(e.transform);u=t.transformPoint(u),c=t.transformPoint(c);}const h=t.createLinearGradient(u.x,u.y,c.x,c.y);for(const t of e.stops)h.addColorStop(t.offset,Ib(t.rgb_color,t.opacity*r,n));return h}function Fb(t,e,r,n,i=!1){if(1===e.stops.length){const t=e.stops[0];return Ib(t.rgb_color,t.opacity*r,n)}const s=Lb(e.transform),{fx:o,fy:a,fr:l,cx:u,cy:c,r:h}=e;let p=new DOMPoint(o,a),d=new DOMPoint(u,c),f=l,m=h;if(i){p=s.transformPoint(p),d=s.transformPoint(d);const t=(s.a+s.d)/2;f=l*t,m=e.r*t;}const y=t.createRadialGradient(p.x,p.y,f,d.x,d.y,m);for(const t of e.stops)y.addColorStop(t.offset,Ib(t.rgb_color,t.opacity*r,n));return y}function Cb(t,e,r,n){const i=n.transform?Lb(n.transform).preMultiplySelf(e):e,s=Mb(t.canvas.width,t.canvas.height),o=s.getContext("2d");for(const t of n.children)if(t.group)Cb(o,i,r,t.group);else if(t.path){const e=t.path,r=new Path2D;r.addPath(Ub(e),i),o.fill(r,Tb(e));}const a=null!=n.clip_path_idx?r.clip_paths[n.clip_path_idx]:null;a&&Db(o,i,r,a),t.globalCompositeOperation="source-over",t.drawImage(s,0,0);}function Db(t,e,r,n){const i=Mb(t.canvas.width,t.canvas.height);Cb(i.getContext("2d"),e,r,n),t.globalCompositeOperation="destination-in",t.drawImage(i,0,0);}function Rb(t,e,r,n,i){if(0===n.children.length)return;const s=null!=n.mask_idx?r.masks[n.mask_idx]:null;s&&Rb(t,e,r,s,i);const o=t.canvas.width,a=t.canvas.height,l=Mb(o,a),u=l.getContext("2d"),c=n.width,h=n.height,p=n.left,d=n.top,f=new Path2D,m=new Path2D;m.rect(p,d,c,h),f.addPath(m,e),u.clip(f);for(const t of n.children)Bb(u,e,r,t,i);const y=u.getImageData(0,0,o,a),g=y.data;if(n.mask_type===Qv.MASK_TYPE_LUMINANCE)for(let t=0;t<g.length;t+=4)g[t+3]=g[t+3]/255*(.2126*g[t]+.7152*g[t+1]+.0722*g[t+2]);u.putImageData(y,0,0),t.globalCompositeOperation="destination-in",t.drawImage(l,0,0);}function Lb(t){return t?new DOMMatrix([t.sx,t.ky,t.kx,t.sy,t.tx,t.ty]):new DOMMatrix}function Ob(t,e){const r=t.step;let n=t.diffs[0]*r,i=t.diffs[1]*r;e.moveTo(n,i);for(let s=0,o=2;s<t.commands.length;s++)switch(t.commands[s]){case Jv.PATH_COMMAND_MOVE:n+=t.diffs[o++]*r,i+=t.diffs[o++]*r,e.moveTo(n,i);break;case Jv.PATH_COMMAND_LINE:n+=t.diffs[o++]*r,i+=t.diffs[o++]*r,e.lineTo(n,i);break;case Jv.PATH_COMMAND_QUAD:{const s=n+t.diffs[o++]*r,a=i+t.diffs[o++]*r;n=s+t.diffs[o++]*r,i=a+t.diffs[o++]*r,e.quadraticCurveTo(s,a,n,i);break}case Jv.PATH_COMMAND_CUBIC:{const s=n+t.diffs[o++]*r,a=i+t.diffs[o++]*r,l=s+t.diffs[o++]*r,u=a+t.diffs[o++]*r;n=l+t.diffs[o++]*r,i=u+t.diffs[o++]*r,e.bezierCurveTo(s,a,l,u,n,i);break}case Jv.PATH_COMMAND_CLOSE:e.closePath();}return e}function Ub(t){return Ob(t,new Path2D)}class Nb{constructor(t){this.capacity=t,this.cache=new Map;}get(t){if(!this.cache.has(t))return;const e=this.cache.get(t);return this.cache.delete(t),this.cache.set(t,e),e}put(t,e){this.cache.has(t)?this.cache.delete(t):this.cache.size===this.capacity&&this.cache.delete(this.cache.keys().next().value),this.cache.set(t,e);}delete(t){this.cache.delete(t);}}Qs(Nb,"LRUCache");class jb{constructor(){this.cacheMap=new Map,this.cacheDependenciesMap=new Map;}static _getImage(t){return new Ah(t,t.data)}getFromCache(t,e,r){return this.cacheMap.has(r)||this.cacheMap.set(r,new Nb(150)),this.cacheMap.get(r).get(ta(t.toString(),e))}setInCache(t,e,r,n){this.cacheDependenciesMap.has(n)||this.cacheDependenciesMap.set(n,new Map),this.cacheMap.has(n)||this.cacheMap.set(n,new Nb(150));const i=this.cacheDependenciesMap.get(n),s=ta(t.id.toString(),r);i.get(s)||i.set(s,new Set);const o=this.cacheMap.get(n),a=t.toString();i.get(s).add(a),o.put(ta(t.toString(),r),e);}removeImagesFromCacheByIds(t,e,r=0){if(!this.cacheMap.has(r)||!this.cacheDependenciesMap.has(r))return;const n=this.cacheMap.get(r),i=this.cacheDependenciesMap.get(r);for(const r of t){const t=ta(r.toString(),e);if(i.has(t)){for(const e of i.get(t))n.delete(e);i.delete(t);}}}rasterize(t,e,r,n){const i=this.getFromCache(t,r,n);if(i)return i.clone();const s=function(t,e){const r=Ab.calculate(e.params,t.metadata?t.metadata.variables:[]),n=t.usvg_tree,i=n.width,s=n.height,o=Math.max(1,Math.round(i*e.sx)),a=Math.max(1,Math.round(s*e.sy)),l=new DOMMatrix([o/i,0,0,a/s,0,0]);return null===Pb&&(Pb=Mb(10,10),Sb=Pb.getContext("2d",{willReadFrequently:!0})),Pb.width=o,Pb.height=a,kb(Sb,l,n,n,r),Sb.getImageData(0,0,o,a)}(e.icon,t),o=jb._getImage(s);return this.setInCache(t,o,r,n),o.clone()}}class $b{constructor(t){this.size=t,this.minimums=[],this.maximums=[],this.leaves=[];}getElevation(t,e){const r=this.toIdx(t,e);return {min:this.minimums[r],max:this.maximums[r]}}isLeaf(t,e){return this.leaves[this.toIdx(t,e)]}toIdx(t,e){return e*this.size+t}}function Gb(t,e,r,n){let i=0,s=Number.MAX_VALUE;for(let o=0;o<3;o++)if(Math.abs(n[o])<1e-15){if(r[o]<t[o]||r[o]>e[o])return null}else {const a=1/n[o];let l=(t[o]-r[o])*a,u=(e[o]-r[o])*a;if(l>u){const t=l;l=u,u=t;}if(l>i&&(i=l),u<s&&(s=u),i>s)return null}return i}function qb(t,e,r,n,i,s,o,a,l,u,c){const h=n-t,p=i-e,d=s-r,f=o-t,m=a-e,y=l-r,g=c[1]*y-c[2]*m,x=c[2]*f-c[0]*y,v=c[0]*m-c[1]*f,b=h*g+p*x+d*v;if(Math.abs(b)<1e-15)return null;const w=1/b,_=u[0]-t,A=u[1]-e,I=u[2]-r,M=(_*g+A*x+I*v)*w;if(M<0||M>1)return null;const S=A*d-I*p,P=I*h-_*d,k=_*p-A*h,B=(c[0]*S+c[1]*P+c[2]*k)*w;return B<0||M+B>1?null:(f*S+m*P+y*k)*w}function Hb(t,e,r){return (t-e)/(r-e)}function Xb(t,e,r,n,i,s,o,a,l){const u=1<<r,c=s-n,h=o-i,p=(t+1)/u*c+n,d=(e+0)/u*h+i,f=(e+1)/u*h+i;a[0]=(t+0)/u*c+n,a[1]=d,l[0]=p,l[1]=f;}class Zb{constructor(t){if(this.maximums=[],this.minimums=[],this.leaves=[],this.childOffsets=[],this.nodeCount=0,this.dem=t,this._siblingOffset=[[0,0],[1,0],[0,1],[1,1]],!this.dem)return;const e=function(t){const e=Math.ceil(Math.log2(t.dim/8)),r=[];let n=Math.ceil(Math.pow(2,e));const i=1/n,s=(t,e,r,n,i)=>{const s=n?1:0,o=(t+1)*r-s,a=e*r,l=(e+1)*r-s;i[0]=t*r,i[1]=a,i[2]=o,i[3]=l;};let o=new $b(n);const a=[];for(let e=0;e<n*n;e++){s(e%n,Math.floor(e/n),i,!1,a);const r=Yb(a[0],a[1],t),l=Yb(a[2],a[1],t),u=Yb(a[2],a[3],t),c=Yb(a[0],a[3],t);o.minimums.push(Math.min(r,l,u,c)),o.maximums.push(Math.max(r,l,u,c)),o.leaves.push(1);}for(r.push(o),n/=2;n>=1;n/=2){const t=r[r.length-1];o=new $b(n);for(let e=0;e<n*n;e++){s(e%n,Math.floor(e/n),2,!0,a);const r=t.getElevation(a[0],a[1]),i=t.getElevation(a[2],a[1]),l=t.getElevation(a[2],a[3]),u=t.getElevation(a[0],a[3]),c=t.isLeaf(a[0],a[1]),h=t.isLeaf(a[2],a[1]),p=t.isLeaf(a[2],a[3]),d=t.isLeaf(a[0],a[3]),f=Math.min(r.min,i.min,l.min,u.min),m=Math.max(r.max,i.max,l.max,u.max),y=c&&h&&p&&d;o.maximums.push(m),o.minimums.push(f),o.leaves.push(m-f<=5&&y?1:0);}r.push(o);}return r}(this.dem),r=e.length-1,n=e[r];this._addNode(n.minimums[0],n.maximums[0],n.leaves[0]),this._construct(e,0,0,r,0);}raycastRoot(t,e,r,n,i,s,o=1){return Gb([t,e,-100],[r,n,this.maximums[0]*o],i,s)}raycast(t,e,r,n,i,s,o=1){if(!this.nodeCount)return null;const a=this.raycastRoot(t,e,r,n,i,s,o);if(null==a)return null;const l=[],u=[],c=[],h=[],p=[{idx:0,t:a,nodex:0,nodey:0,depth:0}];for(;p.length>0;){const{idx:a,t:d,nodex:f,nodey:m,depth:y}=p.pop();if(this.leaves[a]){Xb(f,m,y,t,e,r,n,c,h);const a=1<<y,l=(f+0)/a,u=(f+1)/a,p=(m+0)/a,g=(m+1)/a,x=Yb(l,p,this.dem)*o,v=Yb(u,p,this.dem)*o,b=Yb(u,g,this.dem)*o,w=Yb(l,g,this.dem)*o,_=qb(c[0],c[1],x,h[0],c[1],v,h[0],h[1],b,i,s),A=qb(h[0],h[1],b,c[0],h[1],w,c[0],c[1],x,i,s),I=Math.min(null!==_?_:Number.MAX_VALUE,null!==A?A:Number.MAX_VALUE);if(I!==Number.MAX_VALUE)return I;{const t=V([],i,s,d);if(Wb(x,v,w,b,Hb(t[0],c[0],h[0]),Hb(t[1],c[1],h[1]))>=t[2])return d}continue}let g=0;for(let p=0;p<this._siblingOffset.length;p++){Xb((f<<1)+this._siblingOffset[p][0],(m<<1)+this._siblingOffset[p][1],y+1,t,e,r,n,c,h),c[2]=-100,h[2]=this.maximums[this.childOffsets[a]+p]*o;const d=Gb(c,h,i,s);if(null!=d){const t=d;l[p]=t;let e=!1;for(let r=0;r<g&&!e;r++)t>=l[u[r]]&&(u.splice(r,0,p),e=!0);e||(u[g]=p),g++;}}for(let t=0;t<g;t++){const e=u[t];p.push({idx:this.childOffsets[a]+e,t:l[e],nodex:(f<<1)+this._siblingOffset[e][0],nodey:(m<<1)+this._siblingOffset[e][1],depth:y+1});}}return null}_addNode(t,e,r){return this.minimums.push(t),this.maximums.push(e),this.leaves.push(r),this.childOffsets.push(0),this.nodeCount++}_construct(t,e,r,n,i){if(1===t[n].isLeaf(e,r))return;this.childOffsets[i]||(this.childOffsets[i]=this.nodeCount);const s=n-1,o=t[s];let a=0,l=0;for(let t=0;t<this._siblingOffset.length;t++){const n=2*e+this._siblingOffset[t][0],i=2*r+this._siblingOffset[t][1],s=o.getElevation(n,i),u=o.isLeaf(n,i),c=this._addNode(s.min,s.max,u);u&&(a|=1<<t),l||(l=c);}for(let n=0;n<this._siblingOffset.length;n++)a&1<<n||this._construct(t,2*e+this._siblingOffset[n][0],2*r+this._siblingOffset[n][1],s,l+n);}}function Wb(t,e,r,n,i,s){return pr(pr(t,r,s),pr(e,n,s),i)}function Yb(t,e,r){const n=r.dim,i=Ft(t*n-.5,0,n-1),s=Ft(e*n-.5,0,n-1),o=Math.floor(i),a=Math.floor(s),l=Math.min(o+1,n-1),u=Math.min(a+1,n-1);return Wb(r.get(o,a),r.get(l,a),r.get(o,u),r.get(l,u),i-o,s-a)}const Kb={mapbox:[6553.6,25.6,.1,1e4],terrarium:[256,1,1/256,32768]};function Jb(t,e,r){return (256*t*256+256*e+r)/10-1e4}function Qb(t,e,r){return 256*t+e+r/256-32768}class tw{get tree(){return this._tree||this._buildQuadTree(),this._tree}constructor(t,e,r,n=!1){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&"mapbox"!==r&&"terrarium"!==r)return void Xt(`"${r}" is not a valid encoding type. Valid types include "mapbox" and "terrarium".`);this.stride=e.height;const i=this.dim=e.height-2,s=new Uint32Array(e.data.buffer);if(this.pixels=new Uint8Array(e.data.buffer),this.floatView=new Float32Array(e.data.buffer),this.borderReady=n,this._modifiedForSources={},!n){for(let t=0;t<i;t++)s[this._idx(-1,t)]=s[this._idx(0,t)],s[this._idx(i,t)]=s[this._idx(i-1,t)],s[this._idx(t,-1)]=s[this._idx(t,0)],s[this._idx(t,i)]=s[this._idx(t,i-1)];s[this._idx(-1,-1)]=s[this._idx(0,0)],s[this._idx(i,-1)]=s[this._idx(i-1,0)],s[this._idx(-1,i)]=s[this._idx(0,i-1)],s[this._idx(i,i)]=s[this._idx(i-1,i-1)];}const o="terrarium"===r?Qb:Jb;for(let t=0;t<s.length;++t){const e=4*t;this.floatView[t]=o(this.pixels[e],this.pixels[e+1],this.pixels[e+2]);}this._timestamp=ye.now();}_buildQuadTree(){this._tree=new Zb(this);}get(t,e,r=!1){r&&(t=Ft(t,-1,this.dim),e=Ft(e,-1,this.dim));const n=this._idx(t,e);return this.floatView[n]}set(t,e,r){const n=this._idx(t,e),i=this.floatView[n];return this.floatView[n]=r,r-i}static getUnpackVector(t){return Kb[t]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return (e+1)*this.stride+(t+1)}static pack(t,e){const r=[0,0,0,0],n=tw.getUnpackVector(e);let i=Math.floor((t+n[3])/n[2]);return r[2]=i%256,i=Math.floor(i/256),r[1]=i%256,i=Math.floor(i/256),r[0]=i,r}getPixels(){return new Ih({width:this.stride,height:this.stride},this.pixels)}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let n=e*this.dim,i=e*this.dim+this.dim,s=r*this.dim,o=r*this.dim+this.dim;switch(e){case -1:n=i-1;break;case 1:i=n+1;}switch(r){case -1:s=o-1;break;case 1:o=s+1;}const a=-e*this.dim,l=-r*this.dim;for(let e=s;e<o;e++)for(let r=n;r<i;r++){const n=4*this._idx(r,e),i=4*this._idx(r+a,e+l);this.pixels[n+0]=t.pixels[i+0],this.pixels[n+1]=t.pixels[i+1],this.pixels[n+2]=t.pixels[i+2],this.pixels[n+3]=t.pixels[i+3];}}onDeserialize(){this._tree&&(this._tree.dem=this);}}function ew(t,e,r){1===t?e.headerLength=r.readFixed32():2===t?e.x=r.readVarint():3===t?e.y=r.readVarint():4===t?e.z=r.readVarint():5===t&&e.layers.push(function(t,e){return t.readFields(ow,{version:0,name:"",units:"",tileSize:0,buffer:0,pixelFormat:0,dataIndex:[]},e)}(r,r.readVarint()+r.pos));}function rw(t,e,r){1===t?(e.delta_filter=function(t,e){return t.readFields(nw,{blockSize:0},e)}(r,r.readVarint()+r.pos),e.filter="delta_filter"):2===t?(r.readVarint(),e.filter="zigzag_filter"):3===t?(r.readVarint(),e.filter="bitshuffle_filter"):4===t&&(r.readVarint(),e.filter="byteshuffle_filter");}function nw(t,e,r){1===t&&(e.blockSize=r.readVarint());}function iw(t,e,r){1===t?(r.readVarint(),e.codec="gzip_data"):2===t?(r.readVarint(),e.codec="jpeg_image"):3===t?(r.readVarint(),e.codec="webp_image"):4===t&&(r.readVarint(),e.codec="png_image");}function sw(t,e,r){let n=0,i=0;1===t?e.firstByte=r.readFixed64():2===t?e.lastByte=r.readFixed64():3===t?e.filters.push(function(t,e){return t.readFields(rw,{},e)}(r,r.readVarint()+r.pos)):4===t?e.codec=function(t,e){return t.readFields(iw,{},e)}(r,r.readVarint()+r.pos):5===t?i=r.readFloat():6===t?n=r.readFloat():7===t?e.bands.push(r.readString()):8===t?e.offset=r.readDouble():9===t&&(e.scale=r.readDouble()),0===e.offset&&(e.offset=i),0===e.scale&&(e.scale=n);}function ow(t,e,r){1===t?e.version=r.readVarint():2===t?e.name=r.readString():3===t?e.units=r.readString():4===t?e.tileSize=r.readVarint():5===t?e.buffer=r.readVarint():6===t?e.pixelFormat=r.readVarint():7===t&&e.dataIndex.push(function(t,e){return t.readFields(sw,{firstByte:0,lastByte:0,filters:[],codec:null,offset:0,scale:0,bands:[]},e)}(r,r.readVarint()+r.pos));}function aw(t,e,r){if(2===t)!function(t,e,r){t.readFields(lw,r,e);}(r,r.readVarint()+r.pos,e);else if(3===t)throw new Error("Not implemented")}function lw(t,e,r){if(1===t){let t=0;const n=r.readVarint()+r.pos;for(;r.pos<n;)e[t++]=r.readVarint();}}function uw(t,e){if(4!==e.length)throw new Error(`Expected data of dimension 4 but got ${e.length}.`);let r=e[3];for(let n=2;n>=1;n--){const i=1===n?1:0,s=2===n?1:0;for(let n=0;n<e[0];n++){const o=e[1]*n;for(let n=i;n<e[1];n++){const i=e[2]*(n+o);for(let n=s;n<e[2];n++){const s=e[3]*(n+i);for(let n=0;n<e[3];n++){const e=s+n;t[e]+=t[e-r];}}}}r*=e[n];}return t}function cw(t){for(let e=0,r=t.length;e<r;e++)t[e]=t[e]>>>1^-(1&t[e]);return t}function hw(t,e){switch(e){case "uint32":return t;case "uint16":for(let e=0;e<t.length;e+=2){const r=t[e],n=t[e+1];t[e]=(240&r)>>4|(61440&r)>>8|(240&n)<<4|61440&n,t[e+1]=15&r|(3840&r)>>4|(15&n)<<8|(3840&n)<<4;}return t;case "uint8":for(let e=0;e<t.length;e+=4){const r=t[e],n=t[e+1],i=t[e+2],s=t[e+3];t[e+0]=(192&r)>>6|(192&n)>>4|(192&i)>>2|192&s,t[e+1]=(48&r)>>4|(48&n)>>2|48&i|(48&s)<<2,t[e+2]=(12&r)>>2|12&n|(12&i)<<2|(12&s)<<4,t[e+3]=3&r|(3&n)<<2|(3&i)<<4|(3&s)<<6;}return t;default:throw new Error(`Invalid pixel format, "${e}"`)}}Qs(tw,"DEMData"),Qs(Zb,"DemMinMaxQuadTree",{omit:["dem"]});var pw=Uint8Array,dw=Uint16Array,fw=Int32Array,mw=new pw([0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,0,0,0]),yw=new pw([0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,0,0]),gw=new pw([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]),xw=function(t,e){for(var r=new dw(31),n=0;n<31;++n)r[n]=e+=1<<t[n-1];var i=new fw(r[30]);for(n=1;n<30;++n)for(var s=r[n];s<r[n+1];++s)i[s]=s-r[n]<<5|n;return {b:r,r:i}},vw=xw(mw,2),bw=vw.b,ww=vw.r;bw[28]=258,ww[258]=28;for(var _w=xw(yw,0).b,Aw=new dw(32768),Iw=0;Iw<32768;++Iw){var Mw=(43690&Iw)>>1|(21845&Iw)<<1;Aw[Iw]=((65280&(Mw=(61680&(Mw=(52428&Mw)>>2|(13107&Mw)<<2))>>4|(3855&Mw)<<4))>>8|(255&Mw)<<8)>>1;}var Sw=function(t,e,r){for(var n=t.length,i=0,s=new dw(e);i<n;++i)t[i]&&++s[t[i]-1];var o,a=new dw(e);for(i=1;i<e;++i)a[i]=a[i-1]+s[i-1]<<1;o=new dw(1<<e);var l=15-e;for(i=0;i<n;++i)if(t[i])for(var u=i<<4|t[i],c=e-t[i],h=a[t[i]-1]++<<c,p=h|(1<<c)-1;h<=p;++h)o[Aw[h]>>l]=u;return o},Pw=new pw(288);for(Iw=0;Iw<144;++Iw)Pw[Iw]=8;for(Iw=144;Iw<256;++Iw)Pw[Iw]=9;for(Iw=256;Iw<280;++Iw)Pw[Iw]=7;for(Iw=280;Iw<288;++Iw)Pw[Iw]=8;var kw=new pw(32);for(Iw=0;Iw<32;++Iw)kw[Iw]=5;var Bw=Sw(Pw,9),zw=Sw(kw,5),Tw=function(t){for(var e=t[0],r=1;r<t.length;++r)t[r]>e&&(e=t[r]);return e},Ew=function(t,e,r){var n=e/8|0;return (t[n]|t[n+1]<<8)>>(7&e)&r},Vw=function(t,e){var r=e/8|0;return (t[r]|t[r+1]<<8|t[r+2]<<16)>>(7&e)},Fw=["unexpected EOF","invalid block type","invalid length/literal","invalid distance","stream finished","no stream handler",,"no callback","invalid UTF-8 data","extra field too long","date not in range 1980-2099","filename too long","stream finishing","invalid zip data"],Cw=function(t,e,r){var n=new Error(e||Fw[t]);if(n.code=t,Error.captureStackTrace&&Error.captureStackTrace(n,Cw),!r)throw n;return n},Dw=new pw(0),Rw="undefined"!=typeof TextDecoder&&new TextDecoder;try{Rw.decode(Dw,{stream:!0});}catch(t){}const Lw={gzip_data:"gzip"};class Ow extends Error{constructor(t){super(t),this.name="MRTError";}}const Uw={0:"uint32",1:"uint32",2:"uint16",3:"uint8"},Nw={uint32:1,uint16:2,uint8:4},jw={uint32:Uint32Array,uint16:Uint16Array,uint8:Uint8Array};let $w;class Gw{constructor(t=5){this.x=NaN,this.y=NaN,this.z=NaN,this.layers={},this._cacheSize=t;}getLayer(t){const e=this.layers[t];if(!e)throw new Ow(`Layer '${t}' not found`);return e}getHeaderLength(t){const e=new Uint8Array(t),r=new DataView(t);if(13!==e[0])throw new Ow("File is not a valid MRT.");return r.getUint32(1,!0)}parseHeader(t){const e=new Uint8Array(t),r=this.getHeaderLength(t);if(e.length<r)throw new Ow(`Expected header with length >= ${r} but got buffer of length ${e.length}`);const n=new $w(e.subarray(0,r)).readFields(ew,{headerLength:0,x:0,y:0,z:0,layers:[]},void 0);if(!isNaN(this.x)&&(this.x!==n.x||this.y!==n.y||this.z!==n.z))throw new Ow(`Invalid attempt to parse header ${n.z}/${n.x}/${n.y} for tile ${this.z}/${this.x}/${this.y}`);this.x=n.x,this.y=n.y,this.z=n.z;for(const t of n.layers)this.layers[t.name]=new qw(t,{cacheSize:this._cacheSize});return this}createDecodingTask(t){const e=[],r=this.getLayer(t.layerName);for(let n of t.blockIndices){const i=r.dataIndex[n],s=i.firstByte-t.firstByte,o=i.lastByte-t.firstByte;if(r._blocksInProgress.has(n))continue;const a={layerName:r.name,firstByte:s,lastByte:o,pixelFormat:r.pixelFormat,blockIndex:n,blockShape:[i.bands.length].concat(r.bandShape),buffer:r.buffer,codec:i.codec.codec,filters:i.filters.map((t=>t.filter))};r._blocksInProgress.add(n),e.push(a);}return new Hw(e,(()=>{e.forEach((t=>r._blocksInProgress.delete(t.blockIndex)));}),((t,n)=>{if(e.forEach((t=>r._blocksInProgress.delete(t.blockIndex))),t)throw t;n.forEach((t=>{this.getLayer(t.layerName).processDecodedData(t);}));}))}}class qw{constructor({version:t,name:e,units:r,tileSize:n,pixelFormat:i,buffer:s,dataIndex:o},a){if(this.version=t,1!==this.version)throw new Ow(`Cannot parse raster layer encoded with MRT version ${t}`);this.name=e,this.units=r,this.tileSize=n,this.buffer=s,this.pixelFormat=Uw[i],this.dataIndex=o,this.bandShape=[n+2*s,n+2*s,Nw[this.pixelFormat]],this._decodedBlocks=new Nb(a?a.cacheSize:5),this._blocksInProgress=new Set;}get dimension(){return Nw[this.pixelFormat]}get cacheSize(){return this._decodedBlocks.capacity}getBandList(){return this.dataIndex.map((({bands:t})=>t)).flat()}processDecodedData(t){const e=t.blockIndex.toString();this._decodedBlocks.get(e)||this._decodedBlocks.put(e,t.data);}getBlockForBand(t){let e=0;switch(typeof t){case "string":for(const[r,n]of this.dataIndex.entries()){for(const[i,s]of n.bands.entries())if(s===t)return {bandIndex:e+i,blockIndex:r,blockBandIndex:i};e+=n.bands.length;}break;case "number":for(const[r,n]of this.dataIndex.entries()){if(t>=e&&t<e+n.bands.length)return {bandIndex:t,blockIndex:r,blockBandIndex:t-e};e+=n.bands.length;}break;default:throw new Ow(`Invalid band \`${JSON.stringify(t)}\`. Expected string or integer.`)}return {blockIndex:-1,blockBandIndex:-1}}getDataRange(t){let e=1/0,r=-1/0;const n=[],i=new Set;for(const s of t){const{blockIndex:t}=this.getBlockForBand(s);if(t<0)throw new Ow(`Invalid band: ${JSON.stringify(s)}`);const o=this.dataIndex[t];n.includes(t)||n.push(t),i.add(t),e=Math.min(e,o.firstByte),r=Math.max(r,o.lastByte);}if(i.size>this.cacheSize)throw new Ow(`Number of blocks to decode (${i.size}) exceeds cache size (${this.cacheSize}).`);return {layerName:this.name,firstByte:e,lastByte:r,blockIndices:n}}hasBand(t){const{blockIndex:e}=this.getBlockForBand(t);return e>=0}hasDataForBand(t){const{blockIndex:e}=this.getBlockForBand(t);return e>=0&&!!this._decodedBlocks.get(e.toString())}getBandView(t){const{blockIndex:e,blockBandIndex:r}=this.getBlockForBand(t);if(e<0)throw new Ow(`Band not found: ${JSON.stringify(t)}`);const n=this._decodedBlocks.get(e.toString());if(!n)throw new Ow(`Data for band ${JSON.stringify(t)} of layer "${this.name}" not decoded.`);const i=this.dataIndex[e],s=this.bandShape.reduce(((t,e)=>t*e),1),o=r*s,a=n.subarray(o,o+s);return {data:a,bytes:new Uint8Array(a.buffer).subarray(a.byteOffset,a.byteOffset+a.byteLength),tileSize:this.tileSize,buffer:this.buffer,pixelFormat:this.pixelFormat,dimension:this.dimension,offset:i.offset,scale:i.scale}}}Gw.setPbf=function(t){$w=t;};class Hw{constructor(t,e,r){this.tasks=t,this._onCancel=e,this._onComplete=r,this._finalized=!1;}cancel(){this._finalized||(this._onCancel(),this._finalized=!0);}complete(t,e){this._finalized||(this._onComplete(t,e),this._finalized=!0);}}Gw.performDecoding=function(t,e){const r=new Uint8Array(t);return Promise.all(e.tasks.map((t=>{const{layerName:e,firstByte:n,lastByte:i,pixelFormat:s,blockShape:o,blockIndex:a,filters:l,codec:u}=t,c=r.subarray(n,i+1),h=new Uint32Array(o[0]*o[1]*o[2]);let p;if("gzip_data"!==u)throw new Ow(`Unhandled codec: ${u}`);return p=function(t,e){if(!globalThis.DecompressionStream&&"gzip_data"===e)return Promise.resolve(((s=function(t){31==t[0]&&139==t[1]&&8==t[2]||Cw(6,"invalid gzip data");var e=t[3],r=10;4&e&&(r+=2+(t[10]|t[11]<<8));for(var n=(e>>3&1)+(e>>4&1);n>0;n-=!t[r++]);return r+(2&e)}(i=t))+8>i.length&&Cw(6,"invalid gzip data"),function(t,e,r,n){var i=t.length;if(!i||e.f&&!e.l)return r||new pw(0);var s=!r,o=s||2!=e.i,a=e.i;s&&(r=new pw(3*i));var l,u,c=function(t){var e=r.length;if(t>e){var n=new pw(Math.max(2*e,t));n.set(r),r=n;}},h=e.f||0,p=e.p||0,d=e.b||0,f=e.l,m=e.d,y=e.m,g=e.n,x=8*i;do{if(!f){h=Ew(t,p,1);var v=Ew(t,p+1,3);if(p+=3,!v){var b=t[(T=4+((p+7)/8|0))-4]|t[T-3]<<8,w=T+b;if(w>i){a&&Cw(0);break}o&&c(d+b),r.set(t.subarray(T,w),d),e.b=d+=b,e.p=p=8*w,e.f=h;continue}if(1==v)f=Bw,m=zw,y=9,g=5;else if(2==v){var _=Ew(t,p,31)+257,A=Ew(t,p+10,15)+4,I=_+Ew(t,p+5,31)+1;p+=14;for(var M=new pw(I),S=new pw(19),P=0;P<A;++P)S[gw[P]]=Ew(t,p+3*P,7);p+=3*A;var k=Tw(S),B=(1<<k)-1,z=Sw(S,k);for(P=0;P<I;){var T,E=z[Ew(t,p,B)];if(p+=15&E,(T=E>>4)<16)M[P++]=T;else {var V=0,F=0;for(16==T?(F=3+Ew(t,p,3),p+=2,V=M[P-1]):17==T?(F=3+Ew(t,p,7),p+=3):18==T&&(F=11+Ew(t,p,127),p+=7);F--;)M[P++]=V;}}var C=M.subarray(0,_),D=M.subarray(_);y=Tw(C),g=Tw(D),f=Sw(C,y),m=Sw(D,g);}else Cw(1);if(p>x){a&&Cw(0);break}}o&&c(d+131072);for(var R=(1<<y)-1,L=(1<<g)-1,O=p;;O=p){var U=(V=f[Vw(t,p)&R])>>4;if((p+=15&V)>x){a&&Cw(0);break}if(V||Cw(2),U<256)r[d++]=U;else {if(256==U){O=p,f=null;break}var N=U-254;U>264&&(N=Ew(t,p,(1<<(G=mw[P=U-257]))-1)+bw[P],p+=G);var j=m[Vw(t,p)&L],$=j>>4;if(j||Cw(3),p+=15&j,D=_w[$],$>3){var G=yw[$];D+=Vw(t,p)&(1<<G)-1,p+=G;}if(p>x){a&&Cw(0);break}o&&c(d+131072);var q=d+N;if(d<D){var H=0-D,X=Math.min(D,q);for(H+d<0&&Cw(3);d<X;++d)r[d]=(void 0)[H+d];}for(;d<q;++d)r[d]=r[d-D];}}e.l=f,e.p=O,e.b=d,e.f=h,f&&(h=1,e.m=y,e.d=m,e.n=g);}while(!h);return d!=r.length&&s?(l=r,(null==(u=d)||u>l.length)&&(u=l.length),new pw(l.subarray(0,u))):r.subarray(0,d)}(i.subarray(s,-8),{i:2},new pw(((r=i)[(n=r.length)-4]|r[n-3]<<8|r[n-2]<<16|r[n-1]<<24)>>>0))));var r,n,i,s;const o=Lw[e];if(!o)throw new Error(`Unhandled codec: ${e}`);const a=new globalThis.DecompressionStream(o);return new Response(new Blob([t]).stream().pipeThrough(a)).arrayBuffer().then((t=>new Uint8Array(t)))}(c,u).then((t=>(function(t,e){t.readFields(aw,e);}(new $w(t),h),new(0,jw[s])(h.buffer)))),p.then((t=>{for(let e=l.length-1;e>=0;e--)switch(l[e]){case "delta_filter":uw(t,o);break;case "zigzag_filter":cw(t);break;case "bitshuffle_filter":hw(t,s);break;default:throw new Ow(`Unhandled filter "${l[e]}"`)}return {layerName:e,blockIndex:a,data:t}})).catch((t=>{throw t}))})))},Qs(Hw,"MRTDecodingBatch",{omit:["_onCancel","_onComplete"]}),Qs(Gw,"MapboxRasterTile"),Qs(qw,"MapboxRasterLayer",{omit:["_blocksInProgress"]});class Xw{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e,this._numberToString[e]=r;}}encode(t){return this._stringToNumber[t]}decode(t){return this._numberToString[t]}}class Zw{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new Ks(Un,16,0),this.featureIndexArray=new il,this.promoteId=e,this.is3DTile=!1,this.serializedLayersCache=new Map;}insert(t,e,r,n,i,s=0,o=0){const a=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,i,s);const l=this.grid;for(let t=0;t<e.length;t++){const r=e[t],n=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];n[0]=Math.min(n[0],e.x),n[1]=Math.min(n[1],e.y),n[2]=Math.max(n[2],e.x),n[3]=Math.max(n[3],e.y);}0!==o&&(n[0]-=o,n[1]-=o,n[2]+=o,n[3]+=o),n[0]<Un&&n[1]<Un&&n[2]>=0&&n[3]>=0&&l.insert(a,n[0],n[1],n[2],n[3]);}}loadVTLayers(){if(!this.vtLayers){this.vtLayers=new Cu(new Sy(this.rawTileData)).layers,this.sourceLayerCoder=new Xw(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"]),this.vtFeatures={};for(const t in this.vtLayers)this.vtFeatures[t]=[];}return this.vtLayers}query(t,e){const{tilespaceGeometry:r,transform:n,tileTransform:i,pixelPosMatrix:s,availableImages:o,worldview:a}=e;this.loadVTLayers(),this.serializedLayersCache.clear();const l=e.queryRadius?e.queryRadius:0,u=r.bufferedTilespaceBounds,c=this.grid.query(u.min.x,u.min.y,u.max.x,u.max.y,((t,e,n,i)=>yc(r.bufferedTilespaceGeometry,t-l,e-l,n+l,i+l)));c.sort(Yw);let h=null;n.elevation&&c.length>0&&(h=zv.create(n.elevation,this.tileID));const p={};let d;for(let e=0;e<c.length;e++){const l=c[e];if(l===d)continue;d=l;const u=this.featureIndexArray.get(l);let f=null;this.is3DTile?this.loadMatchingModelFeature(p,u,t,r,n,a):this.loadMatchingFeature(p,u,t,o,a,((t,e,o,a=0)=>(f||(f=ku(t,this.tileID.canonical,i)),e.queryIntersectsFeature(r,t,o,f,this.z,n,s,h,a))));}return p}loadMatchingFeature(t,e,r,n,i,s){const{featureIndex:o,bucketIndex:a,sourceLayerIndex:l,layoutVertexArrayOffset:u}=e,c=this.bucketLayerIDs[a],h=r.layers,p=Object.keys(h);if(p.length&&!qt(p,c))return;const d=r.sourceCache,f=this.sourceLayerCoder.decode(l),m=this.vtLayers[f].feature(o),y=this.getId(m,f);for(let e=0;e<c.length;e++){const r=c[e];if(!h[r])continue;const{styleLayer:a,targets:l}=h[r];let p={};void 0!==y&&(p=d.getFeatureState(a.sourceLayer,y));const f=!s||s(m,a,p,u);if(!f)continue;const g=new jv(m,this.z,this.x,this.y,y);g.tile=this.tileID.canonical,g.state=p;let x=this.serializedLayersCache.get(r);x||(x=a.serialize(),x.id=r,this.serializedLayersCache.set(r,x)),g.source=x.source,g.sourceLayer=x["source-layer"],g.layer=Object.assign({},x),g.layer.paint=Ww(x.paint,a.paint,m,p,n),g.layer.layout=Ww(x.layout,a.layout,m,p,n);let v=!1;for(const t of l){this.updateFeatureProperties(g,t);const{filter:e}=t;if(e)if(m.properties=g.properties,e.needGeometry){const t=Bu(m,!0);if(!e.filter(new Io(this.tileID.overscaledZ,{worldview:i}),t,this.tileID.canonical))continue}else if(!e.filter(new Io(this.tileID.overscaledZ,{worldview:i}),m))continue;v=!0,t.targetId&&this.addFeatureVariant(g,t);}v&&this.appendToResult(t,r,o,g,f);}}loadMatchingModelFeature(t,e,r,n,i,s){const{featureIndex:o,bucketIndex:a}=e,l=this.bucketLayerIDs[a],u=r.layers,c=Object.keys(u);if(!c.length||qt(c,l))for(let e=0;e<l.length;e++){const a=l[e],{styleLayer:c,targets:h}=u[a];if("model"!==c.type)continue;const p=n.tile,d=p.getBucket(c);if(!(d&&d instanceof Rv))continue;const f=qv(d,o,n,i);if(!f)continue;const{z:m,x:y,y:g}=p.tileID.canonical,{feature:x,intersectionZ:v,position:b}=f;let w={};void 0!==x.id&&(w=r.sourceCache.getFeatureState(c.sourceLayer,x.id));const _=new jv({},m,y,g,x.id);_.tile=this.tileID.canonical,_.state=w,_.properties=x.properties,_.geometry={type:"Point",coordinates:[b.lng,b.lat]};let A=this.serializedLayersCache.get(a);A||(A=c.serialize(),A.id=a,this.serializedLayersCache.set(a,A)),_.source=A.source,_.sourceLayer=A["source-layer"],_.layer=Object.assign({},A);let I=!1;for(const t of h){this.updateFeatureProperties(_,t);const{filter:e}=t;if(e)if(x.properties=_.properties,e.needGeometry){if(!e.filter(new Io(this.tileID.overscaledZ,{worldview:s}),x,this.tileID.canonical))continue}else if(!e.filter(new Io(this.tileID.overscaledZ,{worldview:s}),x))continue;I=!0,t.targetId&&this.addFeatureVariant(_,t);}I&&this.appendToResult(t,a,o,_,v);}}updateFeatureProperties(t,e,r){if(e.properties){const n={};for(const i in e.properties){const s=e.properties[i].evaluate({zoom:this.z},t._vectorTileFeature,t.state,t.tile,r);null!=s&&(n[i]=s);}t.properties=n;}}addFeatureVariant(t,e,r){const n={target:e.target,namespace:e.namespace,uniqueFeatureID:e.uniqueFeatureID};e.properties&&(n.properties=t.properties),t.variants=t.variants||{},t.variants[e.targetId]=t.variants[e.targetId]||[],t.variants[e.targetId].push(n);}appendToResult(t,e,r,n,i){let s=t[e];void 0===s&&(s=t[e]=[]),s.push({featureIndex:r,feature:n,intersectionZ:i});}lookupSymbolFeatures(t,e,r,n,i,s){const o={};this.loadVTLayers();for(const a of t)this.loadMatchingFeature(o,{bucketIndex:e,sourceLayerIndex:r,featureIndex:a,layoutVertexArrayOffset:0},n,i,s);return o}loadFeature(t){const{featureIndex:e,sourceLayerIndex:r}=t;this.loadVTLayers();const n=this.sourceLayerCoder.decode(r),i=this.vtFeatures[n];if(i[e])return i[e];const s=this.vtLayers[n].feature(e);return i[e]=s,s}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return !0;return !1}getId(t,e){let r=t.id;if(this.promoteId){const n=Array.isArray(this.promoteId)||"object"!=typeof this.promoteId?this.promoteId:this.promoteId[e];if(null!=n)if(Array.isArray(n)){if(!this.promoteIdExpression){const t=js(n);if("success"!==t.result){const e=t.value.map((t=>`${t.key}: ${t.message}`)).join(", ");return void Xt(`Failed to create expression for promoteId: ${e}`)}this.promoteIdExpression=t.value;}r=this.promoteIdExpression.evaluate({zoom:0},t);}else r=t.properties[n];"boolean"==typeof r&&(r=Number(r));}return r}}function Ww(t,e,r,n,i){return jt(t,((t,s)=>{const o=e instanceof Eo?e.get(s):null;return o&&o.evaluate?o.evaluate(r,n,void 0,i):o}))}function Yw(t,e){return e-t}Qs(Zw,"FeatureIndex",{omit:["rawTileData","sourceLayerCoder"]});const Kw=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class Jw{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[e,r]=new Uint8Array(t,0,2);if(219!==e)throw new Error("Data does not appear to be in a KDBush format.");const n=r>>4;if(1!==n)throw new Error(`Got v${n} data when expected v1.`);const i=Kw[15&r];if(!i)throw new Error("Unrecognized array type.");const[s]=new Uint16Array(t,2,1),[o]=new Uint32Array(t,4,1);return new Jw(o,s,i,t)}constructor(t,e=64,r=Float64Array,n){if(isNaN(t)||t<0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+e,2),65535),this.ArrayType=r,this.IndexArrayType=t<65536?Uint16Array:Uint32Array;const i=Kw.indexOf(this.ArrayType),s=2*t*this.ArrayType.BYTES_PER_ELEMENT,o=t*this.IndexArrayType.BYTES_PER_ELEMENT,a=(8-o%8)%8;if(i<0)throw new Error(`Unexpected typed array class: ${r}.`);n&&n instanceof ArrayBuffer?(this.data=n,this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+o+a,2*t),this._pos=2*t,this._finished=!0):(this.data=new ArrayBuffer(8+s+o+a),this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+o+a,2*t),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+i]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t);}add(t,e){const r=this._pos>>1;return this.ids[r]=r,this.coords[this._pos++]=t,this.coords[this._pos++]=e,r}finish(){const t=this._pos>>1;if(t!==this.numItems)throw new Error(`Added ${t} items when expected ${this.numItems}.`);return Qw(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(t,e,r,n){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:i,coords:s,nodeSize:o}=this,a=[0,i.length-1,0],l=[];for(;a.length;){const u=a.pop()||0,c=a.pop()||0,h=a.pop()||0;if(c-h<=o){for(let o=h;o<=c;o++){const a=s[2*o],u=s[2*o+1];a>=t&&a<=r&&u>=e&&u<=n&&l.push(i[o]);}continue}const p=h+c>>1,d=s[2*p],f=s[2*p+1];d>=t&&d<=r&&f>=e&&f<=n&&l.push(i[p]),(0===u?t<=d:e<=f)&&(a.push(h),a.push(p-1),a.push(1-u)),(0===u?r>=d:n>=f)&&(a.push(p+1),a.push(c),a.push(1-u));}return l}within(t,e,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:i,nodeSize:s}=this,o=[0,n.length-1,0],a=[],l=r*r;for(;o.length;){const u=o.pop()||0,c=o.pop()||0,h=o.pop()||0;if(c-h<=s){for(let r=h;r<=c;r++)n_(i[2*r],i[2*r+1],t,e)<=l&&a.push(n[r]);continue}const p=h+c>>1,d=i[2*p],f=i[2*p+1];n_(d,f,t,e)<=l&&a.push(n[p]),(0===u?t-r<=d:e-r<=f)&&(o.push(h),o.push(p-1),o.push(1-u)),(0===u?t+r>=d:e+r>=f)&&(o.push(p+1),o.push(c),o.push(1-u));}return a}}function Qw(t,e,r,n,i,s){if(i-n<=r)return;const o=n+i>>1;t_(t,e,o,n,i,s),Qw(t,e,r,n,o-1,1-s),Qw(t,e,r,o+1,i,1-s);}function t_(t,e,r,n,i,s){for(;i>n;){if(i-n>600){const o=i-n+1,a=r-n+1,l=Math.log(o),u=.5*Math.exp(2*l/3),c=.5*Math.sqrt(l*u*(o-u)/o)*(a-o/2<0?-1:1);t_(t,e,r,Math.max(n,Math.floor(r-a*u/o+c)),Math.min(i,Math.floor(r+(o-a)*u/o+c)),s);}const o=e[2*r+s];let a=n,l=i;for(e_(t,e,n,r),e[2*i+s]>o&&e_(t,e,n,i);a<l;){for(e_(t,e,a,l),a++,l--;e[2*a+s]<o;)a++;for(;e[2*l+s]>o;)l--;}e[2*n+s]===o?e_(t,e,n,l):(l++,e_(t,e,l,i)),l<=r&&(n=l+1),r<=l&&(i=l-1);}}function e_(t,e,r,n){r_(t,r,n),r_(e,2*r,2*n),r_(e,2*r+1,2*n+1);}function r_(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function n_(t,e,r,n){const i=t-r,s=e-n;return i*i+s*s}t.$=Qr,t.A=Rr,t.B=ta,t.C=2,t.D=Zd,t.E=nr,t.F=_g,t.G=bg,t.H=Yr,t.I=ir,t.J=Lo,t.K=Wr,t.L=Jr,t.M=Ts,t.N=ks,t.O=zs,t.P=It,t.Q=Ns,t.R=Ce,t.S=Oo,t.T=Tf,t.U=js,t.V=Av,t.W=qs,t.X=vi,t.Y=gi,t.Z=xi,t._=sn,t.a=function(t){return oe.API_CDN_URL_REGEX.test(t)},t.a$=du,t.a0=Kr,t.a1=ar,t.a2=Uo,t.a3=class extends Av{},t.a4=Es,t.a5=Bs,t.a6=Ro,t.a7=function(t){const e=t.value;return e?Kr(e)?Iv(e,!0)?[]:[new Av(t.key,e,`invalid url "${e}"`)]:[new Av(t.key,e,`string expected, "${Wr(e)}" found`)]:[]},t.a8=Po,t.a9=Do,t.aA=Ft,t.aB=h,t.aC=Q,t.aD=Hl,t.aE=mc,t.aF=uu,t.aG=_u,t.aH=function(t,e){const r={};for(let n=0;n<e.length;n++){const i=e[n];i in t&&(r[i]=t[i]);}return r},t.aI=su,t.aJ=cu,t.aK=class{constructor(t){this.entries={},this.scheduler=t;}request(t,e,r,n){const i=this.entries[t]=this.entries[t]||{callbacks:[]};if(i.result){const[t,r]=i.result;return this.scheduler?this.scheduler.add((()=>{n(t,r);}),e):n(t,r),()=>{}}return i.callbacks.push(n),i.cancel||(i.cancel=r(((r,n)=>{i.result=[r,n];for(const t of i.callbacks)this.scheduler?this.scheduler.add((()=>{t(r,n);}),e):t(r,n);setTimeout((()=>delete this.entries[t]),3e3);}))),()=>{i.result||(i.callbacks=i.callbacks.filter((t=>t!==n)),i.callbacks.length||(i.cancel(),delete this.entries[t]));}}},t.aL=function(t,e,r){const n=JSON.stringify(t.request);return t.data&&(this.deduped.entries[n]={result:[null,t.data]}),this.deduped.request(n,{type:"parseTile",isSymbolTile:t.isSymbolTile,zoom:t.tileZoom},(e=>{const n=Oe(t.request,((t,n,i)=>{t?e(t):n&&e(null,{rawData:n,vectorTile:r?void 0:new Cu(new Sy(n)),responseHeaders:new Map(i.entries())});}));return ()=>{n.cancel(),e();}}),e)},t.aM=function(t){return t?{cacheControl:t.get("Cache-Control"),expires:t.get("Expires")}:{cacheControl:void 0,expires:void 0}},t.aN=De,t.aO=function(t){Pe++,Pe>we&&(t.getActor().send("enforceCacheSizeLimit",be),Pe=0);},t.aP=function(t){return t<=1?1:Math.pow(2,Math.floor(Math.log2(t)))},t.aQ=Bc,t.aR=dv,t.aS=vv,t.aT=iu,t.aU=hv,t.aV=function(t,e){const r=document.createElement("video");r.muted=!0,r.onloadstart=function(){e(null,r);};for(let e=0;e<t.length;e++){const n=document.createElement("source");Ue(t[e])||(r.crossOrigin="Anonymous"),n.src=t[e],r.appendChild(n);}return {cancel:()=>{}}},t.aW=Ef,t.aX=$v,t.aY=Nt,t.aZ=yx,t.a_=pu,t.aa=Vo,t.ab=class{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return Yt(t.expression.evaluate(e))}interpolate(t,e,r){return {x:pr(t.x,e.x,r),y:pr(t.y,e.y,r),z:pr(t.z,e.z,r),azimuthal:pr(t.azimuthal,e.azimuthal,r),polar:pr(t.polar,e.polar,r)}}},t.ac=Io,t.ad=Gs,t.ae=bu,t.af=j,t.ag=I,t.ah=Ct,t.ai=Eo,t.aj=eh,t.ak=pr,t.al=Un,t.am=dr,t.an=kt,t.ao=lr,t.ap=class{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return function([t,e]){const r=Yt([1,t,e]);return {x:r.x,y:r.y,z:r.z}}(t.expression.evaluate(e))}interpolate(t,e,r){return {x:pr(t.x,e.x,r),y:pr(t.y,e.y,r),z:pr(t.z,e.z,r)}}},t.aq=function(t,e,r=0,n=!0){const i=new It(r,r),s=t.sub(i),o=e.add(i),a=[s,new It(o.x,s.y),o,new It(s.x,o.y)];return n&&a.push(s.clone()),a},t.ar=function(t,e){const r=[];for(let n=0;n<t.length;n++){const i=Dt(n-1,-1,t.length-1),s=Dt(n+1,-1,t.length-1),o=t[n],a=t[s],l=t[i].sub(o).unit(),u=a.sub(o).unit(),c=u.angleWithSep(l.x,l.y),h=l.add(u).unit().mult(-1*e/Math.sin(c/2));r.push(o.add(h));}return r},t.as=gx,t.at=yc,t.au=function(t,e,r=0){return M(((e.x-r)*t.scale-t.x)*Un,(e.y*t.scale-t.y)*Un,fu(e.z,e.y))},t.av=X,t.aw=L,t.ax=qu,t.ay=Km,t.az=function(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const s of t)e=Math.min(e,s.x),r=Math.min(r,s.y),n=Math.max(n,s.x),i=Math.max(i,s.y);return {min:new It(e,r),max:new It(n,i)}},t.b=function(t){return oe.API_FONTS_REGEX.test(t)},t.b$=Xp,t.b0=Fa,t.b1=ma,t.b2=Ot,t.b3=Ya,t.b4=Wx,t.b5=function(){Ao.isLoading()||Ao.isLoaded()||"deferred"!==wo()||_o();},t.b6=No,t.b7=Bu,t.b8=jv,t.b9=Jt,t.bA=u,t.bB=y,t.bC=a,t.bD=function(t,e){const{x:r,y:n}=t.point,i=th(r,n,t.worldSize/t._pixelsPerMercatorPixel,0,0);return h(i,i,Kc(Nc(e)))},t.bE=n,t.bF=q,t.bG=F,t.bH=V,t.bI=U,t.bJ=O,t.bK=hg,t.bL=$y,t.bM=cg,t.bN=function(t,e,r,n,i){const s=5*e+2;t.float32[s+0]=r,t.float32[s+1]=n,t.float32[s+2]=i;},t.bO=qx,t.bP=ct,t.bQ=ft,t.bR=pt,t.bS=bt,t.bT=Dt,t.bU=function(t,e,n,i){var s=new r(4);return s[0]=t,s[1]=e,s[2]=n,s[3]=i,s},t.bV=class{isDataAvailableAtPoint(t){const e=this._source();if(this.isUsingMockSource()||!e||t.y<0||t.y>1)return !1;const r=e.getSource().maxzoom,n=1<<r,i=Math.floor(t.x),s=Math.floor((t.x-i)*n),o=Math.floor(t.y*n),a=this.findDEMTileFor(new Bc(r,i,r,s,o));return !(!a||!a.dem)}getAtPointOrZero(t,e=0){return this.getAtPoint(t,e)||0}getAtPoint(t,e,r=!0){if(this.isUsingMockSource())return null;null==e&&(e=null);const n=this._source();if(!n)return e;if(t.y<0||t.y>1)return e;const i=n.getSource().maxzoom,s=1<<i,o=Math.floor(t.x),a=t.x-o,l=new Bc(i,o,i,Math.floor(a*s),Math.floor(t.y*s)),u=this.findDEMTileFor(l);if(!u||!u.dem)return e;const c=u.dem,h=1<<u.tileID.canonical.z,p=(a*h-u.tileID.canonical.x)*c.dim,d=(t.y*h-u.tileID.canonical.y)*c.dim,f=Math.floor(p),m=Math.floor(d);return (r?this.exaggeration():1)*pr(pr(c.get(f,m),c.get(f,m+1),d-m),pr(c.get(f+1,m),c.get(f+1,m+1),d-m),p-f)}static getAtTileOffset(t,e,r,n){const i=1<<t.canonical.z;return n?n.pointElevation(e):r?r.getAtPointOrZero(new bu(t.wrap+(t.canonical.x+e.x/Un)/i,(t.canonical.y+e.y/Un)/i)):0}static getAtTileOffsetFunc(t,e,r,n){return (i,s,o)=>{const a=this.getAtTileOffset(t,i,s,o),l=n.upVector(t.canonical,i.x,i.y);return E(l,l,a*n.upVectorScale(t.canonical,e,r).metersToTile),l}}getForTilePoints(t,e,r,n){if(this.isUsingMockSource())return !1;const i=zv.create(this,t,n);return !!i&&(e.forEach((t=>{t[2]=this.exaggeration()*i.getElevationAt(t[0],t[1],r);})),!0)}getMinMaxForTile(t){if(this.isUsingMockSource())return null;const e=this.findDEMTileFor(t);if(!e||!e.dem)return null;const r=e.dem.tree,n=e.tileID,i=1<<t.canonical.z-n.canonical.z;let s=t.canonical.x/i-n.canonical.x,o=t.canonical.y/i-n.canonical.y,a=0;for(let e=0;e<t.canonical.z-n.canonical.z&&!r.leaves[a];e++){s*=2,o*=2;const t=2*Math.floor(o)+Math.floor(s);a=r.childOffsets[a]+t,s%=1,o%=1;}return {min:this.exaggeration()*r.minimums[a],max:this.exaggeration()*r.maximums[a]}}getMinElevationBelowMSL(){throw new Error("Pure virtual method called.")}raycast(t,e,r){throw new Error("Pure virtual method called.")}pointCoordinate(t){throw new Error("Pure virtual method called.")}_source(){throw new Error("Pure virtual method called.")}isUsingMockSource(){throw new Error("Pure virtual method called.")}exaggeration(){throw new Error("Pure virtual method called.")}findDEMTileFor(t){throw new Error("Pure virtual method called.")}get visibleDemTiles(){throw new Error("Getter must be implemented in subclass.")}getMinMaxForVisibleTiles(){const t=this.visibleDemTiles;if(0===t.length)return null;let e=!1,r=Number.MAX_VALUE,n=Number.MIN_VALUE;for(const i of t){const t=this.getMinMaxForTile(i.tileID);t&&(r=Math.min(r,t.min),n=Math.max(n,t.max),e=!0);}return e?{min:r,max:n}:null}},t.bW=Fd,t.bX=ic,t.bY=xy,t.bZ=Lp,t.b_=_v,t.ba=Xm,t.bb=bp,t.bc=ku,t.bd=da,t.be=Ga,t.bf=Cc,t.bg=hl,t.bh=zh,t.bi=av,t.bj=function(t,e){const r=eh(e.zoom);if(0===r)return Nc(t);const n=qc(t),i=Hc(n),s=uu(n.getWest())*e.worldSize,o=uu(n.getEast())*e.worldSize,a=cu(n.getNorth())*e.worldSize,l=cu(n.getSouth())*e.worldSize,u=[s,a,0],h=[o,a,0],p=[s,l,0],d=[o,l,0],f=c([],e.globeMatrix);return j(u,u,f),j(h,h,f),j(p,p,f),j(d,d,f),i[0]=jc(i[0],p,r),i[1]=jc(i[1],d,r),i[2]=jc(i[2],h,r),i[3]=jc(i[3],u,r),Ju.fromPoints(i)},t.bk=Yc,t.bl=c,t.bm=Xc,t.bn=jc,t.bo=fa,t.bp=Fc,t.bq=g,t.br=p,t.bs=Gw,t.bt=Sy,t.bu=Oe,t.bv=function(t,e){const r=[];for(const n in t)n in e||r.push(n);return r},t.bw=Rt,t.bx=["type","source","source-layer","minzoom","maxzoom","filter","layout"],t.by=Mt,t.bz=l,t.c=le,t.c$=function(t,e,r){let n=0;for(let r=0;r<2;++r){const i=0;t[r]>i&&(n+=(t[r]-i)*(t[r]-i)),e[r]<i&&(n+=(i-e[r])*(i-e[r]));}return n},t.c0=Zp,t.c1=tg,t.c2=Zg,t.c3=sx,t.c4=Jw,t.c5=E,t.c6=W,t.c7=et,t.c8=function(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],o=e[3],a=Math.sin(r),l=Math.cos(r);return t[0]=n*l+i*a,t[1]=i*l-n*a,t[2]=s*l+o*a,t[3]=o*l-s*a,t},t.c9=rt,t.cA=_,t.cB=Ku,t.cC=Nf,t.cD=Pc,t.cE=Gc,t.cF=function(t,e,r,n,i,s,o,a,l){if("globe"===l.name)return Gc(t,e,new Pc(r,n,i),!1);const u=yx({z:r,x:n,y:i},l);return new Ju([(s+u.x/u.scale)*e,e*(u.y/u.scale),o],[(s+u.x2/u.scale)*e,e*(u.y2/u.scale),a])},t.cG=function(t,e,r){return t[0]=Math.min(e[0],r[0]),t[1]=Math.min(e[1],r[1]),t[2]=Math.min(e[2],r[2]),t[3]=Math.min(e[3],r[3]),t},t.cH=function(t,e,r){return t[0]=Math.max(e[0],r[0]),t[1]=Math.max(e[1],r[1]),t[2]=Math.max(e[2],r[2]),t[3]=Math.max(e[3],r[3]),t},t.cI=function(t){const e=Math.round((t+45+360)%360/90)%4;return zt[e]},t.cJ=mu,t.cK=K,t.cL=Zl,t.cM=function(t){const e=u(new Float64Array(16));h(e,t.pixelMatrix,t.globeMatrix);const r=[0,Jl,0],n=[0,Ql,0];return j(r,r,e),j(n,n,e),[r[0]>0&&r[0]<=t.width&&r[1]>0&&r[1]<=t.height&&!nh(t,new iu(t.center.lat,90)),n[0]>0&&n[0]<=t.width&&n[1]>0&&n[1]<=t.height&&!nh(t,new iu(t.center.lat,-90))]},t.cN=function(t,e){const{scale:r}=t.tileTransform,n=r*Un/(t.tileSize*Math.pow(2,e.zoom-t.tileID.overscaledZ+t.tileID.canonical.z));return function(t,e,r){var n=e[1],i=e[2],s=e[3],o=r[0],a=r[1];return t[0]=e[0]*o,t[1]=n*o,t[2]=i*a,t[3]=s*a,t}(new Float32Array(4),e.inverseAdjustmentMatrix,[n,n])},t.cO=jf,t.cP=w,t.cQ=Uf,t.cR=function(t){const e=Uf(t,!0);return n([],[e[0],e[1],e[4],e[5]])},t.cS=d,t.cT=Hu,t.cU=f,t.cV=function(t){const{x:e,y:r}=t.point,{lng:n,lat:i}=t._center;return th(e,r,t.worldSize,n,i)},t.cW=B,t.cX=Bt,t.cY=zc,t.cZ=gc,t.c_=Xl,t.ca=te,t.cb=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=e[3],t},t.cc=b,t.cd=function(t,e,r,n,i){var s=1/Math.tan(e/2);if(t[0]=s/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=s,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=i&&i!==1/0){var o=1/(n-i);t[10]=(i+n)*o,t[14]=2*i*n*o;}else t[10]=-1,t[14]=-2*n;return t},t.ce=function(t,e,r,n,i,s,o){var a=1/(e-r),l=1/(n-i),u=1/(s-o);return t[0]=-2*a,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*u,t[11]=0,t[12]=(e+r)*a,t[13]=(i+n)*l,t[14]=(o+s)*u,t[15]=1,t},t.cf=hu,t.cg=function(t,e,r){t[4*e+0]=r[0],t[4*e+1]=r[1],t[4*e+2]=r[2],t[4*e+3]=r[3];},t.ch=wl,t.ci=Il,t.cj=_l,t.ck=Al,t.cl=kl,t.cm=Lx,t.cn=function(){var t=new r(4);return r!=Float32Array&&(t[1]=0,t[2]=0),t[0]=1,t[3]=1,t},t.co=function(t,e,r){var n=e[0],i=e[1],s=e[2],o=e[3],a=Math.sin(r),l=Math.cos(r);return t[0]=n*l+s*a,t[1]=i*l+o*a,t[2]=n*-a+s*l,t[3]=i*-a+o*l,t},t.cp=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]},t.cq=H,t.cr=function(t){var e=t[0],r=t[1],n=t[2],i=t[3];return Math.sqrt(e*e+r*r+n*n+i*i)},t.cs=at,t.ct=G,t.cu=kc,t.cv=3,t.cw=2,t.cx=7,t.cy=6,t.cz=N,t.d=function(t){return oe.API_TILEJSON_REGEX.test(t)},t.d$=class{constructor(t,e,r,n){this.context=t,this.format=n,this.size=r,this.texture=t.gl.createTexture();const[i,s,o]=this.size,{gl:a}=t;a.bindTexture(a.TEXTURE_3D,this.texture),t.pixelStoreUnpackFlipY.set(!1),t.pixelStoreUnpack.set(1),t.pixelStoreUnpackPremultiplyAlpha.set(!1),"data"in e&&e.data&&a.texImage3D(a.TEXTURE_3D,0,this.format,i,s,o,0,Bf(this.format),zf(this.format),e.data);}bind(t,e){const{context:r}=this,{gl:n}=r;n.bindTexture(n.TEXTURE_3D,this.texture),t!==this.minFilter&&(n.texParameteri(n.TEXTURE_3D,n.TEXTURE_MAG_FILTER,t),n.texParameteri(n.TEXTURE_3D,n.TEXTURE_MIN_FILTER,t),this.minFilter=t),e!==this.wrapS&&(n.texParameteri(n.TEXTURE_3D,n.TEXTURE_WRAP_S,e),n.texParameteri(n.TEXTURE_3D,n.TEXTURE_WRAP_T,e),this.wrapS=e);}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}},t.d0=function(t){return t*t*t*t*t},t.d1=lu,t.d2=45,t.d3=Ml,t.d4=function(t,e,r){const n=Math.sqrt(t*t+e*e+r*r),i=n>0?Math.acos(r/n)*Pt:0;let s=0!==t||0!==e?Math.atan2(-e,-t)*Pt+90:0;return s<0&&(s+=360),[n,s,i]},t.d5=M,t.d6=Yt,t.d7=vu,t.d8=P,t.d9=Ju,t.dA=function(t){return t({pluginStatus:yo,pluginURL:go}),bo.on("pluginStateChange",t),t},t.dB=Sl,t.dC=class extends bl{constructor(t){super(t),this.current=Bl;}set(t,e,r){if(this.fetchUniformLocation(t,e))for(let t=0;t<9;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix3fv(this.location,!1,r);break}}},t.dD=Tt,t.dE=function(t,e,r){const n=eh(r.zoom),i=t.style.map._antialias,s=t.terrain&&t.terrain.exaggeration()>0;return 0===n&&!i&&!s},t.dF=function(t){const e=t.pixelsPerMeter,r=e/hu(1,t.center.lat),n=u(new Float64Array(16));return p(n,n,[t.point.x,t.point.y,0]),d(n,n,[r,r,e]),Float32Array.from(n)},t.dG=qc,t.dH=function(t){const e=mu-5;t=Ft(t,-e,e)/e*90;const r=Math.pow(Math.abs(Math.sin(kt(t))),3);return Math.round(r*(Kl.length-1))},t.dI=function(t,e,r,n){const i=e.getNorth(),s=e.getSouth(),a=e.getWest(),l=e.getEast(),u=1<<t.z,c=l-a,h=i-s,p=c/Yl,d=-h/Kl[r],f=[0,p,0,d,0,0,i,a,0];if(t.z>0){const t=180/n;o(f,f,[t/c+1,0,0,0,t/h+1,0,-.5*t/p,.5*t/d,1]);}return f[2]=u,f[5]=t.x,f[8]=t.y,f},t.dJ=Nc,t.dK=function(t,e,r){const n=u(new Float64Array(16)),i=(e/(1<<t)-.5)*Math.PI*2;return m(n,r.globeMatrix,i),Float32Array.from(n)},t.dL=Ih,t.dM=Dc,t.dN=function(t,e){return [Math.pow(t[0],2.2)*e,Math.pow(t[1],2.2)*e,Math.pow(t[2],2.2)*e]},t.dO=i,t.dP=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=0,t[3]=-r,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},t.dQ=$,t.dR=Qc,t.dS=ne,t.dT=ie,t.dU=256,t.dV=function(t,e){const r=[0,0,0];return j(r,r,Yc(Nc(e.canonical))),j(r,r,t),r},t.dW=t=>({u_matrix:new kl(t),u_texsize:new Al(t),u_pixels_to_tile_units:new Tl(t),u_device_pixel_ratio:new _l(t),u_width_scale:new _l(t),u_floor_width_scale:new _l(t),u_image:new wl(t),u_units_to_pixels:new Al(t),u_tile_units_to_pixels:new _l(t),u_alpha_discard_threshold:new _l(t),u_trim_offset:new Al(t),u_trim_fade_range:new Al(t),u_trim_color:new Ml(t),u_zbias_factor:new _l(t),u_tile_to_meter:new _l(t),u_ground_shadow_factor:new Il(t),u_pattern_transition:new _l(t)}),t.dX=t=>({u_matrix:new kl(t),u_pixels_to_tile_units:new Tl(t),u_device_pixel_ratio:new _l(t),u_width_scale:new _l(t),u_floor_width_scale:new _l(t),u_units_to_pixels:new Al(t),u_dash_image:new wl(t),u_gradient_image:new wl(t),u_image_height:new _l(t),u_texsize:new Al(t),u_tile_units_to_pixels:new _l(t),u_alpha_discard_threshold:new _l(t),u_trim_offset:new Al(t),u_trim_fade_range:new Al(t),u_trim_color:new Ml(t),u_zbias_factor:new _l(t),u_tile_to_meter:new _l(t),u_ground_shadow_factor:new Il(t)}),t.dY=t=>({u_camera_to_center_distance:new _l(t),u_extrude_scale:new Tl(t),u_device_pixel_ratio:new _l(t),u_matrix:new kl(t),u_inv_rot_matrix:new kl(t),u_merc_center:new Al(t),u_tile_id:new Il(t),u_zoom_transition:new _l(t),u_up_dir:new Il(t),u_emissive_strength:new _l(t)}),t.dZ=Ea,t.d_=gy,t.da=k,t.db=function(t){return [Math.pow(t[0],1/2.2),Math.pow(t[1],1/2.2),Math.pow(t[2],1/2.2)]},t.dc=kf,t.dd=pm,t.de=Qf,t.df=Iv,t.dg=function(t,e){return t.readFields(tb,{icons:[]},e)},t.dh=Kd,t.di=zg,t.dj=Bg,t.dk=Re,t.dl=xo,t.dm=xe,t.dn=Je,t.dp=Gt,t.dq=function(t){const e=t.indexOf(Qo);return e>=0?t.slice(0,e):t},t.dr=function(t){return t.indexOf(Qo)>=0},t.ds=function(t){const e=t.lastIndexOf(Qo);return e>=0?t.slice(e+1):""},t.dt=function(t){const e=[],r=t.id;return void 0===r&&e.push({message:`layers.${r}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${r}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${r}: property "renderingMode" must be either "2d" or "3d"`}),e},t.du=function(t,e,r,n){return "custom"===t.type?new bv(t,e):new Hv[t.type](t,e,r,n)},t.dv=$t,t.dw=function(t){const e=t.indexOf(Qo);return e>=0?t.slice(e+1):""},t.dx=class extends jv{constructor(t,e){super(t._vectorTileFeature,t._z,t._x,t._y,t.id),t.state&&(this.state=Object.assign({},t.state)),this.target=e.target,this.namespace=e.namespace,e.properties&&(this.properties=e.properties),this.target&&("featuresetId"in this.target&&!this.target.importId||"layerId"in this.target)&&(this.source=t.source,this.sourceLayer=t.sourceLayer,this.layer=t.layer);}toJSON(){const t=super.toJSON();return t.target=this.target,t.namespace=this.namespace,t}},t.dy=bo,t.dz=Le,t.e=oe,t.e$=S,t.e0=lh,t.e1=(t,e,r,n,i,s)=>{const o=t.transform,a="globe"===o.projection.name;let l;if("map"===s.paint.get("circle-pitch-alignment"))if(a){const t=Qc(o.zoom,e.canonical)*o._pixelsPerMercatorPixel;l=Float32Array.from([t,0,0,t]);}else l=o.calculatePixelsToTileUnitsMatrix(r);else l=new Float32Array([o.pixelsToGLUnits[0],0,0,o.pixelsToGLUnits[1]]);const u={u_camera_to_center_distance:t.transform.getCameraToCenterDistance(o.projection),u_matrix:t.translatePosMatrix(e.projMatrix,r,s.paint.get("circle-translate"),s.paint.get("circle-translate-anchor")),u_device_pixel_ratio:ye.devicePixelRatio,u_extrude_scale:l,u_inv_rot_matrix:ah,u_merc_center:[0,0],u_tile_id:[0,0,0],u_zoom_transition:0,u_up_dir:[0,0,0],u_emissive_strength:s.paint.get("circle-emissive-strength")};if(a){u.u_inv_rot_matrix=n,u.u_merc_center=i,u.u_tile_id=[e.canonical.x,e.canonical.y,1<<e.canonical.z],u.u_zoom_transition=eh(o.zoom);const t=i[0]*Un,r=i[1]*Un;u.u_up_dir=o.projection.upVector(new Pc(0,0,0),t,r);}return u},t.e2=ey,t.e3=Lr,t.e4=(t,e,r,n,i,s,o,a,l,u)=>{const c=t.transform,h=c.pitch<15?Jm(.07,.7,Ft((14-c.zoom)/5,0,1)):.07,p="none"===r.paint.get("line-trim-color-use-theme").constantOr("default");return {u_matrix:ty(t,e,r,n),u_texsize:e.imageAtlasTexture?e.imageAtlasTexture.size:[0,0],u_pixels_to_tile_units:c.calculatePixelsToTileUnitsMatrix(e),u_device_pixel_ratio:i,u_width_scale:s,u_floor_width_scale:o,u_image:0,u_tile_units_to_pixels:Qm(e,c),u_units_to_pixels:[1/c.pixelsToGLUnits[0],1/c.pixelsToGLUnits[1]],u_alpha_discard_threshold:0,u_trim_offset:a,u_trim_fade_range:r.paint.get("line-trim-fade-range"),u_trim_color:r.paint.get("line-trim-color").toPremultipliedRenderColor(p?null:r.lut).toArray01(),u_zbias_factor:h,u_tile_to_meter:vu(e.tileID.canonical,0),u_ground_shadow_factor:l,u_pattern_transition:u}},t.e5=(t,e,r,n,i,s,o,a,l,u)=>{const c=t.transform,h=c.calculatePixelsToTileUnitsMatrix(e),p="none"===r.paint.get("line-trim-color-use-theme").constantOr("default"),d=c.pitch<15?Jm(.07,.7,Ft((14-c.zoom)/5,0,1)):.07;return {u_matrix:ty(t,e,r,n),u_pixels_to_tile_units:h,u_device_pixel_ratio:s,u_width_scale:o,u_floor_width_scale:a,u_units_to_pixels:[1/c.pixelsToGLUnits[0],1/c.pixelsToGLUnits[1]],u_dash_image:0,u_gradient_image:1,u_image_height:i,u_texsize:ry(r)&&e.lineAtlasTexture?e.lineAtlasTexture.size:[0,0],u_tile_units_to_pixels:Qm(e,t.transform),u_alpha_discard_threshold:0,u_trim_offset:l,u_trim_fade_range:r.paint.get("line-trim-fade-range"),u_trim_color:r.paint.get("line-trim-color").toPremultipliedRenderColor(p?null:r.lut).toArray01(),u_zbias_factor:d,u_tile_to_meter:vu(e.tileID.canonical,0),u_ground_shadow_factor:u}},t.e6=Ut,t.e7=Mh,t.e8=fu,t.e9=Tc,t.eA=function(t,r){var n=2*Math.acos(r[3]),i=Math.sin(n/2);return i>e?(t[0]=r[0]/i,t[1]=r[1]/i,t[2]=r[2]/i):(t[0]=1,t[1]=0,t[2]=0),n},t.eB=Gv,t.eC=Jf,t.eD=Zf,t.eE=[1,1,1],t.eF=zv,t.eG=Y,t.eH=function(t,e,r,n){var i=e[0],s=e[1],o=e[2],a=e[3];return t[0]=i+n*(r[0]-i),t[1]=s+n*(r[1]-s),t[2]=o+n*(r[2]-o),t[3]=a+n*(r[3]-a),t},t.eI=Kf,t.eJ=Ba,t.eK=ja,t.eL=function(t,e,n,i,s,o,a,l,u,c,h,p,d,f,m,y){var g=new r(16);return g[0]=t,g[1]=e,g[2]=n,g[3]=i,g[4]=s,g[5]=o,g[6]=a,g[7]=l,g[8]=u,g[9]=c,g[10]=h,g[11]=p,g[12]=d,g[13]=f,g[14]=m,g[15]=y,g},t.eM=ru,t.eN=Na,t.eO=Ua,t.eP=class{constructor(){this._updateTime=0,this._sourceIds=[],this._activeRegions=[],this._prevRegions=[],this._globalClipBounds={min:new It(1/0,1/0),max:new It(-1/0,-1/0)};}clear(){this._activeRegions.length>0&&++this._updateTime,this._activeRegions=[],this._prevRegions=[];}get updateTime(){return this._updateTime}getReplacementRegionsForTile(t,e=!1){const r=$p(new It(0,0),new It(Un,Un),t),n=[];if(e&&!Np(r,this._globalClipBounds))return n;for(const e of this._activeRegions){if(e.hiddenByOverlap)continue;if(!Np(r,e))continue;const i=Gp(e.min,e.max,t);n.push({min:i.min,max:i.max,sourceId:this._sourceIds[e.priority],footprint:e.footprint,footprintTileId:e.tileId,order:e.order,clipMask:e.clipMask,clipScope:e.clipScope});}return n}setSources(t){this._setSources(t.map((t=>({getSourceId:()=>t.cache.id,getFootprints:()=>{const e=[];for(const r of t.cache.getVisibleCoordinates()){const n=t.cache.getTile(r).buckets[t.layer];n&&n.updateFootprints(r.toUnwrapped(),e);}return e},getOrder:()=>t.order,getClipMask:()=>t.clipMask,getClipScope:()=>t.clipScope}))));}_addSource(t){const e=t.getFootprints();if(0===e.length)return;const r=t.getOrder(),n=t.getClipMask(),i=t.getClipScope();for(const t of e){if(!t.footprint)continue;const e=$p(t.footprint.min,t.footprint.max,t.id);this._activeRegions.push({min:e.min,max:e.max,hiddenByOverlap:!1,priority:this._sourceIds.length,tileId:t.id,footprint:t.footprint,order:r,clipMask:n,clipScope:i});}this._sourceIds.push(t.getSourceId());}_computeReplacement(){this._activeRegions.sort(((t,e)=>t.priority-e.priority||Op(t.min,e.min)||Op(t.max,e.max)||t.order-e.order||t.clipMask-e.clipMask||function(t,e){const r=(t,e)=>t+e;return t.length-e.length||t.reduce(r,"").localeCompare(e.reduce(r,""))}(t.clipScope,e.clipScope)));let t=this._activeRegions.length!==this._prevRegions.length;if(!t){let e=0;for(;!t&&e!==this._activeRegions.length;){const r=this._activeRegions[e],n=this._prevRegions[e];t=r.priority!==n.priority||!Up(r,n)||r.order!==n.order||r.clipMask!==n.clipMask||!Mt(r.clipScope,n.clipScope),this._activeRegions[e].hiddenByOverlap=n.hiddenByOverlap,++e;}}if(t){++this._updateTime;for(const t of this._activeRegions)t.order!==Dp&&(this._globalClipBounds.min.x=Math.min(this._globalClipBounds.min.x,t.min.x),this._globalClipBounds.min.y=Math.min(this._globalClipBounds.min.y,t.min.y),this._globalClipBounds.max.x=Math.max(this._globalClipBounds.max.x,t.max.x),this._globalClipBounds.max.y=Math.max(this._globalClipBounds.max.y,t.max.y));const t=t=>{const e=this._activeRegions;if(t>=e.length)return t;const r=e[t].priority;for(;t<e.length&&e[t].priority===r;)++t;return t};if(this._sourceIds.length>1){let e=0,r=t(e);for(;e!==r;){let n=e;const i=e;for(;n!==r;){const t=this._activeRegions[n];t.hiddenByOverlap=!1;for(let e=0;e<i;e++){const r=this._activeRegions[e];if(!r.hiddenByOverlap&&t.order===Dp&&Np(t,r)&&(t.hiddenByOverlap=Hp(t.footprint,t.tileId,r.footprint,r.tileId),t.hiddenByOverlap))break}++n;}e=r,r=t(e);}}}}_setSources(t){[this._prevRegions,this._activeRegions]=[this._activeRegions,[]],this._sourceIds=[];for(let e=t.length-1;e>=0;e--)this._addSource(t[e]);this._computeReplacement();}},t.eQ=Dp,t.eR=class{constructor(t){this._createGrid(t),this._createPoles(t);}destroy(){this._poleIndexBuffer.destroy(),this._gridBuffer.destroy(),this._gridIndexBuffer.destroy(),this._poleNorthVertexBuffer.destroy(),this._poleSouthVertexBuffer.destroy();for(const t of this._poleSegments)t.destroy();for(const t of this._gridSegments)t.withSkirts.destroy(),t.withoutSkirts.destroy();}_fillGridMeshWithLods(t,e){const r=new da,n=new Fa,i=[],s=t+1+2,o=e[0]+1,a=e[0]+1+(1+e.length),l=(t,e,r)=>{let n=t===s-1?t-2:0===t?t:t-1;return n+=r?24575:0,[n,e]};for(let t=0;t<s;++t)r.emplaceBack(...l(t,0,!0));for(let t=0;t<o;++t)for(let e=0;e<s;++e)r.emplaceBack(...l(e,t,(0===e||e===s-1)&&!0));for(let t=0;t<e.length;++t){const n=e[t];for(let t=0;t<s;++t)r.emplaceBack(...l(t,n,!0));}for(let t=0;t<e.length;++t){const o=n.length,l=e[t]+1+2,u=new Fa;for(let r=0;r<l-1;r++){const i=r===l-2,o=i?s*(a-e.length+t-r):s;for(let t=0;t<s-1;t++){const e=r*s+t;0===r||i||0===t||t===s-2?(u.emplaceBack(e+1,e,e+o),u.emplaceBack(e+o,e+o+1,e+1)):(n.emplaceBack(e+1,e,e+o),n.emplaceBack(e+o,e+o+1,e+1));}}const c=hl.simpleSegment(0,o,r.length,n.length-o);for(let t=0;t<u.uint16.length;t+=3)n.emplaceBack(u.uint16[t],u.uint16[t+1],u.uint16[t+2]);const h=hl.simpleSegment(0,o,r.length,n.length-o);i.push({withoutSkirts:c,withSkirts:h});}return {vertices:r,indices:n,segments:i}}_createGrid(t){const e=this._fillGridMeshWithLods(Yl,Kl);this._gridSegments=e.segments,this._gridBuffer=t.createVertexBuffer(e.vertices,Cc.members),this._gridIndexBuffer=t.createIndexBuffer(e.indices,!0);}_createPoles(t){const e=new Fa;for(let t=0;t<=Yl;t++)e.emplaceBack(0,t+1,t+2);this._poleIndexBuffer=t.createIndexBuffer(e,!0);const r=new La,n=new La,i=new La,s=new La;this._poleSegments=[];for(let t=0,e=0;t<Xl;t++){const o=360/(1<<t);r.emplaceBack(0,-Hl,0,.5,0),n.emplaceBack(0,-Hl,0,.5,1),i.emplaceBack(0,-Hl,0,.5,.5),s.emplaceBack(0,-Hl,0,.5,.5);for(let t=0;t<=Yl;t++){let e=t/Yl,a=0;const l=pr(0,o,e),[u,c,h]=tu(sh,oh,l,Hl);r.emplaceBack(u,c,h,e,a),n.emplaceBack(u,c,h,e,1-a);const p=kt(l);e=.5+.5*Math.sin(p),a=.5+.5*Math.cos(p),i.emplaceBack(u,c,h,e,a),s.emplaceBack(u,c,h,e,1-a);}this._poleSegments.push(hl.simpleSegment(e,0,66,64)),e+=66;}this._poleNorthVertexBuffer=t.createVertexBuffer(r,Vc,!1),this._poleSouthVertexBuffer=t.createVertexBuffer(n,Vc,!1),this._texturedPoleNorthVertexBuffer=t.createVertexBuffer(i,Vc,!1),this._texturedPoleSouthVertexBuffer=t.createVertexBuffer(s,Vc,!1);}getGridBuffers(t,e){return [this._gridBuffer,this._gridIndexBuffer,e?this._gridSegments[t].withSkirts:this._gridSegments[t].withoutSkirts]}getPoleBuffers(t,e){return [e?this._texturedPoleNorthVertexBuffer:this._poleNorthVertexBuffer,e?this._texturedPoleSouthVertexBuffer:this._poleSouthVertexBuffer,this._poleIndexBuffer,this._poleSegments[t]]}},t.eS=Rp,t.eT=Et,t.eU=function(){return !!document.fullscreenElement||!!document.webkitFullscreenElement},t.eV=Vt,t.eW=xu,t.eX=function(t,e,r){return t[0]=e[0]/r[0],t[1]=e[1]/r[1],t[2]=e[2]/r[2],t},t.eY=Z,t.eZ=eu,t.e_=D,t.ea=gd,t.eb=Md,t.ec=nd,t.ed=sd,t.ee=id,t.ef=gu,t.eg=function(t,e){if(t===e){var r=e[1],n=e[2],i=e[3],s=e[6],o=e[7],a=e[11];t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=s,t[11]=e[14],t[12]=i,t[13]=o,t[14]=a;}else t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15];return t},t.eh=pv,t.ei=ha,t.ej=Xa,t.ek=256,t.el=Kc,t.em=wa,t.en=m,t.eo=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t},t.ep=La,t.eq=ys,t.er=Oa,t.es=function(t,e,r,n,i){return Ft((t-e)/(r-e)*(i-n)+n,n,i)},t.et=nt,t.eu=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],o=e[4],a=e[5],l=e[6],u=e[7],c=e[8],h=c*o-a*u,p=-c*s+a*l,d=u*s-o*l,f=r*h+n*p+i*d;return f?(t[0]=h*(f=1/f),t[1]=(-c*n+i*u)*f,t[2]=(a*n-i*o)*f,t[3]=p*f,t[4]=(c*r-i*l)*f,t[5]=(-a*r+i*s)*f,t[6]=d*f,t[7]=(-u*r+n*l)*f,t[8]=(o*r-n*s)*f,t):null},t.ev=2,t.ew=R,t.ex=tt,t.ey=v,t.ez=function(t,e){var n=new r(3);v(n,e);var i=1/n[0],s=1/n[1],o=1/n[2],a=e[0]*i,l=e[1]*s,u=e[2]*o,c=e[4]*i,h=e[5]*s,p=e[6]*o,d=e[8]*i,f=e[9]*s,m=e[10]*o,y=a+h+m,g=0;return y>0?(g=2*Math.sqrt(y+1),t[3]=.25*g,t[0]=(p-f)/g,t[1]=(d-u)/g,t[2]=(l-c)/g):a>h&&a>m?(g=2*Math.sqrt(1+a-h-m),t[3]=(p-f)/g,t[0]=.25*g,t[1]=(l+c)/g,t[2]=(d+u)/g):h>m?(g=2*Math.sqrt(1+h-a-m),t[3]=(d-u)/g,t[0]=(l+c)/g,t[1]=.25*g,t[2]=(p+f)/g):(g=2*Math.sqrt(1+m-a-h),t[3]=(l-c)/g,t[0]=(d+u)/g,t[1]=(p+f)/g,t[2]=.25*g),t},t.f=function(t){return btoa(encodeURIComponent(t).replace(/%([0-9A-F]{2})/g,((t,e)=>String.fromCharCode(Number("0x"+e)))))},t.f0=function([t,e,r]){const n=Math.hypot(t,e,r),i=Math.atan2(t,r),s=.5*Math.PI-Math.acos(-e/n);return new iu(Bt(i),Bt(s))},t.f1=J,t.f2=Gf,t.f3=function(t){const e=t.navigator?t.navigator.userAgent:null;return !!function(t){if(null==Qt){const e=t.navigator?t.navigator.userAgent:null;Qt=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")));}return Qt}(t)&&!(!e||!(e.match("Version/15.4")||e.match("Version/15.5")||e.match(/CPU (OS|iPhone OS) (15_4|15_5) like Mac OS X/)))},t.f4=function(t,e){be=t,we=e;},t.f5=nh,t.f6=rh,t.f7=function(t){const e=[0,0,0],r=u(new Float64Array(16));return h(r,t.pixelMatrix,t.globeMatrix),j(e,e,r),new It(e[0],e[1])},t.f8=function(){const t=Wd;t&&(t.isPreloaded()&&1===t.numActive()?(t.release(Hd),Wd=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"));},t.f9=function(){Kd().acquire(Hd);},t.fA=tw,t.fB=zu,t.fC=function(t){let e=0;if(new Uint32Array(t,0,1)[0]!==wf){const r=new Uint32Array(t,0,7),[,,n,i,s,o]=r;e=r.byteLength+i+s+o+s,(n!==t.byteLength||e>=t.byteLength)&&Xt("Invalid b3dm header information.");}return Pf(t,e)},t.fD=function(t,e){const r=pm(t);for(const t of r){for(const e of t.meshes)dm(e);t.lights&&(t.lightMeshIndex=t.meshes.length,t.meshes.push(mm(t.lights,e)));}return r},t.fE=Rv,t.fF=Kt,t.fG=Gd,t.fH=Ao,t.fI=fo,t.fJ=function(t){Se(),null!=Ae&&Ae.then((e=>{e.keys().then((r=>{for(let n=0;n<r.length-t;n++)e.delete(r[n]).catch((t=>Xt(t.message)));})).catch((t=>Xt(t.message)));})).catch((t=>Xt(t.message)));},t.fa=wo,t.fb=function(t,e,r=!1){if(yo===fo.deferred||yo===fo.loading||yo===fo.loaded)throw new Error("setRTLTextPlugin cannot be called multiple times.");go=ye.resolveURL(t),yo=fo.deferred,mo=e,vo(),r||_o();},t.fc=function(t){nf=ye.resolveURL(t),of||(of=new Zd(Kd(),new nr)),of.broadcast("setMeshoptUrl",nf);},t.fd=hf,t.fe=function(t){ef=ye.resolveURL(t),of||(of=new Zd(Kd(),new nr)),of.broadcast("setDracoUrl",ef);},t.ff=cf,t.fg=qd,t.fh=function(t){const e=Me();if(!e)return;const r=e.delete(ve);t&&r.then((()=>t())).catch(t);},t.fi=Xd,t.fj=Qs,t.fk=_h,t.fl=kg,t.fm=Xw,t.fn=Zw,t.fo=$m,t.fp=Ru,t.fq="hd_road_elevation",t.fr=ec,t.fs=jt,t.ft=lp,t.fu=Ag,t.fv=wg,t.fw=function(t,e,r,n,i,s,o,a=1,l,u,c){t.createArrays(),t.tilePixelRatio=Un/(512*t.overscaling),t.compareText={},t.iconsNeedLinear=!1;const h=t.layers[0].layout,p=t.layers[0]._unevaluatedLayout._values,d={};d.scaleFactor=a,d.textSizeScaleRange=h.get("text-size-scale-range"),d.iconSizeScaleRange=h.get("icon-size-scale-range");const[f,m]=d.textSizeScaleRange,[y,g]=d.iconSizeScaleRange;d.textScaleFactor=Ft(d.scaleFactor,f,m),d.iconScaleFactor=Ft(d.scaleFactor,y,g);const x=p["text-size"],v=p["icon-size"];if("composite"===t.textSizeData.kind){const{minZoom:e,maxZoom:r}=t.textSizeData;d.compositeTextSizes=[x.possiblyEvaluate(new Io(e,{worldview:c}),s),x.possiblyEvaluate(new Io(r,{worldview:c}),s)];}if("composite"===t.iconSizeData.kind){const{minZoom:e,maxZoom:r}=t.iconSizeData;d.compositeIconSizes=[v.possiblyEvaluate(new Io(e,{worldview:c}),s),v.possiblyEvaluate(new Io(r,{worldview:c}),s)];}d.layoutTextSize=x.possiblyEvaluate(new Io(o+1,{worldview:c}),s),d.layoutIconSize=v.possiblyEvaluate(new Io(o+1,{worldview:c}),s),d.textMaxSize=x.possiblyEvaluate(new Io(18,{worldview:c}),s);const b=h.get("symbol-placement"),w="map"===h.get("text-rotation-alignment")&&"point"!==b,_=h.get("text-size");let A=!1;const I=[];for(const o of t.features){const a=h.get("text-font").evaluate(o,{},s).join(","),f=_.evaluate(o,{},s)*d.textScaleFactor,m=d.layoutTextSize.evaluate(o,{},s)*d.textScaleFactor,y=d.layoutIconSize.evaluate(o,{},s)*d.iconScaleFactor,g={horizontal:{},vertical:void 0},x=o.text;let v,M=[0,0];if(x){const n=x.toString(),u=h.get("text-letter-spacing").evaluate(o,{},s)*xy,c=h.get("text-line-height").evaluate(o,{},s)*xy,p=so(n)?u:0,d=h.get("text-anchor").evaluate(o,{},s),y=h.get("text-variable-anchor");if(!y){const t=h.get("text-radial-offset").evaluate(o,{},s);if(t)M=Zg(d,[t*xy,qg]);else {const t=h.get("text-offset").evaluate(o,{},s);M=[t[0]*xy,t[1]*xy];}}let v=w?"center":h.get("text-justify").evaluate(o,{},s);const _="point"===b,A=_?h.get("text-max-width").evaluate(o,{},s)*xy:1/0,I=s=>{t.allowVerticalPlacement&&io(n)&&(g.vertical=Hy(x,e,r,i,a,A,c,d,s,p,M,$y.vertical,!0,m,f,l));};if(!w&&y){const t="auto"===v?y.map((t=>sx(t))):[v];let n=!1;for(let s=0;s<t.length;s++){const o=t[s];if(!g.horizontal[o])if(n)g.horizontal[o]=g.horizontal[0];else {const t=Hy(x,e,r,i,a,A,c,"center",o,p,M,$y.horizontal,!1,m,f,l);t&&(g.horizontal[o]=t,n=1===t.positionedLines.length);}}I("left");}else {if("auto"===v&&(v=sx(d)),_||h.get("text-writing-mode").indexOf("horizontal")>=0||!io(n)){const t=Hy(x,e,r,i,a,A,c,d,v,p,M,$y.horizontal,!1,m,f,l);t&&(g.horizontal[v]=t);}I(_?"left":v);}}let S,P,k,B,z,T,E=!1;const V=h.get("icon-text-fit").evaluate(o,{},s);if(o.icon&&o.icon.hasPrimary()){const e=tx(o.icon,t.iconSizeData,p["icon-size"],s,t.zoom,o,l,d.iconScaleFactor,c);S=e.iconPrimary,k=e.iconSecondary;const r=S.toString();if(P=n.get(r),P&&(z=h.get("icon-offset").evaluate(o,{},s),T=h.get("icon-anchor").evaluate(o,{},s),v=ng(i.get(r),k?i.get(k.toString()):void 0,z,T),E=P.sdf,void 0===t.sdfIcons?t.sdfIcons=P.sdf:t.sdfIcons!==P.sdf&&Xt("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(P.pixelRatio!==t.pixelRatio||0!==h.get("icon-rotate").constantOr(1))&&(t.iconsNeedLinear=!0)),k){const t=k.toString();B=n.get(t);}}A=A||!(!o.icon||!o.icon.hasSecondary());const F=hx(g.horizontal)||g.vertical;t.iconsInText||(t.iconsInText=!!F&&F.iconsInText);const C=m*d.textScaleFactor/xy,{defaultShapedIcon:D,verticallyShapedIcon:R}=ox(t,v,h,o,s,g,C,z,V);"none"!==V&&v&&(sg(v)||og(v))&&(Jg(0,P,S,v,D,V,u,n,i),Jg(0,B,k,v,D,V,u,n,i),R&&(Jg(0,P,S,v,R,V,u,n,i),Jg(0,B,k,v,R,V,u,n,i))),v=D;const{iconBBox:L,iconVerticalBBox:O,textBBox:U,textVerticalBBox:N}=Wg(t,v,R,h,o,s,y,z,d,i,T,g,m,M);I.push({feature:o,shapedTextOrientations:g,shapedText:F,shapedIcon:v,iconPrimary:S,iconSecondary:k,iconOffset:z,iconAnchor:T,verticallyShapedIcon:R,layoutTextSize:m,layoutIconSize:y,textOffset:M,isSDFIcon:E,iconTextFit:V,iconCollisionBounds:L,iconVerticalCollisionBounds:O,textCollisionBounds:U,textVerticalCollisionBounds:N});}return {featureData:I,sizes:d,hasAnySecondaryIcon:A,textAlongLine:w,symbolPlacement:b}},t.fx=Ig,t.fy=function(t,e,r,n,i,s,o,a,l,u){t.iconAtlasPositions=u.iconPositions;const{featureData:c,hasAnySecondaryIcon:h,sizes:p,textAlongLine:d,symbolPlacement:f}=e;for(const e of c){const{shapedIcon:r,verticallyShapedIcon:s,feature:c,shapedTextOrientations:m,shapedText:y,layoutTextSize:g,textOffset:x,isSDFIcon:v,iconPrimary:b,iconSecondary:w,iconTextFit:_,iconOffset:A,iconCollisionBounds:I,iconVerticalCollisionBounds:M,textCollisionBounds:S}=e;rx(r,u.iconPositions,b,w),rx(s,u.iconPositions,b,w),nx(m,u.iconPositions),ex(b,w,u.iconPositions),(y||r)&&ax(t,c,m,r,s,l,p,g,0,x,v,n,i,o,a,h,_,A,d,f,I,M,S);}r&&t.generateCollisionDebugBuffers(s,t.collisionBoxArray,p.textScaleFactor);},t.fz=Cu,t.g=function(t,e){return Le(Object.assign(t,{method:"GET"}),e)},t.h=function(t){return 0===t.indexOf("mapbox:")},t.i=function(t){return oe.API_STYLE_REGEX.test(t)&&!le(t)},t.j=ae,t.k=ke,t.l=function(t){return decodeURIComponent(atob(t).split("").map((t=>"%"+("00"+t.charCodeAt(0).toString(16)).slice(-2))).join(""))},t.m=function(t,e){return Le(Object.assign(t,{type:"json"}),e)},t.n=Ge,t.o=ye,t.p=function(t,e){return Le(Object.assign(t,{method:"POST"}),e)},t.q=Ah,t.r=me,t.s=function(t){try{const e=self[t];return e.setItem("_mapbox_test_",1),e.removeItem("_mapbox_test_"),!0}catch(t){return !1}},t.t=function(){return Yd||(Yd=new Xd("ImageRasterizer")),Yd},t.u=function(){return function t(e){return e?(e^Math.random()*(16>>e/4)).toString(16):([1e7]+-[1e3]+-4e3+-8e3+-1e11).replace(/[018]/g,t)}()},t.v=function(t){return !!t&&/^[0-9a-f]{8}-[0-9a-f]{4}-[4][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i.test(t)},t.w=Xt,t.x=jb,t.y=tr,t.z=Qe;}));

define(["./shared"],(function(e){function t(e){const t=e?e.url.toString():void 0;return t?performance.getEntriesByName(t):[]}function s(e){if("number"==typeof e||"boolean"==typeof e||"string"==typeof e||null==e)return JSON.stringify(e);if(Array.isArray(e)){let t="[";for(const i of e)t+=`${s(i)},`;return `${t}]`}let t="{";for(const i of Object.keys(e).sort())t+=`${i}:${s(e[i])},`;return `${t}}`}function i(t){let i="";for(const o of e.bx)i+=`/${s(t[o])}`;return i}class o{constructor(e){this.keyCache={},this._layers={},this._layerConfigs={},e&&this.replace(e);}replace(e,t){this._layerConfigs={},this._layers={},this.update(e,[],t);}update(t,o,n){this._options=n;for(const s of t)this._layerConfigs[s.id]=s,(this._layers[s.id]=e.du(s,this.scope,null,this._options)).compileFilter(n),this.keyCache[s.id]&&delete this.keyCache[s.id];for(const e of o)delete this.keyCache[e],delete this._layerConfigs[e],delete this._layers[e];this.familiesBySource={};const r=function(e,t){const o={};for(let n=0;n<e.length;n++){const r=e[n];let a=t&&t[r.id];a||("symbol"===r.type?a=r.id:(a=i(r),"line"===r.type&&r.paint&&function e(t){return "string"==typeof t&&"line-progress"===t||(Array.isArray(t)?t.some(e):!(!t||"object"!=typeof t)&&Object.values(t).some(e))}(r.paint["line-width"])&&(a+=`/${s(r.paint["line-width"])}`))),t&&(t[r.id]=a);let l=o[a];l||(l=o[a]=[]),l.push(r);}const n=[];for(const e in o)n.push(o[e]);return n}(Object.values(this._layerConfigs),this.keyCache);for(const e of r){const t=e.map((e=>this._layers[e.id])),s=t[0];if("none"===s.visibility)continue;const i=s.source||"";let o=this.familiesBySource[i];o||(o=this.familiesBySource[i]={});const n=s.sourceLayer||"_geojsonTileLayer";let r=o[n];r||(r=o[n]=[]),r.push(t);}}}const n=1*e.fl;class r{constructor(t){const s={},i=[];for(const e in t){const o=t[e],r=s[e]={};for(const e in o.glyphs){const t=o.glyphs[+e];if(!t||0===t.bitmap.width||0===t.bitmap.height)continue;const s=t.metrics.localGlyph?n:1,a={x:0,y:0,w:t.bitmap.width+2*s,h:t.bitmap.height+2*s};i.push(a),r[e]=a;}}const{w:o,h:r}=e.G(i),a=new e.fk({width:o||1,height:r||1});for(const i in t){const o=t[i];for(const t in o.glyphs){const r=o.glyphs[+t];if(!r||0===r.bitmap.width||0===r.bitmap.height)continue;const l=s[i][t],c=r.metrics.localGlyph?n:1;e.fk.copy(r.bitmap,a,{x:0,y:0},{x:l.x+c,y:l.y+c},r.bitmap);}}this.image=a,this.positions=s;}}function a(e,t,s){e[t]?s&&(e[t].center=s):e[t]={floorIds:new Set,center:s||[0,0],floors:{}};}function l(e,t,s,i){for(const o of t)a(e,o),e[o].floors[s]=i,e[o].floorIds.add(s);}function c(e){return {id:e.properties.id.toString(),center:e.properties.center.toString().split(";").map(Number)}}function h(e){return {id:e.properties.id.toString(),isDefault:!!e.properties.is_default&&e.properties.is_default,connections:e.properties.connected_floor_ids?new Set(e.properties.connected_floor_ids.toString().split(";")):new Set,conflicts:e.properties.conflicted_floor_ids?new Set(e.properties.conflicted_floor_ids.toString().split(";")):new Set,buildings:e.properties.building_ids?new Set(e.properties.building_ids.toString().split(";")):new Set,name:e.properties.name.toString(),zIndex:e.properties.z_index}}function u(e,t){return t.every((t=>e.properties&&null!=e.properties[t]))}function d(e){return u(e,["type","id","name"])&&"building"===e.properties.type}function f(e){return u(e,["type","id","name","z_index"])&&"floor"===e.properties.type}e.fj(r,"GlyphAtlas");class p{constructor(t){this.tileID=new e.aQ(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.tileZoom=t.tileZoom,this.uid=t.uid,this.zoom=t.zoom,this.lut=t.lut,this.canonical=t.tileID.canonical,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.scope=t.scope,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.request&&t.request.collectResourceTiming,this.promoteId=t.promoteId,this.isSymbolTile=t.isSymbolTile,this.tileTransform=e.aZ(t.tileID.canonical,t.projection),this.projection=t.projection,this.worldview=t.worldview,this.localizableLayerIds=t.localizableLayerIds,this.brightness=t.brightness,this.extraShadowCaster=!!t.extraShadowCaster,this.tessellationStep=t.tessellationStep,this.scaleFactor=t.scaleFactor,this.worldview=t.worldview,this.indoor=t.indoor;}parse(t,s,i,o,n,u){this.status="parsing",this.data=t,this.collisionBoxArray=new e.b3;const p=new e.fm(Object.keys(t.layers).sort()),m=new e.fn(this.tileID,this.promoteId);m.bucketLayerIDs=[];const y={},w=new e.fo(256,256),b={featureIndex:m,iconDependencies:new Map,patternDependencies:new Map,glyphDependencies:{},lineAtlas:w,availableImages:i,brightness:this.brightness,scaleFactor:this.scaleFactor,elevationFeatures:void 0,activeFloors:void 0};if(this.indoor){const s=this.indoor.indoorState.activeFloorsVisible,i=function(t,s,i){const o=function(t,s){if(!t)return e.w("No source layers defined in indoor specification"),s;if(0===t.size)return s;const i=t.difference(s);for(const t of i)e.w(`Missing source layer required in indoor specification: ${t}`);return s.intersection(s)}(s.sourceLayers,new Set(Object.keys(t.layers))),n=s.indoorState,r=function(t,s,i,o){const n=new Set,r=new Set,u=new Set,p=new Map,g={},m=e=>{const t=p.get(e)||new Set;for(const s of n)if((p.get(s)||new Set).has(e)||t.has(s))return !0;return !1};for(const i of s){const s=t.layers[i];if(s)for(let e=0;e<s.length;e++){const t=s.feature(e);if(d(t)){const{id:e,center:s}=c(t);a(g,e,s),n.add(e);}else if(f(t)){const{id:e,isDefault:s,connections:i,conflicts:a,buildings:c,name:d,zIndex:f}=h(t);l(g,c,e,{name:d,zIndex:f}),p.set(e,a),(e===o||i.has(o))&&n.add(e),r.add(e),s&&u.add(e);}}else e.w(`indoor source layer not found: ${i}`);}if(i)for(const e of i)r.has(e)&&(m(e)||n.add(e));for(const e of u)n.has(e)||m(e)||n.add(e);return {buildings:g,activeFloors:n}}(t,o,n.lastActiveFloors,n.selectedFloorId);return i.send("setIndoorData",r),r}(t,this.indoor,n);b.activeFloors=s?i.activeFloors:void 0;}const x=[],v=s.familiesBySource[this.source];for(const s in v){const n=t.layers[s];if(!n)continue;let r=!1,a=!1,l=!1;for(const e of v[s])"symbol"===e[0].type?r=!0:a=!0,e[0].is3D()&&"model"!==e[0].type&&(l=!0);if(this.extraShadowCaster&&!l)continue;if(!0===this.isSymbolTile&&!r)continue;if(!1===this.isSymbolTile&&!a)continue;1===n.version&&e.w(`Vector tile source "${this.source}" layer "${s}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const c=p.encode(s),h=[],u=this.localizableLayerIds&&this.localizableLayerIds.has(s);let d=!1;for(let t=0,i=0;t<n.length;t++){const o=n.feature(t),r=m.getId(o,s),a=o.properties?o.properties.worldview:null;if(u&&this.worldview&&"string"==typeof a)if("all"===a)o.properties.$localized=!0;else {if(!a.split(",").includes(this.worldview))continue;o.properties.$localized=!0,o.properties.worldview=this.worldview;}!d&&o.properties&&o.properties.hasOwnProperty(e.fp)&&(d=!0),h.push({feature:o,id:r,index:i,sourceLayerIndex:c}),i++;}d&&!b.elevationFeatures&&t.layers.hasOwnProperty(e.fq)&&(b.elevationFeatures=e.fr.parseFrom(t.layers[e.fq],this.canonical));for(const t of v[s]){const s=t[0];if(this.extraShadowCaster&&(!s.is3D()||"model"===s.type))continue;if(void 0!==this.isSymbolTile&&"symbol"===s.type!==this.isSymbolTile)continue;if(s.minzoom&&this.zoom<Math.floor(s.minzoom))continue;if(s.maxzoom&&this.zoom>=s.maxzoom)continue;if("none"===s.visibility)continue;g(t,this.zoom,b.brightness,i,this.worldview);const n=y[s.id]=s.createBucket({index:m.bucketLayerIDs.length,layers:t,zoom:this.zoom,lut:this.lut,canonical:this.canonical,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:c,sourceID:this.source,projection:this.projection.spec,tessellationStep:this.tessellationStep,styleDefinedModelURLs:o,worldview:this.worldview,localizable:u});m.bucketLayerIDs.push(t.map((t=>e.B(t.id,t.scope))));let r=n.prepare?n.prepare():null;null!=r?(r=r.then((()=>n.populate(h,b,this.tileID.canonical,this.tileTransform))),x.push(r)):n.populate(h,b,this.tileID.canonical,this.tileTransform);}}const I=()=>{let s,o,a,l,c,h;w.trim();const d={type:"maybePrepare",isSymbolTile:this.isSymbolTile,zoom:this.zoom},f=()=>{if(s)return this.status="done",u(s);if(this.extraShadowCaster)this.status="done",u(null,{buckets:Object.values(y).filter((e=>!e.isEmpty())),featureIndex:m,collisionBoxArray:null,glyphAtlasImage:null,lineAtlas:null,imageAtlas:null,brightness:b.brightness,glyphMap:null,iconMap:null,glyphPositions:null});else if(o&&a&&l){const t=new r(o),s=new Map;for(const[t,i]of a.entries()){const{imagePosition:o}=e.fu(t,i,e.fv);s.set(t,o);}const u={};for(const n in y){const r=y[n];r instanceof e.b4&&(g(r.layers,this.zoom,b.brightness,i,this.worldview),u[n]=e.fw(r,o,t.positions,a,s,this.tileID.canonical,this.tileZoom,this.scaleFactor,this.pixelRatio,c,this.worldview));}const d={iconsPending:!0,patternsPending:!0};this.rasterizeIfNeeded(n,a,c,(()=>{d.iconsPending=!1,x(u,t,d);})),this.rasterizeIfNeeded(n,l,h,(()=>{d.patternsPending=!1,x(u,t,d);}));}},x=(t,s,o,n)=>{if(o.iconsPending||o.patternsPending)return;const r=new e.fx(a,l,this.lut);for(const s in y){const o=y[s];if(s in t)e.fy(o,t[s],this.showCollisionBoxes,i,this.tileID.canonical,this.tileZoom,this.projection,this.brightness,a,r);else if(o.hasPattern&&(o instanceof e.ba||o instanceof e.bb||o instanceof e.ea)){g(o.layers,this.zoom,b.brightness,i,this.worldview);const e=Object.fromEntries(r.patternPositions);o.addFeatures(b,this.tileID.canonical,e,i,this.tileTransform,this.brightness);}}this.status="done",u(null,{buckets:Object.values(y).filter((e=>!e.isEmpty())),featureIndex:m,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:s.image,lineAtlas:w,imageAtlas:r,brightness:b.brightness});};if(!this.extraShadowCaster){const t=e.fs(b.glyphDependencies,(e=>Object.keys(e).map(Number)));Object.keys(t).length?n.send("getGlyphs",{uid:this.uid,stacks:t},((e,t)=>{s||(s=e,o=t,f());}),void 0,!1,d):o={};const i=Array.from(b.iconDependencies.keys()).map((t=>e.I.parse(t)));i.length?n.send("getImages",{images:i,source:this.source,scope:this.scope,tileID:this.tileID,type:"icons"},((e,t)=>{s||(s=e,a=new Map,c=this.updateImageMapAndGetImageTaskQueue(a,t,b.iconDependencies),f());}),void 0,!1,d):(a=new Map,c=new Map);const r=Array.from(b.patternDependencies.keys()).map((t=>e.I.parse(t)));r.length?n.send("getImages",{images:r,source:this.source,scope:this.scope,tileID:this.tileID,type:"patterns"},((e,t)=>{s||(s=e,l=new Map,h=this.updateImageMapAndGetImageTaskQueue(l,t,b.patternDependencies),f());}),void 0,!1,d):(l=new Map,h=new Map);}if(b.elevationFeatures&&b.elevationFeatures.length>0){const s=[];for(const t of Object.values(y))if(t instanceof e.bb){const e=t.getUnevaluatedPortalGraph();e&&s.push(e);}const i=e.ft.evaluate(s);for(const s of Object.values(y))if(s instanceof e.bb){const e=t.layers[p.decode(s.sourceLayerIndex)];s.setEvaluatedPortalGraph(i,e,this.tileID.canonical,b.availableImages,b.brightness);}}f();};x.length>0?Promise.allSettled(x).then(I).catch(u):I();}updateParameters(t){this.scaleFactor=t.scaleFactor,this.showCollisionBoxes=t.showCollisionBoxes,this.projection=t.projection,this.brightness=t.brightness,this.tileTransform=e.aZ(t.tileID.canonical,t.projection),this.extraShadowCaster=t.extraShadowCaster,this.lut=t.lut,this.worldview=t.worldview,this.indoor=t.indoor;}rasterizeIfNeeded(e,t,s,i){Array.from(t.values()).some((e=>e.usvg))?this.rasterize(e,t,s,i):i();}updateImageMapAndGetImageTaskQueue(e,t,s){const i=new Map;for(const o of t.keys()){const n=s.get(o)||[];for(const s of n){const o=s.toString(),n=t.get(s.id.toString());n.usvg?i.has(o)||(i.set(o,s),e.set(o,Object.assign({},n))):e.set(o,n);}}return i}rasterize(e,t,s,i){this.rasterizeTask=e.send("rasterizeImages",{scope:this.scope,tasks:s},((e,s)=>{if(!e)for(const[e,i]of s.entries()){const s=Object.assign(t.get(e),{data:i});t.set(e,s);}i();}));}cancelRasterize(){this.rasterizeTask&&this.rasterizeTask.cancel();}}function g(t,s,i,o,n){const r=new e.ac(s,{brightness:i,worldview:n});for(const e of t)e.recalculate(r,o);}class m extends e.E{constructor(t,s,i,o,n,r,a){super(),this.actor=t,this.layerIndex=s,this.availableImages=i,this.availableModels=o,this.loadVectorData=r||e.aL,this.loading={},this.loaded={},this.deduped=new e.aK(t.scheduler),this.isSpriteLoaded=n,this.scheduler=t.scheduler,this.brightness=a;}loadTile(s,i){const o=s.uid,n=s&&s.request,r=n&&n.collectResourceTiming,a=this.loading[o]=new p(s);a.abort=this.loadVectorData(s,((l,c)=>{const h=!this.loading[o];if(delete this.loading[o],a.cancelRasterize(),h||l||!c)return a.status="done",h||(this.loaded[o]=a),i(l);const u=c.rawData,d={},f=e.aM(c.responseHeaders);f&&f.expires&&(d.expires=f.expires),f&&f.cacheControl&&(d.cacheControl=f.cacheControl),a.vectorTile=c.vectorTile||new e.fz(new e.bt(u));const p=()=>{a.parse(a.vectorTile,this.layerIndex,this.availableImages,this.availableModels,this.actor,((e,s)=>{if(e||!s)return i(e);const o={};if(r){const e=t(n);e.length>0&&(o.resourceTiming=JSON.parse(JSON.stringify(e)));}i(null,Object.assign({rawTileData:u.slice(0),responseHeaders:c.responseHeaders},s,d,o));}));};this.isSpriteLoaded?p():this.once("isSpriteLoaded",(()=>{this.scheduler?this.scheduler.add(p,{type:"parseTile",isSymbolTile:s.isSymbolTile,zoom:s.tileZoom}):p();})),this.loaded=this.loaded||{},this.loaded[o]=a;}));}reloadTile(e,t){const s=this.loaded,i=e.uid;if(s&&s[i]){const o=s[i];o.updateParameters(e);const n=(e,s)=>{const i=o.reloadCallback;i&&(delete o.reloadCallback,o.parse(o.vectorTile,this.layerIndex,this.availableImages,this.availableModels,this.actor,i)),t(e,s);};"parsing"===o.status?o.reloadCallback=n:"done"===o.status&&(o.vectorTile?o.parse(o.vectorTile,this.layerIndex,this.availableImages,this.availableModels,this.actor,n):n());}else t(null,void 0);}abortTile(e,t){const s=e.uid,i=this.loading[s];i&&(i.abort&&i.abort(),delete this.loading[s]),t();}removeTile(e,t){const s=this.loaded,i=e.uid;s&&s[i]&&delete s[i],t();}}class y{loadTile(t,s){const{uid:i,encoding:o,rawImageData:n,padding:r}=t,a=ImageBitmap&&n instanceof ImageBitmap?this.getImageData(n,r):n;s(null,new e.fA(i,a,o,r<1));}reloadTile(e,t){t(null,null);}abortTile(e,t){t();}removeTile(e,t){t();}getImageData(e,t){this.offscreenCanvas&&this.offscreenCanvasContext||(this.offscreenCanvas=new OffscreenCanvas(e.width,e.height),this.offscreenCanvasContext=this.offscreenCanvas.getContext("2d",{willReadFrequently:!0})),this.offscreenCanvas.width=e.width,this.offscreenCanvas.height=e.height,this.offscreenCanvasContext.drawImage(e,0,0,e.width,e.height);const s=this.offscreenCanvasContext.getImageData(-t,-t,e.width+2*t,e.height+2*t);return this.offscreenCanvasContext.clearRect(0,0,this.offscreenCanvas.width,this.offscreenCanvas.height),s}}e.bs.setPbf(e.bt);class w{constructor(t){this._mrt=new e.bs(t.partial?30:1/0),this._isHeaderLoaded=!1,this.uid=t.uid,this.tileID=t.tileID,this.source=t.source;}parse(t,s){const i=this._mrt;this.status="parsing",this._entireBuffer=t;try{i.parseHeader(t),this._isHeaderLoaded=!0;const o=[];for(const s in i.layers){const n=i.getLayer(s),r=n.getDataRange(n.getBandList()),a=i.createDecodingTask(r),l=t.slice(r.firstByte,r.lastByte+1),c=e.bs.performDecoding(l,a).then((e=>a.complete(null,e))).catch((e=>a.complete(e,null)));o.push(c);}Promise.allSettled(o).then((()=>s(null,i))).catch((e=>s(e)));}catch(e){s(e);}}}class b{constructor(e){this.actor=e,this.loading={},this.loaded={};}loadTile(t,s){const i=t.uid,o=t.request,n=this.loading[i]=new w(t),{cancel:r}=e.bu(o,((e,t,o)=>{const r=!this.loading[i];if(delete this.loading[i],r||e||!t)return n.status="done",r||(this.loaded[i]=n),s(e);n.parse(t,((e,t)=>{if(e||!t)return s(e);s(null,t,o);})),this.loaded[i]=n;}));n.abort=r;}reloadTile(e,t){t(null,void 0);}abortTile(e,t){const s=e.uid,i=this.loading[s];i&&(i.abort&&i.abort(),delete this.loading[s]),t();}removeTile(e,t){const s=e.uid;this.loaded[s]&&delete this.loaded[s],t();}decodeRasterArray(t,s){e.bs.performDecoding(t.buffer,t.task).then((e=>s(null,e))).catch((e=>s(e)));}}const x=e.fB.prototype.toGeoJSON;class v{constructor(t){this._feature=t,this.extent=e.al,this.type=t.type,this.properties=t.tags,"id"in t&&!isNaN(t.id)&&(this.id=parseInt(t.id,10));}loadGeometry(){if(1===this._feature.type){const t=[];for(const s of this._feature.geometry)t.push([new e.P(s[0],s[1])]);return t}{const t=[];for(const s of this._feature.geometry){const i=[];for(const t of s)i.push(new e.P(t[0],t[1]));t.push(i);}return t}}toGeoJSON(e,t,s){return x.call(this,e,t,s)}}class I{constructor(t,s){this.name=t,this.extent=e.al,this.length=s.length,this._jsonFeatures=s;}feature(e){return new v(this._jsonFeatures[e])}}class S{constructor(t){this.layers={},this.extent=e.al;for(const e of Object.keys(t))this.layers[e]=new I(e,t[e]);}}const M=64/4096,P=128;class T{constructor(){this.features=new Map;}clear(){this.features.clear();}load(e=[],t){for(const s of e){const e=s.id;if(null==e)continue;let i=this.features.get(e);i&&this.updateCache(i,t),s.geometry?(i=k(s),this.updateCache(i,t),this.features.set(e,i)):this.features.delete(e),this.updateCache(i,t);}}updateCache(e,t){for(const{canonical:s,uid:i}of Object.values(t)){const{z:o,x:n,y:r}=s;_(e,Math.pow(2,o),n,r)&&delete t[i];}}getTile(e,t,s){const i=Math.pow(2,e),o=[];for(const e of this.features.values())_(e,i,t,s)&&o.push(D(e,i,t,s));return {features:o}}getFeatures(){return [...this.features.values()]}}function _({minX:e,minY:t,maxX:s,maxY:i},o,n,r){return e<(n+1+M)/o&&t<(r+1+M)/o&&s>(n-M)/o&&i>(r-M)/o}function k(e){const{id:t,geometry:s,properties:i}=e;if(!s)return;if("GeometryCollection"===s.type)throw new Error("GeometryCollection not supported in dynamic mode.");const{type:o,coordinates:n}=s,r={id:t,type:1,geometry:[],tags:i,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0},a=r.geometry;if("Point"===o)L(n,a,r);else if("MultiPoint"===o)for(const e of n)L(e,a,r);else if("LineString"===o)r.type=2,z(n,a,r);else if("MultiLineString"===o)r.type=2,C(n,a,r);else if("Polygon"===o)r.type=3,C(n,a,r,!0);else {if("MultiPolygon"!==o)throw new Error("Input data is not a valid GeoJSON object.");r.type=3;for(const e of n)C(e,a,r,!0);}return r}function L([t,s],i,o){const n=e.aF(t);let r=e.aJ(s);r=r<0?0:r>1?1:r,i.push(n,r),o.minX=Math.min(o.minX,n),o.minY=Math.min(o.minY,r),o.maxX=Math.max(o.maxX,n),o.maxY=Math.max(o.maxY,r);}function z(e,t,s,i=!1,o=!1){const n=[];for(const t of e)L(t,n,s);t.push(n),i&&function(e,t){let s=0;for(let t=0,i=e.length,o=i-2;t<i;o=t,t+=2)s+=(e[t]-e[o])*(e[t+1]+e[o+1]);if(s>0===t)for(let t=0,s=e.length;t<s/2;t+=2){const i=e[t],o=e[t+1];e[t]=e[s-2-t],e[t+1]=e[s-1-t],e[s-2-t]=i,e[s-1-t]=o;}}(n,o);}function C(e,t,s,i=!1){for(let o=0;o<e.length;o++)z(e[o],t,s,i,0===o);}function D(t,s,i,o){const{id:n,type:r,geometry:a,tags:l}=t,c=[];if(1===r)!function(t,s,i,o,n){for(let r=0;r<t.length;r+=2){const a=Math.round(e.al*(t[r+0]*s-i)),l=Math.round(e.al*(t[r+1]*s-o));n.push([a,l]);}}(a,s,i,o,c);else if(2===r)for(const e of a)j(e,s,i,o,c);else if(3===r)for(const e of a)O(e,s,i,o,c);return {id:n,type:r,geometry:c,tags:l}}function j(t,s,i,o,n){const r=-P,a=e.al+P;let l;for(let c=0;c<t.length-2;c+=2){let h=Math.round(e.al*(t[c+0]*s-i)),u=Math.round(e.al*(t[c+1]*s-o)),d=Math.round(e.al*(t[c+2]*s-i)),f=Math.round(e.al*(t[c+3]*s-o));const p=d-h,g=f-u;h<r&&d<r||(h<r?(u+=Math.round(g*((r-h)/p)),h=r):d<r&&(f=u+Math.round(g*((r-h)/p)),d=r),u<r&&f<r||(u<r?(h+=Math.round(p*((r-u)/g)),u=r):f<r&&(d=h+Math.round(p*((r-u)/g)),f=r),h>=a&&d>=a||(h>=a?(u+=Math.round(g*((a-h)/p)),h=a):d>=a&&(f=u+Math.round(g*((a-h)/p)),d=a),u>=a&&f>=a||(u>=a?(h+=Math.round(p*((a-u)/g)),u=a):f>=a&&(d=h+Math.round(p*((a-u)/g)),f=a),l&&h===l[l.length-1][0]&&u===l[l.length-1][1]||(l=[[h,u]],n.push(l)),l.push([d,f])))));}}function O(t,s,i,o,n){const r=(i-M)/s,a=(o-M)/s,l=(i+1+M)/s,c=(o+1+M)/s;function h(e,t){let s=0;return e<r?s|=1:e>l&&(s|=2),t<a?s|=4:t>c&&(s|=8),s}let u=[];for(let e=1;e<=8;e*=2){let s=t[t.length-2],i=t[t.length-1],o=!(h(s,i)&e);for(let n=0;n<t.length;n+=2){const d=t[n],f=t[n+1],p=!(h(d,f)&e);p!==o&&(8&e?u.push(s+(d-s)*(c-i)/(f-i),c):4&e?u.push(s+(d-s)*(a-i)/(f-i),a):2&e?u.push(l,i+(f-i)*(l-s)/(d-s)):1&e&&u.push(r,i+(f-i)*(r-s)/(d-s))),p&&u.push(d,f),s=d,i=f,o=p;}if(!(t=u).length||8===e)break;u=[];}const d=[];for(let t=0;t<u.length;t+=2)d.push([Math.round(e.al*(u[t]*s-i)),Math.round(e.al*(u[t+1]*s-o))]);n.push(d);}function F({name:t,features:s},i){i.writeStringField(1,t),i.writeVarintField(5,e.al);const o=new Map,n=new Map,r={keys:o,values:n,feature:null};for(const e of s)r.feature=e,i.writeMessage(2,A,r);for(const e of o.keys())i.writeStringField(3,e);for(const e of n.keys())i.writeMessage(4,R,e);}function A(e,t){const s=e.feature;void 0!==s.id&&Number.isSafeInteger(+s.id)&&t.writeVarintField(1,+s.id),s.tags&&t.writeMessage(2,Z,e),t.writeVarintField(3,s.type),t.writeMessage(4,E,s);}function Z({keys:e,values:t,feature:s},i){for(const o of Object.keys(s.tags)){let n=s.tags[o];if(null===n)continue;let r=e.get(o);void 0===r&&(r=e.size,e.set(o,r)),i.writeVarint(r);const a=typeof n;"string"!==a&&"boolean"!==a&&"number"!==a&&(n=JSON.stringify(n));let l=t.get(n);void 0===l&&(l=t.size,t.set(n,l)),i.writeVarint(l);}}function B(e,t){return (t<<3)+(7&e)}function N(e){return e<<1^e>>31}function E(e,t){const{geometry:s,type:i}=e;let o=0,n=0;if(1===i){t.writeVarint(B(1,s.length));for(const e of s){const s=e[0]-o,i=e[1]-n;t.writeVarint(N(s)),t.writeVarint(N(i)),o+=s,n+=i;}}else for(const e of s){t.writeVarint(B(1,1));const s=e.length-(3===i?1:0);for(let i=0;i<s;i++){1===i&&t.writeVarint(B(2,s-1));const r=e[i][0]-o,a=e[i][1]-n;t.writeVarint(N(r)),t.writeVarint(N(a)),o+=r,n+=a;}3===i&&t.writeVarint(B(7,1));}}function R(e,t){const s=typeof e;"string"===s?t.writeStringField(1,e):"boolean"===s?t.writeBooleanField(7,e):"number"===s&&(e%1!=0?t.writeDoubleField(3,e):e<0?t.writeSVarintField(6,e):t.writeVarintField(5,e));}const Y={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:e=>e},X=Math.fround||(J=new Float32Array(1),e=>(J[0]=+e,J[0]));var J;const G=3,H=5,$=6;class V{constructor(e){this.options=Object.assign(Object.create(Y),e),this.trees=new Array(this.options.maxZoom+1),this.stride=this.options.reduce?7:6,this.clusterProps=[];}load(e){const{log:t,minZoom:s,maxZoom:i}=this.options;t&&console.time("total time");const o=`prepare ${e.length} points`;t&&console.time(o),this.points=e;const n=[];for(let t=0;t<e.length;t++){const s=e[t];if(!s.geometry)continue;const[i,o]=s.geometry.coordinates,r=X(W(i)),a=X(Q(o));n.push(r,a,1/0,t,-1,1),this.options.reduce&&n.push(0);}let r=this.trees[i+1]=this._createTree(n);t&&console.timeEnd(o);for(let e=i;e>=s;e--){const s=+Date.now();r=this.trees[e]=this._createTree(this._cluster(r,e)),t&&console.log("z%d: %d clusters in %dms",e,r.numItems,+Date.now()-s);}return t&&console.timeEnd("total time"),this}getClusters(e,t){let s=((e[0]+180)%360+360)%360-180;const i=Math.max(-90,Math.min(90,e[1]));let o=180===e[2]?180:((e[2]+180)%360+360)%360-180;const n=Math.max(-90,Math.min(90,e[3]));if(e[2]-e[0]>=360)s=-180,o=180;else if(s>o){const e=this.getClusters([s,i,180,n],t),r=this.getClusters([-180,i,o,n],t);return e.concat(r)}const r=this.trees[this._limitZoom(t)],a=r.range(W(s),Q(n),W(o),Q(i)),l=r.data,c=[];for(const e of a){const t=this.stride*e;c.push(l[t+H]>1?U(l,t,this.clusterProps):this.points[l[t+G]]);}return c}getChildren(e){const t=this._getOriginId(e),s=this._getOriginZoom(e),i="No cluster with the specified id.",o=this.trees[s];if(!o)throw new Error(i);const n=o.data;if(t*this.stride>=n.length)throw new Error(i);const r=this.options.radius/(this.options.extent*Math.pow(2,s-1)),a=o.within(n[t*this.stride],n[t*this.stride+1],r),l=[];for(const t of a){const s=t*this.stride;n[s+4]===e&&l.push(n[s+H]>1?U(n,s,this.clusterProps):this.points[n[s+G]]);}if(0===l.length)throw new Error(i);return l}getLeaves(e,t,s){const i=[];return this._appendLeaves(i,e,t=t||10,s=s||0,0),i}getTile(e,t,s){const i=this.trees[this._limitZoom(e)],o=Math.pow(2,e),{extent:n,radius:r}=this.options,a=r/n,l=(s-a)/o,c=(s+1+a)/o,h={features:[]};return this._addTileFeatures(i.range((t-a)/o,l,(t+1+a)/o,c),i.data,t,s,o,h),0===t&&this._addTileFeatures(i.range(1-a/o,l,1,c),i.data,o,s,o,h),t===o-1&&this._addTileFeatures(i.range(0,l,a/o,c),i.data,-1,s,o,h),h.features.length?h:null}getClusterExpansionZoom(e){let t=this._getOriginZoom(e)-1;for(;t<=this.options.maxZoom;){const s=this.getChildren(e);if(t++,1!==s.length)break;e=s[0].properties.cluster_id;}return t}_appendLeaves(e,t,s,i,o){const n=this.getChildren(t);for(const t of n){const n=t.properties;if(n&&n.cluster?o+n.point_count<=i?o+=n.point_count:o=this._appendLeaves(e,n.cluster_id,s,i,o):o<i?o++:e.push(t),e.length===s)break}return o}_createTree(t){const s=new e.c4(t.length/this.stride|0,this.options.nodeSize,Float32Array);for(let e=0;e<t.length;e+=this.stride)s.add(t[e],t[e+1]);return s.finish(),s.data=t,s}_addTileFeatures(e,t,s,i,o,n){for(const r of e){const e=r*this.stride,a=t[e+H]>1;let l,c,h;if(a)l=q(t,e,this.clusterProps),c=t[e],h=t[e+1];else {const s=this.points[t[e+G]];l=s.properties;const[i,o]=s.geometry.coordinates;c=W(i),h=Q(o);}const u={type:1,geometry:[[Math.round(this.options.extent*(c*o-s)),Math.round(this.options.extent*(h*o-i))]],tags:l};let d;d=a||this.options.generateId?t[e+G]:this.points[t[e+G]].id,void 0!==d&&(u.id=d),n.features.push(u);}}_limitZoom(e){return Math.max(this.options.minZoom,Math.min(Math.floor(+e),this.options.maxZoom+1))}_cluster(e,t){const{radius:s,extent:i,reduce:o,minPoints:n}=this.options,r=s/(i*Math.pow(2,t)),a=e.data,l=[],c=this.stride;for(let s=0;s<a.length;s+=c){if(a[s+2]<=t)continue;a[s+2]=t;const i=a[s],h=a[s+1],u=e.within(a[s],a[s+1],r),d=a[s+H];let f=d;for(const e of u){const s=e*c;a[s+2]>t&&(f+=a[s+H]);}if(f>d&&f>=n){let e,n=i*d,r=h*d,p=-1;const g=(s/c<<5)+(t+1)+this.points.length;for(const i of u){const l=i*c;if(a[l+2]<=t)continue;a[l+2]=t;const h=a[l+H];n+=a[l]*h,r+=a[l+1]*h,a[l+4]=g,o&&(e||(e=this._map(a,s,!0),p=this.clusterProps.length,this.clusterProps.push(e)),o(e,this._map(a,l)));}a[s+4]=g,l.push(n/f,r/f,1/0,g,-1,f),o&&l.push(p);}else {for(let e=0;e<c;e++)l.push(a[s+e]);if(f>1)for(const e of u){const s=e*c;if(!(a[s+2]<=t)){a[s+2]=t;for(let e=0;e<c;e++)l.push(a[s+e]);}}}}return l}_getOriginId(e){return e-this.points.length>>5}_getOriginZoom(e){return (e-this.points.length)%32}_map(e,t,s){if(e[t+H]>1){const i=this.clusterProps[e[t+$]];return s?Object.assign({},i):i}const i=this.points[e[t+G]].properties,o=this.options.map(i);return s&&o===i?Object.assign({},o):o}}function U(e,t,s){return {type:"Feature",id:e[t+G],properties:q(e,t,s),geometry:{type:"Point",coordinates:[(i=e[t],360*(i-.5)),K(e[t+1])]}};var i;}function q(e,t,s){const i=e[t+H],o=i>=1e4?`${Math.round(i/1e3)}k`:i>=1e3?Math.round(i/100)/10+"k":i,n=e[t+$],r=-1===n?{}:Object.assign({},s[n]);return Object.assign(r,{cluster:!0,cluster_id:e[t+G],point_count:i,point_count_abbreviated:o})}function W(e){return e/360+.5}function Q(e){const t=Math.sin(e*Math.PI/180),s=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return s<0?0:s>1?1:s}function K(e){const t=(180-360*e)*Math.PI/180;return 360*Math.atan(Math.exp(t))/Math.PI-90}function ee(e,t,s,i){let o=i;const n=t+(s-t>>1);let r,a=s-t;const l=e[t],c=e[t+1],h=e[s],u=e[s+1];for(let i=t+3;i<s;i+=3){const t=te(e[i],e[i+1],l,c,h,u);if(t>o)r=i,o=t;else if(t===o){const e=Math.abs(i-n);e<a&&(r=i,a=e);}}o>i&&(r-t>3&&ee(e,t,r,i),e[r+2]=o,s-r>3&&ee(e,r,s,i));}function te(e,t,s,i,o,n){let r=o-s,a=n-i;if(0!==r||0!==a){const l=((e-s)*r+(t-i)*a)/(r*r+a*a);l>1?(s=o,i=n):l>0&&(s+=r*l,i+=a*l);}return r=e-s,a=t-i,r*r+a*a}function se(e,t,s,i){const o={id:e??null,type:t,geometry:s,tags:i,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};if("Point"===t||"MultiPoint"===t||"LineString"===t)ie(o,s);else if("Polygon"===t)ie(o,s[0]);else if("MultiLineString"===t)for(const e of s)ie(o,e);else if("MultiPolygon"===t)for(const e of s)ie(o,e[0]);return o}function ie(e,t){for(let s=0;s<t.length;s+=3)e.minX=Math.min(e.minX,t[s]),e.minY=Math.min(e.minY,t[s+1]),e.maxX=Math.max(e.maxX,t[s]),e.maxY=Math.max(e.maxY,t[s+1]);}function oe(e,t,s,i){if(!t.geometry)return;const o=t.geometry.coordinates;if(o&&0===o.length)return;const n=t.geometry.type,r=Math.pow(s.tolerance/((1<<s.maxZoom)*s.extent),2);let a=[],l=t.id;if(s.promoteId?l=t.properties[s.promoteId]:s.generateId&&(l=i||0),"Point"===n)ne(o,a);else if("MultiPoint"===n)for(const e of o)ne(e,a);else if("LineString"===n)re(o,a,r,!1);else if("MultiLineString"===n){if(s.lineMetrics){for(const s of o)a=[],re(s,a,r,!1),e.push(se(l,"LineString",a,t.properties));return}ae(o,a,r,!1);}else if("Polygon"===n)ae(o,a,r,!0);else {if("MultiPolygon"!==n){if("GeometryCollection"===n){for(const o of t.geometry.geometries)oe(e,{id:l,geometry:o,properties:t.properties},s,i);return}throw new Error("Input data is not a valid GeoJSON object.")}for(const e of o){const t=[];ae(e,t,r,!0),a.push(t);}}e.push(se(l,n,a,t.properties));}function ne(e,t){t.push(le(e[0]),ce(e[1]),0);}function re(e,t,s,i){let o,n,r=0;for(let s=0;s<e.length;s++){const a=le(e[s][0]),l=ce(e[s][1]);t.push(a,l,0),s>0&&(r+=i?(o*l-a*n)/2:Math.sqrt(Math.pow(a-o,2)+Math.pow(l-n,2))),o=a,n=l;}const a=t.length-3;t[2]=1,ee(t,0,a,s),t[a+2]=1,t.size=Math.abs(r),t.start=0,t.end=t.size;}function ae(e,t,s,i){for(let o=0;o<e.length;o++){const n=[];re(e[o],n,s,i),t.push(n);}}function le(e){return e/360+.5}function ce(e){const t=Math.sin(e*Math.PI/180),s=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return s<0?0:s>1?1:s}function he(e,t,s,i,o,n,r,a){if(i/=t,n>=(s/=t)&&r<i)return e;if(r<s||n>=i)return null;const l=[];for(const t of e){const e=t.geometry;let n=t.type;const r=0===o?t.minX:t.minY,c=0===o?t.maxX:t.maxY;if(r>=s&&c<i){l.push(t);continue}if(c<s||r>=i)continue;let h=[];if("Point"===n||"MultiPoint"===n)ue(e,h,s,i,o);else if("LineString"===n)de(e,h,s,i,o,!1,a.lineMetrics);else if("MultiLineString"===n)pe(e,h,s,i,o,!1);else if("Polygon"===n)pe(e,h,s,i,o,!0);else if("MultiPolygon"===n)for(const t of e){const e=[];pe(t,e,s,i,o,!0),e.length&&h.push(e);}if(h.length){if(a.lineMetrics&&"LineString"===n){for(const e of h)l.push(se(t.id,n,e,t.tags));continue}"LineString"!==n&&"MultiLineString"!==n||(1===h.length?(n="LineString",h=h[0]):n="MultiLineString"),"Point"!==n&&"MultiPoint"!==n||(n=3===h.length?"Point":"MultiPoint"),l.push(se(t.id,n,h,t.tags));}}return l.length?l:null}function ue(e,t,s,i,o){for(let n=0;n<e.length;n+=3){const r=e[n+o];r>=s&&r<=i&&ge(t,e[n],e[n+1],e[n+2]);}}function de(e,t,s,i,o,n,r){let a=fe(e);const l=0===o?me:ye;let c,h,u=e.start;for(let d=0;d<e.length-3;d+=3){const f=e[d],p=e[d+1],g=e[d+2],m=e[d+3],y=e[d+4],w=0===o?f:p,b=0===o?m:y;let x=!1;r&&(c=Math.sqrt(Math.pow(f-m,2)+Math.pow(p-y,2))),w<s?b>s&&(h=l(a,f,p,m,y,s),r&&(a.start=u+c*h)):w>i?b<i&&(h=l(a,f,p,m,y,i),r&&(a.start=u+c*h)):ge(a,f,p,g),b<s&&w>=s&&(h=l(a,f,p,m,y,s),x=!0),b>i&&w<=i&&(h=l(a,f,p,m,y,i),x=!0),!n&&x&&(r&&(a.end=u+c*h),t.push(a),a=fe(e)),r&&(u+=c);}let d=e.length-3;const f=e[d],p=e[d+1],g=0===o?f:p;g>=s&&g<=i&&ge(a,f,p,e[d+2]),d=a.length-3,n&&d>=3&&(a[d]!==a[0]||a[d+1]!==a[1])&&ge(a,a[0],a[1],a[2]),a.length&&t.push(a);}function fe(e){const t=[];return t.size=e.size,t.start=e.start,t.end=e.end,t}function pe(e,t,s,i,o,n){for(const r of e)de(r,t,s,i,o,n,!1);}function ge(e,t,s,i){e.push(t,s,i);}function me(e,t,s,i,o,n){const r=(n-t)/(i-t);return ge(e,n,s+(o-s)*r,1),r}function ye(e,t,s,i,o,n){const r=(n-s)/(o-s);return ge(e,t+(i-t)*r,n,1),r}function we(e,t){const s=[];for(let i=0;i<e.length;i++){const o=e[i],n=o.type;let r;if("Point"===n||"MultiPoint"===n||"LineString"===n)r=be(o.geometry,t);else if("MultiLineString"===n||"Polygon"===n){r=[];for(const e of o.geometry)r.push(be(e,t));}else if("MultiPolygon"===n){r=[];for(const e of o.geometry){const s=[];for(const i of e)s.push(be(i,t));r.push(s);}}s.push(se(o.id,n,r,o.tags));}return s}function be(e,t){const s=[];s.size=e.size,void 0!==e.start&&(s.start=e.start,s.end=e.end);for(let i=0;i<e.length;i+=3)s.push(e[i]+t,e[i+1],e[i+2]);return s}function xe(e,t){if(e.transformed)return e;const s=1<<e.z,i=e.x,o=e.y;for(const n of e.features){const e=n.geometry,r=n.type;if(n.geometry=[],1===r)for(let r=0;r<e.length;r+=2)n.geometry.push(ve(e[r],e[r+1],t,s,i,o));else for(let r=0;r<e.length;r++){const a=[];for(let n=0;n<e[r].length;n+=2)a.push(ve(e[r][n],e[r][n+1],t,s,i,o));n.geometry.push(a);}}return e.transformed=!0,e}function ve(e,t,s,i,o,n){return [Math.round(s*(e*i-o)),Math.round(s*(t*i-n))]}function Ie(e,t,s,i,o){const n=t===o.maxZoom?0:o.tolerance/((1<<t)*o.extent),r={features:[],numPoints:0,numSimplified:0,numFeatures:e.length,source:null,x:s,y:i,z:t,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0};for(const t of e)Se(r,t,n,o);return r}function Se(e,t,s,i){const o=t.geometry,n=t.type,r=[];if(e.minX=Math.min(e.minX,t.minX),e.minY=Math.min(e.minY,t.minY),e.maxX=Math.max(e.maxX,t.maxX),e.maxY=Math.max(e.maxY,t.maxY),"Point"===n||"MultiPoint"===n)for(let t=0;t<o.length;t+=3)r.push(o[t],o[t+1]),e.numPoints++,e.numSimplified++;else if("LineString"===n)Me(r,o,e,s,!1,!1);else if("MultiLineString"===n||"Polygon"===n)for(let t=0;t<o.length;t++)Me(r,o[t],e,s,"Polygon"===n,0===t);else if("MultiPolygon"===n)for(let t=0;t<o.length;t++){const i=o[t];for(let t=0;t<i.length;t++)Me(r,i[t],e,s,!0,0===t);}if(r.length){let s=t.tags||null;if("LineString"===n&&i.lineMetrics){s={};for(const e in t.tags)s[e]=t.tags[e];s.mapbox_clip_start=o.start/o.size,s.mapbox_clip_end=o.end/o.size;}const a={geometry:r,type:"Polygon"===n||"MultiPolygon"===n?3:"LineString"===n||"MultiLineString"===n?2:1,tags:s};null!==t.id&&(a.id=t.id),e.features.push(a);}}function Me(e,t,s,i,o,n){const r=i*i;if(i>0&&t.size<(o?r:i))return void(s.numPoints+=t.length/3);const a=[];for(let e=0;e<t.length;e+=3)(0===i||t[e+2]>r)&&(s.numSimplified++,a.push(t[e],t[e+1])),s.numPoints++;o&&function(e,t){let s=0;for(let t=0,i=e.length,o=i-2;t<i;o=t,t+=2)s+=(e[t]-e[o])*(e[t+1]+e[o+1]);if(s>0===t)for(let t=0,s=e.length;t<s/2;t+=2){const i=e[t],o=e[t+1];e[t]=e[s-2-t],e[t+1]=e[s-1-t],e[s-2-t]=i,e[s-1-t]=o;}}(a,n),e.push(a);}const Pe={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0};class Te{constructor(e,t){const s=(t=this.options=function(e,t){for(const s in t)e[s]=t[s];return e}(Object.create(Pe),t)).debug;if(s&&console.time("preprocess data"),t.maxZoom<0||t.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(t.promoteId&&t.generateId)throw new Error("promoteId and generateId cannot be used together.");let i=function(e,t){const s=[];if("FeatureCollection"===e.type)for(let i=0;i<e.features.length;i++)oe(s,e.features[i],t,i);else oe(s,"Feature"===e.type?e:{geometry:e},t);return s}(e,t);this.tiles={},this.tileCoords=[],s&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),i=function(e,t){const s=t.buffer/t.extent;let i=e;const o=he(e,1,-1-s,s,0,-1,2,t),n=he(e,1,1-s,2+s,0,-1,2,t);return (o||n)&&(i=he(e,1,-s,1+s,0,-1,2,t)||[],o&&(i=we(o,1).concat(i)),n&&(i=i.concat(we(n,-1)))),i}(i,t),i.length&&this.splitTile(i,0,0,0),s&&(i.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)));}splitTile(e,t,s,i,o,n,r){const a=[e,t,s,i],l=this.options,c=l.debug;for(;a.length;){i=a.pop(),s=a.pop(),t=a.pop(),e=a.pop();const h=1<<t,u=_e(t,s,i);let d=this.tiles[u];if(!d&&(c>1&&console.time("creation"),d=this.tiles[u]=Ie(e,t,s,i,l),this.tileCoords.push({z:t,x:s,y:i}),c)){c>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,s,i,d.numFeatures,d.numPoints,d.numSimplified),console.timeEnd("creation"));const e=`z${t}`;this.stats[e]=(this.stats[e]||0)+1,this.total++;}if(d.source=e,null==o){if(t===l.indexMaxZoom||d.numPoints<=l.indexMaxPoints)continue}else {if(t===l.maxZoom||t===o)continue;if(null!=o){const e=o-t;if(s!==n>>e||i!==r>>e)continue}}if(d.source=null,0===e.length)continue;c>1&&console.time("clipping");const f=.5*l.buffer/l.extent,p=.5-f,g=.5+f,m=1+f;let y=null,w=null,b=null,x=null,v=he(e,h,s-f,s+g,0,d.minX,d.maxX,l),I=he(e,h,s+p,s+m,0,d.minX,d.maxX,l);e=null,v&&(y=he(v,h,i-f,i+g,1,d.minY,d.maxY,l),w=he(v,h,i+p,i+m,1,d.minY,d.maxY,l),v=null),I&&(b=he(I,h,i-f,i+g,1,d.minY,d.maxY,l),x=he(I,h,i+p,i+m,1,d.minY,d.maxY,l),I=null),c>1&&console.timeEnd("clipping"),a.push(y||[],t+1,2*s,2*i),a.push(w||[],t+1,2*s,2*i+1),a.push(b||[],t+1,2*s+1,2*i),a.push(x||[],t+1,2*s+1,2*i+1);}}getTile(e,t,s){e=+e,t=+t,s=+s;const i=this.options,{extent:o,debug:n}=i;if(e<0||e>24)return null;const r=1<<e,a=_e(e,t=t+r&r-1,s);if(this.tiles[a])return xe(this.tiles[a],o);n>1&&console.log("drilling down to z%d-%d-%d",e,t,s);let l,c=e,h=t,u=s;for(;!l&&c>0;)c--,h>>=1,u>>=1,l=this.tiles[_e(c,h,u)];return l&&l.source?(n>1&&(console.log("found parent tile z%d-%d-%d",c,h,u),console.time("drilling down")),this.splitTile(l.source,c,h,u,e,t,s),n>1&&console.timeEnd("drilling down"),this.tiles[a]?xe(this.tiles[a],o):null):null}}function _e(e,t,s){return 32*((1<<e)*s+t)+e}function ke(t,s){const i=t.tileID.canonical;if(!this._geoJSONIndex)return void s(null,null);const o=this._geoJSONIndex.getTile(i.z,i.x,i.y);if(!o)return void s(null,null);const n=e=>e.tags&&"3d_elevation_id"in e.tags&&"source"in e.tags&&"elevation"===e.tags.source,r=o.features.filter((e=>n(e)));let a={_geojsonTileLayer:o.features};r.length>0&&(a={_geojsonTileLayer:o.features.filter((e=>!n(e))),hd_road_elevation:r});const l=new S(a),c=function(t){const s=new e.bt;for(const e of Object.keys(t))s.writeMessage(3,F,{name:e,features:t[e]});return s.finish()}(a).buffer;s(null,{vectorTile:l,rawData:c});}class Le extends m{constructor(e,t,s,i,o,n,r){super(e,t,s,i,o,ke,r),n&&(this.loadGeoJSON=n),this._dynamicIndex=new T;}loadData(s,i){const o=s&&s.request,n=o&&o.collectResourceTiming;this._geoJSONIndex=null,this.loadGeoJSON(s,((r,a)=>{if(r||!a)return i(r);if("object"!=typeof a)return i(new Error(`Input data given to '${s.source}' is not a valid GeoJSON object.`));{try{if(s.filter){const t=e.U(s.filter,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===t.result)throw new Error(t.value.map((e=>`${e.key}: ${e.message}`)).join(", "));a.features=a.features.filter((e=>t.value.evaluate({zoom:0},e)));}s.dynamic?("Feature"===a.type&&(a={type:"FeatureCollection",features:[a]}),s.append||(this._dynamicIndex.clear(),this.loaded={}),this._dynamicIndex.load(a.features,this.loaded),s.cluster&&(a.features=this._dynamicIndex.getFeatures())):this.loaded={},this._geoJSONIndex=s.cluster?new V(function({superclusterOptions:t,clusterProperties:s}){if(!s||!t)return t;const i={},o={},n={accumulated:null,zoom:0},r={properties:null},a=Object.keys(s);for(const t of a){const[n,r]=s[t],a=e.U(r),l=e.U("string"==typeof n?[n,["accumulated"],["get",t]]:n);i[t]=a.value,o[t]=l.value;}return t.map=e=>{r.properties=e;const t={};for(const e of a)t[e]=i[e].evaluate(n,r);return t},t.reduce=(e,t)=>{r.properties=t;for(const t of a)n.accumulated=e[t],e[t]=o[t].evaluate(n,r);},t}(s)).load(a.features):s.dynamic?this._dynamicIndex:function(e,t){return new Te(e,t)}(a,s.geojsonVtOptions);}catch(e){return i(e)}const r={};if(n){const e=t(o);e&&(r.resourceTiming={},r.resourceTiming[s.source]=JSON.parse(JSON.stringify(e)));}i(null,r);}}));}reloadTile(e,t){const s=this.loaded;return s&&s[e.uid]?e.partial?t(null,void 0):super.reloadTile(e,t):this.loadTile(e,t)}loadGeoJSON(t,s){if(t.request)e.m(t.request,s);else {if("string"!=typeof t.data)return s(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`));setTimeout((()=>{try{return s(null,JSON.parse(t.data))}catch(e){return s(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`))}}),0);}}getClusterExpansionZoom(e,t){try{t(null,this._geoJSONIndex.getClusterExpansionZoom(e.clusterId));}catch(e){t(e);}}getClusterChildren(e,t){try{t(null,this._geoJSONIndex.getChildren(e.clusterId));}catch(e){t(e);}}getClusterLeaves(e,t){try{t(null,this._geoJSONIndex.getLeaves(e.clusterId,e.limit,e.offset));}catch(e){t(e);}}}class ze{constructor(t,s,i){this.tileID=new e.aQ(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.tileZoom=t.tileZoom,this.uid=t.uid,this.zoom=t.zoom,this.canonical=t.tileID.canonical,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.projection=t.projection,this.brightness=s,this.worldview=i;}parse(t,s,i,o){this.status="parsing";const n=new e.aQ(i.tileID.overscaledZ,i.tileID.wrap,i.tileID.canonical.z,i.tileID.canonical.x,i.tileID.canonical.y),r=[],a=s.familiesBySource[i.source],l=new e.fn(n,i.promoteId);l.bucketLayerIDs=[],l.is3DTile=!0,e.fC(t).then((t=>{if(!t)return o(new Error("Could not parse tile"));const s=t.json.extensionsUsed&&t.json.extensionsUsed.includes("MAPBOX_mesh_features")||t.json.asset.extras&&t.json.asset.extras.MAPBOX_mesh_features,c=t.json.extensionsUsed&&t.json.extensionsUsed.includes("EXT_meshopt_compression"),h=new e.ac(this.zoom,{brightness:this.brightness,worldview:this.worldview});for(const o in a)for(const u of a[o]){const o=u[0];l.bucketLayerIDs.push(u.map((t=>e.B(t.id,t.scope)))),o.recalculate(h,[]);const a=e.fD(t,1/e.d7(i.tileID.canonical)),d=new e.fE(u,a,n,s,c,this.brightness,l,this.worldview);s||(d.needsUpload=!0),r.push(d),d.evaluate(o);}this.status="done",o(null,{buckets:r,featureIndex:l,collisionBoxArray:null,glyphAtlasImage:null,lineAtlas:null,imageAtlas:null,brightness:null});})).catch((e=>o(new Error(e.message))));}}class Ce{constructor(e,t,s,i,o,n,r,a){this.actor=e,this.layerIndex=t,this.availableImages=s,this.availableModels=i,this.brightness=r,this.loading={},this.loaded={},this.worldview=a;}loadTile(t,s){const i=t.uid,o=this.loading[i]=new ze(t,this.brightness,this.worldview);e.bu(t.request,((e,n)=>{const r=!this.loading[i];return delete this.loading[i],r||e?(o.status="done",r||(this.loaded[i]=o),s(e)):n&&0!==n.byteLength?void o.parse(n,this.layerIndex,t,((e,t)=>{o.status="done",this.loaded=this.loaded||{},this.loaded[i]=o,e||!t?s(e):s(null,t);})):(o.status="done",this.loaded[i]=o,s())}));}reloadTile(e,t){const s=this.loaded,i=e.uid;if(s&&s[i]){const o=s[i];o.projection=e.projection,o.brightness=e.brightness;const n=(s,i)=>{o.reloadCallback&&(delete o.reloadCallback,this.loadTile(e,t)),t(s,i);};"parsing"===o.status?o.reloadCallback=n:"done"===o.status&&this.loadTile(e,t);}}abortTile(e,t){const s=e.uid;this.loading[s]&&delete this.loading[s],t();}removeTile(e,t){const s=this.loaded,i=e.uid;s&&s[i]&&delete s[i],t();}}class De{constructor(t){this.self=t,this.actor=new e.fG(t,this),this.layerIndexes={},this.availableImages={},this.availableModels={},this.isSpriteLoaded={},this.imageRasterizer=new e.x,this.rtlPluginParsingListeners=[],this.projections={},this.defaultProjection=e.cm({name:"mercator"}),this.workerSourceTypes={vector:m,geojson:Le,"raster-dem":y,"raster-array":b,"batched-model":Ce},this.workerSources={},this.self.registerWorkerSource=(e,t)=>{if(this.workerSourceTypes[e])throw new Error(`Worker source with name "${e}" already registered.`);this.workerSourceTypes[e]=t;},this.self.registerRTLTextPlugin=t=>{if(e.fH.isParsed())throw new Error("RTL text plugin already registered.");e.fH.setState({pluginStatus:e.fI.parsed,pluginURL:e.fH.getPluginURL()}),e.fH.applyArabicShaping=t.applyArabicShaping,e.fH.processBidirectionalText=t.processBidirectionalText,e.fH.processStyledBidirectionalText=t.processStyledBidirectionalText;for(const e of this.rtlPluginParsingListeners)e(null,!0);this.rtlPluginParsingListeners=[];};}clearCaches(e,t,s){delete this.layerIndexes[e],delete this.availableImages[e],delete this.availableModels[e],delete this.workerSources[e],s();}checkIfReady(e,t,s){s();}setReferrer(e,t){this.referrer=t;}spriteLoaded(t,s){this.isSpriteLoaded[t]||(this.isSpriteLoaded[t]={});const{scope:i,isLoaded:o}=s;if(this.isSpriteLoaded[t][i]=o,this.workerSources[t]&&this.workerSources[t][i])for(const s in this.workerSources[t][i]){const n=this.workerSources[t][i][s];for(const t in n){const s=n[t];s instanceof m&&(s.isSpriteLoaded=o,s.fire(new e.z("isSpriteLoaded")));}}}setImages(e,t,s){this.availableImages[e]||(this.availableImages[e]={});const{scope:i,images:o}=t;if(this.availableImages[e][i]=o,this.workerSources[e]&&this.workerSources[e][i]){for(const t in this.workerSources[e][i]){const s=this.workerSources[e][i][t];for(const e in s)s[e].availableImages=o;}s();}else s();}setModels(e,{scope:t,models:s},i){if(this.availableModels[e]||(this.availableModels[e]={}),this.availableModels[e][t]=s,this.workerSources[e]&&this.workerSources[e][t]){for(const i in this.workerSources[e][t]){const o=this.workerSources[e][t][i];for(const e in o)o[e].availableModels=s;}i();}else i();}setProjection(t,s){this.projections[t]=e.cm(s);}setBrightness(e,t,s){this.brightness=t,s();}setWorldview(e,t,s){this.worldview=t,s();}setLayers(e,t,s){this.getLayerIndex(e,t.scope).replace(t.layers,t.options),s();}updateLayers(e,t,s){this.getLayerIndex(e,t.scope).update(t.layers,t.removedIds,t.options),s();}loadTile(e,t,s){t.projection=this.projections[e]||this.defaultProjection,this.getWorkerSource(e,t.type,t.source,t.scope).loadTile(t,s);}decodeRasterArray(e,t,s){this.getWorkerSource(e,t.type,t.source,t.scope).decodeRasterArray(t,s);}reloadTile(e,t,s){t.projection=this.projections[e]||this.defaultProjection,this.getWorkerSource(e,t.type,t.source,t.scope).reloadTile(t,s);}abortTile(e,t,s){this.getWorkerSource(e,t.type,t.source,t.scope).abortTile(t,s);}removeTile(e,t,s){this.getWorkerSource(e,t.type,t.source,t.scope).removeTile(t,s);}removeSource(e,t,s){if(!(this.workerSources[e]&&this.workerSources[e][t.scope]&&this.workerSources[e][t.scope][t.type]&&this.workerSources[e][t.scope][t.type][t.source]))return;const i=this.workerSources[e][t.scope][t.type][t.source];delete this.workerSources[e][t.scope][t.type][t.source],void 0!==i.removeSource?i.removeSource(t,s):s();}loadWorkerSource(e,t,s){try{this.self.importScripts(t.url),s();}catch(e){s(e);}}syncRTLPluginState(t,s,i){if(e.fH.isParsed())i(null,!0);else if(e.fH.isParsing())this.rtlPluginParsingListeners.push(i);else try{e.fH.setState(s);const t=e.fH.getPluginURL();!e.fH.isLoaded()||e.fH.isParsed()||e.fH.isParsing()||null==t||(e.fH.setState({pluginStatus:e.fI.parsing,pluginURL:e.fH.getPluginURL()}),this.self.importScripts(t),e.fH.isParsed()?i(null,!0):this.rtlPluginParsingListeners.push(i));}catch(e){i(e);}}setDracoUrl(e,t){this.dracoUrl=t;}getAvailableImages(e,t){this.availableImages[e]||(this.availableImages[e]={});let s=this.availableImages[e][t];return s||(s=[]),s}getAvailableModels(e,t){this.availableModels[e]||(this.availableModels[e]={});let s=this.availableModels[e][t];return s||(s={}),s}getLayerIndex(e,t){this.layerIndexes[e]||(this.layerIndexes[e]={});let s=this.layerIndexes[e][t];return s||(s=this.layerIndexes[e][t]=new o,s.scope=t),s}getWorkerSource(e,t,s,i){const o=this.workerSources;return o[e]||(o[e]={}),o[e][i]||(o[e][i]={}),o[e][i][t]||(o[e][i][t]={}),this.isSpriteLoaded[e]||(this.isSpriteLoaded[e]={}),o[e][i][t][s]||(o[e][i][t][s]=new this.workerSourceTypes[t]({send:(t,s,i,o,n,r)=>this.actor.send(t,s,i,e,n,r),scheduler:this.actor.scheduler},this.getLayerIndex(e,i),this.getAvailableImages(e,i),this.getAvailableModels(e,i),this.isSpriteLoaded[e][i],void 0,this.brightness,this.worldview)),o[e][i][t][s]}rasterizeImagesWorker(e,t,s){const i=new Map;for(const[s,{image:o,imageVariant:n}]of t.tasks.entries()){const r=this.imageRasterizer.rasterize(n,o,t.scope,e);i.set(s,r);}s(void 0,i);}removeRasterizedImages(e,t,s){this.imageRasterizer.removeImagesFromCacheByIds(t.imageIds,t.scope,e),s();}enforceCacheSizeLimit(t,s){e.fJ(s);}getWorkerPerformanceMetrics(e,t,s){s(void 0,void 0);}}return e.fF(self)&&(self.worker=new De(self)),De}));

define(["./shared"],(function(e){var t="3.17.0";const i={create:"create",load:"load",fullLoad:"fullLoad"},o={mark(e){performance.mark(e);},measure(e,t,i){performance.measure(e,t,i);}};function s(t){const i=t.name.split("?")[0];return e.a(i)&&i.includes("mapbox-gl.js")?"javascript":e.a(i)&&i.includes("mapbox-gl.css")?"css":e.b(i)?"fontRange":e.c(i)?"sprite":e.i(i)?"style":e.d(i)?"tilejson":"other"}var r,n={},a=function(){if(r)return n;function e(e){return !t(e)}function t(t){return "undefined"==typeof window||"undefined"==typeof document?"not a browser":function(){if(!("Worker"in window&&"Blob"in window&&"URL"in window))return !1;var e,t,i=new Blob([""],{type:"text/javascript"}),o=URL.createObjectURL(i);try{t=new Worker(o),e=!0;}catch(t){e=!1;}return t&&t.terminate(),URL.revokeObjectURL(o),e}()?function(){var e=document.createElement("canvas");e.width=e.height=1;var t=e.getContext("2d");if(!t)return !1;var i=t.getImageData(0,0,1,1);return i&&i.width===e.width}()?(void 0===i[o=t&&t.failIfMajorPerformanceCaveat]&&(i[o]=function(t){var i,o=function(t){var i=document.createElement("canvas"),o=Object.create(e.webGLContextAttributes);return o.failIfMajorPerformanceCaveat=t,i.getContext("webgl2",o)}(t);if(!o)return !1;try{i=o.createShader(o.VERTEX_SHADER);}catch(e){return !1}return !(!i||o.isContextLost())&&(o.shaderSource(i,"void main() {}"),o.compileShader(i),!0===o.getShaderParameter(i,o.COMPILE_STATUS))}(o)),i[o]?document.documentMode?"insufficient ECMAScript 6 support":void 0:"insufficient WebGL2 support"):"insufficient Canvas/getImageData support":"insufficient worker support";var o;}r=1,n.supported=e,n.notSupportedReason=t;var i={};return e.webGLContextAttributes={antialias:!1,alpha:!0,stencil:!0,depth:!0},n}();function l(e,t,i){const o=document.createElement(e);return null!=t&&(o.className=t),i&&i.appendChild(o),o}function c(e,t,i){const o=document.createElementNS("http://www.w3.org/2000/svg",e);for(const e of Object.keys(t))o.setAttributeNS(null,e,String(t[e]));return i&&i.appendChild(o),o}const h="undefined"!=typeof document?document.documentElement&&document.documentElement.style:null,d=h&&void 0!==h.userSelect?"userSelect":"WebkitUserSelect";let u;function _(){h&&d&&(u=h[d],h[d]="none");}function p(){h&&d&&(h[d]=u);}function f(e){e.preventDefault(),e.stopPropagation(),window.removeEventListener("click",f,!0);}function m(){window.addEventListener("click",f,!0),window.setTimeout((()=>{window.removeEventListener("click",f,!0);}),0);}function g(e,t){const i=e.getBoundingClientRect();return x(e,i,t)}function v(e,t){const i=e.getBoundingClientRect(),o=[];for(let s=0;s<t.length;s++)o.push(x(e,i,t[s]));return o}function y(e){return /firefox/i.test(navigator.userAgent)&&/macintosh/i.test(navigator.userAgent)&&2===e.button&&e.ctrlKey?0:e.button}function x(t,i,o){const s=t.offsetWidth===i.width?1:t.offsetWidth/i.width;return new e.P((o.clientX-i.left)*s,(o.clientY-i.top)*s)}const b="01",w="NO_ACCESS_TOKEN";class T{constructor(e,t,i){this._transformRequestFn=e,this._customAccessToken=t,this._silenceAuthErrors=!!i,this._createSkuToken();}_createSkuToken(){const e=function(){let e="";for(let t=0;t<10;t++)e+="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"[Math.floor(62*Math.random())];return {token:["1",b,e].join(""),tokenExpiresAt:Date.now()+432e5}}();this._skuToken=e.token,this._skuTokenExpiresAt=e.tokenExpiresAt;}_isSkuTokenExpired(){return Date.now()>this._skuTokenExpiresAt}transformRequest(e,t){return this._transformRequestFn&&this._transformRequestFn(e,t)||{url:e}}normalizeStyleURL(i,o){if(!e.h(i))return i;const s=S(i);return s.params.push(`sdk=js-${t}`),s.path=`/styles/v1${s.path}`,this._makeAPIURL(s,this._customAccessToken||o)}normalizeGlyphsURL(t,i){if(!e.h(t))return t;const o=S(t);return o.path=`/fonts/v1${o.path}`,this._makeAPIURL(o,this._customAccessToken||i)}normalizeModelURL(t,i){if(!e.h(t))return t;const o=S(t);return o.path=`/models/v1${o.path}`,this._makeAPIURL(o,this._customAccessToken||i)}normalizeSourceURL(t,i,o,s){if(!e.h(t))return t;const r=S(t);return r.path=`/v4/${r.authority}.json`,r.params.push("secure"),o&&r.params.push(`language=${o}`),s&&r.params.push(`worldview=${s}`),this._makeAPIURL(r,this._customAccessToken||i)}normalizeIconsetURL(t,i){const o=S(t);return e.h(t)?(o.path=`/styles/v1${o.path}/iconset.pbf`,this._makeAPIURL(o,this._customAccessToken||i)):I(o)}normalizeSpriteURL(t,i,o,s){const r=S(t);return e.h(t)?(r.path=`/styles/v1${r.path}/sprite${i}${o}`,this._makeAPIURL(r,this._customAccessToken||s)):(r.path+=`${i}${o}`,I(r))}normalizeTileURL(t,i,o){if(this._isSkuTokenExpired()&&this._createSkuToken(),t&&!e.h(t))return t;const s=S(t);s.path=s.path.replace(/(\.(png|jpg)\d*)(?=$)/,`${i||o&&"raster"!==s.authority&&512===o?"@2x":""}${e.k.supported?".webp":"$1"}`),"raster"===s.authority?s.path=`/${e.e.RASTER_URL_PREFIX}${s.path}`:"rasterarrays"===s.authority?s.path=`/${e.e.RASTERARRAYS_URL_PREFIX}${s.path}`:"3dtiles"===s.authority?s.path=`/${e.e.TILES3D_URL_PREFIX}${s.path}`:(s.path=s.path.replace(/^.+\/v4\//,"/"),s.path=`/${e.e.TILE_URL_VERSION}${s.path}`);const r=this._customAccessToken||function(e){for(const t of e){const e=t.match(/^access_token=(.*)$/);if(e)return e[1]}return null}(s.params)||e.e.ACCESS_TOKEN;return e.e.REQUIRE_ACCESS_TOKEN&&r&&this._skuToken&&s.params.push(`sku=${this._skuToken}`),this._makeAPIURL(s,r)}canonicalizeTileURL(t,i){const o=S(t);if(!o.path.match(/^(\/v4\/|\/(raster|rasterarrays)\/v1\/)/)||!o.path.match(/\.[\w]+$/))return t;let s="mapbox://";o.path.match(/^\/raster\/v1\//)?s+=`raster/${o.path.replace(`/${e.e.RASTER_URL_PREFIX}/`,"")}`:o.path.match(/^\/rasterarrays\/v1\//)?s+=`rasterarrays/${o.path.replace(`/${e.e.RASTERARRAYS_URL_PREFIX}/`,"")}`:s+=`tiles/${o.path.replace(`/${e.e.TILE_URL_VERSION}/`,"")}`;let r=o.params;return i&&(r=r.filter((e=>!e.match(/^access_token=/)))),r.length&&(s+=`?${r.join("&")}`),s}canonicalizeTileset(t,i){const o=!!i&&e.h(i),s=[];for(const i of t.tiles||[])e.j(i)?s.push(this.canonicalizeTileURL(i,o)):s.push(i);return s}_makeAPIURL(t,i){const o="See https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes",s=S(e.e.API_URL);if(t.protocol=s.protocol,t.authority=s.authority,"http"===t.protocol){const e=t.params.indexOf("secure");e>=0&&t.params.splice(e,1);}if("/"!==s.path&&(t.path=`${s.path}${t.path}`),!e.e.REQUIRE_ACCESS_TOKEN)return I(t);if(i=i||e.e.ACCESS_TOKEN,!this._silenceAuthErrors){if(!i)throw new Error(`An API access token is required to use Mapbox GL. ${o}`);if("s"===i[0])throw new Error(`Use a public access token (pk.*) with Mapbox GL, not a secret access token (sk.*). ${o}`)}return t.params=t.params.filter((e=>-1===e.indexOf("access_token"))),t.params.push(`access_token=${i||""}`),I(t)}}const E=/^(\w+):\/\/([^/?]*)(\/[^?]+)?\??(.+)?/;function S(e){const t=e.match(E);if(!t)throw new Error("Unable to parse URL object");return {protocol:t[1],authority:t[2],path:t[3]||"/",params:t[4]?t[4].split("&"):[]}}function I(e){const t=e.params.length?`?${e.params.join("&")}`:"";return `${e.protocol}://${e.authority}${e.path}${t}`}const C="mapbox.eventData";function R(t){if(!t)return null;const i=t.split(".");if(!i||3!==i.length)return null;try{return JSON.parse(e.l(i[1]))}catch(e){return null}}class A{constructor(e){this.type=e,this.anonId=null,this.anonIdTimestamp=null,this.eventData={},this.queue=[],this.pendingRequest=null;}getStorageKey(t){const i=R(e.e.ACCESS_TOKEN);let o="";return o=i&&i.u?e.f(i.u):e.e.ACCESS_TOKEN||"",t?`${C}.${t}:${o}`:`${C}:${o}`}fetchEventData(){const t=e.s("localStorage"),i=this.getStorageKey(),o=this.getStorageKey("uuid"),s=this.getStorageKey("uuidTimestamp");if(t)try{const e=localStorage.getItem(i);e&&(this.eventData=JSON.parse(e));const t=localStorage.getItem(o);t&&(this.anonId=t);const r=localStorage.getItem(s);r&&(this.anonIdTimestamp=Number(r));const n=Date.now()-864e5;(!this.anonIdTimestamp||this.anonIdTimestamp<n)&&this.refreshUUID();}catch(t){e.w("Unable to read from LocalStorage");}}refreshUUID(){this.anonId=e.u(),this.anonIdTimestamp=Date.now();}saveEventData(){const t=e.s("localStorage"),i=this.getStorageKey(),o=this.getStorageKey("uuid"),s=this.getStorageKey("uuidTimestamp"),r=this.anonId,n=this.anonIdTimestamp;if(t&&r)try{localStorage.setItem(o,r),Object.keys(this.eventData).length>=1&&localStorage.setItem(i,JSON.stringify(this.eventData)),n&&localStorage.setItem(s,n.toString());}catch(t){e.w("Unable to write to LocalStorage");}}processRequests(e){}postEvent(t,i,o,s){if(!e.e.EVENTS_URL)return;const r=S(e.e.EVENTS_URL);r.params.push(`access_token=${s||e.e.ACCESS_TOKEN||""}`);const n={event:this.type,created:new Date(t).toISOString()},a=i?Object.assign(n,i):n,l={url:I(r),headers:{"Content-Type":"text/plain"},body:JSON.stringify([a])};this.pendingRequest=e.p(l,(e=>{this.pendingRequest=null,o(e),this.saveEventData(),this.processRequests(s);}));}queueRequest(e,t){this.queue.push(e),this.processRequests(t);}}class L extends A{constructor(e){super("metrics"),e&&(this.data=e);}postMetricsEvent(t){if(!e.e.EVENTS_URL||!t&&!e.e.ACCESS_TOKEN)return;this.anonId||this.fetchEventData(),e.v(this.anonId)||this.refreshUUID();const i=Object.assign({},this.data,{sessionId:this.anonId});this.queueRequest({timestamp:Date.now(),payload:i},t);}processRequests(e){if(this.pendingRequest||0===this.queue.length)return;const{timestamp:t,payload:i}=this.queue.shift();this.postEvent(t,i,(()=>{}),e);}}const D=new class extends A{constructor(e){super("appUserTurnstile"),this._customAccessToken=e;}postTurnstileEvent(t,i){e.e.EVENTS_URL&&e.e.ACCESS_TOKEN&&Array.isArray(t)&&t.some((t=>e.h(t)||e.j(t)))&&this.queueRequest(Date.now(),i);}processRequests(i){if(this.pendingRequest||0===this.queue.length)return;this.anonId&&this.anonIdTimestamp&&this.eventData.lastSuccess&&this.eventData.tokenU||this.fetchEventData();const o=R(e.e.ACCESS_TOKEN),s=o?o.u:e.e.ACCESS_TOKEN;let r=s!==this.eventData.tokenU;e.v(this.anonId)||(this.refreshUUID(),r=!0);const n=this.queue.shift();if(this.eventData.lastSuccess){const e=new Date(this.eventData.lastSuccess),t=new Date(n),i=(n-this.eventData.lastSuccess)/864e5;r=r||i>=1||i<-1||e.getDate()!==t.getDate();}else r=!0;r?this.postEvent(n,{sdkIdentifier:"mapbox-gl-js",sdkVersion:t,skuId:b,"enabled.telemetry":!1,userId:this.anonId},(e=>{e||(this.eventData.lastSuccess=n,this.eventData.tokenU=s);}),i):this.processRequests();}},P=D.postTurnstileEvent.bind(D),O=new class extends A{constructor(){super("map.load"),this.success={},this.skuToken="";}postMapLoadEvent(t,i,o,s){this.skuToken=i,this.errorCb=s,e.e.EVENTS_URL&&(o||e.e.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},o):this.errorCb(new Error(w)));}processRequests(i){if(this.pendingRequest||0===this.queue.length)return;const{id:o,timestamp:s}=this.queue.shift();o&&this.success[o]||(this.anonId&&this.anonIdTimestamp||this.fetchEventData(),e.v(this.anonId)||this.refreshUUID(),this.postEvent(s,{sdkIdentifier:"mapbox-gl-js",sdkVersion:t,skuId:b,skuToken:this.skuToken,userId:this.anonId},(e=>{e?this.errorCb(e):o&&(this.success[o]=!0);}),i));}remove(){this.errorCb=null;}},z=O.postMapLoadEvent.bind(O),M=new class extends A{constructor(){super("style.load"),this.eventIdPerMapInstanceMap=new Map,this.mapInstanceIdMap=new WeakMap;}getMapInstanceId(t){let i=this.mapInstanceIdMap.get(t);return i||(i=e.u(),this.mapInstanceIdMap.set(t,i)),i}getEventId(e){const t=this.eventIdPerMapInstanceMap.get(e)||0;return this.eventIdPerMapInstanceMap.set(e,t+1),t}postStyleLoadEvent(t,i){const{map:o,style:s,importedStyles:r}=i;if(!e.e.EVENTS_URL||!t&&!e.e.ACCESS_TOKEN)return;const n=this.getMapInstanceId(o),a={mapInstanceId:n,eventId:this.getEventId(n),style:s};r.length&&(a.importedStyles=r),this.queueRequest({timestamp:Date.now(),payload:a},t);}processRequests(e){if(this.pendingRequest||0===this.queue.length)return;const{timestamp:t,payload:i}=this.queue.shift();this.postEvent(t,i,(()=>{}),e);}},F=M.postStyleLoadEvent.bind(M),B=new L({attributes:[{name:"maps/js/layer-animations/style-with-appearances"}]}),k=B.postMetricsEvent.bind(B),N=new L({attributes:[{name:"maps/js/layer-animations/runtime-appearances"}]}),U=N.postMetricsEvent.bind(N),j=new class extends A{constructor(){super("gljs.performance");}postPerformanceEvent(t,i){e.e.EVENTS_URL&&(t||e.e.ACCESS_TOKEN)&&this.queueRequest({timestamp:Date.now(),performanceData:i},t);}processRequests(o){if(this.pendingRequest||0===this.queue.length)return;const{timestamp:r,performanceData:n}=this.queue.shift(),a=function(o){const r=performance.getEntriesByType("resource"),n=performance.getEntriesByType("mark"),a=function(e){const t={};if(e)for(const i in e)if("other"!==i)for(const o of e[i]){const e=`${i}ResolveRangeMin`,s=`${i}ResolveRangeMax`,r=`${i}RequestCount`,n=`${i}RequestCachedCount`;t[e]=Math.min(t[e]||1/0,o.startTime),t[s]=Math.max(t[s]||-1/0,o.responseEnd);const a=e=>{void 0===t[e]&&(t[e]=0),++t[e];};void 0!==o.transferSize&&0===o.transferSize&&a(n),a(r);}return t}(function(e,t){const i={};if(e)for(const o of e){const e=t(o);void 0===i[e]&&(i[e]=[]),i[e].push(o);}return i}(r,s)),l=window.devicePixelRatio,c=navigator.connection||navigator.mozConnection||navigator.webkitConnection,h=c?c.effectiveType:void 0,d={counters:[],metadata:[],attributes:[]},u=(e,t,i)=>{null!=i&&e.push({name:t,value:i.toString()});};for(const e in a)u(d.counters,e,a[e]);if(o.interactionRange[0]!==1/0&&o.interactionRange[1]!==-1/0&&(u(d.counters,"interactionRangeMin",o.interactionRange[0]),u(d.counters,"interactionRangeMax",o.interactionRange[1])),n)for(const e of Object.values(i)){const t=n.find((t=>t.name===e));t&&u(d.counters,e,t.startTime);}return u(d.counters,"visibilityHidden",o.visibilityHidden),u(d.attributes,"style",function(t){if(t)for(const i of t){const t=i.name.split("?")[0];if(e.i(t)){const e=t.split("/").slice(-2);if(2===e.length)return `mapbox://styles/${e[0]}/${e[1]}`}}}(r)),u(d.attributes,"terrainEnabled",o.terrainEnabled?"true":"false"),u(d.attributes,"fogEnabled",o.fogEnabled?"true":"false"),u(d.attributes,"projection",o.projection),u(d.attributes,"zoom",o.zoom),u(d.metadata,"devicePixelRatio",l),u(d.metadata,"connectionEffectiveType",h),u(d.metadata,"navigatorUserAgent",navigator.userAgent),u(d.metadata,"screenWidth",window.screen.width),u(d.metadata,"screenHeight",window.screen.height),u(d.metadata,"windowWidth",window.innerWidth),u(d.metadata,"windowHeight",window.innerHeight),u(d.metadata,"mapWidth",o.width/l),u(d.metadata,"mapHeight",o.height/l),u(d.metadata,"webglRenderer",o.renderer),u(d.metadata,"webglVendor",o.vendor),u(d.metadata,"sdkVersion",t),u(d.metadata,"sdkIdentifier","mapbox-gl-js"),d}(n);for(const e of a.metadata);for(const e of a.counters);for(const e of a.attributes);this.postEvent(r,a,(()=>{}),o);}},G=j.postPerformanceEvent.bind(j),V=new class extends A{constructor(){super("map.auth"),this.success={},this.skuToken="";}getSession(t,i,o,s){if(!e.e.API_URL||!e.e.SESSION_PATH)return;const r=S(e.e.API_URL+e.e.SESSION_PATH);r.params.push(`sku=${i||""}`),r.params.push(`access_token=${s||e.e.ACCESS_TOKEN||""}`);const n={url:I(r),headers:{"Content-Type":"text/plain"}};this.pendingRequest=e.g(n,(e=>{this.pendingRequest=null,o(e),this.saveEventData(),this.processRequests(s);}));}getSessionAPI(t,i,o,s){this.skuToken=i,this.errorCb=s,e.e.SESSION_PATH&&e.e.API_URL&&(o||e.e.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},o):this.errorCb(new Error(w)));}processRequests(e){if(this.pendingRequest||0===this.queue.length)return;const{id:t,timestamp:i}=this.queue.shift();t&&this.success[t]||this.getSession(i,this.skuToken,(e=>{e?this.errorCb(e):t&&(this.success[t]=!0);}),e);}remove(){this.errorCb=null;}},H=V.getSessionAPI.bind(V),q=new Set;function Z(e,t){t?q.add(e):q.delete(e);}class W{constructor(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSourceCaches={},this._updatedPaintProps=new Set,this._updatedImages={};}isDirty(){return this._changed}setDirty(){this._changed=!0;}getUpdatedSourceCaches(){return this._updatedSourceCaches}updateSourceCache(e,t){this._updatedSourceCaches[e]=t,this.setDirty();}discardSourceCacheUpdate(e){delete this._updatedSourceCaches[e];}updateLayer(e){const t=e.scope;this._updatedLayers[t]=this._updatedLayers[t]||new Set,this._updatedLayers[t].add(e.id),this.setDirty();}removeLayer(e){const t=e.scope;this._removedLayers[t]=this._removedLayers[t]||{},this._updatedLayers[t]=this._updatedLayers[t]||new Set,this._removedLayers[t][e.id]=e,this._updatedLayers[t].delete(e.id),this._updatedPaintProps.delete(e.fqid),this.setDirty();}getRemovedLayer(e){return this._removedLayers[e.scope]?this._removedLayers[e.scope][e.id]:null}discardLayerRemoval(e){this._removedLayers[e.scope]&&delete this._removedLayers[e.scope][e.id];}getLayerUpdatesByScope(){const e={};for(const t in this._updatedLayers)e[t]=e[t]||{},e[t].updatedIds=Array.from(this._updatedLayers[t].values());for(const t in this._removedLayers)e[t]=e[t]||{},e[t].removedIds=Object.keys(this._removedLayers[t]);return e}getUpdatedPaintProperties(){return this._updatedPaintProps}updatePaintProperties(e){this._updatedPaintProps.add(e.fqid),this.setDirty();}getUpdatedImages(e){return this._updatedImages[e]?Array.from(this._updatedImages[e].values()):[]}updateImage(t,i){this._updatedImages[i]=this._updatedImages[i]||new Set,this._updatedImages[i].add(e.I.toString(t)),this.setDirty();}resetUpdatedImages(e){this._updatedImages[e]&&this._updatedImages[e].clear();}reset(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSourceCaches={},this._updatedPaintProps.clear(),this._updatedImages={};}}function $(e){const{userImage:t}=e;return !!(t&&t.render&&t.render())&&(e.data.replace(new Uint8Array(t.data.buffer)),!0)}class X extends e.E{constructor(t){super(),this.imageProviders=new Map,this.images=new Map,this.updatedImages=new Map,this.callbackDispatchedThisFrame=new Map,this.loaded=new Map,this.requestors=[],this.patterns=new Map,this.patternsInFlight=new Set,this.atlasImage=new Map,this.atlasTexture=new Map,this.dirty=!0,this.spriteFormat=t,"raster"!==t&&e.r()&&(this.imageRasterizerDispatcher=new e.D(e.t(),this,"Image Rasterizer Worker",1));}addScope(t){this.loaded.set(t,!1),this.imageProviders.set(t,new Map),this.images.set(t,new Map),this.updatedImages.set(t,new Set),this.callbackDispatchedThisFrame.set(t,new Set),this.patterns.set(t,new Map),this.atlasImage.set(t,new e.q({width:1,height:1}));}removeScope(e){this.loaded.delete(e),this.imageProviders.delete(e),this.images.delete(e),this.updatedImages.delete(e),this.callbackDispatchedThisFrame.delete(e),this.patterns.delete(e),this.atlasImage.delete(e);const t=this.atlasTexture.get(e);t&&(t.destroy(),this.atlasTexture.delete(e));}addImageProvider(e,t){this.imageProviders.has(t)||this.imageProviders.set(t,new Map),this.imageProviders.get(t).set(e.id,e);}removeImageProvider(e,t){this.imageProviders.has(t)&&this.imageProviders.get(t).delete(e);}getPendingImageProviders(){const e=[];for(const t of this.imageProviders.values())for(const i of t.values())i.hasPendingRequests()&&e.push(i);return e}get imageRasterizer(){return this._imageRasterizer||(this._imageRasterizer=new e.x),this._imageRasterizer}isLoaded(){for(const e of this.loaded.keys())if(!this.loaded.get(e))return !1;return !0}setLoaded(e,t){if(this.loaded.get(t)!==e&&(this.loaded.set(t,e),e)){for(const{ids:e,callback:i}of this.requestors)this._notify(e,t,i);this.requestors=[];}}hasImage(e,t){return !!this.getImage(e,t)}getImage(e,t){return this.images.get(t).get(e.toString())}addImage(e,t,i){this._validate(e,i)&&this.images.get(t).set(e.toString(),i);}_validate(t,i){let o=!0;return this._validateStretch(i.stretchX,i.data&&i.data.width)||(this.fire(new e.y(new Error(`Image "${t.name}" has invalid "stretchX" value`))),o=!1),this._validateStretch(i.stretchY,i.data&&i.data.height)||(this.fire(new e.y(new Error(`Image "${t.name}" has invalid "stretchY" value`))),o=!1),this._validateContent(i.content,i)||(this.fire(new e.y(new Error(`Image "${t.name}" has invalid "content" value`))),o=!1),o}_validateStretch(e,t){if(!e)return !0;let i=0;for(const o of e){if(o[0]<i||o[1]<o[0]||t<o[1])return !1;i=o[1];}return !0}_validateContent(e,t){if(!e)return !0;if(4!==e.length)return !1;if(!t.usvg){if(e[0]<0||t.data.width<e[0])return !1;if(e[1]<0||t.data.height<e[1])return !1;if(e[2]<0||t.data.width<e[2])return !1;if(e[3]<0||t.data.height<e[3])return !1}return !(e[2]<e[0]||e[3]<e[1])}updateImage(e,t,i){const o=this.images.get(t).get(e.toString());i.version=o.version+1,this.images.get(t).set(e.toString(),i),this.updatedImages.get(t).add(e),this.removeFromImageRasterizerCache(e,t);}clearUpdatedImages(e){this.updatedImages.get(e).clear();}removeFromImageRasterizerCache(t,i){"raster"!==this.spriteFormat&&(e.r()?this.imageRasterizerDispatcher.getActor().send("removeRasterizedImages",{imageIds:[t],scope:i}):this.imageRasterizer.removeImagesFromCacheByIds([t],i));}removeImage(e,t){const i=this.images.get(t),o=i.get(e.toString());i.delete(e.toString()),this.patterns.get(t).delete(e.toString()),this.removeFromImageRasterizerCache(e,t),o.userImage&&o.userImage.onRemove&&o.userImage.onRemove();}listImages(t){return Array.from(this.images.get(t).keys()).map((t=>e.I.from(t)))}getImages(e,t,i){const o=[],s=[],r=this.imageProviders.get(t);for(const i of e){if(!i.iconsetId){o.push(i);continue}const e=r.get(i.iconsetId);e&&(this.getImage(i,t)?s.push(i):e.addPendingRequest(i));}if(0===o.length)return void this._notify(s,t,i);let n=!0;const a=!!this.loaded.get(t),l=this.images.get(t);if(!a)for(const e of o)l.has(e.toString())||(n=!1);a||n?this._notify(o,t,i):this.requestors.push({ids:o,scope:t,callback:i});}rasterizeImages(e,t){const i=new Map,{tasks:o,scope:s}=e;for(const[e,t]of o.entries()){const o=this.getImage(t.id,s);o&&i.set(e,{image:o,imageVariant:t});}this._rasterizeImages(s,i,t);}_rasterizeImages(t,i,o){if(e.r())this.imageRasterizerDispatcher.getActor().send("rasterizeImagesWorker",{tasks:i,scope:t},o);else {const e=new Map;for(const[o,{image:s,imageVariant:r}]of i.entries())e.set(o,this.imageRasterizer.rasterize(r,s,t,0));o(void 0,e);}}getUpdatedImages(e){return this.updatedImages.get(e)||new Set}_notify(t,i,o){const s=this.images.get(i),r=new Map;for(const i of t){if(!s.get(i.toString())){if(i.iconsetId)continue;this.fire(new e.z("styleimagemissing",{id:i.name}));}const t=s.get(i.toString());if(!t){e.w(`Image "${i.name}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`);continue}const o={data:t.usvg?null:t.data.clone(),pixelRatio:t.pixelRatio,sdf:t.sdf,usvg:t.usvg,version:t.version,stretchX:t.stretchX,stretchY:t.stretchY,content:t.content,hasRenderCallback:Boolean(t.userImage&&t.userImage.render)};t.usvg&&Object.assign(o,{width:t.icon.usvg_tree.width,height:t.icon.usvg_tree.height}),r.set(e.I.toString(i),o);}o(null,r);}getPixelSize(e){const{width:t,height:i}=this.atlasImage.get(e);return {width:t,height:i}}getPattern(t,i,o){const s=t.toString(),r=this.patterns.get(i),n=r.get(s),a=this.getImage(t,i);if(!a)return null;if(n){if(n.position.version===a.version)return n.position;n.position.version=a.version;}else {if(a.usvg&&!a.data){const r=this.getPatternInFlightId(s,i);if(this.patternsInFlight.has(r))return null;this.patternsInFlight.add(r);const n=new e.A(t).scaleSelf(e.o.devicePixelRatio),l=new Map([[n.toString(),{image:a,imageVariant:n}]]);return this._rasterizeImages(i,l,((e,t)=>this.storePatternImage(n,i,a,o,t))),null}this.storePattern(t,i,a);}return this._updatePatternAtlas(i,o),r.get(s).position}getPatternInFlightId(t,i){return e.B(t,i)}hasPatternsInFlight(){return 0!==this.patternsInFlight.size}storePatternImage(e,t,i,o,s){const r=e.toString(),n=s?s.get(r):void 0;n&&(i.data=n,this.storePattern(e.id,t,i),this._updatePatternAtlas(t,o),this.patternsInFlight.delete(this.getPatternInFlightId(e.id.toString(),t)));}storePattern(t,i,o){const s={w:o.data.width+2*e.C,h:o.data.height+2*e.C,x:0,y:0},r=new e.F(s,o,e.C);this.patterns.get(i).set(t.toString(),{bin:s,position:r});}destroyAtlasTextures(){for(const e of this.atlasTexture.values())e&&e.destroy();this.atlasTexture.clear();}bind(t,i){const o=t.gl;let s=this.atlasTexture.get(i);s?this.dirty&&(s.update(this.atlasImage.get(i)),this.dirty=!1):(s=new e.T(t,this.atlasImage.get(i),o.RGBA8),this.atlasTexture.set(i,s)),s.bind(o.LINEAR,o.CLAMP_TO_EDGE);}_updatePatternAtlas(t,i){const o=this.patterns.get(t),s=Array.from(o.values()).map((({bin:e})=>e)),{w:r,h:n}=e.G(s),a=this.atlasImage.get(t);a.resize({width:r||1,height:n||1});const l=this.images.get(t);for(const[t,{bin:s,position:r}]of o.entries()){let o=r.padding;const n=s.x+o,c=s.y+o,h=l.get(t).data,d=h.width,u=h.height;o=o>1?o-1:o,e.q.copy(h,a,{x:0,y:0},{x:n,y:c},{width:d,height:u},i),e.q.copy(h,a,{x:0,y:u-o},{x:n,y:c-o},{width:d,height:o},i),e.q.copy(h,a,{x:0,y:0},{x:n,y:c+u},{width:d,height:o},i),e.q.copy(h,a,{x:d-o,y:0},{x:n-o,y:c},{width:o,height:u},i),e.q.copy(h,a,{x:0,y:0},{x:n+d,y:c},{width:o,height:u},i),e.q.copy(h,a,{x:d-o,y:u-o},{x:n-o,y:c-o},{width:o,height:o},i),e.q.copy(h,a,{x:0,y:u-o},{x:n+d,y:c-o},{width:o,height:o},i),e.q.copy(h,a,{x:0,y:0},{x:n+d,y:c+u},{width:o,height:o},i),e.q.copy(h,a,{x:d-o,y:0},{x:n-o,y:c+u},{width:o,height:o},i);}this.dirty=!0;}beginFrame(){for(const e of this.images.keys())this.callbackDispatchedThisFrame.set(e,new Set);}dispatchRenderCallbacks(e,t){const i=this.images.get(t);for(const o of e){if(this.callbackDispatchedThisFrame.get(t).has(o.toString()))continue;this.callbackDispatchedThisFrame.get(t).add(o.toString());const e=i.get(o.toString());$(e)&&this.updateImage(o,t,e);}}destroy(){this.imageRasterizerDispatcher&&this.imageRasterizerDispatcher.remove();}}function Y(t){const i=t.value,o=t.valueSpec,s=t.style,r=t.styleSpec,n=t.key,a=t.arrayElementValidator||ve;if(!Array.isArray(i))return [new e.V(n,i,`array expected, ${e.K(i)} found`)];if(o.length&&i.length!==o.length)return [new e.V(n,i,`array length ${o.length} expected, length ${i.length} found`)];if(o["min-length"]&&i.length<o["min-length"])return [new e.V(n,i,`array length at least ${o["min-length"]} expected, length ${i.length} found`)];let l={type:o.value,values:o.values,minimum:o.minimum,maximum:o.maximum,function:void 0};r.$version<7&&(l.function=o.function),e.H(o.value)&&(l=o.value);let c=[];for(let e=0;e<i.length;e++)c=c.concat(a({array:i,arrayIndex:e,value:i[e],valueSpec:l,style:s,styleSpec:r,key:`${n}[${e}]`},!0));return c}function K(t){const i=t.key,o=t.value,s=t.valueSpec;if(!e.L(o))return [new e.V(i,o,`number expected, ${e.K(o)} found`)];if(o!=o)return [new e.V(i,o,"number expected, NaN found")];if("minimum"in s){let r=s.minimum;if(Array.isArray(s.minimum)&&(r=s.minimum[t.arrayIndex]),o<r)return [new e.V(i,o,`${o} is less than the minimum value ${r}`)]}if("maximum"in s){let r=s.maximum;if(Array.isArray(s.maximum)&&(r=s.maximum[t.arrayIndex]),o>r)return [new e.V(i,o,`${o} is greater than the maximum value ${r}`)]}return []}function J(t){const i=t.key,o=t.value;if(!e.H(o))return [new e.V(i,o,`object expected, ${e.K(o)} found`)];const s=t.valueSpec,r=e.J(o.type);let n,a,l,c={};const h="categorical"!==r&&void 0===o.property,d=!h,u=function(t){const i=t.stops;return Array.isArray(i)&&Array.isArray(i[0])&&e.H(i[0][0])}(o),_=ye({key:t.key,value:t.value,valueSpec:t.styleSpec.function,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===r)return [new e.V(t.key,t.value,'identity function may not have a "stops" property')];let i=[];const o=t.value;return i=i.concat(Y({key:t.key,value:o,valueSpec:t.valueSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:p})),Array.isArray(o)&&0===o.length&&i.push(new e.V(t.key,o,"array must have at least one stop")),i},default:function(e){return ve({key:e.key,value:e.value,valueSpec:s,style:e.style,styleSpec:e.styleSpec})}}});return "identity"===r&&h&&_.push(new e.V(t.key,t.value,'missing required property "property"')),"identity"===r||o.stops||_.push(new e.V(t.key,t.value,'missing required property "stops"')),"exponential"===r&&s.expression&&!e.M(s)&&_.push(new e.V(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(d&&!e.N(s)?_.push(new e.V(t.key,t.value,"property functions not supported")):h&&!e.O(s)&&_.push(new e.V(t.key,t.value,"zoom functions not supported"))),"categorical"!==r&&!u||void 0!==o.property||_.push(new e.V(t.key,t.value,'"property" property is required')),_;function p(t){let i=[];const o=t.value,r=t.key;if(!Array.isArray(o))return [new e.V(r,o,`array expected, ${e.K(o)} found`)];if(2!==o.length)return [new e.V(r,o,`array length 2 expected, length ${o.length} found`)];if(u){if(!e.H(o[0]))return [new e.V(r,o,`object expected, ${e.K(o[0])} found`)];const s=o[0];if(void 0===s.zoom)return [new e.V(r,o,"object stop key must have zoom")];if(void 0===s.value)return [new e.V(r,o,"object stop key must have value")];const n=e.J(s.zoom);if("number"!=typeof n)return [new e.V(r,s.zoom,"stop zoom values must be numbers")];if(l&&l>n)return [new e.V(r,s.zoom,"stop zoom values must appear in ascending order")];n!==l&&(l=n,a=void 0,c={}),i=i.concat(ye({key:`${r}[0]`,value:o[0],valueSpec:{zoom:{}},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:K,value:f}}));}else i=i.concat(f({key:`${r}[0]`,value:o[0],style:t.style,styleSpec:t.styleSpec},o));return e.Q(e.S(o[1]))?i.concat([new e.V(`${r}[1]`,o[1],"expressions are not allowed in function stops.")]):i.concat(ve({key:`${r}[1]`,value:o[1],valueSpec:s,style:t.style,styleSpec:t.styleSpec}))}function f(t,i){const o=e.K(t.value),l=e.J(t.value),h=null!==t.value?t.value:i;if(n){if(o!==n)return [new e.V(t.key,h,`${o} stop domain type must match previous stop domain type ${n}`)]}else n=o;if("number"!==o&&"string"!==o&&"boolean"!==o&&"number"!=typeof l&&"string"!=typeof l&&"boolean"!=typeof l)return [new e.V(t.key,h,"stop domain value must be a number, string, or boolean")];if("number"!==o&&"categorical"!==r){let i=`number expected, ${o} found`;return e.N(s)&&void 0===r&&(i+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new e.V(t.key,h,i)]}return "categorical"!==r||"number"!==o||"number"==typeof l&&isFinite(l)&&Math.floor(l)===l?"categorical"!==r&&"number"===o&&"number"==typeof l&&"number"==typeof a&&void 0!==a&&l<a?[new e.V(t.key,h,"stop domain values must appear in ascending order")]:(a=l,"categorical"===r&&l in c?[new e.V(t.key,h,"stop domain values must be unique")]:(c[l]=!0,[])):[new e.V(t.key,h,`integer expected, found ${String(l)}`)]}}function Q(t){const i=("property"===t.expressionContext?e.W:e.U)(e.S(t.value),t.valueSpec);if("error"===i.result)return i.value.map((i=>new e.V(`${t.key}${i.key}`,t.value,i.message)));const o=i.value.expression||i.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!o.outputDefined())return [new e.V(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!e.Z(o))return [new e.V(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext)return ee(o,t);if("appearance"===t.expressionContext)return te(o,t);if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!e.X(o,["zoom","feature-state"]))return [new e.V(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!e.Y(o))return [new e.V(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return []}function ee(t,i){const o=new Set(["zoom","feature-state","pitch","distance-from-center"]);if(i.valueSpec&&i.valueSpec.expression)for(const e of i.valueSpec.expression.parameters)o.delete(e);if(0===o.size)return [];const s=[];return t instanceof e._&&o.has(t.name)?[new e.V(i.key,i.value,`["${t.name}"] expression is not supported in a filter for a ${i.object.type} layer with id: ${i.object.id}`)]:(t.eachChild((e=>{s.push(...ee(e,i));})),s)}function te(t,i){const o=new Set;if(i.valueSpec&&i.valueSpec.expression)for(const e of i.valueSpec.expression.parameters)o.add(e);if(0===o.size)return [];const s=[];return t instanceof e._&&!o.has(t.name)?[new e.V(i.key,i.value,`["${t.name}"] is not an allowed parameter`)]:(t.eachChild((e=>{s.push(...te(e,i));})),s)}function ie(t){const i=t.key,o=t.value,s=t.valueSpec,r=[];return Array.isArray(s.values)?-1===s.values.indexOf(e.J(o))&&r.push(new e.V(i,o,`expected one of [${s.values.join(", ")}], ${JSON.stringify(o)} found`)):-1===Object.keys(s.values).indexOf(e.J(o))&&r.push(new e.V(i,o,`expected one of [${Object.keys(s.values).join(", ")}], ${JSON.stringify(o)} found`)),r}function oe(t){return e.a2(e.S(t.value))?Q(Object.assign({},t,{expressionContext:"filter",valueSpec:t.styleSpec[`filter_${t.layerType||"fill"}`]})):se(t)}function se(t){const i=t.value,o=t.key;if(!Array.isArray(i))return [new e.V(o,i,`array expected, ${e.K(i)} found`)];if(i.length<1)return [new e.V(o,i,"filter array must have at least 1 element")];const s=t.styleSpec;let r=ie({key:`${o}[0]`,value:i[0],valueSpec:s.filter_operator});const n=()=>{i.length>=2&&(e.a0(i[1])||r.push(new e.V(`${o}[1]`,i[1],`string expected, ${e.K(i[1])} found`)));for(let t=2;t<i.length;t++)"$type"===e.J(i[1])?r=r.concat(ie({key:`${o}[${t}]`,value:i[t],valueSpec:s.geometry_type})):e.a0(i[t])||e.L(i[t])||e.$(i[t])||r.push(new e.V(`${o}[${t}]`,i[t],`string, number, or boolean expected, ${e.K(i[t])} found.`));};switch(e.J(i[0])){case "<":case "<=":case ">":case ">=":i.length>=2&&"$type"===e.J(i[1])&&r.push(new e.V(o,i,`"$type" cannot be use with operator "${i[0]}"`)),3!==i.length&&r.push(new e.V(o,i,`filter array for operator "${i[0]}" must have 3 elements`)),n();break;case "==":case "!=":3!==i.length&&r.push(new e.V(o,i,`filter array for operator "${i[0]}" must have 3 elements`)),n();break;case "in":case "!in":n();break;case "any":case "all":case "none":for(let e=1;e<i.length;e++)r=r.concat(se({key:`${o}[${e}]`,value:i[e],style:t.style,styleSpec:t.styleSpec}));break;case "has":case "!has":2!==i.length?r.push(new e.V(o,i,`filter array for "${i[0]}" operator must have 2 elements`)):e.a0(i[1])||r.push(new e.V(`${o}[1]`,i[1],`string expected, ${e.K(i[1])} found`));}return r}function re(t,i){const o=t.key,s=t.style,r=t.layer,n=t.styleSpec,a=t.value,l=t.objectKey,c=n[`${i}_${t.layerType}`];if(!c)return [];const h=l.match(/^(.*)-use-theme$/);if(h&&c[h[1]])return e.Q(e.S(a))?[].concat(ve({key:o,value:a,valueSpec:{type:"string",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},style:s,styleSpec:n,expressionContext:"property",propertyType:i,propertyKey:l})):ve({key:o,value:a,valueSpec:{type:"string"},style:s,styleSpec:n});const d=l.match(/^(.*)-transition$/);if("paint"===i&&d&&c[d[1]]&&c[d[1]].transition)return ve({key:o,value:a,valueSpec:n.transition,style:s,styleSpec:n});const u=t.valueSpec||c[l];if(!u)return [new e.a3(o,a,`unknown property "${l}"`)];let _;if(e.a0(a)&&e.N(u)&&!u.tokens&&(_=/^{([^}]+)}$/.exec(a))){const t=`\`{ "type": "identity", "property": ${_?JSON.stringify(_[1]):'"_"'} }\``;return [new e.V(o,a,`"${l}" does not support interpolation syntax\nUse an identity property function instead: ${t}.`)]}const p=[];if("symbol"===t.layerType)"text-field"!==l||!s||s.glyphs||s.imports||p.push(new e.V(o,a,'use of "text-field" requires a style "glyphs" property')),"text-font"===l&&e.a4(e.S(a))&&"identity"===e.J(a.type)&&p.push(new e.V(o,a,'"text-font" does not support identity functions'));else if("model"===t.layerType&&"paint"===i&&r&&r.layout&&r.layout.hasOwnProperty("model-id")&&e.N(u)&&(e.a5(u)||e.O(u))){const t=e.W(e.S(a),u).value,i="expression"in t&&t.expression||"_styleExpression"in t&&t._styleExpression&&t._styleExpression.expression;i&&!e.X(i,["measure-light"])&&("model-emissive-strength"===l&&e.Y(i)&&e.Z(i)||p.push(new e.V(o,a,`${l} does not support measure-light expressions when the model layer source is vector tile or GeoJSON.`)));}return p.concat(ve({key:t.key,value:a,valueSpec:u,style:s,styleSpec:n,expressionContext:"property",propertyType:i,propertyKey:l}))}function ne(e){return re(e,"paint")}function ae(e){return re(e,"layout")}function le(t){let i=[];const o=t.value,s=t.key,r=t.style,n=t.styleSpec;if(!e.H(o))return [new e.V(s,o,"object expected")];o.type||o.ref||i.push(new e.V(s,o,'either "type" or "ref" is required'));let a=e.J(o.type);const l=e.J(o.ref);if(o.id){const n=e.J(o.id);for(let a=0;a<t.arrayIndex;a++){const t=r.layers[a];e.J(t.id)===n&&i.push(new e.V(s,o.id,`duplicate layer id "${n}", previously used at line ${t.id.__line__}`));}}if("ref"in o){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in o&&i.push(new e.V(s,o[t],`"${t}" is prohibited for ref layers`));})),r.layers.forEach((i=>{e.J(i.id)===l&&(t=i);})),t?t.ref?i.push(new e.V(s,o.ref,"ref cannot reference another ref layer")):a=e.J(t.type):"string"==typeof l&&i.push(new e.V(s,o.ref,`ref layer "${l}" not found`));}else if("background"!==a&&"sky"!==a&&"slot"!==a)if(o.source)if(e.a0(o.source)){const t=r.sources&&r.sources[o.source],n=t&&e.J(t.type);t?"vector"===n&&"raster"===a?i.push(new e.V(s,o.source,`layer "${o.id}" requires a raster source`)):"raster"===n&&"raster"!==a?i.push(new e.V(s,o.source,`layer "${o.id}" requires a vector source`)):"vector"!==n||o["source-layer"]?"raster-dem"===n&&"hillshade"!==a?i.push(new e.V(s,o.source,"raster-dem source can only be used with layer type 'hillshade'.")):"raster-array"!==n||["raster","raster-particle"].includes(a)?"line"===a&&o.paint&&(o.paint["line-gradient"]||o.paint["line-trim-offset"])&&"geojson"===n&&!t.lineMetrics?i.push(new e.V(s,o,`layer "${o.id}" specifies a line-gradient, which requires the GeoJSON source to have \`lineMetrics\` enabled.`)):"raster-particle"===a&&"raster-array"!==n&&i.push(new e.V(s,o.source,`layer "${o.id}" requires a 'raster-array' source.`)):i.push(new e.V(s,o.source,"raster-array source can only be used with layer type 'raster'.")):i.push(new e.V(s,o,`layer "${o.id}" must specify a "source-layer"`)):i.push(new e.V(s,o.source,`source "${o.source}" not found`));}else i.push(new e.V(`${s}.source`,o.source,'"source" must be a string'));else i.push(new e.V(s,o,'missing required property "source"'));return i=i.concat(ye({key:s,value:o,valueSpec:n.layer,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":()=>[],type:()=>ve({key:`${s}.type`,value:o.type,valueSpec:n.layer.type,style:t.style,styleSpec:t.styleSpec,object:o,objectKey:"type"}),filter:e=>oe(Object.assign({layerType:a},e)),layout:e=>ye({layer:o,key:e.key,value:e.value,valueSpec:{},style:e.style,styleSpec:e.styleSpec,objectElementValidators:{"*":e=>ae(Object.assign({layerType:a},e))}}),paint:e=>ye({layer:o,key:e.key,value:e.value,valueSpec:{},style:e.style,styleSpec:e.styleSpec,objectElementValidators:{"*":e=>ne(Object.assign({layerType:a,layer:o},e))}}),appearances(t){const i=Y({key:t.key,value:t.value,valueSpec:t.valueSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:t=>function(t){const{key:i,layer:o,layerType:s}=t,r=e.J(t.value),n=e.J(r.name),a=e.J(r.condition),l=ye({key:i,value:r,valueSpec:t.styleSpec.appearance,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{condition:t=>function(t){const i=[];return i.push(...Q({key:t.key,value:t.object.condition,valueSpec:e.a6.appearance.condition,expressionContext:"appearance"})),i}(Object.assign({layer:o,layerType:s},t)),properties:t=>function(t){const i=[],{styleSpec:o,layer:s,layerType:r}=t,n=o[`paint_${r}`],a=o[`layout_${r}`],l=t.object[t.objectKey];for(const o in l){const c=o in n?"paint":o in a?"layout":void 0;if(!c){i.push(new e.V(t.key,o,`unknown property "${o}" for layer type "${r}"`));continue}const h=Object.assign({},t,{key:`${t.key}.${o}`,object:l,objectKey:o,layer:s,layerType:r,value:l[o],valueSpec:"paint"===c?n[o]:a[o]});i.push(...re(h,c));}return i}(Object.assign({layer:o,layerType:s},t))}});return "hidden"!==n&&void 0===a&&l.push(new e.V(t.key,"name",'Appearance with name different than "hidden" must have a condition')),l}(Object.assign({layerType:a,layer:o},t))}),s=Array.isArray(t.value)?t.value:[],r=new Set;return s.forEach(((s,n)=>{const a=e.J(s.name);if(a)if(r.has(a)){const s=e.J(o.id);i.push(new e.V(t.key,a,`Duplicated appearance name "${a}" for layer "${s}"`));}else r.add(a);})),i}}})),i}function ce({key:t,value:i}){return e.a0(i)?[]:[new e.V(t,i,`string expected, ${e.K(i)} found`)]}const he={promoteId:function t({key:i,value:o}){if(e.a0(o))return ce({key:i,value:o});if(Array.isArray(o)){const t=[],s=e.S(o),r=e.U(s);return "error"===r.result&&r.value.forEach((o=>{t.push(new e.V(`${i}${o.key}`,null,`${o.message}`));})),e.X(r.value.expression,["zoom","heatmap-density","line-progress","raster-value","sky-radial-progress","accumulated","is-supported-script","pitch","distance-from-center","measure-light","raster-particle-speed"])||t.push(new e.V(`${i}`,null,"promoteId expression should be only feature dependent")),t}if(!e.H(o))return [new e.V(i,o,`string, expression or object expected, "${e.K(o)}" found`)];const s=[];for(const e in o)s.push(...t({key:`${i}.${e}`,value:o[e]}));return s}};function de(t){const i=t.value,o=t.key,s=t.styleSpec,r=t.style;if(!e.H(i))return [new e.V(o,i,`object expected, ${e.K(i)} found`)];if(!("type"in i))return [new e.V(o,i,'"type" is required')];const n=e.J(i.type);let a=[];switch(["vector","raster","raster-dem","raster-array"].includes(n)&&("url"in i||"tiles"in i||a.push(new e.a3(o,i,'Either "url" or "tiles" is required.'))),n){case "vector":case "raster":case "raster-dem":case "raster-array":return a=a.concat(ye({key:o,value:i,valueSpec:s[`source_${n.replace("-","_")}`],style:t.style,styleSpec:s,objectElementValidators:he})),a;case "geojson":if(a=ye({key:o,value:i,valueSpec:s.source_geojson,style:r,styleSpec:s,objectElementValidators:he}),"cluster"in i&&"clusterProperties"in i){if(!e.H(i.clusterProperties))return [new e.V(`${o}.clusterProperties`,i,`object expected, ${e.K(i)} found`)];for(const t in i.clusterProperties){const s=i.clusterProperties[t];if(!Array.isArray(s))return [new e.V(`${o}.clusterProperties.${t}`,s,"array expected")];const[r,n]=s,l="string"==typeof r?[r,["accumulated"],["get",t]]:r;a.push(...Q({key:`${o}.${t}.map`,value:n,expressionContext:"cluster-map"})),a.push(...Q({key:`${o}.${t}.reduce`,value:l,expressionContext:"cluster-reduce"}));}}return a;case "video":return ye({key:o,value:i,valueSpec:s.source_video,style:r,styleSpec:s});case "image":return ye({key:o,value:i,valueSpec:s.source_image,style:r,styleSpec:s});case "canvas":return [new e.V(o,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return ie({key:`${o}.type`,value:i.type,valueSpec:{values:ue(s)}})}}function ue(e){return e.source.reduce(((t,i)=>{const o=e[i];return "enum"===o.type.type&&(t=t.concat(Object.keys(o.type.values||{}))),t}),[])}function _e(t){const i=t.value,o=t.styleSpec,s=o.light,r=t.style;if(void 0===i)return [];if(!e.H(i))return [new e.V("light",i,`object expected, ${e.K(i)} found`)];let n=[];for(const t in i){const a=t.match(/^(.*)-transition$/),l=t.match(/^(.*)-use-theme$/);n=n.concat(l&&s[l[1]]?ve({key:t,value:i[t],valueSpec:{type:"string"},style:r,styleSpec:o}):a&&s[a[1]]&&s[a[1]].transition?ve({key:t,value:i[t],valueSpec:o.transition,style:r,styleSpec:o}):s[t]?ve({key:t,value:i[t],valueSpec:s[t],style:r,styleSpec:o}):[new e.V(t,i[t],`unknown property "${t}"`)]);}return n}function pe(t){const i=t.value;if(!i)return [];const o=t.key;if(!e.H(i))return [new e.V(o,i,`object expected, ${e.K(i)} found`)];let s=[];const r=t.styleSpec,n=r["light-3d"],a=t.style,l=t.style.lights;for(const t of ["type","id"])if(!(t in i))return s=s.concat([new e.V(o,i,`missing property "${t}"`)]),s;if(!e.a0(i.type))return s=s.concat([new e.V(`${o}.type`,i.type,"string expected")]),s;if(l)for(let r=0;r<t.arrayIndex;r++){const t=e.J(i.type),n=l[r];e.J(n.type)===t&&s.push(new e.V(o,i.id,`duplicate light type "${i.type}", previously defined at line ${n.id.__line__}`));}const c=`properties_light_${i.type}`;if(!(c in r))return s=s.concat([new e.V(`${o}.type`,i,`Invalid light type ${i.type}`)]),s;const h=r[c];for(const o in i)if("properties"===o){const n=i[o];if(!e.H(n))return s=s.concat([new e.V("properties",n,`object expected, ${e.K(n)} found`)]),s;for(const l in n){const c=l.match(/^(.*)-transition$/),d=l.match(/^(.*)-use-theme$/);s=s.concat(d&&h[d[1]]?ve({key:o,value:n[l],valueSpec:{type:"string"},style:a,styleSpec:r}):c&&h[c[1]]&&h[c[1]].transition?ve({key:o,value:i[o],valueSpec:r.transition,style:a,styleSpec:r}):h[l]?ve({key:l,value:n[l],valueSpec:h[l],style:a,styleSpec:r}):[new e.a3(t.key,n[l],`unknown property "${l}"`)]);}}else s=s.concat(n[o]?ve({key:o,value:i[o],valueSpec:n[o],style:a,styleSpec:r}):[new e.a3(o,i[o],`unknown property "${o}"`)]);return s}function fe(t){const i=t.value,o=t.key,s=t.style,r=t.styleSpec,n=r.terrain;if(null==i)return [];if(!e.H(i))return [new e.V("terrain",i,`object expected, ${e.K(i)} found`)];let a=[];for(const t in i){const o=t.match(/^(.*)-transition$/),l=t.match(/^(.*)-use-theme$/);a=a.concat(l&&n[l[1]]?ve({key:t,value:i[t],valueSpec:{type:"string"},style:s,styleSpec:r}):o&&n[o[1]]&&n[o[1]].transition?ve({key:t,value:i[t],valueSpec:r.transition,style:s,styleSpec:r}):n[t]?ve({key:t,value:i[t],valueSpec:n[t],style:s,styleSpec:r}):[new e.a3(t,i[t],`unknown property "${t}"`)]);}if(i.source)if(e.a0(i.source)){const t=s.sources&&s.sources[i.source],r=t&&e.J(t.type);t?"raster-dem"!==r&&a.push(new e.V(`${o}.source`,i.source,`terrain cannot be used with a source of type ${r}, it only be used with a "raster-dem" source type`)):a.push(new e.V(`${o}.source`,i.source,`source "${i.source}" not found`));}else a.push(new e.V(`${o}.source`,i.source,"source must be a string"));else a.push(new e.V(o,i,'terrain is missing required property "source"'));return a}function me(t){const i=t.value,o=t.style,s=t.styleSpec,r=s.fog;if(void 0===i)return [];if(!e.H(i))return [new e.V("fog",i,`object expected, ${e.K(i)} found`)];let n=[];for(const t in i){const a=t.match(/^(.*)-transition$/),l=t.match(/^(.*)-use-theme$/);n=n.concat(l&&r[l[1]]?ve({key:t,value:i[t],valueSpec:{type:"string"},style:o,styleSpec:s}):a&&r[a[1]]&&r[a[1]].transition?ve({key:t,value:i[t],valueSpec:s.transition,style:o,styleSpec:s}):r[t]?ve({key:t,value:i[t],valueSpec:r[t],style:o,styleSpec:s}):[new e.a3(t,i[t],`unknown property "${t}"`)]);}return n}const ge={"*":()=>[],array:Y,boolean:function(t){const i=t.value,o=t.key;return e.$(i)?[]:[new e.V(o,i,`boolean expected, ${e.K(i)} found`)]},number:K,color:function({key:t,value:i}){return e.a0(i)?null===e.a1.parseCSSColor(i)?[new e.V(t,i,`color expected, "${i}" found`)]:[]:[new e.V(t,i,`color expected, ${e.K(i)} found`)]},enum:ie,filter:oe,function:J,layer:le,object:ye,source:de,model:e.a7,light:_e,"light-3d":pe,terrain:fe,fog:me,string:ce,formatted:function(e){return 0===ce(e).length?[]:Q(e)},resolvedImage:function(e){return 0===ce(e).length?[]:Q(e)},projection:function(t){const i=t.value,o=t.styleSpec,s=o.projection,r=t.style;if(e.H(i)){let e=[];for(const t in i)e=e.concat(ve({key:t,value:i[t],valueSpec:s[t],style:r,styleSpec:o}));return e}return e.a0(i)?[]:[new e.V("projection",i,`object or string expected, ${e.K(i)} found`)]},import:function(t){const i=t.key,{value:o,styleSpec:s}=t;if(!e.H(o))return [new e.V(i,o,"import must be an object")];const{data:r,...n}=o;Object.defineProperty(n,"__line__",{value:o.__line__,enumerable:!1});let a=ye(Object.assign({},t,{value:n,valueSpec:s.import}));return ""===e.J(n.id)&&a.push(new e.V(`${t.key}.id`,n,"import id can't be an empty string")),r&&(a=a.concat(be(r,s,{key:`${t.key}.data`}))),a},iconset:function(t){const i=t.value,o=t.key,s=t.styleSpec,r=t.style;if(!e.H(i))return [new e.V(o,i,"object expected")];if(!i.type)return [new e.V(o,i,'"type" is required')];const n=e.J(i.type);let a=[];if(a=a.concat(ye({key:o,value:i,valueSpec:s[`iconset_${n}`],style:r,styleSpec:s})),function(e,t){return !("source"!==e||!t.source)}(n,i)){const t=r.sources&&r.sources[i.source],s=t&&e.J(t.type);t?"raster-array"!==s&&a.push(new e.V(o,i.source,`iconset cannot be used with a source of type ${String(s)}, it only be used with a "raster-array" source type`)):a.push(new e.V(o,i.source,`source "${i.source}" not found`));}return a}};function ve(t,i=!1){const o=t.value,s=t.valueSpec,r=t.styleSpec;if(s.expression){if(e.a4(e.J(o)))return J(t);if(e.Q(e.S(o)))return Q(t)}if(s.type&&ge[s.type]){const e=ge[s.type](t);return !0===i&&e.length>0&&Array.isArray(t.value)?Q(t):e}return ye(Object.assign({},t,{valueSpec:s.type?r[s.type]:s}))}function ye(t){const i=t.key,o=t.value,s=t.valueSpec||{},r=t.objectElementValidators||{},n=t.style,a=t.styleSpec;if(!e.H(o))return [new e.V(i,o,`object expected, ${e.K(o)} found`)];let l=[];for(const t in o){const c=t.split(".")[0];let h;r[c]?h=r[c]:s[c]?h=ve:r["*"]?h=r["*"]:s["*"]&&(h=ve),h?l=l.concat(h({key:(i?`${i}.`:i)+t,value:o[t],valueSpec:s[c]||s["*"],style:n,styleSpec:a,object:o,objectKey:t},o)):l.push(new e.a3(i,o[t],`unknown property "${t}"`));}for(const t in s){if(r[t])continue;const n=s[t];n.required&&void 0===n.default&&void 0===o[t]&&l.push(new e.V(i,o,`missing required property "${t}"`));}return l}function xe({key:t,value:i}){const o=ce({key:t,value:i});if(o.length)return o;const s=i;return -1===s.indexOf("{fontstack}")&&o.push(new e.V(t,i,'"glyphs" url must include a "{fontstack}" token')),-1===s.indexOf("{range}")&&o.push(new e.V(t,i,'"glyphs" url must include a "{range}" token')),o}function be(t,i=e.a6,o={}){return ye({key:o.key||"",value:t,valueSpec:Object.assign(i.$root,{"*":{type:"*"}}),styleSpec:i,style:t,objectElementValidators:{glyphs:xe}})}function we(t,i=e.a6){return Me(be(t,i))}const Te=e=>Me(de(e)),Ee=e=>Me(_e(e)),Se=e=>Me(pe(e)),Ie=e=>Me(fe(e)),Ce=e=>Me(me(e)),Re=t=>Me(function(t){const i=t.value,o=t.style,s=t.styleSpec,r=s.snow;if(void 0===i)return [];if(!e.H(i))return [new e.V("snow",i,`object expected, ${e.K(i)} found`)];let n=[];for(const t in i){const a=t.match(/^(.*)-transition$/);n=n.concat(a&&r[a[1]]&&r[a[1]].transition?ve({key:t,value:i[t],valueSpec:s.transition,style:o,styleSpec:s}):r[t]?ve({key:t,value:i[t],valueSpec:r[t],style:o,styleSpec:s}):[new e.a3(t,i[t],`unknown property "${t}"`)]);}return n}(t)),Ae=t=>Me(function(t){const i=t.value,o=t.style,s=t.styleSpec,r=s.rain;if(void 0===i)return [];if(!e.H(i))return [new e.V("rain",i,`object expected, ${e.K(i)} found`)];let n=[];for(const t in i){const a=t.match(/^(.*)-transition$/);n=n.concat(a&&r[a[1]]&&r[a[1]].transition?ve({key:t,value:i[t],valueSpec:s.transition,style:o,styleSpec:s}):r[t]?ve({key:t,value:i[t],valueSpec:r[t],style:o,styleSpec:s}):[new e.a3(t,i[t],`unknown property "${t}"`)]);}return n}(t)),Le=e=>Me(le(e)),De=e=>Me(oe(e)),Pe=e=>Me(ne(e)),Oe=e=>Me(ae(e)),ze=t=>Me(e.a7(t));function Me(e){return e.slice().sort(((e,t)=>e.line&&t.line?e.line-t.line:0))}function Fe(t,i){let o=!1;if(i&&i.length)for(const s of i)s instanceof e.a3?e.w(s.message):(t.fire(new e.y(new Error(s.message))),o=!0);return o}const Be=e.a6.light;let ke;class Ne extends e.E{constructor(t,i="flat"){super(),this._transitionable=new e.a8(ke||(ke=new e.a9({anchor:new e.aa(Be.anchor),position:new e.ab(Be.position),color:new e.aa(Be.color),intensity:new e.aa(Be.intensity)}))),this.setLight(t,i),this._transitioning=this._transitionable.untransitioned();}getLight(){return this._transitionable.serialize()}setLight(e,t,i={}){this._validate(Ee,e,i)||(this._transitionable.setTransitionOrValue(e),this.id=t);}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&Fe(this,t.call(we,Object.assign({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.a6})))}}const Ue=e.a6.terrain;let je=class extends e.E{constructor(t,i,o,s,r){super(),this.scope=o,this._transitionable=new e.a8(new e.a9({source:new e.aa(Ue.source),exaggeration:new e.aa(Ue.exaggeration)}),o,s),this._transitionable.setTransitionOrValue(t,s),this._transitioning=this._transitionable.untransitioned(),this.drapeRenderMode=i,this.worldview=r;}get(){return this._transitionable.serialize()}set(e,t){this._transitionable.setTransitionOrValue(e,t);}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}getExaggeration(t){return this._transitioning.possiblyEvaluate(new e.ac(t,{worldview:this.worldview})).get("exaggeration")}getAttenuationRange(){if(!this.isZoomDependent())return null;const t=this._transitionable._values.exaggeration;if(!t)return null;const i=t.value.expression;if(!i)return null;let o=-1,s=-1,r=1;for(const t of i.zoomStops)r=i.evaluate(new e.ac(t,{worldview:this.worldview})),r>.01?(o=t,s=-1):s=t;return r<.01&&o>0&&s>o?[o,s]:null}isZoomDependent(){const t=this._transitionable._values.exaggeration;return null!=t&&null!=t.value&&null!=t.value.expression&&t.value.expression instanceof e.ad}};const Ge=45,Ve=65,He=.05;function qe(t,i,o,s){const r=e.ah(Ge,Ve,o),[n,a]=Ze(t,s);let l=1-Math.min(1,Math.exp((i-n)/(a-n)*-6));return l*=l*l,l=Math.min(1,1.00747*l),l*r*t.alpha}function Ze(e,t){const i=.5/Math.tan(.5*t);return [e.range[0]+i,e.range[1]+i]}function We(t,i,o,s,r){const n=e.af([],[i,o,s],r.mercatorFogMatrix);return qe(t,e.ag(n),r.pitch,r._fov)}function $e(t,i,o,s,r,n,a){const l=[[o,s,0],[r,s,0],[r,n,0],[o,n,0]];let c=Number.MAX_VALUE,h=-Number.MAX_VALUE;for(const t of l){const o=e.af([],t,i),s=e.ag(o);c=Math.min(c,s),h=Math.max(h,s);}return [qe(t,c,a.pitch,a._fov),qe(t,h,a.pitch,a._fov)]}const Xe=e.a6.fog;class Ye extends e.E{constructor(t,i,o,s){super();const r=new e.a9({range:new e.aa(Xe.range),color:new e.aa(Xe.color),"color-use-theme":new e.aa({type:"string","property-type":"data-constant",default:"default"}),"high-color":new e.aa(Xe["high-color"]),"high-color-use-theme":new e.aa({type:"string","property-type":"data-constant",default:"default"}),"space-color":new e.aa(Xe["space-color"]),"space-color-use-theme":new e.aa({type:"string","property-type":"data-constant",default:"default"}),"horizon-blend":new e.aa(Xe["horizon-blend"]),"star-intensity":new e.aa(Xe["star-intensity"]),"vertical-range":new e.aa(Xe["vertical-range"])});this._transitionable=new e.a8(r,o,new Map(s)),this.set(t,s),this._transitioning=this._transitionable.untransitioned(),this._transform=i,this.properties=new e.ai(r),this.scope=o;}get state(){const t=this._transform,i="globe"===t.projection.name,o=e.aj(t.zoom),s=this.properties.get("range"),r=[.5,3];return {range:i?[e.ak(r[0],s[0],o),e.ak(r[1],s[1],o)]:s,horizonBlend:this.properties.get("horizon-blend"),alpha:this.properties.get("color").a}}get(){return this._transitionable.serialize()}set(e,t,i={}){if(this._validate(Ce,e,i))return;const o=Object.assign({},e);for(const e of Object.keys(Xe))void 0===o[e]&&(o[e]=Xe[e].default);this._options=o,this._transitionable.setTransitionOrValue(this._options,t);}getOpacity(t){if(!this._transform.projection.supportsFog)return 0;const i=this.properties&&this.properties.get("color")||1;return ("globe"===this._transform.projection.name?1:e.ah(Ge,Ve,t))*i.a}getOpacityAtLatLng(t,i){return this._transform.projection.supportsFog?function(t,i,o){const s=e.ae.fromLngLat(i),r=o.elevation?o.elevation.getAtPointOrZero(s):0;return We(t,s.x,s.y,r,o)}(this.state,t,i):0}getOpacityForTile(t){if(!this._transform.projection.supportsFog)return [1,1];const i=this._transform.calculateFogTileMatrix(t.toUnwrapped());return $e(this.state,i,0,0,e.al,e.al,this._transform)}getOpacityForBounds(e,t,i,o,s){return this._transform.projection.supportsFog?$e(this.state,e,t,i,o,s,this._transform):[1,1]}getFovAdjustedRange(e){return this._transform.projection.supportsFog?Ze(this.state,e):[0,1]}isVisibleOnFrustum(t){if(!this._transform.projection.supportsFog)return !1;const i=[4,5,6,7];for(const o of i){const i=t.points[o];let s;if(i[2]>=0)s=i;else {const r=t.points[o-4];s=e.am(r,i,r[2]/(r[2]-i[2]));}if(We(this.state,s[0],s[1],0,this._transform)>=He)return !0}return !1}updateConfig(e){this._transitionable.setTransitionOrValue(this._options,new Map(e));}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&Fe(this,t.call(we,Object.assign({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.a6})))}}let Ke,Je,Qe,et,tt=class extends e.E{constructor(t,i,o,s){super();const r=Ke||(Ke=new e.a9({density:new e.aa(e.a6.snow.density),intensity:new e.aa(e.a6.snow.intensity),color:new e.aa(e.a6.snow.color),opacity:new e.aa(e.a6.snow.opacity),vignette:new e.aa(e.a6.snow.vignette),"vignette-color":new e.aa(e.a6.snow["vignette-color"]),"center-thinning":new e.aa(e.a6.snow["center-thinning"]),direction:new e.aa(e.a6.snow.direction),"flake-size":new e.aa(e.a6.snow["flake-size"])}));this._transitionable=new e.a8(r,o,new Map(s)),this.set(t,s),this._transitioning=this._transitionable.untransitioned(),this.properties=new e.ai(r),this.scope=o;}get state(){const t=this.properties.get("opacity"),i=this.properties.get("color"),o=this.properties.get("direction"),s=e.an(o[0]),r=-Math.max(e.an(o[1]),.01),n=[Math.cos(s)*Math.cos(r),Math.sin(s)*Math.cos(r),Math.sin(r)],a=this.properties.get("vignette"),l=this.properties.get("vignette-color");return l.a=a,{density:this.properties.get("density"),intensity:this.properties.get("intensity"),color:new e.ao(i.r,i.g,i.b,i.a*t),direction:n,centerThinning:this.properties.get("center-thinning"),flakeSize:this.properties.get("flake-size"),vignetteColor:l}}get(){return this._transitionable.serialize()}set(t,i,o={}){if(this._validate(Re,t,o))return;const s=Object.assign({},t),r=e.a6.snow;for(const e of Object.keys(r))void 0===s[e]&&(s[e]=r[e].default);this._options=s,this._transitionable.setTransitionOrValue(this._options,i);}updateConfig(e){this._transitionable.setTransitionOrValue(this._options,new Map(e));}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&Fe(this,t.call(we,Object.assign({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.a6})))}},it=class extends e.E{constructor(t,i,o,s){super();const r=Je||(Je=new e.a9({density:new e.aa(e.a6.rain.density),intensity:new e.aa(e.a6.rain.intensity),color:new e.aa(e.a6.rain.color),opacity:new e.aa(e.a6.rain.opacity),vignette:new e.aa(e.a6.rain.vignette),"vignette-color":new e.aa(e.a6.rain["vignette-color"]),"center-thinning":new e.aa(e.a6.rain["center-thinning"]),direction:new e.aa(e.a6.rain.direction),"droplet-size":new e.aa(e.a6.rain["droplet-size"]),"distortion-strength":new e.aa(e.a6.rain["distortion-strength"])}));this._transitionable=new e.a8(r,o,new Map(s)),this.set(t,s),this._transitioning=this._transitionable.untransitioned(),this.properties=new e.ai(r),this.scope=o;}get state(){const t=this.properties.get("opacity"),i=this.properties.get("color"),o=this.properties.get("direction"),s=e.an(o[0]),r=-Math.max(e.an(o[1]),.01),n=[Math.cos(s)*Math.cos(r),Math.sin(s)*Math.cos(r),Math.sin(r)],a=this.properties.get("vignette-color");return a.a=this.properties.get("vignette"),{density:this.properties.get("density"),intensity:this.properties.get("intensity"),color:new e.ao(i.r,i.g,i.b,i.a*t),direction:n,centerThinning:this.properties.get("center-thinning"),dropletSize:this.properties.get("droplet-size"),distortionStrength:this.properties.get("distortion-strength"),vignetteColor:a}}get(){return this._transitionable.serialize()}set(t,i,o={}){if(this._validate(Ae,t,o))return;const s=Object.assign({},t),r=e.a6.rain;for(const e of Object.keys(r))void 0===s[e]&&(s[e]=r[e].default);this._options=s,this._transitionable.setTransitionOrValue(this._options,i);}updateConfig(e){this._transitionable.setTransitionOrValue(this._options,new Map(e));}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&Fe(this,t.call(we,Object.assign({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.a6})))}};class ot extends e.E{constructor(t,i,o,s){super(),this.scope=o,this._options=t,this.properties=new e.ai(i),this._transitionable=new e.a8(i,o,new Map(s)),this._transitionable.setTransitionOrValue(t.properties),this._transitioning=this._transitionable.untransitioned();}updateConfig(e){this._transitionable.setTransitionOrValue(this._options.properties,new Map(e));}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}get(){return this._options.properties=this._transitionable.serialize(),this._options}set(e,t){this._options=e,this._transitionable.setTransitionOrValue(e.properties,t);}shadowsEnabled(){return !!this.properties&&!0===this.properties.get("cast-shadows")}}class st{constructor(e,t,i){this.screenBounds=e,this.cameraPoint=i.getCameraPoint(),this._screenRaycastCache={},this._cameraRaycastCache={},this.isAboveHorizon=t,this.screenGeometry=this.bufferedScreenGeometry(0),this.screenGeometryMercator=this._bufferedScreenMercator(0,i);}static createFromScreenPoints(t,i){let o,s;if(t instanceof e.P||"number"==typeof t[0]){const r=e.P.convert(t);o=[r],s=i.isPointAboveHorizon(r);}else {const r=e.P.convert(t[0]),n=e.P.convert(t[1]),a=r.add(n)._div(2);o=[r,n],s=e.aq(r,n).every((e=>i.isPointAboveHorizon(e)))&&i.isPointAboveHorizon(a);}return new st(o,s,i)}isPointQuery(){return 1===this.screenBounds.length}bufferedScreenGeometry(t){return e.aq(this.screenBounds[0],1===this.screenBounds.length?this.screenBounds[0]:this.screenBounds[1],t)}bufferedCameraGeometry(t){const i=this.screenBounds[0],o=1===this.screenBounds.length?this.screenBounds[0].add(new e.P(1,1)):this.screenBounds[1],s=e.aq(i,o,0,!1);return this.cameraPoint.y>o.y&&(this.cameraPoint.x>i.x&&this.cameraPoint.x<o.x?s.splice(3,0,this.cameraPoint):this.cameraPoint.x>=o.x?s[2]=this.cameraPoint:this.cameraPoint.x<=i.x&&(s[3]=this.cameraPoint)),e.ar(s,t)}bufferedCameraGeometryGlobe(t){const i=this.screenBounds[0],o=1===this.screenBounds.length?this.screenBounds[0].add(new e.P(1,1)):this.screenBounds[1],s=e.aq(i,o,t),r=this.cameraPoint.clone();switch(3*((r.y>i.y)+(r.y>o.y))+((r.x>i.x)+(r.x>o.x))){case 0:s[0]=r,s[4]=r.clone();break;case 1:s.splice(1,0,r);break;case 2:s[1]=r;break;case 3:s.splice(4,0,r);break;case 5:s.splice(2,0,r);break;case 6:s[3]=r;break;case 7:s.splice(3,0,r);break;case 8:s[2]=r;}return s}containsTile(t,i,o,s=0){const r=Math.max(t.queryPadding,t.evaluateQueryRenderedFeaturePadding())/i._pixelsPerMercatorPixel+1,n=o?this._bufferedCameraMercator(r,i):this._bufferedScreenMercator(r,i);let a=t.tileID.wrap+(n.unwrapped?s:0);const l=n.polygon.map((i=>e.as(t.tileTransform,i,a)));if(!e.at(l,0,0,e.al,e.al))return;a=t.tileID.wrap+(this.screenGeometryMercator.unwrapped?s:0);const c=this.screenGeometryMercator.polygon.map((i=>e.au(t.tileTransform,i,a))),h=c.map((t=>new e.P(t[0],t[1]))),d=i.getFreeCameraOptions().position||new e.ae(0,0,0),u=e.au(t.tileTransform,d,a),_=c.map((t=>{const i=e.av(t,t,u);return e.aw(i,i),new e.ax(u,i)})),p=e.ay(t,1,i.zoom)*i._pixelsPerMercatorPixel;return {queryGeometry:this,tilespaceGeometry:h,tilespaceRays:_,bufferedTilespaceGeometry:l,bufferedTilespaceBounds:(f=e.az(l),f.min.x=e.aA(f.min.x,0,e.al),f.min.y=e.aA(f.min.y,0,e.al),f.max.x=e.aA(f.max.x,0,e.al),f.max.y=e.aA(f.max.y,0,e.al),f),tile:t,tileID:t.tileID,pixelToTileUnitsFactor:p};var f;}_bufferedScreenMercator(e,t){const i=at(e);if(this._screenRaycastCache[i])return this._screenRaycastCache[i];{let o;return o="globe"===t.projection.name?this._projectAndResample(this.bufferedScreenGeometry(e),t):{polygon:this.bufferedScreenGeometry(e).map((e=>t.pointCoordinate3D(e))),unwrapped:!0},this._screenRaycastCache[i]=o,o}}_bufferedCameraMercator(e,t){const i=at(e);if(this._cameraRaycastCache[i])return this._cameraRaycastCache[i];{let o;return o="globe"===t.projection.name?this._projectAndResample(this.bufferedCameraGeometryGlobe(e),t):{polygon:this.bufferedCameraGeometry(e).map((e=>t.pointCoordinate3D(e))),unwrapped:!0},this._cameraRaycastCache[i]=o,o}}_projectAndResample(t,i){const o=function(t,i){const o=e.aB([],i.pixelMatrix,i.globeMatrix),s=[0,-e.aD,0,1],r=[0,e.aD,0,1],n=[0,0,0,1];e.aC(s,s,o),e.aC(r,r,o),e.aC(n,n,o);const a=new e.P(s[0]/s[3],s[1]/s[3]),l=new e.P(r[0]/r[3],r[1]/r[3]),c=e.aE(t,a)&&s[3]<n[3],h=e.aE(t,l)&&r[3]<n[3];if(!c&&!h)return null;const d=function(e,t,i){for(let o=1;o<e.length;o++){const s=nt(t.pointCoordinate3D(e[o-1]).x),r=nt(t.pointCoordinate3D(e[o]).x);if(i<0){if(s<r)return {idx:o,t:-s/(r-1-s)}}else if(r<s)return {idx:o,t:(1-s)/(r+1-s)}}return null}(t,i,c?-1:1);if(!d)return null;const{idx:u,t:_}=d;let p=u>1?rt(t.slice(0,u),i):[],f=u<t.length?rt(t.slice(u),i):[];p=p.map((t=>new e.P(nt(t.x),t.y))),f=f.map((t=>new e.P(nt(t.x),t.y)));const m=[...p];0===m.length&&m.push(f[f.length-1]);const g=e.ak(m[m.length-1].y,(0===f.length?p[0]:f[0]).y,_);let v;return v=c?[new e.P(0,g),new e.P(0,0),new e.P(1,0),new e.P(1,g)]:[new e.P(1,g),new e.P(1,1),new e.P(0,1),new e.P(0,g)],m.push(...v),0===f.length?m.push(p[0]):m.push(...f),{polygon:m.map((t=>new e.ae(t.x,t.y))),unwrapped:!1}}(t,i);if(o)return o;const s=function(t,i){let o=!1,s=-1/0,r=0;for(let e=0;e<t.length-1;e++)t[e].x>s&&(s=t[e].x,r=e);for(let e=0;e<t.length-1;e++){const i=(r+e)%(t.length-1),s=t[i],n=t[i+1];Math.abs(s.x-n.x)>.5&&(s.x<n.x?(s.x+=1,0===i&&(t[t.length-1].x+=1)):(n.x+=1,i+1===t.length-1&&(t[0].x+=1)),o=!0);}const n=e.aF(i.center.lng);return o&&n<Math.abs(n-1)&&t.forEach((e=>{e.x-=1;})),{polygon:t,unwrapped:o}}(rt(t,i).map((t=>new e.P(nt(t.x),t.y))),i);return {polygon:s.polygon.map((t=>new e.ae(t.x,t.y))),unwrapped:s.unwrapped}}}function rt(t,i){return e.aG(t,(e=>{const t=i.pointCoordinate3D(e);e.x=t.x,e.y=t.y;}),1/256)}function nt(e){return e<0?1+e%1:e%1}function at(e){return 100*e|0}function lt(t,i,o,s,r){const n=function(o,s){if(o)return r(o);if(s){if(t.url&&s.tiles&&t.tiles&&delete t.tiles,s.variants){if(!Array.isArray(s.variants))return r(new Error("variants must be an array"));for(const e of s.variants){if(null==e||"object"!=typeof e||e.constructor!==Object)return r(new Error("variant must be an object"));if(!Array.isArray(e.capabilities))return r(new Error("capabilities must be an array"));if(1===e.capabilities.length&&"meshopt"===e.capabilities[0]){s=Object.assign(s,e);break}}}const o=e.aH(Object.assign({},s,t),["tilejson","tiles","minzoom","maxzoom","attribution","mapbox_logo","bounds","extra_bounds","scheme","tileSize","encoding","vector_layers","raster_layers","worldview_options","worldview_default","worldview"]);o.tiles=i.canonicalizeTileset(o,t.url),r(null,o);}},a=function(e,t,i){if(!e)return null;if(!t&&!i)return e;i=i||e.worldview_default;const o=Object.values(e.language||{});if(0===o.length)return null;const s=Object.values(e.worldview||{});if(0===s.length)return null;const r=o.every((e=>e===t)),n=s.every((e=>e===i));return r&&n?e:t in(e.language_options||{})||i in(e.worldview_options||{})?null:e.language_options&&e.worldview_options?e:null}(t.data,o,s);return a?e.o.frame((()=>n(null,a))):t.url?e.m(i.transformRequest(i.normalizeSourceURL(t.url,null,o,s),e.R.Source),n):e.o.frame((()=>{const{data:e,...i}=t;n(null,i);}))}function ct(t,i){const o=Math.pow(2,i.z),s=Math.floor(e.aF(t.getWest())*o),r=Math.floor(e.aJ(t.getNorth())*o),n=Math.ceil(e.aF(t.getEast())*o),a=Math.ceil(e.aJ(t.getSouth())*o);return i.x>=s&&i.x<n&&i.y>=r&&i.y<a}class ht{constructor(t,i,o){this.bounds=t?e.aI.convert(this.validateBounds(t)):null,this.minzoom=i||0,this.maxzoom=o||24;}validateBounds(e){return Array.isArray(e)&&4===e.length?[Math.max(-180,e[0]),Math.max(-90,e[1]),Math.min(180,e[2]),Math.min(90,e[3])]:[-180,-90,180,90]}addExtraBounds(t){if(t){this.extraBounds||(this.extraBounds=[]);for(const i of t)this.extraBounds.push(e.aI.convert(this.validateBounds(i)));}}contains(e){if(e.z>this.maxzoom||e.z<this.minzoom)return !1;if(this.bounds&&!ct(this.bounds,e))return !1;if(!this.extraBounds)return !0;for(const t of this.extraBounds)if(ct(t,e))return !0;return !1}static fromTileJSON(e){if(!e.bounds&&!e.extra_bounds)return null;const t=new ht(e.bounds,e.minzoom,e.maxzoom);return t.addExtraBounds(e.extra_bounds),t}}class dt extends e.E{constructor(t,i,o,s){if(super(),this.id=t,this.dispatcher=o,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,Object.assign(this,e.aH(i,["url","scheme","tileSize","promoteId"])),this._options=Object.assign({type:"vector"},i),this._collectResourceTiming=!!i.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(s),this._tileWorkers={},this._deduped=new e.aK;}load(t){this._loaded=!1,this.fire(new e.z("dataloading",{dataType:"source"}));const i=Array.isArray(this.map._language)?this.map._language.join():this.map._language,o=this.map.getWorldview();this._tileJSONRequest=lt(this._options,this.map._requestManager,i,o,((s,r)=>{if(this._tileJSONRequest=null,this._loaded=!0,s)i&&console.warn(`Ensure that your requested language string is a valid BCP-47 code or list of codes. Found: ${i}`),o&&console.warn(`Requested worldview strings must be a valid ISO alpha-2 code. Found: ${o}`),this.fire(new e.y(s));else if(r){if(Object.assign(this,r),this.hasWorldviews=!!r.worldview_options,r.worldview_default&&(this.worldviewDefault=r.worldview_default),r.vector_layers){this.vectorLayers=r.vector_layers,this.vectorLayerIds=[],this.localizableLayerIds=new Set;for(const e of r.vector_layers)this.vectorLayerIds.push(e.id),r.worldview&&r.worldview[e.source]&&this.localizableLayerIds.add(e.id);}this.tileBounds=ht.fromTileJSON(r),P(r.tiles,this.map._requestManager._customAccessToken),this.fire(new e.z("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.z("data",{dataType:"source",sourceDataType:"content"}));}t&&t(s);}));}loaded(){return this._loaded}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}onAdd(e){this.map=e,this.load();}reload(){this.cancelTileJSONRequest();const t=e.B(this.id,this.scope);this.load((()=>this.map.style.clearSource(t)));}setTiles(e){return this._options.tiles=e,this.reload(),this}setUrl(e){return this.url=e,this._options.url=e,this.reload(),this}onRemove(e){this.cancelTileJSONRequest();}serialize(){return Object.assign({},this._options)}loadTile(t,i){const o=t.tileID.canonical.url(this.tiles,this.scheme),s=this.map._requestManager.normalizeTileURL(o),r=this.map._requestManager.transformRequest(s,e.R.Tile),n=this.map.style?this.map.style.getLut(this.scope):null,a=n?{image:n.image.clone()}:null,l={request:r,data:void 0,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,maxZoom:this.maxzoom,lut:a,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,scope:this.scope,pixelRatio:e.o.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,isSymbolTile:t.isSymbolTile,brightness:this.map.style&&this.map.style.getBrightness()||0,extraShadowCaster:t.isExtraShadowCaster,tessellationStep:this.map._tessellationStep,scaleFactor:this.map.getScaleFactor(),worldview:this.map.getWorldview()||this.worldviewDefault,indoor:this.map.indoor?this.map.indoor.getIndoorTileOptions(this.id,this.scope):null};if(this.hasWorldviews&&e.h(o)&&(l.localizableLayerIds=this.localizableLayerIds),l.request.collectResourceTiming=this._collectResourceTiming,t.actor&&"expired"!==t.state)"loading"===t.state?t.reloadCallback=i:t.request=t.actor.send("reloadTile",l,c.bind(this));else if(t.actor=this._tileWorkers[s]=this._tileWorkers[s]||this.dispatcher.getActor(),this.dispatcher.ready)t.request=t.actor.send("loadTile",l,c.bind(this),void 0,!0);else {const i=e.aL.call({deduped:this._deduped},l,((i,o)=>{if(i||!o)c.call(this,i);else {const i=e.aM(o.responseHeaders);l.data={rawData:o.rawData.slice(0),expires:i.expires,cacheControl:i.cacheControl},t.actor&&t.actor.send("loadTile",l,c.bind(this),void 0,!0);}}),!0);t.request={cancel:i};}function c(o,s){return delete t.request,t.aborted?i(null):o&&o instanceof e.aN&&404!==o.status?i(o):(s&&s.resourceTiming&&(t.resourceTiming=s.resourceTiming),this.map._refreshExpiredTiles&&s&&t.setExpiryData(s),t.loadVectorData(s,this.map.painter),e.aO(this.dispatcher),i(null,s),void(t.reloadCallback&&(this.loadTile(t,t.reloadCallback),t.reloadCallback=null)))}}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.actor&&e.actor.send("abortTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope});}unloadTile(e,t){e.actor&&e.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope}),e.destroy();}hasTransition(){return !1}afterUpdate(){this._tileWorkers={};}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}}class ut extends e.E{constructor(t,i,o,s){super(),this.id=t,this.dispatcher=o,this.setEventedParent(s),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=Object.assign({type:"raster"},i),Object.assign(this,e.aH(i,["url","scheme","tileSize"]));}load(t){this._loaded=!1,this.fire(new e.z("dataloading",{dataType:"source"}));const i=this.map.getWorldview();this._tileJSONRequest=lt(this._options,this.map._requestManager,null,i,((i,o)=>{this._tileJSONRequest=null,this._loaded=!0,i?this.fire(new e.y(i)):o&&(Object.assign(this,o),o.raster_layers&&(this.rasterLayers=o.raster_layers,this.rasterLayerIds=this.rasterLayers.map((e=>e.id))),this.tileBounds=ht.fromTileJSON(o),P(o.tiles),this.fire(new e.z("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.z("data",{dataType:"source",sourceDataType:"content"}))),t&&t(i);}));}loaded(){return this._loaded}onAdd(e){this.map=e,this.load();}reload(){this.cancelTileJSONRequest();const t=e.B(this.id,this.scope);this.load((()=>this.map.style.clearSource(t)));}setTiles(e){return this._options.tiles=e,this.reload(),this}setUrl(e){return this.url=e,this._options.url=e,this.reload(),this}onRemove(e){this.cancelTileJSONRequest();}serialize(){return Object.assign({},this._options)}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(t,i){const o=e.o.devicePixelRatio>=2,s=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),o,this.tileSize);t.request=e.n(this.map._requestManager.transformRequest(s,e.R.Tile),((o,s,r)=>{if(delete t.request,t.aborted)return t.state="unloaded",i(null);if(o)return t.state="errored",i(o);if(!s)return i(null);const n=e.aM(r);this.map._refreshExpiredTiles&&t.setExpiryData(n),t.setTexture(s,this.map.painter),t.state="loaded",e.aO(this.dispatcher),i(null);}));}abortTile(e,t){e.request&&(e.request.cancel(),delete e.request),t&&t();}unloadTile(t,i){t.texture&&t.texture instanceof e.T?(t.destroy(!1),t.texture&&t.texture instanceof e.T&&this.map.painter.saveTileTexture(t.texture)):t.destroy(),i&&i();}hasTransition(){return !1}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}}function _t([t,i],o,s,{scaled:r=!0}={}){const{tileSize:n,buffer:a}=s,{x:l,y:c,z:h}=o;if(!isFinite(l)||!isFinite(c)||!isFinite(h))throw new Error("Invalid MRT header");const d=2**h,u=d*e.aF(t),_=d*e.aJ(i);return function([e,t],i,{scaled:o=!0}={}){if(!i)throw new Error("bandView is undefined");const{data:s,tileSize:r,buffer:n,offset:a,scale:l,dimension:c}=i;if(e<-n||e>r+n||t<-n||t>r+n)throw new Error(`Point (${e}, ${t}) out of bounds for tileSize=${r}, buffer=${n}`);const h=(t+n)*(r+2*n)+(e+n);if(4294967295===new Uint32Array(s.buffer)[h])return null;let d=[];d=o?[]:new(0,i.data.constructor)(c);for(let e=0;e<c;e++)d[e]=Math.round(1e12*(s[c*h+e]*l+a))/1e12;return d}([Math.min(Math.max(-a,Math.floor((u-l)*n)),n-1+a),Math.min(Math.max(-a,Math.floor((_-c)*n)),n-1+a)],s,{scaled:r})}class pt extends ut{constructor(e,t,i,o){super(e,t,i,o),this.type="raster-array",this.maxzoom=22,this.partial=!0,this._loadTilePending={},this._loadTileLoaded={},this._options=Object.assign({type:"raster-array"},t);}triggerRepaint(e){const t=this.map.painter._terrain,i=this.map.style.getSourceCache(this.id);t&&t.enabled&&i&&t._clearRenderCacheForTile(i.id,e.tileID),this.map.triggerRepaint();}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),!1,this.tileSize),s=this.map._requestManager.transformRequest(o,e.R.Tile),r={request:s,uid:t.uid,tileID:t.tileID,type:this.type,source:this.id,scope:this.scope,partial:this.partial};t.source=this.id,t.scope=this.scope,t.requestParams=s,t.actor||(t.actor=this.dispatcher.getActor());const n=(o,s,r)=>{if(delete t.request,t.aborted)return t.state="unloaded",i(null);if(o){if("AbortError"===o.name)return;return t.state="errored",i(o)}if(this.map._refreshExpiredTiles&&s){const i=e.aM(r);t.setExpiryData(i);}if(this.partial&&"expired"!==t.state)t.state="empty";else if(!this.partial){if(!s)return i(null);t.state="loaded",t._isHeaderLoaded=!0,t._mrt=s;}i(null);};t.request=this.partial?t.fetchHeader(void 0,n.bind(this)):t.actor.send("loadTile",r,n.bind(this),void 0,!0);}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.actor&&e.actor.send("abortTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope});}unloadTile(e,t){const i=e.texturePerLayer;if(e.flushAllQueues(),i.size){e.destroy(!1);for(const e of i.values())this.map.painter.saveTileTexture(e);}else e.destroy();}prepareTile(t,i,o,s){t._isHeaderLoaded&&("empty"!==t.state&&(t.state="reloading"),t.fetchBandForRender(i,o,s,((i,s)=>{if(i)return t.state="errored",this.fire(new e.y(i)),void this.triggerRepaint(t);s&&(t._isHeaderLoaded=!0,t.setTexturePerLayer(o,s,this.map.painter),t.state="loaded",this.triggerRepaint(t));})));}getInitialBand(e){if(!this.rasterLayers)return 0;const t=this.rasterLayers.find((({id:t})=>t===e)),i=t&&t.fields,o=i&&i.bands&&i.bands;return o?o[0]:0}getTextureDescriptor(t,i,o){if(!t)return;const s=i.sourceLayer||this.rasterLayerIds&&this.rasterLayerIds[0];if(!s)return;let r=null;i instanceof e.aR?r=i.paint.get("raster-array-band"):i instanceof e.aS&&(r=i.paint.get("raster-particle-array-band"));const n=r||this.getInitialBand(s);if(null==n)return;if(!t.textureDescriptorPerLayer.get(i.id))return void this.prepareTile(t,s,i.id,n);if(t.updateNeeded(i.id,n)&&!o)return;const a=t.textureDescriptorPerLayer.get(i.id);return Object.assign({},a,{texture:t.texturePerLayer.get(i.id)})}getImages(t,i){const o=new Map;for(const s of t)for(const t of i){const[i,r]=t.split("/"),n=s.getLayer(i);if(!n)continue;if(!n.hasBand(r)||!n.hasDataForBand(r))continue;const{bytes:a,tileSize:l,buffer:c}=n.getBandView(r),h=l+2*c,d={data:new e.q({width:h,height:h},a),pixelRatio:2,sdf:!1,usvg:!1,version:0};o.set(t,d);}return o}queryRasterArrayValueByBandId(t,i,o){const s=i._mrt;return new Promise((r=>{const n={},a=new Set;for(const[l,c]of Object.entries(s.layers)){if(o.layerName&&l!==o.layerName)continue;const h={};n[l]=h;for(const{bands:d}of c.dataIndex)for(const u of d)o.bands&&!o.bands.includes(u)||(a.add(e.B(l,u)),i.fetchBand(l,null,u,(i=>{e.o.frame((()=>{h[u]=i?null:_t([t.lng,t.lat],s,c.getBandView(u)),a.delete(e.B(l,u)),0===a.size&&r(n);}));}),!1));}0===a.size&&r(n);}))}_loadTileForQuery(t,i){if(this._loadTileLoaded[t.uid])return void i(null,t._mrt);if(this._loadTilePending[t.uid])return void this._loadTilePending[t.uid].push(i);this._loadTilePending[t.uid]=[i];const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),!1,this.tileSize),s=this.map._requestManager.transformRequest(o,e.R.Tile);t.actor.send("loadTile",{request:s,uid:t.uid,tileID:t.tileID,type:this.type,source:this.id,scope:this.scope,partial:!1},((i,o,s)=>{if(i)return this._loadTilePending[t.uid].forEach((e=>e(i,null))),void delete this._loadTilePending[t.uid];if(!o)return this._loadTilePending[t.uid].forEach((e=>e(null,null))),void delete this._loadTilePending[t.uid];if(this.map._refreshExpiredTiles&&o){const i=e.aM(s);t.setExpiryData(i);}t._mrt=o,t._isHeaderLoaded=!0,t.state="loaded",this._loadTilePending[t.uid].forEach((e=>e(null,o))),this._loadTileLoaded[t.uid]=!0,delete this._loadTilePending[t.uid];}),void 0,!0);}queryRasterArrayValueByAllBands(e,t,i){return new Promise(((o,s)=>{this._loadTileForQuery(t,((r,n)=>{r?s(r):o(n?this.queryRasterArrayValueByBandId(e,t,i):null);}));}))}queryRasterArrayValue(t,i){const o=e.aT.convert(t),s=this.findLoadedParent(o);return s&&s._mrt?i.bands||!this.partial?this.queryRasterArrayValueByBandId(o,s,i):this.queryRasterArrayValueByAllBands(o,s,i):Promise.resolve(null)}findLoadedParent(t){const i=e.ae.fromLngLat(t,this.map.transform.tileSize),o=this.maxzoom+1,s=1<<o,r=Math.floor(i.x),n=Math.floor((i.x-r)*s),a=Math.floor(i.y*s),l=this.map.style.getSourceCache(this.id),c=new e.aQ(o,r,o,n,a);return l.findLoadedParent(c,this.minzoom)}}const ft={vector:dt,raster:ut,"raster-dem":class extends ut{constructor(e,t,i,o){super(e,t,i,o),this.type="raster-dem",this.maxzoom=22,this._options=Object.assign({type:"raster-dem"},t),this.encoding=t.encoding||"mapbox";}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),!1,this.tileSize);function s(e,o){e&&(t.state="errored",i(e)),o&&(t.dem=o,t.dem.onDeserialize(),t.needsHillshadePrepare=!0,t.needsDEMTextureUpload=!0,t.state="loaded",i(null));}t.request=e.n(this.map._requestManager.transformRequest(o,e.R.Tile),function(o,r,n){if(delete t.request,t.aborted)t.state="unloaded",i(null);else if(o)t.state="errored",i(o);else if(r){const i=e.aM(n);this.map._refreshExpiredTiles&&t.setExpiryData(i);const o=ImageBitmap&&r instanceof ImageBitmap&&e.r(),a=1-(r.width-e.aP(r.width))/2;a<1||t.neighboringTiles||(t.neighboringTiles=this._getNeighboringTiles(t.tileID));const l=o?r:e.o.getImageData(r,a),c={uid:t.uid,tileID:t.tileID,source:this.id,type:this.type,scope:this.scope,rawImageData:l,encoding:this.encoding,padding:a};t.actor&&"expired"!==t.state||(t.actor=this.dispatcher.getActor(),t.actor.send("loadTile",c,s.bind(this),void 0,!0));}}.bind(this));}_getNeighboringTiles(t){const i=t.canonical,o=Math.pow(2,i.z),s=(i.x-1+o)%o,r=0===i.x?t.wrap-1:t.wrap,n=(i.x+1+o)%o,a=i.x+1===o?t.wrap+1:t.wrap,l={};return l[new e.aQ(t.overscaledZ,r,i.z,s,i.y).key]={backfilled:!1},l[new e.aQ(t.overscaledZ,a,i.z,n,i.y).key]={backfilled:!1},i.y>0&&(l[new e.aQ(t.overscaledZ,r,i.z,s,i.y-1).key]={backfilled:!1},l[new e.aQ(t.overscaledZ,t.wrap,i.z,i.x,i.y-1).key]={backfilled:!1},l[new e.aQ(t.overscaledZ,a,i.z,n,i.y-1).key]={backfilled:!1}),i.y+1<o&&(l[new e.aQ(t.overscaledZ,r,i.z,s,i.y+1).key]={backfilled:!1},l[new e.aQ(t.overscaledZ,t.wrap,i.z,i.x,i.y+1).key]={backfilled:!1},l[new e.aQ(t.overscaledZ,a,i.z,n,i.y+1).key]={backfilled:!1}),l}},"raster-array":pt,geojson:class extends e.E{constructor(t,i,o,s){super(),this.id=t,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._loaded=!1,this.actor=o.getActor(),this.setEventedParent(s),this._data=i.data,this._options=Object.assign({},i),this._collectResourceTiming=i.collectResourceTiming,void 0!==i.maxzoom&&(this.maxzoom=i.maxzoom),void 0!==i.minzoom&&(this.minzoom=i.minzoom),i.type&&(this.type=i.type),i.attribution&&(this.attribution=i.attribution),this.promoteId=i.promoteId;const r=e.al/this.tileSize;this.workerOptions=Object.assign({source:this.id,scope:this.scope,cluster:i.cluster||!1,geojsonVtOptions:{buffer:(void 0!==i.buffer?i.buffer:128)*r,tolerance:(void 0!==i.tolerance?i.tolerance:.375)*r,extent:e.al,maxZoom:this.maxzoom,lineMetrics:i.lineMetrics||!1,generateId:i.generateId||!1},superclusterOptions:{maxZoom:void 0!==i.clusterMaxZoom?i.clusterMaxZoom:this.maxzoom-1,minPoints:Math.max(2,i.clusterMinPoints||2),extent:e.al,radius:(void 0!==i.clusterRadius?i.clusterRadius:50)*r,log:!1,generateId:i.generateId||!1},clusterProperties:i.clusterProperties,filter:i.filter,dynamic:i.dynamic},i.workerOptions);}onAdd(e){this.map=e,this.setData(this._data);}setData(e){return this._data=e,this._updateWorkerData(),this}updateData(t){if(!this._options.dynamic)return this.fire(new e.y(new Error("Can't call updateData on a GeoJSON source with dynamic set to false.")));if("string"!=typeof t&&("Feature"===t.type&&(t={type:"FeatureCollection",features:[t]}),"FeatureCollection"!==t.type))return this.fire(new e.y(new Error("Data to update should be a feature or a feature collection.")));if(this._coalesce&&"string"!=typeof t&&"string"!=typeof this._data&&"FeatureCollection"===this._data.type){const e=new Map;for(const t of this._data.features)e.set(t.id,t);for(const i of t.features)e.set(i.id,i);this._data.features=[...e.values()];}else this._data=t;return this._updateWorkerData(!0),this}getClusterExpansionZoom(e,t){return this.actor.send("geojson.getClusterExpansionZoom",{clusterId:e,source:this.id,scope:this.scope},t),this}getClusterChildren(e,t){return this.actor.send("geojson.getClusterChildren",{clusterId:e,source:this.id,scope:this.scope},t),this}getClusterLeaves(e,t,i,o){return this.actor.send("geojson.getClusterLeaves",{source:this.id,scope:this.scope,clusterId:e,limit:t,offset:i},o),this}_updateWorkerData(t=!1){if(this._pendingLoad)return void(this._coalesce=!0);this.fire(new e.z("dataloading",{dataType:"source"})),this._loaded=!1;const i=Object.assign({append:t},this.workerOptions);i.scope=this.scope;const o=this._data;"string"==typeof o?(i.request=this.map._requestManager.transformRequest(e.o.resolveURL(o),e.R.Source),i.request.collectResourceTiming=this._collectResourceTiming):i.data=JSON.stringify(o),this._pendingLoad=this.actor.send(`${this.type}.loadData`,i,((i,o)=>{if(this._loaded=!0,this._pendingLoad=null,i)this.fire(new e.y(i));else {const i={dataType:"source",sourceDataType:this._metadataFired?"content":"metadata"};this._collectResourceTiming&&o&&o.resourceTiming&&o.resourceTiming[this.id]&&(i.resourceTiming=o.resourceTiming[this.id]),t&&(this._partialReload=!0),this.fire(new e.z("data",i)),this._partialReload=!1,this._metadataFired=!0;}this._coalesce&&(this._updateWorkerData(t),this._coalesce=!1);}));}loaded(){return this._loaded}reload(){const t=e.B(this.id,this.scope);this.map.style.clearSource(t),this._updateWorkerData();}loadTile(t,i){const o=t.actor?"reloadTile":"loadTile";t.actor=this.actor;const s=this.map.style?this.map.style.getLut(this.scope):null,r=s?{image:s.image.clone()}:null,n=this._partialReload,a={type:this.type,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,lut:r,scope:this.scope,pixelRatio:e.o.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,brightness:this.map.style&&this.map.style.getBrightness()||0,extraShadowCaster:t.isExtraShadowCaster,scaleFactor:this.map.getScaleFactor(),partial:n,worldview:this.map.getWorldview(),indoor:this.map.indoor?this.map.indoor.getIndoorTileOptions(this.id,this.scope):null};t.request=this.actor.send(o,a,((e,s)=>n&&!s?(t.state="loaded",i(null)):(delete t.request,t.destroy(!1),t.aborted?i(null):e?i(e):(t.loadVectorData(s,this.map.painter,"reloadTile"===o),i(null)))),void 0,"loadTile"===o);}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.aborted=!0;}unloadTile(e,t){this.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope}),e.destroy();}onRemove(e){this._pendingLoad&&this._pendingLoad.cancel();}serialize(){return Object.assign({},this._options,{type:this.type,data:this._data})}hasTransition(){return !1}},video:class extends e.aU{constructor(e,t,i,o){super(e,t,i,o),this.roundZoom=!0,this.type="video",this.options=t;}load(){this._loaded=!1;const t=this.options;this.urls=[];for(const i of t.urls)this.urls.push(this.map._requestManager.transformRequest(i,e.R.Source).url);e.aV(this.urls,((t,i)=>{this._loaded=!0,t?this.fire(new e.y(t)):i&&(this.video=i,this.video.loop=!0,this.video.setAttribute("playsinline",""),this.video.addEventListener("playing",(()=>{this.map.triggerRepaint();})),this.map&&this.video.play(),this._finishLoading());}));}pause(){this.video&&this.video.pause();}play(){this.video&&this.video.play();}seek(t){if(this.video){const i=this.video.seekable;t<i.start(0)||t>i.end(0)?this.fire(new e.y(new e.V(`sources.${this.id}`,null,`Playback for this video can be set only between the ${i.start(0)} and ${i.end(0)}-second mark.`))):this.video.currentTime=t;}}getVideo(){return this.video}onAdd(e){this.map||(this.map=e,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)));}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const t=this.map.painter.context,i=t.gl;this.texture?this.video.paused||(this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),i.texSubImage2D(i.TEXTURE_2D,0,0,0,i.RGBA,i.UNSIGNED_BYTE,this.video)):(this.texture=new e.T(t,this.video,i.RGBA8),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),this.width=this.video.videoWidth,this.height=this.video.videoHeight),this._prepareData(t);}serialize(){return {type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}},image:e.aU,model:e.aX,"batched-model":class extends e.E{constructor(e,t,i,o){super(),this.type="batched-model",this.id=e,this.tileSize=512,this._options=t,this.tiles=this._options.tiles,this.maxzoom=t.maxzoom||19,this.minzoom=t.minzoom||0,this.roundZoom=!0,this.usedInConflation=!0,this.dispatcher=i,this.reparseOverscaled=!1,this.scheme="xyz",this._loaded=!1,this.setEventedParent(o);}onAdd(e){this.map=e,this.load();}reload(){this.cancelTileJSONRequest();const t=e.B(this.id,this.scope);this.load((()=>this.map.style.clearSource(t)));}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}load(t){this._loaded=!1,this.fire(new e.z("dataloading",{dataType:"source"}));const i=Array.isArray(this.map._language)?this.map._language.join():this.map._language,o=this.map.getWorldview();this._tileJSONRequest=lt(this._options,this.map._requestManager,i,o,((s,r)=>{this._tileJSONRequest=null,this._loaded=!0,s?(i&&console.warn(`Ensure that your requested language string is a valid BCP-47 code or list of codes. Found: ${i}`),o&&2!==o.length&&console.warn(`Requested worldview strings must be a valid ISO alpha-2 code. Found: ${o}`),this.fire(new e.y(s))):r&&(Object.assign(this,r),r.bounds&&(this.tileBounds=new ht(r.bounds,this.minzoom,this.maxzoom)),P(r.tiles,this.map._requestManager._customAccessToken),this.fire(new e.z("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.z("data",{dataType:"source",sourceDataType:"content"}))),t&&t(s);}));}hasTransition(){return !1}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}loaded(){return this._loaded}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme)),s={request:this.map._requestManager.transformRequest(o,e.R.Tile),data:void 0,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,scope:this.scope,showCollisionBoxes:this.map.showCollisionBoxes,isSymbolTile:t.isSymbolTile,brightness:this.map.style&&this.map.style.getBrightness()||0,pixelRatio:e.o.devicePixelRatio,promoteId:this.promoteId};if(t.actor&&"expired"!==t.state)if("loading"===t.state)t.reloadCallback=i;else {if(t.buckets){const e=Object.values(t.buckets);for(const t of e)t.dirty=!0;return void(t.state="loaded")}t.request=t.actor.send("reloadTile",s,r.bind(this));}else t.actor=this.dispatcher.getActor(),t.request=t.actor.send("loadTile",s,r.bind(this),void 0,!0);function r(e,o){return t.aborted?i(null):e&&404!==e.status?i(e):(this.map._refreshExpiredTiles&&o&&t.setExpiryData(o),t.loadModelData(o,this.map.painter),t.state="loaded",void i(null))}}serialize(){return Object.assign({},this._options)}},canvas:class extends e.aU{constructor(t,i,o,s){super(t,i,o,s),i.coordinates?Array.isArray(i.coordinates)&&4===i.coordinates.length&&!i.coordinates.some((e=>!Array.isArray(e)||2!==e.length||e.some((e=>"number"!=typeof e))))||this.fire(new e.y(new e.V(`sources.${t}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new e.y(new e.V(`sources.${t}`,null,'missing required property "coordinates"'))),i.animate&&"boolean"!=typeof i.animate&&this.fire(new e.y(new e.V(`sources.${t}`,null,'optional "animate" property must be a boolean value'))),i.canvas?"string"==typeof i.canvas||i.canvas instanceof HTMLCanvasElement||this.fire(new e.y(new e.V(`sources.${t}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new e.y(new e.V(`sources.${t}`,null,'missing required property "canvas"'))),this.options=i,this.animate=void 0===i.animate||i.animate;}load(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof HTMLCanvasElement?this.options.canvas:document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new e.y(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint();},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1);},this._finishLoading());}getCanvas(){return this.canvas}onAdd(e){this.map=e,this.load(),this.canvas&&this.animate&&this.play();}onRemove(e){this.pause();}prepare(){let t=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,t=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,t=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const i=this.map.painter.context;this.texture?!t&&!this._playing||this.texture instanceof e.aW||this.texture.update(this.canvas,{premultiply:!0}):this.texture=new e.T(i,this.canvas,i.gl.RGBA8,{premultiply:!0}),this._prepareData(i);}serialize(){return {type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const e of [this.canvas.width,this.canvas.height])if(isNaN(e)||e<=0)return !0;return !1}},custom:class extends e.E{constructor(t,i,o,s){super(),this.id=t,this.type="custom",this._dataType="raster",this._dispatcher=o,this._implementation=i,this.setEventedParent(s),this.scheme="xyz",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this._loaded=!1,this.roundZoom=!0,this._implementation||this.fire(new e.y(new Error(`Missing implementation for ${this.id} custom source`))),this._implementation.loadTile||this.fire(new e.y(new Error(`Missing loadTile implementation for ${this.id} custom source`))),this._implementation.bounds&&(this.tileBounds=new ht(this._implementation.bounds,this.minzoom,this.maxzoom)),i.update=this._update.bind(this),i.clearTiles=this._clearTiles.bind(this),i.coveringTiles=this._coveringTiles.bind(this),Object.assign(this,e.aH(i,["dataType","scheme","minzoom","maxzoom","tileSize","attribution","minTileCacheSize","maxTileCacheSize"]));}serialize(){return e.aH(this,["type","scheme","minzoom","maxzoom","tileSize","attribution"])}load(){this._loaded=!0,this.fire(new e.z("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.z("data",{dataType:"source",sourceDataType:"content"}));}loaded(){return this._loaded}onAdd(t){this.map=t,this._loaded=!1,this.fire(new e.z("dataloading",{dataType:"source"})),this._implementation.onAdd&&this._implementation.onAdd(t),this.load();}onRemove(e){this._implementation.onRemove&&this._implementation.onRemove(e);}hasTile(e){if(this._implementation.hasTile){const{x:t,y:i,z:o}=e.canonical;return this._implementation.hasTile({x:t,y:i,z:o})}return !this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(e,t){const{x:i,y:o,z:s}=e.tileID.canonical,r=new AbortController;e.request=Promise.resolve(this._implementation.loadTile({x:i,y:o,z:s},{signal:r.signal})).then(function(i){return delete e.request,e.aborted?(e.state="unloaded",t(null)):void 0===i?(e.state="errored",t(null)):null===i?(this.loadTileData(e,{width:this.tileSize,height:this.tileSize,data:null}),e.state="loaded",t(null)):function(e){return e instanceof ImageData||e instanceof HTMLCanvasElement||e instanceof ImageBitmap||e instanceof HTMLImageElement}(i)?(this.loadTileData(e,i),e.state="loaded",void t(null)):(e.state="errored",t(new Error(`Can't infer data type for ${this.id}, only raster data supported at the moment`)))}.bind(this)).catch((i=>{"AbortError"!==i.name&&(e.state="errored",t(i));})),e.request.cancel=()=>r.abort();}loadTileData(e,t){e.setTexture(t,this.map.painter);}unloadTile(t,i){if(t.texture&&t.texture instanceof e.T?(t.destroy(!1),t.texture&&t.texture instanceof e.T&&this.map.painter.saveTileTexture(t.texture)):t.destroy(),this._implementation.unloadTile){const{x:e,y:i,z:o}=t.tileID.canonical;this._implementation.unloadTile({x:e,y:i,z:o});}i&&i();}abortTile(e,t){e.request&&e.request.cancel&&(e.request.cancel(),delete e.request),t&&t();}hasTransition(){return !1}_coveringTiles(){return this.map.transform.coveringTiles({tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,roundZoom:this.roundZoom}).map((e=>({x:e.canonical.x,y:e.canonical.y,z:e.canonical.z})))}_clearTiles(){const t=e.B(this.id,this.scope);this.map.style.clearSource(t);}_update(){this.fire(new e.z("data",{dataType:"source",sourceDataType:"content"}));}}},mt=function(t,i,o,s){const r=new ft[i.type](t,i,o,s);if(r.id!==t)throw new Error(`Expected Source id to be ${t} instead of ${r.id}`);return e.aY(["load","abort","unload","serialize","prepare"],r),r};function gt(e,t,i=""){return `${i}:${t.id||""}:${t.layer.id}:${function(e){if("layerId"in e)return `layer:${e.layerId}`;{const{featuresetId:t,importId:i}=e;return `featureset:${t}${i?`:import:${i}`:""}`}}(e.target)}`}function vt(e,t,i,o=""){if(e.uniqueFeatureID){const s=gt(e,t,o);if(i.has(s))return !0;i.add(s);}return !1}function yt(e,t,i,o,s=!1){const r=t.sourceCache.transform,n=t.sourceCache.tilesIn(e,t.has3DLayers,s);n.sort(wt);const a=[];for(const e of n){const n=e.tile.queryRenderedFeatures(t,e,i,o,r,s);Object.keys(n).length&&a.push({wrappedTileID:e.tile.tileID.wrapped().key,queryResults:n});}for(const i in t.layers){const s=t.layers[i];if(s.styleLayer){const i=s.styleLayer.queryRenderedFeatures(e,t.sourceCache,o);Object.keys(i).length&&a.push({wrappedTileID:0,queryResults:i});}}return 0===a.length?{}:function(e){const t={},i={};for(const o of e){const e=o.queryResults,s=o.wrappedTileID,r=i[s]=i[s]||{};for(const i in e){const o=e[i],s=r[i]=r[i]||{},n=t[i]=t[i]||[];for(const e of o)s[e.featureIndex]||(s[e.featureIndex]=!0,n.push(e));}}return t}(a)}function xt(e,t,i,o,s,r){const n={},a=o.queryRenderedSymbols(e),l=[];for(const e of Object.keys(a).map(Number))l.push(s[e]);l.sort(wt);for(const e of l){const o=e.featureIndex.lookupSymbolFeatures(a[e.bucketInstanceId],e.bucketIndex,e.sourceLayerIndex,t,i,r);for(const t in o){const i=n[t]=n[t]||[],s=o[t];s.sort(((t,i)=>{const o=e.featureSortOrder;if(o){const e=o.indexOf(t.featureIndex);return o.indexOf(i.featureIndex)-e}return i.featureIndex-t.featureIndex}));for(const e of s)i.push(e);}}return n}function bt(e,t){const i=e.getRenderableIds().map((t=>e.getTileByID(t))),o=[],s={};for(let e=0;e<i.length;e++){const r=i[e],n=r.tileID.canonical.key;s[n]||(s[n]=!0,r.querySourceFeatures(o,t));}return o}function wt(e,t){const i=e.tileID,o=t.tileID;return i.overscaledZ-o.overscaledZ||i.canonical.y-o.canonical.y||i.wrap-o.wrap||i.canonical.x-o.canonical.x}function Tt(e,t){const i={};if(!t)return i;for(const o of e){const e=o.layerIds.map((e=>t.getLayer(e))).filter(Boolean);if(0!==e.length){o.layers=e,o.stateDependentLayerIds&&(o.stateDependentLayers=o.stateDependentLayerIds.map((t=>e.filter((e=>e.id===t))[0])));for(const t of e)i[t.fqid]=o;}}return i}const Et=32,St=33,It=new Uint16Array(8184);for(let e=0;e<2046;e++){let t=e+2,i=0,o=0,s=0,r=0,n=0,a=0;for(1&t?s=r=n=Et:i=o=a=Et;(t>>=1)>1;){const e=i+s>>1,l=o+r>>1;1&t?(s=i,r=o,i=n,o=a):(i=s,o=r,s=n,r=a),n=e,a=l;}const l=4*e;It[l+0]=i,It[l+1]=o,It[l+2]=s,It[l+3]=r;}const Ct=new Uint16Array(2178),Rt=new Uint8Array(1089),At=new Uint16Array(1089);function Lt(e){return 0===e?-.03125:32===e?.03125:0}const Dt=(()=>({type:2,extent:e.al,loadGeometry:()=>[[new e.P(0,0),new e.P(e.al+1,0),new e.P(e.al+1,e.al+1),new e.P(0,e.al+1),new e.P(0,0)]]}))();class Pt{constructor(t,i,o,s,r,n){this.tileID=t,this.uid=e.b2(),this.uses=0,this.tileSize=i,this.tileZoom=o,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.isRaster=r,s&&s.style&&(this._lastUpdatedBrightness=s.style.getBrightness()),this.expiredRequestCount=0,this.state="loading",s&&s.transform&&(this.projection=s.transform.projection),this.worldview=n,this._hasAppearances=null;}registerFadeDuration(t){const i=t+this.timeAdded;i<e.o.now()||this.fadeEndTime&&i<this.fadeEndTime||(this.fadeEndTime=i);}wasRequested(){return "errored"===this.state||"loaded"===this.state||"reloading"===this.state}get tileTransform(){return this._tileTransform||(this._tileTransform=e.aZ(this.tileID.canonical,this.projection)),this._tileTransform}loadVectorData(t,i,o){if(this.unloadVectorData(),this.state="loaded",t){t.featureIndex&&(this.latestFeatureIndex=t.featureIndex,t.rawTileData?(this.latestRawTileData=t.rawTileData,this.latestFeatureIndex.rawTileData=t.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=t.collisionBoxArray,this.buckets=Tt(t.buckets,i.style),this.hasSymbolBuckets=!1;for(const t in this.buckets){const i=this.buckets[t];if(i instanceof e.b4){if(this.hasSymbolBuckets=!0,!o)break;i.justReloaded=!0;}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const t in this.buckets){const i=this.buckets[t];if(i instanceof e.b4&&i.hasRTLText){this.hasRTLText=!0,e.b5();break}}this.queryPadding=0;for(const e in this.buckets){const t=this.buckets[e],o=i.style.getOwnLayer(e);if(!o)continue;const s=o.queryRadius(t);this.queryPadding=Math.max(this.queryPadding,s);}t.imageAtlas&&(this.imageAtlas=t.imageAtlas),t.glyphAtlasImage&&(this.glyphAtlasImage=t.glyphAtlasImage),t.lineAtlas&&(this.lineAtlas=t.lineAtlas),this._lastUpdatedBrightness=t.brightness;}else this.collisionBoxArray=new e.b3;}unloadVectorData(){if(this.hasData()){for(const e in this.buckets)this.buckets[e].destroy();this.buckets={},this.imageAtlas&&(this.imageAtlas=null),this.lineAtlas&&(this.lineAtlas=null),this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.lineAtlasTexture&&this.lineAtlasTexture.destroy(),this._tileBoundsBuffer&&(this._tileBoundsBuffer.destroy(),this._tileBoundsIndexBuffer.destroy(),this._tileBoundsSegments.destroy(),this._tileBoundsBuffer=null),this._tileDebugBuffer&&(this._tileDebugBuffer.destroy(),this._tileDebugSegments.destroy(),this._tileDebugBuffer=null),this._tileDebugIndexBuffer&&(this._tileDebugIndexBuffer.destroy(),this._tileDebugIndexBuffer=null),this._globeTileDebugBorderBuffer&&(this._globeTileDebugBorderBuffer.destroy(),this._globeTileDebugBorderBuffer=null),this._tileDebugTextBuffer&&(this._tileDebugTextBuffer.destroy(),this._tileDebugTextSegments.destroy(),this._tileDebugTextIndexBuffer.destroy(),this._tileDebugTextBuffer=null),this._globeTileDebugTextBuffer&&(this._globeTileDebugTextBuffer.destroy(),this._globeTileDebugTextBuffer=null),this.latestFeatureIndex=null,this.state="unloaded";}}loadModelData(e,t,i){e&&(e.resourceTiming&&(this.resourceTiming=e.resourceTiming),this.buckets=Object.assign({},this.buckets,Tt(e.buckets,t.style)),e.featureIndex&&(this.latestFeatureIndex=e.featureIndex));}getBucket(e){return this.buckets[e.fqid]}upload(t,i){for(const e in this.buckets){const o=this.buckets[e];if(o.uploadPending()){let e={},s=[],r={zoom:0,pitch:0,brightness:0,worldview:""};if(i){if(i.style){s=i.style.listImages();const t=o.layers[0],r=t.sourceLayer||"_geojsonTileLayer",n=i.style.getLayerSourceCache(t);n&&(e=n._state.getState(r,void 0));}r={zoom:i.transform.zoom||0,pitch:i.transform.pitch||0,brightness:i.style.getBrightness()||0,worldview:i.worldview||""};}o.upload(t,this.tileID.canonical,e,s,r);}}const o=t.gl,s=this.imageAtlas;s&&!s.uploaded&&(this.imageAtlasTexture=new e.T(t,s.image,o.RGBA8,{useMipmap:!!s.patternPositions.size}),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new e.T(t,this.glyphAtlasImage,o.R8),this.glyphAtlasImage=null),this.lineAtlas&&!this.lineAtlas.uploaded&&(this.lineAtlasTexture=new e.T(t,this.lineAtlas.image,o.R8),this.lineAtlas.uploaded=!0);}prepare(e,t,i){if(this.imageAtlas&&this.imageAtlasTexture&&this.imageAtlas.patchUpdatedImages(e,this.imageAtlasTexture,i),!t||!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData)return;const o=t.style.getBrightness();null===this._hasAppearances&&(this._hasAppearances=this.hasAppearances(t)),(this._lastUpdatedBrightness||o||this._hasAppearances)&&(!this._hasAppearances&&this._lastUpdatedBrightness&&o&&Math.abs(this._lastUpdatedBrightness-o)<.001||(this.updateBuckets(t,this._lastUpdatedBrightness!==o),this._lastUpdatedBrightness=o));}evaluateQueryRenderedFeaturePadding(){let e=0;for(const t in this.buckets){const i=this.buckets[t];i.evaluateQueryRenderedFeaturePadding&&(e=Math.max(e,i.evaluateQueryRenderedFeaturePadding()));}return e}queryRenderedFeatures(t,i,o,s,r,n){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData&&!this.latestFeatureIndex.is3DTile)return {};const a=this.evaluateQueryRenderedFeaturePadding(),l=function(t,i){const o=e.bq([],[.5*t.width,.5*-t.height,1]);return e.br(o,o,[1,-1,0]),e.aB(o,o,t.calculateProjMatrix(i.toUnwrapped())),Float32Array.from(o)}(r,this.tileID);return this.latestFeatureIndex.query(t,{tilespaceGeometry:i,pixelPosMatrix:l,transform:s,availableImages:o,tileTransform:this.tileTransform,worldview:this.worldview,queryRadius:a})}querySourceFeatures(t,i){const o=this.latestFeatureIndex;if(!o||!o.rawTileData)return;const s=o.loadVTLayers(),r=i?i.sourceLayer:"",n=s._geojsonTileLayer||s[r];if(!n)return;const a=e.b6(i&&i.filter),{z:l,x:c,y:h}=this.tileID.canonical,d={z:l,x:c,y:h};for(let i=0;i<n.length;i++){const s=n.feature(i);if(a.needGeometry){const t=e.b7(s,!0);if(!a.filter(new e.ac(this.tileID.overscaledZ,{worldview:this.worldview}),t,this.tileID.canonical))continue}else if(!a.filter(new e.ac(this.tileID.overscaledZ,{worldview:this.worldview}),s))continue;const u=o.getId(s,r),_=new e.b8(s,l,c,h,u);_.tile=d,t.push(_);}}loaded(){return "loaded"===this.state||"errored"===this.state}hasData(){return "loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return !!this.imageAtlas&&!!this.imageAtlas.patternPositions.size}setExpiryData(t){const i=this.expirationTime;if(t.cacheControl){const i=e.b9(t.cacheControl);i["max-age"]&&(this.expirationTime=Date.now()+1e3*i["max-age"]);}else t.expires&&(this.expirationTime=new Date(t.expires).getTime());if(this.expirationTime){const e=Date.now();let t=!1;if(this.expirationTime>e)t=!1;else if(i)if(this.expirationTime<i)t=!0;else {const o=this.expirationTime-i;o?this.expirationTime=e+Math.max(o,3e4):t=!0;}else t=!0;t?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0;}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}refreshFeatureState(e){this.latestFeatureIndex&&(this.latestFeatureIndex.rawTileData||this.latestFeatureIndex.is3DTile)&&e&&this.updateBuckets(e);}hasAppearances(e){for(const t in this.buckets)if(e.style.hasLayer(t)&&this.buckets[t].layers.some((e=>e.appearances&&e.appearances.length>0)))return !0;return !1}updateBuckets(t,i){if(!this.latestFeatureIndex)return;if(!t.style)return;const o=t.style.listImages(),s=t.style.getBrightness();for(const r in this.buckets){if(!t.style.hasLayer(r))continue;const n=this.buckets[r],a=n.layers[0],l=a.sourceLayer||"_geojsonTileLayer",c=t.style.getLayerSourceCache(a);let h={};c&&(h=c._state.getState(l,void 0));const d=this.imageAtlas?Object.fromEntries(this.imageAtlas.patternPositions):{},u=Object.keys(h).length>0&&!i;n.hasAppearances=n.layers.some((e=>e.appearances&&e.appearances.length>0));const _=u?n.stateDependentLayers:n.layers;if(u&&0!==n.stateDependentLayers.length||i){const e=this.latestFeatureIndex.loadVTLayers();n.update(h,e[l],o,d,_,i,s);}if(u&&0!==n.stateDependentLayers.length||i||n.hasAppearances){const e={zoom:t.transform.zoom,pitch:t.transform.pitch,brightness:t.style.getBrightness()||0,worldview:t.worldview};n.updateAppearances(this.tileID.canonical,h,o,e);}(n instanceof e.ba||n instanceof e.bb)&&t._terrain&&t._terrain.enabled&&c&&n.uploadPending()&&t._terrain._clearRenderCacheForTile(c.id,this.tileID);const p=t&&t.style&&t.style.getOwnLayer(r);p&&(this.queryPadding=Math.max(this.queryPadding,p.queryRadius(n)));}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return !this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<e.o.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0;}setHoldDuration(t){this.symbolFadeHoldUntil=e.o.now()+t;}setTexture(t,i){const o=i.context,s=o.gl;this.texture=this.texture||i.getTileTexture(t.width),this.texture&&this.texture instanceof e.T?this.texture.update(t):(this.texture=new e.T(o,t,s.RGBA8,{useMipmap:!0}),this.texture.bind(s.LINEAR,s.CLAMP_TO_EDGE));}setDependencies(e,t){const i={};for(const e of t)i[e]=!0;this.dependencies[e]=i;}hasDependency(e,t){for(const i of e){const e=this.dependencies[i];if(e)for(const i of t)if(e[i])return !0}return !1}clearQueryDebugViz(){}_makeDebugTileBoundsBuffers(t,i){if(!i||"mercator"===i.name||this._tileDebugBuffer)return;const o=e.bc(Dt,this.tileID.canonical,this.tileTransform)[0],s=new e.bd,r=new e.be;for(let e=0;e<o.length;e++){const{x:t,y:i}=o[e];s.emplaceBack(t,i),r.emplaceBack(e);}r.emplaceBack(0),this._tileDebugIndexBuffer=t.createIndexBuffer(r),this._tileDebugBuffer=t.createVertexBuffer(s,e.bf.members),this._tileDebugSegments=e.bg.simpleSegment(0,0,s.length,r.length);}_makeTileBoundsBuffers(t,i){if(this._tileBoundsBuffer||!i||"mercator"===i.name)return;const o=e.bc(Dt,this.tileID.canonical,this.tileTransform)[0];let s,r;if(this.isRaster){const t=function(t,i){const o=e.aZ(t,i),s=Math.pow(2,t.z);for(let r=0;r<St;r++)for(let n=0;n<St;n++){const a=e.a_((t.x+(n+Lt(n))/Et)/s),l=e.a$((t.y+(r+Lt(r))/Et)/s),c=i.project(a,l),h=r*St+n;Ct[2*h+0]=Math.round((c.x*o.scale-o.x)*e.al),Ct[2*h+1]=Math.round((c.y*o.scale-o.y)*e.al);}Rt.fill(0),At.fill(0);for(let e=2045;e>=0;e--){const t=4*e,i=It[t+0],o=It[t+1],s=It[t+2],r=It[t+3],n=i+s>>1,a=o+r>>1,l=n+a-o,c=a+i-n,h=o*St+i,d=r*St+s,u=a*St+n,_=Math.hypot((Ct[2*h+0]+Ct[2*d+0])/2-Ct[2*u+0],(Ct[2*h+1]+Ct[2*d+1])/2-Ct[2*u+1])>=16;Rt[u]=Rt[u]||(_?1:0),e<1022&&(Rt[u]=Rt[u]||Rt[(o+c>>1)*St+(i+l>>1)]||Rt[(r+c>>1)*St+(s+l>>1)]);}const r=new e.b1,n=new e.b0;let a=0;function l(t,i){const o=i*St+t;return 0===At[o]&&(r.emplaceBack(Ct[2*o+0],Ct[2*o+1],t*e.al/Et,i*e.al/Et),At[o]=++a),At[o]-1}function c(e,t,i,o,s,r){const a=e+i>>1,h=t+o>>1;if(Math.abs(e-s)+Math.abs(t-r)>1&&Rt[h*St+a])c(s,r,e,t,a,h),c(i,o,s,r,a,h);else {const a=l(e,t),c=l(i,o),h=l(s,r);n.emplaceBack(a,c,h);}}return c(0,0,Et,Et,Et,0),c(Et,Et,0,0,0,Et),{vertices:r,indices:n}}(this.tileID.canonical,i);s=t.vertices,r=t.indices;}else {s=new e.b1,r=new e.b0;for(const{x:e,y:t}of o)s.emplaceBack(e,t,0,0);const t=e.bh(s.int16.subarray(0,4*s.length),void 0,4);for(let e=0;e<t.length;e+=3)r.emplaceBack(t[e],t[e+1],t[e+2]);}this._tileBoundsBuffer=t.createVertexBuffer(s,e.bi.members),this._tileBoundsIndexBuffer=t.createIndexBuffer(r),this._tileBoundsSegments=e.bg.simpleSegment(0,0,s.length,r.length);}_makeGlobeTileDebugBuffers(t,i){const o=i.projection;if(!o||"globe"!==o.name||i.freezeTileCoverage)return;const s=this.tileID.canonical,r=e.bj(s,i),n=e.bk(r),a=e.aj(i.zoom);let l;a>0&&(l=e.bl(new Float64Array(16),i.globeMatrix)),this._makeGlobeTileDebugBorderBuffer(t,s,i,n,l,a),this._makeGlobeTileDebugTextBuffer(t,s,i,n,l,a);}_globePoint(t,i,o,s,r,n,a){let l=e.bm(t,i,o);if(n){const r=1<<o.z,c=e.aF(s.center.lng),h=e.aJ(s.center.lat),d=(o.x+.5)/r-c;let u=0;d>.5?u=-1:d<-.5&&(u=1);let _=(t/e.al+o.x)/r+u,p=(i/e.al+o.y)/r;_=(_-c)*s._pixelsPerMercatorPixel+c,p=(p-h)*s._pixelsPerMercatorPixel+h;const f=[_*s.worldSize,p*s.worldSize,0];e.af(f,f,n),l=e.bn(l,f,a);}return e.af(l,l,r)}_makeGlobeTileDebugBorderBuffer(t,i,o,s,r,n){const a=new e.bd,l=new e.be,c=new e.bo,h=(e,t,h,d,u)=>{const _=(h-e)/(u-1),p=(d-t)/(u-1),f=a.length;for(let h=0;h<u;h++){const d=e+h*_,u=t+h*p;a.emplaceBack(d,u);const m=this._globePoint(d,u,i,o,s,r,n);c.emplaceBack(m[0],m[1],m[2]),l.emplaceBack(f+h);}},d=e.al;h(0,0,d,0,16),h(d,0,d,d,16),h(d,d,0,d,16),h(0,d,0,0,16),this._tileDebugIndexBuffer=t.createIndexBuffer(l),this._tileDebugBuffer=t.createVertexBuffer(a,e.bf.members),this._globeTileDebugBorderBuffer=t.createVertexBuffer(c,e.bp.members),this._tileDebugSegments=e.bg.simpleSegment(0,0,a.length,l.length);}_makeGlobeTileDebugTextBuffer(t,i,o,s,r,n){const a=e.al/4,l=new e.bd,c=new e.b0,h=new e.bo,d=25;c.reserve(32),l.reserve(d),h.reserve(d);const u=(e,t)=>d*e+t;for(let e=0;e<d;e++){const t=e*a;for(let e=0;e<d;e++){const c=e*a;l.emplaceBack(c,t);const d=this._globePoint(c,t,i,o,s,r,n);h.emplaceBack(d[0],d[1],d[2]);}}for(let e=0;e<4;e++)for(let t=0;t<4;t++){const i=u(e,t),o=u(e,t+1),s=u(e+1,t),r=u(e+1,t+1);c.emplaceBack(i,o,s),c.emplaceBack(s,o,r);}this._tileDebugTextIndexBuffer=t.createIndexBuffer(c),this._tileDebugTextBuffer=t.createVertexBuffer(l,e.bf.members),this._globeTileDebugTextBuffer=t.createVertexBuffer(h,e.bp.members),this._tileDebugTextSegments=e.bg.simpleSegment(0,0,d,32);}destroy(t=!0){for(const e in this.buckets)this.buckets[e].destroy(t);this.buckets={},this.imageAtlas&&(this.imageAtlas=null),this.lineAtlas&&(this.lineAtlas=null),this.imageAtlasTexture&&(this.imageAtlasTexture.destroy(),delete this.imageAtlasTexture),this.glyphAtlasTexture&&(this.glyphAtlasTexture.destroy(),delete this.glyphAtlasTexture),this.lineAtlasTexture&&(this.lineAtlasTexture.destroy(),delete this.lineAtlasTexture),this._tileBoundsBuffer&&(this._tileBoundsBuffer.destroy(),this._tileBoundsIndexBuffer.destroy(),this._tileBoundsSegments.destroy(),this._tileBoundsBuffer=null),this._tileDebugBuffer&&(this._tileDebugBuffer.destroy(),this._tileDebugSegments.destroy(),this._tileDebugBuffer=null),this._tileDebugIndexBuffer&&(this._tileDebugIndexBuffer.destroy(),this._tileDebugIndexBuffer=null),this._globeTileDebugBorderBuffer&&(this._globeTileDebugBorderBuffer.destroy(),this._globeTileDebugBorderBuffer=null),this._tileDebugTextBuffer&&(this._tileDebugTextBuffer.destroy(),this._tileDebugTextSegments.destroy(),this._tileDebugTextIndexBuffer.destroy(),this._tileDebugTextBuffer=null),this._globeTileDebugTextBuffer&&(this._globeTileDebugTextBuffer.destroy(),this._globeTileDebugTextBuffer=null),t&&this.texture&&this.texture instanceof e.T&&(this.texture.destroy(),delete this.texture),this.emissiveTexture&&this.emissiveTexture instanceof e.T&&(this.emissiveTexture.destroy(),delete this.emissiveTexture),this.hillshadeFBO&&(this.hillshadeFBO.destroy(),delete this.hillshadeFBO),this.dem&&delete this.dem,this.neighboringTiles&&delete this.neighboringTiles,this.demTexture&&(this.demTexture.destroy(),delete this.demTexture),this.rasterParticleState&&(this.rasterParticleState.destroy(),delete this.rasterParticleState),this.latestFeatureIndex=null,this.state="unloaded";}}e.bs.setPbf(e.bt);class Ot extends Pt{constructor(e,t,i,o,s){super(e,t,i,o,s),this._workQueuePerLayer=new Map,this._fetchQueuePerLayer=new Map,this._taskQueue=new Map,this._isHeaderLoaded=!1,this.textureDescriptorPerLayer=new Map,this.texturePerLayer=new Map;}getLayers(){return this._mrt?Object.values(this._mrt.layers):[]}getLayer(e){return this._mrt&&this._mrt.getLayer(e)}setTexturePerLayer(t,i,o){const s=o.context,r=s.gl;let n=this.texturePerLayer.get(t)||o.getTileTexture(i.width);n&&n instanceof e.T?n.update(i,{premultiply:!1}):n=new e.T(s,i,r.RGBA8,{premultiply:!1}),this.texturePerLayer.has(t)||this.texturePerLayer.set(t,n);}flushQueues(e){const t=this._workQueuePerLayer.get(e)||[],i=this._fetchQueuePerLayer.get(e)||[];for(;t.length;)t.pop()();for(;i.length;)i.pop()();}flushAllQueues(){for(const e of this._workQueuePerLayer.keys()){const t=this._workQueuePerLayer.get(e)||[];for(;t.length;)t.pop()();}for(const e of this._fetchQueuePerLayer.keys()){const t=this._fetchQueuePerLayer.get(e)||[];for(;t.length;)t.pop()();}}fetchHeader(t=16384,i){const o=this._mrt=new e.bs(30),s=Object.assign({},this.requestParams,{headers:{Range:"bytes=0-"+(t-1)}});return this.entireBuffer=null,this.request=e.bu(s,((e,s,r)=>{if(e)i(e);else try{const e=o.getHeaderLength(s);if(e>t)return void(this.request=this.fetchHeader(e,i));o.parseHeader(s),this._isHeaderLoaded=!0;let n=0;for(const e of Object.values(o.layers))n=Math.max(n,e.dataIndex[e.dataIndex.length-1].lastByte);s.byteLength>=n&&(this.entireBuffer=s),i(null,this.entireBuffer||s,r);}catch(e){i(e);}})),this.request}fetchBandForRender(e,t,i,o){this.fetchBand(e,t,i,(s=>{if(s)return void o(s);this.updateTextureDescriptor(e,t,i);const r=this.textureDescriptorPerLayer.get(t);o(null,r?r.img:null);}));}fetchBand(t,i,o,s,r=!0){const n=this._mrt;if(!this._isHeaderLoaded||!n)return void s(new Error("Tile header is not ready"));const a=this.actor;if(!a)return void s(new Error("Can't fetch tile band without an actor"));let l;const c=e.B(String(o),e.B(this.tileID.key,t));let h=this._taskQueue.get(c);h?h.add(s):(h=new Set,h.add(s),this._taskQueue.set(c,h));const d=(e,t)=>{l.complete(e,t),e?s(e):(h.forEach((e=>e(null,t))),this._taskQueue.delete(c));},u=(e,t)=>{if(e)return s(e);const o=a.send("decodeRasterArray",{type:"raster-array",source:this.source,scope:this.scope,tileID:this.tileID,uid:this.uid,buffer:t,task:l},d,void 0,!0);if(null!==i){const e=this._workQueuePerLayer.get(i)||[];e.push((()=>{o&&o.cancel(),l.cancel();})),this._workQueuePerLayer.has(i)||this._workQueuePerLayer.set(i,e);}};let _;try{_=n.getLayer(t);}catch(e){if("reloading"===this.state)return;throw e}if(!_)return void s(new Error(`Unknown sourceLayer "${t}"`));if(_.hasDataForBand(o))return h.forEach((e=>e(null,null))),void this._taskQueue.delete(c);const p=_.getDataRange([o]);if(l=n.createDecodingTask(p),!l||l.tasks.length)if(null!==i&&this.flushQueues(i),this.entireBuffer)u(null,this.entireBuffer.slice(p.firstByte,p.lastByte+1));else {const t=Object.assign({},this.requestParams,{headers:{Range:`bytes=${p.firstByte}-${p.lastByte}`}}),o=e.bu(t,u);if(null!==i){const e=this._fetchQueuePerLayer.get(i)||[];e.push((()=>{o.cancel(),l.cancel();})),this._fetchQueuePerLayer.has(i)||this._fetchQueuePerLayer.set(i,e);}}}updateNeeded(e,t){return (!this.textureDescriptorPerLayer.get(e)||this.textureDescriptorPerLayer.get(e).band!==t||this.refreshedUponExpiration)&&"errored"!==this.state}updateTextureDescriptor(t,i,o){if(!this._mrt)return;const s=this._mrt.getLayer(t);if(!s||!s.hasBand(o)||!s.hasDataForBand(o))return;const{bytes:r,tileSize:n,buffer:a,offset:l,scale:c}=s.getBandView(o),h=n+2*a,d=new e.q({width:h,height:h},r),u=this.texturePerLayer.get(i);u&&u instanceof e.T&&u.update(d,{premultiply:!1}),this.textureDescriptorPerLayer.set(i,{layer:t,band:o,img:d,buffer:a,offset:l,tileSize:n,format:s.pixelFormat,mix:[c,256*c,65536*c,16777216*c]});}destroy(t=!1){if(super.destroy(t),delete this._mrt,!t)for(const t of this.texturePerLayer.values())t&&t instanceof e.T&&t.destroy();this.texturePerLayer.clear(),this.textureDescriptorPerLayer.clear(),this.fbo&&(this.fbo.destroy(),delete this.fbo),delete this.request,delete this.requestParams,this._isHeaderLoaded=!1;}}class zt{constructor(e,t){this.max=e,this.onRemove=t,this.reset();}reset(){for(const e in this.data)for(const t of this.data[e])t.timeout&&clearTimeout(t.timeout),this.onRemove(t.value);return this.data={},this.order=[],this}add(e,t,i){const o=e.wrapped().key;void 0===this.data[o]&&(this.data[o]=[]);const s={value:t,timeout:void 0};if(void 0!==i&&(s.timeout=setTimeout((()=>{this.remove(e,s);}),i)),this.data[o].push(s),this.order.push(o),this.order.length>this.max){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e);}return this}has(e){return e.wrapped().key in this.data}getAndRemove(e){return this.has(e)?this._getAndRemoveByKey(e.wrapped().key):null}_getAndRemoveByKey(e){const t=this.data[e].shift();return t.timeout&&clearTimeout(t.timeout),0===this.data[e].length&&delete this.data[e],this.order.splice(this.order.indexOf(e),1),t.value}getByKey(e){const t=this.data[e];return t?t[0].value:null}get(e){return this.has(e)?this.data[e.wrapped().key][0].value:null}remove(e,t){if(!this.has(e))return this;const i=e.wrapped().key,o=void 0===t?0:this.data[i].indexOf(t),s=this.data[i][o];return this.data[i].splice(o,1),s.timeout&&clearTimeout(s.timeout),0===this.data[i].length&&delete this.data[i],this.onRemove(s.value),this.order.splice(this.order.indexOf(i),1),this}setMaxSize(e){for(this.max=e;this.order.length>this.max;){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e);}return this}filter(e){const t=[];for(const i in this.data)for(const o of this.data[i])e(o.value)||t.push(o);for(const e of t)this.remove(e.value.tileID,e);}}class Mt{constructor(){this.state={},this.stateChanges={},this.deletedStates={};}updateState(e,t,i){const o=String(t);if(this.stateChanges[e]=this.stateChanges[e]||{},this.stateChanges[e][o]=this.stateChanges[e][o]||{},Object.assign(this.stateChanges[e][o],i),null===this.deletedStates[e]){this.deletedStates[e]={};for(const t in this.state[e])t!==o&&(this.deletedStates[e][t]=null);}else if(this.deletedStates[e]&&null===this.deletedStates[e][o]){this.deletedStates[e][o]={};for(const t in this.state[e][o])i[t]||(this.deletedStates[e][o][t]=null);}else for(const t in i)this.deletedStates[e]&&this.deletedStates[e][o]&&null===this.deletedStates[e][o][t]&&delete this.deletedStates[e][o][t];}removeFeatureState(e,t,i){if(null===this.deletedStates[e])return;const o=String(t);if(this.deletedStates[e]=this.deletedStates[e]||{},i&&void 0!==t)null!==this.deletedStates[e][o]&&(this.deletedStates[e][o]=this.deletedStates[e][o]||{},this.deletedStates[e][o][i]=null);else if(void 0!==t)if(this.stateChanges[e]&&this.stateChanges[e][o])for(i in this.deletedStates[e][o]={},this.stateChanges[e][o])this.deletedStates[e][o][i]=null;else this.deletedStates[e][o]=null;else this.deletedStates[e]=null;}getState(e,t){const i=this.state[e]||{},o=this.stateChanges[e]||{},s=this.deletedStates[e];if(null===s)return {};if(void 0!==t){const e=String(t),r=Object.assign({},i[e],o[e]);if(s){const e=s[t];if(null===e)return {};for(const t in e)delete r[t];}return r}const r=Object.assign({},i,o);if(s)for(const e in s)delete r[e];return r}initializeTileState(e,t){e.refreshFeatureState(t);}coalesceChanges(e,t){const i={};for(const e in this.stateChanges){this.state[e]=this.state[e]||{};const t={};for(const i in this.stateChanges[e])this.state[e][i]||(this.state[e][i]={}),Object.assign(this.state[e][i],this.stateChanges[e][i]),t[i]=this.state[e][i];i[e]=t;}for(const e in this.deletedStates){this.state[e]=this.state[e]||{};const t={};if(null===this.deletedStates[e])for(const i in this.state[e])t[i]={},this.state[e][i]={};else for(const i in this.deletedStates[e]){if(null===this.deletedStates[e][i])this.state[e][i]={};else if(this.state[e][i])for(const t of Object.keys(this.deletedStates[e][i]))delete this.state[e][i][t];t[i]=this.state[e][i];}i[e]=i[e]||{},Object.assign(i[e],t);}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(i).length)for(const i in e)e[i].refreshFeatureState(t);}}class Ft extends e.E{constructor(e,t,i){super(),this.id=e,this._onlySymbols=i,t.on("data",(e=>{"source"===e.dataType&&"metadata"===e.sourceDataType&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===e.dataType&&"content"===e.sourceDataType&&(this.reload(),this.transform&&this.update(this.transform));})),t.on("error",(()=>{this._sourceErrored=!0;})),this._source=t,this._tiles={},this._cache=new zt(0,this._unloadTile.bind(this)),this._timers={},this._cacheTimers={},this._minTileCacheSize=t.minTileCacheSize,this._maxTileCacheSize=t.maxTileCacheSize,this._loadedParentTiles={},this.castsShadows=!1,this.tileCoverLift=0,this._coveredTiles={},this._shadowCasterTiles={},this._state=new Mt,this._isRaster="raster"===this._source.type||"raster-dem"===this._source.type||"raster-array"===this._source.type||"custom"===this._source.type&&"raster"===this._source._dataType;}onAdd(e){this.map=e,this._minTileCacheSize=void 0===this._minTileCacheSize&&e?e._minTileCacheSize:this._minTileCacheSize,this._maxTileCacheSize=void 0===this._maxTileCacheSize&&e?e._maxTileCacheSize:this._maxTileCacheSize;}loaded(){if(this._sourceErrored)return !0;if(!this._sourceLoaded)return !1;if(!this._source.loaded())return !1;for(const e in this._tiles)if(!this._tiles[e].loaded())return !1;return !0}getSource(){return this._source}pause(){this._paused=!0;}resume(){if(!this._paused)return;const e=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,e&&this.reload(),this.transform&&this.update(this.transform);}_loadTile(e,t){return e.isSymbolTile=this._onlySymbols,e.isExtraShadowCaster=this._shadowCasterTiles[e.tileID.key],this._source.loadTile(e,t)}_unloadTile(e){if(this._source.unloadTile)return this._source.unloadTile(e)}_abortTile(e){if(this._source.abortTile)return this._source.abortTile(e)}serialize(){return this._source.serialize()}prepare(e){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const t in this._tiles){const i=this._tiles[t];i.upload(e,this.map?this.map.painter:void 0),i.prepare(this.map.style.imageManager,this.map?this.map.painter:null,this._source.scope);}}getIds(){return Object.values(this._tiles).map((e=>e.tileID)).sort(Bt).map((e=>e.key))}getRenderableIds(t,i){const o=[];for(const e in this._tiles)this._isIdRenderable(+e,t,i)&&o.push(this._tiles[e]);return t?o.sort(((t,i)=>{const o=t.tileID,s=i.tileID,r=new e.P(o.canonical.x,o.canonical.y)._rotate(this.transform.angle),n=new e.P(s.canonical.x,s.canonical.y)._rotate(this.transform.angle);return o.overscaledZ-s.overscaledZ||n.y-r.y||n.x-r.x})).map((e=>e.tileID.key)):o.map((e=>e.tileID)).sort(Bt).map((e=>e.key))}hasRenderableParent(e){const t=this.findLoadedParent(e,0);return !!t&&this._isIdRenderable(t.tileID.key)}_isIdRenderable(e,t,i){return this._tiles[e]&&this._tiles[e].hasData()&&!this._coveredTiles[e]&&(t||!this._tiles[e].holdingForFade())&&(i||!this._shadowCasterTiles[e])}reload(){if(this._paused)this._shouldReloadOnResume=!0;else {this._cache.reset();for(const e in this._tiles)"errored"!==this._tiles[e].state&&this._reloadTile(+e,"reloading");}}_reloadTile(e,t){const i=this._tiles[e];i&&("loading"!==i.state&&(i.state=t),this._loadTile(i,this._tileLoaded.bind(this,i,e,t)));}_tileLoaded(t,i,o,s,r){if(s){if(t.state="errored",404!==s.status)this._source.fire(new e.y(s,{tile:t}));else {if(this._source.fire(new e.z("data",{dataType:"source",sourceDataType:"error",sourceId:this._source.id,tile:t})),!(t.tileID.key in this._loadedParentTiles))return;if("raster-dem"===this._source.type&&this.usedForTerrain&&this.map.painter.terrain){const e=this.map.painter.terrain;this.update(this.transform,e.getScaledDemTileSize(),!0),e.resetTileLookupCache(this.id);}else this.update(this.transform);}return}t.timeAdded=e.o.now(),"expired"===o&&(t.refreshedUponExpiration=!0),this._setTileReloadTimer(i,t),"raster-dem"===this._source.type&&t.dem&&this._backfillDEM(t),this._state.initializeTileState(t,this.map?this.map.painter:null);let n=new Map;r&&r.responseHeaders&&(n=r.responseHeaders),this._source.fire(new e.z("data",{dataType:"source",tile:t,coord:t.tileID,sourceCacheId:this.id,responseHeaders:n}));}_backfillDEM(e){const t=this.getRenderableIds();for(let o=0;o<t.length;o++){const s=t[o];if(e.neighboringTiles&&e.neighboringTiles[s]){const t=this.getTileByID(s);i(e,t),i(t,e);}}function i(e,t){if(!e.dem||e.dem.borderReady)return;e.needsHillshadePrepare=!0,e.needsDEMTextureUpload=!0;let i=t.tileID.canonical.x-e.tileID.canonical.x;const o=t.tileID.canonical.y-e.tileID.canonical.y,s=Math.pow(2,e.tileID.canonical.z),r=t.tileID.key;0===i&&0===o||Math.abs(o)>1||(Math.abs(i)>1&&(1===Math.abs(i+s)?i+=s:1===Math.abs(i-s)&&(i-=s)),t.dem&&e.dem&&(e.dem.backfillBorder(t.dem,i,o),e.neighboringTiles&&e.neighboringTiles[r]&&(e.neighboringTiles[r].backfilled=!0)));}}getTile(e){return this.getTileByID(e.key)}getTileByID(e){return this._tiles[e]}_retainLoadedChildren(e,t,i,o){for(const s in this._tiles){let r=this._tiles[s];if(o[s]||!r.hasData()||r.tileID.overscaledZ<=t||r.tileID.overscaledZ>i)continue;let n=r.tileID;for(;r&&r.tileID.overscaledZ>t+1;){const e=r.tileID.scaledTo(r.tileID.overscaledZ-1);r=this._tiles[e.key],r&&r.hasData()&&(n=e);}let a=n;for(;a.overscaledZ>t;)if(a=a.scaledTo(a.overscaledZ-1),e[a.key]){o[n.key]=n;break}}}findLoadedParent(e,t){if(e.key in this._loadedParentTiles){const i=this._loadedParentTiles[e.key];return i&&i.tileID.overscaledZ>=t?i:null}for(let i=e.overscaledZ-1;i>=t;i--){const t=e.scaledTo(i),o=this._getLoadedTile(t);if(o)return o}}_getLoadedTile(e){const t=this._tiles[e.key];return t&&t.hasData()?t:this._cache.getByKey(this._source.reparseOverscaled?e.wrapped().key:e.canonical.key)}updateCacheSize(e,t){t=t||this._source.tileSize;const i=Math.ceil(e.width/t)+1,o=Math.ceil(e.height/t)+1,s=Math.floor(i*o*5),r="number"==typeof this._minTileCacheSize?Math.max(this._minTileCacheSize,s):s,n="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,r):r;this._cache.setMaxSize(n);}handleWrapJump(e){const t=Math.round((e-(void 0===this._prevLng?e:this._prevLng))/360);if(this._prevLng=e,t){const e={};for(const i in this._tiles){const o=this._tiles[i];o.tileID=o.tileID.unwrapTo(o.tileID.wrap+t),e[o.tileID.key]=o;}this._tiles=e;for(const e in this._timers)clearTimeout(this._timers[e]),delete this._timers[e];for(const e in this._tiles)this._setTileReloadTimer(+e,this._tiles[e]);}}update(t,i,o,s,r){if(this.transform=t,!this._sourceLoaded||this._paused||this.transform.freezeTileCoverage)return;if(this.usedForTerrain&&!o)return;this.updateCacheSize(t,i),"globe"!==this.transform.projection.name&&this.handleWrapJump(this.transform.center.lng),this._shadowCasterTiles={},this._coveredTiles={};const n="batched-model"===this._source.type;let a,l=this._source.maxzoom;const c=this.map&&this.map.painter?this.map.painter._terrain:null;if(c&&c.sourceCache===this&&c.attenuationRange()){const e=c.attenuationRange()[0],t=Math.floor(e)-Math.log2(c.getDemUpscale());l>t&&(l=t);}if(this.used||this.usedForTerrain){if(this._source.tileID)a=t.getVisibleUnwrappedCoordinates(this._source.tileID).map((t=>new e.aQ(t.canonical.z,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y)));else if(0!==this.tileCoverLift){const s=t.clone();s.tileCoverLift=this.tileCoverLift,a=s.coveringTiles({tileSize:i||this._source.tileSize,minzoom:this._source.minzoom,maxzoom:l,roundZoom:this._source.roundZoom&&!o,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain,calculateQuadrantVisibility:n}),this._source.minzoom<=1&&"globe"===t.projection.name&&(a.push(new e.aQ(1,0,1,0,0)),a.push(new e.aQ(1,0,1,1,0)),a.push(new e.aQ(1,0,1,0,1)),a.push(new e.aQ(1,0,1,1,1)));}else if(a=t.coveringTiles({tileSize:i||this._source.tileSize,minzoom:this._source.minzoom,maxzoom:l,roundZoom:this._source.roundZoom&&!o,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain,calculateQuadrantVisibility:n}),this._source.hasTile){const e=this._source.hasTile.bind(this._source);a=a.filter((t=>e(t)));}}else a=[];if(a.length>0&&"globe"!==this.transform.projection.name&&!this.usedForTerrain&&!kt(this._source.type)){const e=t.coveringZoomLevel({tileSize:i||this._source.tileSize,roundZoom:this._source.roundZoom&&!o}),l=Math.min(e,this._source.maxzoom);if(n){const e=t.extendTileCover(a,l);for(const t of e)a.push(t);}else if(r){const e=t.extendTileCoverToNearPlane(a,this.transform.getFrustum(l),l);for(const t of e)a.push(t);}else if(this.castsShadows&&s){const e=t.extendTileCover(a,l,s,16);for(const t of e)this._shadowCasterTiles[t.key]=!0,a.push(t);}}const h=this._updateRetainedTiles(a);if(kt(this._source.type)&&0!==a.length){const t={},i={},o=Object.keys(h);for(const s of o){const o=h[s],r=this._tiles[s];if(!r||r.fadeEndTime&&r.fadeEndTime<=e.o.now())continue;const n=this.findLoadedParent(o,Math.max(o.overscaledZ-Ft.maxOverzooming,this._source.minzoom));n&&(this._addTile(n.tileID),t[n.tileID.key]=n.tileID),i[s]=o;}const s=a[a.length-1].overscaledZ;for(const e in this._tiles){const t=this._tiles[e];if(h[e]||!t.hasData())continue;let o=t.tileID;for(;o.overscaledZ>s;){o=o.scaledTo(o.overscaledZ-1);const s=this._tiles[o.key];if(s&&s.hasData()&&i[o.key]){h[e]=t.tileID;break}}}for(const e in t)h[e]||(this._coveredTiles[e]=!0,h[e]=t[e]);}for(const e in h)this._tiles[e].clearFadeHold();const d=e.bv(this._tiles,h);for(const e of d){const t=this._tiles[e];t.hasSymbolBuckets&&!t.holdingForFade()?t.setHoldDuration(this.map._fadeDuration):t.hasSymbolBuckets&&!t.symbolFadeFinished()||this._removeTile(+e);}this._updateLoadedParentTileCache(),this._onlySymbols&&this._source.afterUpdate&&this._source.afterUpdate();}releaseSymbolFadeTiles(){for(const e in this._tiles)this._tiles[e].holdingForFade()&&this._removeTile(+e);}_updateRetainedTiles(e){const t={};if(0===e.length)return t;const i={},o=e.reduce(((e,t)=>Math.min(e,t.overscaledZ)),1/0),s=e[0].overscaledZ,r=Math.max(s-Ft.maxOverzooming,this._source.minzoom),n=Math.max(s+Ft.maxUnderzooming,this._source.minzoom),a={};for(const i of e){const e=this._addTile(i);t[i.key]=i,e.hasData()||o<this._source.maxzoom&&(a[i.key]=i);}this._retainLoadedChildren(a,o,n,t);for(const o of e){let e=this._tiles[o.key];if(e.hasData())continue;if(o.canonical.z>=this._source.maxzoom){const e=o.children(this._source.maxzoom)[0],i=this.getTile(e);if(i&&i.hasData()){t[e.key]=e;continue}}else {const e=o.children(this._source.maxzoom);if(t[e[0].key]&&t[e[1].key]&&t[e[2].key]&&t[e[3].key])continue}let s=e.wasRequested();for(let n=o.overscaledZ-1;n>=r;--n){const r=o.scaledTo(n);if(i[r.key])break;if(i[r.key]=!0,e=this.getTile(r),!e&&s&&(e=this._addTile(r)),e&&(t[r.key]=r,s=e.wasRequested(),e.hasData()))break}}return t}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const e in this._tiles){const t=[];let i,o=this._tiles[e].tileID;for(;o.overscaledZ>0;){if(o.key in this._loadedParentTiles){i=this._loadedParentTiles[o.key];break}t.push(o.key);const e=o.scaledTo(o.overscaledZ-1);if(i=this._getLoadedTile(e),i)break;o=e;}for(const e of t)this._loadedParentTiles[e]=i;}}_addTile(t){let i=this._tiles[t.key];if(i)return !0!==i.isExtraShadowCaster||!!this._shadowCasterTiles[t.key]||this._reloadTile(t.key,"reloading"),i;i=this._cache.getAndRemove(t),i&&(this._setTileReloadTimer(t.key,i),i.tileID=t,this._state.initializeTileState(i,this.map?this.map.painter:null),this._cacheTimers[t.key]&&(clearTimeout(this._cacheTimers[t.key]),delete this._cacheTimers[t.key],this._setTileReloadTimer(t.key,i)));const o=Boolean(i);if(!o){const e=this.map?this.map.painter:null,o=this._source.tileSize*t.overscaleFactor();i="raster-array"===this._source.type?new Ot(t,o,this.transform.tileZoom,e,this._isRaster):new Pt(t,o,this.transform.tileZoom,e,this._isRaster,this._source.worldview),this._loadTile(i,this._tileLoaded.bind(this,i,t.key,i.state));}return i.uses++,this._tiles[t.key]=i,o||this._source.fire(new e.z("dataloading",{tile:i,coord:i.tileID,dataType:"source"})),i}_setTileReloadTimer(e,t){e in this._timers&&(clearTimeout(this._timers[e]),delete this._timers[e]);const i=t.getExpiryTimeout();i&&(this._timers[e]=setTimeout((()=>{this._reloadTile(e,"expired"),delete this._timers[e];}),i));}_removeTile(e){const t=this._tiles[e];t&&(t.uses--,delete this._tiles[e],this._timers[e]&&(clearTimeout(this._timers[e]),delete this._timers[e]),t.uses>0||(t.hasData()&&"reloading"!==t.state||"empty"===t.state?this._cache.add(t.tileID,t,t.getExpiryTimeout()):(t.aborted=!0,this._abortTile(t),this._unloadTile(t))));}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const e in this._tiles)this._removeTile(+e);this._source._clear&&this._source._clear(),this._cache.reset(),this.map&&this.usedForTerrain&&this.map.painter.terrain&&this.map.painter.terrain.resetTileLookupCache(this.id);}tilesIn(t,i,o){const s=[],r=this.transform;if(!r)return s;const n="globe"===r.projection.name,a=e.aF(r.center.lng);for(const l in this._tiles){const c=this._tiles[l];if(o&&c.clearQueryDebugViz(),c.holdingForFade())continue;let h;if(n){const t=c.tileID.canonical;if(0===t.z){const i=[Math.abs(e.aA(a,...Nt(t,-1))-a),Math.abs(e.aA(a,...Nt(t,1))-a)];h=[0,2*i.indexOf(Math.min(...i))-1];}else {const i=[Math.abs(e.aA(a,...Nt(t,-1))-a),Math.abs(e.aA(a,...Nt(t,0))-a),Math.abs(e.aA(a,...Nt(t,1))-a)];h=[i.indexOf(Math.min(...i))-1];}}else h=[0];for(const e of h){const o=t.containsTile(c,r,i,e);o&&s.push(o);}}return s}getShadowCasterCoordinates(){return this._getRenderableCoordinates(!1,!0)}getVisibleCoordinates(e){return this._getRenderableCoordinates(e)}_getRenderableCoordinates(e,t){const i=this.getRenderableIds(e,t).map((e=>this._tiles[e].tileID)),o="globe"===this.transform.projection.name;for(const e of i)e.projMatrix=this.transform.calculateProjMatrix(e.toUnwrapped()),e.expandedProjMatrix=o?this.transform.calculateProjMatrix(e.toUnwrapped(),!1,!0):e.projMatrix;return i}sortCoordinatesByDistance(e){const t=e.slice(),i=this.transform._camera.position,o=this.transform._camera.forward(),s={};for(const e of t){const t=1/(1<<e.canonical.z);s[e.key]=((e.canonical.x+.5)*t+e.wrap-i[0])*o[0]+((e.canonical.y+.5)*t-i[1])*o[1]-i[2]*o[2];}return t.sort(((e,t)=>s[e.key]-s[t.key])),t}hasTransition(){if(this._source.hasTransition())return !0;if(kt(this._source.type))for(const t in this._tiles){const i=this._tiles[t];if(void 0!==i.fadeEndTime&&i.fadeEndTime>=e.o.now())return !0}return !1}setFeatureState(e,t,i){this._state.updateState(e=e||"_geojsonTileLayer",t,i);}removeFeatureState(e,t,i){this._state.removeFeatureState(e=e||"_geojsonTileLayer",t,i);}getFeatureState(e,t){return this._state.getState(e=e||"_geojsonTileLayer",t)}setDependencies(e,t,i){const o=this._tiles[e];o&&o.setDependencies(t,i);}reloadTilesForDependencies(e,t){for(const i in this._tiles)this._tiles[i].hasDependency(e,t)&&this._reloadTile(+i,"reloading");this._cache.filter((i=>!i.hasDependency(e,t)));}_preloadTiles(t,i){if(!this._sourceLoaded){const e=()=>{this._sourceLoaded&&(this._source.off("data",e),this._preloadTiles(t,i));};return void this._source.on("data",e)}const o=new Map,s=Array.isArray(t)?t:[t],r=this.map.painter.terrain,n=this.usedForTerrain&&r?r.getScaledDemTileSize():this._source.tileSize;for(const e of s){const t=e.coveringTiles({tileSize:n,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!this.usedForTerrain,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain});for(const e of t)o.set(e.key,e);this.usedForTerrain&&e.updateElevation(!1);}const a=Array.from(o.values());e.bw(a,((e,t)=>{const i=new Pt(e,this._source.tileSize*e.overscaleFactor(),this.transform.tileZoom,this.map.painter,this._isRaster,this._source.worldview);this._loadTile(i,(e=>{"raster-dem"===this._source.type&&i.dem&&this._backfillDEM(i),t(e,i);}));}),i);}}function Bt(e,t){const i=Math.abs(2*e.wrap)-+(e.wrap<0),o=Math.abs(2*t.wrap)-+(t.wrap<0);return e.overscaledZ-t.overscaledZ||o-i||t.canonical.y-e.canonical.y||t.canonical.x-e.canonical.x}function kt(e){return "raster"===e||"image"===e||"video"===e||"custom"===e}function Nt(e,t){const i=1<<e.z;return [e.x/i+t,(e.x+1)/i+t]}Ft.maxOverzooming=10,Ft.maxUnderzooming=3;class Ut{constructor(e){this.style=e,this.layersGotHidden=!1,this.layers=[];}processLayersChanged(){this.layers=[];const e=!1,t=!1;for(const i in this.style._mergedLayers){const o=this.style._mergedLayers[i];if("fill-extrusion"===o.type||"building"===o.type)this.layers.push({layer:o,visible:e,visibilityChanged:t});else if("model"===o.type){const i=this.style.getLayerSource(o);i&&"batched-model"===i.type&&this.layers.push({layer:o,visible:e,visibilityChanged:t});}}}onNewFrame(e){this.layersGotHidden=!1;for(const t of this.layers){const i=t.layer;let o=!1;"fill-extrusion"===i.type?o=!i.isHidden(e)&&i.paint.get("fill-extrusion-opacity")>0:"building"===i.type?o=!i.isHidden(e)&&i.paint.get("building-opacity")>0:"model"===i.type&&(o=!i.isHidden(e)&&i.paint.get("model-opacity").constantOr(1)>0),this.layersGotHidden=this.layersGotHidden||!o&&t.visible,t.visible=o;}}updateZOffset(e,t){this.currentBuildingBuckets=[];for(const e of this.layers){const i=e.layer,o=this.style.getLayerSourceCache(i);let s=1;"fill-extrusion"===i.type?s=e.visible?i.paint.get("fill-extrusion-vertical-scale"):0:"building"===i.type&&(s=e.visible?i.paint.get("building-vertical-scale"):0);let r=o?o.getTile(t):null;if(!r&&o)for(const e in o._tiles){const i=o._tiles[e];if(t.canonical.isChildOf(i.tileID.canonical)){r=i;break}}this.currentBuildingBuckets.push({bucket:r?r.getBucket(i):null,tileID:r?r.tileID:t,verticalScale:s});}e.hasAnyZOffset=!1;let i=!1;for(let o=0;o<e.symbolInstances.length;o++){const s=e.symbolInstances.get(o),r=s.zOffset,n=this._getHeightAtTileOffset(t,s.tileAnchorX,s.tileAnchorY);s.zOffset=n!==Number.NEGATIVE_INFINITY?n:r,i||r===s.zOffset||(i=!0),e.hasAnyZOffset||0===s.zOffset||(e.hasAnyZOffset=!0);}i&&(e.zOffsetBuffersNeedUpload=!0,e.zOffsetSortDirty=!0);}_mapCoordToOverlappingTile(t,i,o,s){let r=i,n=o;if(t.canonical.z!==s.canonical.z){const a=s.canonical,l=1/(1<<t.canonical.z-a.z);r=(i+t.canonical.x*e.al)*l-a.x*e.al|0,n=(o+t.canonical.y*e.al)*l-a.y*e.al|0;}return {tileX:r,tileY:n}}_getHeightAtTileOffset(e,t,i){let o,s;for(let r=0;r<this.layers.length;++r){const n=this.layers[r].layer;if("fill-extrusion"!==n.type&&"building"!==n.type)continue;const{bucket:a,tileID:l,verticalScale:c}=this.currentBuildingBuckets[r];if(!a)continue;const{tileX:h,tileY:d}=this._mapCoordToOverlappingTile(e,t,i,l),u=a.getHeightAtTileCoord(h,d);u&&void 0!==u.height&&(u.hidden?o=u.height:s=Math.max(u.height*c,s||0));}if(void 0!==s)return s;for(let s=0;s<this.layers.length;++s){const r=this.layers[s];if("model"!==r.layer.type||!r.visible)continue;const{bucket:n,tileID:a}=this.currentBuildingBuckets[s];if(!n)continue;const{tileX:l,tileY:c}=this._mapCoordToOverlappingTile(e,t,i,a),h=n.getHeightAtTileCoord(l,c);if(h&&!h.hidden)return void 0===h.height&&void 0!==o?Math.min(h.maxHeight,o)*h.verticalScale:h.height?h.height*h.verticalScale:Number.NEGATIVE_INFINITY}return this.layersGotHidden?0:Number.NEGATIVE_INFINITY}}function jt(t,i){const o={};for(const e in t)"ref"!==e&&(o[e]=t[e]);return e.bx.forEach((e=>{e in i&&(o[e]=i[e]);})),o}function Gt(e){e=e.slice();const t=Object.create(null);for(let i=0;i<e.length;i++)t[e[i].id]=e[i];for(let i=0;i<e.length;i++)"ref"in e[i]&&(e[i]=jt(e[i],t[e[i].ref]));return e}const Vt={setStyle:"setStyle",addLayer:"addLayer",removeLayer:"removeLayer",setPaintProperty:"setPaintProperty",setLayoutProperty:"setLayoutProperty",setSlot:"setSlot",setFilter:"setFilter",addSource:"addSource",removeSource:"removeSource",setGeoJSONSourceData:"setGeoJSONSourceData",setLayerZoomRange:"setLayerZoomRange",setLayerProperty:"setLayerProperty",setCenter:"setCenter",setZoom:"setZoom",setBearing:"setBearing",setPitch:"setPitch",setSprite:"setSprite",setGlyphs:"setGlyphs",setTransition:"setTransition",setLight:"setLight",setTerrain:"setTerrain",setFog:"setFog",setSnow:"setSnow",setRain:"setRain",setCamera:"setCamera",setLights:"setLights",setProjection:"setProjection",addImport:"addImport",removeImport:"removeImport",updateImport:"updateImport",addIconset:"addIconset",removeIconset:"removeIconset"};function Ht(e,t,i){i.push({command:Vt.addSource,args:[e,t[e]]});}function qt(e,t,i){t.push({command:Vt.removeSource,args:[e]}),i[e]=!0;}function Zt(e,t,i,o){qt(e,i,o),Ht(e,t,i);}function Wt(t,i,o){let s;for(s in t[o])if(t[o].hasOwnProperty(s)&&"data"!==s&&!e.by(t[o][s],i[o][s]))return !1;for(s in i[o])if(i[o].hasOwnProperty(s)&&"data"!==s&&!e.by(t[o][s],i[o][s]))return !1;return !0}function $t(t,i,o,s,r,n){let a;for(a in i=i||{},t=t||{})t.hasOwnProperty(a)&&(e.by(t[a],i[a])||o.push({command:n,args:[s,a,i[a],r]}));for(a in i)i.hasOwnProperty(a)&&!t.hasOwnProperty(a)&&(e.by(t[a],i[a])||o.push({command:n,args:[s,a,i[a],r]}));}function Xt(e){return e.id}function Yt(e,t){return e[t.id]=t,e}function Kt(t,i,o){const s=i.createTileMatrix(t,t.worldSize,o.toUnwrapped());return e.aB(new Float32Array(16),t.projMatrix,s)}function Jt(e,t,i){if(t.projection.name===i.projection.name)return e.projMatrix;const o=i.clone();return o.setProjection(t.projection),Kt(o,t.getProjection(),e)}function Qt(e,t,i){return t.name===i.projection.name?e.projMatrix:Kt(i,t,e)}class ei{constructor(e,t){this.reset(e,t);}reset(e,t){this.points=e||[],this._distances=[0];for(let e=1;e<this.points.length;e++)this._distances[e]=this._distances[e-1]+this.points[e].dist(this.points[e-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(t||0,.5*this.length),this.paddedLength=this.length-2*this.padding;}lerp(t){if(1===this.points.length)return this.points[0];t=e.aA(t,0,1);let i=1,o=this._distances[i];const s=t*this.paddedLength+this.padding;for(;o<s&&i<this._distances.length;)o=this._distances[++i];const r=i-1,n=this._distances[r],a=o-n,l=a>0?(s-n)/a:0;return this.points[r].mult(1-l).add(this.points[i].mult(l))}}class ti{constructor(e,t,i){const o=this.boxCells=[],s=this.circleCells=[];this.xCellCount=Math.ceil(e/i),this.yCellCount=Math.ceil(t/i);for(let e=0;e<this.xCellCount*this.yCellCount;e++)o.push([]),s.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=e,this.height=t,this.xScale=this.xCellCount/e,this.yScale=this.yCellCount/t,this.boxUid=0,this.circleUid=0;}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(e,t,i,o,s){this._forEachCell(t,i,o,s,this._insertBoxCell,this.boxUid++),this.boxKeys.push(e),this.bboxes.push(t),this.bboxes.push(i),this.bboxes.push(o),this.bboxes.push(s);}insertCircle(e,t,i,o){this._forEachCell(t-o,i-o,t+o,i+o,this._insertCircleCell,this.circleUid++),this.circleKeys.push(e),this.circles.push(t),this.circles.push(i),this.circles.push(o);}_insertBoxCell(e,t,i,o,s,r){this.boxCells[s].push(r);}_insertCircleCell(e,t,i,o,s,r){this.circleCells[s].push(r);}_query(e,t,i,o,s,r){if(i<0||e>this.width||o<0||t>this.height)return !s&&[];const n=[];if(e<=0&&t<=0&&this.width<=i&&this.height<=o){if(s)return !0;for(let e=0;e<this.boxKeys.length;e++)n.push({key:this.boxKeys[e],x1:this.bboxes[4*e],y1:this.bboxes[4*e+1],x2:this.bboxes[4*e+2],y2:this.bboxes[4*e+3]});for(let e=0;e<this.circleKeys.length;e++){const t=this.circles[3*e],i=this.circles[3*e+1],o=this.circles[3*e+2];n.push({key:this.circleKeys[e],x1:t-o,y1:i-o,x2:t+o,y2:i+o});}return r?n.filter(r):n}return this._forEachCell(e,t,i,o,this._queryCell,n,{hitTest:s,seenUids:{box:{},circle:{}}},r),s?n.length>0:n}_queryCircle(e,t,i,o,s){const r=e-i,n=e+i,a=t-i,l=t+i;if(n<0||r>this.width||l<0||a>this.height)return !o&&[];const c=[];return this._forEachCell(r,a,n,l,this._queryCellCircle,c,{hitTest:o,circle:{x:e,y:t,radius:i},seenUids:{box:{},circle:{}}},s),o?c.length>0:c}query(e,t,i,o,s){return this._query(e,t,i,o,!1,s)}hitTest(e,t,i,o,s){return this._query(e,t,i,o,!0,s)}hitTestCircle(e,t,i,o){return this._queryCircle(e,t,i,!0,o)}_queryCell(e,t,i,o,s,r,n,a){const l=n.seenUids,c=this.boxCells[s];if(null!==c){const s=this.bboxes;for(const h of c)if(!l.box[h]){l.box[h]=!0;const c=4*h;if(e<=s[c+2]&&t<=s[c+3]&&i>=s[c+0]&&o>=s[c+1]&&(!a||a(this.boxKeys[h]))){if(n.hitTest)return r.push(!0),!0;r.push({key:this.boxKeys[h],x1:s[c],y1:s[c+1],x2:s[c+2],y2:s[c+3]});}}}const h=this.circleCells[s];if(null!==h){const s=this.circles;for(const c of h)if(!l.circle[c]){l.circle[c]=!0;const h=3*c;if(this._circleAndRectCollide(s[h],s[h+1],s[h+2],e,t,i,o)&&(!a||a(this.circleKeys[c]))){if(n.hitTest)return r.push(!0),!0;{const e=s[h],t=s[h+1],i=s[h+2];r.push({key:this.circleKeys[c],x1:e-i,y1:t-i,x2:e+i,y2:t+i});}}}}}_queryCellCircle(e,t,i,o,s,r,n,a){const l=n.circle,c=n.seenUids,h=this.boxCells[s];if(null!==h){const e=this.bboxes;for(const t of h)if(!c.box[t]){c.box[t]=!0;const i=4*t;if(this._circleAndRectCollide(l.x,l.y,l.radius,e[i+0],e[i+1],e[i+2],e[i+3])&&(!a||a(this.boxKeys[t])))return r.push(!0),!0}}const d=this.circleCells[s];if(null!==d){const e=this.circles;for(const t of d)if(!c.circle[t]){c.circle[t]=!0;const i=3*t;if(this._circlesCollide(e[i],e[i+1],e[i+2],l.x,l.y,l.radius)&&(!a||a(this.circleKeys[t])))return r.push(!0),!0}}}_forEachCell(e,t,i,o,s,r,n,a){const l=this._convertToXCellCoord(e),c=this._convertToYCellCoord(t),h=this._convertToXCellCoord(i),d=this._convertToYCellCoord(o);for(let u=l;u<=h;u++)for(let l=c;l<=d;l++)if(s.call(this,e,t,i,o,this.xCellCount*l+u,r,n,a))return}_convertToXCellCoord(e){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(e*this.xScale)))}_convertToYCellCoord(e){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(e*this.yScale)))}_circlesCollide(e,t,i,o,s,r){const n=o-e,a=s-t,l=i+r;return l*l>n*n+a*a}_circleAndRectCollide(e,t,i,o,s,r,n){const a=(r-o)/2,l=Math.abs(e-(o+a));if(l>a+i)return !1;const c=(n-s)/2,h=Math.abs(t-(s+c));if(h>c+i)return !1;if(l<=a||h<=c)return !0;const d=l-a,u=h-c;return d*d+u*u<=i*i}}const ii={unknown:0,flipRequired:1,flipNotRequired:2},oi=Math.tan(85*Math.PI/180);function si(t,i,o,s,r,n,a){const l=e.bC();if(o)if("globe"===n.name){const t=e.bD(r,i);e.aB(l,l,t);}else {const t=e.bE([],a);l[0]=t[0],l[1]=t[1],l[4]=t[2],l[5]=t[3],s||e.bB(l,l,r.angle);}else e.aB(l,r.labelPlaneMatrix,t);return l}function ri(e,t,i,o,s,r,n){const a=si(e,t,i,o,s,r,n);return "globe"===r.name&&i||(a[2]=a[6]=a[10]=a[14]=0),a}function ni(t,i,o,s,r,n,a){if(o){if("globe"===n.name){const l=si(t,i,o,s,r,n,a);return e.bl(l,l),e.aB(l,t,l),l}{const i=e.bz(t),o=e.bA([]);return o[0]=a[0],o[1]=a[1],o[4]=a[2],o[5]=a[3],e.aB(i,i,o),s||e.bB(i,i,-r.angle),i}}return r.glCoordMatrix}function ai(t,i,o,s){const r=[t,i,o,1];o?e.aC(r,r,s):vi(r,r,s);const n=r[3];return r[0]/=n,r[1]/=n,r[2]/=n,r}function li(e,t){return Math.min(.5+e/t*.5,1.5)}function ci(e,t){const i=e[0]/e[3],o=e[1]/e[3];return i>=-t[0]&&i<=t[0]&&o>=-t[1]&&o<=t[1]}function hi(t,i,o,s,r,n,a,l,c,h,d=1){const u=o.transform,_=s?t.textSizeData:t.iconSizeData,p=e.bK(_,o.transform.zoom,d),f="globe"===u.projection.name,m=[256/o.width*2+1,256/o.height*2+1],g=s?t.text.dynamicLayoutVertexArray:t.icon.dynamicLayoutVertexArray;g.clear();let v=null;f&&(v=s?t.text.globeExtVertexArray:t.icon.globeExtVertexArray);const y=t.lineVertexArray,x=s?t.text.placedSymbolArray:t.icon.placedSymbolArray,b=o.transform.width/o.transform.height;let w,T=!1;for(let s=0;s<x.length;s++){const d=x.get(s),{numGlyphs:f,writingMode:E}=d;if(E!==e.bL.vertical||T||w===e.bL.horizontal||(T=!0),w=E,(d.hidden||E===e.bL.vertical)&&!T){gi(f,g);continue}T=!1;const S=new e.P(d.tileAnchorX,d.tileAnchorY),I="road"===t.elevationType,C=!!u.elevation||I;let{x:R,y:A,z:L}=u.projection.projectTilePoint(S.x,S.y,h.canonical),D=null;if(C){const e=I?t.getElevationFeatureForText(s):null;D={getElevation:c,elevation:u.elevation,elevationFeature:e};const[i,o,r]=c(S,u.elevation,e);R+=i,A+=o,L+=r;}const P=[R,A,L,1];if(e.aC(P,P,i),!ci(P,m)){gi(f,g);continue}const O=P[3],z=li(o.transform.getCameraToCenterDistance(u.projection),O),M=e.bM(_,p,d),F=a?M/z:M*z,B=ai(R,A,L,r);if(B[3]<=0){gi(f,g);continue}let k={};const N=e.an(t.layers[0].layout.get("text-max-angle")),U=Math.cos(N),j=a?null:D,G=_i(d,F,!1,l,i,r,n,t.glyphOffsetArray,y,g,v,B,S,k,b,j,u.projection,h,a,U);T=G.useVertical,j&&G.needsFlipping&&(k={}),(G.notEnoughRoom||T||G.needsFlipping&&_i(d,F,!0,l,i,r,n,t.glyphOffsetArray,y,g,v,B,S,k,b,j,u.projection,h,a,U).notEnoughRoom)&&gi(f,g);}s?(t.text.dynamicLayoutVertexBuffer.updateData(g),v&&t.text.globeExtVertexBuffer&&t.text.globeExtVertexBuffer.updateData(v)):(t.icon.dynamicLayoutVertexBuffer.updateData(g),v&&t.icon.globeExtVertexBuffer&&t.icon.globeExtVertexBuffer.updateData(v));}function di(e,t,i,o,s,r,n,a,l,c,h,d,u,_,p,f,m){const{lineStartIndex:g,glyphStartIndex:v,segment:y}=a,x=v+a.numGlyphs,b=g+a.lineLength,w=t.getoffsetX(v),T=t.getoffsetX(x-1),E=mi(e*w,i,o,s,r,n,y,g,b,l,c,h,d,u,!0,_,p,f,m);if(!E)return null;const S=mi(e*T,i,o,s,r,n,y,g,b,l,c,h,d,u,!0,_,p,f,m);return S?{first:E,last:S}:null}function ui(t,i,o,s){return t===e.bL.horizontal&&Math.abs(s)>Math.abs(o)?{useVertical:!0}:t===e.bL.vertical?s>0?{needsFlipping:!0}:null:i!==ii.unknown&&function(e,t){return 0===e||Math.abs(t/e)>oi}(o,s)?i===ii.flipRequired?{needsFlipping:!0}:null:o<0?{needsFlipping:!0}:null}function _i(t,i,o,s,r,n,a,l,c,h,d,u,_,p,f,m,g,v,y,x){const b=i/24,w=t.lineOffsetX*b,T=t.lineOffsetY*b,{lineStartIndex:E,glyphStartIndex:S,numGlyphs:I,segment:C,writingMode:R,flipState:A}=t,L=E+t.lineLength,D=t=>{if(d){const[i,o,s]=t.up,r=h.length;e.bN(d,r+0,i,o,s),e.bN(d,r+1,i,o,s),e.bN(d,r+2,i,o,s),e.bN(d,r+3,i,o,s);}const[i,o,s]=t.point;e.bO(h,i,o,s,t.angle);};if(I>1){const e=di(b,l,w,T,o,u,_,t,c,n,p,m,!1,g,v,y,x);if(!e)return {notEnoughRoom:!0};if(s&&!o){let[i,o,s]=e.first.point,[r,n,l]=e.last.point;[i,o]=ai(i,o,s,a),[r,n]=ai(r,n,l,a);const c=ui(R,A,(r-i)*f,n-o);if(t.flipState=c&&c.needsFlipping?ii.flipRequired:ii.flipNotRequired,c)return c}D(e.first);for(let e=S+1;e<S+I-1;e++){const t=mi(b*l.getoffsetX(e),w,T,o,u,_,C,E,L,c,n,p,m,!1,!1,g,v,y,x);if(!t)return h.length-=4*(e-S),{notEnoughRoom:!0};D(t);}D(e.last);}else {if(s&&!o){const i=ai(_.x,_.y,0,r),o=E+C+1,s=new e.P(c.getx(o),c.gety(o)),n=ai(s.x,s.y,0,r),a=n[3]>0?n:fi(_,s,i,1,r,void 0,g,v.canonical),l=ui(R,A,(a[0]-i[0])*f,a[1]-i[1]);if(t.flipState=l&&l.needsFlipping?ii.flipRequired:ii.flipNotRequired,l)return l}const i=mi(b*l.getoffsetX(S),w,T,o,u,_,C,E,L,c,n,p,m,!1,!1,g,v,y,x);if(!i)return {notEnoughRoom:!0};D(i);}return {}}function pi(e,t,i,o,s){const{x:r,y:n,z:a}=o.projectTilePoint(e.x,e.y,t);if(!s)return ai(r,n,a,i);const[l,c,h]=s.getElevation(e,s.elevation,s.elevationFeature);return ai(r+l,n+c,a+h,i)}function fi(t,i,o,s,r,n,a,l){const c=pi(t.sub(i)._unit()._add(t),l,r,a,n);return e.av(c,o,c),e.aw(c,c),e.bH(c,o,c,s)}function mi(t,i,o,s,r,n,a,l,c,h,d,u,_,p,f,m,g,v,y){const x=s?t-i:t+i;let b=x>0?1:-1,w=0;s&&(b*=-1,w=Math.PI),b<0&&(w+=Math.PI);let T=l+a+(b>0?0:1)|0,E=r,S=r,I=0,C=0;const R=Math.abs(x),A=[],L=[];let D=n,P=D,O=e.bF([]);const z=()=>fi(P,D,S,R-I+1,d,_,m,g.canonical);for(;I+C<=R;){if(T+=b,T<l||T>=c)return null;if(S=E,P=D,A.push(S),p&&L.push(P),D=new e.P(h.getx(T),h.gety(T)),E=u[T],!E){const e=pi(D,g.canonical,d,m,_);E=e[3]>0?u[T]=e:z();}I+=C;const t=e.av([],E,S),i=e.bG(S,E);if(o&&i>0&&C>0&&e.bJ(O,t)/(C*i)<y)return null;C=i,O=t;}f&&_&&(u[T]&&(E=z(),C=e.bG(S,E),O=e.av([],E,S)),u[T]=E);const M=(R-I)/C,F=D.sub(P)._mult(M)._add(P),B=e.bH([],S,O,M);let k=[0,0,1],N=O[0],U=O[1];if(v&&(k=m.upVector(g.canonical,F.x,F.y),0!==k[0]||0!==k[1]||1!==k[2])){const t=[k[2],0,-k[0]],i=e.bI([],k,t);e.aw(t,t),e.aw(i,i),N=e.bJ(O,t),U=e.bJ(O,i);}if(o){const t=e.bI([],k,O);e.aw(t,t),e.bH(B,B,t,o*b);}const j=w+Math.atan2(U,N);return A.push(B),p&&L.push(F),{point:B,angle:j,path:A,tilePath:L,up:k}}function gi(e,t){const i=t.length,o=i+4*e;t.resize(o),t.float32.fill(-1/0,4*i,4*o);}function vi(e,t,i){const o=t[0],s=t[1];return e[0]=i[0]*o+i[4]*s+i[12],e[1]=i[1]*o+i[5]*s+i[13],e[3]=i[3]*o+i[7]*s+i[15],e}const yi=100;class xi{constructor(e,t,i=new ti(e.width+200,e.height+200,25),o=new ti(e.width+200,e.height+200,25)){this.transform=e,this.grid=i,this.ignoredGrid=o,this.pitchfactor=Math.cos(e._pitch)*e.cameraToCenterDistance,this.screenRightBoundary=e.width+yi,this.screenBottomBoundary=e.height+yi,this.gridRightBoundary=e.width+200,this.gridBottomBoundary=e.height+200,this.fogState=t;}placeCollisionBox(t,i,o,s,r,n,a,l,c,h,d){let u=o.projectedAnchorX,_=o.projectedAnchorY,p=o.projectedAnchorZ;const f=o.tileAnchorX,m=o.tileAnchorY,g=o.elevation,v=o.tileID,y=t.getProjection();if(g&&v){const[e,t,i]=y.upVector(v.canonical,o.tileAnchorX,o.tileAnchorY),s=y.upVectorScale(v.canonical,this.transform.center.lat,this.transform.worldSize).metersToTile;u+=e*g*s,_+=t*g*s,p+=i*g*s;}const x="globe"===t.projection.name,b="globe"===t.projection.name?e.aj(this.transform.zoom):0;if(v&&x&&b<1&&!n){const t=1<<v.canonical.z,i=e.bP(f,m);e.bQ(i,i,1/e.al),e.bR(i,i,e.bP(v.canonical.x,v.canonical.y)),e.bQ(i,i,1/t),e.bS(i,i,e.bP(s[0],s[1])),i[0]=e.bT(i[0],-.5,.5),e.bQ(i,i,e.al);const o=e.bU(i[0],i[1],e.al/(2*Math.PI),1);e.aC(o,o,r),u=e.ak(u,o[0],b),_=e.ak(_,o[1],b),p=e.ak(p,o[2],b);}const w=this.projectAndGetPerspectiveRatio(h,u,_,p,o.tileID,"globe"===y.name||!!g||this.transform.pitch>0,y),T=c*w.perspectiveRatio,E=(o.x1*i+a.x-o.padding)*T+w.point.x,S=(o.y1*i+a.y-o.padding)*T+w.point.y,I=(o.x2*i+a.x+o.padding)*T+w.point.x,C=(o.y2*i+a.y+o.padding)*T+w.point.y,R=w.perspectiveRatio<=.55||w.occluded;return !this.isInsideGrid(E,S,I,C)||!l&&this.grid.hitTest(E,S,I,C,d)||R?{box:[],offscreen:!1,occluded:w.occluded}:{box:[E,S,I,C],offscreen:this.isOffscreen(E,S,I,C),occluded:!1}}placeCollisionCircles(t,i,o,s,r,n,a,l,c,h,d,u,_,p,f,m){const g=[],v=this.transform.elevation,y=t.getProjection(),x="road"===t.elevationType,b=!!v||x,w=e.bV.getAtTileOffsetFunc(m,this.transform.center.lat,this.transform.worldSize,y),T=new e.P(o.tileAnchorX,o.tileAnchorY),E=new e.P(o.tileAnchorX,o.tileAnchorY);let{x:S,y:I,z:C}=y.projectTilePoint(E.x,E.y,m.canonical),R=null;if(b){const e=x?t.getElevationFeatureForText(s):null;R={getElevation:w,elevation:v,elevationFeature:e};const[i,o,r]=w(T,v,e);S+=i,I+=o,C+=r;}const A="globe"===y.name,L=this.projectAndGetPerspectiveRatio(l,S,I,C,m,A||!!v||this.transform.pitch>0,y),{perspectiveRatio:D}=L,P=(u?a/D:a*D)/e.bY,O=ai(S,I,C,c),z=o.lineOffsetX*P,M=o.lineOffsetY*P,F=e.an(t.layers[0].layout.get("text-max-angle")),B=Math.cos(F),k=L.signedDistanceFromCamera>0?di(P,n,z,M,x&&1===o.flipState,O,E,o,r,c,{},b&&!u?R:null,u&&b,y,m,u,B):null;let N=!1,U=!1,j=!0;if(k&&!L.occluded){const t=.5*p*D+f,o=new e.P(-100,-100),s=new e.P(this.screenRightBoundary,this.screenBottomBoundary),r=new ei,{first:n,last:a}=k,l=n.path.length;let c=[];for(let e=l-1;e>=1;e--)c.push(n.path[e]);for(let e=1;e<a.path.length;e++)c.push(a.path[e]);const u=2.5*t;h&&(c=c.map((([e,t,i],o)=>(b&&!A&&(i=w(o<l-1?n.tilePath[l-1-o]:a.tilePath[o-l+2],v,R.elevationFeature)[2]),ai(e,t,i,h)))),c.some((e=>e[3]<=0))&&(c=[]));let m=[];if(c.length>0){let t=1/0,i=-1/0,r=1/0,n=-1/0;for(const e of c)t=Math.min(t,e[0]),r=Math.min(r,e[1]),i=Math.max(i,e[0]),n=Math.max(n,e[1]);i>=o.x&&t<=s.x&&n>=o.y&&r<=s.y&&(m=[c.map((t=>new e.P(t[0],t[1])))],(t<o.x||i>s.x||r<o.y||n>s.y)&&(m=e.bW(m,o.x,o.y,s.x,s.y)));}for(const e of m){r.reset(e,.25*t);let o=0;o=r.length<=.5*t?1:Math.ceil(r.paddedLength/u)+1;for(let e=0;e<o;e++){const s=e/Math.max(o-1,1),n=r.lerp(s),a=n.x+yi,l=n.y+yi;g.push(a,l,t,0);const c=a-t,h=l-t,u=a+t,p=l+t;if(j=j&&this.isOffscreen(c,h,u,p),U=U||this.isInsideGrid(c,h,u,p),!i&&this.grid.hitTestCircle(a,l,t,_)&&(N=!0,!d))return {circles:[],offscreen:!1,collisionDetected:N,occluded:!1}}}}return {circles:!d&&N||!U?[]:g,offscreen:j,collisionDetected:N,occluded:L.occluded}}queryRenderedSymbols(t){if(0===t.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return {};const i=[];let o=1/0,s=1/0,r=-1/0,n=-1/0;for(const a of t){const t=new e.P(a.x+yi,a.y+yi);o=Math.min(o,t.x),s=Math.min(s,t.y),r=Math.max(r,t.x),n=Math.max(n,t.y),i.push(t);}const a=this.grid.query(o,s,r,n).concat(this.ignoredGrid.query(o,s,r,n)),l={},c={};for(const t of a){const o=t.key;if(void 0===l[o.bucketInstanceId]&&(l[o.bucketInstanceId]={}),l[o.bucketInstanceId][o.featureIndex])continue;const s=[new e.P(t.x1,t.y1),new e.P(t.x2,t.y1),new e.P(t.x2,t.y2),new e.P(t.x1,t.y2)];e.bX(i,s)&&(l[o.bucketInstanceId][o.featureIndex]=!0,void 0===c[o.bucketInstanceId]&&(c[o.bucketInstanceId]=[]),c[o.bucketInstanceId].push(o.featureIndex));}return c}insertCollisionBox(e,t,i,o,s){(t?this.ignoredGrid:this.grid).insert({bucketInstanceId:i,featureIndex:o,collisionGroupID:s},e[0],e[1],e[2],e[3]);}insertCollisionCircles(e,t,i,o,s){const r=t?this.ignoredGrid:this.grid,n={bucketInstanceId:i,featureIndex:o,collisionGroupID:s};for(let t=0;t<e.length;t+=4)r.insertCircle(n,e[t],e[t+1],e[t+2]);}projectAndGetPerspectiveRatio(t,i,o,s,r,n,a){const l=[i,o,s,1];let c=!1;if(s||this.transform.pitch>0){if(e.aC(l,l,t),this.fogState&&r&&"globe"!==a.name){const t=function(t,i,o,s,r,n){const a=n.calculateFogTileMatrix(r),l=[i,o,s];return e.af(l,l,a),qe(t,e.ag(l),n.pitch,n._fov)}(this.fogState,i,o,s,r.toUnwrapped(),this.transform);c=t>.9;}}else vi(l,l,t);const h=l[3];return {point:new e.P((l[0]/h+1)/2*this.transform.width+yi,(-l[1]/h+1)/2*this.transform.height+yi),perspectiveRatio:Math.min(.5+this.transform.getCameraToCenterDistance(a)/h*.5,1.5),signedDistanceFromCamera:h,occluded:n&&l[2]>h||c}}isOffscreen(e,t,i,o){return i<yi||e>=this.screenRightBoundary||o<yi||t>this.screenBottomBoundary}isInsideGrid(e,t,i,o){return i>=0&&e<this.gridRightBoundary&&o>=0&&t<this.gridBottomBoundary}getViewportMatrix(){const t=e.bA([]);return e.br(t,t,[-100,-100,0]),t}}class bi{constructor(e,t,i,o){this.opacity=e?Math.max(0,Math.min(1,e.opacity+(e.placed?t:-t))):o&&i?1:0,this.placed=i;}isHidden(){return 0===this.opacity&&!this.placed}}class wi{constructor(e,t,i,o,s,r=!1){this.text=new bi(e?e.text:null,t,i,s),this.icon=new bi(e?e.icon:null,t,o,s),this.clipped=r;}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class Ti{constructor(e,t,i,o=!1){this.text=e,this.icon=t,this.skipFade=i,this.clipped=o;}}class Ei{constructor(){this.invProjMatrix=e.bC(),this.viewportMatrix=e.bC(),this.circles=[];}}class Si{constructor(e,t,i,o,s){this.bucketInstanceId=e,this.featureIndex=t,this.sourceLayerIndex=i,this.bucketIndex=o,this.tileID=s;}}class Ii{constructor(e){this.crossSourceCollisions=e,this.maxGroupID=0,this.collisionGroups={};}get(e){if(this.crossSourceCollisions)return {ID:0,predicate:null};if(!this.collisionGroups[e]){const t=++this.maxGroupID;this.collisionGroups[e]={ID:t,predicate:e=>e.collisionGroupID===t};}return this.collisionGroups[e]}}function Ci(t,i,o,s,r){const{horizontalAlign:n,verticalAlign:a}=e.c1(t),l=-(n-.5)*i,c=-(a-.5)*o,h=e.c2(t,s);return new e.P(l+h[0]*r,c+h[1]*r)}function Ri(t,i,o,s,r){const n=new e.P(t,i);return o&&n._rotate(s?r:-r),n}class Ai{constructor(e,t,i,o,s,r){this.transform=e.clone(),this.projection=e.projection.name,this.collisionIndex=new xi(this.transform,s),this.buildingIndex=r,this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=t,this.retainedQueryData={},this.collisionGroups=new Ii(i),this.collisionCircleArrays={},this.prevPlacement=o,o&&(o.prevPlacement=void 0),this.placedOrientations={},this.lastReplacementSourceUpdateTime=0;}getBucketParts(t,i,o,s,r=1){const n=o.getBucket(i),a=o.latestFeatureIndex;if(!n||!a||i.fqid!==n.layerIds[0])return;const l=n.layers[0].layout,c=n.layers[0].paint,h=o.collisionBoxArray,d=Math.pow(2,this.transform.zoom-o.tileID.overscaledZ),u=o.tileSize/e.al,_=o.tileID.toUnwrapped();this.transform.setProjection(n.projection);const p=(f=o.tileID,m=n.getProjection(),g=this.transform,m.name===this.projection?g.calculateProjMatrix(f.toUnwrapped()):Kt(g,m,f));var f,m,g;const v="map"===l.get("text-pitch-alignment"),y="map"===l.get("text-rotation-alignment");i.compileFilter(i.options);const x=i.dynamicFilter(),b=i.dynamicFilterNeedsFeature(),w=this.transform.calculatePixelsToTileUnitsMatrix(o),T=ri(p,o.tileID.canonical,v,y,this.transform,n.getProjection(),w);let E=null;const S=n.getProjection().createInversionMatrix(this.transform,o.tileID.canonical);if(v){const t=ni(p,o.tileID.canonical,v,y,this.transform,n.getProjection(),w);E=e.aB([],this.transform.labelPlaneMatrix,t);}let I=null;x&&o.latestFeatureIndex&&(I={unwrappedTileID:_,dynamicFilter:x,dynamicFilterNeedsFeature:b}),this.retainedQueryData[n.bucketInstanceId]=new Si(n.bucketInstanceId,a,n.sourceLayerIndex,n.index,o.tileID);const[C,R]=n.layers[0].layout.get("text-size-scale-range"),A=e.aA(r,C,R),[L,D]=l.get("icon-size-scale-range"),P=e.aA(r,L,D),O={bucket:n,layout:l,paint:c,posMatrix:p,invMatrix:S,mercatorCenter:[e.aF(this.transform.center.lng),e.aJ(this.transform.center.lat)],textLabelPlaneMatrix:T,labelToScreenMatrix:E,clippingData:I,scale:d,textPixelRatio:u,holdingForFade:o.holdingForFade(),collisionBoxArray:h,partiallyEvaluatedTextSize:e.bK(n.textSizeData,this.transform.zoom,A),partiallyEvaluatedIconSize:e.bK(n.iconSizeData,this.transform.zoom,P),collisionGroup:this.collisionGroups.get(n.sourceID),latestFeatureIndex:o.latestFeatureIndex};if(s)for(const e of n.sortKeyRanges){const{sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:s}=e;t.push({sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:s,parameters:O});}else t.push({symbolInstanceStart:0,symbolInstanceEnd:n.symbolInstances.length,parameters:O});}attemptAnchorPlacement(e,t,i,o,s,r,n,a,l,c,h,d,u,_,p,f,m,g,v,y,x){const{textOffset0:b,textOffset1:w,crossTileID:T}=p,E=[b,w],S=Ci(e,r,n,E,a),I=this.collisionIndex.placeCollisionBox(m,a,t,i,o,s,Ri(S.x,S.y,l,c,this.transform.angle),_,h,d,u.predicate);if(v){const e=m.getSymbolInstanceIconSize(x,this.transform.zoom,p.placedIconSymbolIndex);if(0===this.collisionIndex.placeCollisionBox(m,e,v,i,o,s,Ri(S.x,S.y,l,c,this.transform.angle),_,h,d,u.predicate).box.length)return}if(I.box.length>0){let t;return this.prevPlacement&&this.prevPlacement.variableOffsets[T]&&this.prevPlacement.placements[T]&&this.prevPlacement.placements[T].text&&(t=this.prevPlacement.variableOffsets[T].anchor),this.variableOffsets[T]={textOffset:E,width:r,height:n,anchor:e,textScale:a,prevAnchor:t},this.markUsedJustification(m,e,p,g),m.allowVerticalPlacement&&(this.markUsedOrientation(m,g,p),this.placedOrientations[T]=g),{shift:S,placedGlyphBoxes:I}}}placeLayerBucketPart(t,i,o,s,r=1){const{bucket:n,layout:a,paint:l,posMatrix:c,textLabelPlaneMatrix:h,labelToScreenMatrix:d,clippingData:u,textPixelRatio:_,mercatorCenter:p,invMatrix:f,holdingForFade:m,collisionBoxArray:g,partiallyEvaluatedTextSize:v,partiallyEvaluatedIconSize:y,collisionGroup:x,latestFeatureIndex:b}=t.parameters,w=a.get("text-optional"),T=a.get("icon-optional"),E=a.get("text-allow-overlap"),S=a.get("icon-allow-overlap"),I="map"===a.get("text-rotation-alignment"),C="map"===a.get("icon-rotation-alignment"),R="map"===a.get("text-pitch-alignment"),A=l.get("symbol-z-offset"),L="sea"===a.get("symbol-elevation-reference"),D=a.get("symbol-placement"),[P,O]=a.get("text-size-scale-range"),[z,M]=a.get("icon-size-scale-range"),F=e.aA(r,P,O),B=e.aA(r,z,M),k=a.get("text-variable-anchor"),N=I&&"point"!==D,U=C&&"point"!==D,j=k&&n.hasTextData(),G=n.hasIconTextFit()&&j&&n.hasIconData();this.transform.setProjection(n.projection);const V=j||N,H=U||G;let q=E&&(S||!n.hasIconData()||T),Z=S&&(E||!n.hasTextData()||w);const W=!A.isConstant();!n.collisionArrays&&g&&n.deserializeCollisionBoxes(g),o&&s&&n.updateCollisionDebugBuffers(this.transform.zoom,g,F,B);const $=(t,s,r)=>{const{crossTileID:l,numVerticalGlyphVertices:g}=t;let C=null;if(u&&u.dynamicFilterNeedsFeature||W){const e=this.retainedQueryData[n.bucketInstanceId];C=b.loadFeature({featureIndex:t.featureIndex,bucketIndex:e.bucketIndex,sourceLayerIndex:e.sourceLayerIndex,layoutVertexArrayOffset:0});const i=C.properties?C.properties.worldview:null;if(n.localizable&&n.worldview&&"string"==typeof i)if("all"===i)C.properties.$localized=!0;else {if(!i.split(",").includes(n.worldview))return;C.properties.$localized=!0,C.properties.worldview=n.worldview;}}if(u&&!(0,u.dynamicFilter)({zoom:this.transform.zoom,pitch:this.transform.pitch,worldview:n.worldview},C,this.retainedQueryData[n.bucketInstanceId].tileID.canonical,new e.P(t.tileAnchorX,t.tileAnchorY),this.transform.calculateDistanceTileData(u.unwrappedTileID)))return this.placements[l]=new Ti(!1,!1,!1,!0),void i.add(l);const D=A.evaluate(C,{});if(i.has(l))return;if(m)return void(this.placements[l]=new Ti(!1,!1,!1));let P=!1,O=!1,z=!0,M=!1,F=!1,B=null,N={box:null,offscreen:null,occluded:null},U={box:null},j=null,G=null,$=null,X=0,Y=0,K=0;r.textFeatureIndex?X=r.textFeatureIndex:t.useRuntimeCollisionCircles&&(X=t.featureIndex),r.verticalTextFeatureIndex&&(Y=r.verticalTextFeatureIndex);const J=n.elevationFeatures?n.elevationFeatures[t.elevationFeatureIndex]:void 0,Q=i=>{i.tileID=this.retainedQueryData[n.bucketInstanceId].tileID;const o=this.transform.elevation;i.elevation=L?D:D+e.bV.getAtTileOffset(i.tileID,new e.P(i.tileAnchorX,i.tileAnchorY),o,J),i.elevation+=t.zOffset;},ee=r.textBox;if(ee){Q(ee);const i=i=>{let o=e.bL.horizontal;if(n.allowVerticalPlacement&&!i&&this.prevPlacement){const e=this.prevPlacement.placedOrientations[l];e&&(this.placedOrientations[l]=e,o=e,this.markUsedOrientation(n,o,t));}return o},o=(t,i)=>{if(n.allowVerticalPlacement&&g>0&&r.verticalTextBox){for(const o of n.writingModes)if(o===e.bL.vertical?(N=i(),U=N):N=t(),N&&N.box&&N.box.length)break}else N=t();};if(k){let a=k;if(this.prevPlacement&&this.prevPlacement.variableOffsets[l]){const e=this.prevPlacement.variableOffsets[l];a.indexOf(e.anchor)>0&&(a=a.filter((t=>t!==e.anchor)),a.unshift(e.anchor));}const h=(e,i,o)=>{const r=n.getSymbolInstanceTextSize(v,t,this.transform.zoom,s),l=(e.x2-e.x1)*r+2*e.padding,h=(e.y2-e.y1)*r+2*e.padding,d=t.hasIconTextFit&&!S?i:null;d&&Q(d);let u={box:[],offscreen:!1,occluded:!1};const m=E?2*a.length:a.length;for(let i=0;i<m;++i){const m=this.attemptAnchorPlacement(a[i%a.length],e,p,f,V,l,h,r,I,R,_,c,x,i>=a.length,t,s,n,o,d,v,y);if(m&&(u=m.placedGlyphBoxes,u&&u.box&&u.box.length)){P=!0,B=m.shift;break}}return u};o((()=>h(ee,r.iconBox,e.bL.horizontal)),(()=>{const t=r.verticalTextBox;return t&&Q(t),n.allowVerticalPlacement&&!(N&&N.box&&N.box.length)&&g>0&&t?h(t,r.verticalIconBox,e.bL.vertical):{box:null,offscreen:null,occluded:null}})),N&&(P=N.box,z=N.offscreen,M=N.occluded);const d=i(!(!N||!N.box));if(!P&&this.prevPlacement){const e=this.prevPlacement.variableOffsets[l];e&&(this.variableOffsets[l]=e,this.markUsedJustification(n,e.anchor,t,d));}}else {const a=(i,o)=>{const r=n.getSymbolInstanceTextSize(v,t,this.transform.zoom,s),a=this.collisionIndex.placeCollisionBox(n,r,i,p,f,V,new e.P(0,0),E,_,c,x.predicate);return a&&a.box&&a.box.length&&(this.markUsedOrientation(n,o,t),this.placedOrientations[l]=o),a};o((()=>a(ee,e.bL.horizontal)),(()=>{const t=r.verticalTextBox;return n.allowVerticalPlacement&&g>0&&t?(Q(t),a(t,e.bL.vertical)):{box:null,offscreen:null,occluded:null}})),i(!!(N&&N.box&&N.box.length));}}if(j=N,P=j&&j.box&&j.box.length>0,z=j&&j.offscreen,M=j&&j.occluded,t.useRuntimeCollisionCircles){const i=t.centerJustifiedTextSymbolIndex>=0?t.centerJustifiedTextSymbolIndex:t.verticalPlacedTextSymbolIndex,s=n.text.placedSymbolArray.get(i),r=e.bM(n.textSizeData,v,s),l=a.get("text-padding");G=this.collisionIndex.placeCollisionCircles(n,E,s,i,n.lineVertexArray,n.glyphOffsetArray,r,c,h,d,o,R,x.predicate,t.collisionCircleDiameter*r/e.bY,l,this.retainedQueryData[n.bucketInstanceId].tileID),P=E||G.circles.length>0&&!G.collisionDetected,z=z&&G.offscreen,M=G.occluded;}if(r.iconFeatureIndex&&(K=r.iconFeatureIndex),r.iconBox){const i=i=>{Q(i);const o=t.hasIconTextFit&&B?Ri(B.x,B.y,I,R,this.transform.angle):new e.P(0,0),s=n.getSymbolInstanceIconSize(y,this.transform.zoom,t.placedIconSymbolIndex);return this.collisionIndex.placeCollisionBox(n,s,i,p,f,H,o,S,_,c,x.predicate)};U&&U.box&&U.box.length&&r.verticalIconBox?($=i(r.verticalIconBox),O=$.box.length>0):($=i(r.iconBox),O=$.box.length>0),z=z&&$.offscreen,F=$.occluded;}const te=w||0===t.numHorizontalGlyphVertices&&0===g,ie=T||0===t.numIconVertices;if(te||ie?ie?te||(O=O&&P):P=O&&P:O=P=O&&P,P&&j&&j.box&&this.collisionIndex.insertCollisionBox(j.box,a.get("text-ignore-placement"),n.bucketInstanceId,U&&U.box&&Y?Y:X,x.ID),O&&$&&this.collisionIndex.insertCollisionBox($.box,a.get("icon-ignore-placement"),n.bucketInstanceId,K,x.ID),G&&(P&&this.collisionIndex.insertCollisionCircles(G.circles,a.get("text-ignore-placement"),n.bucketInstanceId,X,x.ID),o)){const e=n.bucketInstanceId;let t=this.collisionCircleArrays[e];void 0===t&&(t=this.collisionCircleArrays[e]=new Ei);for(let e=0;e<G.circles.length;e+=4)t.circles.push(G.circles[e+0]),t.circles.push(G.circles[e+1]),t.circles.push(G.circles[e+2]),t.circles.push(G.collisionDetected?1:0);}const oe="globe"!==n.projection.name;q=q&&(oe||!M),Z=Z&&(oe||!F),this.placements[l]=new Ti(P||q,O||Z,z||n.justReloaded),i.add(l);},X=this.retainedQueryData[n.bucketInstanceId].tileID;if("offset"===n.elevationType&&this.buildingIndex&&this.buildingIndex.updateZOffset(n,X),"road"===n.elevationType&&n.updateRoadElevation(X.canonical),n.updateZOffset(),n.sortFeaturesByY){const t=n.getSortedSymbolIndexes(this.transform.angle);for(let e=t.length-1;e>=0;--e){const i=t[e];$(n.symbolInstances.get(i),i,n.collisionArrays[i]);}n.hasAnyZOffset&&e.w(`${n.layerIds[0]} layer symbol-z-elevate: symbols are not sorted by elevation if symbol-z-order is evaluated to viewport-y`);}else if(n.hasAnyZOffset){const e=n.getSortedIndexesByZOffset();for(let t=0;t<e.length;++t){const i=e[t];$(n.symbolInstances.get(i),i,n.collisionArrays[i]);}}else for(let e=t.symbolInstanceStart;e<t.symbolInstanceEnd;e++)$(n.symbolInstances.get(e),e,n.collisionArrays[e]);if(o&&n.bucketInstanceId in this.collisionCircleArrays){const t=this.collisionCircleArrays[n.bucketInstanceId];e.bl(t.invProjMatrix,c),t.viewportMatrix=this.collisionIndex.getViewportMatrix();}n.justReloaded=!1;}markUsedJustification(t,i,o,s){const{leftJustifiedTextSymbolIndex:r,centerJustifiedTextSymbolIndex:n,rightJustifiedTextSymbolIndex:a,verticalPlacedTextSymbolIndex:l,crossTileID:c}=o,h=e.c3(i),d=s===e.bL.vertical?l:"left"===h?r:"center"===h?n:"right"===h?a:-1;r>=0&&(t.text.placedSymbolArray.get(r).crossTileID=d>=0&&r!==d?0:c),n>=0&&(t.text.placedSymbolArray.get(n).crossTileID=d>=0&&n!==d?0:c),a>=0&&(t.text.placedSymbolArray.get(a).crossTileID=d>=0&&a!==d?0:c),l>=0&&(t.text.placedSymbolArray.get(l).crossTileID=d>=0&&l!==d?0:c);}markUsedOrientation(t,i,o){const s=i===e.bL.horizontal||i===e.bL.horizontalOnly?i:0,r=i===e.bL.vertical?i:0,{leftJustifiedTextSymbolIndex:n,centerJustifiedTextSymbolIndex:a,rightJustifiedTextSymbolIndex:l,verticalPlacedTextSymbolIndex:c}=o,h=t.text.placedSymbolArray;n>=0&&(h.get(n).placedOrientation=s),a>=0&&(h.get(a).placedOrientation=s),l>=0&&(h.get(l).placedOrientation=s),c>=0&&(h.get(c).placedOrientation=r);}commit(e){this.commitTime=e,this.zoomAtLastRecencyCheck=this.transform.zoom;const t=this.prevPlacement;let i=!1;this.prevZoomAdjustment=t?t.zoomAdjustment(this.transform.zoom):0;const o=t?t.symbolFadeChange(e):1,s=t?t.opacities:{},r=t?t.variableOffsets:{},n=t?t.placedOrientations:{};for(const e in this.placements){const t=this.placements[e],r=s[e];r?(this.opacities[e]=new wi(r,o,t.text,t.icon,null,t.clipped),i=i||t.text!==r.text.placed||t.icon!==r.icon.placed):(this.opacities[e]=new wi(null,o,t.text,t.icon,t.skipFade,t.clipped),i=i||t.text||t.icon);}for(const e in s){const t=s[e];if(!this.opacities[e]){const s=new wi(t,o,!1,!1);s.isHidden()||(this.opacities[e]=s,i=i||t.text.placed||t.icon.placed);}}for(const e in r)this.variableOffsets[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.variableOffsets[e]=r[e]);for(const e in n)this.placedOrientations[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.placedOrientations[e]=n[e]);i?this.lastPlacementChangeTime=e:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=t?t.lastPlacementChangeTime:e);}updateLayerOpacities(e,t,i,o){o&&(this.lastReplacementSourceUpdateTime=o.updateTime);const s=new Set;for(const r of t){const t=r.getBucket(e);t&&r.latestFeatureIndex&&e.fqid===t.layerIds[0]&&(this.updateBucketOpacities(t,s,r,r.collisionBoxArray,i,o,r.tileID,e.scope),"offset"===t.elevationType&&this.buildingIndex&&this.buildingIndex.updateZOffset(t,r.tileID),"road"===t.elevationType&&t.updateRoadElevation(r.tileID.canonical),t.updateZOffset());}}updateBucketOpacities(t,i,o,s,r,n,a,l){t.hasTextData()&&t.text.opacityVertexArray.clear(),t.hasIconData()&&t.icon.opacityVertexArray.clear(),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexArray.clear(),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexArray.clear();const c=t.layers[0].layout,h=t.layers[0].paint,d=!!t.layers[0].dynamicFilter(),u=new wi(null,0,!1,!1,!0),_=c.get("text-allow-overlap"),p=c.get("icon-allow-overlap"),f=c.get("text-variable-anchor"),m="map"===c.get("text-rotation-alignment"),g="map"===c.get("text-pitch-alignment"),v=h.get("symbol-z-offset"),y="sea"===c.get("symbol-elevation-reference"),x=!v.isConstant(),b=new wi(null,0,_&&(p||!t.hasIconData()||c.get("icon-optional")),p&&(_||!t.hasTextData()||c.get("text-optional")),!0);!t.collisionArrays&&s&&(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData())&&t.deserializeCollisionBoxes(s);const w=(e,t,i)=>{for(let o=0;o<t/4;o++)e.opacityVertexArray.emplaceBack(i);};let T=0;n&&t.updateReplacement(a,n);for(let s=0;s<t.symbolInstances.length;s++){const c=t.symbolInstances.get(s),{numHorizontalGlyphVertices:h,numVerticalGlyphVertices:_,crossTileID:p,numIconVertices:E,tileAnchorX:S,tileAnchorY:I}=c;let C=null;const R=this.retainedQueryData[t.bucketInstanceId];x&&c&&R&&(C=o.latestFeatureIndex.loadFeature({featureIndex:c.featureIndex,bucketIndex:R.bucketIndex,sourceLayerIndex:R.sourceLayerIndex,layoutVertexArrayOffset:0}));const A=v.evaluate(C,{}),L=i.has(p);let D=this.opacities[p];L?D=u:D||(D=b,this.opacities[p]=D),i.add(p);const P=h>0||_>0,O=E>0,z=this.placedOrientations[p],M=z===e.bL.vertical,F=z===e.bL.horizontal||z===e.bL.horizontalOnly;!P&&!O||D.isHidden()||T++;let B=!1;if((P||O)&&n)for(const i of t.activeReplacements){if(e.bZ(i,r,e.b_.Symbol,l))continue;if(i.min.x>S||S>i.max.x||i.min.y>I||I>i.max.y)continue;const t=e.b$(S,I,a.canonical,i.footprintTileId.canonical);if(B=e.c0(t,i.footprint),B)break}if(P){const e=B?Ni:ki(D.text);w(t.text,h,M?Ni:e),w(t.text,_,F?Ni:e);const i=D.text.isHidden(),{leftJustifiedTextSymbolIndex:o,centerJustifiedTextSymbolIndex:s,rightJustifiedTextSymbolIndex:r,verticalPlacedTextSymbolIndex:n}=c,a=t.text.placedSymbolArray,l=i||M?1:0;o>=0&&(a.get(o).hidden=l),s>=0&&(a.get(s).hidden=l),r>=0&&(a.get(r).hidden=l),n>=0&&(a.get(n).hidden=i||F?1:0);const d=this.variableOffsets[p];d&&this.markUsedJustification(t,d.anchor,c,z);const u=this.placedOrientations[p];u&&(this.markUsedJustification(t,"left",c,u),this.markUsedOrientation(t,u,c));}if(O){const e=B?Ni:ki(D.icon),{placedIconSymbolIndex:i,verticalPlacedIconSymbolIndex:o}=c,s=t.icon.placedSymbolArray,r=D.icon.isHidden()?1:0;i>=0&&(w(t.icon,E,M?Ni:e),s.get(i).hidden=r),o>=0&&(w(t.icon,c.numVerticalIconVertices,F?Ni:e),s.get(o).hidden=r);}if(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData()){const i=t.collisionArrays[s];if(i){let o=new e.P(0,0),s=!0;if(i.textBox||i.verticalTextBox){if(f){const e=this.variableOffsets[p];e?(o=Ci(e.anchor,e.width,e.height,e.textOffset,e.textScale),m&&o._rotate(g?this.transform.angle:-this.transform.angle)):s=!1;}d&&(s=!D.clipped),i.textBox&&Li(t.textCollisionBox.collisionVertexArray,D.text.placed,!s||M,A,y,o.x,o.y),i.verticalTextBox&&Li(t.textCollisionBox.collisionVertexArray,D.text.placed,!s||F,A,y,o.x,o.y);}const r=s&&Boolean(!F&&i.verticalIconBox);i.iconBox&&Li(t.iconCollisionBox.collisionVertexArray,D.icon.placed,r,A,y,c.hasIconTextFit?o.x:0,c.hasIconTextFit?o.y:0),i.verticalIconBox&&Li(t.iconCollisionBox.collisionVertexArray,D.icon.placed,!r,A,y,c.hasIconTextFit?o.x:0,c.hasIconTextFit?o.y:0);}}}if(t.fullyClipped=0===T,t.sortFeatures(this.transform.angle),this.retainedQueryData[t.bucketInstanceId]&&(this.retainedQueryData[t.bucketInstanceId].featureSortOrder=t.featureSortOrder),t.hasTextData()&&t.text.opacityVertexBuffer&&t.text.opacityVertexBuffer.updateData(t.text.opacityVertexArray),t.hasIconData()&&t.icon.opacityVertexBuffer&&t.icon.opacityVertexBuffer.updateData(t.icon.opacityVertexArray),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexBuffer&&t.iconCollisionBox.collisionVertexBuffer.updateData(t.iconCollisionBox.collisionVertexArray),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexBuffer&&t.textCollisionBox.collisionVertexBuffer.updateData(t.textCollisionBox.collisionVertexArray),t.bucketInstanceId in this.collisionCircleArrays){const e=this.collisionCircleArrays[t.bucketInstanceId];t.placementInvProjMatrix=e.invProjMatrix,t.placementViewportMatrix=e.viewportMatrix,t.collisionCircleArray=e.circles,delete this.collisionCircleArrays[t.bucketInstanceId];}}symbolFadeChange(e){return 0===this.fadeDuration?1:(e-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(e){return Math.max(0,(this.transform.zoom-e)/1.5)}hasTransitions(e){return this.stale||e-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(e,t){const i=this.zoomAtLastRecencyCheck===t?1-this.zoomAdjustment(t):1;return this.zoomAtLastRecencyCheck=t,this.commitTime+this.fadeDuration*i>e}isStale(){return this.stale}setStale(){this.stale=!0;}}function Li(e,t,i,o,s,r,n){e.emplaceBack(t?1:0,i?1:0,r||0,n||0,o,s?1:0),e.emplaceBack(t?1:0,i?1:0,r||0,n||0,o,s?1:0),e.emplaceBack(t?1:0,i?1:0,r||0,n||0,o,s?1:0),e.emplaceBack(t?1:0,i?1:0,r||0,n||0,o,s?1:0);}const Di=Math.pow(2,25),Pi=Math.pow(2,24),Oi=Math.pow(2,17),zi=Math.pow(2,16),Mi=Math.pow(2,9),Fi=Math.pow(2,8),Bi=Math.pow(2,1);function ki(e){if(0===e.opacity&&!e.placed)return 0;if(1===e.opacity&&e.placed)return 4294967295;const t=e.placed?1:0,i=Math.floor(127*e.opacity);return i*Di+t*Pi+i*Oi+t*zi+i*Mi+t*Fi+i*Bi+t}const Ni=0;class Ui{constructor(e){this._sortAcrossTiles="viewport-y"!==e.layout.get("symbol-z-order")&&void 0!==e.layout.get("symbol-sort-key").constantOr(1),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs=new Set,this._bucketParts=[];}continuePlacement(e,t,i,o,s,r){const n=this._bucketParts;for(;this._currentTileIndex<e.length;)if(t.getBucketParts(n,o,e[this._currentTileIndex],this._sortAcrossTiles,r),this._currentTileIndex++,s())return !0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,n.sort(((e,t)=>e.sortKey-t.sortKey)));this._currentPartIndex<n.length;){const e=n[this._currentPartIndex];if(t.placeLayerBucketPart(e,this._seenCrossTileIDs,i,0===e.symbolInstanceStart,r),this._currentPartIndex++,s())return !0}return !1}}class ji{constructor(e,t,i,o,s,r,n,a,l){this.placement=new Ai(e,s,r,n,a,l),this._currentPlacementIndex=t.length-1,this._forceFullPlacement=i,this._showCollisionBoxes=o,this._done=!1;}isDone(){return this._done}continuePlacement(t,i,o,s,r){const n=e.o.now(),a=()=>{const t=e.o.now()-n;return !this._forceFullPlacement&&t>2};for(;this._currentPlacementIndex>=0;){const n=i[t[this._currentPlacementIndex]],l=this.placement.collisionIndex.transform.zoom;if("symbol"===n.type&&"none"!==n.visibility&&(!n.minzoom||n.minzoom<=l)&&(!n.maxzoom||n.maxzoom>l)){const t=n,i=t.layout.get("symbol-z-elevate"),l=void 0!==t.layout.get("symbol-sort-key").constantOr(1),c=t.layout.get("symbol-z-order"),h="viewport-y"===c||"auto"===c&&!("viewport-y"!==c&&l),d=t.layout.get("text-allow-overlap")||t.layout.get("icon-allow-overlap")||t.layout.get("text-ignore-placement")||t.layout.get("icon-ignore-placement"),u=h&&d,_=this._inProgressLayer=this._inProgressLayer||new Ui(t),p=e.B(n.source,n.scope);if(_.continuePlacement(i||u?s[p]:o[p],this.placement,this._showCollisionBoxes,n,a,r))return;delete this._inProgressLayer;}this._currentPlacementIndex--;}this._done=!0;}commit(e){return this.placement.commit(e),this.placement}}const Gi=512/e.al/2;class Vi{constructor(t,i,o){this.tileID=t,this.bucketInstanceId=o,this.index=new e.c4(i.length,16,Int32Array),this.keys=[],this.crossTileIDs=[];const s=t.canonical.x*e.al,r=t.canonical.y*e.al;for(let e=0;e<i.length;e++){const{key:t,crossTileID:o,tileAnchorX:n,tileAnchorY:a}=i.get(e),l=Math.floor((s+n)*Gi),c=Math.floor((r+a)*Gi);this.index.add(l,c),this.keys.push(t),this.crossTileIDs.push(o);}this.index.finish();}findMatches(t,i,o){const s=this.tileID.canonical.z<i.canonical.z?1:Math.pow(2,this.tileID.canonical.z-i.canonical.z),r=Gi/Math.pow(2,i.canonical.z-this.tileID.canonical.z),n=i.canonical.x*e.al,a=i.canonical.y*e.al;for(let e=0;e<t.length;e++){const i=t.get(e);if(i.crossTileID)continue;const{key:l,tileAnchorX:c,tileAnchorY:h}=i,d=Math.floor((n+c)*r),u=Math.floor((a+h)*r),_=this.index.range(d-s,u-s,d+s,u+s).sort(((e,t)=>e-t));for(const e of _){const t=this.crossTileIDs[e];if(this.keys[e]===l&&!o.has(t)){o.add(t),i.crossTileID=t;break}}}}}class Hi{constructor(){this.maxCrossTileID=0;}generate(){return ++this.maxCrossTileID}}class qi{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0;}handleWrapJump(e){const t=Math.round((e-this.lng)/360);if(0!==t)for(const e in this.indexes){const i=this.indexes[e],o={};for(const e in i){const s=i[e];s.tileID=s.tileID.unwrapTo(s.tileID.wrap+t),o[s.tileID.key]=s;}this.indexes[e]=o;}this.lng=e;}addBucket(e,t,i){if(this.indexes[e.overscaledZ]&&this.indexes[e.overscaledZ][e.key]){if(this.indexes[e.overscaledZ][e.key].bucketInstanceId===t.bucketInstanceId)return !1;this.removeBucketCrossTileIDs(e.overscaledZ,this.indexes[e.overscaledZ][e.key]);}for(let e=0;e<t.symbolInstances.length;e++)t.symbolInstances.get(e).crossTileID=0;this.usedCrossTileIDs[e.overscaledZ]||(this.usedCrossTileIDs[e.overscaledZ]=new Set);const o=this.usedCrossTileIDs[e.overscaledZ];for(const i in this.indexes){const s=this.indexes[i];if(Number(i)>e.overscaledZ)for(const i in s){const r=s[i];r.tileID.isChildOf(e)&&r.findMatches(t.symbolInstances,e,o);}else {const r=s[e.scaledTo(Number(i)).key];r&&r.findMatches(t.symbolInstances,e,o);}}for(let e=0;e<t.symbolInstances.length;e++){const s=t.symbolInstances.get(e);s.crossTileID||(s.crossTileID=i.generate(),o.add(s.crossTileID));}return void 0===this.indexes[e.overscaledZ]&&(this.indexes[e.overscaledZ]={}),this.indexes[e.overscaledZ][e.key]=new Vi(e,t.symbolInstances,t.bucketInstanceId),!0}removeBucketCrossTileIDs(e,t){for(const i of t.crossTileIDs)this.usedCrossTileIDs[e].delete(i);}removeStaleBuckets(e){let t=!1;for(const i in this.indexes){const o=this.indexes[i];for(const s in o)e[o[s].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,o[s]),delete o[s],t=!0);}return t}}class Zi{constructor(){this.layerIndexes={},this.crossTileIDs=new Hi,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={};}addLayer(e,t,i,o){let s=this.layerIndexes[e.fqid];void 0===s&&(s=this.layerIndexes[e.fqid]=new qi);let r=!1;const n={};"globe"!==o.name&&s.handleWrapJump(i);for(const i of t){const t=i.getBucket(e);t&&e.fqid===t.layerIds[0]&&(t.bucketInstanceId||(t.bucketInstanceId=++this.maxBucketInstanceId),s.addBucket(i.tileID,t,this.crossTileIDs)&&(r=!0),n[t.bucketInstanceId]=!0);}return s.removeStaleBuckets(n)&&(r=!0),r}pruneUnusedLayers(e){const t={};e.forEach((e=>{t[e]=!0;}));for(const e in this.layerIndexes)t[e]||delete this.layerIndexes[e];}}const Wi=771;class $i{constructor(e,t,i,o){this.blendFunction=e,this.blendColor=t.toNonPremultipliedRenderColor(null),this.mask=i,this.blendEquation=o;}}$i.Replace=[1,0,1,0],$i.disabled=new $i($i.Replace,e.ao.transparent,[!1,!1,!1,!1]),$i.unblended=new $i($i.Replace,e.ao.transparent,[!0,!0,!0,!0]),$i.alphaBlended=new $i([1,Wi,1,Wi],e.ao.transparent,[!0,!0,!0,!0]),$i.alphaBlendedNonPremultiplied=new $i([770,Wi,770,Wi],e.ao.transparent,[!0,!0,!0,!0]),$i.multiply=new $i([774,0,774,0],e.ao.transparent,[!0,!0,!0,!0]),$i.additive=new $i([1,1,1,1],e.ao.transparent,[!0,!0,!0,!0]);class Xi{constructor(e,t,i){this.func=e,this.mask=t,this.range=i;}}Xi.ReadOnly=!1,Xi.ReadWrite=!0,Xi.disabled=new Xi(519,Xi.ReadOnly,[0,1]);const Yi=7680;class Ki{constructor(e,t,i,o,s,r){this.test=e,this.ref=t,this.mask=i,this.fail=o,this.depthFail=s,this.pass=r;}}Ki.disabled=new Ki({func:519,mask:0},0,0,Yi,Yi,Yi);const Ji=1029,Qi=2305;class eo{constructor(e,t,i){this.enable=e,this.mode=t,this.frontFace=i;}}function to(t,i){const o=e.ca(t,3);e.cc(t,i),e.cg(t,3,o);}function io(t,i){const o=e.c7([]);return e.c8(o,o,-i),e.c9(o,o,-t),o}function oo(t,i){const o=[t[0],t[1],0],s=[i[0],i[1],0];if(e.ag(o)>=1e-15){const t=e.aw([],o);e.c5(s,t,e.bJ(s,t)),i[0]=s[0],i[1]=s[1];}const r=e.bI([],i,t);if(e.c6(r)<1e-15)return null;const n=Math.atan2(-r[1],r[0]);return io(Math.atan2(Math.sqrt(t[0]*t[0]+t[1]*t[1]),-t[2]),n)}eo.disabled=new eo(!1,Ji,Qi),eo.backCCW=new eo(!0,Ji,Qi),eo.backCW=new eo(!0,Ji,2304),eo.frontCW=new eo(!0,1028,2304),eo.frontCCW=new eo(!0,1028,Qi);class so{constructor(e,t){this.position=e,this.orientation=t;}get position(){return this._position}set position(t){if(t){const i=t instanceof e.ae?t:new e.ae(t[0],t[1],t[2]);this._renderWorldCopies&&(i.x=e.bT(i.x,0,1)),this._position=i;}else this._position=null;}lookAtPoint(t,i,o){if(this.orientation=null,!this.position)return;const s=this.position,r=o||(this._elevation?this._elevation.getAtPointOrZero(e.ae.fromLngLat(t)):0),n=e.ae.fromLngLat(t,r),a=[n.x-s.x,n.y-s.y,n.z-s.z];i||(i=[0,0,1]),i[2]=Math.abs(i[2]),this.orientation=oo(a,i);}setPitchBearing(t,i){this.orientation=io(e.an(t),e.an(-i));}}class ro{constructor(t,i){this._transform=e.bA([]),this.orientation=i,this.position=t;}get mercatorPosition(){const t=this.position;return new e.ae(t[0],t[1],t[2])}get position(){const t=e.ca(this._transform,3);return [t[0],t[1],t[2]]}set position(t){var i;t&&e.cg(this._transform,3,[(i=t)[0],i[1],i[2],1]);}get orientation(){return this._orientation}set orientation(t){this._orientation=t||e.c7([]),t&&to(this._transform,this._orientation);}getPitchBearing(){const e=this.forward(),t=this.right();return {bearing:Math.atan2(-t[1],t[0]),pitch:Math.atan2(Math.sqrt(e[0]*e[0]+e[1]*e[1]),-e[2])}}setPitchBearing(e,t){this._orientation=io(e,t),to(this._transform,this._orientation);}forward(){const t=e.ca(this._transform,2);return [-t[0],-t[1],-t[2]]}up(){const t=e.ca(this._transform,1);return [-t[0],-t[1],-t[2]]}right(){const t=e.ca(this._transform,0);return [t[0],t[1],t[2]]}getCameraToWorld(t,i){const o=new Float64Array(16);return e.bl(o,this.getWorldToCamera(t,i)),o}getCameraToWorldMercator(){return this._transform}getWorldToCameraPosition(t,i,o){const s=this.position;e.c5(s,s,-t);const r=new Float64Array(16);return e.bq(r,[o,o,o]),e.br(r,r,s),r[10]*=i,r}getWorldToCamera(t,i){const o=new Float64Array(16),s=new Float64Array(4),r=this.position;return e.cb(s,this._orientation),e.c5(r,r,-t),e.cc(o,s),e.br(o,o,r),o[1]*=-1,o[5]*=-1,o[9]*=-1,o[13]*=-1,o[8]*=i,o[9]*=i,o[10]*=i,o[11]*=i,o}getCameraToClipPerspective(t,i,o,s){const r=new Float64Array(16);return e.cd(r,t,i,o,s),r}getCameraToClipOrthographic(t,i,o,s,r,n){const a=new Float64Array(16);return e.ce(a,t,i,o,s,r,n),a}getDistanceToElevation(t,i=!1){const o=0===t?0:e.cf(t,i?e.a$(this.position[1]):this.position[1]),s=this.forward();return (o-this.position[2])/s[2]}clone(){return new ro([...this.position],[...this.orientation])}}const no={BaseColor:5,MetallicRoughness:6,Normal:7,Occlusion:8,Emission:9,LUT:10,ShadowMap0:11};class ao{constructor(e=0,t=0,i=0,o=0){if(isNaN(e)||e<0||isNaN(t)||t<0||isNaN(i)||i<0||isNaN(o)||o<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=e,this.bottom=t,this.left=i,this.right=o;}interpolate(t,i,o){return null!=i.top&&null!=t.top&&(this.top=e.ak(t.top,i.top,o)),null!=i.bottom&&null!=t.bottom&&(this.bottom=e.ak(t.bottom,i.bottom,o)),null!=i.left&&null!=t.left&&(this.left=e.ak(t.left,i.left,o)),null!=i.right&&null!=t.right&&(this.right=e.ak(t.right,i.right,o)),this}getCenter(t,i){const o=e.aA((this.left+t-this.right)/2,0,t),s=e.aA((this.top+i-this.bottom)/2,0,i);return new e.P(o,s)}equals(e){return this.top===e.top&&this.bottom===e.bottom&&this.left===e.left&&this.right===e.right}clone(){return new ao(this.top,this.bottom,this.left,this.right)}toJSON(){return {top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}const lo=15;class co{constructor(t,i,o,s,r,n,a){this.tileSize=512,this._renderWorldCopies=void 0===r||r,this._minZoom=t||0,this._maxZoom=i||22,this._minPitch=o??0,this._maxPitch=s??60,this.setProjection(n),this.setMaxBounds(a),this.width=0,this.height=0,this._center=new e.aT(0,0),this.zoom=0,this.angle=0,this._fov=.6435011087932844,this._pitch=0,this._nearZ=0,this._farZ=0,this._unmodified=!0,this._edgeInsets=new ao,this._projMatrixCache={},this._alignedProjMatrixCache={},this._fogTileMatrixCache={},this._expandedProjMatrixCache={},this._distanceTileDataCache={},this._camera=new ro,this._centerAltitude=0,this._averageElevation=0,this.cameraElevationReference="ground",this._pixelsPerMercatorPixel=1,this.globeRadius=0,this.globeCenterInViewSpace=[0,0,0],this._tileCoverLift=0,this.freezeTileCoverage=!1,this._horizonShift=.1,this._orthographicProjectionAtLowPitch=!1,this._allowWorldUnderZoom=!1;}clone(){const e=new co(this._minZoom,this._maxZoom,this._minPitch,this.maxPitch,this._renderWorldCopies,this.getProjection(),this.maxBounds);return e._elevation=this._elevation,e._centerAltitude=this._centerAltitude,e._centerAltitudeValidForExaggeration=this._centerAltitudeValidForExaggeration,e.tileSize=this.tileSize,e.mercatorFromTransition=this.mercatorFromTransition,e.width=this.width,e.height=this.height,e.cameraElevationReference=this.cameraElevationReference,e._center=this._center,e._setZoom(this.zoom),e._seaLevelZoom=this._seaLevelZoom,e.angle=this.angle,e._fov=this._fov,e._pitch=this._pitch,e._nearZ=this._nearZ,e._farZ=this._farZ,e._averageElevation=this._averageElevation,e._orthographicProjectionAtLowPitch=this._orthographicProjectionAtLowPitch,e._unmodified=this._unmodified,e._edgeInsets=this._edgeInsets.clone(),e._camera=this._camera.clone(),e._calcMatrices(),e.freezeTileCoverage=this.freezeTileCoverage,e.frustumCorners=this.frustumCorners,e._allowWorldUnderZoom=this._allowWorldUnderZoom,e}get isOrthographic(){return "globe"!==this.projection.name&&this._orthographicProjectionAtLowPitch&&this.pitch<lo}get elevation(){return this._elevation}set elevation(e){this._elevation!==e&&(this._elevation=e,this._updateCameraOnTerrain(),this._calcMatrices());}get depthOcclusionForSymbolsAndCircles(){return "globe"!==this.projection.name&&!this.isOrthographic}updateElevation(e,t=!1){const i=this._elevation&&this._elevation.exaggeration()!==this._centerAltitudeValidForExaggeration;(null==this._seaLevelZoom||i)&&this._updateCameraOnTerrain(),(e||i)&&this._constrainCamera(t),this._calcMatrices();}getProjection(){return e.aH(this.projection,["name","center","parallels"])}setProjection(t){this.projectionOptions=t||{name:"mercator"};const i=this.projection?this.getProjection():void 0;this.projection=e.cm(this.projectionOptions);const o=this.getProjection(),s=!e.by(i,o);return s&&this._calcMatrices(),this.mercatorFromTransition=!1,s}setOrthographicProjectionAtLowPitch(e){return this._orthographicProjectionAtLowPitch!==e&&(this._orthographicProjectionAtLowPitch=e,this._calcMatrices(),!0)}setMercatorFromTransition(){const t=this.projection.name;this.mercatorFromTransition=!0,this.projectionOptions={name:"mercator"},this.projection=e.cm({name:"mercator"});const i=t!==this.projection.name;return i&&this._calcMatrices(),i}get minZoom(){return this._minZoom}set minZoom(e){this._minZoom!==e&&(this._minZoom=e,this.zoom=Math.max(this.zoom,e));}get maxZoom(){return this._maxZoom}set maxZoom(e){this._maxZoom!==e&&(this._maxZoom=e,this.zoom=Math.min(this.zoom,e));}get minPitch(){return this._minPitch}set minPitch(e){this._minPitch!==e&&(this._minPitch=e,this.pitch=Math.max(this.pitch,e));}get maxPitch(){return this._maxPitch}set maxPitch(e){this._maxPitch!==e&&(this._maxPitch=e,this.pitch=Math.min(this.pitch,e));}get renderWorldCopies(){return this._renderWorldCopies&&!0===this.projection.supportsWorldCopies}set renderWorldCopies(e){void 0===e?e=!0:null===e&&(e=!1),this._renderWorldCopies=e;}get worldSize(){return this.tileSize*this.scale}get cameraWorldSizeForFog(){const e=Math.max(this._camera.getDistanceToElevation(this._averageElevation),Number.EPSILON);return this._worldSizeFromZoom(this._zoomFromMercatorZ(e))}get cameraWorldSize(){const e=Math.max(this._camera.getDistanceToElevation(this._averageElevation,!0),Number.EPSILON);return this._worldSizeFromZoom(this._zoomFromMercatorZ(e))}get pixelsPerMeter(){return this.projection.pixelsPerMeter(this.center.lat,this.worldSize)}get cameraPixelsPerMeter(){return e.cf(1,this.center.lat)*this.cameraWorldSizeForFog}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new e.P(this.width,this.height)}get bearing(){return e.bT(this.rotation,-180,180)}set bearing(e){this.rotation=e;}get rotation(){return -this.angle/Math.PI*180}set rotation(t){const i=-t*Math.PI/180;this.angle!==i&&(this._unmodified=!1,this.angle=i,this._calcMatrices(),this.rotationMatrix=e.cn(),e.co(this.rotationMatrix,this.rotationMatrix,this.angle));}get pitch(){return this._pitch/Math.PI*180}set pitch(t){const i=e.aA(t,this.minPitch,this.maxPitch)/180*Math.PI;this._pitch!==i&&(this._unmodified=!1,this._pitch=i,this._calcMatrices());}get aspect(){return this.width/this.height}get fov(){return this._fov/Math.PI*180}set fov(t){t=Math.max(.01,Math.min(60,t)),this._fov!==t&&(this._unmodified=!1,this._fov=e.an(t),this._calcMatrices());}get fovX(){return this._fov}get fovY(){const e=1/Math.tan(.5*this.fovX);return 2*Math.atan(1/this.aspect/e)}get averageElevation(){return this._averageElevation}set averageElevation(e){this._averageElevation=e,this._calcFogMatrices(),this._distanceTileDataCache={};}get zoom(){return this._zoom}set zoom(e){const t=Math.min(Math.max(e,this.minZoom),this.maxZoom);this._zoom!==t&&(this._unmodified=!1,this._setZoom(t),this._updateSeaLevelZoom(),this._constrain(),this._calcMatrices());}_setZoom(e){this._zoom=e,this.scale=this.zoomScale(e),this.tileZoom=Math.floor(e),this.zoomFraction=e-this.tileZoom;}get tileCoverLift(){return this._tileCoverLift}set tileCoverLift(e){this._tileCoverLift!==e&&(this._tileCoverLift=e);}_updateCameraOnTerrain(){const e=this.elevation?this.elevation.getAtPoint(this.locationCoordinate(this.center),Number.NEGATIVE_INFINITY):Number.NEGATIVE_INFINITY,t=this.elevation&&e===Number.NEGATIVE_INFINITY&&this.elevation.visibleDemTiles.length>0&&this.elevation.exaggeration()>0&&this._centerAltitudeValidForExaggeration;if(!this._elevation||e===Number.NEGATIVE_INFINITY&&(!t||!this._centerAltitude))return this._centerAltitude=0,this._seaLevelZoom=null,void(this._centerAltitudeValidForExaggeration=void 0);const i=this._elevation;t||this._centerAltitude&&this._centerAltitudeValidForExaggeration&&i.exaggeration()&&this._centerAltitudeValidForExaggeration!==i.exaggeration()?(this._centerAltitude=this._centerAltitude/this._centerAltitudeValidForExaggeration*i.exaggeration(),this._centerAltitudeValidForExaggeration=i.exaggeration()):(this._centerAltitude=e||0,this._centerAltitudeValidForExaggeration=i.exaggeration()),this._updateSeaLevelZoom();}_updateSeaLevelZoom(){if(void 0===this._centerAltitudeValidForExaggeration)return;const e=Math.max(0,(this.pixelsPerMeter*this._centerAltitude+this.cameraToCenterDistance)/this.worldSize);this._seaLevelZoom=this._zoomFromMercatorZ(e);}sampleAverageElevation(){if(!this._elevation)return 0;const t=this._elevation,i=[[.5,.2],[.3,.5],[.5,.5],[.7,.5],[.5,.8]],o=this.horizonLineFromTop();let s=0,r=0;for(let n=0;n<i.length;n++){const a=new e.P(i[n][0]*this.width,o+i[n][1]*(this.height-o)),l=t.pointCoordinate(a);if(!l)continue;const c=1/Math.hypot(l[0]-this._camera.position[0],l[1]-this._camera.position[1]);s+=l[3]*c,r+=c;}return 0===r?NaN:s/r}get center(){return this._center}set center(e){e.lat===this._center.lat&&e.lng===this._center.lng||(this._unmodified=!1,this._center=e,this._terrainEnabled()&&("ground"===this.cameraElevationReference?this._updateCameraOnTerrain():this._updateZoomFromElevation()),this._constrain(),this._calcMatrices());}_updateZoomFromElevation(){if(null==this._seaLevelZoom||!this._elevation)return;const e=this._seaLevelZoom,t=this._elevation.getAtPointOrZero(this.locationCoordinate(this.center)),i=this.pixelsPerMeter/this.worldSize*t,o=this._mercatorZfromZoom(e),s=this._mercatorZfromZoom(this._maxZoom),r=Math.max(o-i,s);this._setZoom(this._zoomFromMercatorZ(r));}get padding(){return this._edgeInsets.toJSON()}set padding(e){this._edgeInsets.equals(e)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,e,1),this._calcMatrices());}equals(e){const t=this.elevation,i=e.elevation,o=null!=t!=(null!=i)||t&&i&&t.exaggeration()!==i.exaggeration();return this.width===e.width&&this.height===e.height&&this.center.lng===e.center.lng&&this.center.lat===e.center.lat&&this.zoom===e.zoom&&this.bearing===e.bearing&&this.pitch===e.pitch&&this.fov===e.fov&&this.projection.name===e.projection.name&&this._edgeInsets.equals(e.padding)&&!o}computeZoomRelativeTo(t){const i=this.rayIntersectionCoordinate(this.pointRayIntersection(this.centerPoint,t.toAltitude()));let o;o=t.z<this._camera.position[2]?[i.x,i.y,i.z]:[t.x,t.y,t.z];const s=e.ag(e.av([],this._camera.position,o));return e.aA(this._zoomFromMercatorZ(s),this._minZoom,this._maxZoom)}setFreeCameraOptions(t){if(!this.height)return;if(!t.position&&!t.orientation)return;this._updateCameraState();let i=!1;if(t.orientation&&!e.cp(t.orientation,this._camera.orientation)&&(i=this._setCameraOrientation(t.orientation)),t.position){const o=[t.position.x,t.position.y,t.position.z];e.cq(o,this._camera.position)||(this._setCameraPosition(o),i=!0);}i&&(this._updateStateFromCamera(),this.recenterOnTerrain());}getFreeCameraOptions(){this._updateCameraState();const t=this._camera.position,i=new so;return i.position=new e.ae(t[0],t[1],t[2]),i.orientation=this._camera.orientation,i._elevation=this.elevation,i._renderWorldCopies=this.renderWorldCopies,i}_setCameraOrientation(t){if(!e.cr(t))return !1;e.cs(t,t);const i=e.ct([],[0,0,-1],t),o=e.ct([],[0,-1,0],t);if(o[2]<0)return !1;const s=oo(i,o);return !!s&&(this._camera.orientation=s,!0)}_setCameraPosition(t){const i=this.zoomScale(this.minZoom)*this.tileSize,o=this.zoomScale(this.maxZoom)*this.tileSize,s=this.cameraToCenterDistance;t[2]=e.aA(t[2],s/o,s/i),this._camera.position=t;}get centerPoint(){return this._edgeInsets.getCenter(this.width,this.height)}get fovAboveCenter(){return this._fov*(.5+this.centerOffset.y/this.height)}isPaddingEqual(e){return this._edgeInsets.equals(e)}interpolatePadding(e,t,i){this._unmodified=!1,this._edgeInsets.interpolate(e,t,i),this._constrain(),this._calcMatrices();}coveringZoomLevel(e){const t=(e.roundZoom?Math.round:Math.floor)(this.zoom+this.scaleZoom(this.tileSize/e.tileSize));return Math.max(0,t)}getVisibleUnwrappedCoordinates(t){const i=[new e.cu(0,t)];if(this.renderWorldCopies){const o=this.pointCoordinate(new e.P(0,0)),s=this.pointCoordinate(new e.P(this.width,0)),r=this.pointCoordinate(new e.P(this.width,this.height)),n=this.pointCoordinate(new e.P(0,this.height)),a=Math.floor(Math.min(o.x,s.x,r.x,n.x)),l=Math.floor(Math.max(o.x,s.x,r.x,n.x)),c=1;for(let o=a-c;o<=l+c;o++)0!==o&&i.push(new e.cu(o,t));}return i}isLODDisabled(e){return (!e||this.pitch<=60)&&this._edgeInsets.top<=this._edgeInsets.bottom&&!this._elevation&&!this.projection.isReprojectedInTileSpace}extendTileCover(t,i,o,s){let r=[];const n=null!=o,a=!n;if(a&&this.zoom<i)return r;if(n&&0===o[0]&&0===o[1])return r;const l=new Set,c=(t,i,o,s,n)=>{const a=e.cY(i,t,o,s,n);l.has(a)||(r.push(new e.aQ(t,i,o,s,n)),l.add(a));};for(let e=0;e<t.length;e++){const r=t[e];if(a&&r.canonical.z!==i)continue;if(n&&void 0!==s&&s>r.canonical.z)continue;const l=r.canonical,h=r.overscaledZ,d=r.wrap,u=1<<l.z,_=l.x+1<u,p=l.x>0,f=l.y+1<u,m=l.y>0,g=r.wrap-(p?0:1),v=r.wrap+(_?0:1),y=p?l.x-1:u-1,x=_?l.x+1:0;if(n)o[0]<0?(c(h,v,l.z,x,l.y),o[1]<0&&f&&(c(h,d,l.z,l.x,l.y+1),c(h,v,l.z,x,l.y+1)),o[1]>0&&m&&(c(h,d,l.z,l.x,l.y-1),c(h,v,l.z,x,l.y-1))):o[0]>0?(c(h,g,l.z,y,l.y),o[1]<0&&f&&(c(h,d,l.z,l.x,l.y+1),c(h,g,l.z,y,l.y+1)),o[1]>0&&m&&(c(h,d,l.z,l.x,l.y-1),c(h,g,l.z,y,l.y-1))):o[1]<0&&f?c(h,d,l.z,l.x,l.y+1):m&&c(h,d,l.z,l.x,l.y-1);else {const e=r.visibleQuadrants;1&e&&(c(h,g,l.z,y,l.y),m&&(c(h,d,l.z,l.x,l.y-1),c(h,g,l.z,y,l.y-1))),2&e&&(c(h,v,l.z,x,l.y),m&&(c(h,d,l.z,l.x,l.y-1),c(h,v,l.z,x,l.y-1))),4&e&&(c(h,g,l.z,y,l.y),f&&(c(h,d,l.z,l.x,l.y+1),c(h,g,l.z,y,l.y+1))),8&e&&(c(h,v,l.z,x,l.y),f&&(c(h,d,l.z,l.x,l.y+1),c(h,v,l.z,x,l.y+1)));}}const h=[];for(const e of r)r.some((t=>e.isChildOf(t)))||h.push(e);if(r=h.filter((e=>!t.some((t=>!!(e.overscaledZ<i&&t.isChildOf(e))||e.equals(t)||e.isChildOf(t))))),a){const e=1<<i,t="globe"===this.projection.name?this._camera.mercatorPosition:this.pointCoordinate(this.getCameraPoint()),o=[e*t.x,e*t.y],s=4,n=s*s;r=r.filter((e=>{const t=e.canonical.x+.5-o[0],i=e.canonical.y+.5-o[1];return t*t+i*i<n}));}return r}extendTileCoverToNearPlane(t,i,o){const s=[],r=new Set;for(const e of t)r.add(e.key);const n=(t,i,o,n,a)=>{const l=e.cY(i,t,o,n,a);r.has(l)||(s.push(new e.aQ(t,i,o,n,a)),r.add(l));},a=t.reduce(((e,t)=>Math.max(e,t.overscaledZ)),o),l=1<<o,c=[new e.P(0,0),new e.P(e.al,0),new e.P(e.al,e.al),new e.P(0,e.al)],h=new e.P(0,0),d=new e.P(0,0),u=(t,i)=>{const s=Math.floor(t[0]),r=Math.floor(t[1]),u=(t[0]-s)*e.al,_=(t[1]-r)*e.al,p=Math.floor(i[0]),f=Math.floor(i[1]),m=(i[0]-p)*e.al,g=(i[1]-f)*e.al;for(let t=-1;t<=1;t++){const i=s+t;if(!(i<0||i>=l)){h.x=u-t*e.al,d.x=m-(i-p)*e.al;for(let t=-1;t<=1;t++){const s=r+t;h.y=_-t*e.al,d.y=g-(s-f)*e.al,e.cZ(h,d,c)&&n(a,0,o,i,s);}}}},_=i.points,p=_[e.cv],f=_[e.cw],m=this._projectToGround(p,_[e.cx]),g=this._projectToGround(f,_[e.cy]);return u(p,m),u(f,g),s}_projectToGround(t,i){return e.cz(e.cA(),t,i,t[2]/(t[2]-i[2]))}coveringTiles(t){let i=this.coveringZoomLevel(t);const o=i,s=this.elevation&&this.elevation.exaggeration(),r=s&&!t.isTerrainDEM,n="mercator"===this.projection.name;if(void 0!==t.minzoom&&i<t.minzoom)return [];void 0!==t.maxzoom&&i>t.maxzoom&&(i=t.maxzoom);const a=this.locationCoordinate(this.center),l=this.center.lat,c=1<<i,h=[c*a.x,c*a.y,0],d="globe"===this.projection.name,u=!d,_=e.cB.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,i,u),p=d?this._camera.mercatorPosition:this.pointCoordinate(this.getCameraPoint()),f=c*e.cf(1,this.center.lat),m=this._camera.position[2]/e.cf(1,this.center.lat),g=[c*p.x,c*p.y,m*(u?1:f)],v=d||s,y=this.cameraToCenterDistance/t.tileSize*(t.roundZoom?1:.502),x=this.isLODDisabled(!0)?i:0;let b;if(this._elevation&&t.isTerrainDEM)b=1e4*this._elevation.exaggeration();else if(this._elevation){const e=this._elevation.getMinMaxForVisibleTiles();b=e?e.max:this._centerAltitude;}else b=this._centerAltitude;const w=t.isTerrainDEM?-b:this._elevation?this._elevation.getMinElevationBelowMSL():0,T=this.projection.isReprojectedInTileSpace?e.cC(this):1,E=t=>{const i=1/4e4,o=new e.ae(t.x+i,t.y,t.z),s=new e.ae(t.x,t.y+i,t.z),r=t.toLngLat(),n=o.toLngLat(),a=s.toLngLat(),l=this.locationCoordinate(r),c=this.locationCoordinate(n),h=this.locationCoordinate(a),d=Math.hypot(c.x-l.x,c.y-l.y),u=Math.hypot(h.x-l.x,h.y-l.y);return Math.sqrt(d*u)*T/i},S=t=>{const i=b,o=w;return {aabb:e.cF(this,c,0,0,0,t,o,i,this.projection),zoom:0,x:0,y:0,minZ:o,maxZ:i,wrap:t,fullyVisible:!1}},I=[];let C=[];const R=i,A=t.reparseOverscaled?o:i,L=(m-this._centerAltitude)*f,D=e=>{if(!this._elevation||!e.tileID||!n)return;const t=this._elevation.getMinMaxForTile(e.tileID),i=e.aabb;t?(i.min[2]=t.min,i.max[2]=t.max,i.center[2]=(i.min[2]+i.max[2])/2):(e.shouldSplit=O(e),e.shouldSplit||(i.min[2]=i.max[2]=i.center[2]=this._centerAltitude));},P=(e,t)=>{if(.707*t<e)return 1;const i=t/e;return i/(1.4144271570014144+(Math.pow(1.1,i-1.4144271570014144+1)-1)/(1.1-1)-1)},O=t=>{if(t.zoom<x)return !0;if(t.zoom===R)return !1;if(null!=t.shouldSplit)return t.shouldSplit;const i=t.aabb.distanceX(g),s=t.aabb.distanceY(g);let a=L,c=1;if(d){a=t.aabb.distanceZ(g);const i=Math.pow(2,t.zoom),o=e.a$((t.y+1)/i),s=e.a$(t.y/i),r=Math.min(Math.max(l,o),s),n=e.d1(r)/e.d1(l);if(c=r===l?1/Math.max(1,this._mercatorScaleRatio-.3):Math.min(1,n/this._mercatorScaleRatio),this.zoom<=e.c_&&t.zoom===R-1&&n>=.9)return !0}else if(r&&(a=t.aabb.distanceZ(g)*f),this.projection.isReprojectedInTileSpace&&o<=5){const i=Math.pow(2,t.zoom),o=E(new e.ae((t.x+.5)/i,(t.y+.5)/i));c=o>.85?1:o;}if(!n&&!d){const e=Math.sqrt(i*i+s*s+a*a);let o=(1<<R-t.zoom)*y*c;return o*=P(Math.max(a,L),e),e<o}let u=Number.MAX_VALUE,_=0;const p=t.aabb.getCorners(),m=[];for(const t of p){e.av(m,t,g),d||(r?m[2]*=f:m[2]=L);const i=e.bJ(m,this._camera.forward());i<u&&(u=i,_=Math.abs(m[2]));}let v=(1<<R-t.zoom)*y*c;if(v*=P(Math.max(_,L),u),u<v)return !0;const b=t.aabb.closestPoint(h);return b[0]===h[0]&&b[1]===h[1]};if(this.renderWorldCopies)for(let e=1;e<=3;e++)I.push(S(-e)),I.push(S(e));for(I.push(S(0));I.length>0;){const o=I.pop(),s=o.x,a=o.y;let l=o.fullyVisible;const u=()=>"globe"===this.projection.name&&(0===o.y||o.y===(1<<o.zoom)-1);if(!l){let t=v?o.aabb.intersects(_):o.aabb.intersectsFlat(_);if(0===t&&u()){const i=new e.cD(o.zoom,s,a);t=e.cE(this,c,i,!0).intersects(_);}if(0===t)continue;l=2===t;}if(o.zoom!==R&&O(o))for(let t=0;t<4;t++){const i=(s<<1)+t%2,h=(a<<1)+(t>>1),u={aabb:n?o.aabb.quadrant(t):e.cF(this,c,o.zoom+1,i,h,o.wrap,o.minZ,o.maxZ,this.projection),zoom:o.zoom+1,x:i,y:h,wrap:o.wrap,fullyVisible:l,tileID:void 0,shouldSplit:void 0,minZ:o.minZ,maxZ:o.maxZ};r&&!d&&(u.tileID=new e.aQ(o.zoom+1===R?A:o.zoom+1,o.wrap,o.zoom+1,i,h),D(u)),I.push(u);}else {const r=o.zoom===R?A:o.zoom;if(t.minzoom&&t.minzoom>r)continue;let n=0;if(!l){let i=v?o.aabb.intersectsPrecise(_):o.aabb.intersectsPreciseFlat(_);if(0===i&&u()){const t=new e.cD(o.zoom,s,a);i=e.cE(this,c,t,!0).intersectsPrecise(_);}if(0===i)continue;if(t.calculateQuadrantVisibility)if(_.containsPoint(o.aabb.center))n=15;else for(let e=0;e<4;e++)0!==o.aabb.quadrant(e).intersects(_)&&(n|=1<<e);}const d=h[0]-(.5+s+(o.wrap<<o.zoom))*(1<<i-o.zoom),p=h[1]-.5-a,f=o.tileID?o.tileID:new e.aQ(r,o.wrap,o.zoom,s,a);t.calculateQuadrantVisibility&&(f.visibleQuadrants=n),C.push({tileID:f,distanceSq:d*d+p*p});}}if(this.fogCullDistSq){const i=this.fogCullDistSq,o=this.horizonLineFromTop();C=C.filter((s=>{const r=[0,0,0,1],n=[e.al,e.al,0,1],a=this.calculateFogTileMatrix(s.tileID.toUnwrapped());e.aC(r,r,a),e.aC(n,n,a);const l=e.cG([],r,n),c=e.cH([],r,n),h=e.c$(l,c);if(0===h)return !0;let d=!1;const u=this._elevation;if(u&&h>i&&0!==o){const i=this.calculateProjMatrix(s.tileID.toUnwrapped());let r;t.isTerrainDEM||(r=u.getMinMaxForTile(s.tileID)),r||(r={min:w,max:b});const n=e.cI(this.rotation),a=[n[0]*e.al,n[1]*e.al,r.max];e.af(a,a,i),d=(1-a[1])*this.height*.5<o;}return h<i||d}));}return C.sort(((e,t)=>e.distanceSq-t.distanceSq)).map((e=>e.tileID))}resize(e,t){this.width=e,this.height=t,this.pixelsToGLUnits=[2/e,-2/t],this._constrain(),this._calcMatrices();}get unmodified(){return this._unmodified}zoomScale(e){return Math.pow(2,e)}scaleZoom(e){return Math.log2(e)}project(t){const i=e.aA(t.lat,-e.cJ,e.cJ),o=this.projection.project(t.lng,i);return new e.P(o.x*this.worldSize,o.y*this.worldSize)}unproject(e){return this.projection.unproject(e.x/this.worldSize,e.y/this.worldSize)}get point(){return this.project(this.center)}get pointMerc(){return this.point._div(this.worldSize)}get pixelsPerMeterRatio(){return this.pixelsPerMeter/e.cf(1,this.center.lat)/this.worldSize}setLocationAtPoint(t,i){let o,s;const r=this.centerPoint;if("globe"===this.projection.name){const e=this.worldSize;o=(i.x-r.x)/e,s=(i.y-r.y)/e;}else {const e=this.pointCoordinate(i),t=this.pointCoordinate(r);o=e.x-t.x,s=e.y-t.y;}const n=this.locationCoordinate(t);this.setLocation(new e.ae(n.x-o,n.y-s));}setLocation(e){this.center=this.coordinateLocation(e),this.projection.wrap&&(this.center=this.center.wrap());}locationPoint(e,t){return this.projection.locationPoint(this,e,t)}locationPoint3D(e,t){return this.projection.locationPoint(this,e,t,!0)}pointLocation(e){return this.coordinateLocation(this.pointCoordinate(e))}pointLocation3D(e,t){return this.coordinateLocation(this.pointCoordinate3D(e,t))}locationCoordinate(t,i){const o=i?e.cf(i,t.lat):void 0,s=this.projection.project(t.lng,t.lat);return new e.ae(s.x,s.y,o)}coordinateLocation(e){return this.projection.unproject(e.x,e.y)}pointRayIntersection(t,i){const o=null!=i?i:this._centerAltitude,s=[t.x,t.y,0,1],r=[t.x,t.y,1,1];e.aC(s,s,this.pixelMatrixInverse),e.aC(r,r,this.pixelMatrixInverse);const n=r[3];e.cK(s,s,1/s[3]),e.cK(r,r,1/n);const a=s[2],l=r[2];return {p0:s,p1:r,t:a===l?0:(o-a)/(l-a)}}screenPointToMercatorRay(t){const i=[t.x,t.y,0,1],o=[t.x,t.y,1,1];return e.aC(i,i,this.pixelMatrixInverse),e.aC(o,o,this.pixelMatrixInverse),e.cK(i,i,1/i[3]),e.cK(o,o,1/o[3]),i[2]=e.cf(i[2],this._center.lat)*this.worldSize,o[2]=e.cf(o[2],this._center.lat)*this.worldSize,e.cK(i,i,1/this.worldSize),e.cK(o,o,1/this.worldSize),new e.ax([i[0],i[1],i[2]],e.aw([],e.av([],o,i)))}rayIntersectionCoordinate(t){const{p0:i,p1:o,t:s}=t,r=e.cf(i[2],this._center.lat),n=e.cf(o[2],this._center.lat);return new e.ae(e.ak(i[0],o[0],s)/this.worldSize,e.ak(i[1],o[1],s)/this.worldSize,e.ak(r,n,s))}pointCoordinate(e,t=this._centerAltitude){return this.projection.pointCoordinate(this,e.x,e.y,t)}pointCoordinate3D(t,i){if(!this.elevation)return this.pointCoordinate(t,i);let o=this.projection.pointCoordinate3D(this,t.x,t.y);if(o)return new e.ae(o[0],o[1],o[2]);let s=0,r=this.horizonLineFromTop();if(t.y>r)return this.pointCoordinate(t,i);const n=.02*r,a=t.clone();for(let t=0;t<10&&r-s>n;t++){a.y=e.ak(s,r,.66);const t=this.projection.pointCoordinate3D(this,a.x,a.y);t?(r=a.y,o=t):s=a.y;}return o?new e.ae(o[0],o[1],o[2]):this.pointCoordinate(t)}isPointAboveHorizon(e){return this.projection.isPointAboveHorizon(this,e)}isPointOnSurface(t){if(t.y<0||t.y>this.height||t.x<0||t.x>this.width)return !1;if(this.elevation||this.zoom>=e.cL)return !this.isPointAboveHorizon(t);const i=this.pointCoordinate(t);return i.y>=0&&i.y<=1}_coordinatePoint(t,i){const o=i&&this.elevation?this.elevation.getAtPointOrZero(t,this._centerAltitude):this._centerAltitude,s=[t.x*this.worldSize,t.y*this.worldSize,o+t.toAltitude(),1];return e.aC(s,s,this.pixelMatrix),s[3]>0?new e.P(s[0]/s[3],s[1]/s[3]):new e.P(Number.MAX_VALUE,Number.MAX_VALUE)}_getBoundsNonRectangular(){const{top:t,left:i}=this._edgeInsets,o=this.height-this._edgeInsets.bottom,s=this.width-this._edgeInsets.right,r=this.pointLocation3D(new e.P(i,t)),n=this.pointLocation3D(new e.P(s,t)),a=this.pointLocation3D(new e.P(s,o)),l=this.pointLocation3D(new e.P(i,o));let c=Math.min(r.lng,n.lng,a.lng,l.lng),h=Math.max(r.lng,n.lng,a.lng,l.lng),d=Math.min(r.lat,n.lat,a.lat,l.lat),u=Math.max(r.lat,n.lat,a.lat,l.lat);const _=Math.pow(2,-this.zoom)/16*270,p="globe"===this.projection.name?1:4,f=(t,i,o,s,r)=>{const n=(t+o)/2,a=(i+s)/2,l=new e.P(n,a),{lng:m,lat:g}=this.pointLocation3D(l),v=Math.max(0,c-m,d-g,m-h,g-u);c=Math.min(c,m),h=Math.max(h,m),d=Math.min(d,g),u=Math.max(u,g),(r<p||v>_)&&(f(t,i,n,a,r+1),f(n,a,o,s,r+1));};if(f(i,t,s,t,1),f(s,t,s,o,1),f(s,o,i,o,1),f(i,o,i,t,1),"globe"===this.projection.name){const[t,i]=e.cM(this);t?(u=90,h=180,c=-180):i&&(d=-90,h=180,c=-180);}return new e.aI(new e.aT(c,d),new e.aT(h,u))}_getBoundsRectangular(t,i){const{top:o,left:s}=this._edgeInsets,r=this.height-this._edgeInsets.bottom,n=this.width-this._edgeInsets.right,a=new e.P(s,o),l=new e.P(n,o),c=new e.P(n,r),h=new e.P(s,r);let d=this.pointCoordinate(a,t),u=this.pointCoordinate(l,t);const _=this.pointCoordinate(c,i),p=this.pointCoordinate(h,i),f=(e,t)=>(t.y-e.y)/(t.x-e.x);return d.y>1&&u.y>=0?d=new e.ae((1-p.y)/f(p,d)+p.x,1):d.y<0&&u.y<=1&&(d=new e.ae(-p.y/f(p,d)+p.x,0)),u.y>1&&d.y>=0?u=new e.ae((1-_.y)/f(_,u)+_.x,1):u.y<0&&d.y<=1&&(u=new e.ae(-_.y/f(_,u)+_.x,0)),(new e.aI).extend(this.coordinateLocation(d)).extend(this.coordinateLocation(u)).extend(this.coordinateLocation(p)).extend(this.coordinateLocation(_))}_getBoundsRectangularTerrain(){const e=this.elevation;if(!e.visibleDemTiles.length||e.isUsingMockSource())return this._getBoundsRectangular(0,0);const t=e.visibleDemTiles.reduce(((e,t)=>{if(t.dem){const i=t.dem.tree;e.min=Math.min(e.min,i.minimums[0]),e.max=Math.max(e.max,i.maximums[0]);}return e}),{min:Number.MAX_VALUE,max:0});return this._getBoundsRectangular(t.min*e.exaggeration(),t.max*e.exaggeration())}getBounds(){return "mercator"===this.projection.name||"equirectangular"===this.projection.name?this._terrainEnabled()?this._getBoundsRectangularTerrain():this._getBoundsRectangular(0,0):this._getBoundsNonRectangular()}horizonLineFromTop(e=!0){const t=this.height/2/Math.tan(this._fov/2)/Math.tan(Math.max(this._pitch,.1))-this.centerOffset.y,i=this.height/2-t*(1-this._horizonShift);return e?Math.max(0,i):i}getMaxBounds(){return this.maxBounds}setMaxBounds(t){this.maxBounds=t,this.minLat=-e.cJ,this.maxLat=e.cJ,this.minLng=-180,this.maxLng=180,t&&(this.minLat=t.getSouth(),this.maxLat=t.getNorth(),this.minLng=t.getWest(),this.maxLng=t.getEast(),this.maxLng<this.minLng&&(this.maxLng+=360)),this.worldMinX=e.aF(this.minLng)*this.tileSize,this.worldMaxX=e.aF(this.maxLng)*this.tileSize,this.worldMinY=e.aJ(this.maxLat)*this.tileSize,this.worldMaxY=e.aJ(this.minLat)*this.tileSize,this._constrain();}calculatePosMatrix(e,t){return this.projection.createTileMatrix(this,t,e)}calculateDistanceTileData(t){const i=t.key,o=this._distanceTileDataCache;if(o[i])return o[i];const s=t.canonical,r=1/this.height,n=this.cameraWorldSize,a=n/this.zoomScale(s.z),l=(s.x+Math.pow(2,s.z)*t.wrap)*a,c=s.y*a,h=this.point;h.x*=n/this.worldSize,h.y*=n/this.worldSize;const d=this.angle,u=Math.sin(-d),_=-Math.cos(-d);return o[i]={bearing:[u,_],center:[(h.x-l)*r,(h.y-c)*r],scale:a/e.al*r},o[i]}calculateFogTileMatrix(t){const i=t.key,o=this._fogTileMatrixCache;if(o[i])return o[i];const s=this.projection.createTileMatrix(this,this.cameraWorldSizeForFog,t);return e.aB(s,this.worldToFogMatrix,s),o[i]=new Float32Array(s),o[i]}calculateProjMatrix(t,i=!1,o=!1){const s=t.key;let r;if(r=o?this._expandedProjMatrixCache:i?this._alignedProjMatrixCache:this._projMatrixCache,r[s])return r[s];const n=this.calculatePosMatrix(t,this.worldSize);let a;return a=this.projection.isReprojectedInTileSpace?this.mercatorMatrix:o?this.expandedFarZProjMatrix:i?this.alignedProjMatrix:this.projMatrix,e.aB(n,a,n),r[s]=new Float32Array(n),r[s]}calculatePixelsToTileUnitsMatrix(t){const i=t.tileID.key,o=this._pixelsToTileUnitsCache;if(o[i])return o[i];const s=e.cN(t,this);return o[i]=s,o[i]}customLayerMatrix(){return this.mercatorMatrix.slice()}globeToMercatorMatrix(){if("globe"===this.projection.name){const t=1/this.worldSize,i=e.bq([],[t,t,t]);return e.aB(i,i,this.globeMatrix),i}}recenterOnTerrain(){if(!this._elevation||"globe"===this.projection.name)return;const t=this._elevation;this._updateCameraState();const i=e.cf(1,this._center.lat)*this.worldSize,o=this._computeCameraPosition(i),s=this._camera.forward(),r=e.cf(1,this._center.lat);o[2]/=r,s[2]/=r,e.aw(s,s);const n=t.raycast(o,s,t.exaggeration());if(n){const t=e.bH([],o,s,n),i=new e.ae(t[0],t[1],e.cf(t[2],e.a$(t[1]))),a=(i.z+e.ag([i.x-o[0],i.y-o[1],i.z-o[2]*r]))*this._pixelsPerMercatorPixel;this._seaLevelZoom=this._zoomFromMercatorZ(a),this._centerAltitude=i.toAltitude(),this._center=this.coordinateLocation(i),this._updateZoomFromElevation(),this._constrain(),this._calcMatrices();}}_constrainCamera(t=!1){if(!this._elevation)return;const i=this._elevation,o=e.cf(1,this._center.lat)*this.worldSize,s=this._computeCameraPosition(o),r=i.getAtPointOrZero(new e.ae(...s)),n=this.pixelsPerMeter/this.worldSize*r,a=this._minimumHeightOverTerrain(),l=s[2]-n;if(l<=a)if(l<0||t){const t=this.locationCoordinate(this._center,this._centerAltitude),i=[s[0],s[1],t.z-s[2]],o=e.ag(i);i[2]-=(a-l)/this._pixelsPerMercatorPixel;const r=e.ag(i);if(0===r)return;e.c5(i,i,o/r*this._pixelsPerMercatorPixel),this._camera.position=[s[0],s[1],t.z*this._pixelsPerMercatorPixel-i[2]],this._updateStateFromCamera();}else this._isCameraConstrained=!0;}_constrain(){if(!this.center||!this.width||!this.height||this._constraining)return;this._constraining=!0;const t="globe"===this.projection.name||this.mercatorFromTransition;if(this.projection.isReprojectedInTileSpace||t){const i=this.center;return i.lat=e.aA(i.lat,this.minLat,this.maxLat),(this.maxBounds||!this.renderWorldCopies&&!t)&&(i.lng=e.aA(i.lng,this.minLng,this.maxLng)),this.center=i,void(this._constraining=!1)}const i=this._unmodified,{x:o,y:s}=this.point;let r=0,n=o,a=s;const l=this.width/2,c=this.height/2,h=this.worldMinY*this.scale,d=this.worldMaxY*this.scale;if(s-c<h&&(a=h+c),s+c>d&&(a=d-c),d-h<this.height&&(r=Math.max(r,this.height/(d-h)),a=(d+h)/2),this.maxBounds||!this._renderWorldCopies||!this.projection.wrap){const e=this.worldMinX*this.scale,t=this.worldMaxX*this.scale,i=this.worldSize/2-(e+t)/2;n=(o+i+this.worldSize)%this.worldSize-i,n-l<e&&(n=e+l),n+l>t&&(n=t-l),t-e<this.width&&(r=Math.max(r,this.width/(t-e)),n=(t+e)/2);}n===o&&a===s||this._allowWorldUnderZoom||(this.center=this.unproject(new e.P(n,a))),r&&!this._allowWorldUnderZoom&&(this.zoom+=this.scaleZoom(r)),this._constrainCamera(),this._unmodified=i,this._constraining=!1;}_minZoomForBounds(){let e=Math.max(0,this.scaleZoom(Math.max(0,this.height)/(this.worldMaxY-this.worldMinY)));return this.maxBounds&&(e=Math.max(e,this.scaleZoom(this.width/(this.worldMaxX-this.worldMinX)))),e}_maxCameraBoundsDistance(){return this._mercatorZfromZoom(this._minZoomForBounds())}_calcMatrices(){if(!this.height)return;const t=this.centerOffset,i="globe"===this.projection.name,o=this.pixelsPerMeter;"globe"===this.projection.name&&(this._mercatorScaleRatio=e.cf(1,this.center.lat)/e.cf(1,e.d2));const s=e.cO(this.projection,this.zoom,this.width,this.height,1024);this._pixelsPerMercatorPixel=this.projection.pixelSpaceConversion(this.center.lat,this.worldSize,s),this.cameraToCenterDistance=.5/Math.tan(.5*this._fov)*this.height*this._pixelsPerMercatorPixel,this._updateCameraState(),this._farZ=this.projection.farthestPixelDistance(this),this._nearZ=this.height/50;const r="meters"===this.projection.zAxisUnit?o:1,n=this._camera.getWorldToCamera(this.worldSize,r);let a;const l=this._camera.getCameraToClipPerspective(this._fov,this.width/this.height,this._nearZ,this._farZ);if(l[8]=2*-t.x/this.width,l[9]=2*t.y/this.height,this.isOrthographic){let i=.5*this.height/Math.tan(this._fov/2)*1*Math.tan(.5*this._fov),o=i*this.aspect,s=-o,r=-i;o-=t.x,s-=t.x,i+=t.y,r+=t.y,a=this._camera.getCameraToClipOrthographic(s,o,r,i,this._nearZ,this._farZ),((t,i,o,s)=>{for(let r=0;r<16;r++)t[r]=e.ak(i[r],o[r],s);})(a,a,l,e.d0(this.pitch>=lo?1:this.pitch/lo));}else a=l;const c=e.cP([],l,n);let h=e.cP([],a,n);if(this.projection.isReprojectedInTileSpace){const t=this.locationCoordinate(this.center),i=e.bA([]);e.br(i,i,[t.x*this.worldSize,t.y*this.worldSize,0]),e.aB(i,i,e.cQ(this)),e.br(i,i,[-t.x*this.worldSize,-t.y*this.worldSize,0]),e.aB(h,h,i),e.aB(c,c,i),this.inverseAdjustmentMatrix=e.cR(this);}else this.inverseAdjustmentMatrix=[1,0,0,1];if(this.mercatorMatrix=e.cS([],h,[this.worldSize,this.worldSize,this.worldSize/r,1]),this.projMatrix=h,this.invProjMatrix=e.bl(new Float64Array(16),this.projMatrix),i){const i=this._camera.getCameraToClipPerspective(this._fov,this.width/this.height,this._nearZ,1/0);i[8]=2*-t.x/this.width,i[9]=2*t.y/this.height,this.expandedFarZProjMatrix=e.cP([],i,n);}else this.expandedFarZProjMatrix=this.projMatrix;const d=e.bl([],a);this.frustumCorners=e.cT.fromInvProjectionMatrix(d,this.horizonLineFromTop(),this.height),this.cameraFrustum=e.cB.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,0,!i);const u=new Float32Array(16);e.bA(u),e.cS(u,u,[1,-1,1]),e.cU(u,u,this._pitch),e.bB(u,u,this.angle);const _=e.cd(new Float32Array(16),this._fov,this.width/this.height,this._nearZ,this._farZ);this.starsProjMatrix=e.bz(_);const p=(Math.PI/2-this._pitch)*(this.height/this._fov)*this._horizonShift;_[8]=2*-t.x/this.width,_[9]=2*(t.y+p)/this.height,this.skyboxMatrix=e.aB(u,_,u);const f=this.point,m=f.x,g=f.y,v=this.width%2/2,y=this.height%2/2,x=Math.cos(this.angle),b=Math.sin(this.angle),w=m-Math.round(m)+x*v+b*y,T=g-Math.round(g)+x*y+b*v,E=new Float64Array(h);if(e.br(E,E,[w>.5?w-1:w,T>.5?T-1:T,0]),this.alignedProjMatrix=E,h=e.bC(),e.cS(h,h,[this.width/2,-this.height/2,1]),e.br(h,h,[1,-1,0]),this.labelPlaneMatrix=h,h=e.bC(),e.cS(h,h,[1,-1,1]),e.br(h,h,[-1,-1,0]),e.cS(h,h,[2/this.width,2/this.height,1]),this.glCoordMatrix=h,this.pixelMatrix=e.aB(new Float64Array(16),this.labelPlaneMatrix,c),this._calcFogMatrices(),this._distanceTileDataCache={},h=e.bl(new Float64Array(16),this.pixelMatrix),!h)throw new Error("failed to invert matrix");if(this.pixelMatrixInverse=h,"globe"===this.projection.name||this.mercatorFromTransition){this.globeMatrix=e.cV(this);const t=[this.globeMatrix[12],this.globeMatrix[13],this.globeMatrix[14]];this.globeCenterInViewSpace=e.af(t,t,n),this.globeRadius=this.worldSize/2/Math.PI-1;}else this.globeMatrix=h;this._projMatrixCache={},this._alignedProjMatrixCache={},this._pixelsToTileUnitsCache={},this._expandedProjMatrixCache={};}_calcFogMatrices(){this._fogTileMatrixCache={};const t=this.cameraWorldSizeForFog,i=this.cameraPixelsPerMeter,o=this._camera.position,s=1/this.height/this._pixelsPerMercatorPixel,r=[t,t,i];e.c5(r,r,s),e.c5(o,o,-1),e.cW(o,o,r);const n=e.bC();e.br(n,n,o),e.cS(n,n,r),this.mercatorFogMatrix=n,this.worldToFogMatrix=this._camera.getWorldToCameraPosition(t,i,s);}_computeCameraPosition(e){const t=(e=e||this.pixelsPerMeter)/this.pixelsPerMeter,i=this._camera.forward(),o=this.point,s=this._mercatorZfromZoom(this._seaLevelZoom?this._seaLevelZoom:this._zoom)*t-e/this.worldSize*this._centerAltitude;return [o.x/this.worldSize-i[0]*s,o.y/this.worldSize-i[1]*s,e/this.worldSize*this._centerAltitude-i[2]*s]}_updateCameraState(){this.height&&(this._camera.setPitchBearing(this._pitch,this.angle),this._camera.position=this._computeCameraPosition());}_translateCameraConstrained(t){const i=this._maxCameraBoundsDistance()*Math.cos(this._pitch),o=this._camera.position[2],s=t[2];let r=1;this.projection.wrap&&(this.center=this.center.wrap()),s>0&&(r=Math.min((i-o)/s,1)),this._camera.position=e.bH([],this._camera.position,t,r),this._updateStateFromCamera();}_updateStateFromCamera(){const t=this._camera.position,i=this._camera.forward(),{pitch:o,bearing:s}=this._camera.getPitchBearing(),r=e.cf(this._centerAltitude,this.center.lat)*this._pixelsPerMercatorPixel,n=this._mercatorZfromZoom(this._maxZoom)*Math.cos(e.an(this._maxPitch)),a=Math.max((t[2]-r)/Math.cos(o),n),l=this._zoomFromMercatorZ(a);e.bH(t,t,i,a),this._pitch=e.aA(o,e.an(this.minPitch),e.an(this.maxPitch)),this.angle=e.bT(s,-Math.PI,Math.PI),this._setZoom(e.aA(l,this._minZoom,this._maxZoom)),this._updateSeaLevelZoom(),this._center=this.coordinateLocation(new e.ae(t[0],t[1],t[2])),this._unmodified=!1,this._constrain(),this._calcMatrices();}_worldSizeFromZoom(e){return Math.pow(2,e)*this.tileSize}_mercatorZfromZoom(e){return this.cameraToCenterDistance/this._worldSizeFromZoom(e)}_minimumHeightOverTerrain(){const e=Math.min(null!=this._seaLevelZoom?this._seaLevelZoom:this._zoom,this._maxZoom)+4;return this._mercatorZfromZoom(e)}_zoomFromMercatorZ(e){return this.scaleZoom(this.cameraToCenterDistance/(Math.max(0,e)*this.tileSize))}zoomFromMercatorZAdjusted(t){let i=0,o=e.cL,s=0,r=1/0;for(;o-i>1e-6&&o>i;){const e=i+.5*(o-i),n=this.tileSize*Math.pow(2,e),a=this.getCameraToCenterDistance(this.projection,e,n),l=this.scaleZoom(a/(Math.max(0,t)*this.tileSize)),c=Math.abs(e-l);c<r&&(r=c,s=e),e<l?i=e:o=e;}return s}_terrainEnabled(){return !(!this._elevation||!this.projection.supportsTerrain&&(e.w("Terrain is not yet supported with alternate projections. Use mercator or globe to enable terrain."),1))}anyCornerOffEdge(t,i){const o=Math.min(t.x,i.x),s=Math.max(t.x,i.x),r=Math.min(t.y,i.y),n=Math.max(t.y,i.y);if(r<this.horizonLineFromTop(!1))return !0;if("mercator"!==this.projection.name)return !1;const a=[new e.P(o,r),new e.P(s,n),new e.P(o,n),new e.P(s,r)],l=this.renderWorldCopies?-3:0,c=this.renderWorldCopies?4:1;for(const e of a){const t=this.pointRayIntersection(e);if(t.t<0)return !0;const i=this.rayIntersectionCoordinate(t);if(i.x<l||i.y<0||i.x>c||i.y>1)return !0}return !1}isHorizonVisible(){return this.pitch+e.cX(this.fovAboveCenter)>88||this.anyCornerOffEdge(new e.P(0,0),new e.P(this.width,this.height))}zoomDeltaToMovement(t,i){const o=e.ag(e.av([],this._camera.position,t)),s=this._zoomFromMercatorZ(o)+i;return o-this._mercatorZfromZoom(s)}getCameraPoint(){if("globe"===this.projection.name){const t=function([t,i,o],s){const r=[t,i,o,1];e.aC(r,r,s);const n=r[3]=Math.max(r[3],1e-6);return r[0]/=n,r[1]/=n,r[2]/=n,r}([this.globeMatrix[12],this.globeMatrix[13],this.globeMatrix[14]],this.pixelMatrix);return new e.P(t[0],t[1])}{const t=Math.tan(this._pitch)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new e.P(0,t))}}getCameraToCenterDistance(t,i=this.zoom,o=this.worldSize){const s=e.cO(t,i,this.width,this.height,1024),r=t.pixelSpaceConversion(this.center.lat,o,s);let n=.5/Math.tan(.5*this._fov)*this.height*r;return this.isOrthographic&&(n=e.ak(1,n,e.d0(this.pitch>=lo?1:this.pitch/lo))),n}getWorldToCameraMatrix(){const t=this._camera.getWorldToCamera(this.worldSize,"meters"===this.projection.zAxisUnit?this.pixelsPerMeter:1);return "globe"===this.projection.name&&e.aB(t,t,this.globeMatrix),t}getFrustum(t){return e.cB.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,t,"meters"===this.projection.zAxisUnit)}}const ho=(t,i)=>{if(i>0&&t.terrain&&e.w("Cutoff is currently disabled on terrain"),i<=0||t.terrain)return {shouldRenderCutoff:!1,uniformValues:{u_cutoff_params:[0,0,0,1]}};const o=t.transform,s=Math.max(Math.abs(o._zoom-(t.minCutoffZoom-1)),1),r=o.isLODDisabled(!1)?e.ah(60,45,o.pitch):e.ah(30,15,o.pitch),n=o._farZ-o._nearZ,a=i*o.height,l=((1-(c=r))*o.cameraToCenterDistance+c*(o._farZ+a))*s;var c;return {shouldRenderCutoff:r<1,uniformValues:{u_cutoff_params:[o._nearZ,o._farZ,(l-o._nearZ)/n,(l-a-o._nearZ)/n]}}},uo=2048;class _o{constructor(e,t){this.aabb=e,this.lastCascade=t;}}class po{add(e,t){const i=this.receivers[e.key];void 0!==i?(i.aabb.min[0]=Math.min(i.aabb.min[0],t.min[0]),i.aabb.min[1]=Math.min(i.aabb.min[1],t.min[1]),i.aabb.min[2]=Math.min(i.aabb.min[2],t.min[2]),i.aabb.max[0]=Math.max(i.aabb.max[0],t.max[0]),i.aabb.max[1]=Math.max(i.aabb.max[1],t.max[1]),i.aabb.max[2]=Math.max(i.aabb.max[2],t.max[2])):this.receivers[e.key]=new _o(t,null);}clear(){this.receivers={};}get(e){return this.receivers[e.key]}computeRequiredCascades(t,i,o){const s=e.d9.fromPoints(t.points);let r=0;for(const t in this.receivers){const n=this.receivers[t];if(!n)continue;if(!s.intersectsAabb(n.aabb))continue;n.aabb.min=s.closestPoint(n.aabb.min),n.aabb.max=s.closestPoint(n.aabb.max);const a=n.aabb.getCorners();for(let t=0;t<o.length;t++){let s=!0;for(const r of a){const n=[r[0]*i,r[1]*i,r[2]];if(e.af(n,n,o[t].matrix),n[0]<-1||n[0]>1||n[1]<-1||n[1]>1){s=!1;break}}if(n.lastCascade=t,r=Math.max(r,t),s)break}}return r+1}}class fo{constructor(e){this.painter=e,this._enabled=!1,this._shadowLayerCount=0,this._numCascadesToRender=0,this._cascades=[],this._groundShadowTiles=[],this._receivers=new po,this._depthMode=new Xi(e.context.gl.LEQUAL,Xi.ReadWrite,[0,1]),this._uniformValues={u_light_matrix_0:new Float32Array(16),u_light_matrix_1:new Float32Array(16),u_shadow_intensity:0,u_fade_range:[0,0],u_shadow_normal_offset:[1,1,1],u_shadow_texel_size:1,u_shadow_map_resolution:1,u_shadow_direction:[0,0,1],u_shadow_bias:[36e-5,.0012,.012],u_shadowmap_0:0,u_shadowmap_1:0},this._forceDisable=!1,this.useNormalOffset=!1;}destroy(){for(const e of this._cascades)e.texture.destroy(),e.framebuffer.destroy();this._cascades=[];}updateShadowParameters(t,i){const o=this.painter;if(this._enabled=!1,this._shadowLayerCount=0,this._receivers.clear(),!i||!i.properties)return;const s=i.properties.get("shadow-intensity");if(!i.shadowsEnabled()||s<=0)return;if(this._shadowLayerCount=o.style.order.reduce(((e,i)=>{const s=o.style._mergedLayers[i];return e+(s.hasShadowPass()&&!s.isHidden(t.zoom)?1:0)}),0),this._enabled=this._shadowLayerCount>0,!this.enabled)return;const r=o.context,n=uo,a=uo;if(0===this._cascades.length||uo!==this._cascades[0].texture.size[0]){this._cascades=[];for(let t=0;t<2;++t){const t=o._shadowMapDebug,i=r.gl,s=r.createFramebuffer(n,a,t?1:0,"texture"),l=new e.T(r,{width:n,height:a,data:null},i.DEPTH_COMPONENT16);if(s.depthAttachment.set(l.texture),t){const t=new e.T(r,{width:n,height:a,data:null},i.RGBA8);s.colorAttachment0.set(t.texture);}this._cascades.push({framebuffer:s,texture:l,matrix:[],far:0,boundingSphereRadius:0,frustum:new e.cB,scale:0});}}this.shadowDirection=go(i);let l=0;if(t.elevation){const e=t.elevation,i=[1e4,-1e4];e.visibleDemTiles.filter((e=>e.dem)).forEach((e=>{const t=e.dem.tree;i[0]=Math.min(i[0],t.minimums[0]),i[1]=Math.max(i[1],t.maximums[0]);})),1e4!==i[0]&&(l=(i[1]-i[0])*e.exaggeration());}const c=1.5*t.cameraToCenterDistance,h=3*c,d=new Float64Array(16);for(let i=0;i<this._cascades.length;++i){const o=this._cascades[i];let s=t.height/50,r=1;0===i?r=c:(s=c,r=h);const[n,a]=yo(t,this.shadowDirection,s,r,uo,l);o.scale=t.scale,o.matrix=n,o.boundingSphereRadius=a,e.bl(d,o.matrix),o.frustum=e.cB.fromInvProjectionMatrix(d,1,0,!0),o.far=r;}const u=this._cascades.length-1;this._uniformValues.u_fade_range=[.75*this._cascades[u].far,this._cascades[u].far],this._uniformValues.u_shadow_intensity=s,this._uniformValues.u_shadow_direction=[this.shadowDirection[0],this.shadowDirection[1],this.shadowDirection[2]],this._uniformValues.u_shadow_texel_size=.00048828125,this._uniformValues.u_shadow_map_resolution=uo,this._uniformValues.u_shadowmap_0=no.ShadowMap0,this._uniformValues.u_shadowmap_1=no.ShadowMap0+1,this._groundShadowTiles=o.transform.coveringTiles({tileSize:512,renderWorldCopies:!0});const _=o.transform.elevation;for(const e of this._groundShadowTiles){let t={min:0,max:0};if(_){const i=_.getMinMaxForTile(e);i&&(t=i);}this.addShadowReceiver(e.toUnwrapped(),t.min,t.max);}}get enabled(){return this._enabled&&!this._forceDisable}set enabled(e){this._enabled=e;}drawShadowPass(t,i){if(!this.enabled)return;const o=this.painter,s=o.context;this._numCascadesToRender=this._receivers.computeRequiredCascades(o.transform.getFrustum(0),o.transform.worldSize,this._cascades),s.viewport.set([0,0,uo,uo]);for(let r=0;r<this._numCascadesToRender;++r){o.currentShadowCascade=r,s.bindFramebuffer.set(this._cascades[r].framebuff