## ----include = FALSE----------------------------------------------------------
Sys.setenv(R_USER_LIBS = tempdir())  #Just in case for CRAN
library(biodosetools)
knitr::opts_chunk$set(
  fig.dpi = 96,
  collapse = TRUE,
  comment = "#>"
)

## ----sc-interlab-01, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Data Input' box and 'Results' tabbed box in the interlaboratory comparison module when loading curves from an `.rds` file for two laboratories."----
knitr::include_graphics("figures/screenshot-interlab-01.png")

## ----load-interlab-data, tidy=TRUE, tidy.opts=list(width.cutoff=60)-----------
fit_results_A1 <- system.file("extdata", "A1_Estimation_results.rds", package = "biodosetools") %>%
  readRDS()

fit_results_A2 <- system.file("extdata", "A2_Estimation_results.rds", package = "biodosetools") %>%
  readRDS()


## ----interlab-data------------------------------------------------------------
list_lab_names <- list("A1", "A2")
all_rds <- list(fit_results_A1, fit_results_A2)

tables_list <- summary_curve_tables(
  num_labs = 2,
  list_lab_names, 
  all_rds
)

## ----summary_plots------------------------------------------------------------
yield_boxplot(
  dat =  tables_list[[1]],
  place = "UI"
)

dose_boxplot(
  dat = tables_list[[1]],
  place = "UI"
)

u_test_plot(
  dat = tables_list[[1]],
  place = "UI"
)

DI_plot(
  dat = tables_list[[1]],
  place = "UI"
)

## ----curve-plots--------------------------------------------------------------
curves_plot(
  dat = tables_list[[2]], 
  curve = "manual", 
  curve_type = "lin_quad",
  place = "UI"
)

bar_plots(
  dat = tables_list[[2]], 
  curve = "manual",
  place = "UI"
)


## ----sc-interlab-04, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Z-score Data input options' in the interlaboratory comparison module."----
knitr::include_graphics("figures/screenshot-interlab-04.png")

## ----sc-interlab-05, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Z-score Results table' in the interlaboratory comparison module."----
knitr::include_graphics("figures/screenshot-interlab-05.png")

## ----interlab-zscore----------------------------------------------------------

zscore_S1 <- calc.zValue.new(
  X =  tables_list[[1]][["estimate"]][1:2],
  type = "dose", 
  alg = "algA", 
  c = 2.56
)

zscore_S2 <- calc.zValue.new(
  X =  tables_list[[1]][["estimate"]][3:4],
  type = "dose", 
  alg = "algA", 
  c = 3.41
)

zscore_S3 <- calc.zValue.new(
  X =  tables_list[[1]][["estimate"]][5:6],
  type = "dose", 
  alg = "algA", 
  c = 4.54
)


## ----plots-interlab-zscore----------------------------------------------------

data_frame_zscore <- data.frame(
          Lab = tables_list[[1]][["Lab"]],
          Sample = tables_list[[1]][["Sample"]],
          Type = tables_list[[1]][["Type"]],
          Reference = c(2.56, 3.41, 4.54),
          Dose = tables_list[[1]][["estimate"]],
          Deviation = tables_list[[1]][["estimate"]] - c(2.56, 3.41, 4.54),
          Zscore = c(zscore_S1, zscore_S2, zscore_S3),
          stringsAsFactors = FALSE
        )

plot_1 <- plot_zscore_all(
  zscore = data_frame_zscore, 
  select_method = "algA",
  place = "UI"
)

plot_2 <- plot_deviation_all(
  zscore = data_frame_zscore, 
  select_method = "algA",
  place = "UI"
)

plot_3 <- plot_interlab_v2(
  zscore = data_frame_zscore, 
  select_method = "algA", 
  sum_table = tables_list[[1]],
  place = "UI"
)


plot_4 <- plot_interlab_deviation(
  zscore = data_frame_zscore, 
  sum_table = tables_list[[1]],
  place = "UI"
)


line_triage <- list(`1` = 2.56, `2` = 3.41, `3` = 4.54)

plot_5 <- plot_triage_interlab(
  line_triage,
  sum_table = tables_list[[1]],
  place = "UI"
)


## ----all-plots, fig.width=6, fig.height=3.5, fig.align='center', fig.cap="Plots generated by \\{biodosetools\\}."----

plot_1
plot_2
for (p in plot_3) print(p)
for (p in plot_4) print(p)
for (p in plot_5) print(p)

