/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.protobuf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jdplus.x13.base.api.regarima.EasterSpec;
import jdplus.x13.base.api.regarima.RegressionTestSpec;
import jdplus.x13.base.api.regarima.TradingDaysSpec;
import jdplus.x13.base.api.x11.CalendarSigmaOption;
import jdplus.x13.base.api.x11.SeasonalFilterOption;
import jdplus.x13.base.core.x13.X13Results;
import jdplus.x13.base.protobuf.AutomaticTradingDays;
import jdplus.x13.base.protobuf.BiasCorrection;
import jdplus.x13.base.protobuf.CalendarSigma;
import jdplus.x13.base.protobuf.DecompositionMode;
import jdplus.x13.base.protobuf.EasterType;
import jdplus.x13.base.protobuf.RegressionTest;
import jdplus.x13.base.protobuf.SeasonalFilter;
import jdplus.x13.base.protobuf.SpecProto;
import jdplus.x13.base.protobuf.X13Output;
import jdplus.x13.base.protobuf.X13ResultsProto;
import lombok.Generated;

public final class X13ProtosUtility {
    public static DecompositionMode convert(jdplus.sa.base.api.DecompositionMode mode) {
        switch (mode) {
            case Additive: {
                return DecompositionMode.MODE_ADDITIVE;
            }
            case Multiplicative: {
                return DecompositionMode.MODE_MULTIPLICATIVE;
            }
            case LogAdditive: {
                return DecompositionMode.MODE_LOGADDITIVE;
            }
            case PseudoAdditive: {
                return DecompositionMode.MODE_PSEUDOADDITIVE;
            }
        }
        return DecompositionMode.MODE_UNKNOWN;
    }

    public static jdplus.sa.base.api.DecompositionMode convert(DecompositionMode mode) {
        switch (mode) {
            case MODE_ADDITIVE: {
                return jdplus.sa.base.api.DecompositionMode.Additive;
            }
            case MODE_MULTIPLICATIVE: {
                return jdplus.sa.base.api.DecompositionMode.Multiplicative;
            }
            case MODE_LOGADDITIVE: {
                return jdplus.sa.base.api.DecompositionMode.LogAdditive;
            }
            case MODE_PSEUDOADDITIVE: {
                return jdplus.sa.base.api.DecompositionMode.PseudoAdditive;
            }
        }
        return jdplus.sa.base.api.DecompositionMode.Undefined;
    }

    public static SeasonalFilter convert(SeasonalFilterOption sf) {
        switch (sf) {
            case Stable: {
                return SeasonalFilter.SEASONAL_FILTER_STABLE;
            }
            case X11Default: {
                return SeasonalFilter.SEASONAL_FILTER_X11DEFAULT;
            }
            case S3X1: {
                return SeasonalFilter.SEASONAL_FILTER_S3X1;
            }
            case S3X3: {
                return SeasonalFilter.SEASONAL_FILTER_S3X3;
            }
            case S3X5: {
                return SeasonalFilter.SEASONAL_FILTER_S3X5;
            }
            case S3X9: {
                return SeasonalFilter.SEASONAL_FILTER_S3X9;
            }
            case S3X15: {
                return SeasonalFilter.SEASONAL_FILTER_S3X15;
            }
        }
        return SeasonalFilter.SEASONAL_FILTER_MSR;
    }

    public static SeasonalFilterOption convert(SeasonalFilter sf) {
        switch (sf) {
            case SEASONAL_FILTER_STABLE: {
                return SeasonalFilterOption.Stable;
            }
            case SEASONAL_FILTER_S3X1: {
                return SeasonalFilterOption.S3X1;
            }
            case SEASONAL_FILTER_S3X3: {
                return SeasonalFilterOption.S3X3;
            }
            case SEASONAL_FILTER_S3X5: {
                return SeasonalFilterOption.S3X5;
            }
            case SEASONAL_FILTER_S3X9: {
                return SeasonalFilterOption.S3X9;
            }
            case SEASONAL_FILTER_S3X15: {
                return SeasonalFilterOption.S3X15;
            }
            case SEASONAL_FILTER_X11DEFAULT: {
                return SeasonalFilterOption.X11Default;
            }
        }
        return SeasonalFilterOption.Msr;
    }

    public static List<SeasonalFilter> convert(SeasonalFilterOption[] sf) {
        if (sf == null || sf.length == 0) {
            return List.of();
        }
        SeasonalFilterOption sf0 = sf[0];
        boolean same = true;
        for (int i = 1; i < sf.length; ++i) {
            if (sf[i] == sf0) continue;
            same = false;
            break;
        }
        if (same) {
            return Collections.singletonList(X13ProtosUtility.convert(sf0));
        }
        return Arrays.stream(sf).map(s -> X13ProtosUtility.convert(s)).toList();
    }

    public static jdplus.x13.base.api.x11.BiasCorrection convert(BiasCorrection bias) {
        switch (bias) {
            case BIAS_LEGACY: {
                return jdplus.x13.base.api.x11.BiasCorrection.Legacy;
            }
            case BIAS_RATIO: {
                return jdplus.x13.base.api.x11.BiasCorrection.Ratio;
            }
            case BIAS_SMOOTH: {
                return jdplus.x13.base.api.x11.BiasCorrection.Smooth;
            }
        }
        return jdplus.x13.base.api.x11.BiasCorrection.None;
    }

    public static BiasCorrection convert(jdplus.x13.base.api.x11.BiasCorrection bias) {
        switch (bias) {
            case Legacy: {
                return BiasCorrection.BIAS_LEGACY;
            }
            case Ratio: {
                return BiasCorrection.BIAS_RATIO;
            }
            case Smooth: {
                return BiasCorrection.BIAS_SMOOTH;
            }
        }
        return BiasCorrection.BIAS_NONE;
    }

    public static CalendarSigma convert(CalendarSigmaOption sig) {
        switch (sig) {
            case All: {
                return CalendarSigma.SIGMA_ALL;
            }
            case Signif: {
                return CalendarSigma.SIGMA_SIGNIF;
            }
            case Select: {
                return CalendarSigma.SIGMA_SELECT;
            }
        }
        return CalendarSigma.SIGMA_NONE;
    }

    public static CalendarSigmaOption convert(CalendarSigma sig) {
        switch (sig) {
            case SIGMA_ALL: {
                return CalendarSigmaOption.All;
            }
            case SIGMA_SIGNIF: {
                return CalendarSigmaOption.Signif;
            }
            case SIGMA_SELECT: {
                return CalendarSigmaOption.Select;
            }
        }
        return CalendarSigmaOption.None;
    }

    public static RegressionTest convert(RegressionTestSpec test) {
        switch (test) {
            case Add: {
                return RegressionTest.TEST_ADD;
            }
            case Remove: {
                return RegressionTest.TEST_REMOVE;
            }
        }
        return RegressionTest.TEST_NO;
    }

    public static RegressionTestSpec convert(RegressionTest test) {
        switch (test) {
            case TEST_ADD: {
                return RegressionTestSpec.Add;
            }
            case TEST_REMOVE: {
                return RegressionTestSpec.Remove;
            }
        }
        return RegressionTestSpec.None;
    }

    public static EasterSpec.Type convert(EasterType type) {
        switch (type) {
            case EASTER_STANDARD: {
                return EasterSpec.Type.Easter;
            }
            case EASTER_JULIAN: {
                return EasterSpec.Type.JulianEaster;
            }
            case EASTER_SC: {
                return EasterSpec.Type.SCEaster;
            }
        }
        return EasterSpec.Type.Unused;
    }

    public static EasterType convert(EasterSpec.Type type) {
        switch (type) {
            case Easter: {
                return EasterType.EASTER_STANDARD;
            }
            case JulianEaster: {
                return EasterType.EASTER_JULIAN;
            }
            case SCEaster: {
                return EasterType.EASTER_SC;
            }
        }
        return EasterType.EASTER_UNUSED;
    }

    public static AutomaticTradingDays convert(TradingDaysSpec.AutoMethod auto) {
        switch (auto) {
            case WALD: {
                return AutomaticTradingDays.TD_AUTO_WALD;
            }
            case BIC: {
                return AutomaticTradingDays.TD_AUTO_BIC;
            }
            case AIC: {
                return AutomaticTradingDays.TD_AUTO_AIC;
            }
        }
        return AutomaticTradingDays.TD_AUTO_NO;
    }

    public static TradingDaysSpec.AutoMethod convert(AutomaticTradingDays auto) {
        return switch (auto) {
            case AutomaticTradingDays.TD_AUTO_WALD -> TradingDaysSpec.AutoMethod.WALD;
            case AutomaticTradingDays.TD_AUTO_BIC -> TradingDaysSpec.AutoMethod.BIC;
            case AutomaticTradingDays.TD_AUTO_AIC -> TradingDaysSpec.AutoMethod.AIC;
            default -> TradingDaysSpec.AutoMethod.UNUSED;
        };
    }

    public static X13Output convert(jdplus.x13.base.core.x13.X13Output output) {
        X13Output.Builder builder = X13Output.newBuilder().setEstimationSpec(SpecProto.convert(output.getEstimationSpec()));
        X13Results result = output.getResult();
        if (result != null && result.isValid()) {
            builder.setResult(X13ResultsProto.convert(result)).setResultSpec(SpecProto.convert(output.getResultSpec()));
        }
        return builder.build();
    }

    @Generated
    private X13ProtosUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

