/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import java.util.Arrays;
import java.util.Comparator;
import jdplus.sa.base.core.regarima.AutomaticTradingRegressionModule;
import jdplus.toolkit.base.api.timeseries.regression.IEasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.ILengthOfPeriodVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.regsarima.regular.TradingDaysRegressionComparator;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;
import jdplus.tramoseats.base.core.tramo.TramoModelBuilder;

public class AutomaticRegressionTest
implements AutomaticTradingRegressionModule {
    public static final double DEF_TMEAN = 1.96;
    public static final double DEF_TLP = 2.0;
    public static final double DEF_TEASTER = 2.2;
    private final ITradingDaysVariable[] td;
    private final ILengthOfPeriodVariable lp;
    private final IEasterVariable easter;
    private final double tmean;
    private final double teaster;
    private final double tlp;
    private final boolean testMean;
    private final double precision;
    private final boolean aic;
    private final boolean adjust;

    public static Builder builder() {
        return new Builder();
    }

    private AutomaticRegressionTest(Builder builder) {
        this.td = builder.td;
        this.lp = builder.lp;
        this.easter = builder.easter;
        this.tmean = builder.tmean;
        this.teaster = builder.teaster;
        this.tlp = builder.tlp;
        this.testMean = builder.testMean;
        this.precision = builder.precision;
        this.aic = builder.aic;
        this.adjust = builder.adjust;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult test(RegSarimaModelling context) {
        context.getLog().push("automatic trading days selection");
        try {
            ModelDescription current = context.getDescription();
            RegArimaEstimation[] estimations = TradingDaysRegressionComparator.test((ModelDescription)current, (ITradingDaysVariable[])this.td, (ILengthOfPeriodVariable)this.lp, (double)this.precision);
            int best = this.aic ? TradingDaysRegressionComparator.bestModel((RegArimaEstimation[])estimations, (Comparator)TradingDaysRegressionComparator.aiccComparator()) : TradingDaysRegressionComparator.bestModel((RegArimaEstimation[])estimations, (Comparator)TradingDaysRegressionComparator.bicComparator());
            ITradingDaysVariable tdsel = best < 2 ? null : this.td[best - 2];
            ILengthOfPeriodVariable lpsel = best < 1 ? null : this.lp;
            AutomaticTradingRegressionModule.Info info = new AutomaticTradingRegressionModule.Info(AutomaticTradingRegressionModule.modelNames((ITradingDaysVariable[])this.td), (LikelihoodStatistics[])Arrays.stream(estimations).map(e -> e == null ? null : e.statistics()).toArray(LikelihoodStatistics[]::new), best);
            context.getLog().info("selected trading days: " + info.getNames()[best], (Object)info);
            IRegArimaComputer processor = RegArimaUtility.processor((boolean)true, (double)this.precision);
            ModelDescription model = this.createTestModel(context, tdsel, lpsel);
            RegArimaEstimation regarima = processor.process(model.regarima(), model.mapping());
            int nhp = current.getArimaSpec().freeParametersCount();
            ProcessingResult processingResult = this.update(current, model, tdsel, lpsel, regarima.getConcentratedLikelihood(), nhp);
            return processingResult;
        }
        catch (RuntimeException ex) {
            context.getLog().remark("automatic trading days selection failed");
            ProcessingResult processingResult = ProcessingResult.Failed;
            return processingResult;
        }
        finally {
            context.getLog().pop();
        }
    }

    private ModelDescription createTestModel(RegSarimaModelling context, ITradingDaysVariable td, ILengthOfPeriodVariable lp) {
        ModelDescription tmp = ModelDescription.copyOf((ModelDescription)context.getDescription());
        tmp.setAirline(true);
        tmp.setMean(true);
        if (td != null) {
            tmp.addVariable(Variable.variable((String)"td", (ITsVariable)td, TramoModelBuilder.calendarAMI));
        }
        if (lp != null) {
            tmp.addVariable(Variable.variable((String)"lp", (ITsVariable)lp, TramoModelBuilder.calendarAMI));
        }
        if (this.easter != null) {
            tmp.addVariable(Variable.variable((String)"easter", (ITsVariable)this.easter, TramoModelBuilder.calendarAMI));
        }
        return tmp;
    }

    private ProcessingResult update(ModelDescription current, ModelDescription test, ITradingDaysVariable aTd, ILengthOfPeriodVariable aLp, ConcentratedLikelihoodWithMissing ll, int nhp) {
        int pos;
        double tstat;
        boolean preadjustment;
        boolean changed = false;
        boolean bl = preadjustment = this.adjust && current.isLogTransformation();
        if (aTd != null) {
            current.addVariable(Variable.variable((String)"td", (ITsVariable)aTd, TramoModelBuilder.calendarAMI));
        }
        if (this.testMean) {
            boolean mean;
            boolean bl2 = mean = Math.abs(ll.tstat(0, nhp, true)) > this.tmean;
            if (mean != current.isMean()) {
                current.setMean(mean);
                changed = true;
            }
        }
        if (aLp != null && Math.abs(tstat = ll.tstat(pos = test.findPosition((ITsVariable)aLp), nhp, true)) > this.tlp) {
            if (preadjustment && tstat > 0.0) {
                current.setPreadjustment(this.lp.getType());
            } else {
                current.addVariable(Variable.variable((String)"lp", (ITsVariable)this.lp, TramoModelBuilder.calendarAMI));
            }
            changed = true;
        }
        if (this.easter != null && Math.abs(ll.tstat(pos = test.findPosition((ITsVariable)this.easter), nhp, true)) > this.teaster) {
            current.addVariable(Variable.variable((String)"easter", (ITsVariable)this.easter, TramoModelBuilder.calendarAMI));
            changed = true;
        }
        return changed ? ProcessingResult.Changed : ProcessingResult.Unchanged;
    }

    public static class Builder {
        private ITradingDaysVariable[] td;
        private ILengthOfPeriodVariable lp;
        private IEasterVariable easter;
        private boolean aic = true;
        private double tmean = 1.96;
        private double tlp = 2.0;
        private double teaster = 2.2;
        private boolean testMean = true;
        private double precision = 1.0E-5;
        private boolean adjust = false;

        public Builder tradingDays(ITradingDaysVariable[] td) {
            this.td = (ITradingDaysVariable[])td.clone();
            return this;
        }

        public Builder leapYear(ILengthOfPeriodVariable lp) {
            this.lp = lp;
            return this;
        }

        public Builder easter(IEasterVariable easter) {
            this.easter = easter;
            return this;
        }

        public Builder meanThreshold(double tmean) {
            this.tmean = tmean;
            return this;
        }

        public Builder easterThreshold(double teaster) {
            this.teaster = teaster;
            return this;
        }

        public Builder lpThreshold(double tlp) {
            this.tlp = tlp;
            return this;
        }

        public Builder testMean(boolean test) {
            this.testMean = test;
            return this;
        }

        public Builder estimationPrecision(double eps) {
            this.precision = eps;
            return this;
        }

        public Builder aic() {
            this.aic = true;
            return this;
        }

        public Builder bic() {
            this.aic = false;
            return this;
        }

        public Builder adjust(boolean adjust) {
            this.adjust = adjust;
            return this;
        }

        public AutomaticRegressionTest build() {
            return new AutomaticRegressionTest(this);
        }
    }
}

