/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.QuadraticForm;
import jdplus.toolkit.base.core.ssf.arima.SsfArima;
import jdplus.toolkit.base.core.ssf.dk.FastDkFilter;
import jdplus.toolkit.base.core.ssf.dk.sqrt.DefaultDiffuseSquareRootFilteringResults;
import jdplus.toolkit.base.core.ssf.dk.sqrt.DiffuseSquareRootInitializer;
import jdplus.toolkit.base.core.ssf.univariate.OrdinaryFilter;
import jdplus.toolkit.base.core.ssf.univariate.Ssf;
import jdplus.toolkit.base.core.ssf.univariate.SsfData;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class RegArimaForecasts {
    public static <M extends IArimaModel> Result calcForecast(@NonNull IArimaModel arima, @NonNull DoubleSeq y, @NonNull Matrix X, @NonNull DoubleSeq b, @NonNull Matrix varB, double sig2) {
        if (arima == null) {
            throw new NullPointerException("arima is marked non-null but is null");
        }
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        if (X == null) {
            throw new NullPointerException("X is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        if (varB == null) {
            throw new NullPointerException("varB is marked non-null but is null");
        }
        return RegArimaForecasts.calcForecast(arima, y, X.getRowsCount() - y.length(), X, b, varB, sig2);
    }

    public static <M extends IArimaModel> Result calcForecast(@NonNull IArimaModel arima, @NonNull DoubleSeq y, int nf, double sig2) {
        if (arima == null) {
            throw new NullPointerException("arima is marked non-null but is null");
        }
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        return RegArimaForecasts.calcForecast(arima, y, nf, null, null, null, sig2);
    }

    private static <M extends IArimaModel> Result calcForecast(IArimaModel arima, DoubleSeq y, int nf, Matrix X, DoubleSeq b, Matrix varb, double sig2) {
        int n = y.length();
        int nall = n + nf;
        double[] yall = new double[nall];
        y.copyTo(yall, 0);
        for (int i = n; i < nall; ++i) {
            yall[i] = Double.NaN;
        }
        Ssf ssf = SsfArima.ssf(arima);
        DefaultDiffuseSquareRootFilteringResults fr2 = DefaultDiffuseSquareRootFilteringResults.full();
        fr2.prepare(ssf, 0, nall);
        DiffuseSquareRootInitializer initializer = new DiffuseSquareRootInitializer(fr2);
        OrdinaryFilter of = new OrdinaryFilter(initializer);
        of.process(ssf, new SsfData(yall), fr2);
        FastDkFilter filter = new FastDkFilter(ssf, fr2, false);
        int nx = X == null ? 0 : X.getColumnsCount();
        double[] f = new double[nf];
        double[] vf = new double[nf];
        fr2.getComponent(0).drop(n, 0).copyTo(f, 0);
        fr2.getComponentVariance(0).drop(n, 0).copyTo(vf, 0);
        int i = 0;
        while (i < nf) {
            int n2 = i++;
            vf[n2] = vf[n2] * sig2;
        }
        if (nx > 0) {
            FastMatrix xall = FastMatrix.of(X);
            filter.filter(xall);
            FastMatrix dx = xall.extract(n, nf, 0, nx);
            DataBlockIterator xrows = dx.rowsIterator();
            int j = 0;
            FastMatrix V = FastMatrix.of(varb);
            while (xrows.hasNext()) {
                DataBlock xrow = xrows.next();
                int n3 = j;
                f[n3] = f[n3] + xrow.dot(b);
                int n4 = j++;
                vf[n4] = vf[n4] + QuadraticForm.apply(V, xrow);
            }
        }
        for (i = 0; i < nf; ++i) {
            vf[i] = Math.sqrt(vf[i]);
        }
        return new Result(f, vf);
    }

    @Generated
    private RegArimaForecasts() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class Result {
        private final double[] forecasts;
        private final double[] forecastsStdev;

        @Generated
        public Result(double[] forecasts, double[] forecastsStdev) {
            this.forecasts = forecasts;
            this.forecastsStdev = forecastsStdev;
        }

        @Generated
        public double[] getForecasts() {
            return this.forecasts;
        }

        @Generated
        public double[] getForecastsStdev() {
            return this.forecastsStdev;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!Arrays.equals(this.getForecasts(), other.getForecasts())) {
                return false;
            }
            return Arrays.equals(this.getForecastsStdev(), other.getForecastsStdev());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getForecasts());
            result = result * 59 + Arrays.hashCode(this.getForecastsStdev());
            return result;
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "RegArimaForecasts.Result(forecasts=" + Arrays.toString(this.getForecasts()) + ", forecastsStdev=" + Arrays.toString(this.getForecastsStdev()) + ")";
        }
    }
}

