/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.random;

import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;

public abstract class AbstractRNG
implements RandomNumberGenerator {
    private static final double IntToDoubleMultiplier = 4.656612873077393E-10;

    public double nextDouble() {
        return (double)(this.nextInt() >>> 1) * 4.656612873077393E-10;
    }

    public long nextLong() {
        return ((long)this.nextInt() & 0xFFFFFFFFL) << 32 | (long)this.nextInt() & 0xFFFFFFFFL;
    }

    public boolean nextBoolean() {
        return this.nextInt() % 2 != 0;
    }

    public float nextFloat() {
        return (float)this.nextDouble();
    }

    public int nextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        int result = (int)(this.nextDouble() * (double)n);
        return result < n ? result : n - 1;
    }

    public RandomNumberGenerator synchronize() {
        return new SynchronizedRNG(this);
    }

    private static final class SynchronizedRNG
    implements RandomNumberGenerator {
        private final RandomNumberGenerator rng;

        private SynchronizedRNG(RandomNumberGenerator rng) {
            this.rng = rng;
        }

        public synchronized double nextDouble() {
            return this.rng.nextDouble();
        }

        public synchronized int nextInt() {
            return this.rng.nextInt();
        }

        public synchronized long nextLong() {
            return this.rng.nextLong();
        }

        public synchronized boolean nextBoolean() {
            return this.rng.nextBoolean();
        }

        public synchronized float nextFloat() {
            return this.rng.nextFloat();
        }

        public synchronized int nextInt(int n) throws IllegalArgumentException {
            return this.rng.nextInt(n);
        }

        public RandomNumberGenerator synchronize() {
            return this;
        }
    }
}

