/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.r.modelling;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import jdplus.toolkit.base.api.data.Range;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.calendars.Calendar;
import jdplus.toolkit.base.api.timeseries.calendars.DayClustering;
import jdplus.toolkit.base.api.timeseries.calendars.GenericTradingDays;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.timeseries.regression.AdditiveOutlier;
import jdplus.toolkit.base.api.timeseries.regression.EasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.HolidaysCorrectedTradingDays;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.InterventionVariable;
import jdplus.toolkit.base.api.timeseries.regression.JulianEasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.LengthOfPeriod;
import jdplus.toolkit.base.api.timeseries.regression.LevelShift;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicContrasts;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicDummies;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicOutlier;
import jdplus.toolkit.base.api.timeseries.regression.Ramp;
import jdplus.toolkit.base.api.timeseries.regression.StockTradingDays;
import jdplus.toolkit.base.api.timeseries.regression.TransitoryChange;
import jdplus.toolkit.base.api.timeseries.regression.TrigonometricVariables;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.GenericTradingDaysFactory;
import jdplus.toolkit.base.core.modelling.regression.HolidaysCorrectionFactory;
import jdplus.toolkit.base.core.modelling.regression.Regression;
import jdplus.toolkit.base.core.modelling.regression.TrigonometricVariablesFactory;
import lombok.Generated;

public final class Variables {
    public static Matrix td(TsDomain domain, int[] groups, boolean contrasts) {
        DayClustering dc = DayClustering.of((int[])groups);
        if (contrasts) {
            GenericTradingDays gtd = GenericTradingDays.contrasts((DayClustering)dc);
            FastMatrix m = FastMatrix.make((int)domain.getLength(), (int)(dc.getGroupsCount() - 1));
            GenericTradingDaysFactory.FACTORY.fill(gtd, domain.getStartPeriod(), m);
            return m.unmodifiable();
        }
        GenericTradingDays gtd = GenericTradingDays.raw((DayClustering)dc);
        FastMatrix m = FastMatrix.make((int)domain.getLength(), (int)dc.getGroupsCount());
        GenericTradingDaysFactory.FACTORY.fill(gtd, domain.getStartPeriod(), m);
        return m.unmodifiable();
    }

    public static Matrix htd(Calendar calendar, TsDomain domain, int[] groups, int dw, boolean contrasts) {
        DayClustering dc = DayClustering.of((int[])groups);
        HolidaysCorrectedTradingDays.HolidaysCorrector corrector = HolidaysCorrectionFactory.corrector((Calendar)calendar, (DayOfWeek)DayOfWeek.SUNDAY);
        HolidaysCorrectedTradingDays htd = HolidaysCorrectedTradingDays.builder().contrast(contrasts).clustering(dc).corrector(corrector).build();
        FastMatrix M = FastMatrix.make((int)domain.getLength(), (int)htd.dim());
        HolidaysCorrectionFactory.FACTORY.fill((ITsVariable)htd, domain.getStartPeriod(), M);
        return M;
    }

    public static double[] easter(TsDomain domain, int duration, int endpos, String corr) {
        EasterVariable.Correction correction = EasterVariable.Correction.valueOf((String)corr);
        EasterVariable easter = EasterVariable.builder().duration(duration).endPosition(endpos).meanCorrection(correction).build();
        DataBlock x = Regression.x((TimeSeriesDomain)domain, (ITsVariable)easter);
        return x.getStorage();
    }

    public static double[] julianEaster(TsDomain domain, int duration) {
        JulianEasterVariable easter = new JulianEasterVariable(duration, true);
        DataBlock x = Regression.x((TimeSeriesDomain)domain, (ITsVariable)easter);
        return x.getStorage();
    }

    public static double[] leapYear(TsDomain domain, boolean lp) {
        LengthOfPeriod lpvar = new LengthOfPeriod(lp ? LengthOfPeriodType.LeapYear : LengthOfPeriodType.LengthOfPeriod);
        DataBlock x = Regression.x((TimeSeriesDomain)domain, (ITsVariable)lpvar);
        return x.toArray();
    }

    private static double[] ao(TsDomain domain, LocalDateTime pos) {
        AdditiveOutlier ao = new AdditiveOutlier(pos);
        DataBlock x = Regression.x((TimeSeriesDomain)domain, (ITsVariable)ao);
        return x.getStorage();
    }

    public static double[] ao(TsDomain domain, String pos) {
        LocalDate dt = LocalDate.parse(pos, DateTimeFormatter.ISO_DATE);
        return Variables.ao(domain, dt.atStartOfDay());
    }

    public static double[] ao(TsDomain domain, int pos) {
        LocalDateTime dt = domain.get(pos).start();
        return Variables.ao(domain, dt);
    }

    private static double[] ls(TsDomain domain, LocalDateTime pos, boolean zeroended) {
        LevelShift ls = new LevelShift(pos, zeroended);
        DataBlock x = Regression.x((TimeSeriesDomain)domain, (ITsVariable)ls);
        return x.getStorage();
    }

    public static double[] ls(TsDomain domain, String pos, boolean zeroended) {
        LocalDate dt = LocalDate.parse(pos, DateTimeFormatter.ISO_DATE);
        return Variables.ls(domain, dt.atStartOfDay(), zeroended);
    }

    public static double[] ls(TsDomain domain, int pos, boolean zeroended) {
        LocalDateTime dt = domain.get(pos).start();
        return Variables.ls(domain, dt, zeroended);
    }

    private static double[] so(TsDomain domain, LocalDateTime pos, boolean zeroended) {
        PeriodicOutlier so = new PeriodicOutlier(pos, domain.getAnnualFrequency(), zeroended);
        DataBlock x = Regression.x((TimeSeriesDomain)domain, (ITsVariable)so);
        return x.getStorage();
    }

    public static double[] so(TsDomain domain, String pos, boolean zeroended) {
        LocalDate dt = LocalDate.parse(pos, DateTimeFormatter.ISO_DATE);
        return Variables.so(domain, dt.atStartOfDay(), zeroended);
    }

    public static double[] so(TsDomain domain, int pos, boolean zeroended) {
        LocalDateTime dt = domain.get(pos).start();
        return Variables.so(domain, dt, zeroended);
    }

    private static double[] tc(TsDomain domain, LocalDateTime pos, double delta) {
        TransitoryChange tc = new TransitoryChange(pos, delta);
        DataBlock x = Regression.x((TimeSeriesDomain)domain, (ITsVariable)tc);
        return x.getStorage();
    }

    public static double[] tc(TsDomain domain, String pos, double delta) {
        LocalDate dt = LocalDate.parse(pos, DateTimeFormatter.ISO_DATE);
        return Variables.tc(domain, dt.atStartOfDay(), delta);
    }

    public static double[] tc(TsDomain domain, int pos, double delta) {
        LocalDateTime dt = domain.get(pos).start();
        return Variables.tc(domain, dt, delta);
    }

    private static double[] ramp(TsDomain domain, LocalDateTime start, LocalDateTime end) {
        Ramp ramp = new Ramp(start, end);
        DataBlock x = Regression.x((TimeSeriesDomain)domain, (ITsVariable)ramp);
        return x.getStorage();
    }

    public static double[] ramp(TsDomain domain, String start, String end) {
        LocalDate d0 = LocalDate.parse(start, DateTimeFormatter.ISO_DATE);
        LocalDate d1 = LocalDate.parse(end, DateTimeFormatter.ISO_DATE);
        return Variables.ramp(domain, d0.atStartOfDay(), d1.atStartOfDay());
    }

    public static double[] ramp(TsDomain domain, int start, int end) {
        return Variables.ramp(domain, domain.get(start).start(), domain.get(end).start());
    }

    public static Matrix stockTradingDays(TsDomain domain, int w) {
        StockTradingDays std = new StockTradingDays(w);
        return Regression.matrix((TimeSeriesDomain)domain, (ITsVariable[])new ITsVariable[]{std});
    }

    public static Matrix periodicDummies(TsDomain domain) {
        PeriodicDummies var = new PeriodicDummies(domain.getAnnualFrequency());
        return Regression.matrix((TimeSeriesDomain)domain, (ITsVariable[])new ITsVariable[]{var});
    }

    public static Matrix periodicContrasts(TsDomain domain) {
        PeriodicContrasts var = new PeriodicContrasts(domain.getAnnualFrequency());
        return Regression.matrix((TimeSeriesDomain)domain, (ITsVariable[])new ITsVariable[]{var});
    }

    public static Matrix trigonometricVariables(TsDomain domain, int[] seasonal) {
        TrigonometricVariables var = seasonal == null ? TrigonometricVariables.regular((int)domain.getAnnualFrequency()) : TrigonometricVariables.regular((int)domain.getAnnualFrequency(), (int[])seasonal);
        return Regression.matrix((TimeSeriesDomain)domain, (ITsVariable[])new ITsVariable[]{var});
    }

    public static Matrix trigonometricVariables(TsDomain domain, int[] seasonal, String reference) {
        LocalDate ref = LocalDate.parse(reference, DateTimeFormatter.ISO_DATE);
        TrigonometricVariables var = seasonal == null ? TrigonometricVariables.regular((int)domain.getAnnualFrequency(), (LocalDateTime)ref.atStartOfDay()) : TrigonometricVariables.regular((int)domain.getAnnualFrequency(), (int[])seasonal, (LocalDateTime)ref.atStartOfDay());
        return Regression.matrix((TimeSeriesDomain)domain, (ITsVariable[])new ITsVariable[]{var});
    }

    public static Matrix trigonometricVariables(double[] freq, int length, int start) {
        TrigonometricVariables var = new TrigonometricVariables(freq, TsPeriod.DEFAULT_EPOCH);
        return TrigonometricVariablesFactory.matrix((TrigonometricVariables)var, (int)length, (int)start);
    }

    public static double[] interventionVariable(TsDomain domain, double delta, double sdelta, String[] starts, String[] ends) {
        InterventionVariable.Builder builder = InterventionVariable.builder().delta(delta).deltaSeasonal(sdelta);
        for (int i = 0; i < starts.length; ++i) {
            LocalDate start = LocalDate.parse(starts[i], DateTimeFormatter.ISO_DATE);
            LocalDate end = LocalDate.parse(ends[i], DateTimeFormatter.ISO_DATE);
            builder.sequence(Range.of((Comparable)start.atStartOfDay(), (Comparable)end.atStartOfDay()));
        }
        InterventionVariable var = builder.build();
        return Regression.matrix((TimeSeriesDomain)domain, (ITsVariable[])new ITsVariable[]{var}).getStorage();
    }

    public static double[] interventionVariable(TsDomain domain, double delta, double sdelta, int[] starts, int[] ends) {
        InterventionVariable.Builder builder = InterventionVariable.builder().delta(delta).deltaSeasonal(sdelta);
        for (int i = 0; i < starts.length; ++i) {
            LocalDateTime start = domain.get(starts[i]).start();
            LocalDateTime end = domain.get(ends[i]).start();
            builder.sequence(Range.of((Comparable)start, (Comparable)end));
        }
        InterventionVariable var = builder.build();
        return Regression.matrix((TimeSeriesDomain)domain, (ITsVariable[])new ITsVariable[]{var}).getStorage();
    }

    @Generated
    private Variables() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

