/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.xml.information;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.xml.information.XmlPeriodSelectionBetween;
import jdplus.toolkit.base.xml.information.XmlPeriodSelectionExcluding;
import jdplus.toolkit.base.xml.legacy.IXmlConverter;
import jdplus.toolkit.base.xml.legacy.XmlEmptyElement;

@XmlType(name="periodSelectionType")
public class XmlPeriodSelection
implements IXmlConverter<TimeSelector> {
    static final String NAME = "periodSelectionType";
    @XmlElement
    public XmlEmptyElement all;
    @XmlElement
    public XmlEmptyElement none;
    @XmlElement
    public String from;
    @XmlElement
    public String to;
    @XmlElement
    public String first;
    @XmlElement
    public String last;
    @XmlElement
    public XmlPeriodSelectionExcluding excluding;
    @XmlElement
    public XmlPeriodSelectionBetween between;

    @Override
    public TimeSelector create() {
        if (this.excluding != null) {
            return TimeSelector.excluding((int)this.excluding.nfirst, (int)this.excluding.nlast);
        }
        if (this.between != null) {
            return TimeSelector.between((LocalDateTime)LocalDate.parse(this.between.start, DateTimeFormatter.ISO_DATE).atStartOfDay(), (LocalDateTime)LocalDate.parse(this.between.end, DateTimeFormatter.ISO_DATE).atStartOfDay());
        }
        if (this.from != null) {
            return TimeSelector.from((LocalDateTime)LocalDate.parse(this.from, DateTimeFormatter.ISO_DATE).atStartOfDay());
        }
        if (this.to != null) {
            return TimeSelector.to((LocalDateTime)LocalDate.parse(this.to, DateTimeFormatter.ISO_DATE).atStartOfDay());
        }
        if (this.none != null) {
            return TimeSelector.none();
        }
        if (this.first != null) {
            return TimeSelector.first((int)Integer.parseInt(this.first));
        }
        if (this.last != null) {
            return TimeSelector.last((int)Integer.parseInt(this.last));
        }
        return TimeSelector.all();
    }

    @Override
    public void copy(TimeSelector t) {
        if (t.getType() == TimeSelector.SelectionType.All) {
            this.all = new XmlEmptyElement();
        } else if (t.getType() == TimeSelector.SelectionType.Between) {
            this.between = new XmlPeriodSelectionBetween();
            this.between.start = t.getD0().toLocalDate().format(DateTimeFormatter.ISO_DATE);
            this.between.end = t.getD1().toLocalDate().format(DateTimeFormatter.ISO_DATE);
        } else if (t.getType() == TimeSelector.SelectionType.From) {
            this.from = t.getD0().toLocalDate().format(DateTimeFormatter.ISO_DATE);
        } else if (t.getType() == TimeSelector.SelectionType.To) {
            this.to = t.getD1().toLocalDate().format(DateTimeFormatter.ISO_DATE);
        } else if (t.getType() == TimeSelector.SelectionType.First) {
            this.first = Integer.toString(t.getN0());
        } else if (t.getType() == TimeSelector.SelectionType.Last) {
            this.last = Integer.toString(t.getN1());
        } else if (t.getType() == TimeSelector.SelectionType.Excluding) {
            this.excluding = new XmlPeriodSelectionExcluding();
            this.excluding.nfirst = t.getN0();
            this.excluding.nlast = t.getN1();
        } else {
            this.none = new XmlEmptyElement();
        }
    }
}

