/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value.aggregatefn;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.util.CompressionUtil;
import com.amazon.sqlengine.executor.etree.value.aggregatefn.AbstractAggregator;
import com.amazon.sqlengine.executor.etree.value.aggregatefn.AbstractAggregatorFactory;
import com.amazon.support.exceptions.ErrorException;
import java.nio.ByteBuffer;

public class CountAggregatorFactory
extends AbstractAggregatorFactory {
    private final boolean m_isCountStar;

    public CountAggregatorFactory(IColumn[] iColumnArray, IColumn iColumn) {
        super(iColumnArray, iColumn);
        this.m_isCountStar = 0 == iColumnArray.length;
    }

    @Override
    public CountAggregator createAggregator() {
        return this.m_isCountStar ? new CountStarAggregator(this) : new CountAggregator(this);
    }

    private static final class CountStarAggregator
    extends CountAggregator {
        public CountStarAggregator(CountAggregatorFactory countAggregatorFactory) {
            super(countAggregatorFactory);
        }

        @Override
        protected boolean shouldUpdate() throws ErrorException {
            return true;
        }
    }

    private static class CountAggregator
    extends AbstractAggregator {
        private long m_count = 0L;

        public CountAggregator(CountAggregatorFactory countAggregatorFactory) {
            super(countAggregatorFactory);
        }

        @Override
        public void load(byte[] byArray) throws ErrorException {
            try {
                this.m_count = ByteBuffer.wrap(byArray).getLong();
            }
            catch (Exception exception) {
                throw SQLEngineExceptionFactory.failedToReadData(exception);
            }
        }

        @Override
        public byte[] serialize() {
            return ByteBuffer.allocate(8).putLong(this.m_count).array();
        }

        @Override
        public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
            eTDataRequest.getData().setBigInt(CompressionUtil.getlongAsBigInteger(this.m_count, false));
            return false;
        }

        @Override
        protected void update() throws ErrorException {
            if (this.shouldUpdate()) {
                ++this.m_count;
            }
        }

        protected boolean shouldUpdate() throws ErrorException {
            return !this.getArgumentData(0, 0L, 0L).isNull();
        }

        @Override
        protected long getMemoryUsage() {
            return 8L;
        }

        @Override
        public void reset() {
            this.m_count = 0L;
        }

        @Override
        public void close() {
        }
    }
}

