/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aebuilder.relation;

import com.amazon.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.amazon.sqlengine.aeprocessor.aebuilder.AEBuilderCheck;
import com.amazon.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.amazon.sqlengine.aeprocessor.aebuilder.bool.AEBooleanExprBuilder;
import com.amazon.sqlengine.aeprocessor.aebuilder.bool.AEBooleanExprOuterRefProcessor;
import com.amazon.sqlengine.aeprocessor.aebuilder.relation.AETableRefBuilder;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AECrossJoin;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.parser.parsetree.PTNonterminalNode;
import com.amazon.sqlengine.parser.type.PTNonterminalType;
import com.amazon.sqlengine.parser.type.PTPositionalType;
import com.amazon.support.exceptions.ErrorException;

public class AEJoinedTableBuilder
extends AEBuilderBase<AERelationalExpr> {
    protected AEJoinedTableBuilder(AEQueryScope aEQueryScope) {
        super(aEQueryScope);
    }

    @Override
    public AERelationalExpr visit(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        if (null == pTNonterminalNode) {
            throw new NullPointerException("node may not be null.");
        }
        switch (pTNonterminalNode.getNonterminalType()) {
            case CROSS_JOIN: {
                return AEJoinedTableBuilder.buildCrossJoin(pTNonterminalNode, this.getQueryScope());
            }
            case INNER_JOIN: 
            case LEFT_OUTER_JOIN: 
            case RIGHT_OUTER_JOIN: 
            case FULL_OUTER_JOIN: {
                return AEJoinedTableBuilder.buildJoin(pTNonterminalNode, this.getQueryScope());
            }
            case JOIN_ESCAPE: {
                return pTNonterminalNode.getChild(PTPositionalType.JOIN).acceptVisitor(this);
            }
        }
        throw SQLEngineExceptionFactory.invalidParseTreeException();
    }

    private static AECrossJoin buildCrossJoin(PTNonterminalNode pTNonterminalNode, AEQueryScope aEQueryScope) throws ErrorException {
        AEBuilderCheck.checkThat(pTNonterminalNode, AEBuilderCheck.nonTerminal(PTNonterminalType.CROSS_JOIN).withExactChildren(PTPositionalType.TABLE_REF_LEFT, AEBuilderCheck.nonEmpty(), PTPositionalType.TABLE_REF_RIGHT, AEBuilderCheck.nonEmpty()));
        AETableRefBuilder aETableRefBuilder = new AETableRefBuilder(aEQueryScope);
        AERelationalExpr aERelationalExpr = (AERelationalExpr)aETableRefBuilder.build(pTNonterminalNode.getChild(PTPositionalType.TABLE_REF_LEFT));
        AERelationalExpr aERelationalExpr2 = (AERelationalExpr)aETableRefBuilder.build(pTNonterminalNode.getChild(PTPositionalType.TABLE_REF_RIGHT));
        return new AECrossJoin(aERelationalExpr, aERelationalExpr2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AEJoin buildJoin(PTNonterminalNode pTNonterminalNode, AEQueryScope aEQueryScope) throws ErrorException {
        AEBuilderCheck.checkThat(pTNonterminalNode, AEBuilderCheck.nonTerminal().withExactChildren(PTPositionalType.TABLE_REF_LEFT, AEBuilderCheck.nonEmpty(), PTPositionalType.TABLE_REF_RIGHT, AEBuilderCheck.nonEmpty(), PTPositionalType.SEARCH_COND, AEBuilderCheck.nonEmpty()));
        AEJoin.AEJoinType aEJoinType = AEJoinedTableBuilder.translateJoinType(pTNonterminalNode.getNonterminalType());
        AETableRefBuilder aETableRefBuilder = new AETableRefBuilder(aEQueryScope);
        AERelationalExpr aERelationalExpr = (AERelationalExpr)aETableRefBuilder.build(pTNonterminalNode.getChild(PTPositionalType.TABLE_REF_LEFT));
        AERelationalExpr aERelationalExpr2 = (AERelationalExpr)aETableRefBuilder.build(pTNonterminalNode.getChild(PTPositionalType.TABLE_REF_RIGHT));
        AEJoin aEJoin = new AEJoin(aEJoinType, aERelationalExpr, aERelationalExpr2);
        aEQueryScope.setCurrentJoinExpr(aEJoin);
        try {
            AEBooleanExpr aEBooleanExpr = (AEBooleanExpr)new AEBooleanExprBuilder(aEQueryScope).build(pTNonterminalNode.getChild(PTPositionalType.SEARCH_COND));
            if (!aEQueryScope.isTopMost()) {
                AEBooleanExprOuterRefProcessor.process(aEBooleanExpr, aEQueryScope);
            }
            aEJoin.setJoinCondition(aEBooleanExpr);
        }
        finally {
            aEQueryScope.setCurrentJoinExpr(null);
        }
        return aEJoin;
    }

    private static AEJoin.AEJoinType translateJoinType(PTNonterminalType pTNonterminalType) throws ErrorException {
        switch (pTNonterminalType) {
            case INNER_JOIN: {
                return AEJoin.AEJoinType.INNER_JOIN;
            }
            case LEFT_OUTER_JOIN: {
                return AEJoin.AEJoinType.LEFT_OUTER_JOIN;
            }
            case RIGHT_OUTER_JOIN: {
                return AEJoin.AEJoinType.RIGHT_OUTER_JOIN;
            }
            case FULL_OUTER_JOIN: {
                return AEJoin.AEJoinType.FULL_OUTER_JOIN;
            }
        }
        throw SQLEngineExceptionFactory.invalidParseTreeException();
    }
}

