/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.common;

import com.amazon.support.IMessageSource;
import com.amazon.support.IWarningListener;
import com.amazon.support.SettingReader;
import com.amazon.support.Warning;
import com.amazon.support.WarningCode;
import com.amazon.support.exceptions.ExceptionUtilities;
import com.amazon.utilities.FunctionID;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class SWarningListener
implements IWarningListener {
    private static final HashMap<WarningCode, String> WARNING_MAP = new HashMap<WarningCode, String>(){
        private static final long serialVersionUID = -4253295231118746567L;
        {
            this.put(WarningCode.GENERAL_WARNING, "01000");
            this.put(WarningCode.CURSOR_OPERATION_CONFLICT, "01001");
            this.put(WarningCode.NULL_VALUE_ELIMINATED_IN_SET_FUNCTION, "01003");
            this.put(WarningCode.STRING_RIGHT_TRUNCATION_WARNING, "01004");
            this.put(WarningCode.PRIVILEGE_NOT_REVOKED, "01006");
            this.put(WarningCode.PRIVILEGE_NOT_GRANTED, "01007");
            this.put(WarningCode.INVALID_CONNECTION_STRING_ATTRIBUTE, "01S00");
            this.put(WarningCode.ERROR_IN_ROW, "01S01");
            this.put(WarningCode.OPTIONAL_VALUE_CHANGED, "01S02");
            this.put(WarningCode.FRACTIONAL_TRUNCATION, "01S07");
        }
    };
    private List<Warning> m_warnings = new ArrayList<Warning>();
    private IMessageSource m_messageSource = null;
    private Locale m_locale = null;
    private SQLWarning m_sqlWarning = null;
    private SQLWarning m_tailSqlWarning = null;
    private FunctionID m_currFunction = null;

    protected SWarningListener(IMessageSource iMessageSource, FunctionID functionID) {
        this.m_messageSource = iMessageSource;
        this.m_currFunction = functionID;
        String string = SettingReader.readSetting("DriverLocale");
        this.m_locale = Locale.ENGLISH;
        if (null != string) {
            this.m_locale = ExceptionUtilities.createLocale(string);
        }
    }

    public synchronized void clear() {
        if (null != this.m_sqlWarning) {
            this.m_warnings.clear();
            this.m_sqlWarning = null;
            this.m_tailSqlWarning = null;
        }
    }

    public void clearAndSetFunction(FunctionID functionID) {
        this.clear();
        this.m_currFunction = functionID;
    }

    @Override
    public Locale getLocale() {
        return this.m_locale;
    }

    @Override
    public IMessageSource getMessageSource() {
        return this.m_messageSource;
    }

    public SQLWarning getSQLWarnings() {
        return this.m_sqlWarning;
    }

    @Override
    public List<Warning> getWarnings() {
        return this.m_warnings;
    }

    @Override
    public synchronized void postWarning(Warning warning) {
        if (null == warning) {
            return;
        }
        warning.setLocalizedWarningMessage(this.m_messageSource, this.m_locale);
        this.m_warnings.add(warning);
        SQLWarning sQLWarning = this.createSQLWarning(warning);
        if (null == this.m_sqlWarning) {
            this.m_sqlWarning = sQLWarning;
            this.m_tailSqlWarning = sQLWarning;
        } else {
            this.m_tailSqlWarning.setNextWarning(sQLWarning);
            this.m_tailSqlWarning = sQLWarning;
        }
    }

    public void setCurrentFunction(FunctionID functionID) {
        this.m_currFunction = functionID;
    }

    @Override
    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    private SQLWarning createSQLWarning(Warning warning) {
        String string = warning.hasCustomState() ? warning.getCustomState() : this.getSQLState(this.m_currFunction, warning.getWarningCode());
        if (-1 != warning.getNativeErrorCode()) {
            return new SQLWarning(warning.getMessage(), string, warning.getNativeErrorCode());
        }
        return new SQLWarning(warning.getMessage(), string);
    }

    private String getSQLState(FunctionID functionID, WarningCode warningCode) {
        if (null == functionID) {
            return WARNING_MAP.get((Object)WarningCode.GENERAL_WARNING);
        }
        switch (functionID) {
            case CONNECTION_UPDATE_SETTINGS: {
                switch (warningCode) {
                    case STRING_RIGHT_TRUNCATION_WARNING: 
                    case INVALID_CONNECTION_STRING_ATTRIBUTE: 
                    case OPTIONAL_VALUE_CHANGED: {
                        return WARNING_MAP.get((Object)warningCode);
                    }
                }
                break;
            }
            case CONNECTION_SET_PROPERTY: 
            case STATEMENT_SET_PROPERTY: {
                switch (warningCode) {
                    case OPTIONAL_VALUE_CHANGED: {
                        return WARNING_MAP.get((Object)warningCode);
                    }
                }
                break;
            }
            case STATEMENT_PREPARE: {
                switch (warningCode) {
                    case OPTIONAL_VALUE_CHANGED: {
                        return WARNING_MAP.get((Object)warningCode);
                    }
                    case FRACTIONAL_TRUNCATION: {
                        return WARNING_MAP.get((Object)warningCode);
                    }
                }
                break;
            }
            case STATEMENT_EXECUTE: {
                switch (warningCode) {
                    case OPTIONAL_VALUE_CHANGED: 
                    case FRACTIONAL_TRUNCATION: 
                    case CURSOR_OPERATION_CONFLICT: 
                    case NULL_VALUE_ELIMINATED_IN_SET_FUNCTION: 
                    case PRIVILEGE_NOT_GRANTED: 
                    case PRIVILEGE_NOT_REVOKED: {
                        return WARNING_MAP.get((Object)warningCode);
                    }
                }
                break;
            }
        }
        return WARNING_MAP.get((Object)WarningCode.GENERAL_WARNING);
    }
}

