/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.linearmodel;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.dstats.Chi2;
import jdplus.toolkit.base.core.dstats.F;
import jdplus.toolkit.base.core.dstats.T;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.QuadraticForm;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;
import lombok.NonNull;

public final class LeastSquaresResults {
    private final DoubleSeq y;
    private final FastMatrix X;
    private final boolean mean;
    private final int n;
    private final int nx;
    private final DoubleSeq coefficients;
    private final double sse;
    private final double ldet;
    private final FastMatrix ucov;
    private final double sst;
    private final double ssm;

    public static Builder builder(@NonNull DoubleSeq Y, FastMatrix X) {
        if (Y == null) {
            throw new NullPointerException("Y is marked non-null but is null");
        }
        return new Builder(Y, X);
    }

    private LeastSquaresResults(DoubleSeq Y, FastMatrix X, boolean mean, DoubleSeq coefficients, FastMatrix unscaledCov, double ssq, double ldet) {
        this.y = Y;
        this.X = X;
        this.mean = mean;
        this.coefficients = coefficients;
        this.ldet = ldet;
        this.n = this.y.length();
        this.ucov = unscaledCov;
        int n = this.nx = this.ucov == null ? 0 : this.ucov.diagonal().count(x -> x != 0.0);
        if (mean) {
            double ybar = this.y.average();
            this.sst = this.y.ssqc(ybar);
        } else {
            this.sst = this.y.ssq();
        }
        this.sse = Math.min(ssq, this.sst);
        this.ssm = this.sst - this.sse;
    }

    public DoubleSeq getY() {
        return this.y;
    }

    public Matrix X() {
        return this.X.unmodifiable();
    }

    public FastMatrix projectionMatrix() {
        return SymmetricMatrix.XSXt(this.ucov, this.X);
    }

    public boolean isMean() {
        return this.mean;
    }

    public DoubleSeq regressionEffect() {
        DataBlock e = DataBlock.make(this.y.length());
        DoubleSeqCursor c = this.coefficients.cursor();
        DataBlockIterator cols = this.X.columnsIterator();
        while (cols.hasNext()) {
            e.addAY(c.getAndNext(), cols.next());
        }
        return e.unmodifiable();
    }

    public DoubleSeq residuals() {
        DataBlock e = DataBlock.of(this.y);
        DoubleSeqCursor c = this.coefficients.cursor();
        DataBlockIterator cols = this.X.columnsIterator();
        while (cols.hasNext()) {
            e.addAY(-c.getAndNext(), cols.next());
        }
        return e.unmodifiable();
    }

    public DoubleSeq studentizedResiduals() {
        DoubleSeq e = this.residuals();
        double[] v = new double[e.length()];
        double sig = this.getErrorStandardDeviation();
        DataBlockIterator rows = this.X.rowsIterator();
        DoubleSeqCursor cursor = e.cursor();
        for (int i = 0; i < v.length; ++i) {
            v[i] = cursor.getAndNext() / (sig * Math.sqrt(1.0 - QuadraticForm.apply(this.ucov, rows.next())));
        }
        return DoubleSeq.of((double[])v);
    }

    public DoubleSeq getCoefficients() {
        return this.coefficients;
    }

    public double getErrorMeanSquares() {
        return this.sse / (double)this.degreesOfFreedomForError();
    }

    public double getErrorStandardDeviation() {
        return Math.sqrt(this.getErrorMeanSquares());
    }

    public double getModelMeanSquares() {
        return this.ssm / (double)this.degreesOfFreedomForModel();
    }

    public double getTotalMeanSquares() {
        return this.sst / (double)this.degreesOfFreedomForTotal();
    }

    public double getTotalSumOfSquares() {
        return this.sst;
    }

    public double getErrorSumOfSquares() {
        return this.sse;
    }

    public double getModelSumOfSquares() {
        return this.ssm;
    }

    public double getR2() {
        return 1.0 - this.sse / this.sst;
    }

    public double getAdjustedR2() {
        return 1.0 - (double)this.degreesOfFreedomForTotal() * (1.0 - this.getR2()) / (double)this.degreesOfFreedomForError();
    }

    private int degreesOfFreedomForModel() {
        return this.mean ? this.nx - 1 : this.nx;
    }

    private int degreesOfFreedomForError() {
        return this.n - this.nx;
    }

    private int degreesOfFreedomForTotal() {
        return this.mean ? this.n - 1 : this.n;
    }

    public StatisticalTest Ftest() {
        F f = new F(this.degreesOfFreedomForModel(), this.degreesOfFreedomForError());
        return TestsUtility.testOf(this.getModelMeanSquares() / this.getErrorMeanSquares(), f, TestType.Upper);
    }

    public StatisticalTest Khi2Test() {
        Chi2 chi = new Chi2(this.degreesOfFreedomForModel());
        return TestsUtility.testOf((double)this.n * this.getR2(), chi, TestType.Upper);
    }

    public StatisticalTest Ftest(int v0, int nvars) {
        FastMatrix bvar = this.ucov.extract(v0, nvars, v0, nvars).deepClone();
        SymmetricMatrix.lcholesky(bvar);
        DataBlock b = DataBlock.of(this.coefficients.extract(v0, nvars));
        LowerTriangularMatrix.solveLx(bvar, b);
        double fval = b.ssq() / (double)nvars / this.getErrorMeanSquares();
        F f = new F(nvars, this.degreesOfFreedomForError());
        return TestsUtility.testOf(fval, f, TestType.Upper);
    }

    public FastMatrix covariance() {
        return this.ucov.times(this.sse / (double)(this.n - this.nx));
    }

    public double standardDeviation(int idx) {
        double v = this.ucov.get(idx, idx);
        return Math.sqrt(this.getErrorMeanSquares() * v);
    }

    public double T(int idx) {
        return this.T(idx, 0.0);
    }

    public StatisticalTest Ttest(int idx) {
        return this.Ttest(idx, 0.0);
    }

    public double T(int idx, double value) {
        double e = this.ucov.get(idx, idx);
        if (e == 0.0) {
            return Double.NaN;
        }
        double b = this.coefficients.get(idx);
        if (b == 0.0) {
            return 0.0;
        }
        return (b - value) / Math.sqrt(e * this.getErrorMeanSquares());
    }

    public StatisticalTest Ttest(int idx, double value) {
        double t = this.T(idx, value);
        if (!Double.isFinite(t)) {
            return null;
        }
        return TestsUtility.testOf(t, new T(this.degreesOfFreedomForError()), TestType.TwoSided);
    }

    public ConcentratedLikelihoodWithMissing getLikelihood() {
        return ConcentratedLikelihoodWithMissing.builder().ndata(this.n).coefficients(this.coefficients).unscaledCovariance(this.ucov).ssqErr(this.sse).logDeterminant(this.ldet).build();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("R2=").append(this.getR2());
        builder.append(System.lineSeparator());
        builder.append("Adjusted R2=").append(this.getAdjustedR2());
        builder.append(System.lineSeparator());
        builder.append("Residual standard deviation=").append(this.getErrorStandardDeviation());
        builder.append(System.lineSeparator());
        builder.append("F=").append(this.Ftest().getValue());
        builder.append(System.lineSeparator());
        int idx = 0;
        if (this.mean) {
            builder.append(System.lineSeparator());
            builder.append("mean").append('\t').append(this.coefficients.get(0)).append('\t').append(this.standardDeviation(idx));
            ++idx;
        }
        int j = 1;
        while (idx < this.coefficients.length()) {
            double c = this.coefficients.get(idx);
            if (c != 0.0) {
                builder.append(System.lineSeparator());
                builder.append("x").append(j).append('\t').append(c).append('\t').append(this.standardDeviation(idx));
            }
            ++idx;
            ++j;
        }
        builder.append(System.lineSeparator());
        return builder.toString();
    }

    public static class Builder {
        private final DoubleSeq y;
        private final FastMatrix X;
        private boolean mean;
        private DoubleSeq coefficients;
        private DoubleSeq res;
        private double ssq;
        private double ldet;
        private FastMatrix ucov;

        private Builder(DoubleSeq y, FastMatrix X) {
            this.y = y;
            this.X = X;
        }

        public Builder mean(boolean mu) {
            this.mean = mu;
            return this;
        }

        public Builder estimation(DoubleSeq coefficients, FastMatrix ucov) {
            this.coefficients = coefficients;
            this.ucov = ucov;
            return this;
        }

        public Builder ssq(double ssq) {
            this.ssq = ssq;
            return this;
        }

        public Builder residuals(DoubleSeq res) {
            this.res = res;
            if (this.ssq == 0.0) {
                this.ssq = res.ssq();
            }
            return this;
        }

        public Builder logDeterminant(double ldet) {
            this.ldet = ldet;
            return this;
        }

        public LeastSquaresResults build() {
            return new LeastSquaresResults(this.y, this.X, this.mean, this.coefficients, this.ucov, this.ssq, this.ldet);
        }
    }
}

