/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regsarima.regular;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regsarima.RegSarimaComputer;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import lombok.Generated;
import lombok.NonNull;

public class RegSarimaModelling {
    @NonNull
    private ModelDescription description;
    private RegArimaEstimation<SarimaModel> estimation;
    @NonNull
    private final ProcessingLog log;

    public static RegSarimaModelling of(ModelDescription desc) {
        return new RegSarimaModelling(desc, null, ProcessingLog.dummy());
    }

    public static RegSarimaModelling of(ModelDescription desc, ProcessingLog log) {
        return new RegSarimaModelling(desc, null, log);
    }

    public static RegSarimaModelling copyOf(RegSarimaModelling modelling) {
        return new RegSarimaModelling(ModelDescription.copyOf(modelling.description), modelling.estimation, ProcessingLog.dummy());
    }

    public void estimate(IRegArimaComputer<SarimaModel> processor) {
        this.estimation = this.description.estimate(processor);
    }

    public void estimate(double precision) {
        RegSarimaComputer processor = RegSarimaComputer.builder().precision(precision).startingPoint(RegSarimaComputer.StartingPoint.HannanRissanen).build();
        this.estimation = this.description.estimate(processor);
    }

    public RegSarimaModel build() {
        return RegSarimaModel.of(this.description, this.estimation, this.log);
    }

    public void clearEstimation() {
        this.estimation = null;
        this.description.freeArimaParameters();
    }

    public boolean needEstimation() {
        return this.estimation == null;
    }

    public void setSpecification(SarimaOrders spec) {
        this.description.setSpecification(spec);
        this.estimation = null;
    }

    public void setDescription(ModelDescription desc) {
        this.description = desc;
        this.estimation = null;
    }

    public void set(ModelDescription desc, RegArimaEstimation<SarimaModel> est) {
        this.description = desc;
        this.estimation = est;
    }

    @NonNull
    @Generated
    public ModelDescription getDescription() {
        return this.description;
    }

    @Generated
    public RegArimaEstimation<SarimaModel> getEstimation() {
        return this.estimation;
    }

    @NonNull
    @Generated
    public ProcessingLog getLog() {
        return this.log;
    }

    @Generated
    private RegSarimaModelling(@NonNull ModelDescription description, RegArimaEstimation<SarimaModel> estimation, @NonNull ProcessingLog log) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (log == null) {
            throw new NullPointerException("log is marked non-null but is null");
        }
        this.description = description;
        this.estimation = estimation;
        this.log = log;
    }
}

