/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima;

import java.util.List;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.eco.EcoException;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.StationaryTransformation;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class RegArmaModel<M extends IArimaModel> {
    @NonNull
    private final DoubleSeq y;
    @NonNull
    private final M arma;
    private final int missingCount;
    private final FastMatrix x;

    public static <M extends IArimaModel> RegArmaModel<M> of(RegArmaModel<M> model, M newarma) {
        return new RegArmaModel<M>(model.y, newarma, model.missingCount, model.x);
    }

    static <M extends IArimaModel> RegArmaModel<M> of(RegArimaModel<M> regarima) {
        double[] dy;
        FastMatrix dx;
        int[] missing;
        IArimaModel arma;
        block14: {
            StationaryTransformation st = regarima.arima().stationaryTransformation();
            arma = (IArimaModel)st.getStationaryModel();
            BackFilter ur = st.getUnitRoots();
            int d = ur.getDegree();
            int n = regarima.getObservationsCount();
            int ndy = n - d;
            if (ndy <= 0) {
                throw new EcoException("Not enough observations");
            }
            DoubleSeq y = regarima.getY();
            boolean mean = regarima.isMean();
            List<DoubleSeq> x = regarima.getX();
            missing = regarima.missing();
            int nx = regarima.getMissingValuesCount() + regarima.getVariablesCount();
            dx = FastMatrix.make(ndy, nx);
            if (d > 0) {
                dy = new double[y.length() - d];
                ur.apply(y, (DoubleSeq.Mutable)DataBlock.of(dy));
            } else {
                dy = y.toArray();
            }
            if (nx <= 0) break block14;
            DataBlockIterator cols = dx.columnsIterator();
            if (d > 0) {
                if (missing.length > 0) {
                    DoubleSeq coeff = ur.asPolynomial().coefficients().reverse();
                    for (int i = 0; i < missing.length; ++i) {
                        DataBlock col = cols.next();
                        if (missing[i] >= dy.length) {
                            col.range(missing[i] - d, dy.length).copy(coeff.drop(0, y.length() - missing[i]));
                            continue;
                        }
                        if (missing[i] >= d) {
                            col.range(missing[i] - d, missing[i] + 1).copy(coeff);
                            continue;
                        }
                        col.range(0, missing[i] + 1).copy(coeff.drop(d - missing[i], 0));
                    }
                }
                if (mean) {
                    cols.next().set(1.0);
                }
                for (DoubleSeq var : x) {
                    ur.apply(var, (DoubleSeq.Mutable)cols.next());
                }
            } else {
                for (int i = 0; i < missing.length; ++i) {
                    cols.next().set(missing[i], 1.0);
                }
                if (mean) {
                    cols.next().set(1.0);
                }
                for (DoubleSeq var : x) {
                    ur.apply(var, (DoubleSeq.Mutable)cols.next());
                }
            }
        }
        return new RegArmaModel<IArimaModel>(DoubleSeq.of((double[])dy), arma, missing.length, dx);
    }

    public LinearModel asLinearModel() {
        return new LinearModel(this.y.toArray(), false, FastMatrix.of((Matrix)this.x));
    }

    @Generated
    public RegArmaModel(@NonNull DoubleSeq y, @NonNull M arma, int missingCount, FastMatrix x) {
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        if (arma == null) {
            throw new NullPointerException("arma is marked non-null but is null");
        }
        this.y = y;
        this.arma = arma;
        this.missingCount = missingCount;
        this.x = x;
    }

    @NonNull
    @Generated
    public DoubleSeq getY() {
        return this.y;
    }

    @NonNull
    @Generated
    public M getArma() {
        return this.arma;
    }

    @Generated
    public int getMissingCount() {
        return this.missingCount;
    }

    @Generated
    public FastMatrix getX() {
        return this.x;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegArmaModel)) {
            return false;
        }
        RegArmaModel other = (RegArmaModel)o;
        if (this.getMissingCount() != other.getMissingCount()) {
            return false;
        }
        DoubleSeq this$y = this.getY();
        DoubleSeq other$y = other.getY();
        if (this$y == null ? other$y != null : !this$y.equals(other$y)) {
            return false;
        }
        M this$arma = this.getArma();
        M other$arma = other.getArma();
        if (this$arma == null ? other$arma != null : !this$arma.equals(other$arma)) {
            return false;
        }
        FastMatrix this$x = this.getX();
        FastMatrix other$x = other.getX();
        return !(this$x == null ? other$x != null : !this$x.equals(other$x));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMissingCount();
        DoubleSeq $y = this.getY();
        result = result * 59 + ($y == null ? 43 : $y.hashCode());
        M $arma = this.getArma();
        result = result * 59 + ($arma == null ? 43 : $arma.hashCode());
        FastMatrix $x = this.getX();
        result = result * 59 + ($x == null ? 43 : $x.hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "RegArmaModel(y=" + String.valueOf(this.getY()) + ", arma=" + String.valueOf(this.getArma()) + ", missingCount=" + this.getMissingCount() + ", x=" + String.valueOf(this.getX()) + ")";
    }
}

