/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core;

import jdplus.sa.base.api.SaException;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TsData;
import lombok.Generated;

public final class PreliminaryChecks {
    public static final int MAX_REPEAT_COUNT = 80;
    public static final int MAX_MISSING_COUNT = 33;

    public static void testSeries(TsData y) {
        int period;
        if (y == null) {
            throw new SaException("no data");
        }
        int nz = y.length();
        if (nz < Math.max(8, 3 * (period = y.getAnnualFrequency()))) {
            throw new SaException("not enough data");
        }
        DoubleSeq values = y.getValues();
        int nrepeat = PreliminaryChecks.repeatCount(values);
        if (nrepeat > 80 * nz / 100) {
            throw new SaException("too many identical data");
        }
        int nm = values.count(z -> !Double.isFinite(z));
        if (nm > 33 * nz / 100) {
            throw new SaException("too many missing data");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testSeries(TsData y, ProcessingLog log) {
        log.push("preliminary checks");
        try {
            PreliminaryChecks.testSeries(y);
            boolean bl = true;
            return bl;
        }
        catch (SaException err) {
            log.error(err.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            log.pop();
        }
    }

    public static int repeatCount(DoubleSeq values) {
        int i;
        int n = values.length();
        for (i = 0; i < n && !Double.isFinite(values.get(i)); ++i) {
        }
        if (i == n) {
            return 0;
        }
        int c = 0;
        double prev = values.get(i++);
        while (i < n) {
            double cur = values.get(i);
            if (Double.isFinite(cur)) {
                if (cur == prev) {
                    ++c;
                } else {
                    prev = cur;
                }
            }
            ++i;
        }
        return c;
    }

    @Generated
    private PreliminaryChecks() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface Tool {
        public TsData check(TsData var1, ProcessingLog var2);
    }
}

