/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.regression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class ModifiedTsVariable
implements ITsVariable {
    @NonNull
    private final ITsVariable variable;
    @NonNull
    private final List<Modifier> modifiers;

    @Override
    public int dim() {
        return this.mdim() * this.variable.dim();
    }

    private int mdim() {
        int d = 1;
        for (Modifier m : this.modifiers) {
            d *= m.dim();
        }
        return d;
    }

    @Override
    public <D extends TimeSeriesDomain<?>> String description(D context) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.variable.description(context));
        for (Modifier m : this.modifiers) {
            builder.append(m.description());
        }
        return builder.toString();
    }

    @Override
    public <D extends TimeSeriesDomain<?>> String description(int idx, D context) {
        int dim = this.mdim();
        String desc = this.variable.description(idx / dim, context);
        idx /= this.variable.dim();
        StringBuilder builder = new StringBuilder();
        builder.append(desc);
        for (Modifier m : this.modifiers) {
            int cdim = m.dim();
            builder.append(m.description(idx / (dim /= cdim)));
            idx /= cdim;
        }
        return builder.toString();
    }

    @Generated
    ModifiedTsVariable(@NonNull ITsVariable variable, @NonNull List<Modifier> modifiers) {
        if (variable == null) {
            throw new NullPointerException("variable is marked non-null but is null");
        }
        if (modifiers == null) {
            throw new NullPointerException("modifiers is marked non-null but is null");
        }
        this.variable = variable;
        this.modifiers = modifiers;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        Builder builder = new Builder().variable(this.variable);
        if (this.modifiers != null) {
            builder.modifiers(this.modifiers);
        }
        return builder;
    }

    @NonNull
    @Generated
    public ITsVariable getVariable() {
        return this.variable;
    }

    @NonNull
    @Generated
    public List<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModifiedTsVariable)) {
            return false;
        }
        ModifiedTsVariable other = (ModifiedTsVariable)o;
        ITsVariable this$variable = this.getVariable();
        ITsVariable other$variable = other.getVariable();
        if (this$variable == null ? other$variable != null : !this$variable.equals(other$variable)) {
            return false;
        }
        List<Modifier> this$modifiers = this.getModifiers();
        List<Modifier> other$modifiers = other.getModifiers();
        return !(this$modifiers == null ? other$modifiers != null : !((Object)this$modifiers).equals(other$modifiers));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ITsVariable $variable = this.getVariable();
        result = result * 59 + ($variable == null ? 43 : $variable.hashCode());
        List<Modifier> $modifiers = this.getModifiers();
        result = result * 59 + ($modifiers == null ? 43 : ((Object)$modifiers).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "ModifiedTsVariable(variable=" + String.valueOf(this.getVariable()) + ", modifiers=" + String.valueOf(this.getModifiers()) + ")";
    }

    public static interface Modifier {
        public int dim();

        default public int redim(int n) {
            return n * this.dim();
        }

        public String description();

        default public String description(int idx) {
            return this.description();
        }
    }

    @Generated
    public static class Builder {
        @Generated
        private ITsVariable variable;
        @Generated
        private ArrayList<Modifier> modifiers;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder variable(@NonNull ITsVariable variable) {
            if (variable == null) {
                throw new NullPointerException("variable is marked non-null but is null");
            }
            this.variable = variable;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder modifier(Modifier modifier) {
            if (this.modifiers == null) {
                this.modifiers = new ArrayList();
            }
            this.modifiers.add(modifier);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder modifiers(@org.jspecify.annotations.NonNull Collection<? extends Modifier> modifiers) {
            if (modifiers == null) {
                throw new NullPointerException("modifiers cannot be null");
            }
            if (this.modifiers == null) {
                this.modifiers = new ArrayList();
            }
            this.modifiers.addAll(modifiers);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearModifiers() {
            if (this.modifiers != null) {
                this.modifiers.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull ModifiedTsVariable build() {
            return new ModifiedTsVariable(this.variable, switch (this.modifiers == null ? 0 : this.modifiers.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.modifiers.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Modifier>(this.modifiers));
            });
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "ModifiedTsVariable.Builder(variable=" + String.valueOf(this.variable) + ", modifiers=" + String.valueOf(this.modifiers) + ")";
        }
    }
}

