## ----setup, include=FALSE, echo=TRUE------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  echo = TRUE,
  results = "markup",
  include = TRUE
)

## -----------------------------------------------------------------------------
library("opusreader2")
file_1 <- opus_test_file()
spectrum_1 <- read_opus(dsn = file_1)

## -----------------------------------------------------------------------------
print(spectrum_1)
class(spectrum_1)
names(spectrum_1)

## -----------------------------------------------------------------------------
meas_1 <- spectrum_1[["BF_lo_01_soil_cal.1"]]
names(meas_1)

## -----------------------------------------------------------------------------
str(meas_1$basic_metadata)

## -----------------------------------------------------------------------------
meas_1$ab_data_param$parameters$FXV$parameter_value

## -----------------------------------------------------------------------------
class(meas_1$ab_data_param)
str(meas_1$ab_data_param)

## -----------------------------------------------------------------------------
str(meas_1$instrument)

## -----------------------------------------------------------------------------
test_dsn <- system.file("extdata", "test_data", package = "opusreader2")
data_test <- read_opus(dsn = test_dsn)
names(data_test)

## -----------------------------------------------------------------------------
get_instrument_name <- function(data) {
  return(data$instrument$parameters$INS$parameter_value)
}

lapply(data_test, get_instrument_name)

