/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf.extended;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockStorage;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.extended.INonLinearSsf;
import ec.tstoolkit.ssf.extended.LinearizedLogSsf;

public class WeightedLogSsf<S extends ISsf>
implements INonLinearSsf {
    private S m_ssf;
    private double[] m_w;

    public WeightedLogSsf(S ssf, double[] w) {
        this.m_ssf = ssf;
        this.m_w = w;
    }

    public S getSsf() {
        return this.m_ssf;
    }

    public DataBlock getWeights() {
        return new DataBlock(this.m_w);
    }

    public LinearizedLogSsf<S> linearApproximation(DataBlock observations, DataBlock lstates) {
        double[] e = new double[observations.getLength()];
        for (int i = 0; i < e.length; ++i) {
            double w;
            e[i] = w = lstates.get(i);
            observations.add(i, -w * (1.0 - Math.log(w / this.m_w[i])));
        }
        return new LinearizedLogSsf<S>(this.m_ssf, e);
    }

    @Override
    public ISsf linearApproximation(DataBlock observations, DataBlockStorage states) {
        double[] e = new double[observations.getLength()];
        for (int i = 0; i < e.length; ++i) {
            double w = this.m_ssf.ZX(i, states.block(i));
            e[i] = this.m_w[i] * Math.exp(w);
            observations.add(i, -e[i] * (1.0 - w));
        }
        return new LinearizedLogSsf<S>(this.m_ssf, e);
    }

    @Override
    public void TX(int pos, DataBlock x) {
        this.m_ssf.TX(pos, x);
    }

    @Override
    public double Z(int pos, DataBlock x) {
        return this.m_w[pos] * Math.exp(this.m_ssf.ZX(pos, x));
    }
}

