/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima;

import ec.tstoolkit.arima.ArimaException;
import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.LinearModel;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.FiniteFilter;
import ec.tstoolkit.maths.linearfilters.ForeFilter;
import ec.tstoolkit.maths.linearfilters.IFiniteFilter;
import ec.tstoolkit.maths.linearfilters.RationalFilter;

public class CrossCovarianceFunction {
    private final RationalFilter m_r;
    private double m_c = 1.0;

    public static CrossCovarianceFunction create(ArimaModel m1, ArimaModel m2) {
        try {
            return new CrossCovarianceFunction(new RationalFilter(FiniteFilter.multiply((IFiniteFilter)new FiniteFilter(m1.getMA()), m2.getMA().mirror()), m1.getAR(), m2.getAR().mirror()), Math.sqrt(m1.getInnovationVariance() * m2.getInnovationVariance()));
        }
        catch (ArimaException ex) {
            return null;
        }
    }

    public CrossCovarianceFunction(LinearModel m1, LinearModel m2) {
        RationalFilter f1 = m1.getFilter();
        RationalFilter f2 = m2.getFilter();
        FiniteFilter n1 = new FiniteFilter(f1.getNumerator());
        FiniteFilter n2 = new FiniteFilter(f2.getNumerator()).mirror();
        BackFilter db1 = f1.getRationalBackFilter().getDenominator();
        BackFilter db2 = f2.getRationalBackFilter().getDenominator();
        ForeFilter df1 = f1.getRationalForeFilter().getDenominator();
        ForeFilter df2 = f2.getRationalForeFilter().getDenominator();
        this.m_r = new RationalFilter(FiniteFilter.multiply((IFiniteFilter)n1, n2), db1.times(df2.mirror()), df1.times(db2.mirror()));
        this.m_c = Math.sqrt(m1.getInnovationVariance() * m2.getInnovationVariance());
    }

    private CrossCovarianceFunction(RationalFilter r, double c) {
        this.m_r = r;
        this.m_c = c;
    }

    public double get(int k) {
        return this.m_r.getWeight(k) * this.m_c;
    }

    public int getLBound() {
        return this.m_r.getLBound();
    }

    public int getUBound() {
        return this.m_r.getUBound();
    }

    public boolean hasLBound() {
        return this.m_r.hasLowerBound();
    }

    public boolean hasUBound() {
        return this.m_r.hasUpperBound();
    }

    public void prepare(int n, int m) {
        this.m_r.prepare(n, m);
    }
}

