/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.calendars;

import java.time.LocalDate;
import jdplus.toolkit.base.api.timeseries.ValidityPeriod;
import jdplus.toolkit.base.api.timeseries.calendars.CalendarUtility;
import jdplus.toolkit.base.api.timeseries.calendars.Holiday;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class FixedDay
implements Holiday {
    private final int month;
    private final int day;
    private final double weight;
    private final ValidityPeriod validityPeriod;
    public static final FixedDay CHRISTMAS = new FixedDay(12, 25);
    public static final FixedDay NEWYEAR = new FixedDay(1, 1);
    public static final FixedDay ASSUMPTION = new FixedDay(8, 15);
    public static final FixedDay MAYDAY = new FixedDay(5, 1);
    public static final FixedDay ALLSAINTSDAY = new FixedDay(11, 1);
    public static final FixedDay ARMISTICE = new FixedDay(11, 11);
    public static final FixedDay HALLOWEEN = new FixedDay(10, 31);

    public FixedDay(int month, int day) {
        this(month, day, 1.0, ValidityPeriod.ALWAYS);
    }

    public FixedDay(int month, int day, double weight, ValidityPeriod validityPeriod) {
        this.day = day;
        this.month = month;
        this.weight = weight;
        this.validityPeriod = validityPeriod;
    }

    @Override
    public FixedDay reweight(double nweight) {
        if (this.weight == this.weight) {
            return this;
        }
        return new FixedDay(this.month, this.day, nweight, this.validityPeriod);
    }

    @Override
    public FixedDay forPeriod(LocalDate start, LocalDate end) {
        if (this.validityPeriod.getStart().equals(start) && this.validityPeriod.getEnd().equals(end)) {
            return this;
        }
        return new FixedDay(this.month, this.day, this.weight, ValidityPeriod.between(start, end));
    }

    public FixedDay plus(int offset) {
        if (offset == 0) {
            return this;
        }
        int pos = CalendarUtility.getCumulatedMonthDays(this.month - 1) + this.day;
        if ((pos += offset) > 365) {
            pos -= 365;
        } else if (pos <= 0) {
            pos += 365;
        }
        int nmonth = 0;
        while (pos > CalendarUtility.getCumulatedMonthDays(nmonth + 1)) {
            ++nmonth;
        }
        int nday = pos - CalendarUtility.getCumulatedMonthDays(nmonth);
        if (this.month <= 2 && nmonth >= 2) {
            return null;
        }
        return new FixedDay(nmonth + 1, nday, this.weight, this.validityPeriod);
    }

    @Override
    public String display() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.day).append('-').append(this.month);
        return builder.toString();
    }

    @Generated
    public int getMonth() {
        return this.month;
    }

    @Generated
    public int getDay() {
        return this.day;
    }

    @Override
    @Generated
    public double getWeight() {
        return this.weight;
    }

    @Override
    @Generated
    public ValidityPeriod getValidityPeriod() {
        return this.validityPeriod;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixedDay)) {
            return false;
        }
        FixedDay other = (FixedDay)o;
        if (this.getMonth() != other.getMonth()) {
            return false;
        }
        if (this.getDay() != other.getDay()) {
            return false;
        }
        if (Double.compare(this.getWeight(), other.getWeight()) != 0) {
            return false;
        }
        ValidityPeriod this$validityPeriod = this.getValidityPeriod();
        ValidityPeriod other$validityPeriod = other.getValidityPeriod();
        return !(this$validityPeriod == null ? other$validityPeriod != null : !((Object)this$validityPeriod).equals(other$validityPeriod));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMonth();
        result = result * 59 + this.getDay();
        long $weight = Double.doubleToLongBits(this.getWeight());
        result = result * 59 + (int)($weight >>> 32 ^ $weight);
        ValidityPeriod $validityPeriod = this.getValidityPeriod();
        result = result * 59 + ($validityPeriod == null ? 43 : ((Object)$validityPeriod).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "FixedDay(month=" + this.getMonth() + ", day=" + this.getDay() + ", weight=" + this.getWeight() + ", validityPeriod=" + String.valueOf(this.getValidityPeriod()) + ")";
    }
}

