/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.util.Arrays2;
import lombok.Generated;

public final class ComplexUtility {
    private static final Complex[] MROOTS = ComplexUtility.ur(12);
    private static final Complex[] QROOTS = ComplexUtility.ur(4);

    public static Complex[] difference(Complex[] lr, int lrlength, Complex[] rr, int rrlength, double epsilon) {
        boolean[] flags = new boolean[lrlength];
        int rem = 0;
        for (int i = 0; i < rrlength; ++i) {
            for (int j = 0; j < lrlength; ++j) {
                if (flags[j] || !(lr[j].distance(rr[i]) <= epsilon)) continue;
                flags[j] = true;
                ++rem;
            }
        }
        Complex[] remroots = new Complex[lrlength - rem];
        int j = 0;
        for (int i = 0; i < lrlength; ++i) {
            if (flags[i]) continue;
            remroots[j++] = lr[i];
        }
        return remroots;
    }

    public static Complex[] intersection(int lnroots, Complex[] lroots, int rnroots, Complex[] rroots, double epsilon) {
        if (lnroots == 0 || rnroots == 0) {
            return null;
        }
        int croots = 0;
        boolean[] lflags = new boolean[lnroots];
        boolean[] rflags = new boolean[rnroots];
        block0: for (int i = 0; i < lnroots; ++i) {
            for (int j = 0; j < rnroots; ++j) {
                if (rflags[j] || !(lroots[i].distance(rroots[j]) <= epsilon)) continue;
                lflags[i] = true;
                rflags[j] = true;
                ++croots;
                continue block0;
            }
        }
        Complex[] outroots = new Complex[croots];
        int k = 0;
        for (int i = 0; i < lnroots; ++i) {
            if (!lflags[i]) continue;
            outroots[k++] = lroots[i];
        }
        return outroots;
    }

    public static Complex[] union(Complex[] lr, Complex[] rr) {
        if (lr == null) {
            return rr;
        }
        if (rr == null) {
            return lr;
        }
        return ComplexUtility.union(lr, lr.length, rr, rr.length);
    }

    public static Complex[] union(Complex[] lr, int lrlength, Complex[] rr, int rrlength) {
        if (Arrays2.isNullOrEmpty((Object[])lr)) {
            if (Arrays2.isNullOrEmpty((Object[])rr)) {
                return null;
            }
            return (Complex[])Arrays2.copyOf((Object[])rr);
        }
        if (Arrays2.isNullOrEmpty((Object[])rr)) {
            return (Complex[])Arrays2.copyOf((Object[])lr);
        }
        Complex[] rslt = new Complex[lrlength + rrlength];
        System.arraycopy(lr, 0, rslt, 0, lrlength);
        System.arraycopy(rr, 0, rslt, lrlength, rrlength);
        return rslt;
    }

    public static void lejaOrder(Complex[] xin) {
        int i;
        if (xin == null) {
            return;
        }
        int n = xin.length;
        if (n == 0) {
            return;
        }
        double dist = 0.0;
        int m = 0;
        for (i = 0; i < n; ++i) {
            double tmp = xin[i].absSquare();
            if (!(dist < tmp)) continue;
            dist = tmp;
            m = i;
        }
        Arrays2.swap((Object[])xin, (int)0, (int)m);
        for (i = 1; i < n; ++i) {
            dist = 0.0;
            m = i;
            for (int j = i; j < n; ++j) {
                double tmp = 1.0;
                for (int k = 0; k < i; ++k) {
                    double tre = xin[k].getRe() - xin[j].getRe();
                    double tim = xin[k].getIm() - xin[j].getIm();
                    tmp *= tre * tre + tim * tim;
                }
                if (!(dist < tmp)) continue;
                dist = tmp;
                m = j;
            }
            Arrays2.swap((Object[])xin, (int)i, (int)m);
        }
    }

    public static Complex[] roots(Complex c, int nRoots) {
        if (nRoots <= 0) {
            return null;
        }
        Complex[] roots = ComplexUtility.unitRoots(nRoots);
        double arg = c.arg();
        double abs = c.abs();
        double p = 1.0;
        abs = Math.pow(abs, p /= (double)nRoots);
        Complex tmp = Complex.polar((double)abs, (double)(arg *= p));
        for (int i = 0; i < nRoots; ++i) {
            roots[i] = roots[i].times(tmp);
        }
        return roots;
    }

    public static Complex[] unitRoots(int nRoots) {
        if (nRoots <= 0) {
            return null;
        }
        if (nRoots == 4) {
            return (Complex[])QROOTS.clone();
        }
        if (nRoots == 12) {
            return (Complex[])MROOTS.clone();
        }
        return ComplexUtility.ur(nRoots);
    }

    private static Complex[] ur(int nRoots) {
        Complex[] roots = new Complex[nRoots];
        roots[0] = Complex.ONE;
        if (nRoots == 2) {
            roots[1] = Complex.NEG_ONE;
        } else if (nRoots == 4) {
            roots[1] = Complex.I;
            roots[2] = Complex.NEG_ONE;
            roots[3] = Complex.NEG_I;
        } else if (nRoots != 1) {
            double v = Math.PI * 2 / (double)nRoots;
            for (int q = 1; q < nRoots; ++q) {
                double w = v * (double)q;
                roots[q] = Complex.cart((double)Math.cos(w), (double)Math.sin(w));
            }
        }
        return roots;
    }

    @Generated
    private ComplexUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

