/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.nbbrd.io.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.file.Path;
import lombok.Generated;
import lombok.NonNull;
import standalone_spreadsheet.nbbrd.io.BlockSizer;

public final class TextBuffers {
    public static final int DEFAULT_CHAR_BUFFER_SIZE = 8192;
    public static final int IMPL_DEPENDENT_MIN_BUFFER_CAP = -1;
    public static final TextBuffers UNKNOWN = new TextBuffers(-1, -1, -1);
    private final int block;
    private final int bytes;
    private final int chars;

    @NonNull
    public static TextBuffers of(@NonNull Path file, @NonNull CharsetDecoder decoder) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (decoder == null) {
            throw new NullPointerException("decoder is marked non-null but is null");
        }
        return TextBuffers.make(BlockSizer.INSTANCE.get().getBlockSize(file), decoder.averageCharsPerByte());
    }

    @NonNull
    public static TextBuffers of(@NonNull Path file, @NonNull CharsetEncoder encoder) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (encoder == null) {
            throw new NullPointerException("encoder is marked non-null but is null");
        }
        return TextBuffers.make(BlockSizer.INSTANCE.get().getBlockSize(file), 1.0f / encoder.averageBytesPerChar());
    }

    @NonNull
    public static TextBuffers of(@NonNull InputStream stream, @NonNull CharsetDecoder decoder) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        if (decoder == null) {
            throw new NullPointerException("decoder is marked non-null but is null");
        }
        return TextBuffers.make(BlockSizer.INSTANCE.get().getBlockSize(stream), decoder.averageCharsPerByte());
    }

    @NonNull
    public static TextBuffers of(@NonNull OutputStream stream, @NonNull CharsetEncoder encoder) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        if (encoder == null) {
            throw new NullPointerException("encoder is marked non-null but is null");
        }
        return TextBuffers.make(BlockSizer.INSTANCE.get().getBlockSize(stream), 1.0f / encoder.averageBytesPerChar());
    }

    private static TextBuffers make(long blockSize, float averageCharsPerByte) {
        if (blockSize <= 0L || blockSize > Integer.MAX_VALUE) {
            return UNKNOWN;
        }
        int block = (int)blockSize;
        int bytes = TextBuffers.getByteSizeFromBlockSize(block);
        int chars = (int)((float)bytes * averageCharsPerByte);
        return new TextBuffers(block, bytes, chars);
    }

    public int getCharBufferSize() {
        return this.chars > 0 ? this.chars : 8192;
    }

    public int getChannelMinBufferCap() {
        return this.bytes > 0 ? this.bytes : -1;
    }

    @NonNull
    public Reader newCharReader(@NonNull ReadableByteChannel channel, @NonNull CharsetDecoder decoder) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (decoder == null) {
            throw new NullPointerException("decoder is marked non-null but is null");
        }
        return Channels.newReader(channel, decoder, this.getChannelMinBufferCap());
    }

    @NonNull
    public Writer newCharWriter(@NonNull WritableByteChannel channel, @NonNull CharsetEncoder encoder) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (encoder == null) {
            throw new NullPointerException("encoder is marked non-null but is null");
        }
        return Channels.newWriter(channel, encoder, this.getChannelMinBufferCap());
    }

    private static int getByteSizeFromBlockSize(int blockSize) {
        int tmp = TextBuffers.getNextHighestPowerOfTwo(blockSize);
        return tmp == blockSize ? blockSize * 64 : blockSize;
    }

    private static int getNextHighestPowerOfTwo(int val) {
        --val;
        val |= val >> 1;
        val |= val >> 2;
        val |= val >> 4;
        val |= val >> 8;
        val |= val >> 16;
        return val + 1;
    }

    @Generated
    TextBuffers(int block, int bytes, int chars) {
        this.block = block;
        this.bytes = bytes;
        this.chars = chars;
    }
}

