/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.topology.merge;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import usf.saav.topology.TopoTree;
import usf.saav.topology.merge.AbstractMergeTreeNode;

public abstract class AbstractMergeTree
implements TopoTree<AbstractMergeTreeNode> {
    protected AbstractMergeTreeNode head = null;
    protected ArrayList<AbstractMergeTreeNode> grid = new ArrayList();

    public AbstractMergeTreeNode getRoot() {
        return this.head;
    }

    public void savetoDot(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(string);
            printWriter.println(this.toDot());
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public String toString() {
        if (this.head == null) {
            return "<empty>";
        }
        return this.head.toString();
    }

    @Override
    public int size() {
        return this.grid.size();
    }

    @Override
    public float getBirth(int n) {
        return this.grid.get(n).getBirth();
    }

    @Override
    public float getDeath(int n) {
        return this.grid.get(n).getDeath();
    }

    @Override
    public float getPersistence(int n) {
        return this.grid.get(n).getPersistence();
    }

    @Override
    public AbstractMergeTreeNode getNode(int n) {
        return this.grid.get(n);
    }

    public ArrayList<AbstractMergeTreeNode> getAll() {
        return this.grid;
    }

    protected void setParents() {
        for (AbstractMergeTreeNode abstractMergeTreeNode : this.grid) {
            for (AbstractMergeTreeNode abstractMergeTreeNode2 : abstractMergeTreeNode.getChildren()) {
                abstractMergeTreeNode2.setParent(abstractMergeTreeNode);
            }
        }
    }

    @Override
    public void setPersistentSimplification(float f) {
    }

    @Override
    public float getPersistentSimplification() {
        return 0.0f;
    }

    @Override
    public boolean isActive(int n) {
        return true;
    }

    @Override
    public float getMaxPersistence() {
        return 0.0f;
    }

    public String toDot() {
        if (this.head == null) {
            return "Digraph{\n}";
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        this.head.toDot(stringBuffer, stringBuffer2);
        return "Digraph{\n" + String.valueOf(stringBuffer) + String.valueOf(stringBuffer2) + "}";
    }

    public class JNode
    extends AbstractMergeTreeNode {
        private int position;
        private float value;

        public JNode(AbstractMergeTree abstractMergeTree, float f, int n, Object object) {
            super(object);
            this.position = n;
            this.value = f;
        }

        @Override
        public float getValue() {
            return this.value;
        }

        @Override
        public int getID() {
            return this.position;
        }
    }
}

